package CParse::Op::Conditional;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;

use CExpr::Conditional;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $cond = shift;
    my $true = shift;
    my $false = shift;

    my $self = {cond => $cond,
                true => $true,
                false => $false,
               };
    bless $self, $class;
    return $self;
  }

sub args
  {
    my $self = shift;
    return ($self->{cond}, $self->{true}, $self->{false});
  }

sub dump_c
  {
    my $self = shift;
    my $cond = $self->{cond}->dump_c;
    my $true = $self->{true}->dump_c;
    my $false = $self->{false}->dump_c;

    return "($cond ? $true : $false)";
  }

sub get_expr
  {
    my $self = shift;
    my $namespace = shift;

    my $cond = $self->{cond}->get_expr($namespace);
    my $true = $self->{true}->get_expr($namespace);
    my $false = $self->{false}->get_expr($namespace);

    return new CExpr::Conditional $cond, $true, $false;
  }

1;
