/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.util;

import com.sun.tools.doclets.util.Specifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class PathSpecifier {
    protected LinkedList patternList = new LinkedList();
    protected boolean openEnded = false;
    String separator = "";

    public PathSpecifier(String pattern) {
        this.separator = System.getProperty("file.separator");
        LinkedList pList = PathSpecifier.parsePath(pattern);
        this.initPatternList(pList);
    }

    public PathSpecifier(String s, String aSeparator) {
        this.separator = aSeparator;
        LinkedList pList = PathSpecifier.parsePath(s, aSeparator);
        this.initPatternList(pList);
    }

    public PathSpecifier(List pList) {
        this.separator = System.getProperty("file.separator");
        this.initPatternList(pList);
    }

    public PathSpecifier(List pList, String aSeparator) {
        this.separator = aSeparator;
        this.initPatternList(pList);
    }

    public static LinkedList parsePath(String path) {
        return PathSpecifier.parsePath(path, System.getProperty("file.separator"));
    }

    public static LinkedList parsePath(String path, String aSeparator) {
        if (path == null || path.equals("")) {
            return null;
        }
        LinkedList<String> pathList = new LinkedList<String>();
        if (path == null || path.equals("")) {
            pathList.add("*");
            return pathList;
        }
        StringTokenizer st = new StringTokenizer(path, aSeparator);
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            pathList.add(pattern);
        }
        return pathList;
    }

    protected void initPatternList(List pList) {
        LinkedList pLL = new LinkedList(pList);
        Iterator it = pLL.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            if (pattern.equals("?*")) {
                pattern = "*";
            }
            this.patternList.add(new Specifier(pattern));
        }
        String s = (String)pLL.getLast();
        if (s.equals("*")) {
            this.openEnded = true;
        }
    }

    public boolean match(String s) {
        String separator = System.getProperty("file.separator");
        return this.match(s, separator);
    }

    public boolean match(String path, String separator) {
        if (path == null || path.equals("")) {
            return false;
        }
        LinkedList testList = PathSpecifier.parsePath(path, separator);
        return this.match(testList);
    }

    public boolean match(List testList) {
        Iterator plt = this.patternList.iterator();
        Iterator tlt = testList.iterator();
        while (plt.hasNext()) {
            String test;
            Specifier pattern;
            if (!tlt.hasNext()) {
                if (this.openEnded) {
                    pattern = (Specifier)plt.next();
                    if (!plt.hasNext()) {
                        return true;
                    }
                }
                return false;
            }
            pattern = (Specifier)plt.next();
            if (pattern.match(test = (String)tlt.next())) continue;
            return false;
        }
        if (this.openEnded) {
            return true;
        }
        return !tlt.hasNext();
    }

    public String toString() {
        String s = "";
        Iterator pt = this.patternList.iterator();
        while (pt.hasNext()) {
            Specifier pattern = (Specifier)pt.next();
            if (s != "") {
                s = s + this.separator;
            }
            s = s + pattern.toString();
        }
        return s;
    }
}

