---
created: 2020-03-14T00:15:55.000+00:00
source_url: https://www.patreon.com/posts/experimental-in-34246624
---

# Experimental WYSIWYG editor in Joplin

The latest pre-release of Joplin ([v1.0.194](https://github.com/laurent22/joplin/releases/tag/v1.0.194)) includes a new WYSIWYG editor, a prototype for now, but a first step towards integrating this feature into Joplin.

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20200314-001555_0.gif)

WYSIWYG is probably the most requested feature in Joplin - it's the second most up-voted on GitHub, and one of the most viewed and commented on post in the forum.

Please note however that this feature is experimental at this stage - don't use it for important notes as you may lose the content of the note, or it might get corrupted.

If you are interested in this editor though it might make sense to use it for less important notes, so as to evaluate it and report bugs and issues you might find.

This is a technically challenging component because it needs to convert between Markdown and HTML, and vice-versa. Joplin already includes robust HTML-to-MD and MD-to-HTML conversion modules (battle tested respectively in the web clipper and the desktop/mobile client), and this new editor is based on this technology. It is possible however that there are various edge cases that I have not thought of. 

Thus your support to test and validate (or invalidate) this idea would be very much appreciated! If it turns out it does not make sense technically to support this editor, for example if some bugs are critical and can't be solved, it might be removed at a later date, but hopefully all bugs will be fixable. **Please report issues you might find on GitHub,** [**on this post**](https://github.com/laurent22/joplin/issues/176). In there, there's also a list of features that remains to be implemented.

At the moment, the feature is a bit hidden. **To enable it, go into the menu View => Layout button sequence, and choose "Split / WYSIWYG"**. Then click on the Layout button to toggle between modes.

**Missing features**

Some features are missing, most notably the ability to insert plugin blocks such as Katex or Mermaid, so you would have to create them first in the split view. Once created, they can however be edited.

One issue to be aware of, one that cannot be easily fixed, is that **some Markdown plugins are not supported by the editor**. This is because once the Markdown is converted to HTML, and displayed in the WYSIWYG editor, it cannot be converted back to the original Markdown. Some plugins are supported, such as Katex, Fountain or Mermaid. But others are not, like the multi-md table. So if you open a note that contains a multi-md table in the WYSIWYG editor and save, the original multi-md Markdown will be lost, and you'll get back a plain Markdown table.

Again if you find any issue, please report it on GitHub: https://github.com/laurent22/joplin/issues/176 

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20200314-001555_1.gif)