---
created: 2021-01-05T15:30:08.000+00:00
source_url: https://www.patreon.com/posts/joplin-server-is-45843886
---

# Joplin Server pre-release is now available

The first release of Joplin Server is now available as a pre-release:

https://github.com/laurent22/joplin/blob/dev/packages/server/README.md

### What does it sync with?

You will need Joplin v1.6+ clients, which are available as pre-releases for [desktop](https://github.com/laurent22/joplin/releases) and [Android](https://github.com/laurent22/joplin-android/releases).

### What does it do?

At this point, this server allows you to sync any Joplin client with it, as you would do with Dropbox, OneDrive, etc. So in that way, it's not essential. Long term, the goal is to add collaboration features:

- Sharing a note with anyone, using a URL. When the note is changed, the content at the URL is changed too.
- Sharing a notebook with a user on the same Joplin Server instance. For example, if you share a notebook with another user, that user will see this notebook in their desktop or mobile app, and will be able to edit the notes, etc.

### Any improvement over Nextcloud?

For now, one benefit of using Joplin Server, compared to Nextcloud or WebDAV in general, is that it is much faster and resource efficient. I've done a basic test with Nextcloud and Joplin Server running on the same server. Both have mostly default settings (except Nextcloud which uses Redis for file locks):

![](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20210105-153008_0.png)

Why is it so much faster? I assume it's in part because the WebDAV protocol is terribly inefficient. It sends unnecessarily large XML blobs for every request, which are time consuming to download and parse. It also doesn't support delta sync (unlike Joplin Server), which means the complete file list needs to be downloaded before syncing in order to compare the local and remote items.

Finally it's possible that Nextcloud file locking system means an overhead on each request. It shouldn't be much since it's handled by Redis but who knows. Joplin Server doesn't need locking as data consistency is handled by the clients.

So just by following common sense and transferring only the required data in a sane format (JSON), we can have something more performant. In my case, I appreciate that the mobile app no longer freezes when it starts synchronising - before it would do that due to the large XML WebDAV file that needs to be parsed.

### Stability

I've been using it with the desktop and mobile app for a few weeks now and haven't had any issue so far. The server also passes all the existing sync-related test units (sync, e2ee and lock handling) so I'm reasonably confident it can already be used. As always though, keep making backups in case there's any issue.

### Suggestions are welcome

This is still a pre-release and if you notice anything off please let me know. In particular, I believe it doesn't gzip responses, so that will need to be added. The process also doesn't restart when it crashes, which could be solved with pm2.

Also if you have any idea on how to make installation easier, your feedback is welcome.