---
forum_url: https://discourse.joplinapp.org/t/42371
---

# Project 2: Making Joplin more accessible with WCAG-2 compliance

We're always looking for ways to make Joplin better for everyone, and one of the key steps in improving accessibility is implementing the [Web Content Accessibility Guidelines](https://www.w3.org/TR/WCAG20/) (WCAG 2). These guidelines help ensure that our app is usable for all users, including those with disabilities, while also enhancing the overall user experience for everyone.

To get started with WCAG 2 support, we’ll run an accessibility audit with a tool such as [Web Accessibility Evaluation Tools](https://wave.webaim.org) (WAVE). This will help us spot any accessibility issues in the app that we need to address.

Once the audit is complete, we'll take action on the issues we find. Here's a look at some of the things we'll focus on:

- **Making content easier to perceive**: We’ll make sure there are text alternatives for non-text content, provide captions for multimedia, and check that colour contrast is strong enough for easy reading.

- **Improving operability**: Every feature will be accessible through the keyboard, ensuring that users who can't rely on a mouse can still navigate easily.

- **Enhancing comprehension**: We’ll ensure that the text is readable, the layout is predictable, and input assistance is available for those who need it.

We’ll also use ARIA standards and test for compatibility with assistive technologies to make sure everything works well with tools like screen readers.

To ensure we're on the right track, we’ll invite users with disabilities to test the app and help us identify any remaining barriers. Accessibility is something we’ll keep working on, so we'll continue testing, refining, and making improvements to ensure Joplin stays accessible to everyone. It’s a journey, and we’re committed to making the experience better for all our users.

![WCAG 2 logo](https://raw.githubusercontent.com/laurent22/joplin/dev/Assets/WebsiteAssets/images/news/20241207-wcag2.jpg)