/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.AbstractInjectionMonobit;
import com.jsql.model.injection.strategy.blind.callable.CallableBlindBit;
import com.jsql.util.LogLevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import name.fraser.neil.plaintext.diff_match_patch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionBlindBit
extends AbstractInjectionMonobit<CallableBlindBit> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String sourceReferencePage;
    private List<diff_match_patch.Diff> falseDiffs = new ArrayList<diff_match_patch.Diff>();
    private List<diff_match_patch.Diff> trueDiffs = new ArrayList<diff_match_patch.Diff>();

    public InjectionBlindBit(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindMode) {
        super(injectionModel, blindMode);
        if (this.falsyBit.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.sourceReferencePage = this.callUrl("", "bit#ref:" + blindMode.toString().toLowerCase());
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindBitTagFalse");
        ArrayList<CallableBlindBit> callablesFalseTest = new ArrayList<CallableBlindBit>();
        for (String falseTest : this.falsyBit) {
            callablesFalseTest.add(new CallableBlindBit(falseTest, injectionModel, this, blindMode, "bit#falsy"));
        }
        try {
            List futuresFalseTest = taskExecutor.invokeAll(callablesFalseTest);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureFalseTest : futuresFalseTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.falseDiffs.isEmpty()) {
                    this.falseDiffs = ((CallableBlindBit)futureFalseTest.get()).getDiffsWithReference();
                    continue;
                }
                this.falseDiffs.retainAll(((CallableBlindBit)futureFalseTest.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.cleanTrueDiffs(injectionModel, blindMode);
    }

    private void cleanTrueDiffs(InjectionModel injectionModel, AbstractInjectionBit.BlindOperator blindMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindBitTagTrue");
        ArrayList<CallableBlindBit> callablesTrueTest = new ArrayList<CallableBlindBit>();
        for (String trueTest : this.truthyBit) {
            callablesTrueTest.add(new CallableBlindBit(trueTest, injectionModel, this, blindMode, "bit#truthy"));
        }
        try {
            List futuresTrueTest = taskExecutor.invokeAll(callablesTrueTest);
            this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
            for (Future futureTrueTest : futuresTrueTest) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (this.trueDiffs.isEmpty()) {
                    this.trueDiffs = ((CallableBlindBit)futureTrueTest.get()).getDiffsWithReference();
                } else {
                    this.trueDiffs.retainAll(((CallableBlindBit)futureTrueTest.get()).getDiffsWithReference());
                }
                this.falseDiffs.removeAll(((CallableBlindBit)futureTrueTest.get()).getDiffsWithReference());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableBlindBit getCallableBitTest(String sqlQuery, int indexChar, int bit) {
        return new CallableBlindBit(sqlQuery, indexChar, bit, this.injectionModel, this, this.blindOperator, "bit#" + indexChar + "~" + bit);
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableBlindBit blindTest = new CallableBlindBit(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlindConfirm(), this.injectionModel, this, this.blindOperator, "bit#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && this.trueDiffs.stream().anyMatch(diff -> !diff_match_patch.Operation.EQUAL.equals((Object)diff.operation)) || this.falseDiffs.stream().anyMatch(diff -> !diff_match_patch.Operation.EQUAL.equals((Object)diff.operation));
    }

    @Override
    public String getInfoMessage() {
        return "- Strategy Blind bit: query True when Diffs are matching " + this.falseDiffs + "\n\n";
    }

    public String getSourceReferencePage() {
        return this.sourceReferencePage;
    }

    public List<diff_match_patch.Diff> getFalseDiffs() {
        return this.falseDiffs;
    }

    public List<diff_match_patch.Diff> getTrueDiffs() {
        return this.trueDiffs;
    }
}

