/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.util.LogLevelUtil;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18nUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String BASE_NAME = "i18n.jsql";
    public static final ResourceBundle BUNDLE_ROOT = ResourceBundle.getBundle("i18n.jsql", Locale.ROOT);
    private static ResourceBundle currentBundle = ResourceBundle.getBundle("i18n.jsql", Locale.getDefault());

    private I18nUtil() {
    }

    public static String valueByKey(String key) {
        return currentBundle.getString(key.replace(" ", "_"));
    }

    public static void checkCurrentLanguage() {
        URL path = I18nUtil.class.getClassLoader().getResource("i18n/jsql_" + Locale.getDefault().getLanguage() + ".properties");
        if (!"en".equals(Locale.getDefault().getLanguage()) && path == null) {
            String languageHost = Locale.getDefault().getDisplayLanguage(Locale.ENGLISH);
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, () -> String.join((CharSequence)"", "Contribute and translate parts of ", "jSQL Injection", " into ", languageHost, ": ", "click on the top right button and open menu [Community], choose [I help translate jSQL into > another language...] and ", "translate some text into ", languageHost, " then click on [Send]. Your translation will be integrated to the next release by the developer."));
        }
    }

    public static void setCurrentBundle(Locale newLocale) {
        currentBundle = ResourceBundle.getBundle(BASE_NAME, newLocale);
    }

    public static Locale getCurrentLocale() {
        return currentBundle.getLocale();
    }
}

