/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util.bruter;

public class Crc64Helper {
    private static final long POLY64REV = -2882303761517117440L;
    private static final long[] LOOKUPTABLE = new long[256];

    private Crc64Helper() {
    }

    public static String generateCRC64(byte[] data) {
        long sum = 0L;
        for (byte element : data) {
            int lookupidx = ((int)sum ^ element) & 0xFF;
            sum = sum >>> 8 ^ LOOKUPTABLE[lookupidx];
        }
        return String.valueOf(sum);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long v = i;
            for (int j = 0; j < 8; ++j) {
                if ((v & 1L) == 1L) {
                    v = v >>> 1 ^ 0xD800000000000000L;
                    continue;
                }
                v >>>= 1;
            }
            Crc64Helper.LOOKUPTABLE[i] = v;
        }
    }
}

