/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.ManagerAdminPage;
import com.jsql.view.swing.manager.ManagerBruteForce;
import com.jsql.view.swing.manager.ManagerCoder;
import com.jsql.view.swing.manager.ManagerDatabase;
import com.jsql.view.swing.manager.ManagerExploit;
import com.jsql.view.swing.manager.ManagerFile;
import com.jsql.view.swing.manager.ManagerScan;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;

public class TabManagersCards
extends JPanel {
    private final ManagerFile managerFile = new ManagerFile();
    private final ManagerExploit managerExploit = new ManagerExploit();

    public TabManagersCards() {
        this.setName("tabManagersProxy");
        this.setLayout(new CardLayout());
        this.setMinimumSize(new Dimension(100, 0));
        ManagerScan managerScanList = new ManagerScan();
        ManagerDatabase managerDatabase = new ManagerDatabase();
        ManagerAdminPage managerAdminPage = new ManagerAdminPage();
        ManagerBruteForce managerBruteForce = new ManagerBruteForce();
        MediatorHelper.register(this.managerFile);
        MediatorHelper.register(this.managerExploit);
        MediatorHelper.register(managerScanList);
        MediatorHelper.register(managerAdminPage);
        MediatorHelper.register(managerBruteForce);
        List<JPanel> managers = Arrays.asList(managerDatabase, managerAdminPage, this.managerFile, this.managerExploit, managerBruteForce, new ManagerCoder(), managerScanList);
        AtomicInteger i = new AtomicInteger();
        MediatorHelper.frame().getTabManagers().getIconsTabs().forEach(modelSvgIcon -> this.buildI18nTab(modelSvgIcon.getKeyLabel(), (Component)managers.get(i.getAndIncrement())));
        MediatorHelper.register(this);
    }

    public void addToLists(String path, String name) {
        this.managerExploit.addToList(path.replace(name, ""));
    }

    public void markFileSystemInvulnerable() {
        this.getManagers().forEach(manager -> {
            manager.changePrivilegeIcon(UiUtil.CROSS_RED.getIcon());
            manager.endProcess();
        });
    }

    public void endPreparation() {
        this.getManagers().forEach(manager -> manager.setButtonEnable(true));
    }

    public void markFileSystemVulnerable() {
        this.getManagers().forEach(manager -> manager.changePrivilegeIcon(UiUtil.TICK_GREEN.getIcon()));
    }

    private void buildI18nTab(String keyLabel, Component manager) {
        manager.setName(keyLabel);
        this.add(manager, keyLabel);
    }

    private List<AbstractManagerList> getManagers() {
        return Arrays.asList(this.managerFile, this.managerExploit);
    }
}

