/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.vendor.model.yaml.Method;
import com.jsql.model.injection.vendor.model.yaml.Strategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class StrategyError
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String[] tabCapacityMethod;
    private int indexErrorStrategy = 0;

    public StrategyError(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() {
        this.isApplicable = false;
        Strategy strategyYaml = this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy();
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isStrategyErrorDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy [{}] disabled", (Object)this.getName());
            return;
        }
        if (strategyYaml.getError().getMethod().isEmpty()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Strategy [{}] for [{}] not implemented, share a working example to GitHub to speed up release", (Object)this.getName(), (Object)this.injectionModel.getMediatorVendor().getVendor());
            return;
        }
        this.logChecking();
        this.tabCapacityMethod = new String[strategyYaml.getError().getMethod().size()];
        int indexErrorMethod = 0;
        int errorCapacity = 0;
        for (Method errorMethod : strategyYaml.getError().getMethod()) {
            boolean methodIsApplicable = this.isApplicable(errorMethod);
            if (methodIsApplicable) {
                Matcher regexSearch = this.getPerformance(errorMethod);
                if (regexSearch.find()) {
                    errorCapacity = this.getCapacity(indexErrorMethod, errorCapacity, errorMethod, regexSearch);
                } else {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> I18nUtil.valueByKey("LOG_VULNERABLE");
                    supplierArray[1] = errorMethod::getName;
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{} {} but injectable size is incorrect", supplierArray);
                    methodIsApplicable = false;
                }
            }
            if (methodIsApplicable) {
                this.allow(indexErrorMethod);
            } else {
                this.unallow(indexErrorMethod);
            }
            ++indexErrorMethod;
        }
    }

    private boolean isApplicable(Method errorMethod) {
        boolean methodIsApplicable = false;
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlErrorIndice(errorMethod), "error#confirm");
        String indexZeroToFind = "0";
        String regexIndexZero = String.format("1337%s7331", indexZeroToFind);
        if (performanceSourcePage.matches("(?s).*" + regexIndexZero + ".*")) {
            methodIsApplicable = true;
            this.isApplicable = true;
        }
        return methodIsApplicable;
    }

    private Matcher getPerformance(Method errorMethod) {
        String performanceErrorSourcePage = this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlErrorCalibrator(errorMethod), "error#size");
        return Pattern.compile("(?s)SqLi(a+)").matcher(performanceErrorSourcePage);
    }

    private int getCapacity(int indexErrorMethod, int errorCapacityDefault, Method errorMethod, Matcher regexSearch) {
        int errorCapacityImproved = errorCapacityDefault;
        regexSearch.reset();
        while (regexSearch.find()) {
            if (errorCapacityImproved < regexSearch.group(1).length()) {
                this.indexErrorStrategy = indexErrorMethod;
            }
            errorCapacityImproved = regexSearch.group(1).length();
            this.tabCapacityMethod[indexErrorMethod] = Integer.toString(errorCapacityImproved);
        }
        int logErrorCapacityImproved = errorCapacityImproved;
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> I18nUtil.valueByKey("LOG_VULNERABLE");
        supplierArray[1] = errorMethod::getName;
        supplierArray[2] = () -> Integer.toString(logErrorCapacityImproved);
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} [Error {}] showing [{}] characters", supplierArray);
        return errorCapacityImproved;
    }

    @Override
    public void allow(int ... indexError) {
        this.injectionModel.appendAnalysisReport(StringUtil.formatReport(LogLevelUtil.COLOR_BLU, "### Strategy: " + this.getName() + ":" + this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getError().getMethod().get(indexError[0]).getName()) + this.injectionModel.getReportWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlError(StringUtil.formatReport(LogLevelUtil.COLOR_GREEN, "&lt;query&gt;"), "0", indexError[0], true), "metadataInjectionProcess"));
        this.markVulnerability(Interaction.MARK_ERROR_VULNERABLE, indexError[0]);
    }

    @Override
    public void unallow(int ... indexError) {
        this.markVulnerability(Interaction.MARK_ERROR_INVULNERABLE, indexError[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) {
        return this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlError(sqlQuery, startPosition, this.indexErrorStrategy, false), metadataInjectionProcess);
    }

    @Override
    public void activateWhenApplicable() {
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null && this.isApplicable()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{} {}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName, () -> this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getError().getMethod().get(this.indexErrorStrategy).getName());
            this.injectionModel.getMediatorStrategy().setStrategy(this);
            Request request = new Request();
            request.setMessage(Interaction.MARK_ERROR_STRATEGY);
            this.injectionModel.sendToViews(request);
        }
    }

    @Override
    public String getPerformanceLength() {
        return this.tabCapacityMethod[this.indexErrorStrategy];
    }

    @Override
    public String getName() {
        return "Error";
    }

    public Integer getIndexErrorStrategy() {
        return this.indexErrorStrategy;
    }

    public void setIndexErrorStrategy(int indexErrorStrategy) {
        this.indexErrorStrategy = indexErrorStrategy;
    }
}

