/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.action;

import com.jsql.view.swing.action.ActionCloseTabResult;
import com.jsql.view.swing.action.ActionSaveTab;
import com.jsql.view.swing.action.AltKeyEventDispatcher;
import com.jsql.view.swing.menubar.AppMenubar;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.AWTKeyStroke;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class HotkeyUtil {
    private static final String STR_CTRL_TAB = "ctrl TAB";
    private static final String STR_CTRL_SHIFT_TAB = "ctrl shift TAB";
    private static final String STR_SELECT_TAB = "actionString-selectTab";

    private HotkeyUtil() {
    }

    public static void addTextFieldShortcutSelectAll() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", propertyChangeEvent -> {
            Object patt0$temp = propertyChangeEvent.getNewValue();
            if (patt0$temp instanceof JTextField) {
                JTextField textField = (JTextField)patt0$temp;
                SwingUtilities.invokeLater(textField::selectAll);
            }
        });
    }

    public static void addShortcut(JTabbedPane tabbedPane) {
        KeyStroke ctrlTab = KeyStroke.getKeyStroke(STR_CTRL_TAB);
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke(STR_CTRL_SHIFT_TAB);
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(tabbedPane.getFocusTraversalKeys(0));
        forwardKeys.remove(ctrlTab);
        tabbedPane.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(tabbedPane.getFocusTraversalKeys(1));
        backwardKeys.remove(ctrlShiftTab);
        tabbedPane.setFocusTraversalKeys(1, backwardKeys);
        InputMap inputMap = tabbedPane.getInputMap(1);
        inputMap.put(ctrlTab, "navigateNext");
        inputMap.put(ctrlShiftTab, "navigatePrevious");
    }

    public static void addShortcut(JRootPane rootPane, final JTabbedPane valuesTabbedPane) {
        ActionCloseTabResult closeTab = new ActionCloseTabResult();
        AbstractAction nextTab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (valuesTabbedPane.getTabCount() > 0) {
                    int selectedIndex = valuesTabbedPane.getSelectedIndex();
                    if (selectedIndex + 1 < valuesTabbedPane.getTabCount()) {
                        valuesTabbedPane.setSelectedIndex(selectedIndex + 1);
                    } else {
                        valuesTabbedPane.setSelectedIndex(0);
                    }
                }
            }
        };
        AbstractAction previousTab = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (valuesTabbedPane.getTabCount() > 0) {
                    int selectedIndex = valuesTabbedPane.getSelectedIndex();
                    if (selectedIndex - 1 > -1) {
                        valuesTabbedPane.setSelectedIndex(selectedIndex - 1);
                    } else {
                        valuesTabbedPane.setSelectedIndex(valuesTabbedPane.getTabCount() - 1);
                    }
                }
            }
        };
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(rootPane.getFocusTraversalKeys(0));
        forwardKeys.remove(KeyStroke.getKeyStroke(STR_CTRL_TAB));
        rootPane.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(rootPane.getFocusTraversalKeys(1));
        backwardKeys.remove(KeyStroke.getKeyStroke(STR_CTRL_SHIFT_TAB));
        rootPane.setFocusTraversalKeys(1, backwardKeys);
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("ctrl W"), "actionString-closeTab");
        actionMap.put("actionString-closeTab", closeTab);
        inputMap.put(KeyStroke.getKeyStroke(STR_CTRL_TAB), "actionString-nextTab");
        actionMap.put("actionString-nextTab", nextTab);
        inputMap.put(KeyStroke.getKeyStroke(STR_CTRL_SHIFT_TAB), "actionString-previousTab");
        actionMap.put("actionString-previousTab", previousTab);
        int tabCount = MediatorHelper.tabManagersCards().getComponentCount();
        for (int currentTab = 1; currentTab <= tabCount; ++currentTab) {
            inputMap.put(KeyStroke.getKeyStroke("ctrl " + currentTab), STR_SELECT_TAB + currentTab);
            inputMap.put(KeyStroke.getKeyStroke("ctrl NUMPAD" + currentTab), STR_SELECT_TAB + currentTab);
            final int currentTabFinal = currentTab;
            actionMap.put(STR_SELECT_TAB + currentTab, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MediatorHelper.frame().getTabManagers().setSelectedIndex(currentTabFinal - 1);
                }
            });
        }
        inputMap.put(KeyStroke.getKeyStroke("ctrl S"), "actionString-saveTab");
        actionMap.put("actionString-saveTab", new ActionSaveTab());
    }

    public static void addShortcut(AppMenubar appMenubar) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", propertyChangeEvent -> SwingUtilities.invokeLater(() -> {
            if (MediatorHelper.panelAddressBar() != null && MediatorHelper.panelAddressBar().isAdvanceActivated()) {
                appMenubar.setVisible(false);
            }
        }));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new AltKeyEventDispatcher());
    }
}

