/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel.preferences;

import com.jsql.view.swing.panel.PanelPreferences;
import com.jsql.view.swing.panel.preferences.PanelGeneral;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.text.listener.DocumentListenerEditing;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Dimension;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PanelAuthentication
extends JPanel {
    private final JCheckBox checkboxUseDigestAuthentication = new JCheckBox("<html>Enable <b>Basic</b> and <b>NTLM</b> (for <b>Digest</b>: do not enable but just set the user and password):</html>", MediatorHelper.model().getMediatorUtils().authenticationUtil().isAuthentEnabled());
    private final JCheckBox checkboxUseKerberos = new JCheckBox("Enable Kerberos:", MediatorHelper.model().getMediatorUtils().authenticationUtil().isKerberos());
    private final JTextField textDigestAuthenticationUsername = (JTextField)new JPopupTextField("Host system user", MediatorHelper.model().getMediatorUtils().authenticationUtil().getUsernameAuthentication()).getProxy();
    private final JTextField textDigestAuthenticationPassword = (JTextField)new JPopupTextField("Host system password", MediatorHelper.model().getMediatorUtils().authenticationUtil().getPasswordAuthentication()).getProxy();
    private final JTextField textKerberosLoginConf = (JTextField)new JPopupTextField("Path to login.conf", MediatorHelper.model().getMediatorUtils().authenticationUtil().getPathKerberosLogin()).getProxy();
    private final JTextField textKerberosKrb5Conf = (JTextField)new JPopupTextField("Path to krb5.conf", MediatorHelper.model().getMediatorUtils().authenticationUtil().getPathKerberosKrb5()).getProxy();
    private static final String TAG_HTML_ON = "<html>";
    private static final String TAG_HTML_OFF = "</html>";

    public PanelAuthentication(final PanelPreferences panelPreferences) {
        this.checkboxUseDigestAuthentication.setToolTipText("<html>Enable <b>Basic</b>, <b>Digest</b>, <b>NTLM</b> authentication (e.g. WWW-Authenticate).<br>Then define username and password for the host.<br><i><b>Negotiate</b> authentication is defined in URL.</i></html>");
        JPanel panelUsername = new JPanel();
        panelUsername.setLayout(new BoxLayout(panelUsername, 2));
        panelUsername.add(new JLabel("Username "));
        panelUsername.add(this.textDigestAuthenticationUsername);
        panelUsername.setMaximumSize(new Dimension(325, this.textDigestAuthenticationUsername.getPreferredSize().height));
        JPanel panelPassword = new JPanel();
        panelPassword.setLayout(new BoxLayout(panelPassword, 2));
        panelPassword.add(new JLabel("Password "));
        panelPassword.add(this.textDigestAuthenticationPassword);
        panelPassword.setMaximumSize(new Dimension(325, this.textDigestAuthenticationPassword.getPreferredSize().height));
        panelPassword.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        String tooltipUseKerberos = "<html>Enable Kerberos authentication, then define path to <b>login.conf</b> and <b>krb5.conf</b>.<br>Path to <b>.keytab</b> file is defined in login.conf ; name of <b>principal</b> must be correct.<br><b>Realm</b> and <b>kdc</b> are defined in krb5.conf.<br>Finally use the <b>correct hostname</b> in URL, e.g. http://servicename.corp.test/[..]</html>";
        this.textKerberosLoginConf.setToolTipText("<html>Define the path to <b>login.conf</b>. Sample:<br>&emsp;<b>entry-name</b> {<br>&emsp;&emsp;com.sun.security.auth.module.Krb5LoginModule<br>&emsp;&emsp;required<br>&emsp;&emsp;useKeyTab=true<br>&emsp;&emsp;keyTab=\"<b>/path/to/my.keytab</b>\"<br>&emsp;&emsp;principal=\"<b>HTTP/SERVICENAME.CORP.TEST@CORP.TEST</b>\"<br>&emsp;&emsp;debug=false;<br>&emsp;}<br><i>Principal name is case sensitive ; entry-name is read automatically.</i></html>");
        this.textKerberosKrb5Conf.setToolTipText("<html>Define the path to <b>krb5.conf</b>. Sample:<br>&emsp;[libdefaults]<br>&emsp;&emsp;default_realm = <b>CORP.TEST</b><br>&emsp;&emsp;udp_preference_limit = 1<br>&emsp;[realms]<br>&emsp;&emsp;<b>CORP.TEST</b> = {<br>&emsp;&emsp;&emsp;kdc = <b>127.0.0.1:88</b><br>&emsp;&emsp;}<br><i>Realm and kdc are case sensitives.</i></html>");
        this.checkboxUseKerberos.setToolTipText(tooltipUseKerberos);
        JPanel panelLoginConf = new JPanel();
        panelLoginConf.setLayout(new BoxLayout(panelLoginConf, 2));
        panelLoginConf.add(new JLabel("login.conf "));
        panelLoginConf.add(this.textKerberosLoginConf);
        panelLoginConf.setMaximumSize(new Dimension(325, this.textKerberosLoginConf.getPreferredSize().height));
        JPanel panelKrb5Conf = new JPanel();
        panelKrb5Conf.setLayout(new BoxLayout(panelKrb5Conf, 2));
        panelKrb5Conf.add(new JLabel("krb5.conf "));
        panelKrb5Conf.add(this.textKerberosKrb5Conf);
        panelKrb5Conf.setMaximumSize(new Dimension(325, this.textKerberosKrb5Conf.getPreferredSize().height));
        Stream.of(this.checkboxUseDigestAuthentication, this.checkboxUseKerberos).forEach(button -> button.addActionListener(panelPreferences.getActionListenerSave()));
        DocumentListenerEditing documentListenerSave = new DocumentListenerEditing(this){

            @Override
            public void process() {
                panelPreferences.getActionListenerSave().actionPerformed(null);
            }
        };
        Stream.of(this.textDigestAuthenticationPassword, this.textDigestAuthenticationUsername, this.textKerberosKrb5Conf, this.textKerberosLoginConf).forEach(textField -> textField.getDocument().addDocumentListener(documentListenerSave));
        JLabel labelOrigin = new JLabel("<html><b>Network secured connection</b></html>");
        labelOrigin.setBorder(PanelGeneral.MARGIN);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(labelOrigin).addComponent(this.checkboxUseDigestAuthentication).addComponent(panelUsername).addComponent(panelPassword).addComponent(this.checkboxUseKerberos).addComponent(panelLoginConf).addComponent(panelKrb5Conf)));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelOrigin)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkboxUseDigestAuthentication)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(panelUsername)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(panelPassword)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkboxUseKerberos)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(panelLoginConf)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(panelKrb5Conf)));
    }

    public JCheckBox getCheckboxUseDigestAuthentication() {
        return this.checkboxUseDigestAuthentication;
    }

    public JTextField getTextDigestAuthenticationUsername() {
        return this.textDigestAuthenticationUsername;
    }

    public JTextField getTextDigestAuthenticationPassword() {
        return this.textDigestAuthenticationPassword;
    }

    public JCheckBox getCheckboxUseKerberos() {
        return this.checkboxUseKerberos;
    }

    public JTextField getTextKerberosKrb5Conf() {
        return this.textKerberosKrb5Conf;
    }

    public JTextField getTextKerberosLoginConf() {
        return this.textKerberosLoginConf;
    }
}

