
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImage.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QImage>
#include <QColor>
#include <QIODevice>
#include <QMatrix>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPainter>
#include <QPixelFormat>
#include <QPoint>
#include <QRect>
#include <QSize>
#include <QTransform>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImage

// bool QImage::allGray()


static void _init_f_allGray_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_allGray_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImage *)cls)->allGray ());
}


// QImage QImage::alphaChannel()


static void _init_f_alphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_alphaChannel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImage > ((QImage)((QImage *)cls)->alphaChannel ());
}


// int QImage::bitPlaneCount()


static void _init_f_bitPlaneCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bitPlaneCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->bitPlaneCount ());
}


// const unsigned char *QImage::bits()


static void _init_f_bits_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const unsigned char * > ();
}

static void _call_f_bits_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const unsigned char * > ((const unsigned char *)((QImage *)cls)->bits ());
}


// int QImage::byteCount()


static void _init_f_byteCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_byteCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->byteCount ());
}


// int QImage::bytesPerLine()


static void _init_f_bytesPerLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bytesPerLine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->bytesPerLine ());
}


// qint64 QImage::cacheKey()


static void _init_f_cacheKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_cacheKey_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QImage *)cls)->cacheKey ());
}


// unsigned int QImage::color(int i)


static void _init_f_color_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_color_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<unsigned int > ((unsigned int)((QImage *)cls)->color (arg1));
}


// int QImage::colorCount()


static void _init_f_colorCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_colorCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->colorCount ());
}


// QVector<QRgb> QImage::colorTable()


static void _init_f_colorTable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector<QRgb> > ();
}

static void _call_f_colorTable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector<QRgb> > ((QVector<QRgb>)((QImage *)cls)->colorTable ());
}


// const unsigned char *QImage::constBits()


static void _init_f_constBits_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const unsigned char * > ();
}

static void _call_f_constBits_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<const unsigned char * > ((const unsigned char *)((QImage *)cls)->constBits ());
}


// const unsigned char *QImage::constScanLine(int)


static void _init_f_constScanLine_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const unsigned char * > ();
}

static void _call_f_constScanLine_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<const unsigned char * > ((const unsigned char *)((QImage *)cls)->constScanLine (arg1));
}


// QImage QImage::convertToFormat(QImage::Format f, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_convertToFormat_cr4993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_convertToFormat_cr4993 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->convertToFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref(), arg2));
}


// QImage QImage::convertToFormat(QImage::Format f, const QVector<QRgb> &colorTable, QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_convertToFormat_c7392 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("colorTable");
  decl->add_arg<const QVector<QRgb> & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_convertToFormat_c7392 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  const QVector<QRgb> &arg2 = gsi::arg_reader<const QVector<QRgb> & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg3 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->convertToFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref(), arg2, arg3));
}


// QImage QImage::copy(const QRect &rect)


static void _init_f_copy_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QImage > ();
}

static void _call_f_copy_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args ? gsi::arg_reader<const QRect & >() (args, heap) : gsi::arg_maker<const QRect & >() (QRect(), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->copy (arg1));
}


// QImage QImage::copy(int x, int y, int w, int h)


static void _init_f_copy_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QImage > ();
}

static void _call_f_copy_c2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->copy (arg1, arg2, arg3, arg4));
}


// QImage QImage::createAlphaMask(QFlags<Qt::ImageConversionFlag> flags)


static void _init_f_createAlphaMask_c3368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "Qt::AutoColor");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_0);
  decl->set_return<QImage > ();
}

static void _call_f_createAlphaMask_c3368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::ImageConversionFlag> arg1 = args ? gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap) : gsi::arg_maker<QFlags<Qt::ImageConversionFlag> >() (Qt::AutoColor, heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->createAlphaMask (arg1));
}


// QImage QImage::createHeuristicMask(bool clipTight)


static void _init_f_createHeuristicMask_c864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clipTight", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<QImage > ();
}

static void _call_f_createHeuristicMask_c864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->createHeuristicMask (arg1));
}


// QImage QImage::createMaskFromColor(unsigned int color, Qt::MaskMode mode)


static void _init_f_createMaskFromColor_c3198 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::MaskInColor");
  decl->add_arg<const qt_gsi::Converter<Qt::MaskMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_createMaskFromColor_c3198 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  const qt_gsi::Converter<Qt::MaskMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::MaskMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::MaskMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::MaskMode>(heap, Qt::MaskInColor), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->createMaskFromColor (arg1, qt_gsi::QtToCppAdaptor<Qt::MaskMode>(arg2).cref()));
}


// int QImage::depth()


static void _init_f_depth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_depth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->depth ());
}


// void QImage::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->detach ();
}


// double QImage::devicePixelRatio()


static void _init_f_devicePixelRatio_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_devicePixelRatio_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QImage *)cls)->devicePixelRatio ());
}


// int QImage::dotsPerMeterX()


static void _init_f_dotsPerMeterX_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dotsPerMeterX_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->dotsPerMeterX ());
}


// int QImage::dotsPerMeterY()


static void _init_f_dotsPerMeterY_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dotsPerMeterY_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->dotsPerMeterY ());
}


// void QImage::fill(unsigned int pixel)


static void _init_f_fill_1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixel");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->fill (arg1);
}


// void QImage::fill(const QColor &color)


static void _init_f_fill_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->fill (arg1);
}


// void QImage::fill(Qt::GlobalColor color)


static void _init_f_fill_1853 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const qt_gsi::Converter<Qt::GlobalColor>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_fill_1853 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::GlobalColor>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::GlobalColor>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->fill (qt_gsi::QtToCppAdaptor<Qt::GlobalColor>(arg1).cref());
}


// QImage::Format QImage::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImage::Format>::target_type > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QImage::Format>::target_type > ((qt_gsi::Converter<QImage::Format>::target_type)qt_gsi::CppToQtAdaptor<QImage::Format>(((QImage *)cls)->format ()));
}


// bool QImage::hasAlphaChannel()


static void _init_f_hasAlphaChannel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlphaChannel_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImage *)cls)->hasAlphaChannel ());
}


// int QImage::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->height ());
}


// void QImage::invertPixels(QImage::InvertMode)


static void _init_f_invertPixels_2137 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "QImage::InvertRgb");
  decl->add_arg<const qt_gsi::Converter<QImage::InvertMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_invertPixels_2137 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::InvertMode>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<QImage::InvertMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QImage::InvertMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QImage::InvertMode>(heap, QImage::InvertRgb), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->invertPixels (qt_gsi::QtToCppAdaptor<QImage::InvertMode>(arg1).cref());
}


// bool QImage::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImage *)cls)->isDetached ());
}


// bool QImage::isGrayscale()


static void _init_f_isGrayscale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isGrayscale_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImage *)cls)->isGrayscale ());
}


// bool QImage::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImage *)cls)->isNull ());
}


// bool QImage::load(QIODevice *device, const char *format)


static void _init_f_load_3070 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_load_3070 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<bool > ((bool)((QImage *)cls)->load (arg1, arg2));
}


// bool QImage::load(const QString &fileName, const char *format)


static void _init_f_load_3648 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_load_3648 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<bool > ((bool)((QImage *)cls)->load (arg1, arg2));
}


// bool QImage::loadFromData(const unsigned char *buf, int len, const char *format)


static void _init_f_loadFromData_5018 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buf");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_5018 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const unsigned char *arg1 = gsi::arg_reader<const unsigned char * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const char *arg3 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<bool > ((bool)((QImage *)cls)->loadFromData (arg1, arg2, arg3));
}


// bool QImage::loadFromData(const QByteArray &data, const char *aformat)


static void _init_f_loadFromData_3932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aformat", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_loadFromData_3932 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<bool > ((bool)((QImage *)cls)->loadFromData (arg1, arg2));
}


// QImage QImage::mirrored(bool horizontally, bool vertically)


static void _init_f_mirrored_cr1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("horizontally", true, "false");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vertically", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_mirrored_cr1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (false, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->mirrored (arg1, arg2));
}


// QPoint QImage::offset()


static void _init_f_offset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_offset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QImage *)cls)->offset ());
}


// bool QImage::operator!=(const QImage &)


static void _init_f_operator_excl__eq__c1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  ret.write<bool > ((bool)((QImage *)cls)->operator!= (arg1));
}


// QImage &QImage::operator=(const QImage &)


static void _init_f_operator_eq__1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<QImage & > ();
}

static void _call_f_operator_eq__1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  ret.write<QImage & > ((QImage &)((QImage *)cls)->operator= (arg1));
}


// bool QImage::operator==(const QImage &)


static void _init_f_operator_eq__eq__c1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  ret.write<bool > ((bool)((QImage *)cls)->operator== (arg1));
}


// QPaintEngine *QImage::paintEngine()


static void _init_f_paintEngine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_f_paintEngine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QImage *)cls)->paintEngine ());
}


// unsigned int QImage::pixel(int x, int y)


static void _init_f_pixel_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<unsigned int > ();
}

static void _call_f_pixel_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<unsigned int > ((unsigned int)((QImage *)cls)->pixel (arg1, arg2));
}


// unsigned int QImage::pixel(const QPoint &pt)


static void _init_f_pixel_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_pixel_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<unsigned int > ((unsigned int)((QImage *)cls)->pixel (arg1));
}


// QColor QImage::pixelColor(int x, int y)


static void _init_f_pixelColor_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QColor > ();
}

static void _call_f_pixelColor_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QColor > ((QColor)((QImage *)cls)->pixelColor (arg1, arg2));
}


// QColor QImage::pixelColor(const QPoint &pt)


static void _init_f_pixelColor_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QColor > ();
}

static void _call_f_pixelColor_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QColor > ((QColor)((QImage *)cls)->pixelColor (arg1));
}


// QPixelFormat QImage::pixelFormat()


static void _init_f_pixelFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPixelFormat > ();
}

static void _call_f_pixelFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPixelFormat > ((QPixelFormat)((QImage *)cls)->pixelFormat ());
}


// int QImage::pixelIndex(int x, int y)


static void _init_f_pixelIndex_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_pixelIndex_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QImage *)cls)->pixelIndex (arg1, arg2));
}


// int QImage::pixelIndex(const QPoint &pt)


static void _init_f_pixelIndex_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_pixelIndex_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<int > ((int)((QImage *)cls)->pixelIndex (arg1));
}


// QRect QImage::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QImage *)cls)->rect ());
}


// bool QImage::reinterpretAsFormat(QImage::Format f)


static void _init_f_reinterpretAsFormat_1733 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_reinterpretAsFormat_1733 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QImage *)cls)->reinterpretAsFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref()));
}


// QImage QImage::rgbSwapped()


static void _init_f_rgbSwapped_cr0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_f_rgbSwapped_cr0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImage > ((QImage)((QImage *)cls)->rgbSwapped ());
}


// bool QImage::save(const QString &fileName, const char *format, int quality)


static void _init_f_save_c4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c4307 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<bool > ((bool)((QImage *)cls)->save (arg1, arg2, arg3));
}


// bool QImage::save(QIODevice *device, const char *format, int quality)


static void _init_f_save_c3729 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("quality", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_save_c3729 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<bool > ((bool)((QImage *)cls)->save (arg1, arg2, arg3));
}


// QImage QImage::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6100 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_3);
  decl->set_return<QImage > ();
}

static void _call_f_scaled_c6100 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg4 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->scaled (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg3).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg4).cref()));
}


// QImage QImage::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)


static void _init_f_scaled_c6479 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_scaled_c6479 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio), heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->scaled (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref(), qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg3).cref()));
}


// QImage QImage::scaledToHeight(int h, Qt::TransformationMode mode)


static void _init_f_scaledToHeight_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_scaledToHeight_c3292 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->scaledToHeight (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// QImage QImage::scaledToWidth(int w, Qt::TransformationMode mode)


static void _init_f_scaledToWidth_c3292 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_scaledToWidth_c3292 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->scaledToWidth (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// const unsigned char *QImage::scanLine(int)


static void _init_f_scanLine_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const unsigned char * > ();
}

static void _call_f_scanLine_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<const unsigned char * > ((const unsigned char *)((QImage *)cls)->scanLine (arg1));
}


// void QImage::setAlphaChannel(const QImage &alphaChannel)


static void _init_f_setAlphaChannel_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alphaChannel");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlphaChannel_1877 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setAlphaChannel (arg1);
}


// void QImage::setColor(int i, unsigned int c)


static void _init_f_setColor_2431 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<unsigned int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColor_2431 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  unsigned int arg2 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setColor (arg1, arg2);
}


// void QImage::setColorCount(int)


static void _init_f_setColorCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setColorCount (arg1);
}


// void QImage::setColorTable(const QVector<QRgb> colors)


static void _init_f_setColorTable_2325 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("colors");
  decl->add_arg<const QVector<QRgb> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorTable_2325 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<QRgb> arg1 = gsi::arg_reader<const QVector<QRgb> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setColorTable (arg1);
}


// void QImage::setDevicePixelRatio(double scaleFactor)


static void _init_f_setDevicePixelRatio_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scaleFactor");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevicePixelRatio_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setDevicePixelRatio (arg1);
}


// void QImage::setDotsPerMeterX(int)


static void _init_f_setDotsPerMeterX_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDotsPerMeterX_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setDotsPerMeterX (arg1);
}


// void QImage::setDotsPerMeterY(int)


static void _init_f_setDotsPerMeterY_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDotsPerMeterY_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setDotsPerMeterY (arg1);
}


// void QImage::setOffset(const QPoint &)


static void _init_f_setOffset_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffset_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setOffset (arg1);
}


// void QImage::setPixel(int x, int y, unsigned int index_or_rgb)


static void _init_f_setPixel_3090 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index_or_rgb");
  decl->add_arg<unsigned int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPixel_3090 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  unsigned int arg3 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setPixel (arg1, arg2, arg3);
}


// void QImage::setPixel(const QPoint &pt, unsigned int index_or_rgb)


static void _init_f_setPixel_3580 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index_or_rgb");
  decl->add_arg<unsigned int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPixel_3580 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  unsigned int arg2 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setPixel (arg1, arg2);
}


// void QImage::setPixelColor(int x, int y, const QColor &c)


static void _init_f_setPixelColor_3223 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("c");
  decl->add_arg<const QColor & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPixelColor_3223 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const QColor &arg3 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setPixelColor (arg1, arg2, arg3);
}


// void QImage::setPixelColor(const QPoint &pt, const QColor &c)


static void _init_f_setPixelColor_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const QColor & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPixelColor_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  const QColor &arg2 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setPixelColor (arg1, arg2);
}


// void QImage::setText(const QString &key, const QString &value)


static void _init_f_setText_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setText_3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->setText (arg1, arg2);
}


// QSize QImage::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QImage *)cls)->size ());
}


// qsizetype QImage::sizeInBytes()


static void _init_f_sizeInBytes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qsizetype > ();
}

static void _call_f_sizeInBytes_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qsizetype > ((qsizetype)((QImage *)cls)->sizeInBytes ());
}


// void QImage::swap(QImage &other)


static void _init_f_swap_1182 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QImage & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1182 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QImage &arg1 = gsi::arg_reader<QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage *)cls)->swap (arg1);
}


// QStringList QImage::textKeys()


static void _init_f_textKeys_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_textKeys_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QImage *)cls)->textKeys ());
}


// QImage QImage::transformed(const QMatrix &matrix, Qt::TransformationMode mode)


static void _init_f_transformed_c4548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_transformed_c4548 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMatrix &arg1 = gsi::arg_reader<const QMatrix & >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// QImage QImage::transformed(const QTransform &matrix, Qt::TransformationMode mode)


static void _init_f_transformed_c4875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::FastTransformation");
  decl->add_arg<const qt_gsi::Converter<Qt::TransformationMode>::target_type & > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_transformed_c4875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  const qt_gsi::Converter<Qt::TransformationMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TransformationMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TransformationMode>(heap, Qt::FastTransformation), heap);
  ret.write<QImage > ((QImage)((QImage *)cls)->transformed (arg1, qt_gsi::QtToCppAdaptor<Qt::TransformationMode>(arg2).cref()));
}


// bool QImage::valid(int x, int y)


static void _init_f_valid_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_valid_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QImage *)cls)->valid (arg1, arg2));
}


// bool QImage::valid(const QPoint &pt)


static void _init_f_valid_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_valid_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<bool > ((bool)((QImage *)cls)->valid (arg1));
}


// int QImage::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImage *)cls)->width ());
}


// static QImage QImage::fromData(const unsigned char *data, int size, const char *format)


static void _init_f_fromData_5018 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_fromData_5018 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const unsigned char *arg1 = gsi::arg_reader<const unsigned char * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const char *arg3 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<QImage > ((QImage)QImage::fromData (arg1, arg2, arg3));
}


// static QImage QImage::fromData(const QByteArray &data, const char *format)


static void _init_f_fromData_3932 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_f_fromData_3932 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<QImage > ((QImage)QImage::fromData (arg1, arg2));
}


// static QImage::Format QImage::toImageFormat(QPixelFormat format)


static void _init_f_toImageFormat_1648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<QPixelFormat > (argspec_0);
  decl->set_return<qt_gsi::Converter<QImage::Format>::target_type > ();
}

static void _call_f_toImageFormat_1648 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPixelFormat arg1 = gsi::arg_reader<QPixelFormat >() (args, heap);
  ret.write<qt_gsi::Converter<QImage::Format>::target_type > ((qt_gsi::Converter<QImage::Format>::target_type)qt_gsi::CppToQtAdaptor<QImage::Format>(QImage::toImageFormat (arg1)));
}


// static QPixelFormat QImage::toPixelFormat(QImage::Format format)


static void _init_f_toPixelFormat_1733 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  decl->set_return<QPixelFormat > ();
}

static void _call_f_toPixelFormat_1733 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  ret.write<QPixelFormat > ((QPixelFormat)QImage::toPixelFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref()));
}


// static QMatrix QImage::trueMatrix(const QMatrix &, int w, int h)


static void _init_f_trueMatrix_3341 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QMatrix > ();
}

static void _call_f_trueMatrix_3341 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMatrix &arg1 = gsi::arg_reader<const QMatrix & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QMatrix > ((QMatrix)QImage::trueMatrix (arg1, arg2, arg3));
}


// static QTransform QImage::trueMatrix(const QTransform &, int w, int h)


static void _init_f_trueMatrix_3668 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("w");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("h");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QTransform > ();
}

static void _call_f_trueMatrix_3668 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTransform &arg1 = gsi::arg_reader<const QTransform & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QTransform > ((QTransform)QImage::trueMatrix (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QImage () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("allGray", "@brief Method bool QImage::allGray()\n", true, &_init_f_allGray_c0, &_call_f_allGray_c0);
  methods += new qt_gsi::GenericMethod (":alphaChannel", "@brief Method QImage QImage::alphaChannel()\n", true, &_init_f_alphaChannel_c0, &_call_f_alphaChannel_c0);
  methods += new qt_gsi::GenericMethod ("bitPlaneCount", "@brief Method int QImage::bitPlaneCount()\n", true, &_init_f_bitPlaneCount_c0, &_call_f_bitPlaneCount_c0);
  methods += new qt_gsi::GenericMethod ("bits", "@brief Method const unsigned char *QImage::bits()\n", true, &_init_f_bits_c0, &_call_f_bits_c0);
  methods += new qt_gsi::GenericMethod ("byteCount", "@brief Method int QImage::byteCount()\n", true, &_init_f_byteCount_c0, &_call_f_byteCount_c0);
  methods += new qt_gsi::GenericMethod ("bytesPerLine", "@brief Method int QImage::bytesPerLine()\n", true, &_init_f_bytesPerLine_c0, &_call_f_bytesPerLine_c0);
  methods += new qt_gsi::GenericMethod ("cacheKey", "@brief Method qint64 QImage::cacheKey()\n", true, &_init_f_cacheKey_c0, &_call_f_cacheKey_c0);
  methods += new qt_gsi::GenericMethod ("color", "@brief Method unsigned int QImage::color(int i)\n", true, &_init_f_color_c767, &_call_f_color_c767);
  methods += new qt_gsi::GenericMethod (":colorCount", "@brief Method int QImage::colorCount()\n", true, &_init_f_colorCount_c0, &_call_f_colorCount_c0);
  methods += new qt_gsi::GenericMethod ("colorTable", "@brief Method QVector<QRgb> QImage::colorTable()\n", true, &_init_f_colorTable_c0, &_call_f_colorTable_c0);
  methods += new qt_gsi::GenericMethod ("constBits", "@brief Method const unsigned char *QImage::constBits()\n", true, &_init_f_constBits_c0, &_call_f_constBits_c0);
  methods += new qt_gsi::GenericMethod ("constScanLine", "@brief Method const unsigned char *QImage::constScanLine(int)\n", true, &_init_f_constScanLine_c767, &_call_f_constScanLine_c767);
  methods += new qt_gsi::GenericMethod ("convertToFormat", "@brief Method QImage QImage::convertToFormat(QImage::Format f, QFlags<Qt::ImageConversionFlag> flags)\n", true, &_init_f_convertToFormat_cr4993, &_call_f_convertToFormat_cr4993);
  methods += new qt_gsi::GenericMethod ("convertToFormat", "@brief Method QImage QImage::convertToFormat(QImage::Format f, const QVector<QRgb> &colorTable, QFlags<Qt::ImageConversionFlag> flags)\n", true, &_init_f_convertToFormat_c7392, &_call_f_convertToFormat_c7392);
  methods += new qt_gsi::GenericMethod ("copy", "@brief Method QImage QImage::copy(const QRect &rect)\n", true, &_init_f_copy_c1792, &_call_f_copy_c1792);
  methods += new qt_gsi::GenericMethod ("copy", "@brief Method QImage QImage::copy(int x, int y, int w, int h)\n", true, &_init_f_copy_c2744, &_call_f_copy_c2744);
  methods += new qt_gsi::GenericMethod ("createAlphaMask", "@brief Method QImage QImage::createAlphaMask(QFlags<Qt::ImageConversionFlag> flags)\n", true, &_init_f_createAlphaMask_c3368, &_call_f_createAlphaMask_c3368);
  methods += new qt_gsi::GenericMethod ("createHeuristicMask", "@brief Method QImage QImage::createHeuristicMask(bool clipTight)\n", true, &_init_f_createHeuristicMask_c864, &_call_f_createHeuristicMask_c864);
  methods += new qt_gsi::GenericMethod ("createMaskFromColor", "@brief Method QImage QImage::createMaskFromColor(unsigned int color, Qt::MaskMode mode)\n", true, &_init_f_createMaskFromColor_c3198, &_call_f_createMaskFromColor_c3198);
  methods += new qt_gsi::GenericMethod ("depth", "@brief Method int QImage::depth()\n", true, &_init_f_depth_c0, &_call_f_depth_c0);
  methods += new qt_gsi::GenericMethod ("detach", "@brief Method void QImage::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
  methods += new qt_gsi::GenericMethod (":devicePixelRatio", "@brief Method double QImage::devicePixelRatio()\n", true, &_init_f_devicePixelRatio_c0, &_call_f_devicePixelRatio_c0);
  methods += new qt_gsi::GenericMethod (":dotsPerMeterX", "@brief Method int QImage::dotsPerMeterX()\n", true, &_init_f_dotsPerMeterX_c0, &_call_f_dotsPerMeterX_c0);
  methods += new qt_gsi::GenericMethod (":dotsPerMeterY", "@brief Method int QImage::dotsPerMeterY()\n", true, &_init_f_dotsPerMeterY_c0, &_call_f_dotsPerMeterY_c0);
  methods += new qt_gsi::GenericMethod ("fill", "@brief Method void QImage::fill(unsigned int pixel)\n", false, &_init_f_fill_1772, &_call_f_fill_1772);
  methods += new qt_gsi::GenericMethod ("fill", "@brief Method void QImage::fill(const QColor &color)\n", false, &_init_f_fill_1905, &_call_f_fill_1905);
  methods += new qt_gsi::GenericMethod ("fill", "@brief Method void QImage::fill(Qt::GlobalColor color)\n", false, &_init_f_fill_1853, &_call_f_fill_1853);
  methods += new qt_gsi::GenericMethod ("format", "@brief Method QImage::Format QImage::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("hasAlphaChannel", "@brief Method bool QImage::hasAlphaChannel()\n", true, &_init_f_hasAlphaChannel_c0, &_call_f_hasAlphaChannel_c0);
  methods += new qt_gsi::GenericMethod ("height", "@brief Method int QImage::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("invertPixels", "@brief Method void QImage::invertPixels(QImage::InvertMode)\n", false, &_init_f_invertPixels_2137, &_call_f_invertPixels_2137);
  methods += new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QImage::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
  methods += new qt_gsi::GenericMethod ("isGrayscale?", "@brief Method bool QImage::isGrayscale()\n", true, &_init_f_isGrayscale_c0, &_call_f_isGrayscale_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QImage::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QImage::load(QIODevice *device, const char *format)\n", false, &_init_f_load_3070, &_call_f_load_3070);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QImage::load(const QString &fileName, const char *format)\n", false, &_init_f_load_3648, &_call_f_load_3648);
  methods += new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QImage::loadFromData(const unsigned char *buf, int len, const char *format)\n", false, &_init_f_loadFromData_5018, &_call_f_loadFromData_5018);
  methods += new qt_gsi::GenericMethod ("loadFromData", "@brief Method bool QImage::loadFromData(const QByteArray &data, const char *aformat)\n", false, &_init_f_loadFromData_3932, &_call_f_loadFromData_3932);
  methods += new qt_gsi::GenericMethod ("mirrored", "@brief Method QImage QImage::mirrored(bool horizontally, bool vertically)\n", true, &_init_f_mirrored_cr1620, &_call_f_mirrored_cr1620);
  methods += new qt_gsi::GenericMethod (":offset", "@brief Method QPoint QImage::offset()\n", true, &_init_f_offset_c0, &_call_f_offset_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QImage::operator!=(const QImage &)\n", true, &_init_f_operator_excl__eq__c1877, &_call_f_operator_excl__eq__c1877);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QImage &QImage::operator=(const QImage &)\n", false, &_init_f_operator_eq__1877, &_call_f_operator_eq__1877);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QImage::operator==(const QImage &)\n", true, &_init_f_operator_eq__eq__c1877, &_call_f_operator_eq__eq__c1877);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Method QPaintEngine *QImage::paintEngine()\nThis is a reimplementation of QPaintDevice::paintEngine", true, &_init_f_paintEngine_c0, &_call_f_paintEngine_c0);
  methods += new qt_gsi::GenericMethod ("pixel", "@brief Method unsigned int QImage::pixel(int x, int y)\n", true, &_init_f_pixel_c1426, &_call_f_pixel_c1426);
  methods += new qt_gsi::GenericMethod ("pixel", "@brief Method unsigned int QImage::pixel(const QPoint &pt)\n", true, &_init_f_pixel_c1916, &_call_f_pixel_c1916);
  methods += new qt_gsi::GenericMethod ("pixelColor", "@brief Method QColor QImage::pixelColor(int x, int y)\n", true, &_init_f_pixelColor_c1426, &_call_f_pixelColor_c1426);
  methods += new qt_gsi::GenericMethod ("pixelColor", "@brief Method QColor QImage::pixelColor(const QPoint &pt)\n", true, &_init_f_pixelColor_c1916, &_call_f_pixelColor_c1916);
  methods += new qt_gsi::GenericMethod ("pixelFormat", "@brief Method QPixelFormat QImage::pixelFormat()\n", true, &_init_f_pixelFormat_c0, &_call_f_pixelFormat_c0);
  methods += new qt_gsi::GenericMethod ("pixelIndex", "@brief Method int QImage::pixelIndex(int x, int y)\n", true, &_init_f_pixelIndex_c1426, &_call_f_pixelIndex_c1426);
  methods += new qt_gsi::GenericMethod ("pixelIndex", "@brief Method int QImage::pixelIndex(const QPoint &pt)\n", true, &_init_f_pixelIndex_c1916, &_call_f_pixelIndex_c1916);
  methods += new qt_gsi::GenericMethod ("rect", "@brief Method QRect QImage::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
  methods += new qt_gsi::GenericMethod ("reinterpretAsFormat", "@brief Method bool QImage::reinterpretAsFormat(QImage::Format f)\n", false, &_init_f_reinterpretAsFormat_1733, &_call_f_reinterpretAsFormat_1733);
  methods += new qt_gsi::GenericMethod ("rgbSwapped", "@brief Method QImage QImage::rgbSwapped()\n", true, &_init_f_rgbSwapped_cr0, &_call_f_rgbSwapped_cr0);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QImage::save(const QString &fileName, const char *format, int quality)\n", true, &_init_f_save_c4307, &_call_f_save_c4307);
  methods += new qt_gsi::GenericMethod ("save", "@brief Method bool QImage::save(QIODevice *device, const char *format, int quality)\n", true, &_init_f_save_c3729, &_call_f_save_c3729);
  methods += new qt_gsi::GenericMethod ("scaled", "@brief Method QImage QImage::scaled(int w, int h, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6100, &_call_f_scaled_c6100);
  methods += new qt_gsi::GenericMethod ("scaled", "@brief Method QImage QImage::scaled(const QSize &s, Qt::AspectRatioMode aspectMode, Qt::TransformationMode mode)\n", true, &_init_f_scaled_c6479, &_call_f_scaled_c6479);
  methods += new qt_gsi::GenericMethod ("scaledToHeight", "@brief Method QImage QImage::scaledToHeight(int h, Qt::TransformationMode mode)\n", true, &_init_f_scaledToHeight_c3292, &_call_f_scaledToHeight_c3292);
  methods += new qt_gsi::GenericMethod ("scaledToWidth", "@brief Method QImage QImage::scaledToWidth(int w, Qt::TransformationMode mode)\n", true, &_init_f_scaledToWidth_c3292, &_call_f_scaledToWidth_c3292);
  methods += new qt_gsi::GenericMethod ("scanLine", "@brief Method const unsigned char *QImage::scanLine(int)\n", true, &_init_f_scanLine_c767, &_call_f_scanLine_c767);
  methods += new qt_gsi::GenericMethod ("setAlphaChannel|alphaChannel=", "@brief Method void QImage::setAlphaChannel(const QImage &alphaChannel)\n", false, &_init_f_setAlphaChannel_1877, &_call_f_setAlphaChannel_1877);
  methods += new qt_gsi::GenericMethod ("setColor", "@brief Method void QImage::setColor(int i, unsigned int c)\n", false, &_init_f_setColor_2431, &_call_f_setColor_2431);
  methods += new qt_gsi::GenericMethod ("setColorCount|colorCount=", "@brief Method void QImage::setColorCount(int)\n", false, &_init_f_setColorCount_767, &_call_f_setColorCount_767);
  methods += new qt_gsi::GenericMethod ("setColorTable", "@brief Method void QImage::setColorTable(const QVector<QRgb> colors)\n", false, &_init_f_setColorTable_2325, &_call_f_setColorTable_2325);
  methods += new qt_gsi::GenericMethod ("setDevicePixelRatio|devicePixelRatio=", "@brief Method void QImage::setDevicePixelRatio(double scaleFactor)\n", false, &_init_f_setDevicePixelRatio_1071, &_call_f_setDevicePixelRatio_1071);
  methods += new qt_gsi::GenericMethod ("setDotsPerMeterX|dotsPerMeterX=", "@brief Method void QImage::setDotsPerMeterX(int)\n", false, &_init_f_setDotsPerMeterX_767, &_call_f_setDotsPerMeterX_767);
  methods += new qt_gsi::GenericMethod ("setDotsPerMeterY|dotsPerMeterY=", "@brief Method void QImage::setDotsPerMeterY(int)\n", false, &_init_f_setDotsPerMeterY_767, &_call_f_setDotsPerMeterY_767);
  methods += new qt_gsi::GenericMethod ("setOffset|offset=", "@brief Method void QImage::setOffset(const QPoint &)\n", false, &_init_f_setOffset_1916, &_call_f_setOffset_1916);
  methods += new qt_gsi::GenericMethod ("setPixel", "@brief Method void QImage::setPixel(int x, int y, unsigned int index_or_rgb)\n", false, &_init_f_setPixel_3090, &_call_f_setPixel_3090);
  methods += new qt_gsi::GenericMethod ("setPixel", "@brief Method void QImage::setPixel(const QPoint &pt, unsigned int index_or_rgb)\n", false, &_init_f_setPixel_3580, &_call_f_setPixel_3580);
  methods += new qt_gsi::GenericMethod ("setPixelColor", "@brief Method void QImage::setPixelColor(int x, int y, const QColor &c)\n", false, &_init_f_setPixelColor_3223, &_call_f_setPixelColor_3223);
  methods += new qt_gsi::GenericMethod ("setPixelColor", "@brief Method void QImage::setPixelColor(const QPoint &pt, const QColor &c)\n", false, &_init_f_setPixelColor_3713, &_call_f_setPixelColor_3713);
  methods += new qt_gsi::GenericMethod ("setText", "@brief Method void QImage::setText(const QString &key, const QString &value)\n", false, &_init_f_setText_3942, &_call_f_setText_3942);
  methods += new qt_gsi::GenericMethod ("size", "@brief Method QSize QImage::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod ("sizeInBytes", "@brief Method qsizetype QImage::sizeInBytes()\n", true, &_init_f_sizeInBytes_c0, &_call_f_sizeInBytes_c0);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QImage::swap(QImage &other)\n", false, &_init_f_swap_1182, &_call_f_swap_1182);
  methods += new qt_gsi::GenericMethod ("textKeys", "@brief Method QStringList QImage::textKeys()\n", true, &_init_f_textKeys_c0, &_call_f_textKeys_c0);
  methods += new qt_gsi::GenericMethod ("transformed", "@brief Method QImage QImage::transformed(const QMatrix &matrix, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4548, &_call_f_transformed_c4548);
  methods += new qt_gsi::GenericMethod ("transformed", "@brief Method QImage QImage::transformed(const QTransform &matrix, Qt::TransformationMode mode)\n", true, &_init_f_transformed_c4875, &_call_f_transformed_c4875);
  methods += new qt_gsi::GenericMethod ("valid", "@brief Method bool QImage::valid(int x, int y)\n", true, &_init_f_valid_c1426, &_call_f_valid_c1426);
  methods += new qt_gsi::GenericMethod ("valid", "@brief Method bool QImage::valid(const QPoint &pt)\n", true, &_init_f_valid_c1916, &_call_f_valid_c1916);
  methods += new qt_gsi::GenericMethod ("width", "@brief Method int QImage::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += new qt_gsi::GenericStaticMethod ("fromData", "@brief Static method QImage QImage::fromData(const unsigned char *data, int size, const char *format)\nThis method is static and can be called without an instance.", &_init_f_fromData_5018, &_call_f_fromData_5018);
  methods += new qt_gsi::GenericStaticMethod ("fromData", "@brief Static method QImage QImage::fromData(const QByteArray &data, const char *format)\nThis method is static and can be called without an instance.", &_init_f_fromData_3932, &_call_f_fromData_3932);
  methods += new qt_gsi::GenericStaticMethod ("toImageFormat", "@brief Static method QImage::Format QImage::toImageFormat(QPixelFormat format)\nThis method is static and can be called without an instance.", &_init_f_toImageFormat_1648, &_call_f_toImageFormat_1648);
  methods += new qt_gsi::GenericStaticMethod ("toPixelFormat", "@brief Static method QPixelFormat QImage::toPixelFormat(QImage::Format format)\nThis method is static and can be called without an instance.", &_init_f_toPixelFormat_1733, &_call_f_toPixelFormat_1733);
  methods += new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QMatrix QImage::trueMatrix(const QMatrix &, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3341, &_call_f_trueMatrix_3341);
  methods += new qt_gsi::GenericStaticMethod ("trueMatrix", "@brief Static method QTransform QImage::trueMatrix(const QTransform &, int w, int h)\nThis method is static and can be called without an instance.", &_init_f_trueMatrix_3668, &_call_f_trueMatrix_3668);
  return methods;
}

gsi::Class<QPaintDevice> &qtdecl_QPaintDevice ();

gsi::Class<QImage> decl_QImage (qtdecl_QPaintDevice (), "QtGui", "QImage_Native",
  methods_QImage (),
  "@hide\n@alias QImage");

GSI_QTGUI_PUBLIC gsi::Class<QImage> &qtdecl_QImage () { return decl_QImage; }

}


class QImage_Adaptor : public QImage, public qt_gsi::QtObjectBase
{
public:

  //  NOTE: QImage does not take ownership of the data, so 
  //  we will provide a buffer to do so. This requires an additional 
  //  copy, but as GSI is not guaranteeing the lifetime of the 
  //  data, this is required here.
  class DataHolder
  {
  public:

    DataHolder() : mp_data(0) { }
    DataHolder(unsigned char *data) : mp_data(data) { }

    ~DataHolder() 
    { 
      if (mp_data) {
        delete[](mp_data); 
      }
      mp_data = 0;
    }

    static unsigned char *alloc(const std::string &data)
    {
      unsigned char *ptr = new unsigned char[data.size()];
      memcpy(ptr, data.c_str(), data.size());
      return ptr;
    }

  private:
    unsigned char *mp_data;
  };

  static QImage_Adaptor *new_qimage_from_data1(const std::string &data, int width, int height, int bytesPerLine, QImage::Format format) 
  {
    return new QImage_Adaptor(DataHolder::alloc(data), width, height, bytesPerLine, format);
  }

  static QImage_Adaptor *new_qimage_from_data2(const std::string &data, int width, int height, QImage::Format format) 
  {
    return new QImage_Adaptor(DataHolder::alloc(data), width, height, format);
  }

  QImage_Adaptor(unsigned char *data, int width, int height, int bytesPerLine, QImage::Format format)
    : QImage(data, width, height, bytesPerLine, format), m_holder(data)
  {
  }

  QImage_Adaptor(unsigned char *data, int width, int height, QImage::Format format)
    : QImage (data, width, height, format), m_holder(data)
  {
  }

  DataHolder m_holder;


  virtual ~QImage_Adaptor();

  //  [adaptor ctor] QImage::QImage()
  QImage_Adaptor() : QImage()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QSize &size, QImage::Format format)
  QImage_Adaptor(const QSize &size, QImage::Format format) : QImage(size, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(int width, int height, QImage::Format format)
  QImage_Adaptor(int width, int height, QImage::Format format) : QImage(width, height, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QString &fileName, const char *format)
  QImage_Adaptor(const QString &fileName) : QImage(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QString &fileName, const char *format)
  QImage_Adaptor(const QString &fileName, const char *format) : QImage(fileName, format)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImage::QImage(const QImage &)
  QImage_Adaptor(const QImage &arg1) : QImage(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QImage QImage::convertToFormat_helper(QImage::Format format, QFlags<Qt::ImageConversionFlag> flags)
  QImage fp_QImage_convertToFormat_helper_c4993 (const qt_gsi::Converter<QImage::Format>::target_type & format, QFlags<Qt::ImageConversionFlag> flags) const {
    return QImage::convertToFormat_helper(qt_gsi::QtToCppAdaptor<QImage::Format>(format).cref(), flags);
  }

  //  [expose] bool QImage::convertToFormat_inplace(QImage::Format format, QFlags<Qt::ImageConversionFlag> flags)
  bool fp_QImage_convertToFormat_inplace_4993 (const qt_gsi::Converter<QImage::Format>::target_type & format, QFlags<Qt::ImageConversionFlag> flags) {
    return QImage::convertToFormat_inplace(qt_gsi::QtToCppAdaptor<QImage::Format>(format).cref(), flags);
  }

  //  [expose] QImage QImage::mirrored_helper(bool horizontal, bool vertical)
  QImage fp_QImage_mirrored_helper_c1620 (bool horizontal, bool vertical) const {
    return QImage::mirrored_helper(horizontal, vertical);
  }

  //  [expose] void QImage::mirrored_inplace(bool horizontal, bool vertical)
  void fp_QImage_mirrored_inplace_1620 (bool horizontal, bool vertical) {
    QImage::mirrored_inplace(horizontal, vertical);
  }

  //  [expose] QImage QImage::rgbSwapped_helper()
  QImage fp_QImage_rgbSwapped_helper_c0 () const {
    return QImage::rgbSwapped_helper();
  }

  //  [expose] void QImage::rgbSwapped_inplace()
  void fp_QImage_rgbSwapped_inplace_0 () {
    QImage::rgbSwapped_inplace();
  }

  //  [expose] QImage QImage::smoothScaled(int w, int h)
  QImage fp_QImage_smoothScaled_c1426 (int w, int h) const {
    return QImage::smoothScaled(w, h);
  }

  //  [adaptor impl] QPaintEngine *QImage::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QImage::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QImage_Adaptor, QPaintEngine *>(&QImage_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QImage::paintEngine();
    }
  }

  //  [adaptor impl] void QImage::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QImage::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QImage_Adaptor, QPainter *>(&QImage_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QImage::initPainter(painter);
    }
  }

  //  [adaptor impl] int QImage::metric(QPaintDevice::PaintDeviceMetric metric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & _metric) const
  {
    return QImage::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(_metric).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric _metric) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QImage_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QImage_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(_metric));
    } else {
      return QImage::metric(_metric);
    }
  }

  //  [adaptor impl] QPaintDevice *QImage::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QImage::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QImage_Adaptor, QPaintDevice *, QPoint *>(&QImage_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QImage::redirected(offset);
    }
  }

  //  [adaptor impl] QPainter *QImage::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QImage::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QImage_Adaptor, QPainter *>(&QImage_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QImage::sharedPainter();
    }
  }

  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_sharedPainter_c0_0;
};

QImage_Adaptor::~QImage_Adaptor() { }

//  Constructor QImage::QImage() (adaptor class)

static void _init_ctor_QImage_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QImage_Adaptor> ();
}

static void _call_ctor_QImage_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImage_Adaptor *> (new QImage_Adaptor ());
}


//  Constructor QImage::QImage(const QSize &size, QImage::Format format) (adaptor class)

static void _init_ctor_QImage_Adaptor_3430 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_1);
  decl->set_return_new<QImage_Adaptor> ();
}

static void _call_ctor_QImage_Adaptor_3430 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  const qt_gsi::Converter<QImage::Format>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QImage::Format>(arg2).cref()));
}


//  Constructor QImage::QImage(int width, int height, QImage::Format format) (adaptor class)

static void _init_ctor_QImage_Adaptor_3051 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_2);
  decl->set_return_new<QImage_Adaptor> ();
}

static void _call_ctor_QImage_Adaptor_3051 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QImage::Format>::target_type & arg3 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QImage::Format>(arg3).cref()));
}


//  Constructor QImage::QImage(const QString &fileName, const char *format) (adaptor class)

static void _init_ctor_QImage_Adaptor_3648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return_new<QImage_Adaptor> ();
}

static void _call_ctor_QImage_Adaptor_3648 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1, arg2));
}


//  Constructor QImage::QImage(const QImage &) (adaptor class)

static void _init_ctor_QImage_Adaptor_1877 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return_new<QImage_Adaptor> ();
}

static void _call_ctor_QImage_Adaptor_1877 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QImage &arg1 = gsi::arg_reader<const QImage & >() (args, heap);
  ret.write<QImage_Adaptor *> (new QImage_Adaptor (arg1));
}


// exposed QImage QImage::convertToFormat_helper(QImage::Format format, QFlags<Qt::ImageConversionFlag> flags)

static void _init_fp_convertToFormat_helper_c4993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_fp_convertToFormat_helper_c4993 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap);
  ret.write<QImage > ((QImage)((QImage_Adaptor *)cls)->fp_QImage_convertToFormat_helper_c4993 (arg1, arg2));
}


// exposed bool QImage::convertToFormat_inplace(QImage::Format format, QFlags<Qt::ImageConversionFlag> flags)

static void _init_fp_convertToFormat_inplace_4993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<QFlags<Qt::ImageConversionFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_fp_convertToFormat_inplace_4993 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  QFlags<Qt::ImageConversionFlag> arg2 = gsi::arg_reader<QFlags<Qt::ImageConversionFlag> >() (args, heap);
  ret.write<bool > ((bool)((QImage_Adaptor *)cls)->fp_QImage_convertToFormat_inplace_4993 (arg1, arg2));
}


// void QImage::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// int QImage::metric(QPaintDevice::PaintDeviceMetric metric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QImage_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// exposed QImage QImage::mirrored_helper(bool horizontal, bool vertical)

static void _init_fp_mirrored_helper_c1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("horizontal");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vertical");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_fp_mirrored_helper_c1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  ret.write<QImage > ((QImage)((QImage_Adaptor *)cls)->fp_QImage_mirrored_helper_c1620 (arg1, arg2));
}


// exposed void QImage::mirrored_inplace(bool horizontal, bool vertical)

static void _init_fp_mirrored_inplace_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("horizontal");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vertical");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_mirrored_inplace_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage_Adaptor *)cls)->fp_QImage_mirrored_inplace_1620 (arg1, arg2);
}


// QPaintEngine *QImage::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QImage_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// QPaintDevice *QImage::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QImage_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// exposed QImage QImage::rgbSwapped_helper()

static void _init_fp_rgbSwapped_helper_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QImage > ();
}

static void _call_fp_rgbSwapped_helper_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QImage > ((QImage)((QImage_Adaptor *)cls)->fp_QImage_rgbSwapped_helper_c0 ());
}


// exposed void QImage::rgbSwapped_inplace()

static void _init_fp_rgbSwapped_inplace_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_rgbSwapped_inplace_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImage_Adaptor *)cls)->fp_QImage_rgbSwapped_inplace_0 ();
}


// QPainter *QImage::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QImage_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QImage_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// exposed QImage QImage::smoothScaled(int w, int h)

static void _init_fp_smoothScaled_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QImage > ();
}

static void _call_fp_smoothScaled_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<QImage > ((QImage)((QImage_Adaptor *)cls)->fp_QImage_smoothScaled_c1426 (arg1, arg2));
}


namespace gsi
{

gsi::Class<QImage> &qtdecl_QImage ();

static gsi::Methods methods_QImage_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage()\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_0, &_call_ctor_QImage_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const QSize &size, QImage::Format format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_3430, &_call_ctor_QImage_Adaptor_3430);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(int width, int height, QImage::Format format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_3051, &_call_ctor_QImage_Adaptor_3051);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const QString &fileName, const char *format)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_3648, &_call_ctor_QImage_Adaptor_3648);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImage::QImage(const QImage &)\nThis method creates an object of class QImage.", &_init_ctor_QImage_Adaptor_1877, &_call_ctor_QImage_Adaptor_1877);
  methods += new qt_gsi::GenericMethod ("*convertToFormat_helper", "@brief Method QImage QImage::convertToFormat_helper(QImage::Format format, QFlags<Qt::ImageConversionFlag> flags)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_convertToFormat_helper_c4993, &_call_fp_convertToFormat_helper_c4993);
  methods += new qt_gsi::GenericMethod ("*convertToFormat_inplace", "@brief Method bool QImage::convertToFormat_inplace(QImage::Format format, QFlags<Qt::ImageConversionFlag> flags)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_convertToFormat_inplace_4993, &_call_fp_convertToFormat_inplace_4993);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QImage::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QImage::metric(QPaintDevice::PaintDeviceMetric metric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*mirrored_helper", "@brief Method QImage QImage::mirrored_helper(bool horizontal, bool vertical)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_mirrored_helper_c1620, &_call_fp_mirrored_helper_c1620);
  methods += new qt_gsi::GenericMethod ("*mirrored_inplace", "@brief Method void QImage::mirrored_inplace(bool horizontal, bool vertical)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_mirrored_inplace_1620, &_call_fp_mirrored_inplace_1620);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QImage::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QImage::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*rgbSwapped_helper", "@brief Method QImage QImage::rgbSwapped_helper()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rgbSwapped_helper_c0, &_call_fp_rgbSwapped_helper_c0);
  methods += new qt_gsi::GenericMethod ("*rgbSwapped_inplace", "@brief Method void QImage::rgbSwapped_inplace()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_rgbSwapped_inplace_0, &_call_fp_rgbSwapped_inplace_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QImage::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*smoothScaled", "@brief Method QImage QImage::smoothScaled(int w, int h)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_smoothScaled_c1426, &_call_fp_smoothScaled_c1426);
  return methods;
}

gsi::Class<QImage_Adaptor> decl_QImage_Adaptor (qtdecl_QImage (), "QtGui", "QImage",
  gsi::constructor("new", &QImage_Adaptor::new_qimage_from_data1, gsi::arg ("data"), gsi::arg ("width"), gsi::arg ("height"), gsi::arg ("bytesPerLine"), gsi::arg ("format"),
    "@brief QImage::QImage(const uchar *data, int width, int height, int bytesPerLine)\n"
    "The cleanupFunction parameter is available currently."
  ) +
  gsi::constructor("new", &QImage_Adaptor::new_qimage_from_data2, gsi::arg ("data"), gsi::arg ("width"), gsi::arg ("height"), gsi::arg ("format"),
    "@brief QImage::QImage(const uchar *data, int width, int height)\n"
    "The cleanupFunction parameter is available currently."
  )
+
  methods_QImage_Adaptor (),
  "@qt\n@brief Binding of QImage");

}


//  Implementation of the enum wrapper class for QImage::Format
namespace qt_gsi
{

static gsi::Enum<QImage::Format> decl_QImage_Format_Enum ("QtGui", "QImage_Format",
    gsi::enum_const ("Format_Invalid", QImage::Format_Invalid, "@brief Enum constant QImage::Format_Invalid") +
    gsi::enum_const ("Format_Mono", QImage::Format_Mono, "@brief Enum constant QImage::Format_Mono") +
    gsi::enum_const ("Format_MonoLSB", QImage::Format_MonoLSB, "@brief Enum constant QImage::Format_MonoLSB") +
    gsi::enum_const ("Format_Indexed8", QImage::Format_Indexed8, "@brief Enum constant QImage::Format_Indexed8") +
    gsi::enum_const ("Format_RGB32", QImage::Format_RGB32, "@brief Enum constant QImage::Format_RGB32") +
    gsi::enum_const ("Format_ARGB32", QImage::Format_ARGB32, "@brief Enum constant QImage::Format_ARGB32") +
    gsi::enum_const ("Format_ARGB32_Premultiplied", QImage::Format_ARGB32_Premultiplied, "@brief Enum constant QImage::Format_ARGB32_Premultiplied") +
    gsi::enum_const ("Format_RGB16", QImage::Format_RGB16, "@brief Enum constant QImage::Format_RGB16") +
    gsi::enum_const ("Format_ARGB8565_Premultiplied", QImage::Format_ARGB8565_Premultiplied, "@brief Enum constant QImage::Format_ARGB8565_Premultiplied") +
    gsi::enum_const ("Format_RGB666", QImage::Format_RGB666, "@brief Enum constant QImage::Format_RGB666") +
    gsi::enum_const ("Format_ARGB6666_Premultiplied", QImage::Format_ARGB6666_Premultiplied, "@brief Enum constant QImage::Format_ARGB6666_Premultiplied") +
    gsi::enum_const ("Format_RGB555", QImage::Format_RGB555, "@brief Enum constant QImage::Format_RGB555") +
    gsi::enum_const ("Format_ARGB8555_Premultiplied", QImage::Format_ARGB8555_Premultiplied, "@brief Enum constant QImage::Format_ARGB8555_Premultiplied") +
    gsi::enum_const ("Format_RGB888", QImage::Format_RGB888, "@brief Enum constant QImage::Format_RGB888") +
    gsi::enum_const ("Format_RGB444", QImage::Format_RGB444, "@brief Enum constant QImage::Format_RGB444") +
    gsi::enum_const ("Format_ARGB4444_Premultiplied", QImage::Format_ARGB4444_Premultiplied, "@brief Enum constant QImage::Format_ARGB4444_Premultiplied") +
    gsi::enum_const ("Format_RGBX8888", QImage::Format_RGBX8888, "@brief Enum constant QImage::Format_RGBX8888") +
    gsi::enum_const ("Format_RGBA8888", QImage::Format_RGBA8888, "@brief Enum constant QImage::Format_RGBA8888") +
    gsi::enum_const ("Format_RGBA8888_Premultiplied", QImage::Format_RGBA8888_Premultiplied, "@brief Enum constant QImage::Format_RGBA8888_Premultiplied") +
    gsi::enum_const ("Format_BGR30", QImage::Format_BGR30, "@brief Enum constant QImage::Format_BGR30") +
    gsi::enum_const ("Format_A2BGR30_Premultiplied", QImage::Format_A2BGR30_Premultiplied, "@brief Enum constant QImage::Format_A2BGR30_Premultiplied") +
    gsi::enum_const ("Format_RGB30", QImage::Format_RGB30, "@brief Enum constant QImage::Format_RGB30") +
    gsi::enum_const ("Format_A2RGB30_Premultiplied", QImage::Format_A2RGB30_Premultiplied, "@brief Enum constant QImage::Format_A2RGB30_Premultiplied") +
    gsi::enum_const ("Format_Alpha8", QImage::Format_Alpha8, "@brief Enum constant QImage::Format_Alpha8") +
    gsi::enum_const ("Format_Grayscale8", QImage::Format_Grayscale8, "@brief Enum constant QImage::Format_Grayscale8") +
    gsi::enum_const ("Format_RGBX64", QImage::Format_RGBX64, "@brief Enum constant QImage::Format_RGBX64") +
    gsi::enum_const ("Format_RGBA64", QImage::Format_RGBA64, "@brief Enum constant QImage::Format_RGBA64") +
    gsi::enum_const ("Format_RGBA64_Premultiplied", QImage::Format_RGBA64_Premultiplied, "@brief Enum constant QImage::Format_RGBA64_Premultiplied") +
    gsi::enum_const ("NImageFormats", QImage::NImageFormats, "@brief Enum constant QImage::NImageFormats"),
  "@qt\n@brief This class represents the QImage::Format enum");

static gsi::QFlagsClass<QImage::Format > decl_QImage_Format_Enums ("QtGui", "QImage_QFlags_Format",
  "@qt\n@brief This class represents the QFlags<QImage::Format> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QImage> inject_QImage_Format_Enum_in_parent (decl_QImage_Format_Enum.defs ());
static gsi::ClassExt<QImage> decl_QImage_Format_Enum_as_child (decl_QImage_Format_Enum, "Format");
static gsi::ClassExt<QImage> decl_QImage_Format_Enums_as_child (decl_QImage_Format_Enums, "QFlags_Format");

}


//  Implementation of the enum wrapper class for QImage::InvertMode
namespace qt_gsi
{

static gsi::Enum<QImage::InvertMode> decl_QImage_InvertMode_Enum ("QtGui", "QImage_InvertMode",
    gsi::enum_const ("InvertRgb", QImage::InvertRgb, "@brief Enum constant QImage::InvertRgb") +
    gsi::enum_const ("InvertRgba", QImage::InvertRgba, "@brief Enum constant QImage::InvertRgba"),
  "@qt\n@brief This class represents the QImage::InvertMode enum");

static gsi::QFlagsClass<QImage::InvertMode > decl_QImage_InvertMode_Enums ("QtGui", "QImage_QFlags_InvertMode",
  "@qt\n@brief This class represents the QFlags<QImage::InvertMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QImage> inject_QImage_InvertMode_Enum_in_parent (decl_QImage_InvertMode_Enum.defs ());
static gsi::ClassExt<QImage> decl_QImage_InvertMode_Enum_as_child (decl_QImage_InvertMode_Enum, "InvertMode");
static gsi::ClassExt<QImage> decl_QImage_InvertMode_Enums_as_child (decl_QImage_InvertMode_Enums, "QFlags_InvertMode");

}

