/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "messagebox.h"

#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>

namespace KylinUI {
MessageBox::MessageBox(QString title, QString text, QWidget *parent, MessageType type) :
    Dialog(parent)
{
    msg_type = type;
    initLayout();
    setData(title, text);
}

MessageBox::~MessageBox()
{
    delete lab_titleIcon;
    delete lab_title;
    delete lab_text;
    delete lab_textIcon;
    delete btn_ok;
    delete box_hb;
    delete box_hm;
    delete box_ht;
    delete box_v;
}

void MessageBox::setData(QString title, QString text)
{
    QIcon icMsg, icTitle = QIcon::fromTheme("kylin-video");
    switch (msg_type) {
    case INFORMATION:
        icMsg = QIcon::fromTheme("ukui-dialog-information");
        btn_cancel->hide();
        break;
    case QUESTION:
        icMsg = QIcon::fromTheme("ukui-dialog-help");
        break;
    case WARNING:
        icMsg = QIcon::fromTheme("ukui-dialog-warning");
        btn_cancel->hide();
        break;
    case ABOUT:
        icMsg = QIcon::fromTheme("about");
        btn_cancel->hide();
        break;
    default:
        break;
    }

    lab_title->setText(title);
    lab_titleIcon->setPixmap(icTitle.pixmap(lab_titleIcon->size()));
    lab_text->setText(text);
    lab_textIcon->setPixmap(icMsg.pixmap(lab_textIcon->size()));
}

void MessageBox::initLayout()
{
    setFixedSize(WIDGET_WIDTH, WIDGET_HEIGHT);

    box_ht = new QHBoxLayout;
    box_hm = new QHBoxLayout;
    box_hb = new QHBoxLayout;
    box_v = new QVBoxLayout(this);

    box_v->addLayout(box_ht);
    box_v->addSpacing(10);
    box_v->addLayout(box_hm);
    box_v->addStretch();
    box_v->addLayout(box_hb);

    lab_titleIcon = new QLabel;
    lab_titleIcon->setFixedSize(TITLE_ICON_WIDTH, TITLE_ICON_WIDTH);
    lab_title = new QLabel;

    box_ht->addWidget(lab_titleIcon);
    box_ht->addWidget(lab_title);
    box_ht->addStretch();

    lab_text = new QLabel;
    lab_textIcon = new QLabel;
    lab_textIcon->setFixedSize(TEXT_ICON_WIDTH, TEXT_ICON_WIDTH);
    box_hm->addSpacing(24);
    box_hm->addWidget(lab_textIcon);
    box_hm->addWidget(lab_text);
    box_hm->addStretch();

    btn_cancel = new QPushButton;
    btn_cancel->setFixedSize(80, 30);
    btn_cancel->setText(tr("Cancle"));

    btn_ok = new QPushButton;
    btn_ok->setFixedSize(80, 30);
    btn_ok->setText(tr("Ok"));

    connect(btn_cancel, &QPushButton::clicked, this, &MessageBox::reject);
    connect(btn_ok, &QPushButton::clicked, this, &MessageBox::accept);
    box_hb->addStretch();
    box_hb->addWidget(btn_cancel);
    box_hb->addWidget(btn_ok);
    box_hb->setContentsMargins(0, 0, 24, 16);
}
}
