//
// $Id$
//
//
// Darren Kessner <darren@proteowizard.org>
//
// Copyright 2007 Spielberg Family Center for Applied Proteomics
//   Cedars-Sinai Medical Center, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// This file was generated by cvgen.
//
// Do not edit this file! Your changes will be lost next time cvgen is run -
// see pwiz/scripts/misc/update_cv.bat for info on how that works.
// Instead, edit cvgen.cpp itself, or the cv.inl include file if adding static
// code or data.
//


#define PWIZ_SOURCE

#include "cv.hpp"
#include "pwiz/utility/misc/Std.hpp"
#include "pwiz/utility/misc/Singleton.hpp"


namespace pwiz {
namespace cv {


namespace {


struct TermInfo
{
    CVID cvid;
    const char* id;
    const char* name;
    const char* def;
    bool isObsolete;
};


const TermInfo termInfos_[] =
{
    {CVID_Unknown, "??:0000000", "CVID_Unknown", "CVID_Unknown", false},
    {MS_Proteomics_Standards_Initiative_Mass_Spectrometry_Vocabularies, "MS:0000000", "Proteomics Standards Initiative Mass Spectrometry Vocabularies", "Proteomics Standards Initiative Mass Spectrometry Vocabularies.", false},
    {PEFF_PEFF_CV_term, "PEFF:0000001", "PEFF CV term", "PSI Extended FASTA Format controlled vocabulary term.", false},
    {PEFF_PEFF_file_header_section_term, "PEFF:0000002", "PEFF file header section term", "CV term that may appear in a PEFF file header section.", false},
    {PEFF_PEFF_file_sequence_entry_term, "PEFF:0000003", "PEFF file sequence entry term", "CV term that may appear in a description line of a PEFF file individual sequence entry.", false},
    {PEFF_DbName, "PEFF:0000008", "DbName", "PEFF keyword for the sequence database name.", false},
    {PEFF_Prefix, "PEFF:0000009", "Prefix", "PEFF keyword for the sequence database prefix.", false},
    {PEFF_DbDescription, "PEFF:0000010", "DbDescription", "PEFF keyword for the sequence database short description.", false},
    {PEFF_Decoy, "PEFF:0000011", "Decoy", "PEFF keyword for the specifying whether the sequence database is a decoy database.", false},
    {PEFF_DbSource, "PEFF:0000012", "DbSource", "PEFF keyword for the source of the database file.", false},
    {PEFF_DbVersion, "PEFF:0000013", "DbVersion", "PEFF keyword for the database version (release date) according to database provider.", false},
    {PEFF_DbDate_OBSOLETE, "PEFF:0000014", "DbDate", "PEFF keyword for the database date (release or file date of the source) according to database provider.", true},
    {PEFF_NumberOfEntries, "PEFF:0000015", "NumberOfEntries", "PEFF keyword for the sumber of sequence entries in the database.", false},
    {PEFF_Conversion, "PEFF:0000016", "Conversion", "PEFF keyword for the description of the conversion from original format to this current one.", false},
    {PEFF_SequenceType, "PEFF:0000017", "SequenceType", "PEFF keyword for the molecular type of the sequences.", false},
    {PEFF_SpecificKey, "PEFF:0000018", "SpecificKey", "PEFF keyword for database specific keywords not included in the current controlled vocabulary.", false},
    {PEFF_SpecificValue, "PEFF:0000019", "SpecificValue", "PEFF keyword for the specific values for a custom key.", false},
    {PEFF_DatabaseDescription, "PEFF:0000020", "DatabaseDescription", "PEFF keyword for the short description of the PEFF file.", false},
    {PEFF_GeneralComment, "PEFF:0000021", "GeneralComment", "PEFF keyword for a general comment.", false},
    {PEFF_ProteoformDb, "PEFF:0000022", "ProteoformDb", "PEFF keyword that when set to 'true' indicates that the database contains complete proteoforms.", false},
    {PEFF_OptionalTagDef, "PEFF:0000023", "OptionalTagDef", "PEFF keyword for the short tag (abbreviation) and longer definition used to annotate a sequence annotation (such as variant or modification) in the OptionalTag location.", false},
    {PEFF_HasAnnotationIdentifiers, "PEFF:0000024", "HasAnnotationIdentifiers", "PEFF keyword that when set to 'true' indicates that entries in the database have identifiers for each annotation.", false},
    {PEFF_DbUniqueId_OBSOLETE, "PEFF:0001001", "DbUniqueId", "Sequence database unique identifier.", true},
    {PEFF_PName, "PEFF:0001002", "PName", "PEFF keyword for the protein full name.", false},
    {PEFF_NcbiTaxId, "PEFF:0001003", "NcbiTaxId", "PEFF keyword for the NCBI taxonomy identifier.", false},
    {PEFF_TaxName, "PEFF:0001004", "TaxName", "PEFF keyword for the taxonomy name (latin or common name).", false},
    {PEFF_GName, "PEFF:0001005", "GName", "PEFF keyword for the gene name.", false},
    {PEFF_Length, "PEFF:0001006", "Length", "PEFF keyword for the sequence length.", false},
    {PEFF_SV, "PEFF:0001007", "SV", "PEFF keyword for the sequence version.", false},
    {PEFF_EV, "PEFF:0001008", "EV", "PEFF keyword for the entry version.", false},
    {PEFF_PE, "PEFF:0001009", "PE", "PEFF keyword for the Protein Evidence; A UniProtKB code 1-5.", false},
    {PEFF_Processed, "PEFF:0001010", "Processed", "PEFF keyword for information on how the full length original protein sequence can be processed into shorter components such as signal peptides and chains.", false},
    {PEFF_Variant_OBSOLETE, "PEFF:0001011", "Variant", "Sequence variation (substitution, insertion, deletion).", true},
    {PEFF_ModResPsi, "PEFF:0001012", "ModResPsi", "PEFF keyword for the modified residue with PSI-MOD identifier.", false},
    {PEFF_ModRes, "PEFF:0001013", "ModRes", "PEFF keyword for the modified residue without aPSI-MOD or UniMod identifier.", false},
    {PEFF_AltAC, "PEFF:0001014", "AltAC", "PEFF keyword for the Alternative Accession Code.", false},
    {PEFF_SeqStatus, "PEFF:0001015", "SeqStatus", "PEFF keyword for the sequence status. Complete or Fragment.", false},
    {PEFF_CC, "PEFF:0001016", "CC", "PEFF keyword for the entry associated comment.", false},
    {PEFF_KW, "PEFF:0001017", "KW", "PEFF keyword for the entry associated keyword(s).", false},
    {PEFF_GO, "PEFF:0001018", "GO", "PEFF keyword for the Gene Ontology code.", false},
    {PEFF_XRef, "PEFF:0001019", "XRef", "PEFF keyword for the cross-reference to an external resource.", false},
    {PEFF_mature_protein, "PEFF:0001020", "mature protein", "Portion of a newly synthesized protein that contributes to a final structure after other components such as signal peptides are removed.", false},
    {PEFF_signal_peptide, "PEFF:0001021", "signal peptide", "Short peptide present at the N-terminus of a newly synthesized protein that is cleaved off and is not part of the final mature protein.", false},
    {PEFF_transit_peptide, "PEFF:0001022", "transit peptide", "Short peptide present at the N-terminus of a newly synthesized protein that helps the protein through the membrane of its destination organelle.", false},
    {PEFF_Conflict, "PEFF:0001023", "Conflict", "PEFF keyword for the sequence conflict; a UniProtKB term.", false},
    {PEFF_Crc64, "PEFF:0001024", "Crc64", "PEFF keyword for the Sequence checksum in crc64.", false},
    {PEFF_Domain, "PEFF:0001025", "Domain", "PEFF keyword for the sequence range of a domain.", false},
    {PEFF_ID, "PEFF:0001026", "ID", "PEFF keyword for the UniProtKB specific Protein identifier ID; a UniProtKB term.", false},
    {PEFF_ModResUnimod, "PEFF:0001027", "ModResUnimod", "PEFF keyword for the modified residue with UniMod identifier.", false},
    {PEFF_VariantSimple, "PEFF:0001028", "VariantSimple", "PEFF keyword for the simple sequence variation of a single amino acid change. A change to a stop codon is permitted with a * symbol. More complex variations must be encoded with the VariantComplex term.", false},
    {PEFF_VariantComplex, "PEFF:0001029", "VariantComplex", "PEFF keyword for a sequence variation that is more complex than a single amino acid change or change to a stop codon.", false},
    {PEFF_Proteoform, "PEFF:0001030", "Proteoform", "PEFF keyword for the proteoforms of this protein, constructed as a set of annotation identifiers.", false},
    {PEFF_DisulfideBond, "PEFF:0001031", "DisulfideBond", "PEFF keyword for the disulfide bonds in this protein, constructed as a sets of annotation identifiers of two half-cystine modifications.", false},
    {PEFF_PEFF_molecule_processing_keyword, "PEFF:0001032", "PEFF molecule processing keyword", "PEFF keyword describing the type of processing event being described.", false},
    {PEFF_Comment, "PEFF:0001033", "Comment", "PEFF keyword for the individual protein entry comment. It is discouraged to put parsable information here. This is only for free-text commentary.", false},
    {PEFF_propeptide, "PEFF:0001034", "propeptide", "Short peptide that is cleaved off a newly synthesized protein and generally immediately degraded in the process of protein maturation, and is not a signal peptide or transit peptide.", false},
    {PEFF_initiator_methionine, "PEFF:0001035", "initiator methionine", "N-terminal methionine residue of a protein that can be co-translationally cleaved.", false},
    {NCIT_Technique, "NCIT:0316847", "Technique", "A practiced and regimented skill or series of actions.", false},
    {NCIT_Statistical_Technique, "NCIT:0319044", "Statistical Technique", "A method of analyzing or representing statistical data; a procedure for calculating a statistic.", false},
    {NCIT_Conceptual_Entity, "NCIT:0320181", "Conceptual Entity", "An organizational header for concepts representing mostly abstract entities.", false},
    {NCIT_Property_or_Attribute, "NCIT:0320189", "Property or Attribute", "A distinguishing quality or prominent aspect of a person, object, action, process, or substance.", false},
    {NCIT_Temporal_Qualifier, "NCIT:0321514", "Temporal Qualifier", "Terms used to indicate units of time or other terms associated with time.", false},
    {NCIT_Duration, "NCIT:0325330", "Duration", "The period of time during which something continues.", false},
    {NCIT_Action, "NCIT:0325404", "Action", "A thing done.", false},
    {NCIT_Characteristic, "NCIT:0325447", "Characteristic", "The distinguishing qualities or prominent aspect of a person, object, action, process, or substance.", false},
    {NCIT_Qualifier, "NCIT:0341009", "Qualifier", "A term that helps define and render a concept unique.", false},
    {NCIT_Activity, "NCIT:0343431", "Activity", "An active process; excludes processes and mechanisms which fulfill biological functions.", false},
    {NCIT_Density, "NCIT:0345781", "Density", "The amount of something per unit size.", false},
    {NCIT_Principal_Component, "NCIT:0360694", "Principal Component", "One of the axes representing the projection of varience resulting from principal component analysis.", false},
    {NCIT_Cover, "NCIT:0368811", "Cover", "Span a region or interval of distance, space or time.", false},
    {NCIT_Outlier, "NCIT:0379083", "Outlier", "An observation in a data set that is numerically distant from the rest of the data.", false},
    {MS_sample_number, "MS:1000001", "sample number", "A reference number relevant to the sample under study.", false},
    {MS_sample_name, "MS:1000002", "sample name", "A reference string relevant to the sample under study.", false},
    {MS_sample_state, "MS:1000003", "sample state", "The chemical phase of a pure sample, or the state of a mixed sample.", false},
    {MS_sample_mass, "MS:1000004", "sample mass", "Total mass of sample used.", false},
    {MS_sample_volume, "MS:1000005", "sample volume", "Total volume of solution used.", false},
    {MS_sample_concentration, "MS:1000006", "sample concentration", "Concentration of sample in picomol/ul, femtomol/ul or attomol/ul solution used.", false},
    {MS_inlet_type, "MS:1000007", "inlet type", "The nature of the sample inlet.", false},
    {MS_ionization_type, "MS:1000008", "ionization type", "The method by which gas phase ions are generated from the sample.", false},
    {MS_ionization_mode_OBSOLETE, "MS:1000009", "ionization mode", "Whether positive or negative ions are selected for analysis by the spectrometer.", true},
    {MS_analyzer_type_OBSOLETE, "MS:1000010", "analyzer type", "The common name of the particular analyzer stage being described. Synonym of mass analyzer, should be obsoleted.", true},
    {MS_mass_resolution, "MS:1000011", "mass resolution", "Smallest mass difference between two equal magnitude peaks so that the valley between them is a specified fraction of the peak height.", false},
    {MS_resolution_measurement_method, "MS:1000012", "resolution measurement method", "Which of the available standard measures is used to define whether two peaks are separate.", false},
    {MS_resolution_type_OBSOLETE, "MS:1000013", "resolution type", "Specify the nature of resolution for the mass analyzer. Resolution is usually either constant with respect to m/z or proportional to m/z.", true},
    {MS_accuracy, "MS:1000014", "accuracy", "Accuracy is the degree of conformity of a measured mass to its actual value.", false},
    {MS_scan_rate, "MS:1000015", "scan rate", "Rate in Th/sec for scanning analyzers.", false},
    {MS_scan_start_time, "MS:1000016", "scan start time", "The time that an analyzer started a scan, relative to the start of the MS run.", false},
    {MS_Scan_Function_OBSOLETE, "MS:1000017", "Scan Function", "Describes the type of mass analysis being performed. Two primary modes are: typical acquisition over a range of masses (Mass Scan), and Selected Ion Detection. The primary difference is that Selected Ion Detection produces a single value for the signal at the selected mass rather than producing a mass spectrum.", true},
    {MS_scan_direction, "MS:1000018", "scan direction", "Direction in terms of m/z of the scan for scanning analyzers (low to high, or high to low).", false},
    {MS_scan_law, "MS:1000019", "scan law", "Describes the function in control of the m/z scan (for scanning instruments). Commonly the scan function is linear, but in principle any function can be used.", false},
    {MS_scanning_method_OBSOLETE, "MS:1000020", "scanning method", "Describes the acquisition data type produced by a tandem mass spectrometry experiment.", true},
    {MS_reflectron_state, "MS:1000021", "reflectron state", "Status of the reflectron, turned on or off.", false},
    {MS_TOF_Total_Path_Length, "MS:1000022", "TOF Total Path Length", "The length of the field free drift space in a time of flight mass spectrometer.", false},
    {MS_isolation_width_OBSOLETE, "MS:1000023", "isolation width", "The total width (i.e. not half for plus-or-minus) of the gate applied around a selected precursor ion.", true},
    {MS_final_MS_exponent, "MS:1000024", "final MS exponent", "Final MS level achieved when performing PFF with the ion trap (e.g. MS E10).", false},
    {MS_magnetic_field_strength, "MS:1000025", "magnetic field strength", "A property of space that produces a force on a charged particle equal to qv x B where q is the particle charge and v its velocity.", false},
    {MS_detector_type, "MS:1000026", "detector type", "Type of detector used in the mass spectrometer.", false},
    {MS_detector_acquisition_mode, "MS:1000027", "detector acquisition mode", "Method by which detector signal is acquired by the data system.", false},
    {MS_detector_resolution, "MS:1000028", "detector resolution", "The resolving power of the detector to detect the smallest difference between two ions so that the valley between them is a specified fraction of the peak height.", false},
    {MS_sampling_frequency, "MS:1000029", "sampling frequency", "The rate of signal sampling (measurement) with respect to time.", false},
    {MS_vendor_OBSOLETE, "MS:1000030", "vendor", "Name of instrument vendor.", true},
    {MS_instrument_model, "MS:1000031", "instrument model", "Instrument model name not including the vendor's name.", false},
    {MS_customization, "MS:1000032", "customization", "Free text description of a single customization made to the instrument; for several modifications, use several entries.", false},
    {MS_deisotoping, "MS:1000033", "deisotoping", "The removal of isotope peaks to represent the ion as one data point and is commonly done to reduce complexity. It is done in conjunction with the charge state deconvolution.", false},
    {MS_charge_deconvolution, "MS:1000034", "charge deconvolution", "The determination of the mass of an ion based on the mass spectral peaks that represent multiple-charge ions.", false},
    {MS_peak_picking, "MS:1000035", "peak picking", "Spectral peak processing conducted on the acquired data to convert profile data to centroided data.", false},
    {MS_scan_mode_OBSOLETE, "MS:1000036", "scan mode", "OBSOLETE.", true},
    {MS_polarity_OBSOLETE, "MS:1000037", "polarity", "Terms to describe the polarity setting of the instrument.", true},
    {MS_minute_OBSOLETE, "MS:1000038", "minute", "Acquisition time in minutes.", true},
    {MS_second_OBSOLETE, "MS:1000039", "second", "Acquisition time in seconds.", true},
    {MS_m_z, "MS:1000040", "m/z", "Three-character symbol m/z is used to denote the quantity formed by dividing the mass of an ion in unified atomic mass units by its charge number (regardless of sign). The symbol is written in italicized lower case letters with no spaces. Note 1: The term mass-to-charge-ratio is deprecated. Mass-to-charge ratio has been used for the abscissa of a mass spectrum, although the quantity measured is not the quotient of the ion's mass to its electric charge. The three-character symbol m/z is recommended for the quantity that is the independent variable in a mass spectrum Note 2: The proposed unit thomson (Th) is deprecated.", false},
    {MS_charge_state, "MS:1000041", "charge state", "Number of net charges, positive or negative, on an ion.", false},
    {MS_peak_intensity, "MS:1000042", "peak intensity", "Intensity of ions as measured by the height or area of a peak in a mass spectrum.", false},
    {MS_intensity_unit, "MS:1000043", "intensity unit", "Intensity units are commonly arbitrary. Detected in counts per second (cps) when using counting detectors, but measured in volts when using analog detectors.", false},
    {MS_dissociation_method, "MS:1000044", "dissociation method", "Fragmentation method used for dissociation or fragmentation.", false},
    {MS_collision_energy, "MS:1000045", "collision energy", "Energy for an ion experiencing collision with a stationary gas particle resulting in dissociation of the ion.", false},
    {MS_energy_unit_OBSOLETE, "MS:1000046", "energy unit", "Energy units are represented in either eV or Joules.", true},
    {MS_emulsion, "MS:1000047", "emulsion", "State if the sample is in emulsion form.", false},
    {MS_gaseous_sample_state, "MS:1000048", "gaseous sample state", "State if the sample is in gaseous form.", false},
    {MS_liquid_sample_state, "MS:1000049", "liquid sample state", "State if the sample is in liquid form.", false},
    {MS_solid_sample_state, "MS:1000050", "solid sample state", "State if the sample is in solid form.", false},
    {MS_solution, "MS:1000051", "solution", "State if the sample is in solution form.", false},
    {MS_suspension, "MS:1000052", "suspension", "State if the sample is in suspension form.", false},
    {MS_sample_batch, "MS:1000053", "sample batch", "Sample batch lot identifier.", false},
    {MS_chromatography_OBSOLETE, "MS:1000054", "chromatography", "Chromatographic conditions used to obtain the sample.", true},
    {MS_continuous_flow_fast_atom_bombardment, "MS:1000055", "continuous flow fast atom bombardment", "Fast atom bombardment ionization in which the analyte in solution is entrained in a flowing liquid matrix.", false},
    {MS_direct_inlet, "MS:1000056", "direct inlet", "The sample is directly inserted into the ion source, usually on the end of a heatable probe.", false},
    {MS_electrospray_inlet, "MS:1000057", "electrospray inlet", "Inlet used for introducing the liquid sample into an electrospray ionization source.", false},
    {MS_flow_injection_analysis, "MS:1000058", "flow injection analysis", "Sample is directly injected or infused into the ionization source.", false},
    {MS_inductively_coupled_plasma, "MS:1000059", "inductively coupled plasma", "A gas discharge ion source in which the energy to the plasma is supplied by electromagnetic induction.", false},
    {MS_infusion, "MS:1000060", "infusion", "The continuous flow of solution of a sample into the ionization source.", false},
    {MS_jet_separator, "MS:1000061", "jet separator", "A device that separates carrier gas from gaseous analyte molecules on the basis of diffusivity.", false},
    {MS_membrane_separator, "MS:1000062", "membrane separator", "A device to separate carrier molecules from analyte molecules on the basis of ease of diffusion across a semipermeable membrane.", false},
    {MS_moving_belt, "MS:1000063", "moving belt", "Continuous moving surface in the form of a belt which passes through an ion source carrying analyte molecules.", false},
    {MS_moving_wire, "MS:1000064", "moving wire", "Continuous moving surface in the form of a wire which passes through an ion source carrying analyte molecules.", false},
    {MS_open_split, "MS:1000065", "open split", "A division of flowing stream of liquid into two streams.", false},
    {MS_particle_beam, "MS:1000066", "particle beam", "Method for generating ions from a solution of an analyte.", false},
    {MS_reservoir, "MS:1000067", "reservoir", "A sample inlet method involving a reservoir.", false},
    {MS_septum, "MS:1000068", "septum", "A disc composed of a flexible material that seals the entrance to the reservoir. Can also be entrance to the vacuum chamber.", false},
    {MS_thermospray_inlet, "MS:1000069", "thermospray inlet", "A method for generating gas phase ions from a solution of an analyte by rapid heating of the sample.", false},
    {MS_atmospheric_pressure_chemical_ionization, "MS:1000070", "atmospheric pressure chemical ionization", "Chemical ionization that takes place at atmospheric pressure as opposed to the reduced pressure is normally used for chemical ionization.", false},
    {MS_chemical_ionization, "MS:1000071", "chemical ionization", "The formation of a new ion by the reaction of a neutral species with an ion. The process may involve transfer of an electron, a proton or other charged species between the reactants. When a positive ion results from chemical ionization the term may be used without qualification. When a negative ion results the term negative ion chemical ionization should be used. Note that this term is not synonymous with chemi-ionization.", false},
    {MS_Electronic_Ionization_OBSOLETE, "MS:1000072", "Electronic Ionization", "The ionization of an atom or molecule by electrons that are typically accelerated to energies between 50 and 150 eV. Usually 70 eV electrons are used to produce positive ions. The term 'electron impact' is not recommended.", true},
    {MS_electrospray_ionization, "MS:1000073", "electrospray ionization", "A process in which ionized species in the gas phase are produced from an analyte-containing solution via highly charged fine droplets, by means of spraying the solution from a narrow-bore needle tip at atmospheric pressure in the presence of a high electric field. When a pressurized gas is used to aid in the formation of a stable spray, the term pneumatically assisted electrospray ionization is used. The term ion spray is not recommended.", false},
    {MS_fast_atom_bombardment_ionization, "MS:1000074", "fast atom bombardment ionization", "The ionization of any species by the interaction of a focused beam of neutral atoms having a translational energy of several thousand eV with a sample that is typically dissolved in a solvent matrix. See also secondary ionization.", false},
    {MS_matrix_assisted_laser_desorption_ionization, "MS:1000075", "matrix-assisted laser desorption ionization", "The formation of gas-phase ions from molecules that are present in a solid or solvent matrix that is irradiated with a pulsed laser. See also laser desorption/ionization.", false},
    {MS_negative_ion_mode_OBSOLETE, "MS:1000076", "negative ion mode", "OBSOLETE.", true},
    {MS_positive_ion_mode_OBSOLETE, "MS:1000077", "positive ion mode", "OBSOLETE.", true},
    {MS_axial_ejection_linear_ion_trap, "MS:1000078", "axial ejection linear ion trap", "A linear ion trap mass spectrometer where ions are ejected along the axis of the analyzer.", false},
    {MS_fourier_transform_ion_cyclotron_resonance_mass_spectrometer, "MS:1000079", "fourier transform ion cyclotron resonance mass spectrometer", "A mass spectrometer based on the principle of ion cyclotron resonance in which an ion in a magnetic field moves in a circular orbit at a frequency characteristic of its m/z value. Ions are coherently excited to a larger radius orbit using a pulse of radio frequency energy and their image charge is detected on receiver plates as a time domain signal. Fourier transformation of the time domain signal results in a frequency domain signal which is converted to a mass spectrum based in the inverse relationship between frequency and m/z.", false},
    {MS_magnetic_sector, "MS:1000080", "magnetic sector", "A device that produces a magnetic field perpendicular to a charged particle beam that deflects the beam to an extent that is proportional to the particle momentum per unit charge. For a monoenergetic beam, the deflection is proportional to m/z.", false},
    {MS_quadrupole, "MS:1000081", "quadrupole", "A mass spectrometer that consists of four parallel rods whose centers form the corners of a square and whose opposing poles are connected. The voltage applied to the rods is a superposition of a static potential and a sinusoidal radio frequency potential. The motion of an ion in the x and y dimensions is described by the Matthieu equation whose solutions show that ions in a particular m/z range can be transmitted along the z axis.", false},
    {MS_quadrupole_ion_trap, "MS:1000082", "quadrupole ion trap", "Quadrupole Ion Trap mass analyzer captures the ions in a three dimensional ion trap and then selectively ejects them by varying the RF and DC potentials.", false},
    {MS_radial_ejection_linear_ion_trap, "MS:1000083", "radial ejection linear ion trap", "A linear ion trap mass spectrometer where ions are ejected along the radius of the analyzer.", false},
    {MS_time_of_flight, "MS:1000084", "time-of-flight", "Instrument that separates ions by m/z in a field-free region after acceleration to a fixed acceleration energy.", false},
    {MS_baseline, "MS:1000085", "baseline", "An attribute of resolution when recording the detector response in absence of the analyte.", false},
    {MS_full_width_at_half_maximum, "MS:1000086", "full width at half-maximum", "A measure of resolution represented as width of the peak at half peak height.", false},
    {MS_ten_percent_valley, "MS:1000087", "ten percent valley", "An attribute of resolution when the ratio between adjacent signals is 10% of the signal height.", false},
    {MS_constant_OBSOLETE, "MS:1000088", "constant", "When resolution is constant with respect to m/z.", true},
    {MS_proportional_OBSOLETE, "MS:1000089", "proportional", "When resolution is proportional with respect to m/z.", true},
    {MS_mass_scan_OBSOLETE, "MS:1000090", "mass scan", "A variation of instrument where a selected mass is scanned.", true},
    {MS_selected_ion_detection_OBSOLETE, "MS:1000091", "selected ion detection", "Please see Single Ion Monitoring.", true},
    {MS_decreasing_m_z_scan, "MS:1000092", "decreasing m/z scan", "High to low direction in terms of m/z of the scan for scanning analyzers.", false},
    {MS_increasing_m_z_scan, "MS:1000093", "increasing m/z scan", "Low to high direction in terms of m/z of the scan for scanning analyzers.", false},
    {MS_exponential, "MS:1000094", "exponential", "The mass scan is done in exponential mode.", false},
    {MS_linear_OBSOLETE, "MS:1000095", "linear", "The mass scan is done in linear mode.", true},
    {MS_quadratic, "MS:1000096", "quadratic", "The mass scan is done in quadratic mode.", false},
    {MS_constant_neutral_mass_loss_OBSOLETE, "MS:1000097", "constant neutral mass loss", "A spectrum formed of all product ions that have been produced with a selected m/z decrement from any precursor ions. The spectrum shown correlates to the precursor ion spectrum. See also neutral loss spectrum.", true},
    {MS_multiple_ion_monitoring_OBSOLETE, "MS:1000098", "multiple ion monitoring", "Data acquired when monitoring the ion current of a few specific m/z values. Remap to MS:1000205 -Selected Ion Monitoring.", true},
    {MS_multiple_reaction_monitoring_OBSOLETE, "MS:1000099", "multiple reaction monitoring", "This term is not recommended. See Selected Reaction Monitoring.", true},
    {MS_precursor_ion_scan_OBSOLETE, "MS:1000100", "precursor ion scan", "The specific scan function or process that will record a precursor ion spectrum.", true},
    {MS_product_ion_scan_OBSOLETE, "MS:1000101", "product ion scan", "The specific scan function or process that records product ion spectrum.", true},
    {MS_single_ion_monitoring_OBSOLETE, "MS:1000102", "single ion monitoring", "The operation of a mass spectrometer to monitor a single ion rather than scanning entire mass spectrum.", true},
    {MS_single_reaction_monitoring_OBSOLETE, "MS:1000103", "single reaction monitoring", "This term is not recommended. See Selected Reaction Monitoring.", true},
    {MS_None____OBSOLETE, "MS:1000104", "None ??", "None.", true},
    {MS_reflectron_off, "MS:1000105", "reflectron off", "Reflectron is off.", false},
    {MS_reflectron_on, "MS:1000106", "reflectron on", "Reflectron is on.", false},
    {MS_channeltron, "MS:1000107", "channeltron", "A horn-shaped (or cone-shaped) continuous dynode particle multiplier. The ion strikes the inner surface of the device and induces the production of secondary electrons that in turn impinge on the inner surfaces to produce more secondary electrons. This avalanche effect produces an increase in signal in the final measured current pulse.", false},
    {MS_conversion_dynode_electron_multiplier, "MS:1000108", "conversion dynode electron multiplier", "A surface that is held at high potential so that ions striking the surface produce electrons that are subsequently detected.", false},
    {MS_conversion_dynode_photomultiplier, "MS:1000109", "conversion dynode photomultiplier", "A detector in which ions strike a conversion dynode to produce electrons that in turn generate photons through a phosphorescent screen that are detected by a photomultiplier.", false},
    {MS_daly_detector, "MS:1000110", "daly detector", "Detector consisting of a conversion dynode, scintillator and photomultiplier. The metal knob at high potential emits secondary electrons when ions impinge on the surface. The secondary electrons are accelerated onto the scintillator that produces light that is then detected by the photomultiplier detector.", false},
    {MS_electron_multiplier_tube, "MS:1000111", "electron multiplier tube", "A device to amplify the current of a beam or packet of charged particles or photons by incidence upon the surface of an electrode to produce secondary electrons.", false},
    {MS_faraday_cup, "MS:1000112", "faraday cup", "A conducting cup or chamber that intercepts a charged particle beam and is electrically connected to a current measuring device.", false},
    {MS_focal_plane_array, "MS:1000113", "focal plane array", "An array of detectors for spatially disperse ion beams in which all ions simultaneously impinge on the detector plane.", false},
    {MS_microchannel_plate_detector, "MS:1000114", "microchannel plate detector", "A thin plate that contains a closely spaced array of channels that each act as a continuous dynode particle multiplier. A charged particle, fast neutral particle, or photon striking the plate causes a cascade of secondary electrons that ultimately exits the opposite side of the plate.", false},
    {MS_multi_collector, "MS:1000115", "multi-collector", "A detector system commonly used in inductively coupled plasma mass spectrometers.", false},
    {MS_photomultiplier, "MS:1000116", "photomultiplier", "A detector for conversion of the ion/electron signal into photon(s) which are then amplified and detected.", false},
    {MS_analog_digital_converter, "MS:1000117", "analog-digital converter", "Analog-to-digital converter (abbreviated ADC, A/D or A to D) is an electronic integrated circuit (i/c) that converts continuous signals to discrete digital numbers.", false},
    {MS_pulse_counting, "MS:1000118", "pulse counting", "Definition to do.", false},
    {MS_time_digital_converter, "MS:1000119", "time-digital converter", "A device for converting a signal of sporadic pluses into a digital representation of their time indices.", false},
    {MS_transient_recorder, "MS:1000120", "transient recorder", "A detector acquisition mode used for detecting transient signals.", false},
    {MS_SCIEX_instrument_model, "MS:1000121", "SCIEX instrument model", "The brand of instruments from the joint venture between Applied Biosystems and MDS Analytical Technologies (formerly MDS SCIEX). Previously branded as \\\"Applied Biosystems|MDS SCIEX\\\".", false},
    {MS_Bruker_Daltonics_instrument_model, "MS:1000122", "Bruker Daltonics instrument model", "Bruker Daltonics' instrument model.", false},
    {MS_IonSpec_instrument_model, "MS:1000123", "IonSpec instrument model", "IonSpec corporation instrument model.", false},
    {MS_Shimadzu_instrument_model, "MS:1000124", "Shimadzu instrument model", "Shimadzu corporation instrument model.", false},
    {MS_Thermo_Finnigan_instrument_model, "MS:1000125", "Thermo Finnigan instrument model", "ThermoFinnigan from Thermo Electron Corporation instrument model.", false},
    {MS_Waters_instrument_model, "MS:1000126", "Waters instrument model", "Waters Corporation instrument model.", false},
    {MS_centroid_spectrum, "MS:1000127", "centroid spectrum", "Processing of profile data to produce spectra that contains discrete peaks of zero width. Often used to reduce the size of dataset.", false},
    {MS_profile_spectrum, "MS:1000128", "profile spectrum", "A profile mass spectrum is created when data is recorded with ion current (counts per second) on one axis and mass/charge ratio on another axis.", false},
    {MS_negative_scan, "MS:1000129", "negative scan", "Polarity of the scan is negative.", false},
    {MS_positive_scan, "MS:1000130", "positive scan", "Polarity of the scan is positive.", false},
    {MS_number_of_detector_counts, "MS:1000131", "number of detector counts", "The number of counted events observed in one or a group of elements of a detector.", false},
    {MS_percent_of_base_peak, "MS:1000132", "percent of base peak", "The magnitude of a peak or measurement element expressed in terms of the percentage of the magnitude of the base peak intensity.", false},
    {MS_collision_induced_dissociation, "MS:1000133", "collision-induced dissociation", "The dissociation of an ion after collisional excitation. The term collisional-activated dissociation is not recommended.", false},
    {MS_plasma_desorption, "MS:1000134", "plasma desorption", "The ionization of material in a solid sample by bombarding it with ionic or neutral atoms formed as a result of the fission of a suitable nuclide, typically 252Cf. Synonymous with fission fragment ionization.", false},
    {MS_post_source_decay, "MS:1000135", "post-source decay", "A technique specific to reflectron time-of-flight mass spectrometers where product ions of metastable transitions or collision-induced dissociations generated in the drift tube prior to entering the reflectron are m/z separated to yield product ion spectra.", false},
    {MS_surface_induced_dissociation, "MS:1000136", "surface-induced dissociation", "Fragmentation that results from the collision of an ion with a surface.", false},
    {MS_electron_volt_OBSOLETE, "MS:1000137", "electron volt", "A non-SI unit of energy (eV) defined as the energy acquired by a particle containing one unit of charge through a potential difference of one volt. An electron-volt is equal to 1.602 176 53(14) x 10^-19 J.", true},
    {MS_normalized_collision_energy, "MS:1000138", "normalized collision energy", "Instrument setting, expressed in percent, for adjusting collisional energies of ions in an effort to provide equivalent excitation of all ions.", false},
    {MS_4000_QTRAP, "MS:1000139", "4000 QTRAP", "Applied Biosystems/MDS SCIEX Q 4000 TRAP MS.", false},
    {MS_4700_Proteomics_Analyzer, "MS:1000140", "4700 Proteomics Analyzer", "Applied Biosystems/MDS SCIEX 4700 Proteomics Analyzer MS.", false},
    {MS_apex_IV, "MS:1000141", "apex IV", "Bruker Daltonics' apex IV: ESI, MALDI, Nanospray, APCI, APPI, Qh-FT_ICR.", false},
    {MS_apex_Q, "MS:1000142", "apex Q", "Bruker Daltonics' apex Q: ESI, MALDI, Nanospray, APCI, APPI, Qh-FT_ICR.", false},
    {MS_API_150EX, "MS:1000143", "API 150EX", "Applied Biosystems/MDS SCIEX API 150EX MS.", false},
    {MS_API_150EX_Prep, "MS:1000144", "API 150EX Prep", "Applied Biosystems/MDS SCIEX API 150EX Prep MS.", false},
    {MS_API_2000, "MS:1000145", "API 2000", "Applied Biosystems/MDS SCIEX API 2000 MS.", false},
    {MS_API_3000, "MS:1000146", "API 3000", "Applied Biosystems/MDS SCIEX API 3000 MS.", false},
    {MS_API_4000, "MS:1000147", "API 4000", "Applied Biosystems/MDS SCIEX API 4000 MS.", false},
    {MS_autoflex_II, "MS:1000148", "autoflex II", "Bruker Daltonics' autoflex II: MALDI TOF.", false},
    {MS_autoflex_TOF_TOF, "MS:1000149", "autoflex TOF/TOF", "Bruker Daltonics' autoflex TOF/TOF MS: MALDI TOF.", false},
    {MS_Auto_Spec_Ultima_NT, "MS:1000150", "Auto Spec Ultima NT", "Waters magnetic sector based AutoSpec Ultima NT MS.", false},
    {MS_BioTOF_II, "MS:1000151", "BioTOF II", "Bruker Daltonics' BioTOF II: ESI TOF.", false},
    {MS_BioTOF_Q, "MS:1000152", "BioTOF-Q", "Bruker Daltonics' BioTOF-Q: ESI Q-TOF.", false},
    {MS_DELTA_plusAdvantage, "MS:1000153", "DELTA plusAdvantage", "ThermoFinnigan DELTA plusAdvantage MS.", false},
    {MS_DELTAplusXP, "MS:1000154", "DELTAplusXP", "ThermoFinnigan DELTAplusXP MS.", false},
    {MS_ELEMENT2_OBSOLETE, "MS:1000155", "ELEMENT2", "ThermoFinnigan ELEMENT2 MS.", true},
    {MS_esquire_4000, "MS:1000156", "esquire 4000", "Bruker Daltonics' esquire 4000: linear ion trap, ESI, MALDI, Nanospray, APCI, APPI.", false},
    {MS_esquire_6000, "MS:1000157", "esquire 6000", "Bruker Daltonics' esquire 6000: linear ion trap, ESI, MALDI, Nanospray, APCI, APPI.", false},
    {MS_explorer, "MS:1000158", "explorer", "IonSpec Explorer MS.", false},
    {MS_GCT, "MS:1000159", "GCT", "Waters oa-ToF based GCT.", false},
    {MS_HCT, "MS:1000160", "HCT", "Bruker Daltonics' HCT: ESI Q-TOF, Nanospray, APCI, APPI.", false},
    {MS_HCTplus, "MS:1000161", "HCTplus", "Bruker Daltonics' HCTplus: ESI Q-TOF, Nanospray, APCI, APPI.", false},
    {MS_HiRes_ESI, "MS:1000162", "HiRes ESI", "IonSpec HiResESI MS.", false},
    {MS_HiRes_MALDI, "MS:1000163", "HiRes MALDI", "IonSpec HiResMALDI MS.", false},
    {MS_IsoPrime, "MS:1000164", "IsoPrime", "Waters IsoPrime MS.", false},
    {MS_IsoProbe, "MS:1000165", "IsoProbe", "Waters IsoProbe MS.", false},
    {MS_IsoProbe_T, "MS:1000166", "IsoProbe T", "Waters IsoProbe T MS.", false},
    {MS_LCQ_Advantage, "MS:1000167", "LCQ Advantage", "ThermoFinnigan LCQ Advantage MS.", false},
    {MS_LCQ_Classic, "MS:1000168", "LCQ Classic", "ThermoFinnigan LCQ Classic MS.", false},
    {MS_LCQ_Deca_XP_Plus, "MS:1000169", "LCQ Deca XP Plus", "ThermoFinnigan LCQ Deca XP Plus MS.", false},
    {MS_M_LDI_L, "MS:1000170", "M@LDI L", "Waters oa-ToF based MALDI L.", false},
    {MS_M_LDI_LR, "MS:1000171", "M@LDI LR", "Waters oa-ToF based MALDI LR.", false},
    {MS_MAT253, "MS:1000172", "MAT253", "ThermoFinnigan MAT253 MS.", false},
    {MS_MAT900XP, "MS:1000173", "MAT900XP", "ThermoFinnigan MAT900XP MS.", false},
    {MS_MAT900XP_Trap, "MS:1000174", "MAT900XP Trap", "ThermoFinnigan MAT900XP Trap MS.", false},
    {MS_MAT95XP, "MS:1000175", "MAT95XP", "ThermoFinnigan MAT95XP MS.", false},
    {MS_MAT95XP_Trap, "MS:1000176", "MAT95XP Trap", "ThermoFinnigan MAT95XP Trap MS.", false},
    {MS_microflex, "MS:1000177", "microflex", "Bruker Daltonics' microflex: MALDI TOF.", false},
    {MS_microTOF_LC, "MS:1000178", "microTOF LC", "Bruker Daltonics' microTOF LC: ESI TOF, Nanospray, APCI, APPI.", false},
    {MS_neptune, "MS:1000179", "neptune", "ThermoFinnigan NEPTUNE MS.", false},
    {MS_NG_5400, "MS:1000180", "NG-5400", "Waters NG-5400 MS.", false},
    {MS_OMEGA, "MS:1000181", "OMEGA", "IonSpec OMEGA MS.", false},
    {MS_OMEGA_2001, "MS:1000182", "OMEGA-2001", "IonSpec OMEGA-2001 MS.", false},
    {MS_OmniFlex, "MS:1000183", "OmniFlex", "Bruker Daltonics' OmniFlex: MALDI TOF.", false},
    {MS_Platform_ICP, "MS:1000184", "Platform ICP", "Waters Platform ICP MS.", false},
    {MS_PolarisQ, "MS:1000185", "PolarisQ", "ThermoFinnigan PolarisQ MS.", false},
    {MS_proteomics_solution_1, "MS:1000186", "proteomics solution 1", "Applied Biosystems/MDS SCIEX Proteomics Solution 1 MS.", false},
    {MS_Q_TRAP, "MS:1000187", "Q TRAP", "Applied Biosystems/MDS SCIEX Q TRAP MS.", false},
    {MS_Q_Tof_micro, "MS:1000188", "Q-Tof micro", "Waters oa-ToF based Q-Tof micro.", false},
    {MS_Q_Tof_Ultima, "MS:1000189", "Q-Tof Ultima", "Waters oa-ToF based Q-Tof Ultima.", false},
    {MS_QSTAR, "MS:1000190", "QSTAR", "Applied Biosystems/MDS SCIEX QSTAR MS.", false},
    {MS_quattro_micro, "MS:1000191", "quattro micro", "Waters (triple) quadrupole based micro.", false},
    {MS_Quattro_Ultima, "MS:1000192", "Quattro Ultima", "Waters (triple) quadrupole based Ultima.", false},
    {MS_Surveyor_MSQ, "MS:1000193", "Surveyor MSQ", "ThermoFinnigan Surveyor MSQ MS.", false},
    {MS_SymBiot_I, "MS:1000194", "SymBiot I", "Applied Biosystems/MDS SCIEX SymBiot I MS.", false},
    {MS_SymBiot_XVI, "MS:1000195", "SymBiot XVI", "Applied Biosystems/MDS SCIEX SymBiot XVI MS.", false},
    {MS_TEMPUS_TOF, "MS:1000196", "TEMPUS TOF", "ThermoFinnigan TEMPUS TOF MS.", false},
    {MS_TRACE_DSQ, "MS:1000197", "TRACE DSQ", "ThermoFinnigan TRACE DSQ MS.", false},
    {MS_TRITON, "MS:1000198", "TRITON", "ThermoFinnigan TRITON MS.", false},
    {MS_TSQ_Quantum, "MS:1000199", "TSQ Quantum", "ThermoFinnigan TSQ Quantum MS.", false},
    {MS_ultima, "MS:1000200", "ultima", "IonSpec Ultima MS.", false},
    {MS_ultraflex, "MS:1000201", "ultraflex", "Bruker Daltonics' ultraflex: MALDI TOF.", false},
    {MS_ultraflex_TOF_TOF, "MS:1000202", "ultraflex TOF/TOF", "Bruker Daltonics' ultraflex TOF/TOF: MALDI TOF.", false},
    {MS_Voyager_DE_PRO, "MS:1000203", "Voyager-DE PRO", "Applied Biosystems/MDS SCIEX Voyager-DE PRO MS.", false},
    {MS_Voyager_DE_STR, "MS:1000204", "Voyager-DE STR", "Applied Biosystems/MDS SCIEX Voyager-DE STR MS.", false},
    {MS_selected_ion_monitoring, "MS:1000205", "selected ion monitoring", "The operation of a mass spectrometer in which the intensities of several specific m/z values are recorded rather than the entire mass spectrum.", false},
    {MS_selected_reaction_monitoring, "MS:1000206", "selected reaction monitoring", "Data acquired from specific product ions corresponding to m/z selected precursor ions recorded via multiple stages of mass spectrometry. Selected reaction monitoring can be performed in time or in space.", false},
    {MS_accurate_mass_OBSOLETE, "MS:1000207", "accurate mass", "An experimentally determined mass that is can be to determine a unique elemental formula. For ions less than 200 u, a measurement with 5 ppm accuracy is sufficient to determine the elemental composition.", true},
    {MS_average_mass_OBSOLETE, "MS:1000208", "average mass", "The mass of an ion or molecule calculated using the average mass of each element weighted for its natural isotopic abundance.", true},
    {MS_appearance_energy_OBSOLETE, "MS:1000209", "appearance energy", "The minimum energy that must be imparted to an atom or molecule to produce a specified ion. The term appearance potential is not recommended.", true},
    {MS_base_peak, "MS:1000210", "base peak", "The peak in a mass spectrum that has the greatest intensity. This term may be applied to the spectra of pure substances or mixtures.", false},
    {MS_OBSOLETE_charge_number_OBSOLETE, "MS:1000211", "OBSOLETE charge number", "The total charge on an ion divided by the electron charge e. OBSOLETED 2009-10-27 since this was viewed as a duplication of 00041 charge state.", true},
    {MS_dalton_OBSOLETE, "MS:1000212", "dalton", "A non-SI unit of mass (symbol Da) that is equal to the unified atomic mass unit: 1.660 538 86(28) x 10^-27 kg.", true},
    {MS_electron_affinity_OBSOLETE, "MS:1000213", "electron affinity", "The electron affinity of M is the minimum energy required for the process M- ? M + e where M- and M are in their ground rotational, vibrational and electronic states and the electron has zero kinetic energy.", true},
    {MS_electron_energy_obsolete_OBSOLETE, "MS:1000214", "electron energy obsolete", "The potential difference through which electrons are accelerated before they are used to bring about electron ionization.", true},
    {MS_exact_mass_OBSOLETE, "MS:1000215", "exact mass", "The calculated mass of an ion or molecule containing a single isotope of each atom.", true},
    {MS_field_free_region, "MS:1000216", "field-free region", "A section of a mass spectrometer in which there are no electric or magnetic fields.", false},
    {MS_ionization_cross_section_OBSOLETE, "MS:1000217", "ionization cross section", "A measure of the probability that a given ionization process will occur when an atom or molecule interacts with a photon, electron, atom or molecule.", true},
    {MS_ionization_efficiency_OBSOLETE, "MS:1000218", "ionization efficiency", "The ratio of the number of ions formed to the number of electrons, molecules or photons used.", true},
    {MS_ionization_energy_OBSOLETE, "MS:1000219", "ionization energy", "The minimum energy required to remove an electron from an atom or molecule to produce a positive ion.", true},
    {MS_isotope_dilution_mass_spectrometry_OBSOLETE, "MS:1000220", "isotope dilution mass spectrometry", "A quantitative mass spectrometry technique in which an isotopically enriched compound is used as an internal standard.", true},
    {MS_magnetic_deflection, "MS:1000221", "magnetic deflection", "The deflection of charged particles in a magnetic field due to a force equal to qvxB where q is the particle charge, v its velocity and B the magnetic field. Magnetic deflection of an ion beam is used for m/z separation in a magnetic sector mass spectrometer.", false},
    {MS_mass_defect_OBSOLETE, "MS:1000222", "mass defect", "The difference between the monoisotopic and nominal mass of a molecule or atom.", true},
    {MS_mass_number_OBSOLETE, "MS:1000223", "mass number", "The sum of the protons and neutrons in an atom, molecule or ion.", true},
    {MS_molecular_mass, "MS:1000224", "molecular mass", "Mass of a molecule measured in unified atomic mass units (u or Da).", false},
    {MS_monoisotopic_mass_OBSOLETE, "MS:1000225", "monoisotopic mass", "The mass of an ion or molecule calculated using the mass of the most abundant isotope of each element.", true},
    {MS_molecular_beam_mass_spectrometry_OBSOLETE, "MS:1000226", "molecular beam mass spectrometry", "A mass spectrometry technique in which the sample is introduced into the mass spectrometer as a molecular beam.", true},
    {MS_multiphoton_ionization, "MS:1000227", "multiphoton ionization", "Photoionization of an atom or molecule in which in two or more photons are absorbed.", false},
    {MS_nitrogen_rule_OBSOLETE, "MS:1000228", "nitrogen rule", "An organic molecule containing the elements C, H, O, S, P, or halogen has an odd nominal mass if it contains an odd number of nitrogen atoms.", true},
    {MS_nominal_mass_OBSOLETE, "MS:1000229", "nominal mass", "The mass of an ion or molecule calculated using the mass of the most abundant isotope of each element rounded to the nearest integer value.", true},
    {MS_odd_electron_rule_OBSOLETE, "MS:1000230", "odd-electron rule", "Odd-electron ions may dissociate to form either odd or even-electron ions, whereas even-electron ions generally form even-electron fragment ions.", true},
    {MS_peak, "MS:1000231", "peak", "A localized region of relatively large ion signal in a mass spectrum. Although peaks are often associated with particular ions, the terms peak and ion should not be used interchangeably.", false},
    {MS_peak_intensity_OBSOLETE, "MS:1000232", "peak intensity", "The height or area of a peak in a mass spectrum.", true},
    {MS_proton_affinity_OBSOLETE, "MS:1000233", "proton affinity", "The proton affinity of a species M is defined as the negative of the enthalpy change for the reaction M + H+ ->[M+H]+, where all species are in their ground rotational, vibrational and electronic states.", true},
    {MS_mass_resolving_power_OBSOLETE, "MS:1000234", "mass resolving power", "In a mass spectrum, the observed mass divided by the difference between two masses that can be separated. The method by which delta m was obtained and the mass at which the measurement was made should be reported.", true},
    {MS_total_ion_current_chromatogram, "MS:1000235", "total ion current chromatogram", "Representation of the total ion current detected in each of a series of mass spectra versus time.", false},
    {MS_transmission, "MS:1000236", "transmission", "The ratio of the number of ions leaving a region of a mass spectrometer to the number entering that region.", false},
    {MS_unified_atomic_mass_unit_OBSOLETE, "MS:1000237", "unified atomic mass unit", "A non-SI unit of mass (u) defined as one twelfth of ^12 C in its ground state and equal to 1.660 538 86(28) x 10^-27 kg.", true},
    {MS_accelerator_mass_spectrometry_OBSOLETE, "MS:1000238", "accelerator mass spectrometry", "A mass spectrometry technique in which atoms extracted from a sample are ionized, accelerated to MeV energies and separated according to their momentum, charge and energy.", true},
    {MS_atmospheric_pressure_matrix_assisted_laser_desorption_ionization, "MS:1000239", "atmospheric pressure matrix-assisted laser desorption ionization", "Matrix-assisted laser desorption ionization in which the sample target is at atmospheric pressure and the ions formed by the pulsed laser are sampled through a small aperture into the mass spectrometer.", false},
    {MS_atmospheric_pressure_ionization, "MS:1000240", "atmospheric pressure ionization", "Any ionization process in which ions are formed in the gas phase at atmospheric pressure.", false},
    {MS_Atmostpheric_Pressure_Photoionization_OBSOLETE, "MS:1000241", "Atmostpheric Pressure Photoionization", "Atmospheric pressure chemical ionization in which the reactant ions are generated by photo-ionization.", true},
    {MS_blackbody_infrared_radiative_dissociation, "MS:1000242", "blackbody infrared radiative dissociation", "A special case of infrared multiphoton dissociation wherein excitation of the reactant ion is caused by absorption of infrared photons radiating from heated blackbody surroundings, which are usually the walls of a vacuum chamber. See also infrared multiphoton dissociation.", false},
    {MS_charge_remote_fragmentation_OBSOLETE, "MS:1000243", "charge-remote fragmentation", "A fragmentation of an even-electron ion in which the cleaved bond is not adjacent to the apparent charge site.", true},
    {MS_consecutive_reaction_monitoring_OBSOLETE_1000244, "MS:1000244", "consecutive reaction monitoring (MS:1000244)", "MSn experiment with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.", true},
    {MS_charge_stripping, "MS:1000245", "charge stripping", "The reaction of a positive ion with an atom or molecule that results in the removal of one or more electrons from the ion.", false},
    {MS_delayed_extraction, "MS:1000246", "delayed extraction", "The application of the accelerating voltage pulse after a time delay in desorption ionization from a surface. The extraction delay can produce energy focusing in a time-of-flight mass spectrometer.", false},
    {MS_desorption_ionization, "MS:1000247", "desorption ionization", "The formation of ions from a solid or liquid material after the rapid vaporization of that sample.", false},
    {MS_direct_insertion_probe, "MS:1000248", "direct insertion probe", "A device for introducing a solid or liquid sample into a mass spectrometer ion source for desorption ionization.", false},
    {MS_direct_liquid_introduction, "MS:1000249", "direct liquid introduction", "The delivery of a liquid sample into a mass spectrometer for spray or desorption ionization.", false},
    {MS_electron_capture_dissociation, "MS:1000250", "electron capture dissociation", "A process in which a multiply protonated molecules interacts with a low energy electrons. Capture of the electron leads the liberation of energy and a reduction in charge state of the ion with the production of the (M + nH) (n-1)+ odd electron ion, which readily fragments.", false},
    {MS_even_electron_ion_OBSOLETE, "MS:1000251", "even-electron ion", "An ion containing no unpaired electrons in its ground electronic state, e.g. CH3+ in its ground state.", true},
    {MS_electron_induced_excitation_in_organics_OBSOLETE, "MS:1000252", "electron-induced excitation in organics", "The reaction of an ion with an electron in which the translational energy of the collision is converted into internal energy of the ion.", true},
    {MS_electron_multiplier, "MS:1000253", "electron multiplier", "A device to amplify the current of a beam or packet of charged particles or photons by incidence upon the surface of an electrode to produce secondary electrons. The secondary electrons are then accelerated to other electrodes or parts of a continuous electrode to produce further secondary electrons.", false},
    {MS_electrostatic_energy_analyzer, "MS:1000254", "electrostatic energy analyzer", "A device consisting of conducting parallel plates, concentric cylinders or concentric spheres that separates charged particles according to their kinetic energy by means of an electric field that is constant in time.", false},
    {MS_flowing_afterglow, "MS:1000255", "flowing afterglow", "An ion source immersed in a flow of helium or other inert buffer gas that carries the ions through a meter-long reactor at pressures around 100 Pa.", false},
    {MS_high_field_asymmetric_waveform_ion_mobility_spectrometry_OBSOLETE, "MS:1000256", "high-field asymmetric waveform ion mobility spectrometry", "The separation of ions between two concentric cylindrical electrodes due to application of a high voltage asymmetric waveform whereby ions migrate towards one of the two electrodes depending on the ratio of the high- to low-field mobility of the ion.", true},
    {MS_field_desorption, "MS:1000257", "field desorption", "The formation of gas-phase ions from a material deposited on a solid surface in the presence of a high electric field. Because this process may encompass ionization by field ionization or other mechanisms, it is not recommended as a synonym for field desorption ionization.", false},
    {MS_field_ionization, "MS:1000258", "field ionization", "The removal of electrons from any species by interaction with a high electric field.", false},
    {MS_glow_discharge_ionization, "MS:1000259", "glow discharge ionization", "The formation of ions in the gas phase and from solid samples at the cathode by application of a voltage to a low pressure gas.", false},
    {MS_ion_kinetic_energy_spectrometry_OBSOLETE, "MS:1000260", "ion kinetic energy spectrometry", "A method of analysis in which a beam of ions is separated according to the ratio of its translational energy to charge.", true},
    {MS_ion_mobility_spectrometry_OBSOLETE, "MS:1000261", "ion mobility spectrometry", "The separation of ions according to their velocity through a buffer gas under the influence of an electric field.", true},
    {MS_infrared_multiphoton_dissociation, "MS:1000262", "infrared multiphoton dissociation", "Multiphoton ionization where the reactant ion dissociates as a result of the absorption of multiple infrared photons.", false},
    {MS_isotope_ratio_mass_spectrometry_OBSOLETE, "MS:1000263", "isotope ratio mass spectrometry", "The measurement of the relative quantity of the different isotopes of an element in a material with a mass spectrometer.", true},
    {MS_ion_trap, "MS:1000264", "ion trap", "A device for spatially confining ions using electric and magnetic fields alone or in combination.", false},
    {MS_kinetic_energy_release_distribution_OBSOLETE, "MS:1000265", "kinetic energy release distribution", "Distribution of values of translational kinetic energy release for an ensemble of metastable ions undergoing a specific dissociation reaction.", true},
    {MS_Laser_Desorption_OBSOLETE, "MS:1000266", "Laser Desorption", "The formation of ions through the interaction of a laser with a material or with gas-phase ions or molecules.", true},
    {MS_mass_analyzed_ion_kinetic_energy_spectrometry_OBSOLETE, "MS:1000267", "mass analyzed ion kinetic energy spectrometry", "Spectra that are obtained from a sector mass spectrometer that incorporates at least one magnetic sector plus one electric sector in reverse geometry. The accelerating voltage, V, and the magnetic sector field, B, are set at fixed values to select the precursor ions, which are then allowed to dissociate or to react in a field free region between the two sectors. The kinetic energy product ions of m/z selected precursor ions is analyzed by scanning the electric sector field, E. The width of the product ion spectrum peaks is related to the kinetic energy release distribution (KERD) for the dissociation process.", true},
    {MS_mass_spectrometry_OBSOLETE, "MS:1000268", "mass spectrometry", "The branch of science that deals with all aspects of mass spectrometers and the results obtained with these instruments.", true},
    {MS_mass_spectrometry_mass_spectrometry_OBSOLETE, "MS:1000269", "mass spectrometry/mass spectrometry", "The acquisition, study and spectra of the electrically charged products or precursors of a m/z selected ion or ions.", true},
    {MS_multiple_stage_mass_spectrometry_OBSOLETE, "MS:1000270", "multiple stage mass spectrometry", "Multiple stages of precursor ion m/z selection followed by product ion detection for successive progeny ions.", true},
    {MS_Negative_Ion_chemical_ionization, "MS:1000271", "Negative Ion chemical ionization", "Chemical ionization that results in the formation of negative ions.", false},
    {MS_neutralization_reionization_mass_spectrometry, "MS:1000272", "neutralization reionization mass spectrometry", "With this technique, m/z selected ions form neutrals by charge transfer to a collision gas or by dissociation. The neutrals are separated from the remaining ions and ionized in collisions with a second gas. This method is used to investigate reaction intermediates and other unstable species.", false},
    {MS_photoionization, "MS:1000273", "photoionization", "The ionization of an atom or molecule by a photon, written M + h? ? M^+ + e. The term photon impact is not recommended.", false},
    {MS_pyrolysis_mass_spectrometry, "MS:1000274", "pyrolysis mass spectrometry", "A mass spectrometry technique in which the sample is heated to the point of decomposition and the gaseous decomposition products are introduced into the ion source.", false},
    {MS_collision_quadrupole, "MS:1000275", "collision quadrupole", "A transmission quadrupole to which an oscillating potential is applied so as to focus a beam of ions through a collision gas with no m/z separation.", false},
    {MS_resonance_enhanced_multiphoton_ionization, "MS:1000276", "resonance enhanced multiphoton ionization", "Multiphoton ionization in which the ionization cross section is significantly enhanced because the energy of the incident photons is resonant with an intermediate excited state of the neutral species.", false},
    {MS_residual_gas_analyzer_OBSOLETE, "MS:1000277", "residual gas analyzer", "A mass spectrometer used to measure the composition and pressure of gasses in an evacuated chamber.", true},
    {MS_surface_enhanced_laser_desorption_ionization, "MS:1000278", "surface enhanced laser desorption ionization", "The formation of ionized species in the gas phase from analytes deposited on a particular surface substrate which is irradiated with a laser beam of which wavelength is absorbed by the surface. See also desorption/ionization on silicon and laser desorption/ionization.", false},
    {MS_surface_enhanced_neat_desorption, "MS:1000279", "surface enhanced neat desorption", "Matrix-assisted laser desorption ionization in which the matrix is covalently linked to the target surface.", false},
    {MS_suface_ionization_OBSOLETE, "MS:1000280", "suface ionization", "The ionization of a neutral species when it interacts with a solid surface with an appropriate work function and temperature.", true},
    {MS_selected_ion_flow_tube, "MS:1000281", "selected ion flow tube", "A device in which m/z selected ions are entrained in an inert carrier gas and undergo ion-molecule reactions.", false},
    {MS_sustained_off_resonance_irradiation, "MS:1000282", "sustained off-resonance irradiation", "A technique associated with Fourier transform ion cyclotron resonance (FT-ICR) mass spectrometry to carry out ion/neutral reactions such as low-energy collision-induced dissociation. A radio-frequency electric field of slightly off-resonance to the cyclotron frequency of the reactant ion cyclically accelerates and decelerates the reactant ion that is confined in the Penning ion trap. The ion's orbit does not exceed the dimensions of ion trap while the ion undergoes an ion/neutral species process that produces a high average translational energy for an extended time.", false},
    {MS_Spark_Source_Mass_Spectrometry_OBSOLETE, "MS:1000283", "Spark Source Mass Spectrometry", "Mass spectrometry using spark ionization.", true},
    {MS_stored_waveform_inverse_fourier_transform, "MS:1000284", "stored waveform inverse fourier transform", "A technique to create excitation waveforms for ions in FT-ICR mass spectrometer or Paul ion trap. An excitation waveform in the time-domain is generated by taking the inverse Fourier transform of an appropriate frequency-domain programmed excitation spectrum, in which the resonance frequencies of ions to be excited are included. This technique may be used for selection of precursor ions in MS2 experiments.", false},
    {MS_total_ion_current, "MS:1000285", "total ion current", "The sum of all the separate ion currents carried by the ions of different m/z contributing to a complete mass spectrum or in a specified m/z range of a mass spectrum.", false},
    {MS_time_lag_focusing, "MS:1000286", "time lag focusing", "Energy focusing in a time-of-flight mass spectrometer that is accomplished by introducing a time delay between the formation of the ions and the application of the accelerating voltage pulse.", false},
    {MS_time_of_flight_mass_spectrometer_OBSOLETE, "MS:1000287", "time-of-flight mass spectrometer", "An instrument that separates ions by m/z in a field-free region after acceleration to a fixed kinetic energy.", true},
    {MS_cyclotron, "MS:1000288", "cyclotron", "A device that uses an oscillating electric field and magnetic field to accelerate charged particles.", false},
    {MS_double_focusing_mass_spectrometer_OBSOLETE, "MS:1000289", "double-focusing mass spectrometer", "A mass spectrometer that uses a magnetic sector for m/z focusing and an electric sector for energy focusing of an ion beam.", true},
    {MS_hybrid_mass_spectrometer_OBSOLETE, "MS:1000290", "hybrid mass spectrometer", "A mass spectrometer that combines m/z analyzers of different types to perform tandem mass spectrometry.", true},
    {MS_linear_ion_trap, "MS:1000291", "linear ion trap", "A two dimensional Paul ion trap in which ions are confined in the axial dimension by means of an electric field at the ends of the trap.", false},
    {MS_mass_spectrograph_obsolete_OBSOLETE, "MS:1000292", "mass spectrograph obsolete", "An instrument that separates a beam of ions according to their mass-to-charge ratio in which the ions are directed onto a focal plane detector such as a photographic plate.", true},
    {MS_mass_spectrometer_OBSOLETE, "MS:1000293", "mass spectrometer", "An instrument that measures the mass-to-charge ratio and relative abundances of ions.", true},
    {MS_mass_spectrum, "MS:1000294", "mass spectrum", "A plot of the relative abundance of a beam or other collection of ions as a function of the mass-to-charge ratio (m/z).", false},
    {MS_mattauch_herzog_geometry_OBSOLETE, "MS:1000295", "mattauch-herzog geometry", "An arrangement for a double-focusing mass spectrometer in which a deflection of ?/(4 ?(2)) radians in a radial electric field is followed by a magnetic deflection of ?/2 radians.", true},
    {MS_nier_johnson_geometry_OBSOLETE, "MS:1000296", "nier-johnson geometry", "An arrangement for a double-focusing mass spectrometer in which a deflection of ?/2 radians in a radial electric field analyzer is followed by a magnetic deflection of ?/3 radians.", true},
    {MS_paul_ion_trap_OBSOLETE, "MS:1000297", "paul ion trap", "A device that permits the trapping of ions by means of an alternating current voltage. The ejection of ions with a m/z less than a prescribed value and retention of those with higher mass depends on the application of radio frequency voltages between a ring electrode and two end-cap electrodes to confine the ions in a circular path. The choice of these voltages determines the m/z below which ions are ejected.", true},
    {MS_prolate_traochoidal_mass_spectrometer_OBSOLETE, "MS:1000298", "prolate traochoidal mass spectrometer", "A mass spectrometer in which the ions of different m/z are separated by means of crossed electric and magnetic fields in such a way that the selected ions follow a prolate trochoidal path.", true},
    {MS_quistor_OBSOLETE, "MS:1000299", "quistor", "An abbreviation of quadrupole ion storage trap. This term is synonymous with Paul Ion Trap. If so then add a synonym to paul and obsolete this term.", true},
    {MS_reflectron, "MS:1000300", "reflectron", "A time-of-flight mass spectrometer that uses a static electric field to reverse the direction of travel of the ions entering it. A reflectron improves mass resolution by assuring that ions of the same m/z but different kinetic energy arrive at the detector at the same time.", false},
    {MS_sector_mass_spectrometer_OBSOLETE, "MS:1000301", "sector mass spectrometer", "A mass spectrometer consisting of one or more magnetic sectors for m/z selection in a beam of ions. Such instruments may also have one or more electric sectors for energy selection.", true},
    {MS_tandem_mass_spectrometer_OBSOLETE, "MS:1000302", "tandem mass spectrometer", "A mass spectrometer designed for mass spectrometry/mass spectrometry.", true},
    {MS_transmission_quadrupole_mass_spectrometer_OBSOLETE, "MS:1000303", "transmission quadrupole mass spectrometer", "A mass spectrometer that consists of four parallel rods whose centers form the corners of a square and whose opposing poles are connected. The voltage applied to the rods is a superposition of a static potential and a sinusoidal radio frequency potential. The motion of an ion in the x and y dimensions is described by the Matthieu equation whose solutions show that ions in a particular m/z range can be transmitted along the z axis.", true},
    {MS_accelerating_voltage, "MS:1000304", "accelerating voltage", "The electrical potential used to impart kinetic energy to ions in a mass spectrometer.", false},
    {MS_cyclotron_motion_OBSOLETE, "MS:1000305", "cyclotron motion", "The circular motion of a charged particle moving at velocity v in a magnetic field B that results from the force qvB.", true},
    {MS_dynamic_mass_spectrometry_OBSOLETE, "MS:1000306", "dynamic mass spectrometry", "A mass spectrometer in which m/z separation using one or more electric fields that vary with time.", true},
    {MS_einzel_lens, "MS:1000307", "einzel lens", "Three element charged particle lens in which the first and third elements are held at the same voltage. Such a lens produces focusing without changing the translational energy of the particle.", false},
    {MS_electric_field_strength, "MS:1000308", "electric field strength", "The magnitude of the force per unit charge at a given point in space.", false},
    {MS_first_stability_region, "MS:1000309", "first stability region", "The region of a Mathieu stability diagram closest to the origin. Ions within this region can traverse the full length of a transmission quadrupole.", false},
    {MS_fringing_field, "MS:1000310", "fringing field", "The electric or magnetic field that extends from the edge of a sector, lens or other ion optics element.", false},
    {MS_kinetic_energy_analyzer, "MS:1000311", "kinetic energy analyzer", "A device for measuring the kinetic energy of charged particles using a retarding field, time-of-flight, or the extent of deflection in an electric or magnetic field.", false},
    {MS_mass_limit_OBSOLETE, "MS:1000312", "mass limit", "The m/z value above which ions cannot be detected in a mass spectrometer.", true},
    {MS_scan_m_z_range__OBSOLETE, "MS:1000313", "scan m/z range?", "The limit of m/z over which a mass spectrometer can detect ions.", true},
    {MS_mass_selective_axial_ejection_OBSOLETE, "MS:1000314", "mass selective axial ejection", "The use of mass selective instability to eject ions of selected m/z values from an ion trap.", true},
    {MS_mass_selective_instability_OBSOLETE, "MS:1000315", "mass selective instability", "A method for selective ejection of ions according to their m/z value in an ion trap.", true},
    {MS_mathieu_stability_diagram_OBSOLETE, "MS:1000316", "mathieu stability diagram", "A graphical representation expressed in terms of reduced coordinates that describes charged particle motion in a quadrupole mass filter or quadrupole ion trap mass spectrometer.", true},
    {MS_orthogonal_extraction_OBSOLETE, "MS:1000317", "orthogonal extraction", "The pulsed acceleration of ions perpendicular to their direction of travel into a time-of-flight mass spectrometer. Ions may be extracted from a directional ion source, drift tube or m/z separation stage.", true},
    {MS_resonance_ion_ejection_OBSOLETE, "MS:1000318", "resonance ion ejection", "A mode of ion ejection in a quadrupole ion trap that relies on a auxiliary radio frequency voltage that is applied to the end-cap electrodes. The voltage is tuned to the secular frequency of a particular ion to eject it.", true},
    {MS_space_charge_effect, "MS:1000319", "space charge effect", "The mutual repulsion of particles of like charge that limits the current in a charged-particle beam and causes beams or packets of charged particles to expand radially over time.", false},
    {MS_static_field, "MS:1000320", "static field", "An electric or magnetic field that does not change in time.", false},
    {MS_2E_Mass_Spectrum_OBSOLETE, "MS:1000321", "2E Mass Spectrum", "A mass spectrum obtained by setting the electric sector field E to twice the value required to transmit the main ion-beam thereby allowing ions with a kinetic energy-to-charge ratio twice that of the main ion-beam to be transmitted. Product ions resulting from partial charge transfer reactions such as m^2+ + N ? m^+ + N^+ that occur in a collision cell (containing a gas, N) located in a field-free region preceding a magnetic and electric sector combination are detected. When the magnetic sector field B is scanned, a mass spectrum of singly charged product ions of doubly charged precursor ions is obtained.", true},
    {MS_charge_inversion_mass_spectrum, "MS:1000322", "charge inversion mass spectrum", "The measurement of the relative abundance of ions that result from a charge inversion reaction as a function of m/z.", false},
    {MS_constant_neutral_loss_scan_OBSOLETE, "MS:1000323", "constant neutral loss scan", "Spectrum of all precursor ions that undergo a selected m/z decrement.", true},
    {MS_constant_neutral_gain_scan_OBSOLETE, "MS:1000324", "constant neutral gain scan", "Spectrum of all precursor ions that undergo a selected m/z increment.", true},
    {MS_constant_neutral_gain_spectrum, "MS:1000325", "constant neutral gain spectrum", "A spectrum formed of all product ions that have been produced by gain of a pre-selected neutral mass following the reaction with and addition of the gas in a collision cell.", false},
    {MS_constant_neutral_loss_spectrum, "MS:1000326", "constant neutral loss spectrum", "A spectrum formed of all product ions that have been produced with a selected m/z decrement from any precursor ions. The spectrum shown correlates to the precursor ion spectrum. See also neutral loss spectrum.", false},
    {MS_consecutive_reaction_monitoring_OBSOLETE_1000327, "MS:1000327", "consecutive reaction monitoring (MS:1000327)", "A type of MS2 experiments with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.", true},
    {MS_e_2_mass_spectrum, "MS:1000328", "e/2 mass spectrum", "A mass spectrum obtained using a sector mass spectrometer in which the electric sector field E is set to half the value required to transmit the main ion-beam. This spectrum records the signal from doubly charged product ions of charge-stripping reactions.", false},
    {MS_linked_scan_OBSOLETE, "MS:1000329", "linked scan", "A scan in an instrument with two or more m/z analysers or in a sector mass spectrometer that incorporates at least one magnetic sector and one electric sector. Two or more of the analyzers are scanned simultaneously so as to preserve a predetermined relationship between scan parameters to produce a product ion, precursor ion or constant neutral loss spectrum.", true},
    {MS_linked_scan_at_constant_b_e_OBSOLETE, "MS:1000330", "linked scan at constant b/e", "A linked scan at constant B/E may be performed on a sector mass spectrometer that incorporates at least one magnetic sector plus one electric sector. The magnetic field B and the electric field E are scanned simultaneously while the accelerating voltage V is held constant, so as to maintain the ratio of the two fields constant. This linked scan may record a product ion spectrum of dissociation or other reactions occurring in a field free region preceding the two sectors.", true},
    {MS_Linked_Scan_at_Constant_E2_V_OBSOLETE, "MS:1000331", "Linked Scan at Constant E2/V", "A linked scan performed on a sector instrument that incorporates at least one electric sector plus one magnetic sector. The electric sector field, E, and the accelerating voltage, V, are scanned simultaneously, so as to maintain the ratio E2/V at a constant value. This linked scan recordss a product ion spectrum of dissociation or other reactions occurring in a field free region (FFR) preceding the two sectors.", true},
    {MS_Linked_Scan_at_Constant_B2_E_OBSOLETE, "MS:1000332", "Linked Scan at Constant B2/E", "A linked scan performed on a sector mass spectrometer that incorporates at least one electric sector plus one magnetic sector in either order. The accelerating voltage is fixed and the magnetic field, B, and the electric field, E, are scanned simultaneously so as to maintain the ratio B2/E at a constant value. This linked scan records a precursor ion spectrum of dissociation or other reactions occurring in the field free region preceding the two sectors. The term B2/E linked scan is not recommended.", true},
    {MS_Linked_Scan_at_Constant_B_1__E_E0___1_2___E_OBSOLETE, "MS:1000333", "Linked Scan at Constant B[1-(E/E0)]^1/2 / E", "A linked scan performed on a sector instrument that incorporates at least one electric sector plus one magnetic sector placed in either order. The accelerating voltage is fixed while scanning the magnetic field, B, and electric field, E, simultaneously, so as to maintain the quantity B[1-(E/E0)]1/2/E at a constant value. This linked scan records a constant neutral mass loss (or gain) spectrum of dissociation or other reactions occurring in a field free region preceding the two sectors. E0 is the electric field required to transmit the singly charged analog of the desired neutral fragment. The term B[1-(E/E0)]1/2/E linked scan.", true},
    {MS_MS_MS_in_Time_OBSOLETE, "MS:1000334", "MS/MS in Time", "A tandem mass spectrometry method in which product ion spectra are recorded in a single m/z analyzer (such as a Paul Ion Trap or FTMS) in discreet steps over time. Ions in a specific m/z range are selected, dissociated, and the product ions analyzed sequentially in time.", true},
    {MS_MS_MS_in_Space_OBSOLETE, "MS:1000335", "MS/MS in Space", "A tandem mass spectrometry method in which product ion spectra are recorded in m/z analyzers separated in space. Specific m/z separation functions are designed such that in one section of the instrument ions are selected, dissociated in an intermediate region, and the product ions are then transmitted to another analyser for m/z separation and data acquisition.", true},
    {MS_neutral_loss, "MS:1000336", "neutral loss", "The loss of an uncharged species during a rearrangement process. The value slot holds the molecular formula in Hill notation of the neutral loss molecule, see PMID:21182243. This term must be used in conjunction with a child of the term MS:1002307 (fragmentation ion type).", false},
    {MS_nth_generation_product_ion_OBSOLETE, "MS:1000337", "nth generation product ion", "Serial product ions from dissociation of selected precursor ions where n refers to the number of stages of dissociation. The term granddaughter ion is deprecated.", true},
    {MS_nth_generation_product_ion_scan_OBSOLETE, "MS:1000338", "nth generation product ion scan", "The specific scan functions or processes that record the appropriate generation of product ion or ions of any m/z selected precursor ions.", true},
    {MS_nth_generation_product_ion_spectrum_OBSOLETE, "MS:1000339", "nth generation product ion spectrum", "The mass spectrum recorded from any mass spectrometer in which the appropriate scan function can be set to record the appropriate generation product ion or ions of m/z selected precursor ions.", true},
    {MS_precursor_ion_OBSOLETE, "MS:1000340", "precursor ion", "An ion that reacts to form particular product ions. The reaction can be unimolecular dissociation, ion/molecule reaction, isomerization, or change in charge state. The term parent ion is deprecated.", true},
    {MS_precursor_ion_spectrum, "MS:1000341", "precursor ion spectrum", "Spectrum generated by scanning precursor m/z while monitoring a fixed product m/z.", false},
    {MS_product_ion_OBSOLETE, "MS:1000342", "product ion", "An ion formed as the product of a reaction involving a particular precursor ion. The reaction can be unimolecular dissociation to form fragment ions, an ion/molecule reaction, or simply involve a change in the number of charges. The term fragment ion is deprecated. The term daughter ion is deprecated.", true},
    {MS_product_ion_spectrum_OBSOLETE, "MS:1000343", "product ion spectrum", "A mass spectrum recorded from any spectrometer in which the appropriate m/z separation scan function is set to record the product ion or ions of selected precursor ions.", true},
    {MS_progeny_ion_OBSOLETE, "MS:1000344", "progeny ion", "A charged product of a series of consecutive reactions that includes product ions, 1st generation product ions, 2nd generation product ions, etc. Given the sequential fragmentation scheme: M1+ -> M2+ -> M3+ -> M4+ -> M5+. M4+ is the precursor ion of M5+, a 1st generation product ion of M3+, a 2nd generation product ion of M2+ and a 3rd generation product ion of M1+.", true},
    {MS_array_detector, "MS:1000345", "array detector", "Detector comprising several ion collection elements, arranged in a line or grid where each element is an individual detector.", false},
    {MS_conversion_dynode, "MS:1000346", "conversion dynode", "A surface that is held at high potential such that ions striking the surface produce electrons that are subsequently detected.", false},
    {MS_dynode, "MS:1000347", "dynode", "One of a series of electrodes in a photomultiplier tube. Such an arrangement is able to amplify the current emitted by the photocathode.", false},
    {MS_focal_plane_collector, "MS:1000348", "focal plane collector", "A detector for spatially disperse ion beams in which all ions simultaneously impinge on the detector plane.", false},
    {MS_ion_to_photon_detector, "MS:1000349", "ion-to-photon detector", "A detector in which ions strike a conversion dynode to produce electrons that in turn strike a phosphor and the resulting photons are detected by a photomultiplier.", false},
    {MS_point_collector, "MS:1000350", "point collector", "A detector in which the ion beam is focused onto a point and the individual ions arrive sequentially.", false},
    {MS_postacceleration_detector, "MS:1000351", "postacceleration detector", "A detector in which the charged particles are accelerated to a high velocity and impinge on a conversion dynode, emitting secondary electrons. The electrons are accelerated onto a phosphor screen, which emits photons that are in turn detected using a photomultiplier or other photon detector.", false},
    {MS_secondary_electron_OBSOLETE, "MS:1000352", "secondary electron", "Electrons that are ejected from a sample surface as a result of bombardment by a primary beam of atoms, ions or photons. WAS IN DETECTOR TYPE. Where should it go.", true},
    {MS_adduct_ion, "MS:1000353", "adduct ion", "Ion formed by the interaction of an ion with one or more atoms or molecules to form an ion containing all the constituent atoms of the precursor ion as well as the additional atoms from the associated atoms or molecules.", false},
    {MS_aromatic_ion_OBSOLETE, "MS:1000354", "aromatic ion", "A planar cyclic ion that obeys the Hueckel (4n + 2) rule where n is a positive integer representing the number of conjugated Pi electrons. Charge delocalization leads to greater stability compared to a hypothetical localized structure.", true},
    {MS_analog_ion_OBSOLETE, "MS:1000355", "analog ion", "Ions that have similar chemical valence, for example the acetyl cation CH3-CO+ and the thioacetyl cation CH3-CS+.", true},
    {MS_anti_aromatic_ion_OBSOLETE, "MS:1000356", "anti-aromatic ion", "A planar cyclic ion with 4n ? electrons and is therefore not aromatic.", true},
    {MS_cationized_molecule_OBSOLETE, "MS:1000357", "cationized molecule", "An ion formed by the association of a cation with a neutral molecule, M, for example [M+ Na]+ and [M + K]+. The terms quasi-molecular ion and pseudo-molecular ion should not be used.", true},
    {MS_cluster_ion_OBSOLETE, "MS:1000358", "cluster ion", "An ion formed by a multi-component atomic or molecular assembly of one or more ions with atoms or molecules, such as [(H20)nH]+, [(NaCl)nNa]+ and [(H3PO3)nHPO3]-.", true},
    {MS_Conventional_ion_OBSOLETE, "MS:1000359", "Conventional ion", "A radical cation or anion in which the charge site and the unpaired electron spin are both formally located in the same atom or group of atoms, as opposed to the spatially separate electronic configuration of distonic ions. The radical cation of methanol, CH3OH+, in which the charge and spin sites are formally located at the O atom is an example of a conventional ion, whereas .CH2-OH2+ is a distonic ion.", true},
    {MS_diagnostic_ion_OBSOLETE, "MS:1000360", "diagnostic ion", "A product ion whose formation reveals structural or compositional information of its precursor. For instance, the phenyl cation in an electron ionization mass spectrum is a diagnostic ion for benzene and derivatives.", true},
    {MS_dimeric_ion_OBSOLETE, "MS:1000361", "dimeric ion", "An ion formed by ionization of a dimer or by the association of an ion with its neutral counterpart such as [M2]+ or [M-H-M]+.", true},
    {MS_distonic_ion_OBSOLETE, "MS:1000362", "distonic ion", "A radical cation or anion in which the charge site and the unpaired electron spin cannot be both formally located in the same atom or group of atoms as it can be with a conventional ion. For example, CH2-OH2+ is a distonic ion whereas the radical cation of methanol, CH3OH+ is a conventional ion.", true},
    {MS_enium_ion_OBSOLETE, "MS:1000363", "enium ion", "A positively charged lower-valency ion of the nonmetallic elements. The methenium ion is CH3+. Other examples are the oxenium, sulfenium, nitrenium, phosphenium, and halenium ions.", true},
    {MS_fragment_ion_OBSOLETE, "MS:1000364", "fragment ion", "A product ion that results from the dissociation of a precursor ion.", true},
    {MS_ion__OBSOLETE, "MS:1000365", "ion?", "An atomic or molecular species having a net positive or negative electric charge.", true},
    {MS_Isotopologue_ion_OBSOLETE, "MS:1000366", "Isotopologue ion", "An ion that differs only in the isotopic composition of one or more of its constituent atoms. For example CH4+ and CH3D+ or 10BF3 and 11BF3. The term isotopologue is a contraction of isotopic homologue.", true},
    {MS_Isotopomeric_ion_OBSOLETE, "MS:1000367", "Isotopomeric ion", "Isomeric ion having the same numbers of each isotopic atom but differing in their positions. Isotopomeric ions can be either configurational isomers in which two atomic isotopes exchange positions or isotopic stereoisomers. The term isotopomer is a shortening of isotopic isomer.", true},
    {MS_metastable_ion_OBSOLETE, "MS:1000368", "metastable ion", "An ion that is formed with internal energy higher than the threshold for dissociation but with a lifetime great enough to allow it to exit the ion source and enter the mass spectrometer where it dissociates before detection.", true},
    {MS_molecular_ion_OBSOLETE, "MS:1000369", "molecular ion", "An ion formed by the removal of one or more electrons to form a positive ion or the addition off one or more electrons to form a negative ion.", true},
    {MS_negative_ion_OBSOLETE, "MS:1000370", "negative ion", "An atomic or molecular species having a net negative electric charge.", true},
    {MS_non_classical_ion_OBSOLETE, "MS:1000371", "non-classical ion", "Hyper-coordinated carbonium ion such as the penta-coordinated norbornyl cation. Note: Tri-coordinated carbenium ions are termed classical ions.", true},
    {MS_onium_ion_OBSOLETE, "MS:1000372", "onium ion", "A positively charged hypervalent ion of the nonmetallic elements. Examples are the methonium ion CH5+, the hydrogenonium ion H3+ and the hydronium ion H3O+. Other examples are the carbonium, oxonium, sulfonium, nitronium, diazonium, phosphonium, and halonium ions. Onium ions are not limited to monopositive ions; multiply-charged onium ions exist such as the gitonic (proximal) oxonium dication H4O2+ and the distonic oxonium dication H2O+-CH2-CH2-OH2+.", true},
    {MS_principal_ion_OBSOLETE, "MS:1000373", "principal ion", "Most abundant ion of an isotope cluster, such as the 11B79Br2 81Br+ ion of m/z 250 of the cluster of isotopologue molecular ions of BBr3. The term principal ion has also been used to describe ions that have been artificially isotopically enriched in one or more positions such as CH3 13CH3+ or CH2D2 +, but those are best defined as isotopologue ions.", true},
    {MS_positive_ion_OBSOLETE, "MS:1000374", "positive ion", "An atomic or molecular species having a net positive electric charge.", true},
    {MS_protonated_molecule_OBSOLETE, "MS:1000375", "protonated molecule", "An ion formed by interaction of a neutral molecule with a proton and represented by the symbol [M + H]+, where M is the neutral molecule. The term 'protonated molecular ion,' 'quasi-molecular ion' and 'pseudo-molecular ion' are not recommended.", true},
    {MS_radical_ion_OBSOLETE, "MS:1000376", "radical ion", "An ion, either a cation or anion, containing unpaired electrons in its ground state. The unpaired electron is denoted by a superscript dot alongside the superscript symbol for charge, such as for the molecular ion of a molecule M, that is, M+. Radical ions with more than one charge and/or more than one unpaired electron are denoted such as M(2+)(2). Unless the positions of the unpaired electron and charge can be associated with specific atoms, superscript charge designation should be placed before the superscript dot designation.", true},
    {MS_reference_ion_OBSOLETE, "MS:1000377", "reference ion", "A stable ion whose structure is known with certainty. These ions are usually formed by direct ionization of a neutral molecule of known structure and are used to verify by comparison the structure of an unknown ion.", true},
    {MS_stable_ion_OBSOLETE, "MS:1000378", "stable ion", "An ion with internal energy sufficiently low that it does not rearrange or dissociate prior to detection in a mass spectrometer.", true},
    {MS_unstable_ion_OBSOLETE, "MS:1000379", "unstable ion", "An ion with sufficient energy to dissociate within the ion source.", true},
    {MS_adiabatic_ionization, "MS:1000380", "adiabatic ionization", "A process whereby an electron is removed from an atom, ion, or molecule to produce an ion in its lowest energy state.", false},
    {MS_associative_ionization, "MS:1000381", "associative ionization", "An ionization process in which two excited atoms or molecules react to form a single positive ion and an electron.", false},
    {MS_atmospheric_pressure_photoionization, "MS:1000382", "atmospheric pressure photoionization", "Atmospheric pressure chemical ionization in which the reactant ions are generated by photo-ionization.", false},
    {MS_autodetachment, "MS:1000383", "autodetachment", "The formation of a neutral when a negative ion in a discrete state with an energy greater than the detachment threshold loses an electron spontaneously without further interaction with an energy source.", false},
    {MS_autoionization, "MS:1000384", "autoionization", "The formation of an ion when an atom or molecule in a discrete state with an energy greater than the ionization threshold loses an electron spontaneously without further interaction with an energy source.", false},
    {MS_charge_exchange_ionization, "MS:1000385", "charge exchange ionization", "The interaction of an ion with an atom or molecule in which the charge on the ion is transferred to the neutral without the dissociation of either. Synonymous with charge transfer ionization.", false},
    {MS_chemi_ionization, "MS:1000386", "chemi-ionization", "The reaction of a neutral molecule with an internally excited molecule to form an ion. Note that this term is not synonymous with chemical ionization.", false},
    {MS_desorption_ionization_on_silicon, "MS:1000387", "desorption/ionization on silicon", "The formation of ions by laser desorption ionization of a sample deposited on a porous silicon surface.", false},
    {MS_dissociative_ionization, "MS:1000388", "dissociative ionization", "The reaction of a gas-phase molecule that results in its decomposition to form products, one of which is an ion.", false},
    {MS_electron_ionization, "MS:1000389", "electron ionization", "The ionization of an atom or molecule by electrons that are typically accelerated to energies between 50 and 150 eV. Usually 70 eV electrons are used to produce positive ions. The term 'electron impact' is not recommended.", false},
    {MS_ion_desolvation_OBSOLETE, "MS:1000390", "ion desolvation", "The removal of solvent molecules clustered around a gas-phase ion by means of heating and/or collisions with gas molecules.", true},
    {MS_ion_pair_formation_OBSOLETE, "MS:1000391", "ion-pair formation", "The reaction of a molecule to form both a positive ion and negative ion fragment among the products.", true},
    {MS_ionization_efficiency, "MS:1000392", "ionization efficiency", "The ratio of the number of ions formed to the number of electrons, molecules or photons used.", false},
    {MS_laser_desorption_ionization, "MS:1000393", "laser desorption ionization", "The formation of gas-phase ions by the interaction of a pulsed laser with a solid or liquid material.", false},
    {MS_liquid_secondary_ionization, "MS:1000395", "liquid secondary ionization", "The ionization of any species by the interaction of a focused beam of ions with a sample that is dissolved in a solvent matrix. See also fast atom bombardment and secondary ionization.", false},
    {MS_membrane_inlet, "MS:1000396", "membrane inlet", "A semi-permeable membrane separator that permits the passage of gas sample directly to the mass spectrometer ion source.", false},
    {MS_microelectrospray, "MS:1000397", "microelectrospray", "Electrospray ionization at a solvent flow rate of 300-800 nL/min where the flow is a result of a mechanical pump. See nanoelectrospray.", false},
    {MS_nanoelectrospray, "MS:1000398", "nanoelectrospray", "Electrospray ionization at a flow rate less than ~25 nL/min. Nanoelectrospray is synonymous with nanospray. The flow is dependent on the potenial on the tip of the electrospray needle and/or a gas presure to push the sample through the needle. See also electrospray ionization and microelectrospray.", false},
    {MS_penning_ionization, "MS:1000399", "penning ionization", "Ionization that occurs through the interaction of two or more neutral gaseous species, at least one of which is internally excited.", false},
    {MS_plasma_desorption_ionization, "MS:1000400", "plasma desorption ionization", "The ionization of material in a solid sample by bombarding it with ionic or neutral atoms formed as a result of the fission of a suitable nuclide, typically 252Cf. Synonymous with fission fragment ionization.", false},
    {MS_pre_ionization_state_OBSOLETE, "MS:1000401", "pre-ionization state", "An electronic state capable of undergoing auto-Ionization.", true},
    {MS_secondary_ionization, "MS:1000402", "secondary ionization", "The process in which ions are ejected from a sample surface as a result of bombardment by a primary beam of atoms or ions.", false},
    {MS_soft_ionization, "MS:1000403", "soft ionization", "The formation of gas-phase ions without extensive fragmentation.", false},
    {MS_spark_ionization, "MS:1000404", "spark ionization", "The formation of ions from a solid material by an intermittent electrical discharge.", false},
    {MS_surface_assisted_laser_desorption_ionization, "MS:1000405", "surface-assisted laser desorption ionization", "The formation of gas-phase ions from molecules that are deposited on a particular surface substrate that is irradiated with a pulsed laser. See also matrix-assisted laser desorption ionization.", false},
    {MS_surface_ionization, "MS:1000406", "surface ionization", "The ionization of a neutral species when it interacts with a solid surface with an appropriate work function and temperature.", false},
    {MS_thermal_ionization, "MS:1000407", "thermal ionization", "The ionization of a neutral species through contact with a high temperature surface.", false},
    {MS_vertical_ionization, "MS:1000408", "vertical ionization", "A process in which an electron is removed from or added to a molecule without a change in the positions of the atoms. The resulting ion is typically in an excited vibrational state.", false},
    {MS_association_reaction_OBSOLETE, "MS:1000409", "association reaction", "The reaction of an ion with a neutral species in which the reactants combine to form a single ion.", true},
    {MS_alpha_cleavage_OBSOLETE, "MS:1000410", "alpha-cleavage", "A homolytic cleavage where the bond fission occurs between at the atom adjacent to the atom at the apparent charge site and an atom removed from the aparent charge site by two bonds.", true},
    {MS_beta_cleavage_OBSOLETE, "MS:1000411", "beta-cleavage", "A homolytic cleavage where the bond fission occurs between at an atom removed from the apparent charge site atom by two bonds and an atom adjacent to that atom and removed from the aparent charge site by three bonds.", true},
    {MS_buffer_gas, "MS:1000412", "buffer gas", "An inert gas used for collisional deactivation of internally excited ions.", false},
    {MS_charge_induced_fragmentation_OBSOLETE, "MS:1000413", "charge-induced fragmentation", "Fragmentation of an odd electron ion in which the cleaved bond is adjacent to the apparent charge site. Synonymous with charge mediated fragmentation.", true},
    {MS_charge_inversion_reaction_OBSOLETE, "MS:1000414", "charge inversion reaction", "Reaction of an ion with a neutral species in which the charge on the product ion is reversed in sign with respect to the reactant ion.", true},
    {MS_charge_permutation_reaction_OBSOLETE, "MS:1000415", "charge permutation reaction", "The reaction of an ion with a neutral species with a resulting change in the magnitude or sign of the charge on the reactant ion.", true},
    {MS_charge_stripping_reaction_OBSOLETE, "MS:1000416", "charge stripping reaction", "Reaction of a positive ion with a neutral species in which the positive charge on the product ion is greater than that on the reactant ion.", true},
    {MS_charge_transfer_reaction_OBSOLETE, "MS:1000417", "charge transfer reaction", "The reaction of an ion with a neutral species in which some or all of the charge of the reactant ion is transferred to the neutral species.", true},
    {MS_collisional_excitation_OBSOLETE, "MS:1000418", "collisional excitation", "The reaction of an ion with a neutral species in which the translational energy of the collision is converted into internal energy of the ion.", true},
    {MS_collision_gas, "MS:1000419", "collision gas", "An inert gas used for collisional excitation. The term target gas is not recommended.", false},
    {MS_heterolytic_cleavage_OBSOLETE, "MS:1000420", "heterolytic cleavage", "Fragmentation of a molecule or ion in which both electrons forming the single bond that is broken remain on one of the atoms that were originally bonded. This term is synonymous with heterolysis.", true},
    {MS_high_energy_collision_OBSOLETE, "MS:1000421", "high energy collision", "Collision-induced dissociation process wherein the projectile ion has laboratory-frame translational energy higher than 1 keV.", true},
    {MS_beam_type_collision_induced_dissociation, "MS:1000422", "beam-type collision-induced dissociation", "A collision-induced dissociation process that occurs in a beam-type collision cell.", false},
    {MS_homolytic_cleavage_OBSOLETE, "MS:1000423", "homolytic cleavage", "Fragmentation of an odd electron ion that results from one of a pair of electrons that form a bond between two atoms moving to form a pair with the odd electron on the atom at the apparent charge site. Fragmentation results in the formation of an even electron ion and a radical. This reaction involves the movement of a single electron and is symbolized by a single-barbed arrow. Synonymous with Homolysis.", true},
    {MS_hydrogen_deuterium_exchange_OBSOLETE, "MS:1000424", "hydrogen/deuterium exchange", "Exchange of hydrogen atoms with deuterium atoms in a molecule or pre-formed ion in solution prior to introduction into a mass spectrometer, or by reaction of an ion with a deuterated collision gas inside a mass spectrometer.", true},
    {MS_ion_energy_loss_spectrum_OBSOLETE, "MS:1000425", "ion energy loss spectrum", "A plot of the relative abundance of a beam or other collection of ions as a function their loss of translational energy in reactions with neutral species.", true},
    {MS_ionizing_collision_OBSOLETE, "MS:1000426", "ionizing collision", "The reaction of an ion with a neutral species in which one or more electrons are removed from either the ion or neutral.", true},
    {MS_ion_molecule_reaction_OBSOLETE, "MS:1000427", "ion/molecule reaction", "The reaction of an ion with a neutral molecule. The term ion-molecule reaction is not recommended because the hyphen suggests a single species that is that is both an ion and a molecule.", true},
    {MS_ion_neutral_complex_OBSOLETE, "MS:1000428", "ion/neutral complex", "A particular type of transition state that lies between precursor and product ions on the reaction coordinate of some ion reactions.", true},
    {MS_ion_neutral_species_reaction_OBSOLETE, "MS:1000429", "ion/neutral species reaction", "A process wherein a charged species interacts with a neutral reactant to produce either chemically different species or changes in the internal energy of one or both of the reactants.", true},
    {MS_ion_neutral_species_exchange_reaction_OBSOLETE, "MS:1000430", "ion/neutral species exchange reaction", "In this reaction an association reaction is accompanied by the subsequent or simultaneous liberation of a different neutral species as a product.", true},
    {MS_kinetic_method_OBSOLETE, "MS:1000431", "kinetic method", "An approach to determination of ion thermodynamic quantities by a bracketing procedure in which the relative probabilities of competing ion fragmentations are measured via the relative abundances of the reaction products. The extended kinetic method takes the associated entropy changes into account.", true},
    {MS_low_energy_collisions_OBSOLETE, "MS:1000432", "low energy collisions", "A collision between an ion and neutral species with translational energy approximately 1000 eV or lower.", true},
    {MS_low_energy_collision_induced_dissociation, "MS:1000433", "low-energy collision-induced dissociation", "A collision-induced dissociation process wherein the precursor ion has the translational energy lower than approximately 1000 eV. This process typically requires multiple collisions and the collisional excitation is cumulative.", false},
    {MS_McLafferty_Rearrangement_OBSOLETE, "MS:1000434", "McLafferty Rearrangement", "A dissociation reaction triggered by transfer of a hydrogen atom via a 6-member transition state to the formal radical/charge site from a carbon atom four atoms removed from the charge/radical site (the gamma-carbon); subsequent rearrangement of electron density leads to expulsion of an olefin molecule. This term was originally applied to ketone ions where the charge/radical site is the carbonyl oxygen, but it is now more widely applied.", true},
    {MS_photodissociation, "MS:1000435", "photodissociation", "A process wherein the reactant ion is dissociated as a result of absorption of one or more photons.", false},
    {MS_partial_charge_transfer_reaction_OBSOLETE, "MS:1000436", "partial charge transfer reaction", "Reaction of an ion with a neutral species in which some but not all of the ion charge is transferred to the neutral.", true},
    {MS_ion_reaction_OBSOLETE, "MS:1000437", "ion reaction", "Chemical transformation involving an ion.", true},
    {MS_superelastic_collision_OBSOLETE, "MS:1000438", "superelastic collision", "Collision in which the translational energy of the fast-moving collision partner is increased at the expense of internal energy of one or both collision partners.", true},
    {MS_surface_induced_reaction_OBSOLETE, "MS:1000439", "surface-induced reaction", "A process wherein a reactant ion interacts with a surface to produce either chemically different species or a change in the internal energy of the reactant ion.", true},
    {MS_unimolecular_dissociation_OBSOLETE, "MS:1000440", "unimolecular dissociation", "Fragmentation reaction in which the molecularity is treated as one, irrespective of whether the dissociative state is that of a metastable ion produced in the ion source or results from collisional excitation of a stable ion.", true},
    {MS_scan, "MS:1000441", "scan", "Function or process of the mass spectrometer where it records a spectrum.", false},
    {MS_spectrum, "MS:1000442", "spectrum", "Representation of intensity values corresponding to a range of measurement space.", false},
    {MS_mass_analyzer_type, "MS:1000443", "mass analyzer type", "Mass analyzer separates the ions according to their mass-to-charge ratio.", false},
    {MS_m_z_Separation_Method_OBSOLETE, "MS:1000444", "m/z Separation Method", "Mass/charge separation Method.", true},
    {MS_sequential_m_z_separation_method_OBSOLETE, "MS:1000445", "sequential m/z separation method", "Sequential m/z separation method.", true},
    {MS_fast_ion_bombardment, "MS:1000446", "fast ion bombardment", "The ionization of any species by the interaction of a focused beam of ions having a translational energy of several thousand eV with a solid sample.", false},
    {MS_LTQ, "MS:1000447", "LTQ", "Finnigan LTQ MS.", false},
    {MS_LTQ_FT, "MS:1000448", "LTQ FT", "Finnigan LTQ FT MS.", false},
    {MS_LTQ_Orbitrap, "MS:1000449", "LTQ Orbitrap", "Finnigan LTQ Orbitrap MS.", false},
    {MS_LXQ, "MS:1000450", "LXQ", "Finnigan LXQ MS.", false},
    {MS_mass_analyzer, "MS:1000451", "mass analyzer", "Terms used to describe the Analyzer.", false},
    {MS_data_transformation, "MS:1000452", "data transformation", "Terms used to describe types of data processing.", false},
    {MS_detector, "MS:1000453", "detector", "The device that detects ions.", false},
    {MS_instrument_additional_description_OBSOLETE, "MS:1000454", "instrument additional description", "Additional terms to describe the instrument as outlined in the mass spec doc, Appendix 1, section 1.5.", true},
    {MS_ion_selection_attribute, "MS:1000455", "ion selection attribute", "Ion selection properties that are associated with a value.", false},
    {MS_precursor_activation, "MS:1000456", "precursor activation", "Terms to describe the precursor activation.", false},
    {MS_sample, "MS:1000457", "sample", "Terms to describe the sample.", false},
    {MS_source, "MS:1000458", "source", "Terms to describe the source.", false},
    {MS_spectrum_instrument_description_OBSOLETE, "MS:1000459", "spectrum instrument description", "Terms used to describe the spectrum.", true},
    {MS_unit_OBSOLETE, "MS:1000460", "unit", "Terms to describe units.", true},
    {MS_additional_description_OBSOLETE, "MS:1000461", "additional description", "Terms to describe Additional.", true},
    {MS_ion_optics, "MS:1000462", "ion optics", "Device used in the construction of a mass spectrometer to focus, contain or otherwise manipulate ions.", false},
    {MS_instrument, "MS:1000463", "instrument", "Description of the instrument or the mass spectrometer.", false},
    {MS_mass_unit_OBSOLETE, "MS:1000464", "mass unit", "A unit of measurement for mass.", true},
    {MS_scan_polarity, "MS:1000465", "scan polarity", "Relative orientation of the electromagnetic field during the selection and detection of ions in the mass spectrometer.", false},
    {MS_alternating_OBSOLETE, "MS:1000466", "alternating", "Alternating.", true},
    {MS_1200_series_LC_MSD_SL, "MS:1000467", "1200 series LC/MSD SL", "The 1200 Series LC/MSD SL ion trap belongs to the Agilent LC/MSD ion trap family. It provides fast polarity switching and multisignal data acquisition capabilities in a single run while also providing 5 stages of automated data dependent MS2 and 11 stages of manual MS2.", false},
    {MS_6110_Quadrupole_LC_MS, "MS:1000468", "6110 Quadrupole LC/MS", "The 6110 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with an entry level single quadrupole mass spectrometer from the 6100 Series of Agilent quadrupole mass spectrometers. 6110 Quadrupole mass spectrometer has m/z range of 10-1500 and 2500 u/s scan speed. It proves useful for wide range of SIM quantitative applications.", false},
    {MS_6120A_Quadrupole_LC_MS, "MS:1000469", "6120A Quadrupole LC/MS", "The 6120A Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 Series of Agilent mass spectrometers. 6120 quadrupole mass spectrometer has m/z range of 10-1500, 2500 u/s scan speed and utilizes multiple signal acquisition.", false},
    {MS_6130_Quadrupole_LC_MS, "MS:1000470", "6130 Quadrupole LC/MS", "The 6130 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 series of Agilent mass spectrometers. The 6130 quadrupole mass spectrometer has m/z range of 2-3000, 2500 u/s scan speed in standard mode and 5250 u/s speed in fast-scan mode. It also uses multiple signal acquisition.", false},
    {MS_6140_Quadrupole_LC_MS, "MS:1000471", "6140 Quadrupole LC/MS", "The 6140 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 Series of Agilent quadrupole mass spectrometers. 6140 Quadrupole mass spectrometer has m/z range of 10-1350, 2500 u/s scan speed in standard mode and 10000 u/s speed in fast-scan mode. It also uses multiple signal acquisition.", false},
    {MS_6210_Time_of_Flight_LC_MS, "MS:1000472", "6210 Time-of-Flight LC/MS", "The 6210 Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 13,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.", false},
    {MS_6310_Ion_Trap_LC_MS, "MS:1000473", "6310 Ion Trap LC/MS", "The 6310 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.35 resolution and mass range of 200-4000 with resolution of 3-4. The scan speed varies from 1650-27000 for the respective mass ranges.", false},
    {MS_6320_Ion_Trap_LC_MS, "MS:1000474", "6320 Ion Trap LC/MS", "The 6320 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.25 resolution and mass range of 200-4000 with resolution of less than 3. The scan speed varies from 1650-27000 for the respective mass ranges.", false},
    {MS_6330_Ion_Trap_LC_MS, "MS:1000475", "6330 Ion Trap LC/MS", "The 6330 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.25 resolution and mass range of 200-4000 with resolution of less than 3. The scan speed varies from 1650-27000 for the respective mass ranges.", false},
    {MS_6340_Ion_Trap_LC_MS, "MS:1000476", "6340 Ion Trap LC/MS", "The 6340 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.25 resolution and mass range of 200-4000 with resolution of less than 3. The scan speed varies from 1650-27000 for the respective mass ranges.", false},
    {MS_6410_Triple_Quadrupole_LC_MS, "MS:1000477", "6410 Triple Quadrupole LC/MS", "The 6410 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. Mass range of the mass spectrometer is 15-1650 m/z, resolution is at three settings of 0.7 u (unit), 1.2 u (wide) and 2.5 u (widest). The mass accuracy for 6410 mass spectrometer is 0.1 across the mass range. The collision cell is a hexapole with linear acceleration.", false},
    {MS_1200_series_LC_MSD_VL, "MS:1000478", "1200 series LC/MSD VL", "The LC/MSD VL ion trap is part of the family of Agilent ion trap mass spectrometers. It has ESI, APCI and APPI ion sources and is a useful ion trap when the amount of sample is not the limiting factor.", false},
    {MS_purgatory_OBSOLETE, "MS:1000479", "purgatory", "Terms that will likely become obsolete unless there are wails of dissent.", true},
    {MS_mass_analyzer_attribute, "MS:1000480", "mass analyzer attribute", "Analyzer properties that are associated with a value.", false},
    {MS_detector_attribute, "MS:1000481", "detector attribute", "Detector attribute recognized as a value.", false},
    {MS_source_attribute, "MS:1000482", "source attribute", "Property of a source device that need a value.", false},
    {MS_Thermo_Fisher_Scientific_instrument_model, "MS:1000483", "Thermo Fisher Scientific instrument model", "Thermo Fisher Scientific instrument model. The company has gone through several names including Thermo Finnigan, Thermo Scientific.", false},
    {MS_orbitrap, "MS:1000484", "orbitrap", "An ion trapping device that consists of an outer barrel-like electrode and a coaxial inner spindle-like electrode that form an electrostatic field with quadro-logarithmic potential distribution. The frequency of harmonic oscillations of the orbitally trapped ions along the axis of the electrostatic field is independent of the ion velocity and is inversely proportional to the square root of m/z so that the trap can be used as a mass analyzer.", false},
    {MS_nanospray_inlet, "MS:1000485", "nanospray inlet", "Nanospray Inlet.", false},
    {MS_source_potential, "MS:1000486", "source potential", "Potential difference at the MS source in volts.", false},
    {MS_ion_optics_attribute, "MS:1000487", "ion optics attribute", "Ion optics involves components that help focus ion streams in mass spectrometry.", false},
    {MS_Hitachi_instrument_model, "MS:1000488", "Hitachi instrument model", "Hitachi instrument model.", false},
    {MS_Varian_instrument_model, "MS:1000489", "Varian instrument model", "Varian instrument model.", false},
    {MS_Agilent_instrument_model, "MS:1000490", "Agilent instrument model", "Agilent instrument model.", false},
    {MS_Dionex_instrument_model, "MS:1000491", "Dionex instrument model", "Dionex instrument model.", false},
    {MS_Thermo_Electron_instrument_model, "MS:1000492", "Thermo Electron instrument model", "Thermo Electron Corporation instrument model.", false},
    {MS_Finnigan_MAT_instrument_model, "MS:1000493", "Finnigan MAT instrument model", "Finnigan MAT instrument model.", false},
    {MS_Thermo_Scientific_instrument_model, "MS:1000494", "Thermo Scientific instrument model", "Thermo Scientific instrument model.", false},
    {MS_Applied_Biosystems_instrument_model, "MS:1000495", "Applied Biosystems instrument model", "Applied Biosystems instrument model.", false},
    {MS_instrument_attribute, "MS:1000496", "instrument attribute", "Instrument properties that are associated with a value.", false},
    {MS_zoom_scan, "MS:1000497", "zoom scan", "Special scan mode where data with improved resolution is acquired. This is typically achieved by scanning a more narrow m/z window or scanning with a lower scan rate.", false},
    {MS_full_scan_OBSOLETE, "MS:1000498", "full scan", "Feature of the ion trap mass spectrometer where MS data is acquired over a mass range.", true},
    {MS_spectrum_attribute, "MS:1000499", "spectrum attribute", "Nonphysical characteristic attributed to a spectrum.", false},
    {MS_scan_window_upper_limit, "MS:1000500", "scan window upper limit", "The lower m/z bound of a mass spectrometer scan window.", false},
    {MS_scan_window_lower_limit, "MS:1000501", "scan window lower limit", "The upper m/z bound of a mass spectrometer scan window.", false},
    {MS_dwell_time, "MS:1000502", "dwell time", "The time spent gathering data across a peak.", false},
    {MS_scan_attribute, "MS:1000503", "scan attribute", "Nonphysical characteristic attributed to a spectrum acquisition scan.", false},
    {MS_base_peak_m_z, "MS:1000504", "base peak m/z", "M/z value of the signal of highest intensity in the mass spectrum.", false},
    {MS_base_peak_intensity, "MS:1000505", "base peak intensity", "The intensity of the greatest peak in the mass spectrum.", false},
    {MS_ion_role_OBSOLETE, "MS:1000506", "ion role", "Ion Role.", true},
    {MS_ion_property, "MS:1000507", "ion property", "Nonphysical characteristic attributed to an ion.", false},
    {MS_ion_chemical_type_OBSOLETE, "MS:1000508", "ion chemical type", "Ion Type.", true},
    {MS_activation_energy, "MS:1000509", "activation energy", "Activation Energy.", false},
    {MS_precursor_activation_attribute, "MS:1000510", "precursor activation attribute", "Precursor Activation Attribute.", false},
    {MS_ms_level, "MS:1000511", "ms level", "Stage number achieved in a multi stage mass spectrometry acquisition.", false},
    {MS_filter_string, "MS:1000512", "filter string", "A string unique to Thermo instrument describing instrument settings for the scan.", false},
    {MS_binary_data_array, "MS:1000513", "binary data array", "A data array of values.", false},
    {MS_m_z_array, "MS:1000514", "m/z array", "A data array of m/z values.", false},
    {MS_intensity_array, "MS:1000515", "intensity array", "A data array of intensity values.", false},
    {MS_charge_array, "MS:1000516", "charge array", "A data array of charge values.", false},
    {MS_signal_to_noise_array, "MS:1000517", "signal to noise array", "A data array of signal-to-noise values.", false},
    {MS_binary_data_type, "MS:1000518", "binary data type", "Encoding type of binary data specifying the binary representation and precision, e.g. 64-bit float.", false},
    {MS_32_bit_integer, "MS:1000519", "32-bit integer", "Signed 32-bit little-endian integer.", false},
    {MS_16_bit_float_OBSOLETE, "MS:1000520", "16-bit float", "Signed 16-bit float.", true},
    {MS_32_bit_float, "MS:1000521", "32-bit float", "32-bit precision little-endian floating point conforming to IEEE-754.", false},
    {MS_64_bit_integer, "MS:1000522", "64-bit integer", "Signed 64-bit little-endian integer.", false},
    {MS_64_bit_float, "MS:1000523", "64-bit float", "64-bit precision little-endian floating point conforming to IEEE-754.", false},
    {MS_data_file_content, "MS:1000524", "data file content", "Describes the data content on the file.", false},
    {MS_spectrum_representation, "MS:1000525", "spectrum representation", "Way in which the spectrum is represented, either with regularly spaced data points or with a list of centroided peaks.", false},
    {MS_Waters_raw_format, "MS:1000526", "Waters raw format", "Waters data file format found in a Waters RAW directory, generated from an MS acquisition.", false},
    {MS_highest_observed_m_z, "MS:1000527", "highest observed m/z", "Highest m/z value observed in the m/z array.", false},
    {MS_lowest_observed_m_z, "MS:1000528", "lowest observed m/z", "Lowest m/z value observed in the m/z array.", false},
    {MS_instrument_serial_number, "MS:1000529", "instrument serial number", "Serial Number of the instrument.", false},
    {MS_file_format_conversion, "MS:1000530", "file format conversion", "Conversion of one file format to another.", false},
    {MS_software, "MS:1000531", "software", "Software related to the recording or transformation of spectra.", false},
    {MS_Xcalibur, "MS:1000532", "Xcalibur", "Thermo Finnigan software for data acquisition and analysis.", false},
    {MS_Bioworks, "MS:1000533", "Bioworks", "Thermo Finnigan software for data analysis of peptides and proteins.", false},
    {MS_MassLynx, "MS:1000534", "MassLynx", "Micromass software for data acquisition and analysis.", false},
    {MS_FlexAnalysis, "MS:1000535", "FlexAnalysis", "Bruker software for data analysis.", false},
    {MS_Data_Explorer, "MS:1000536", "Data Explorer", "Applied Biosystems software for data acquisition and analysis.", false},
    {MS_4700_Explorer, "MS:1000537", "4700 Explorer", "Applied Biosystems software for data acquisition and analysis.", false},
    {MS_massWolf, "MS:1000538", "massWolf", "A software for converting Waters raw directory format to mzXML or mzML. MassWolf was originally developed at the Institute for Systems Biology.", false},
    {MS_Voyager_Biospectrometry_Workstation_System, "MS:1000539", "Voyager Biospectrometry Workstation System", "Applied Biosystems MALDI-TOF data acquisition and analysis system.", false},
    {MS_FlexControl, "MS:1000540", "FlexControl", "Bruker software for data acquisition.", false},
    {MS_ReAdW, "MS:1000541", "ReAdW", "A software program for converting Thermo Finnigan RAW file format to mzXML or mzML. ReAdW was originally developed at the Institute for Systems Biology. Its whimsical interleaved spelling and capitalization is pronounced \\\"readraw\\\".", false},
    {MS_MzStar, "MS:1000542", "MzStar", "A software program for converting Applied Biosystems wiff file format to mzXML format. MzStar was originally developed at the Institute for Systems Biology. It is now obsoleted by the MzWiff program.", false},
    {MS_data_processing_action, "MS:1000543", "data processing action", "Data processing attribute used to describe the type of data processing performed on the data file.", false},
    {MS_Conversion_to_mzML, "MS:1000544", "Conversion to mzML", "Conversion of a file format to Proteomics Standards Initiative mzML file format.", false},
    {MS_Conversion_to_mzXML, "MS:1000545", "Conversion to mzXML", "Conversion of a file format to Institute of Systems Biology mzXML file format.", false},
    {MS_Conversion_to_mzData, "MS:1000546", "Conversion to mzData", "Conversion of a file format to Proteomics Standards Initiative mzData file format.", false},
    {MS_object_attribute, "MS:1000547", "object attribute", "Object Attribute.", false},
    {MS_sample_attribute, "MS:1000548", "sample attribute", "Sample properties that are associated with a value.", false},
    {MS_selection_window_attribute, "MS:1000549", "selection window attribute", "Selection window properties that are associated with a value.", false},
    {MS_time_unit_OBSOLETE, "MS:1000550", "time unit", "Time Unit.", true},
    {MS_Analyst, "MS:1000551", "Analyst", "SCIEX or Applied Biosystems|MDS SCIEX software for data acquisition.", false},
    {MS_maldi_spot_identifier_OBSOLETE, "MS:1000552", "maldi spot identifier", "Maldi Spot Identifier.", true},
    {MS_Trapper, "MS:1000553", "Trapper", "A software program for converting Agilent MassHunter format to mzXML or mzML. Trapper was originally developed at the Institute for Systems Biology.", false},
    {MS_LCQ_Deca, "MS:1000554", "LCQ Deca", "ThermoFinnigan LCQ Deca.", false},
    {MS_LTQ_Orbitrap_Discovery, "MS:1000555", "LTQ Orbitrap Discovery", "LTQ Orbitrap Discovery.", false},
    {MS_LTQ_Orbitrap_XL, "MS:1000556", "LTQ Orbitrap XL", "LTQ Orbitrap XL.", false},
    {MS_LTQ_FT_Ultra, "MS:1000557", "LTQ FT Ultra", "LTQ FT Ultra.", false},
    {MS_GC_Quantum, "MS:1000558", "GC Quantum", "GC Quantum.", false},
    {MS_spectrum_type, "MS:1000559", "spectrum type", "Spectrum type.", false},
    {MS_mass_spectrometer_file_format, "MS:1000560", "mass spectrometer file format", "The format of the file being used. This could be a instrument or vendor specific proprietary file format or a converted open file format.", false},
    {MS_data_file_checksum_type, "MS:1000561", "data file checksum type", "Checksum is a form of redundancy check, a simple way to protect the integrity of data by detecting errors in data.", false},
    {MS_ABI_WIFF_format, "MS:1000562", "ABI WIFF format", "Applied Biosystems WIFF file format.", false},
    {MS_Thermo_RAW_format, "MS:1000563", "Thermo RAW format", "Thermo Scientific RAW file format.", false},
    {MS_PSI_mzData_format, "MS:1000564", "PSI mzData format", "Proteomics Standards Inititative mzData file format.", false},
    {MS_Micromass_PKL_format, "MS:1000565", "Micromass PKL format", "Micromass PKL file format.", false},
    {MS_ISB_mzXML_format, "MS:1000566", "ISB mzXML format", "Institute of Systems Biology mzXML file format.", false},
    {MS_Bruker_Agilent_YEP_format, "MS:1000567", "Bruker/Agilent YEP format", "Bruker/Agilent YEP file format.", false},
    {MS_MD5, "MS:1000568", "MD5", "MD5 (Message-Digest algorithm 5) is a (now deprecated) cryptographic hash function with a 128-bit hash value used to check the integrity of files.", false},
    {MS_SHA_1, "MS:1000569", "SHA-1", "SHA-1 (Secure Hash Algorithm-1) is a cryptographic hash function designed by the National Security Agency (NSA). It is also used to verify file integrity. Since 2011 it has been deprecated by the NIST as a U. S. government standard.", false},
    {MS_spectra_combination, "MS:1000570", "spectra combination", "Method used to combine the mass spectra.", false},
    {MS_sum_of_spectra, "MS:1000571", "sum of spectra", "Spectra Sum.", false},
    {MS_binary_data_compression_type, "MS:1000572", "binary data compression type", "Compression Type.", false},
    {MS_median_of_spectra, "MS:1000573", "median of spectra", "Spectra is combined by calculating the median of the spectra.", false},
    {MS_zlib_compression, "MS:1000574", "zlib compression", "Zlib.", false},
    {MS_mean_of_spectra, "MS:1000575", "mean of spectra", "Spectra is combined by calculating the mean of the spectra.", false},
    {MS_no_compression, "MS:1000576", "no compression", "No Compression.", false},
    {MS_source_data_file, "MS:1000577", "source data file", "Data file from which an entity is sourced.", false},
    {MS_LCQ_Fleet, "MS:1000578", "LCQ Fleet", "LCQ Fleet.", false},
    {MS_MS1_spectrum, "MS:1000579", "MS1 spectrum", "Mass spectrum created by a single-stage MS experiment or the first stage of a multi-stage experiment.", false},
    {MS_MSn_spectrum, "MS:1000580", "MSn spectrum", "MSn refers to multi-stage MS2 experiments designed to record product ion spectra where n is the number of product ion stages (progeny ions). For ion traps, sequential MS/MS experiments can be undertaken where n > 2 whereas for a simple triple quadrupole system n=2. Use the term ms level (MS:1000511) for specifying n.", false},
    {MS_CRM_spectrum, "MS:1000581", "CRM spectrum", "Spectrum generated from MSn experiment with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.", false},
    {MS_SIM_spectrum, "MS:1000582", "SIM spectrum", "Spectrum obtained with the operation of a mass spectrometer in which the abundances of one ion or several ions of specific m/z values are recorded rather than the entire mass spectrum (Selected Ion Monitoring).", false},
    {MS_SRM_spectrum, "MS:1000583", "SRM spectrum", "Spectrum obtained when data are acquired from specific product ions corresponding to m/z values of selected precursor ions a recorded via two or more stages of mass spectrometry. The precursor/product ion pair is called a transition pair. Data can be obtained for a single transition pair or multiple transition pairs. Multiple time segments of different transition pairs can exist in a single file. Single precursor ions can have multiple product ions consitituting multiple transition pairs. Selected reaction monitoring can be performed as tandem mass spectrometry in time or tandem mass spectrometry in space.", false},
    {MS_mzML_format, "MS:1000584", "mzML format", "Proteomics Standards Inititative mzML file format.", false},
    {MS_contact_attribute, "MS:1000585", "contact attribute", "Details about a person or organization to contact in case of concern or discussion about the file.", false},
    {MS_contact_name, "MS:1000586", "contact name", "Name of the contact person or organization.", false},
    {MS_contact_address, "MS:1000587", "contact address", "Postal address of the contact person or organization.", false},
    {MS_contact_URL, "MS:1000588", "contact URL", "Uniform Resource Locator related to the contact person or organization.", false},
    {MS_contact_email, "MS:1000589", "contact email", "Email address of the contact person or organization.", false},
    {MS_contact_affiliation, "MS:1000590", "contact affiliation", "Home institution of the contact person.", false},
    {MS_MzWiff, "MS:1000591", "MzWiff", "A software program for converting Applied Biosystems wiff file format to the mzXML or mzML format. MzWiff is currently maintained at the Institute for Systems Biology. It replaces the slower mzStar program.", false},
    {MS_smoothing, "MS:1000592", "smoothing", "A process of reducing spikes of intensity in order to reduce noise while preserving real peak signal. Many algorithms can be applied for this process.", false},
    {MS_baseline_reduction, "MS:1000593", "baseline reduction", "A process of removal of varying intensities generated due to variable energy absorption before further processing can take place. Baseline reduction facilitates meaningful comparision between intensities of m/z values.", false},
    {MS_low_intensity_data_point_removal, "MS:1000594", "low intensity data point removal", "The removal of very low intensity data points that are likely to be spurious noise rather than real signal.", false},
    {MS_time_array, "MS:1000595", "time array", "A data array of relative time offset values from a reference time.", false},
    {MS_measurement_method, "MS:1000596", "measurement method", "An attribute of resolution when recording the detector response in absence of the analyte.", false},
    {MS_ion_optics_type, "MS:1000597", "ion optics type", "The electrical potential used to impart kinetic energy to ions in a mass spectrometer.", false},
    {MS_electron_transfer_dissociation, "MS:1000598", "electron transfer dissociation", "A process to fragment ions in a mass spectrometer by inducing fragmentation of cations (e.g. peptides or proteins) by transferring electrons from radical-anions.", false},
    {MS_pulsed_q_dissociation, "MS:1000599", "pulsed q dissociation", "A process that involves precursor ion activation at high Q, a time delay to allow the precursor to fragment, then a rapid pulse to low Q where all fragment ions are trapped. The product ions can then be scanned out of the ion trap and detected.", false},
    {MS_Proteios, "MS:1000600", "Proteios", "Database application and analysis platform for proteomics.", false},
    {MS_ProteinLynx_Global_Server, "MS:1000601", "ProteinLynx Global Server", "Waters software for data analysis.", false},
    {MS_Shimadzu_MALDI_TOF_instrument_model, "MS:1000602", "Shimadzu MALDI-TOF instrument model", "Shimadzu MALDI-TOF instrument model.", false},
    {MS_Shimadzu_Scientific_Instruments_instrument_model, "MS:1000603", "Shimadzu Scientific Instruments instrument model", "Shimadzu Scientific Instruments instrument model.", false},
    {MS_LCMS_IT_TOF, "MS:1000604", "LCMS-IT-TOF", "Shimadzu Scientific Instruments LCMS-IT-TOF MS.", false},
    {MS_LCMS_2010EV, "MS:1000605", "LCMS-2010EV", "Shimadzu Scientific Instruments LCMS-2010EV MS.", false},
    {MS_LCMS_2010A, "MS:1000606", "LCMS-2010A", "Shimadzu Scientific Instruments LCMS-2010A MS.", false},
    {MS_AXIMA_CFR_MALDI_TOF, "MS:1000607", "AXIMA CFR MALDI-TOF", "Shimadzu Biotech AXIMA CFR MALDI-TOF MS.", false},
    {MS_AXIMA_QIT, "MS:1000608", "AXIMA-QIT", "Shimadzu Biotech AXIMA-QIT MS.", false},
    {MS_AXIMA_CFR_plus, "MS:1000609", "AXIMA-CFR plus", "Shimadzu Biotech AXIMA-CFR plus MS.", false},
    {MS_AXIMA_Performance_MALDI_TOF_TOF, "MS:1000610", "AXIMA Performance MALDI-TOF/TOF", "Shimadzu Biotech AXIMA Performance MALDI-TOF/TOF MS.", false},
    {MS_AXIMA_Confidence_MALDI_TOF, "MS:1000611", "AXIMA Confidence MALDI-TOF", "Shimadzu Biotech AXIMA Confidence MALDI-TOF (curved field reflectron) MS.", false},
    {MS_AXIMA_Assurance_Linear_MALDI_TOF, "MS:1000612", "AXIMA Assurance Linear MALDI-TOF", "Shimadzu Biotech AXIMA Assurance Linear MALDI-TOF MS.", false},
    {MS_DTA_format, "MS:1000613", "DTA format", "SEQUEST DTA file format.", false},
    {MS_ProteinLynx_Global_Server_mass_spectrum_XML_format, "MS:1000614", "ProteinLynx Global Server mass spectrum XML format", "Peak list file format used by ProteinLynx Global Server.", false},
    {MS_ProteoWizard_software, "MS:1000615", "ProteoWizard software", "ProteoWizard software for data processing and analysis. Primarily developed by the labs of P. Malick and D. Tabb.", false},
    {MS_preset_scan_configuration, "MS:1000616", "preset scan configuration", "A user-defined scan configuration that specifies the instrumental settings in which a spectrum is acquired. An instrument may cycle through a list of preset scan configurations to acquire data. This is a more generic term for the Thermo \\\"scan event\\\", which is defined in the Thermo Xcalibur glossary as: a mass spectrometer scan that is defined by choosing the necessary scan parameter settings. Multiple scan events can be defined for each segment of time.", false},
    {MS_wavelength_array, "MS:1000617", "wavelength array", "A data array of electromagnetic radiation wavelength values.", false},
    {MS_highest_observed_wavelength, "MS:1000618", "highest observed wavelength", "Highest wavelength observed in an EMR spectrum.", false},
    {MS_lowest_observed_wavelength, "MS:1000619", "lowest observed wavelength", "Lowest wavelength observed in an EMR spectrum.", false},
    {MS_PDA_spectrum_OBSOLETE, "MS:1000620", "PDA spectrum", "Spectrum generated from a photodiode array detector (ultraviolet/visible spectrum).", true},
    {MS_photodiode_array_detector, "MS:1000621", "photodiode array detector", "An array detector used to record spectra in the ultraviolet and visible region of light.", false},
    {MS_Surveyor_PDA, "MS:1000622", "Surveyor PDA", "Surveyor PDA.", false},
    {MS_Accela_PDA, "MS:1000623", "Accela PDA", "Accela PDA.", false},
    {MS_inductive_detector, "MS:1000624", "inductive detector", "Inductive detector.", false},
    {MS_chromatogram, "MS:1000625", "chromatogram", "Representation of a chromatographic separation attribute measurement versus time.", false},
    {MS_chromatogram_type, "MS:1000626", "chromatogram type", "Type of chromatogram measurement being represented.", false},
    {MS_selected_ion_current_chromatogram, "MS:1000627", "selected ion current chromatogram", "Representation of an array of the measurements of a specific single ion current versus time.", false},
    {MS_basepeak_chromatogram, "MS:1000628", "basepeak chromatogram", "Representation of an array of the most intense peaks versus time.", false},
    {MS_low_intensity_threshold, "MS:1000629", "low intensity threshold", "Threshold below which some action is taken.", false},
    {MS_data_processing_parameter, "MS:1000630", "data processing parameter", "Data processing parameter used in the data processing performed on the data file.", false},
    {MS_high_intensity_threshold, "MS:1000631", "high intensity threshold", "Threshold above which some action is taken.", false},
    {MS_Q_Tof_Premier, "MS:1000632", "Q-Tof Premier", "Waters oa-ToF based Q-Tof Premier.", false},
    {MS_possible_charge_state, "MS:1000633", "possible charge state", "A possible charge state of the ion in a situation where the charge of an ion is known to be one of several possible values rather than a completely unknown value or determined to be a specific charge with reasonable certainty.", false},
    {MS_DSQ, "MS:1000634", "DSQ", "ThermoFinnigan DSQ GC-MS.", false},
    {MS_ITQ_700, "MS:1000635", "ITQ 700", "Thermo Scientific ITQ 700 GC-MS.", false},
    {MS_ITQ_900, "MS:1000636", "ITQ 900", "Thermo Scientific ITQ 900 GC-MS.", false},
    {MS_ITQ_1100, "MS:1000637", "ITQ 1100", "Thermo Scientific ITQ 1100 GC-MS.", false},
    {MS_LTQ_XL_ETD, "MS:1000638", "LTQ XL ETD", "Thermo Scientific LTQ XL MS with ETD.", false},
    {MS_LTQ_Orbitrap_XL_ETD, "MS:1000639", "LTQ Orbitrap XL ETD", "Thermo Scientific LTQ Orbitrap XL MS with ETD.", false},
    {MS_DFS, "MS:1000640", "DFS", "Thermo Scientific DFS HR GC-MS.", false},
    {MS_DSQ_II, "MS:1000641", "DSQ II", "Thermo Scientific DSQ II GC-MS.", false},
    {MS_MALDI_LTQ_XL, "MS:1000642", "MALDI LTQ XL", "Thermo Scientific MALDI LTQ XL MS.", false},
    {MS_MALDI_LTQ_Orbitrap, "MS:1000643", "MALDI LTQ Orbitrap", "Thermo Scientific MALDI LTQ Orbitrap MS.", false},
    {MS_TSQ_Quantum_Access, "MS:1000644", "TSQ Quantum Access", "Thermo Scientific TSQ Quantum Access MS.", false},
    {MS_Element_XR, "MS:1000645", "Element XR", "Thermo Scientific Element XR HR-ICP-MS.", false},
    {MS_Element_2, "MS:1000646", "Element 2", "Thermo Scientific Element 2 HR-ICP-MS.", false},
    {MS_Element_GD, "MS:1000647", "Element GD", "Thermo Scientific Element GD Glow Discharge MS.", false},
    {MS_GC_IsoLink, "MS:1000648", "GC IsoLink", "Thermo Scientific GC IsoLink Isotope Ratio MS.", false},
    {MS_Exactive, "MS:1000649", "Exactive", "Thermo Scientific Exactive MS.", false},
    {MS_Proteome_Discoverer, "MS:1000650", "Proteome Discoverer", "Thermo Scientific software for data analysis of peptides and proteins.", false},
    {MS_3200_QTRAP, "MS:1000651", "3200 QTRAP", "SCIEX or Applied Biosystems|MDS SCIEX QTRAP 3200.", false},
    {MS_4800_Plus_MALDI_TOF_TOF, "MS:1000652", "4800 Plus MALDI TOF/TOF", "SCIEX or Applied Biosystems|MDS SCIEX 4800 Plus MALDI TOF-TOF Analyzer.", false},
    {MS_API_3200, "MS:1000653", "API 3200", "SCIEX or Applied Biosystems|MDS SCIEX API 3200 MS.", false},
    {MS_API_5000, "MS:1000654", "API 5000", "SCIEX or Applied Biosystems|MDS SCIEX API 5000 MS.", false},
    {MS_QSTAR_Elite, "MS:1000655", "QSTAR Elite", "SCIEX or Applied Biosystems|MDS SCIEX QSTAR Elite.", false},
    {MS_QSTAR_Pulsar, "MS:1000656", "QSTAR Pulsar", "Applied Biosystems|MDS SCIEX QSTAR Pulsar.", false},
    {MS_QSTAR_XL, "MS:1000657", "QSTAR XL", "Applied Biosystems|MDS SCIEX QSTAR XL.", false},
    {MS_4800_Proteomics_Analyzer, "MS:1000658", "4800 Proteomics Analyzer", "Applied Biosystems|MDS SCIEX 4800 Proteomics Analyzer.", false},
    {MS_4000_Series_Explorer_Software, "MS:1000659", "4000 Series Explorer Software", "SCIEX or Applied Biosystems software for data acquisition and analysis.", false},
    {MS_GPS_Explorer, "MS:1000661", "GPS Explorer", "SCIEX or Applied Biosystems software for data acquisition and analysis.", false},
    {MS_LightSight_Software, "MS:1000662", "LightSight Software", "SCIEX or Applied Biosystems|MDS SCIEX software metabolite identification.", false},
    {MS_ProteinPilot_Software, "MS:1000663", "ProteinPilot Software", "SCIEX or Applied Biosystems|MDS SCIEX software for protein ID and quant.", false},
    {MS_TissueView_Software, "MS:1000664", "TissueView Software", "Applied Biosystems|MDS SCIEX software for tissue imaging.", false},
    {MS_MarkerView_Software, "MS:1000665", "MarkerView Software", "Applied Biosystems|MDS SCIEX software for metabolomics and biomarker profiling.", false},
    {MS_MRMPilot_Software, "MS:1000666", "MRMPilot Software", "Applied Biosystems|MDS SCIEX software for MRM assay development.", false},
    {MS_BioAnalyst, "MS:1000667", "BioAnalyst", "Applied Biosystems|MDS SCIEX software for bio-related data exploration.", false},
    {MS_Pro_ID, "MS:1000668", "Pro ID", "Applied Biosystems|MDS SCIEX software for protein identification.", false},
    {MS_Pro_ICAT, "MS:1000669", "Pro ICAT", "Applied Biosystems|MDS SCIEX software for protein ID and quant by ICAT.", false},
    {MS_Pro_Quant, "MS:1000670", "Pro Quant", "Applied Biosystems|MDS SCIEX software for protein ID and quant by iTRAQ.", false},
    {MS_Pro_BLAST, "MS:1000671", "Pro BLAST", "Applied Biosystems|MDS SCIEX software for MS-BLAST identification.", false},
    {MS_Cliquid, "MS:1000672", "Cliquid", "SCIEX Cliquid software for data analysis and quantitation.", false},
    {MS_MIDAS_Workflow_Designer, "MS:1000673", "MIDAS Workflow Designer", "Applied Biosystems|MDS SCIEX software for MRM assay development.", false},
    {MS_MultiQuant, "MS:1000674", "MultiQuant", "Applied Biosystems|MDS SCIEX software for MRM-based quantitation.", false},
    {MS_6220_Time_of_Flight_LC_MS, "MS:1000675", "6220 Time-of-Flight LC/MS", "The 6220 Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 13,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.", false},
    {MS_6510_Quadrupole_Time_of_Flight_LC_MS, "MS:1000676", "6510 Quadrupole Time-of-Flight LC/MS", "The 6510 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 13,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.", false},
    {MS_6520A_Quadrupole_Time_of_Flight_LC_MS, "MS:1000677", "6520A Quadrupole Time-of-Flight LC/MS", "The 6520A Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 26,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.", false},
    {MS_MassHunter_Data_Acquisition, "MS:1000678", "MassHunter Data Acquisition", "Software for data acquisition of 6000 series instruments.", false},
    {MS_MassHunter_Easy_Access, "MS:1000679", "MassHunter Easy Access", "Software for open access data acquisition.", false},
    {MS_MassHunter_Qualitative_Analysis, "MS:1000680", "MassHunter Qualitative Analysis", "Software for data analysis of data from 6000 series instruments.", false},
    {MS_MassHunter_Quantitative_Analysis, "MS:1000681", "MassHunter Quantitative Analysis", "Software for quantitation of Triple Quadrupole and Quadrupole Time-of-Flight data.", false},
    {MS_MassHunter_Metabolite_ID, "MS:1000682", "MassHunter Metabolite ID", "Software for identification of metabolites.", false},
    {MS_MassHunter_BioConfirm, "MS:1000683", "MassHunter BioConfirm", "Software for protein characterization.", false},
    {MS_Genespring_MS, "MS:1000684", "Genespring MS", "Software for quantitation and statistical analysis of TOF and Q-TOF LC/MS data.", false},
    {MS_MassHunter_Mass_Profiler, "MS:1000685", "MassHunter Mass Profiler", "Software for quantitation and statistical analysis of TOF and Q-TOF LC/MS data.", false},
    {MS_METLIN, "MS:1000686", "METLIN", "Personal Metabolite Database for MassHunter Workstation. Software for identification of human metabolites.", false},
    {MS_Spectrum_Mill_for_MassHunter_Workstation, "MS:1000687", "Spectrum Mill for MassHunter Workstation", "Software for protein identification and characterization of complex protein digest mixtures.", false},
    {MS_6300_Series_Ion_Trap_Data_Analysis_Software, "MS:1000688", "6300 Series Ion Trap Data Analysis Software", "Software for data analysis of 6300 series ion trap mass spectrometers.", false},
    {MS_Agilent_software, "MS:1000689", "Agilent software", "Agilent software for data acquisition and analysis.", false},
    {MS_SCIEX_software, "MS:1000690", "SCIEX software", "SCIEX or Applied Biosystems software for data acquisition and analysis.", false},
    {MS_Applied_Biosystems_software, "MS:1000691", "Applied Biosystems software", "Applied Biosystems|MDS SCIEX software for data acquisition and analysis.", false},
    {MS_Bruker_software, "MS:1000692", "Bruker software", "Bruker software for data acquisition and analysis.", false},
    {MS_Thermo_Finnigan_software, "MS:1000693", "Thermo Finnigan software", "Thermo Finnigan software for data acquisition and analysis.", false},
    {MS_Waters_software, "MS:1000694", "Waters software", "Waters software for data acquisition and analysis.", false},
    {MS_apex_ultra, "MS:1000695", "apex ultra", "Bruker Daltonics' apex ultra: ESI, MALDI, Nanospray, APCI, APPI, Qh-FT_ICR.", false},
    {MS_autoflex_III_smartbeam, "MS:1000696", "autoflex III smartbeam", "Bruker Daltonics' autoflex III smartbeam: MALDI TOF.", false},
    {MS_Bruker_Daltonics_HCT_Series, "MS:1000697", "Bruker Daltonics HCT Series", "Bruker Daltonics' HCT Series.", false},
    {MS_HCTultra, "MS:1000698", "HCTultra", "Bruker Daltonics' HCTultra: ESI TOF, Nanospray, APCI, APPI.", false},
    {MS_HCTultra_PTM, "MS:1000699", "HCTultra PTM", "Bruker Daltonics' HCTultra PTM: ESI TOF, Nanospray, APCI, APPI, PTR.", false},
    {MS_HCTultra_ETD_II, "MS:1000700", "HCTultra ETD II", "Bruker Daltonics' HCTultra ETD II: ESI Q-TOF, Nanospray, APCI, APPI, ETD.", false},
    {MS_microflex_LT, "MS:1000701", "microflex LT", "Bruker Daltonics' microflex LT: MALDI TOF.", false},
    {MS_micrOTOF, "MS:1000702", "micrOTOF", "Bruker Daltonics' micrOTOF: ESI TOF, APCI, APPI.", false},
    {MS_micrOTOF_Q, "MS:1000703", "micrOTOF-Q", "Bruker Daltonics' micrOTOF-Q: ESI Q-TOF, Nanospray, APCI, APPI.", false},
    {MS_micrOTOF_Q_II, "MS:1000704", "micrOTOF-Q II", "Bruker Daltonics' micrOTOF-Q II: ESI Q-TOF, Nanospray, APCI, APPI.", false},
    {MS_ultraflex_III_TOF_TOF, "MS:1000705", "ultraflex III TOF/TOF", "Bruker Daltonics' ultraflex III TOF/TOF: MALDI TOF.", false},
    {MS_apexControl, "MS:1000706", "apexControl", "Bruker software for data acquisition.", false},
    {MS_BioTools, "MS:1000707", "BioTools", "Bruker software for data analysis.", false},
    {MS_CLINPROT, "MS:1000708", "CLINPROT", "Bruker CLINPROT software.", false},
    {MS_CLINPROT_micro, "MS:1000709", "CLINPROT micro", "Bruker CLINPROT micro software.", false},
    {MS_CLINPROT_robot, "MS:1000710", "CLINPROT robot", "Bruker CLINPROT robot software.", false},
    {MS_ClinProTools, "MS:1000711", "ClinProTools", "Bruker ClinProTools software.", false},
    {MS_Compass, "MS:1000712", "Compass", "Bruker Compass software.", false},
    {MS_Compass_for_HCT_esquire, "MS:1000713", "Compass for HCT/esquire", "Bruker Compass for HCT/esquire software.", false},
    {MS_Compass_for_micrOTOF, "MS:1000714", "Compass for micrOTOF", "Bruker Compass for micrOTOF software.", false},
    {MS_Compass_OpenAccess, "MS:1000715", "Compass OpenAccess", "Bruker compass OpenAccess software.", false},
    {MS_Compass_Security_Pack, "MS:1000716", "Compass Security Pack", "Bruker compass Security Pack software.", false},
    {MS_CompassXport, "MS:1000717", "CompassXport", "Bruker stand-alone software for data conversion.", false},
    {MS_CompassXtract, "MS:1000718", "CompassXtract", "Bruker software library for data access.", false},
    {MS_DataAnalysis, "MS:1000719", "DataAnalysis", "Bruker software for data analysis.", false},
    {MS_dpControl, "MS:1000720", "dpControl", "Bruker software for data acquisition.", false},
    {MS_esquireControl, "MS:1000721", "esquireControl", "Bruker software for data acquisition.", false},
    {MS_flexImaging, "MS:1000722", "flexImaging", "Bruker software for data analysis.", false},
    {MS_GENOLINK, "MS:1000723", "GENOLINK", "Bruker GENOLINK software.", false},
    {MS_GenoTools, "MS:1000724", "GenoTools", "Bruker GenoTools software.", false},
    {MS_HCTcontrol, "MS:1000725", "HCTcontrol", "Bruker software for data acquisition.", false},
    {MS_micrOTOFcontrol, "MS:1000726", "micrOTOFcontrol", "Bruker software for data acquisition.", false},
    {MS_PolyTools, "MS:1000727", "PolyTools", "Bruker PolyTools software.", false},
    {MS_ProfileAnalysis, "MS:1000728", "ProfileAnalysis", "Bruker software for data analysis.", false},
    {MS_PROTEINEER, "MS:1000729", "PROTEINEER", "Bruker PROTEINEER software.", false},
    {MS_PROTEINEER_dp, "MS:1000730", "PROTEINEER dp", "Bruker PROTEINEER dp software.", false},
    {MS_PROTEINEER_fc, "MS:1000731", "PROTEINEER fc", "Bruker PROTEINEER fc software.", false},
    {MS_PROTEINEER_spII, "MS:1000732", "PROTEINEER spII", "Bruker PROTEINEER spII software.", false},
    {MS_PROTEINEER_LC, "MS:1000733", "PROTEINEER-LC", "Bruker PROTEINEER-LC software.", false},
    {MS_ProteinScape, "MS:1000734", "ProteinScape", "Bruker ProteinScape software.", false},
    {MS_PureDisk, "MS:1000735", "PureDisk", "BrukerPureDisk software.", false},
    {MS_QuantAnalysis, "MS:1000736", "QuantAnalysis", "Bruker software for data analysis.", false},
    {MS_spControl, "MS:1000737", "spControl", "Bruker software for data acquisition.", false},
    {MS_TargetAnalysis, "MS:1000738", "TargetAnalysis", "Bruker TargetAnalysis software.", false},
    {MS_WARP_LC, "MS:1000739", "WARP-LC", "Bruker WARP-LC software.", false},
    {MS_parameter_file, "MS:1000740", "parameter file", "Parameter file used to configure the acquisition of raw data on the instrument.", false},
    {MS_Conversion_to_dta, "MS:1000741", "Conversion to dta", "Conversion to dta format.", false},
    {MS_Bioworks_SRF_format, "MS:1000742", "Bioworks SRF format", "Thermo Finnigan SRF file format.", false},
    {MS_TSQ_Quantum_Ultra_AM, "MS:1000743", "TSQ Quantum Ultra AM", "Thermo Scientific TSQ Quantum Ultra AM.", false},
    {MS_selected_ion_m_z, "MS:1000744", "selected ion m/z", "Mass-to-charge ratio of an selected ion.", false},
    {MS_retention_time_alignment, "MS:1000745", "retention time alignment", "The correction of the spectrum scan times, as used e.g. in label-free proteomics.", false},
    {MS_high_intensity_data_point_removal, "MS:1000746", "high intensity data point removal", "The removal of very high intensity data points.", false},
    {MS_completion_time, "MS:1000747", "completion time", "The time that a data processing action was finished.", false},
    {MS_SSQ_7000, "MS:1000748", "SSQ 7000", "ThermoFinnigan SSQ 7000 MS.", false},
    {MS_TSQ_7000, "MS:1000749", "TSQ 7000", "ThermoFinnigan TSQ 7000 MS.", false},
    {MS_TSQ, "MS:1000750", "TSQ", "ThermoFinnigan TSQ MS.", false},
    {MS_TSQ_Quantum_Ultra, "MS:1000751", "TSQ Quantum Ultra", "Thermo Scientific TSQ Quantum Ultra.", false},
    {MS_TOPP_software, "MS:1000752", "TOPP software", "TOPP (The OpenMS proteomics pipeline) software.", false},
    {MS_BaselineFilter, "MS:1000753", "BaselineFilter", "Removes the baseline from profile spectra using a top-hat filter.", false},
    {MS_DBExporter, "MS:1000754", "DBExporter", "Exports data from an OpenMS database to a file.", false},
    {MS_DBImporter, "MS:1000755", "DBImporter", "Imports data to an OpenMS database.", false},
    {MS_FileConverter, "MS:1000756", "FileConverter", "Converts between different MS file formats.", false},
    {MS_FileFilter, "MS:1000757", "FileFilter", "Extracts or manipulates portions of data from peak, feature or consensus feature files.", false},
    {MS_FileMerger, "MS:1000758", "FileMerger", "Merges several MS files into one file.", false},
    {MS_InternalCalibration, "MS:1000759", "InternalCalibration", "Applies an internal calibration.", false},
    {MS_MapAligner_OBSOLETE, "MS:1000760", "MapAligner", "Corrects retention time distortions between maps.", true},
    {MS_MapNormalizer, "MS:1000761", "MapNormalizer", "Normalizes peak intensities in an MS run.", false},
    {MS_NoiseFilter_OBSOLETE, "MS:1000762", "NoiseFilter", "Removes noise from profile spectra by using different smoothing techniques.", true},
    {MS_PeakPicker_OBSOLETE, "MS:1000763", "PeakPicker", "Finds mass spectrometric peaks in profile mass spectra.", true},
    {MS_Resampler, "MS:1000764", "Resampler", "Transforms an LC/MS map into a resampled map or a png image.", false},
    {MS_SpectraFilter_OBSOLETE, "MS:1000765", "SpectraFilter", "Applies a filter to peak spectra.", true},
    {MS_TOFCalibration, "MS:1000766", "TOFCalibration", "Applies time of flight calibration.", false},
    {MS_native_spectrum_identifier_format, "MS:1000767", "native spectrum identifier format", "Describes how the native spectrum identifiers are formated.", false},
    {MS_Thermo_nativeID_format, "MS:1000768", "Thermo nativeID format", "Native format defined by controllerType=xsd:nonNegativeInteger controllerNumber=xsd:positiveInteger scan=xsd:positiveInteger.", false},
    {MS_Waters_nativeID_format, "MS:1000769", "Waters nativeID format", "Native format defined by function=xsd:positiveInteger process=xsd:nonNegativeInteger scan=xsd:nonNegativeInteger.", false},
    {MS_WIFF_nativeID_format, "MS:1000770", "WIFF nativeID format", "Native format defined by sample=xsd:nonNegativeInteger period=xsd:nonNegativeInteger cycle=xsd:nonNegativeInteger experiment=xsd:nonNegativeInteger.", false},
    {MS_Bruker_Agilent_YEP_nativeID_format, "MS:1000771", "Bruker/Agilent YEP nativeID format", "Native format defined by scan=xsd:nonNegativeInteger.", false},
    {MS_Bruker_BAF_nativeID_format, "MS:1000772", "Bruker BAF nativeID format", "Native format defined by scan=xsd:nonNegativeInteger.", false},
    {MS_Bruker_FID_nativeID_format, "MS:1000773", "Bruker FID nativeID format", "Native format defined by file=xsd:IDREF.", false},
    {MS_multiple_peak_list_nativeID_format, "MS:1000774", "multiple peak list nativeID format", "Native format defined by index=xsd:nonNegativeInteger.", false},
    {MS_single_peak_list_nativeID_format, "MS:1000775", "single peak list nativeID format", "Native format defined by file=xsd:IDREF.", false},
    {MS_scan_number_only_nativeID_format, "MS:1000776", "scan number only nativeID format", "Native format defined by scan=xsd:nonNegativeInteger.", false},
    {MS_spectrum_identifier_nativeID_format, "MS:1000777", "spectrum identifier nativeID format", "Native format defined by spectrum=xsd:nonNegativeInteger.", false},
    {MS_charge_state_calculation, "MS:1000778", "charge state calculation", "A process that infers the charge state of an MSn spectrum's precursor(s) by the application of some algorithm.", false},
    {MS_below_precursor_intensity_dominance_charge_state_calculation, "MS:1000779", "below precursor intensity dominance charge state calculation", "Infers charge state as single or ambiguously multiple by determining the fraction of intensity below the precursor m/z.", false},
    {MS_precursor_recalculation, "MS:1000780", "precursor recalculation", "A process that recalculates existing precursor selected ions with one or more algorithmically determined precursor selected ions.", false},
    {MS_msPrefix_precursor_recalculation, "MS:1000781", "msPrefix precursor recalculation", "Recalculates one or more precursor selected ions by peak detection in the isolation windows of high accuracy MS precursor scans.", false},
    {MS_Savitzky_Golay_smoothing, "MS:1000782", "Savitzky-Golay smoothing", "Reduces intensity spikes by applying local polynomial regression (of degree k) on a distribution (of at least k+1 equally spaced points) to determine the smoothed value for each point. It tends to preserve features of the distribution such as relative maxima, minima and width, which are usually 'flattened' by other adjacent averaging techniques.", false},
    {MS_LOWESS_smoothing, "MS:1000783", "LOWESS smoothing", "Reduces intensity spikes by applying a modelling method known as locally weighted polynomial regression. At each point in the data set a low-degree polynomial is fit to a subset of the data, with explanatory variable values near the point whose response is being estimated. The polynomial is fit using weighted least squares, giving more weight to points near the point whose response is being estimated and less weight to points further away. The value of the regression function for the point is then obtained by evaluating the local polynomial using the explanatory variable values for that data point. The LOESS fit is complete after regression function values have been computed for each of the n data points. Many of the details of this method, such as the degree of the polynomial model and the weights, are flexible.", false},
    {MS_Gaussian_smoothing, "MS:1000784", "Gaussian smoothing", "Reduces intensity spikes by convolving the data with a one-dimensional Gaussian function.", false},
    {MS_moving_average_smoothing, "MS:1000785", "moving average smoothing", "Reduces intensity spikes by averaging each point with two or more adjacent points. The more adjacent points that used, the stronger the smoothing effect.", false},
    {MS_non_standard_data_array, "MS:1000786", "non-standard data array", "A data array that contains data not covered by any other term in this group. Please do not use this term, if the binary data array type might be commonly used - contact the PSI-MS working group in order to have another CV term added.", false},
    {MS_inclusive_low_intensity_threshold, "MS:1000787", "inclusive low intensity threshold", "Threshold at or below which some action is taken.", false},
    {MS_inclusive_high_intensity_threshold, "MS:1000788", "inclusive high intensity threshold", "Threshold at or above which some action is taken.", false},
    {MS_enhanced_multiply_charged_spectrum, "MS:1000789", "enhanced multiply charged spectrum", "MS1 spectrum that is enriched in multiply-charged ions compared to singly-charged ions.", false},
    {MS_time_delayed_fragmentation_spectrum, "MS:1000790", "time-delayed fragmentation spectrum", "MSn spectrum in which the product ions are collected after a time delay, which allows the observation of lower energy fragmentation processes after precursor ion activation.", false},
    {MS_enhanced_resolution_scan_OBSOLETE, "MS:1000791", "enhanced resolution scan", "Scan with enhanced resolution.", true},
    {MS_isolation_window_attribute, "MS:1000792", "isolation window attribute", "Isolation window parameter.", false},
    {MS_isolation_window_upper_limit_OBSOLETE, "MS:1000793", "isolation window upper limit", "The highest m/z being isolated in an isolation window.", true},
    {MS_isolation_window_lower_limit_OBSOLETE, "MS:1000794", "isolation window lower limit", "The lowest m/z being isolated in an isolation window.", true},
    {MS_no_combination, "MS:1000795", "no combination", "Use this term if only one scan was recorded or there is no information about scans available.", false},
    {MS_spectrum_title, "MS:1000796", "spectrum title", "Free-form text title describing a spectrum, usually a series of key value pairs as used in an MGF file.", false},
    {MS_peak_list_scans, "MS:1000797", "peak list scans", "A list of scan numbers and or scan ranges associated with a peak list. If possible the list of scans should be converted to native spectrum identifiers instead of using this term.", false},
    {MS_peak_list_raw_scans, "MS:1000798", "peak list raw scans", "A list of raw scans and or scan ranges used to generate a peak list. If possible the list of scans should be converted to native spectrum identifiers instead of using this term.", false},
    {MS_custom_unreleased_software_tool, "MS:1000799", "custom unreleased software tool", "A software tool that has not yet been released. The value should describe the software. Please do not use this term for publicly available software - contact the PSI-MS working group in order to have another CV term added.", false},
    {MS_mass_resolving_power, "MS:1000800", "mass resolving power", "The observed mass divided by the difference between two masses that can be separated: m/dm. The procedure by which dm was obtained and the mass at which the measurement was made should be reported.", false},
    {MS_area_peak_picking, "MS:1000801", "area peak picking", "Spectral peak processing conducted on the acquired data to convert profile data to centroided data. The area defined by all raw data points that belong to the peak is reported.", false},
    {MS_height_peak_picking, "MS:1000802", "height peak picking", "Spectral peak processing conducted on the acquired data to convert profile data to centroided data. The maximum intensity of all raw data points that belong to the peak is reported.", false},
    {MS_analyzer_scan_offset, "MS:1000803", "analyzer scan offset", "Offset between two analyzers in a constant neutral loss or neutral gain scan. The value corresponds to the neutral loss or neutral gain value.", false},
    {MS_electromagnetic_radiation_spectrum, "MS:1000804", "electromagnetic radiation spectrum", "A plot of the relative intensity of electromagnetic radiation as a function of the wavelength.", false},
    {MS_emission_spectrum, "MS:1000805", "emission spectrum", "A plot of the relative intensity of electromagnetic radiation emitted by atoms or molecules when excited.", false},
    {MS_absorption_spectrum, "MS:1000806", "absorption spectrum", "A plot of the relative intensity of electromagnetic radiation absorbed by atoms or molecules when excited.", false},
    {MS_Th_s, "MS:1000807", "Th/s", "Unit describing the scan rate of a spectrum in Thomson per second.", false},
    {MS_chromatogram_attribute, "MS:1000808", "chromatogram attribute", "Chromatogram properties that are associated with a value.", false},
    {MS_chromatogram_title, "MS:1000809", "chromatogram title", "A free-form text title describing a chromatogram.", false},
    {MS_ion_current_chromatogram, "MS:1000810", "ion current chromatogram", "Representation of the current of ions versus time.", false},
    {MS_electromagnetic_radiation_chromatogram, "MS:1000811", "electromagnetic radiation chromatogram", "Representation of electromagnetic properties versus time.", false},
    {MS_absorption_chromatogram, "MS:1000812", "absorption chromatogram", "Representation of light absorbed by the sample versus time.", false},
    {MS_emission_chromatogram, "MS:1000813", "emission chromatogram", "Representation of light emitted by the sample versus time.", false},
    {MS_counts_per_second, "MS:1000814", "counts per second", "The number of counted events observed per second in one or a group of elements of a detector.", false},
    {MS_Bruker_BAF_format, "MS:1000815", "Bruker BAF format", "Bruker BAF raw file format.", false},
    {MS_Bruker_U2_format, "MS:1000816", "Bruker U2 format", "Bruker HyStar U2 file format.", false},
    {MS_HyStar, "MS:1000817", "HyStar", "Bruker software for hyphenated experiments.", false},
    {MS_Acquity_UPLC_PDA, "MS:1000818", "Acquity UPLC PDA", "Acquity UPLC Photodiode Array Detector.", false},
    {MS_Acquity_UPLC_FLR, "MS:1000819", "Acquity UPLC FLR", "Acquity UPLC Fluorescence Detector.", false},
    {MS_flow_rate_array, "MS:1000820", "flow rate array", "A data array of flow rate measurements.", false},
    {MS_pressure_array, "MS:1000821", "pressure array", "A data array of pressure measurements.", false},
    {MS_temperature_array, "MS:1000822", "temperature array", "A data array of temperature measurements.", false},
    {MS_Bruker_U2_nativeID_format, "MS:1000823", "Bruker U2 nativeID format", "Native format defined by declaration=xsd:nonNegativeInteger collection=xsd:nonNegativeInteger scan=xsd:nonNegativeInteger.", false},
    {MS_no_nativeID_format, "MS:1000824", "no nativeID format", "No nativeID format indicates that the file tagged with this term does not contain spectra that can have a nativeID format.", false},
    {MS_Bruker_FID_format, "MS:1000825", "Bruker FID format", "Bruker FID file format.", false},
    {MS_elution_time, "MS:1000826", "elution time", "The time of elution from all used chromatographic columns (one or more) in the chromatographic separation step, relative to the start of the chromatography.", false},
    {MS_isolation_window_target_m_z, "MS:1000827", "isolation window target m/z", "The primary or reference m/z about which the isolation window is defined.", false},
    {MS_isolation_window_lower_offset, "MS:1000828", "isolation window lower offset", "The extent of the isolation window in m/z below the isolation window target m/z. The lower and upper offsets may be asymmetric about the target m/z.", false},
    {MS_isolation_window_upper_offset, "MS:1000829", "isolation window upper offset", "The extent of the isolation window in m/z above the isolation window target m/z. The lower and upper offsets may be asymmetric about the target m/z.", false},
    {MS_sample_preparation, "MS:1000831", "sample preparation", "Properties of the preparation steps which took place before the measurement was performed.", false},
    {MS_MALDI_matrix_application, "MS:1000832", "MALDI matrix application", "Attributes to describe the technique how the sample is prepared with the matrix solution.", false},
    {MS_matrix_application_type, "MS:1000833", "matrix application type", "Describes the technique how the matrix is put on the sample target.", false},
    {MS_matrix_solution, "MS:1000834", "matrix solution", "Describes the chemical solution used as matrix.", false},
    {MS_matrix_solution_concentration, "MS:1000835", "matrix solution concentration", "Concentration of the chemical solution used as matrix.", false},
    {MS_dried_droplet_MALDI_matrix_preparation, "MS:1000836", "dried droplet MALDI matrix preparation", "Dried droplet in MALDI matrix preparation.", false},
    {MS_printed_MALDI_matrix_preparation, "MS:1000837", "printed MALDI matrix preparation", "Printed MALDI matrix preparation.", false},
    {MS_sprayed_MALDI_matrix_preparation, "MS:1000838", "sprayed MALDI matrix preparation", "Sprayed MALDI matrix preparation.", false},
    {MS_precoated_MALDI_sample_plate, "MS:1000839", "precoated MALDI sample plate", "Precoated MALDI sample plate.", false},
    {MS_laser, "MS:1000840", "laser", "Device that emits light (electromagnetic radiation) through a process called stimulated emission. The term is an acronym for Light Amplification by Stimulated Emission of Radiation.", false},
    {MS_laser_attribute, "MS:1000841", "laser attribute", "Laser properties that are associated with a value.", false},
    {MS_laser_type, "MS:1000842", "laser type", "Type of laser used for desorption purpose.", false},
    {MS_wavelength_OBSOLETE, "MS:1000843", "wavelength", "The distance between two peaks of the emitted laser beam.", true},
    {MS_focus_diameter_x, "MS:1000844", "focus diameter x", "Describes the diameter of the laser beam in x direction.", false},
    {MS_focus_diameter_y, "MS:1000845", "focus diameter y", "Describes the diameter of the laser beam in y direction.", false},
    {MS_pulse_energy, "MS:1000846", "pulse energy", "Describes output energy of the laser system. May be attenuated by filters or other means.", false},
    {MS_pulse_duration, "MS:1000847", "pulse duration", "Describes how long the laser beam was emitted from the laser device.", false},
    {MS_attenuation, "MS:1000848", "attenuation", "Describes the reduction of the intensity of the laser beam energy.", false},
    {MS_impact_angle, "MS:1000849", "impact angle", "Describes the angle between the laser beam and the sample target.", false},
    {MS_gas_laser, "MS:1000850", "gas laser", "Laser which is powered by a gaseous medium.", false},
    {MS_solid_state_laser, "MS:1000851", "solid-state laser", "Solid state laser materials are commonly made by doping a crystalline solid host with ions that provide the required energy states.", false},
    {MS_dye_laser, "MS:1000852", "dye-laser", "Dye lasers use an organic dye as the gain medium.", false},
    {MS_free_electron_laser, "MS:1000853", "free electron laser", "Free electron laser uses a relativistic electron beam as the lasing medium which move freely through a magnetic structure, hence the term.", false},
    {MS_LTQ_XL, "MS:1000854", "LTQ XL", "Thermo Scientific LTQ XL MS.", false},
    {MS_LTQ_Velos, "MS:1000855", "LTQ Velos", "Thermo Scientific LTQ Velos MS.", false},
    {MS_LTQ_Velos_ETD, "MS:1000856", "LTQ Velos ETD", "Thermo Scientific LTQ Velos MS with ETD.", false},
    {MS_run_attribute, "MS:1000857", "run attribute", "Properties of the described run.", false},
    {MS_fraction_identifier, "MS:1000858", "fraction identifier", "Identier string that describes the sample fraction. This identifier should contain the fraction number(s) or similar information.", false},
    {MS_molecule, "MS:1000859", "molecule", "Group of two or more atoms held together by chemical bonds.", false},
    {MS_peptide, "MS:1000860", "peptide", "A molecule of low molecular weight that is composed of two or more amino acid residues.", false},
    {MS_molecular_entity_property, "MS:1000861", "molecular entity property", "A physical characteristic of a molecular entity.", false},
    {MS_isoelectric_point, "MS:1000862", "isoelectric point", "The pH of a solution at which a charged molecule does not migrate in an electric field.", false},
    {MS_predicted_isoelectric_point, "MS:1000863", "predicted isoelectric point", "The pH of a solution at which a charged molecule would not migrate in an electric field, as predicted by a software algorithm.", false},
    {MS_chemical_formula, "MS:1000864", "chemical formula", "A combination of symbols used to express the chemical composition of a molecule.", false},
    {MS_empirical_formula, "MS:1000865", "empirical formula", "A chemical formula which expresses the proportions of the elements present in a substance.", false},
    {MS_molecular_formula, "MS:1000866", "molecular formula", "A chemical compound formula expressing the number of atoms of each element present in a compound, without indicating how they are linked.", false},
    {MS_structural_formula, "MS:1000867", "structural formula", "A chemical formula showing the number of atoms of each element in a molecule, their spatial arrangement, and their linkage to each other.", false},
    {MS_SMILES_formula, "MS:1000868", "SMILES formula", "The simplified molecular input line entry specification or SMILES is a specification for unambiguously describing the structure of a chemical compound using a short ASCII string.", false},
    {MS_collision_gas_pressure, "MS:1000869", "collision gas pressure", "The gas pressure of the collision gas used for collisional excitation.", false},
    {MS_4000_QTRAP_OBSOLETE, "MS:1000870", "4000 QTRAP", "SCIEX or Applied Biosystems|MDS SCIEX QTRAP 4000.", true},
    {MS_SRM_software, "MS:1000871", "SRM software", "Software used to predict, select, or optimize transitions or analyze the results of selected reaction monitoring runs.", false},
    {MS_MaRiMba, "MS:1000872", "MaRiMba", "Software used to predict transitions for selected reaction monitoring experiments based on observed spectrum libraries developed and distributed by the Institute for Systems Biology.", false},
    {MS_peptide_attribute_calculation_software, "MS:1000873", "peptide attribute calculation software", "Software used to predict or calculate numerical attributes of peptides.", false},
    {MS_SSRCalc, "MS:1000874", "SSRCalc", "Sequence Specific Retention Calculator estimates the retention time of peptides based on their sequence.", false},
    {MS_declustering_potential, "MS:1000875", "declustering potential", "Potential difference between the orifice and the skimmer in volts.", false},
    {MS_cone_voltage, "MS:1000876", "cone voltage", "Potential difference between the sampling cone/orifice in volts.", false},
    {MS_tube_lens_voltage, "MS:1000877", "tube lens voltage", "Potential difference setting of the tube lens in volts.", false},
    {MS_external_reference_identifier, "MS:1000878", "external reference identifier", "An identifier/accession number to an external reference database.", false},
    {MS_PubMed_identifier, "MS:1000879", "PubMed identifier", "A unique identifier for a publication in the PubMed database (MIR:00000015).", false},
    {MS_interchannel_delay, "MS:1000880", "interchannel delay", "The duration of intervals between scanning, during which the instrument configuration is switched.", false},
    {MS_molecular_entity, "MS:1000881", "molecular entity", "Constitutionally or isotopically distinct atom, molecule, ion, ion pair, radical, radical ion, complex, conformer, etc., identifiable as a separately distinguishable entity.", false},
    {MS_protein, "MS:1000882", "protein", "A compound composed of one or more chains of amino acids in a specific order determined by the base sequence of nucleotides in the DNA of a gene.", false},
    {MS_protein_short_name, "MS:1000883", "protein short name", "A short name or symbol of a protein (e.g., HSF 1 or HSF1_HUMAN).", false},
    {MS_protein_attribute, "MS:1000884", "protein attribute", "An nonphysical characterstic attributed to a specific protein.", false},
    {MS_protein_accession, "MS:1000885", "protein accession", "Identifier for a specific protein in a database.", false},
    {MS_protein_name, "MS:1000886", "protein name", "A long name describing the function of the protein.", false},
    {MS_peptide_attribute, "MS:1000887", "peptide attribute", "Nonphysical characteristic attributed to a peptide.", false},
    {MS_stripped_peptide_sequence, "MS:1000888", "stripped peptide sequence", "Sequence of letter symbols denoting the order of amino acids that compose the peptide, with any amino acid mass modifications that might be present having been stripped away.", false},
    {MS_peptidoform_sequence, "MS:1000889", "peptidoform sequence", "Sequence of letter symbols denoting the order of amino acid residues that compose the peptidoform including the encoding of any residue modifications that are present.", false},
    {MS_peptidoform_labeling_state, "MS:1000890", "peptidoform labeling state", "A state description of how a peptide might be isotopically or isobarically labelled.", false},
    {MS_heavy_labeled_peptidoform, "MS:1000891", "heavy labeled peptidoform", "A peptide that has been created or labelled with some heavier-than-usual isotopes.", false},
    {MS_unlabeled_peptidoform, "MS:1000892", "unlabeled peptidoform", "A peptide that has not been labelled with heavier-than-usual isotopes. This is often referred to as \\\"light\\\" to distinguish from \\\"heavy\\\".", false},
    {MS_peptidoform_group_label, "MS:1000893", "peptidoform group label", "An arbitrary string label used to mark a set of peptides that belong together in a set, whereby the members are differentiated by different isotopic labels. For example, the heavy and light forms of the same peptide will both be assigned the same peptide group label.", false},
    {MS_retention_time, "MS:1000894", "retention time", "A time interval from the start of chromatography when an analyte exits a chromatographic column.", false},
    {MS_local_retention_time, "MS:1000895", "local retention time", "A time interval from the start of chromatography when an analyte exits an unspecified local chromatographic column and instrumental setup.", false},
    {MS_normalized_retention_time, "MS:1000896", "normalized retention time", "A time interval from the start of chromatography when an analyte exits a standardized reference chromatographic column and instrumental setup.", false},
    {MS_predicted_retention_time, "MS:1000897", "predicted retention time", "A time interval from the start of chromatography when an analyte exits a chromatographic column as predicted by a referenced software application.", false},
    {MS_standard, "MS:1000898", "standard", "Something, such as a practice or a product, that is widely recognized or employed, especially because of its excellence.", false},
    {MS_de_facto_standard, "MS:1000899", "de facto standard", "A practice or product that has become a standard not because it has been approved by a standards organization but because it is widely used and recognized by the industry as being standard.", false},
    {MS_minimum_information_standard, "MS:1000900", "minimum information standard", "A specification of a minimum amount of information needed to reproduce or fully interpret a scientific result.", false},
    {MS_retention_time_normalization_standard, "MS:1000901", "retention time normalization standard", "A standard providing the retention times at which a set of reference compounds exit the reference chromatographic column.", false},
    {MS_H_PINS_retention_time_normalization_standard, "MS:1000902", "H-PINS retention time normalization standard", "The de facto standard providing the retention times at which a set of halogenated reference peptides exit the reference chromatographic column.", false},
    {MS_product_ion_series_ordinal, "MS:1000903", "product ion series ordinal", "The ordinal of the fragment within a specified ion series. (e.g. 8 for a y8 ion).", false},
    {MS_product_ion_m_z_delta, "MS:1000904", "product ion m/z delta", "The difference in m/z of the predicted m/z based on the assigned product ion minus the actual observed peak m/z.", false},
    {MS_percent_of_base_peak_times_100, "MS:1000905", "percent of base peak times 100", "The magnitude of a peak expressed in terms of the percentage of the magnitude of the base peak intensity multiplied by 100. The base peak is therefore 10000. This unit is common in normalized spectrum libraries.", false},
    {MS_peak_intensity_rank, "MS:1000906", "peak intensity rank", "Ordinal specifying the rank in intensity of a peak in a spectrum. Base peak is 1. The next most intense peak is 2, etc.", false},
    {MS_peak_targeting_suitability_rank, "MS:1000907", "peak targeting suitability rank", "Ordinal specifying the rank of a peak in a spectrum in terms of suitability for targeting. The most suitable peak is 1. The next most suitability peak is 2, etc. Suitability is algorithm and context dependant.", false},
    {MS_transition, "MS:1000908", "transition", "A set of two m/z values corresponding to the precursor m/z and a fragment m/z that in combination can be used to identify or quantify a specific ion, although not necessarily uniquely.", false},
    {MS_transition_validation_method, "MS:1000909", "transition validation method", "The strategy used to validate that a transition is effective.", false},
    {MS_transition_optimized_on_specified_instrument, "MS:1000910", "transition optimized on specified instrument", "The transition has been optimized by direct injection of the peptide into an instrument specified in a separate term, and the optimum voltages and fragmentation energies have been determined.", false},
    {MS_transition_validated_with_an_MS_MS_spectrum_on_specified_instrument, "MS:1000911", "transition validated with an MS/MS spectrum on specified instrument", "The transition has been validated by obtaining an MS2 spectrum and demonstrating that the peak is detectable on the instrument specified with a separate term.", false},
    {MS_transition_purported_from_an_MS_MS_spectrum_on_a_different__specified_instrument, "MS:1000912", "transition purported from an MS/MS spectrum on a different, specified instrument", "The transition has been purported by obtaining an MS2 spectrum and demonstrating that the peak is detectable on the instrument specified with a separate term. However, the detecting instrument is of a different type (e.g. ion trap) than the instrument that the transition will eventually be used on (e.g. triple quad).", false},
    {MS_transition_predicted_by_informatic_analysis, "MS:1000913", "transition predicted by informatic analysis", "The transition has been predicted by informatics software without any direct spectral evidence.", false},
    {MS_tab_delimited_text_format, "MS:1000914", "tab delimited text format", "A file format that has two or more columns of tabular data where each column is separated by a TAB character.", false},
    {MS_retention_time_window_attribute, "MS:1000915", "retention time window attribute", "An attribute of a window in time about which a peptide might elute from the column.", false},
    {MS_retention_time_window_lower_offset, "MS:1000916", "retention time window lower offset", "The extent of the retention time window in time units below the target retention time. The lower and upper offsets may be asymmetric about the target time.", false},
    {MS_retention_time_window_upper_offset, "MS:1000917", "retention time window upper offset", "The extent of the retention time window in time units above the target retention time. The lower and upper offsets may be asymmetric about the target time.", false},
    {MS_target_list, "MS:1000918", "target list", "A list of peptides or compounds and their expected m/z coordinates that can be used to cause a mass spectrometry to obtain spectra of those molecules specifically.", false},
    {MS_target_inclusion_exclusion_priority, "MS:1000919", "target inclusion exclusion priority", "A priority setting specifying whether included or excluded targets have priority over the other.", false},
    {MS_includes_supersede_excludes, "MS:1000920", "includes supersede excludes", "A priority setting specifying that included targets have priority over the excluded targets if there is a conflict.", false},
    {MS_excludes_supersede_includes, "MS:1000921", "excludes supersede includes", "A priority setting specifying that excluded targets have priority over the included targets if there is a conflict.", false},
    {MS_Skyline, "MS:1000922", "Skyline", "Software used to predict, select, and optimize transitions as well as analyze the results of selected reaction monitoring runs developed and distributed by the MacCoss lab at the University of Washington.", false},
    {MS_TIQAM, "MS:1000923", "TIQAM", "Software used to predict, select, and optimize transitions for selected reaction monitoring experiments developed and distributed by the Institute for Systems Biology.", false},
    {MS_MaRiMba_OBSOLETE, "MS:1000924", "MaRiMba", "Software used to predict transitions for selected reaction monitoring experiments based on observed spectrum libraries developed and distributed by the Institute for Systems Biology.", true},
    {MS_ATAQS, "MS:1000925", "ATAQS", "Software suite used to predict, select, and optimize transitions as well as analyze the results of selected reaction monitoring runs developed and distributed by the Institute for Systems Biology.", false},
    {MS_product_interpretation_rank, "MS:1000926", "product interpretation rank", "The integer rank given an interpretation of an observed product ion. For example, if y8 is selected as the most likely interpretation of a peak, then it is assigned a rank of 1.", false},
    {MS_ion_injection_time, "MS:1000927", "ion injection time", "The length of time spent filling an ion trapping device.", false},
    {MS_calibration_spectrum, "MS:1000928", "calibration spectrum", "A spectrum derived from a special calibration source, rather than from the primary injected sample. A calibration spectrum is typically derived from a substance that can be used to correct systematic shift in m/z for spectra of the primary inject sample.", false},
    {MS_Shimadzu_Biotech_nativeID_format, "MS:1000929", "Shimadzu Biotech nativeID format", "Native format defined by source=xsd:string start=xsd:nonNegativeInteger end=xsd:nonNegativeInteger.", false},
    {MS_Shimadzu_Biotech_database_entity, "MS:1000930", "Shimadzu Biotech database entity", "Shimadzu Biotech format.", false},
    {MS_QTRAP_5500, "MS:1000931", "QTRAP 5500", "Applied Biosystems|MDS SCIEX QTRAP 5500.", false},
    {MS_TripleTOF_5600, "MS:1000932", "TripleTOF 5600", "SCIEX TripleTOF 5600, a quadrupole - quadrupole - time-of-flight mass spectrometer.", false},
    {MS_protein_modifications, "MS:1000933", "protein modifications", "Encoding of modifications of the protein sequence from the specified accession, written in PEFF notation.", false},
    {MS_gene_name, "MS:1000934", "gene name", "Name of the gene from which the protein is translated.", false},
    {MS_6470A_Triple_Quadrupole_LC_MS, "MS:1000935", "6470A Triple Quadrupole LC/MS", "The 6470A Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_6470B_Triple_Quadrupole_LC_MS, "MS:1000936", "6470B Triple Quadrupole LC/MS", "The 6470B Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_6495C_Triple_Quadrupole_LC_MS, "MS:1000937", "6495C Triple Quadrupole LC/MS", "The 6495C Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_spectrum_interpretation, "MS:1001000", "spectrum interpretation", "Collection of terms from the PSI Proteome Informatics standards describing the interpretation of spectra.", false},
    {MS_SEQUEST_CleavesAt, "MS:1001005", "SEQUEST:CleavesAt", "", false},
    {MS_SEQUEST_ViewCV, "MS:1001006", "SEQUEST:ViewCV", "SEQUEST View Input Parameters.", false},
    {MS_SEQUEST_OutputLines, "MS:1001007", "SEQUEST:OutputLines", "Number of peptide results to show.", false},
    {MS_SEQUEST_DescriptionLines, "MS:1001009", "SEQUEST:DescriptionLines", "Number of full protein descriptions to show for top N peptides.", false},
    {MS_de_novo_search, "MS:1001010", "de novo search", "A de novo sequencing search (without database).", false},
    {MS_search_database_details, "MS:1001011", "search database details", "Details about the database searched.", false},
    {MS_database_source, "MS:1001012", "database source", "The organisation, project or laboratory from where the database is obtained (UniProt, NCBI, EBI, other).", false},
    {MS_database_name, "MS:1001013", "database name", "The name of the search database (nr, SwissProt or est_human).", false},
    {MS_database_local_file_path_OBSOLETE, "MS:1001014", "database local file path", "OBSOLETE: Use attribute in mzIdentML instead. Local file path of the search database from the search engine's point of view.", true},
    {MS_database_original_uri, "MS:1001015", "database original uri", "URI, from where the search database was originally downloaded.", false},
    {MS_database_version, "MS:1001016", "database version", "Version of the search database. In mzIdentML use the attribute instead.", false},
    {MS_release_date, "MS:1001017", "release date", "Date and time at which a product was publicly released. For mzIdentML, use the database release date XML attribute instead of this term.", false},
    {MS_database_type, "MS:1001018", "database type", "Database containing amino acid or nucleic acid sequences.", false},
    {MS_database_filtering, "MS:1001019", "database filtering", "Was there filtering used on the database.", false},
    {MS_DB_filter_taxonomy, "MS:1001020", "DB filter taxonomy", "A taxonomy filter was to the database search.", false},
    {MS_DB_filter_on_accession_numbers, "MS:1001021", "DB filter on accession numbers", "Filtering applied specifically by accession number pattern.", false},
    {MS_DB_MW_filter, "MS:1001022", "DB MW filter", "Filtering applied specifically by protein molecular weight, specified as either a range or above/below a threshold value.", false},
    {MS_DB_PI_filter, "MS:1001023", "DB PI filter", "Filtering applied specifically by predicted protein isoelectric focussing point (pI), specified as either a range or above/below a threshold value.", false},
    {MS_translation_frame, "MS:1001024", "translation frame", "The translated open reading frames from a nucleotide database considered in the search (range: 1-6).", false},
    {MS_translation_table, "MS:1001025", "translation table", "The translation table used to translate the nucleotides to amino acids.", false},
    {MS_SEQUEST_NormalizeXCorrValues, "MS:1001026", "SEQUEST:NormalizeXCorrValues", "", false},
    {MS_DB_filter_on_sequence_pattern, "MS:1001027", "DB filter on sequence pattern", "Filtering applied specifically by amino acid sequence pattern.", false},
    {MS_SEQUEST_SequenceHeaderFilter, "MS:1001028", "SEQUEST:SequenceHeaderFilter", "String in the header of a sequence entry for that entry to be searched.", false},
    {MS_number_of_sequences_searched, "MS:1001029", "number of sequences searched", "The number of sequences (proteins / nucleotides) from the database search after filtering.", false},
    {MS_number_of_peptide_seqs_compared_to_each_spectrum, "MS:1001030", "number of peptide seqs compared to each spectrum", "Number of peptide seqs compared to each spectrum.", false},
    {MS_spectral_library_search, "MS:1001031", "spectral library search", "A search using a library of spectra.", false},
    {MS_SEQUEST_SequencePartialFilter, "MS:1001032", "SEQUEST:SequencePartialFilter", "", false},
    {MS_date___time_search_performed_OBSOLETE, "MS:1001035", "date / time search performed", "OBSOLETE: use attribute in mzIdentML instead. Date and time of the actual search run.", true},
    {MS_search_time_taken, "MS:1001036", "search time taken", "The time taken to complete the search in seconds.", false},
    {MS_SEQUEST_ShowFragmentIons, "MS:1001037", "SEQUEST:ShowFragmentIons", "Flag indicating that fragment ions should be shown.", false},
    {MS_SEQUEST_Consensus, "MS:1001038", "SEQUEST:Consensus", "Specify depth as value of the CVParam.", false},
    {MS_intermediate_analysis_format, "MS:1001040", "intermediate analysis format", "Type of the source file, the mzIdentML was created from.", false},
    {MS_SEQUEST_sortCV, "MS:1001041", "SEQUEST:sortCV", "SEQUEST View / Sort Input Parameters.", false},
    {MS_SEQUEST_LimitTo, "MS:1001042", "SEQUEST:LimitTo", "Specify \\\"number of dtas shown\\\" as value of the CVParam.", false},
    {MS_cleavage_agent_details, "MS:1001044", "cleavage agent details", "Details of cleavage agent (enzyme).", false},
    {MS_cleavage_agent_name, "MS:1001045", "cleavage agent name", "The name of the cleavage agent.", false},
    {MS_SEQUEST_sort_by_dCn, "MS:1001046", "SEQUEST:sort by dCn", "Sort order of SEQUEST search results by the delta of the normalized correlation score.", false},
    {MS_SEQUEST_sort_by_dM, "MS:1001047", "SEQUEST:sort by dM", "Sort order of SEQUEST search results by the difference between a theoretically calculated and the corresponding experimentally measured molecular mass M.", false},
    {MS_SEQUEST_sort_by_Ions, "MS:1001048", "SEQUEST:sort by Ions", "Sort order of SEQUEST search results given by the ions.", false},
    {MS_SEQUEST_sort_by_MH_, "MS:1001049", "SEQUEST:sort by MH+", "Sort order of SEQUEST search results given by the mass of the protonated ion.", false},
    {MS_SEQUEST_sort_by_P, "MS:1001050", "SEQUEST:sort by P", "Sort order of SEQUEST search results given by the probability.", false},
    {MS_multiple_enzyme_combination_rules_OBSOLETE, "MS:1001051", "multiple enzyme combination rules", "OBSOLETE: use attribute independent in mzIdentML instead. Description of multiple enzyme digestion protocol, if any.", true},
    {MS_SEQUEST_sort_by_PreviousAminoAcid, "MS:1001052", "SEQUEST:sort by PreviousAminoAcid", "Sort order of SEQUEST search results given by the previous amino acid.", false},
    {MS_SEQUEST_sort_by_Ref, "MS:1001053", "SEQUEST:sort by Ref", "Sort order of SEQUEST search results given by the reference.", false},
    {MS_modification_parameters, "MS:1001055", "modification parameters", "Modification parameters for the search engine run.", false},
    {MS_modification_specificity_rule, "MS:1001056", "modification specificity rule", "The specificity rules for the modifications applied by the search engine.", false},
    {MS_tolerance_on_types_OBSOLETE, "MS:1001057", "tolerance on types", "OBSOLETE: Tolerance on types.", true},
    {MS_quality_estimation_by_manual_validation, "MS:1001058", "quality estimation by manual validation", "The quality estimation was done manually.", false},
    {MS_SEQUEST_sort_by_RSp, "MS:1001059", "SEQUEST:sort by RSp", "Sort order of SEQUEST search results given by the result 'Sp' of 'Rank/Sp' in the out file (peptide).", false},
    {MS_quality_estimation_method_details, "MS:1001060", "quality estimation method details", "Method for quality estimation (manually or with decoy database).", false},
    {MS_neutral_loss_OBSOLETE, "MS:1001061", "neutral loss", "OBSOLETE: replaced by MS:1000336 (neutral loss): Leave this to PSI-MOD.", true},
    {MS_Mascot_MGF_format, "MS:1001062", "Mascot MGF format", "Mascot MGF file format.", false},
    {MS_TODOscoring_model_OBSOLETE, "MS:1001065", "TODOscoring model", "OBSOLETE: There is Phenyx:ScoringModel for Phenyx! Scoring model (more detailed granularity). TODO: add some child terms.", true},
    {MS_ions_series_considered_in_search, "MS:1001066", "ions series considered in search", "The description of the DEPRECATED ion fragment series (including charges and neutral losses) that are considered by the search engine.", false},
    {MS_SEQUEST_sort_by_Sp, "MS:1001068", "SEQUEST:sort by Sp", "Sort order of SEQUEST search results by the Sp score.", false},
    {MS_SEQUEST_sort_by_TIC, "MS:1001069", "SEQUEST:sort by TIC", "Sort order of SEQUEST search results given by the total ion current.", false},
    {MS_SEQUEST_sort_by_Scan, "MS:1001070", "SEQUEST:sort by Scan", "Sort order of SEQUEST search results given by the scan number.", false},
    {MS_SEQUEST_sort_by_Sequence, "MS:1001071", "SEQUEST:sort by Sequence", "Sort order of SEQUEST search results given by the sequence.", false},
    {MS_SEQUEST_sort_by_Sf, "MS:1001072", "SEQUEST:sort by Sf", "Sort order of SEQUEST search results given by the SEQUEST result 'Sf'.", false},
    {MS_database_type_amino_acid, "MS:1001073", "database type amino acid", "Database contains amino acid sequences.", false},
    {MS_database_type_nucleotide, "MS:1001079", "database type nucleotide", "Database contains nucleic acid sequences.", false},
    {MS_search_type, "MS:1001080", "search type", "Enumeration of type of search value (i.e. from PMF, sequence tag, MS2).", false},
    {MS_pmf_search, "MS:1001081", "pmf search", "A peptide mass fingerprint search.", false},
    {MS_tag_search, "MS:1001082", "tag search", "A sequence tag search.", false},
    {MS_ms_ms_search, "MS:1001083", "ms-ms search", "An MS2 search (with fragment ions).", false},
    {MS_database_nr, "MS:1001084", "database nr", "Non-redundant GenBank sequence database.", false},
    {MS_protein_level_identification_attribute, "MS:1001085", "protein-level identification attribute", "Protein level information.", false},
    {MS_SEQUEST_sort_by_XCorr, "MS:1001086", "SEQUEST:sort by XCorr", "Sort order of SEQUEST search results by the correlation score.", false},
    {MS_SEQUEST_ProcessCV, "MS:1001087", "SEQUEST:ProcessCV", "SEQUEST View / Process Input Parameters.", false},
    {MS_protein_description, "MS:1001088", "protein description", "The protein description line from the sequence entry in the source database FASTA file.", false},
    {MS_molecule_taxonomy, "MS:1001089", "molecule taxonomy", "The taxonomy of the resultant molecule from the search.", false},
    {MS_taxonomy_nomenclature_OBSOLETE, "MS:1001090", "taxonomy nomenclature", "OBSOLETE: The system used to indicate taxonomy. There should be an enumerated list of options: latin name, NCBI TaxID, common name, Swiss-Prot species ID (ex. RABIT from the full protein ID ALBU_RABIT).", true},
    {MS_NoEnzyme_OBSOLETE, "MS:1001091", "NoEnzyme", "", true},
    {MS_peptide_sequence_level_identification_statistic, "MS:1001092", "peptide sequence-level identification statistic", "Identification confidence metric for a peptide.", false},
    {MS_sequence_coverage, "MS:1001093", "sequence coverage", "The percent coverage for the protein based upon the matched peptide sequences (can be calculated).", false},
    {MS_SEQUEST_sort_by_z, "MS:1001094", "SEQUEST:sort by z", "Sort order of SEQUEST search results given by the charge.", false},
    {MS_SEQUEST_ProcessAll, "MS:1001095", "SEQUEST:ProcessAll", "", false},
    {MS_SEQUEST_TopPercentMostIntense, "MS:1001096", "SEQUEST:TopPercentMostIntense", "Specify \\\"percentage\\\" as value of the CVParam.", false},
    {MS_distinct_peptide_sequences, "MS:1001097", "distinct peptide sequences", "This counts distinct sequences hitting the protein without regard to a minimal confidence threshold.", false},
    {MS_confident_distinct_peptide_sequences, "MS:1001098", "confident distinct peptide sequences", "This counts the number of distinct peptide sequences. Multiple charge states and multiple modification states do NOT count as multiple sequences. The definition of 'confident' must be qualified elsewhere.", false},
    {MS_confident_peptide_qualification, "MS:1001099", "confident peptide qualification", "The point of this entry is to define what is meant by confident for the term Confident distinct peptide sequence and/or Confident peptides. Example 1 - metric=Paragon:Confidence value=95 sense=greater than Example 2 - metric=Mascot:Eval value=0.05 sense=less than.", false},
    {MS_confident_peptide_sequence_number, "MS:1001100", "confident peptide sequence number", "This counts the number of peptide sequences without regard to whether they are distinct. Multiple charges states and multiple modification states DO count as multiple peptides. The definition of 'confident' must be qualified elsewhere.", false},
    {MS_protein_group_or_subset_relationship, "MS:1001101", "protein group or subset relationship", "Protein group or subset relationships.", false},
    {MS_SEQUEST_Chromatogram, "MS:1001102", "SEQUEST:Chromatogram", "", false},
    {MS_SEQUEST_InfoAndLog, "MS:1001103", "SEQUEST:InfoAndLog", "", false},
    {MS_database_UniProtKB_Swiss_Prot, "MS:1001104", "database UniProtKB/Swiss-Prot", "The name of the UniProtKB/Swiss-Prot knowledgebase.", false},
    {MS_peptide_sequence_level_identification_attribute, "MS:1001105", "peptide sequence-level identification attribute", "Peptide level information.", false},
    {MS_SEQUEST_TopNumber, "MS:1001106", "SEQUEST:TopNumber", "Specify \\\"number\\\" as value of the CVParam.", false},
    {MS_data_stored_in_database, "MS:1001107", "data stored in database", "Source file for this mzIdentML was a data set in a database.", false},
    {MS_param__a_ion, "MS:1001108", "param: a ion", "Parameter information, type of product: a ion with charge on the N-terminal side.", false},
    {MS_SEQUEST_CullTo, "MS:1001109", "SEQUEST:CullTo", "Specify cull string as value of the CVParam.", false},
    {MS_SEQUEST_modeCV, "MS:1001110", "SEQUEST:modeCV", "SEQUEST Mode Input Parameters.", false},
    {MS_SEQUEST_Full, "MS:1001111", "SEQUEST:Full", "", false},
    {MS_n_terminal_flanking_residue, "MS:1001112", "n-terminal flanking residue", "Residue preceding the first amino acid in the peptide sequence as it occurs in the protein. Use 'N-term' to denote if the peptide starts at the N terminus of the protein.", false},
    {MS_c_terminal_flanking_residue, "MS:1001113", "c-terminal flanking residue", "Residue following the last amino acid in the peptide sequence as it occurs in the protein. Use 'C-term' to denote if the peptide ends at the C terminus of the protein.", false},
    {MS_retention_time_s__OBSOLETE, "MS:1001114", "retention time(s)", "Retention time of the spectrum from the source file.", true},
    {MS_scan_number_s__OBSOLETE, "MS:1001115", "scan number(s)", "OBSOLETE: use spectrumID attribute of SpectrumIdentificationResult. Take from mzData.", true},
    {MS_single_protein_identification_statistic, "MS:1001116", "single protein identification statistic", "Results specific for one protein as part of a protein ambiguity group (a result not valid for all the other proteins in the protein ambiguity group).", false},
    {MS_theoretical_mass, "MS:1001117", "theoretical mass", "The theoretical neutral mass of the molecule (e.g. the peptide sequence and its modifications) not including its charge carrier.", false},
    {MS_param__b_ion, "MS:1001118", "param: b ion", "Parameter information, type of product: b ion with charge on the N-terminal side.", false},
    {MS_param__c_ion, "MS:1001119", "param: c ion", "Parameter information, type of product: c ion with charge on the N-terminal side.", false},
    {MS_SEQUEST_FormatAndLinks, "MS:1001120", "SEQUEST:FormatAndLinks", "", false},
    {MS_number_of_matched_peaks, "MS:1001121", "number of matched peaks", "The number of peaks that were matched as qualified by the ion series considered field. If a peak matches multiple ions then only 1 would be added the count.", false},
    {MS_ions_series_considered, "MS:1001122", "ions series considered", "The ion series that were used during the calculation of the count (e.g. a, b, c, d, v, w, x, y, z, a-H2O, a-NH3, b-H2O, b-NH3, y-H2O, y-NH3, b-H20, b+, z-, z+1, z+2, b-H3PO4, y-H3PO4, immonium, internal ya, internal yb).", false},
    {MS_number_of_peaks_used, "MS:1001123", "number of peaks used", "The number of peaks from the original peak list that are used to calculate the scores for a particular search engine. All ions that have the opportunity to match or be counted even if they don't.", false},
    {MS_number_of_peaks_submitted, "MS:1001124", "number of peaks submitted", "The number of peaks from the original peaks listed that were submitted to the search engine.", false},
    {MS_manual_validation, "MS:1001125", "manual validation", "Result of quality estimation: decision of a manual validation.", false},
    {MS_SEQUEST_Fast, "MS:1001126", "SEQUEST:Fast", "", false},
    {MS_peptide_sharing_details, "MS:1001127", "peptide sharing details", "Accessions Containing Sequence - Accessions for each protein containing this peptide.", false},
    {MS_SEQUEST_selectCV, "MS:1001128", "SEQUEST:selectCV", "SEQUEST Select Input Parameters.", false},
    {MS_quantification_information, "MS:1001129", "quantification information", "Quantification information.", false},
    {MS_peptide_raw_area_OBSOLETE, "MS:1001130", "peptide raw area", "Peptide raw area.", true},
    {MS_error_on_peptide_area, "MS:1001131", "error on peptide area", "Error on peptide area.", false},
    {MS_peptide_ratio, "MS:1001132", "peptide ratio", "Peptide ratio.", false},
    {MS_error_on_peptide_ratio, "MS:1001133", "error on peptide ratio", "Error on peptide ratio.", false},
    {MS_protein_ratio, "MS:1001134", "protein ratio", "Protein ratio.", false},
    {MS_error_on_protein_ratio, "MS:1001135", "error on protein ratio", "Error on protein ratio.", false},
    {MS_p_value__protein_diff_from_1_randomly__OBSOLETE, "MS:1001136", "p-value (protein diff from 1 randomly)", "P-value (protein diff from 1 randomly).", true},
    {MS_absolute_quantity, "MS:1001137", "absolute quantity", "Absolute quantity in terms of real concentration or molecule copy number in sample.", false},
    {MS_error_on_absolute_quantity, "MS:1001138", "error on absolute quantity", "Error on absolute quantity.", false},
    {MS_quantitation_software_name, "MS:1001139", "quantitation software name", "Quantitation software name.", false},
    {MS_quantitation_software_version_OBSOLETE, "MS:1001140", "quantitation software version", "Quantitation software version.", true},
    {MS_intensity_of_precursor_ion, "MS:1001141", "intensity of precursor ion", "The intensity of the precursor ion.", false},
    {MS_database_IPI_human, "MS:1001142", "database IPI_human", "International Protein Index database for Homo sapiens sequences.", false},
    {MS_PSM_level_search_engine_specific_statistic, "MS:1001143", "PSM-level search engine specific statistic", "Search engine specific peptide spectrum match scores.", false},
    {MS_SEQUEST_SelectDefault, "MS:1001144", "SEQUEST:SelectDefault", "", false},
    {MS_SEQUEST_SelectAdvancedCV, "MS:1001145", "SEQUEST:SelectAdvancedCV", "SEQUEST Select Advanced Input Parameters.", false},
    {MS_param__a_ion_NH3_DEPRECATED, "MS:1001146", "param: a ion-NH3 DEPRECATED", "Ion a-NH3 parameter information, type of product: a ion with lost ammonia.", false},
    {MS_protein_ambiguity_group_result_details, "MS:1001147", "protein ambiguity group result details", "", false},
    {MS_param__a_ion_H2O_DEPRECATED, "MS:1001148", "param: a ion-H2O DEPRECATED", "Ion a-H2O if a significant and fragment includes STED.", false},
    {MS_param__b_ion_NH3_DEPRECATED, "MS:1001149", "param: b ion-NH3 DEPRECATED", "Ion b-NH3 parameter information, type of product: b ion with lost ammonia.", false},
    {MS_param__b_ion_H2O_DEPRECATED, "MS:1001150", "param: b ion-H2O DEPRECATED", "Ion b-H2O if b significant and fragment includes STED.", false},
    {MS_param__y_ion_NH3_DEPRECATED, "MS:1001151", "param: y ion-NH3 DEPRECATED", "Ion y-NH3 parameter information, type of product: y ion with lost ammonia.", false},
    {MS_param__y_ion_H2O_DEPRECATED, "MS:1001152", "param: y ion-H2O DEPRECATED", "", false},
    {MS_search_engine_specific_score, "MS:1001153", "search engine specific score", "Search engine specific scores.", false},
    {MS_SEQUEST_probability, "MS:1001154", "SEQUEST:probability", "The SEQUEST result 'Probability'.", false},
    {MS_SEQUEST_xcorr, "MS:1001155", "SEQUEST:xcorr", "The SEQUEST result 'XCorr'.", false},
    {MS_SEQUEST_deltacn, "MS:1001156", "SEQUEST:deltacn", "The SEQUEST result 'DeltaCn'.", false},
    {MS_SEQUEST_sp, "MS:1001157", "SEQUEST:sp", "The SEQUEST result 'Sp' (protein).", false},
    {MS_SEQUEST_Uniq, "MS:1001158", "SEQUEST:Uniq", "", false},
    {MS_SEQUEST_expectation_value, "MS:1001159", "SEQUEST:expectation value", "The SEQUEST result 'Expectation value'.", false},
    {MS_SEQUEST_sf, "MS:1001160", "SEQUEST:sf", "The SEQUEST result 'Sf'.", false},
    {MS_SEQUEST_matched_ions, "MS:1001161", "SEQUEST:matched ions", "The SEQUEST result 'Matched Ions'.", false},
    {MS_SEQUEST_total_ions, "MS:1001162", "SEQUEST:total ions", "The SEQUEST result 'Total Ions'.", false},
    {MS_SEQUEST_consensus_score, "MS:1001163", "SEQUEST:consensus score", "The SEQUEST result 'Consensus Score'.", false},
    {MS_Paragon_unused_protscore, "MS:1001164", "Paragon:unused protscore", "The Paragon result 'Unused ProtScore'.", false},
    {MS_Paragon_total_protscore, "MS:1001165", "Paragon:total protscore", "The Paragon result 'Total ProtScore'.", false},
    {MS_Paragon_score, "MS:1001166", "Paragon:score", "The Paragon result 'Score'.", false},
    {MS_Paragon_confidence, "MS:1001167", "Paragon:confidence", "The Paragon result 'Confidence'.", false},
    {MS_Paragon_expression_error_factor, "MS:1001168", "Paragon:expression error factor", "The Paragon result 'Expression Error Factor'.", false},
    {MS_Paragon_expression_change_p_value, "MS:1001169", "Paragon:expression change p-value", "The Paragon result 'Expression change P-value'.", false},
    {MS_Paragon_contrib, "MS:1001170", "Paragon:contrib", "The Paragon result 'Contrib'.", false},
    {MS_Mascot_score, "MS:1001171", "Mascot:score", "The Mascot result 'Score'.", false},
    {MS_Mascot_expectation_value, "MS:1001172", "Mascot:expectation value", "The Mascot result 'expectation value'.", false},
    {MS_Mascot_matched_ions, "MS:1001173", "Mascot:matched ions", "The Mascot result 'Matched ions'.", false},
    {MS_Mascot_total_ions, "MS:1001174", "Mascot:total ions", "The Mascot result 'Total ions'.", false},
    {MS_peptide_shared_in_multiple_proteins, "MS:1001175", "peptide shared in multiple proteins", "A peptide matching multiple proteins.", false},
    {MS______KR_____P_, "MS:1001176", "(?<=[KR])(?!P)", "Regular expression for Trypsin.", false},
    {MS_number_of_molecular_hypothesis_considered, "MS:1001177", "number of molecular hypothesis considered", "Number of Molecular Hypothesis Considered - This is the number of molecules (e.g. peptides for proteomics) considered for a particular search.", false},
    {MS_database_EST, "MS:1001178", "database EST", "Expressed sequence tag nucleotide sequence database.", false},
    {MS_Cleavage_agent_regular_expression, "MS:1001180", "Cleavage agent regular expression", "Regular expressions for cleavage enzymes.", false},
    {MS_search_statistics, "MS:1001184", "search statistics", "The details of the actual run of the search.", false},
    {MS_modification_specificity_peptide_N_term, "MS:1001189", "modification specificity peptide N-term", "As parameter for search engine: apply the modification only at the N-terminus of a peptide.", false},
    {MS_modification_specificity_peptide_C_term, "MS:1001190", "modification specificity peptide C-term", "As parameter for search engine: apply the modification only at the C-terminus of a peptide.", false},
    {MS_p_value_OBSOLETE, "MS:1001191", "p-value", "Quality estimation by p-value.", true},
    {MS_Expect_value, "MS:1001192", "Expect value", "Result of quality estimation: Expect value.", false},
    {MS_confidence_score, "MS:1001193", "confidence score", "Result of quality estimation: confidence score.", false},
    {MS_quality_estimation_with_decoy_database, "MS:1001194", "quality estimation with decoy database", "Quality estimation by decoy database.", false},
    {MS_decoy_DB_type_reverse, "MS:1001195", "decoy DB type reverse", "Decoy type: Amino acids of protein sequences are used in reverse order.", false},
    {MS_decoy_DB_type_randomized, "MS:1001196", "decoy DB type randomized", "Decoy type: Amino acids of protein sequences are randomized (keeping the original protein mass).", false},
    {MS_DB_composition_target_decoy, "MS:1001197", "DB composition target+decoy", "Decoy database composition: database contains original (target) and decoy entries.", false},
    {MS_protein_identification_confidence_metric, "MS:1001198", "protein identification confidence metric", "Identification confidence metric for a protein.", false},
    {MS_Mascot_DAT_format, "MS:1001199", "Mascot DAT format", "Source file for this mzIdentML was in Mascot DAT file format.", false},
    {MS_SEQUEST_out_file_format, "MS:1001200", "SEQUEST out file format", "Source file for this mzIdentML was in SEQUEST out file format.", false},
    {MS_DB_MW_filter_maximum, "MS:1001201", "DB MW filter maximum", "Maximum value of molecular weight filter.", false},
    {MS_DB_MW_filter_minimum, "MS:1001202", "DB MW filter minimum", "Minimum value of molecular weight filter.", false},
    {MS_DB_PI_filter_maximum, "MS:1001203", "DB PI filter maximum", "Maximum value of isoelectric point filter.", false},
    {MS_DB_PI_filter_minimum, "MS:1001204", "DB PI filter minimum", "Minimum value of isoelectric point filter.", false},
    {MS_Mascot, "MS:1001207", "Mascot", "The name of the Mascot search engine.", false},
    {MS_SEQUEST, "MS:1001208", "SEQUEST", "The name of the SEQUEST search engine.", false},
    {MS_Phenyx, "MS:1001209", "Phenyx", "The name of the Phenyx search engine.", false},
    {MS_mass_type_settings, "MS:1001210", "mass type settings", "The type of mass difference value to be considered by the search engine (monoisotopic or average).", false},
    {MS_parent_mass_type_mono, "MS:1001211", "parent mass type mono", "Mass type setting for parent mass was monoisotopic.", false},
    {MS_parent_mass_type_average, "MS:1001212", "parent mass type average", "Mass type setting for parent mass was average isotopic.", false},
    {MS_search_result_details_OBSOLETE, "MS:1001213", "search result details", "OBSOLETE: Scores and global result characteristics.", true},
    {MS_protein_level_global_FDR, "MS:1001214", "protein-level global FDR", "Estimation of the global false discovery rate of proteins.", false},
    {MS_SEQUEST_PeptideSp, "MS:1001215", "SEQUEST:PeptideSp", "The SEQUEST result 'Sp' in out file (peptide).", false},
    {MS_SEQUEST_PeptideRankSp, "MS:1001217", "SEQUEST:PeptideRankSp", "The SEQUEST result 'Sp' of 'Rank/Sp' in out file (peptide). Also called 'rsp'.", false},
    {MS_SEQUEST_PeptideNumber, "MS:1001218", "SEQUEST:PeptideNumber", "The SEQUEST result '#' in out file (peptide).", false},
    {MS_SEQUEST_PeptideIdnumber, "MS:1001219", "SEQUEST:PeptideIdnumber", "The SEQUEST result 'Id#' in out file (peptide).", false},
    {MS_frag__y_ion, "MS:1001220", "frag: y ion", "Fragmentation information, type of product: y ion.", false},
    {MS_product_ion_attribute, "MS:1001221", "product ion attribute", "Fragmentation information like ion types.", false},
    {MS_frag__b_ion___H2O, "MS:1001222", "frag: b ion - H2O", "Fragmentation information, type of product: b ion without water.", false},
    {MS_frag__y_ion___H2O, "MS:1001223", "frag: y ion - H2O", "Fragmentation information, type of product: y ion without water.", false},
    {MS_frag__b_ion, "MS:1001224", "frag: b ion", "Fragmentation information, type of product: b ion.", false},
    {MS_product_ion_m_z, "MS:1001225", "product ion m/z", "The m/z of the product ion.", false},
    {MS_product_ion_intensity, "MS:1001226", "product ion intensity", "The intensity of a single product ion.", false},
    {MS_product_ion_m_z_error, "MS:1001227", "product ion m/z error", "The product ion m/z error.", false},
    {MS_frag__x_ion, "MS:1001228", "frag: x ion", "Fragmentation information, type of product: x ion.", false},
    {MS_frag__a_ion, "MS:1001229", "frag: a ion", "Fragmentation information, type of product: a ion.", false},
    {MS_frag__z_ion, "MS:1001230", "frag: z ion", "Fragmentation information, type of product: z ion.", false},
    {MS_frag__c_ion, "MS:1001231", "frag: c ion", "Fragmentation information, type of product: c ion.", false},
    {MS_frag__b_ion___NH3, "MS:1001232", "frag: b ion - NH3", "Ion b-NH3 fragmentation information, type of product: b ion without ammonia.", false},
    {MS_frag__y_ion___NH3, "MS:1001233", "frag: y ion - NH3", "Ion y-NH3 fragmentation information, type of product: y ion without ammonia.", false},
    {MS_frag__a_ion___H2O, "MS:1001234", "frag: a ion - H2O", "Fragmentation information, type of product: a ion without water.", false},
    {MS_frag__a_ion___NH3, "MS:1001235", "frag: a ion - NH3", "Ion a-NH3 fragmentation information, type of product: a ion without ammonia.", false},
    {MS_frag__d_ion, "MS:1001236", "frag: d ion", "Fragmentation information, type of product: d ion.", false},
    {MS_frag__v_ion, "MS:1001237", "frag: v ion", "Fragmentation information, type of product: v ion.", false},
    {MS_frag__w_ion, "MS:1001238", "frag: w ion", "Fragmentation information, type of product: w ion.", false},
    {MS_frag__immonium_ion, "MS:1001239", "frag: immonium ion", "Fragmentation information, type of product: immonium ion.", false},
    {MS_non_identified_ion, "MS:1001240", "non-identified ion", "Non-identified ion.", false},
    {MS_co_eluting_ion, "MS:1001241", "co-eluting ion", "Co-eluting ion.", false},
    {MS_SEQUEST_out_folder, "MS:1001242", "SEQUEST out folder", "Source file for this mzIdentML was a SEQUEST folder with its out files.", false},
    {MS_SEQUEST_summary, "MS:1001243", "SEQUEST summary", "Source file for this mzIdentML was a SEQUEST summary page (proteins).", false},
    {MS_PerSeptive_PKS_format, "MS:1001245", "PerSeptive PKS format", "PerSeptive peak list file format.", false},
    {MS_SCIEX_API_III_format, "MS:1001246", "SCIEX API III format", "PE SCIEX peak list file format.", false},
    {MS_Bruker_XML_format, "MS:1001247", "Bruker XML format", "Bruker data exchange XML format.", false},
    {MS_search_input_details, "MS:1001249", "search input details", "Details describing the search input.", false},
    {MS_local_FDR, "MS:1001250", "local FDR", "Result of quality estimation: the local FDR at the current position of a sorted list.", false},
    {MS_Trypsin, "MS:1001251", "Trypsin", "Enzyme trypsin.", false},
    {MS_DB_source_EBI, "MS:1001252", "DB source EBI", "Database source EBI.", false},
    {MS_DB_source_NCBI, "MS:1001253", "DB source NCBI", "Database source NCBI.", false},
    {MS_DB_source_UniProt, "MS:1001254", "DB source UniProt", "Database source UniProt.", false},
    {MS_fragment_mass_type_average, "MS:1001255", "fragment mass type average", "Mass type setting for fragment mass was average isotopic.", false},
    {MS_fragment_mass_type_mono, "MS:1001256", "fragment mass type mono", "Mass type setting for fragment mass was monoisotopic.", false},
    {MS_param__v_ion, "MS:1001257", "param: v ion", "Parameter information, type of product: side chain loss v ion.", false},
    {MS_param__d_ion, "MS:1001258", "param: d ion", "Parameter information, type of product: side chain loss d ion.", false},
    {MS_param__immonium_ion, "MS:1001259", "param: immonium ion", "Parameter information, type of product: immonium ion.", false},
    {MS_param__w_ion, "MS:1001260", "param: w ion", "Parameter information, type of product: side chain loss w ion.", false},
    {MS_param__x_ion, "MS:1001261", "param: x ion", "Parameter information, type of product: x ion with charge on the C-terminal side.", false},
    {MS_param__y_ion, "MS:1001262", "param: y ion", "Parameter information, type of product: y ion with charge on the C-terminal side.", false},
    {MS_param__z_ion, "MS:1001263", "param: z ion", "Parameter information, type of product: z ion with charge on the C-terminal side.", false},
    {MS_role_type, "MS:1001266", "role type", "Role of a Person or Organization.", false},
    {MS_software_vendor, "MS:1001267", "software vendor", "Software vendor role.", false},
    {MS_programmer, "MS:1001268", "programmer", "Programmer role.", false},
    {MS_instrument_vendor, "MS:1001269", "instrument vendor", "Instrument vendor role.", false},
    {MS_lab_personnel, "MS:1001270", "lab personnel", "Lab personnel role.", false},
    {MS_researcher, "MS:1001271", "researcher", "Researcher role.", false},
    {MS_____R____P_, "MS:1001272", "(?<=R)(?!P)", "Regular expression for Arg-C.", false},
    {MS_____BD__, "MS:1001273", "(?=[BD])", "Regular expression for Asp-N.", false},
    {MS_____DE__, "MS:1001274", "(?=[DE])", "Regular expression for Asp-N-ambic.", false},
    {MS_ProteinScape_SearchEvent, "MS:1001275", "ProteinScape SearchEvent", "Source data for this mzIdentML was a ProteinScape SearchEvent.", false},
    {MS_ProteinScape_Gel, "MS:1001276", "ProteinScape Gel", "Source data for this mzIdentML was a ProteinScape Gel.", false},
    {MS_decoy_DB_accession_regexp, "MS:1001283", "decoy DB accession regexp", "Specify the regular expression for decoy accession numbers.", false},
    {MS_decoy_DB_derived_from_OBSOLETE, "MS:1001284", "decoy DB derived from", "The name of the database, the search database was derived from.", true},
    {MS_database_IPI_mouse, "MS:1001285", "database IPI_mouse", "International Protein Index database for Mus musculus sequences.", false},
    {MS_database_IPI_rat, "MS:1001286", "database IPI_rat", "International Protein Index database for Rattus norvegicus sequences.", false},
    {MS_database_IPI_zebrafish, "MS:1001287", "database IPI_zebrafish", "International Protein Index database for Danio rerio sequences.", false},
    {MS_database_IPI_chicken, "MS:1001288", "database IPI_chicken", "International Protein Index database for Gallus gallus sequences.", false},
    {MS_database_IPI_cow, "MS:1001289", "database IPI_cow", "International Protein Index database for Bos taurus sequences.", false},
    {MS_database_IPI_arabidopsis, "MS:1001290", "database IPI_arabidopsis", "International Protein Index database for Arabidopsis thaliana sequences.", false},
    {MS_decoy_DB_from_nr_OBSOLETE, "MS:1001291", "decoy DB from nr", "Decoy database from a non-redundant GenBank sequence database.", true},
    {MS_decoy_DB_from_IPI_rat_OBSOLETE, "MS:1001292", "decoy DB from IPI_rat", "Decoy database from a International Protein Index database for Rattus norvegicus.", true},
    {MS_decoy_DB_from_IPI_mouse_OBSOLETE, "MS:1001293", "decoy DB from IPI_mouse", "Decoy database from a International Protein Index database for Mus musculus.", true},
    {MS_decoy_DB_from_IPI_arabidopsis_OBSOLETE, "MS:1001294", "decoy DB from IPI_arabidopsis", "Decoy database from a International Protein Index database for Arabidopsis thaliana.", true},
    {MS_decoy_DB_from_EST_OBSOLETE, "MS:1001295", "decoy DB from EST", "Decoy database from an expressed sequence tag nucleotide sequence database.", true},
    {MS_decoy_DB_from_IPI_zebrafish_OBSOLETE, "MS:1001296", "decoy DB from IPI_zebrafish", "Decoy database from a International Protein Index database for Danio rerio.", true},
    {MS_decoy_DB_from_UniProtKB_Swiss_Prot_OBSOLETE, "MS:1001297", "decoy DB from UniProtKB/Swiss-Prot", "Decoy database from a Swiss-Prot protein sequence database.", true},
    {MS_decoy_DB_from_IPI_chicken_OBSOLETE, "MS:1001298", "decoy DB from IPI_chicken", "Decoy database from a International Protein Index database for Gallus gallus.", true},
    {MS_decoy_DB_from_IPI_cow_OBSOLETE, "MS:1001299", "decoy DB from IPI_cow", "Decoy database from a International Protein Index database for Bos taurus.", true},
    {MS_decoy_DB_from_IPI_human_OBSOLETE, "MS:1001300", "decoy DB from IPI_human", "Decoy database from a International Protein Index database for Homo sapiens.", true},
    {MS_protein_rank, "MS:1001301", "protein rank", "The rank of the protein in a list sorted by the search engine.", false},
    {MS_search_engine_specific_input_parameter, "MS:1001302", "search engine specific input parameter", "Search engine specific input parameters.", false},
    {MS_Arg_C, "MS:1001303", "Arg-C", "Endoproteinase Arg-C.", false},
    {MS_Asp_N, "MS:1001304", "Asp-N", "Endoproteinase Asp-N.", false},
    {MS_Asp_N_ambic, "MS:1001305", "Asp-N_ambic", "Enzyme Asp-N, Ammonium Bicarbonate (AmBic).", false},
    {MS_Chymotrypsin, "MS:1001306", "Chymotrypsin", "Enzyme chymotrypsin.", false},
    {MS_CNBr, "MS:1001307", "CNBr", "Cyanogen bromide.", false},
    {MS_Formic_acid, "MS:1001308", "Formic_acid", "Formic acid.", false},
    {MS_Lys_C, "MS:1001309", "Lys-C", "Endoproteinase Lys-C.", false},
    {MS_Lys_C_P, "MS:1001310", "Lys-C/P", "Proteinase Lys-C/P.", false},
    {MS_PepsinA, "MS:1001311", "PepsinA", "PepsinA proteinase.", false},
    {MS_TrypChymo, "MS:1001312", "TrypChymo", "Cleavage agent TrypChymo.", false},
    {MS_Trypsin_P, "MS:1001313", "Trypsin/P", "Cleavage agent Trypsin/P.", false},
    {MS_V8_DE, "MS:1001314", "V8-DE", "Cleavage agent V8-DE.", false},
    {MS_V8_E, "MS:1001315", "V8-E", "Cleavage agent V8-E.", false},
    {MS_Mascot_SigThreshold, "MS:1001316", "Mascot:SigThreshold", "Significance threshold below which the p-value of a peptide match must lie to be considered statistically significant (default 0.05).", false},
    {MS_Mascot_MaxProteinHits, "MS:1001317", "Mascot:MaxProteinHits", "The number of protein hits to display in the report. If 'Auto', all protein hits that have a protein score exceeding the average peptide identity threshold are reported. Otherwise an integer at least 1.", false},
    {MS_Mascot_ProteinScoringMethod, "MS:1001318", "Mascot:ProteinScoringMethod", "Mascot protein scoring method; either 'Standard' or 'MudPIT'.", false},
    {MS_Mascot_MinMSMSThreshold, "MS:1001319", "Mascot:MinMSMSThreshold", "Mascot peptide match ion score threshold. If between 0 and 1, then peptide matches whose expect value exceeds the thresholds are suppressed; if at least 1, then peptide matches whose ion score is below the threshold are suppressed.", false},
    {MS_Mascot_ShowHomologousProteinsWithSamePeptides, "MS:1001320", "Mascot:ShowHomologousProteinsWithSamePeptides", "If true, show (sequence or spectrum) same-set proteins. Otherwise they are suppressed.", false},
    {MS_Mascot_ShowHomologousProteinsWithSubsetOfPeptides, "MS:1001321", "Mascot:ShowHomologousProteinsWithSubsetOfPeptides", "If true, show (sequence or spectrum) sub-set and subsumable proteins. Otherwise they are suppressed.", false},
    {MS_Mascot_RequireBoldRed, "MS:1001322", "Mascot:RequireBoldRed", "Only used in Peptide Summary and Select Summary reports. If true, a peptide match must be 'bold red' to be included in the report; bold red means the peptide is a top ranking match in a query and appears for the first time (in linear order) in the list of protein hits.", false},
    {MS_Mascot_UseUnigeneClustering, "MS:1001323", "Mascot:UseUnigeneClustering", "If true, then the search results are against a nucleic acid database and Unigene clustering is enabled. Otherwise UniGene clustering is not in use.", false},
    {MS_Mascot_IncludeErrorTolerantMatches, "MS:1001324", "Mascot:IncludeErrorTolerantMatches", "If true, then the search results are error tolerant and peptide matches from the second pass are included in search results. Otherwise no error tolerant peptide matches are included.", false},
    {MS_Mascot_ShowDecoyMatches, "MS:1001325", "Mascot:ShowDecoyMatches", "If true, then the search results are against an automatically generated decoy database and the reported peptide matches and protein hits come from the decoy database. Otherwise peptide matches and protein hits come from the original database.", false},
    {MS_add_others_OBSOLETE, "MS:1001326", "add_others", "OBSOLETE.", true},
    {MS_Spectronaut, "MS:1001327", "Spectronaut", "Commercial cross-vendor software for library (peptide centric), and library-free (spectrum centric) analysis and quantification of DIA data.", false},
    {MS_OMSSA_evalue, "MS:1001328", "OMSSA:evalue", "OMSSA E-value.", false},
    {MS_OMSSA_pvalue, "MS:1001329", "OMSSA:pvalue", "OMSSA p-value.", false},
    {MS_X_Tandem_expect, "MS:1001330", "X!Tandem:expect", "The X!Tandem expectation value.", false},
    {MS_X_Tandem_hyperscore, "MS:1001331", "X!Tandem:hyperscore", "The X!Tandem hyperscore.", false},
    {MS______FYWL_____P_, "MS:1001332", "(?<=[FYWL])(?!P)", "Regular expression for Chymotrypsin.", false},
    {MS_____M_, "MS:1001333", "(?<=M)", "Regular expression for CNBr.", false},
    {MS______D_______D__, "MS:1001334", "((?<=D))|((?=D))", "Regular expression for formic acid.", false},
    {MS_____K____P_, "MS:1001335", "(?<=K)(?!P)", "Regular expression for Lys-C.", false},
    {MS_____K_, "MS:1001336", "(?<=K)", "Regular expression for Lys-C/P.", false},
    {MS______FL__, "MS:1001337", "(?<=[FL])", "Regular expression for PepsinA.", false},
    {MS______FYWLKR_____P_, "MS:1001338", "(?<=[FYWLKR])(?!P)", "Regular expression for TrypChymo.", false},
    {MS______KR__, "MS:1001339", "(?<=[KR])", "Regular expression for Trypsin/P.", false},
    {MS______BDEZ_____P_, "MS:1001340", "(?<=[BDEZ])(?!P)", "Regular expression for V8-DE.", false},
    {MS______EZ_____P_, "MS:1001341", "(?<=[EZ])(?!P)", "Regular expression for V8-E.", false},
    {MS_database_sequence_details, "MS:1001342", "database sequence details", "Details about a single database sequence.", false},
    {MS_NA_sequence, "MS:1001343", "NA sequence", "The sequence is a nucleic acid sequence.", false},
    {MS_AA_sequence, "MS:1001344", "AA sequence", "The sequence is a amino acid sequence.", false},
    {MS_mass_table_source, "MS:1001345", "mass table source", "Children of this term specify the source of the mass table used.", false},
    {MS_AAIndex_mass_table, "MS:1001346", "AAIndex mass table", "The masses used in the mass table are taken from AAIndex.", false},
    {MS_database_file_formats, "MS:1001347", "database file formats", "The children of this term define file formats of the sequence database used.", false},
    {MS_FASTA_format, "MS:1001348", "FASTA format", "The sequence database was stored in the FASTA format.", false},
    {MS_ASN_1, "MS:1001349", "ASN.1", "The sequence database was stored in the Abstract Syntax Notation 1 format.", false},
    {MS_NCBI___p_, "MS:1001350", "NCBI *.p*", "The sequence database was stored in the NCBI formatdb (*.p*) format.", false},
    {MS_clustal_aln, "MS:1001351", "clustal aln", "ClustalW ALN (multiple alignment) format.", false},
    {MS_embl_em, "MS:1001352", "embl em", "EMBL entry format.", false},
    {MS_NBRF_PIR, "MS:1001353", "NBRF PIR", "The NBRF PIR was used as format.", false},
    {MS_mass_table_options, "MS:1001354", "mass table options", "Root node for options for the mass table used.", false},
    {MS_peptide_descriptions, "MS:1001355", "peptide descriptions", "Descriptions of peptides.", false},
    {MS_spectrum_descriptions, "MS:1001356", "spectrum descriptions", "Descriptions of the input spectra.", false},
    {MS_spectrum_quality_descriptions, "MS:1001357", "spectrum quality descriptions", "Description of the quality of the input spectrum.", false},
    {MS_msmsEval_quality, "MS:1001358", "msmsEval quality", "This term reports the quality of the spectrum assigned by msmsEval.", false},
    {MS_ambiguous_residues, "MS:1001359", "ambiguous residues", "Children of this term describe ambiguous residues.", false},
    {MS_alternate_single_letter_codes, "MS:1001360", "alternate single letter codes", "List of standard residue one letter codes which are used to replace a non-standard.", false},
    {MS_alternate_mass, "MS:1001361", "alternate mass", "List of masses a non-standard letter code is replaced with.", false},
    {MS_number_of_unmatched_peaks, "MS:1001362", "number of unmatched peaks", "The number of unmatched peaks.", false},
    {MS_peptide_unique_to_one_protein, "MS:1001363", "peptide unique to one protein", "A peptide matching only one.", false},
    {MS_peptide_sequence_level_global_FDR, "MS:1001364", "peptide sequence-level global FDR", "Estimation of the global false discovery rate for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_frag__internal_yb_ion, "MS:1001365", "frag: internal yb ion", "Fragmentation information, type of product: internal yb ion.", false},
    {MS_frag__internal_ya_ion, "MS:1001366", "frag: internal ya ion", "Fragmentation information, type of product: internal ya ion.", false},
    {MS_frag__z_1_ion, "MS:1001367", "frag: z+1 ion", "Fragmentation information, type of product: z+1 ion.", false},
    {MS_frag__z_2_ion, "MS:1001368", "frag: z+2 ion", "Fragmentation information, type of product: z+2 ion.", false},
    {MS_text_format, "MS:1001369", "text format", "Simple text file format of \\\"m/z [intensity]\\\" values for a PMF (or single MS2) search.", false},
    {MS_Mascot_homology_threshold, "MS:1001370", "Mascot:homology threshold", "The Mascot result 'homology threshold'.", false},
    {MS_Mascot_identity_threshold, "MS:1001371", "Mascot:identity threshold", "The Mascot result 'identity threshold'.", false},
    {MS_SEQUEST_Sequences, "MS:1001372", "SEQUEST:Sequences", "", false},
    {MS_SEQUEST_TIC, "MS:1001373", "SEQUEST:TIC", "SEQUEST total ion current.", false},
    {MS_SEQUEST_Sum, "MS:1001374", "SEQUEST:Sum", "", false},
    {MS_Phenyx_Instrument_Type, "MS:1001375", "Phenyx:Instrument Type", "The instrument type parameter value in Phenyx.", false},
    {MS_Phenyx_Scoring_Model, "MS:1001376", "Phenyx:Scoring Model", "The selected scoring model in Phenyx.", false},
    {MS_Phenyx_Default_Parent_Charge, "MS:1001377", "Phenyx:Default Parent Charge", "The default parent charge value in Phenyx.", false},
    {MS_Phenyx_Trust_Parent_Charge, "MS:1001378", "Phenyx:Trust Parent Charge", "The parameter in Phenyx that specifies if the experimental charge state is to be considered as correct.", false},
    {MS_Phenyx_Turbo, "MS:1001379", "Phenyx:Turbo", "The turbo mode parameter in Phenyx.", false},
    {MS_Phenyx_Turbo_ErrorTol, "MS:1001380", "Phenyx:Turbo:ErrorTol", "The maximal allowed fragment m/z error filter considered in the turbo mode of Phenyx.", false},
    {MS_Phenyx_Turbo_Coverage, "MS:1001381", "Phenyx:Turbo:Coverage", "The minimal peptide sequence coverage value, expressed in percent, considered in the turbo mode of Phenyx.", false},
    {MS_Phenyx_Turbo_Series, "MS:1001382", "Phenyx:Turbo:Series", "The list of ion series considered in the turbo mode of Phenyx.", false},
    {MS_Phenyx_MinPepLength, "MS:1001383", "Phenyx:MinPepLength", "The minimal number of residues for a peptide to be considered for a valid identification in Phenyx.", false},
    {MS_Phenyx_MinPepzscore, "MS:1001384", "Phenyx:MinPepzscore", "The minimal peptide z-score for a peptide to be considered for a valid identification in Phenyx.", false},
    {MS_Phenyx_MaxPepPvalue, "MS:1001385", "Phenyx:MaxPepPvalue", "The maximal peptide p-value for a peptide to be considered for a valid identification in Phenyx.", false},
    {MS_Phenyx_AC_Score, "MS:1001386", "Phenyx:AC Score", "The minimal protein score required for a protein database entry to be displayed in the list of identified proteins in Phenyx.", false},
    {MS_Phenyx_Conflict_Resolution, "MS:1001387", "Phenyx:Conflict Resolution", "The parameter in Phenyx that specifies if the conflict resolution algorithm is to be used.", false},
    {MS_Phenyx_AC, "MS:1001388", "Phenyx:AC", "The primary sequence database identifier of a protein in Phenyx.", false},
    {MS_Phenyx_ID, "MS:1001389", "Phenyx:ID", "A secondary sequence database identifier of a protein in Phenyx.", false},
    {MS_Phenyx_Score, "MS:1001390", "Phenyx:Score", "The protein score of a protein match in Phenyx.", false},
    {MS_Phenyx_Peptides1, "MS:1001391", "Phenyx:Peptides1", "First number of phenyx result \\\"#Peptides\\\".", false},
    {MS_Phenyx_Peptides2, "MS:1001392", "Phenyx:Peptides2", "Second number of phenyx result \\\"#Peptides\\\".", false},
    {MS_Phenyx_Auto, "MS:1001393", "Phenyx:Auto", "The value of the automatic peptide acceptance filter in Phenyx.", false},
    {MS_Phenyx_User, "MS:1001394", "Phenyx:User", "The value of the user-defined peptide acceptance filter in Phenyx.", false},
    {MS_Phenyx_Pepzscore, "MS:1001395", "Phenyx:Pepzscore", "The z-score value of a peptide sequence match in Phenyx.", false},
    {MS_Phenyx_PepPvalue, "MS:1001396", "Phenyx:PepPvalue", "The p-value of a peptide sequence match in Phenyx.", false},
    {MS_Phenyx_NumberOfMC, "MS:1001397", "Phenyx:NumberOfMC", "The number of missed cleavages of a peptide sequence in Phenyx.", false},
    {MS_Phenyx_Modif, "MS:1001398", "Phenyx:Modif", "The expression of the nature and position(s) of modified residue(s) on a matched peptide sequence in Phenyx.", false},
    {MS_OMSSA_csv_format, "MS:1001399", "OMSSA csv format", "Source file for this mzIdentML was in OMSSA csv file format.", false},
    {MS_OMSSA_xml_format, "MS:1001400", "OMSSA xml format", "Source file for this mzIdentML was in OMSSA xml file format.", false},
    {MS_X_Tandem_xml_format, "MS:1001401", "X!Tandem xml format", "Source file for this mzIdentML was in X!Tandem xml file format.", false},
    {MS_spectrum_identification_result_details, "MS:1001405", "spectrum identification result details", "This subsection describes terms which can describe details of spectrum identification results.", false},
    {MS_param__internal_yb_ion, "MS:1001406", "param: internal yb ion", "Parameter information, type of product: internal yb ion.", false},
    {MS_param__internal_ya_ion, "MS:1001407", "param: internal ya ion", "Parameter information, type of product: internal ya ion.", false},
    {MS_param__z_1_ion, "MS:1001408", "param: z+1 ion", "Parameter information, type of product: z+1 ion.", false},
    {MS_param__z_2_ion, "MS:1001409", "param: z+2 ion", "Parameter information, type of product: z+2 ion.", false},
    {MS_translation_start_codons, "MS:1001410", "translation start codons", "The translation start codons used to translate the nucleotides to amino acids.", false},
    {MS_search_tolerance_specification, "MS:1001411", "search tolerance specification", "Specification of the search tolerance.", false},
    {MS_search_tolerance_plus_value, "MS:1001412", "search tolerance plus value", "", false},
    {MS_search_tolerance_minus_value, "MS:1001413", "search tolerance minus value", "", false},
    {MS_MGF_scans_OBSOLETE, "MS:1001414", "MGF scans", "OBSOLETE: replaced by MS:1000797 (peak list scans): This term can hold the scans attribute from an MGF input file.", true},
    {MS_MGF_raw_scans_OBSOLETE, "MS:1001415", "MGF raw scans", "OBSOLETE: replaced by MS:1000798 (peak list raw scans): This term can hold the raw scans attribute from an MGF input file.", true},
    {MS_spectrum_title_OBSOLETE, "MS:1001416", "spectrum title", "OBSOLETE: replaced by MS:1000796 (spectrum title): Holds the spectrum title from different input file formats, e.g. MGF TITLE.", true},
    {MS_SpectraST_dot, "MS:1001417", "SpectraST:dot", "SpectraST dot product of two spectra, measuring spectral similarity.", false},
    {MS_SpectraST_dot_bias, "MS:1001418", "SpectraST:dot_bias", "SpectraST measure of how much of the dot product is dominated by a few peaks.", false},
    {MS_SpectraST_discriminant_score_F, "MS:1001419", "SpectraST:discriminant score F", "SpectraST spectrum score.", false},
    {MS_SpectraST_delta, "MS:1001420", "SpectraST:delta", "SpectraST normalised difference between dot product of top hit and runner-up.", false},
    {MS_pepXML_format, "MS:1001421", "pepXML format", "The XML-based pepXML file format for encoding PSM information, created and maintained by the Trans-Proteomic Pipeline developers.", false},
    {MS_protXML_format, "MS:1001422", "protXML format", "The XML-based protXML file format for encoding protein identifications, created and maintained by the Trans-Proteomic Pipeline developers.", false},
    {MS_translation_table_description, "MS:1001423", "translation table description", "A URL that describes the translation table used to translate the nucleotides to amino acids.", false},
    {MS_ProteinExtractor_Methodname, "MS:1001424", "ProteinExtractor:Methodname", "Name of the used method in the ProteinExtractor algorithm.", false},
    {MS_ProteinExtractor_GenerateNonRedundant, "MS:1001425", "ProteinExtractor:GenerateNonRedundant", "Flag indicating if a non redundant scoring should be generated.", false},
    {MS_ProteinExtractor_IncludeIdentified, "MS:1001426", "ProteinExtractor:IncludeIdentified", "Flag indicating if identified proteins should be included.", false},
    {MS_ProteinExtractor_MaxNumberOfProteins, "MS:1001427", "ProteinExtractor:MaxNumberOfProteins", "The maximum number of proteins to consider.", false},
    {MS_ProteinExtractor_MaxProteinMass, "MS:1001428", "ProteinExtractor:MaxProteinMass", "The maximum considered mass for a protein.", false},
    {MS_ProteinExtractor_MinNumberOfPeptides, "MS:1001429", "ProteinExtractor:MinNumberOfPeptides", "The minimum number of proteins to consider.", false},
    {MS_ProteinExtractor_UseMascot, "MS:1001430", "ProteinExtractor:UseMascot", "Flag indicating to include Mascot scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_MascotPeptideScoreThreshold, "MS:1001431", "ProteinExtractor:MascotPeptideScoreThreshold", "Only peptides with scores higher than that threshold are taken into account in Mascot scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_MascotUniqueScore, "MS:1001432", "ProteinExtractor:MascotUniqueScore", "In the final result each protein must have at least one peptide above this Mascot score threshold in ProteinExtractor meta score calculation.", false},
    {MS_ProteinExtractor_MascotUseIdentityScore, "MS:1001433", "ProteinExtractor:MascotUseIdentityScore", "", false},
    {MS_ProteinExtractor_MascotWeighting, "MS:1001434", "ProteinExtractor:MascotWeighting", "Influence of Mascot search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.", false},
    {MS_ProteinExtractor_UseSequest, "MS:1001435", "ProteinExtractor:UseSequest", "Flag indicating to include SEQUEST scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_SequestPeptideScoreThreshold, "MS:1001436", "ProteinExtractor:SequestPeptideScoreThreshold", "Only peptides with scores higher than that threshold are taken into account in SEQUEST scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_SequestUniqueScore, "MS:1001437", "ProteinExtractor:SequestUniqueScore", "In the final result each protein must have at least one peptide above this SEQUEST score threshold in ProteinExtractor meta score calculation.", false},
    {MS_ProteinExtractor_SequestWeighting, "MS:1001438", "ProteinExtractor:SequestWeighting", "Influence of SEQUEST search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.", false},
    {MS_ProteinExtractor_UseProteinSolver, "MS:1001439", "ProteinExtractor:UseProteinSolver", "Flag indicating to include ProteinSolver scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_ProteinSolverPeptideScoreThreshold, "MS:1001440", "ProteinExtractor:ProteinSolverPeptideScoreThreshold", "Only peptides with scores higher than that threshold are taken into account in ProteinSolver scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_ProteinSolverUniqueScore, "MS:1001441", "ProteinExtractor:ProteinSolverUniqueScore", "In the final result each protein must have at least one peptide above this ProteinSolver score threshold in ProteinExtractor meta score calculation.", false},
    {MS_ProteinExtractor_ProteinSolverWeighting, "MS:1001442", "ProteinExtractor:ProteinSolverWeighting", "Influence of ProteinSolver search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.", false},
    {MS_ProteinExtractor_UsePhenyx, "MS:1001443", "ProteinExtractor:UsePhenyx", "Flag indicating to include Phenyx scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_PhenyxPeptideScoreThreshold, "MS:1001444", "ProteinExtractor:PhenyxPeptideScoreThreshold", "Only peptides with scores higher than that threshold are taken into account in Phenyx scoring for calculation of the ProteinExtractor meta score.", false},
    {MS_ProteinExtractor_PhenyxUniqueScore, "MS:1001445", "ProteinExtractor:PhenyxUniqueScore", "In the final result each protein must have at least one peptide above this Phenyx score threshold in ProteinExtractor meta score calculation.", false},
    {MS_ProteinExtractor_PhenyxWeighting, "MS:1001446", "ProteinExtractor:PhenyxWeighting", "Influence of Phenyx search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.", false},
    {MS_prot_FDR_threshold, "MS:1001447", "prot:FDR threshold", "False-discovery rate threshold for proteins.", false},
    {MS_pep_FDR_threshold, "MS:1001448", "pep:FDR threshold", "False-discovery rate threshold for peptides.", false},
    {MS_OMSSA_e_value_threshold, "MS:1001449", "OMSSA e-value threshold", "Threshold for OMSSA e-value for quality estimation.", false},
    {MS_decoy_DB_details, "MS:1001450", "decoy DB details", "Details of decoy generation and database structure.", false},
    {MS_decoy_DB_generation_algorithm, "MS:1001451", "decoy DB generation algorithm", "Name of algorithm used for decoy generation.", false},
    {MS_decoy_DB_type_shuffle, "MS:1001452", "decoy DB type shuffle", "Decoy type: Amino acids of protein sequences are used in a random order.", false},
    {MS_DB_composition_only_decoy, "MS:1001453", "DB composition only decoy", "Decoy database composition: database contains only decoy entries.", false},
    {MS_quality_estimation_with_implicite_decoy_sequences, "MS:1001454", "quality estimation with implicite decoy sequences", "Decoy entries are generated during the search, not explicitly stored in a database (like Mascot Decoy).", false},
    {MS_acquisition_software, "MS:1001455", "acquisition software", "Acquisition software.", false},
    {MS_analysis_software, "MS:1001456", "analysis software", "Analysis software.", false},
    {MS_data_processing_software, "MS:1001457", "data processing software", "Data processing software.", false},
    {MS_spectrum_generation_information, "MS:1001458", "spectrum generation information", "Vocabularies describing the spectrum generation information.", false},
    {MS_file_format, "MS:1001459", "file format", "Format of data files.", false},
    {MS_unknown_modification, "MS:1001460", "unknown modification", "This term should be given if the modification was unknown.", false},
    {MS_greylag, "MS:1001461", "greylag", "Greylag identification software.", false},
    {MS_PEFF_format, "MS:1001462", "PEFF format", "The sequence database was stored in the PEFF (PSI enhanced FastA file) format.", false},
    {MS_Phenyx_XML_format, "MS:1001463", "Phenyx XML format", "Phenyx open XML file format.", false},
    {MS_DTASelect_format, "MS:1001464", "DTASelect format", "DTASelect file format.", false},
    {MS_MS2_format, "MS:1001466", "MS2 format", "MS2 file format for MS2 spectral data.", false},
    {MS_taxonomy__NCBI_TaxID, "MS:1001467", "taxonomy: NCBI TaxID", "This term is used if a NCBI TaxID is specified, e.g. 9606 for Homo sapiens.", false},
    {MS_taxonomy__common_name, "MS:1001468", "taxonomy: common name", "This term is used if a common name is specified, e.g. human. Recommend using MS:1001467 (taxonomy: NCBI TaxID) where possible.", false},
    {MS_taxonomy__scientific_name, "MS:1001469", "taxonomy: scientific name", "This term is used if a scientific name is specified, e.g. Homo sapiens. Recommend using MS:1001467 (taxonomy: NCBI TaxID) where possible.", false},
    {MS_taxonomy__Swiss_Prot_ID, "MS:1001470", "taxonomy: Swiss-Prot ID", "This term is used if a swiss prot taxonomy id is specified, e.g. Human. Recommend using MS:1001467 (taxonomy: NCBI TaxID) where possible.", false},
    {MS_peptide_modification_details, "MS:1001471", "peptide modification details", "The children of this term can be used to describe modifications.", false},
    {MS_selected_ion_monitoring_chromatogram, "MS:1001472", "selected ion monitoring chromatogram", "Representation of an array of the measurements of a selectively monitored ion versus time.", false},
    {MS_selected_reaction_monitoring_chromatogram, "MS:1001473", "selected reaction monitoring chromatogram", "Representation of an array of the measurements of a selectively monitored reaction versus time.", false},
    {MS_consecutive_reaction_monitoring_chromatogram_OBSOLETE, "MS:1001474", "consecutive reaction monitoring chromatogram", "Representation of an array of the measurements of a series of monitored reactions versus time.", true},
    {MS_OMSSA, "MS:1001475", "OMSSA", "Open Mass Spectrometry Search Algorithm was used to analyze the spectra.", false},
    {MS_X_Tandem, "MS:1001476", "X!Tandem", "X!Tandem was used to analyze the spectra.", false},
    {MS_SpectraST, "MS:1001477", "SpectraST", "Open-source software for mass spectral library creation and searching, developed at the Institute for Systems Biology and the Hong Kong University of Science and Technology. Part of the Trans-Proteomic Pipeline.", false},
    {MS_Mascot_Parser, "MS:1001478", "Mascot Parser", "Mascot Parser was used to analyze the spectra.", false},
    {MS_null_terminated_ASCII_string, "MS:1001479", "null-terminated ASCII string", "Sequence of zero or more non-zero ASCII characters terminated by a single null (0) byte.", false},
    {MS_SCIEX_TOF_TOF_nativeID_format, "MS:1001480", "SCIEX TOF/TOF nativeID format", "Native format defined by jobRun=xsd:nonNegativeInteger spotLabel=xsd:string spectrum=xsd:nonNegativeInteger.", false},
    {MS_SCIEX_TOF_TOF_database, "MS:1001481", "SCIEX TOF/TOF database", "Applied Biosystems/MDS Analytical Technologies TOF/TOF instrument database.", false},
    {MS_5800_TOF_TOF, "MS:1001482", "5800 TOF/TOF", "SCIEX 5800 TOF-TOF Analyzer.", false},
    {MS_SCIEX_TOF_TOF_Series_Explorer_Software, "MS:1001483", "SCIEX TOF/TOF Series Explorer Software", "SCIEX or Applied Biosystems software for TOF/TOF data acquisition and analysis.", false},
    {MS_intensity_normalization, "MS:1001484", "intensity normalization", "Normalization of data point intensities.", false},
    {MS_m_z_calibration, "MS:1001485", "m/z calibration", "Calibration of data point m/z positions.", false},
    {MS_data_filtering, "MS:1001486", "data filtering", "Filtering out part of the data.", false},
    {MS_ProteinExtractor, "MS:1001487", "ProteinExtractor", "An algorithm for protein determination/assembly integrated into Bruker's ProteinScape.", false},
    {MS_Mascot_Distiller, "MS:1001488", "Mascot Distiller", "Mascot Distiller.", false},
    {MS_Mascot_Integra, "MS:1001489", "Mascot Integra", "Mascot Integra.", false},
    {MS_Percolator, "MS:1001490", "Percolator", "Percolator.", false},
    {MS_percolator_Q_value, "MS:1001491", "percolator:Q value", "Percolator:Q value.", false},
    {MS_percolator_score, "MS:1001492", "percolator:score", "Percolator:score.", false},
    {MS_percolator_PEP, "MS:1001493", "percolator:PEP", "Posterior error probability.", false},
    {MS_no_threshold, "MS:1001494", "no threshold", "In case no threshold was used.", false},
    {MS_ProteinScape_SearchResultId, "MS:1001495", "ProteinScape:SearchResultId", "The SearchResultId of this peptide as SearchResult in the ProteinScape database.", false},
    {MS_ProteinScape_SearchEventId, "MS:1001496", "ProteinScape:SearchEventId", "The SearchEventId of the SearchEvent in the ProteinScape database.", false},
    {MS_ProteinScape_ProfoundProbability, "MS:1001497", "ProteinScape:ProfoundProbability", "The Profound probability score stored by ProteinScape.", false},
    {MS_Profound_z_value, "MS:1001498", "Profound:z value", "The Profound z value.", false},
    {MS_Profound_Cluster, "MS:1001499", "Profound:Cluster", "The Profound cluster score.", false},
    {MS_Profound_ClusterRank, "MS:1001500", "Profound:ClusterRank", "The Profound cluster rank.", false},
    {MS_MSFit_Mowse_score, "MS:1001501", "MSFit:Mowse score", "The MSFit Mowse score.", false},
    {MS_Sonar_Score, "MS:1001502", "Sonar:Score", "The Sonar score.", false},
    {MS_ProteinScape_PFFSolverExp, "MS:1001503", "ProteinScape:PFFSolverExp", "The ProteinSolver exp value stored by ProteinScape.", false},
    {MS_ProteinScape_PFFSolverScore, "MS:1001504", "ProteinScape:PFFSolverScore", "The ProteinSolver score stored by ProteinScape.", false},
    {MS_ProteinScape_IntensityCoverage, "MS:1001505", "ProteinScape:IntensityCoverage", "The intensity coverage of the identified peaks in the spectrum calculated by ProteinScape.", false},
    {MS_ProteinScape_SequestMetaScore, "MS:1001506", "ProteinScape:SequestMetaScore", "The SEQUEST meta score calculated by ProteinScape from the original SEQUEST scores.", false},
    {MS_ProteinExtractor_Score, "MS:1001507", "ProteinExtractor:Score", "The score calculated by ProteinExtractor.", false},
    {MS_Agilent_MassHunter_nativeID_format, "MS:1001508", "Agilent MassHunter nativeID format", "Native format defined by scanId=xsd:nonNegativeInteger.", false},
    {MS_Agilent_MassHunter_format, "MS:1001509", "Agilent MassHunter format", "A data file format found in an Agilent MassHunter directory which contains raw data acquired by an Agilent mass spectrometer.", false},
    {MS_TSQ_Vantage, "MS:1001510", "TSQ Vantage", "TSQ Vantage.", false},
    {MS_Sequence_database_filter_types, "MS:1001511", "Sequence database filter types", "Filter types which are used to filter a sequence database.", false},
    {MS_Sequence_database_filters, "MS:1001512", "Sequence database filters", "Sequence database filters which actually can contains values, e.g. to limit PI value of the sequences used to search.", false},
    {MS_DB_sequence_filter_pattern, "MS:1001513", "DB sequence filter pattern", "DB sequence filter pattern.", false},
    {MS_DB_accession_filter_string, "MS:1001514", "DB accession filter string", "DB accession filter string.", false},
    {MS_frag__c_ion___H2O, "MS:1001515", "frag: c ion - H2O", "Fragmentation information, type of product: c ion without water.", false},
    {MS_frag__c_ion___NH3, "MS:1001516", "frag: c ion - NH3", "Fragmentation information, type of product: c ion without ammonia.", false},
    {MS_frag__z_ion___H2O, "MS:1001517", "frag: z ion - H2O", "Fragmentation information, type of product: z ion without water.", false},
    {MS_frag__z_ion___NH3, "MS:1001518", "frag: z ion - NH3", "Fragmentation information, type of product: z ion without ammonia.", false},
    {MS_frag__x_ion___H2O, "MS:1001519", "frag: x ion - H2O", "Fragmentation information, type of product: x ion without water.", false},
    {MS_frag__x_ion___NH3, "MS:1001520", "frag: x ion - NH3", "Fragmentation information, type of product: x ion without ammonia.", false},
    {MS_frag__precursor_ion___H2O, "MS:1001521", "frag: precursor ion - H2O", "Fragmentation information, type of product: precursor ion without water.", false},
    {MS_frag__precursor_ion___NH3, "MS:1001522", "frag: precursor ion - NH3", "Fragmentation information, type of product: precursor ion without ammonia.", false},
    {MS_frag__precursor_ion, "MS:1001523", "frag: precursor ion", "Fragmentation information, type of product: precursor ion.", false},
    {MS_fragment_neutral_loss, "MS:1001524", "fragment neutral loss", "This term can describe a neutral loss m/z value that is lost from an ion.", false},
    {MS_precursor_neutral_loss, "MS:1001525", "precursor neutral loss", "This term can describe a neutral loss m/z value that is lost from an ion.", false},
    {MS_spectrum_from_database_integer_nativeID_format, "MS:1001526", "spectrum from database integer nativeID format", "Native format defined by databasekey=xsd:long.", false},
    {MS_Proteinscape_spectra, "MS:1001527", "Proteinscape spectra", "Spectra from Bruker/Protagen Proteinscape database.", false},
    {MS_Mascot_query_number, "MS:1001528", "Mascot query number", "Native format defined by query=xsd:nonNegativeInteger.", false},
    {MS_spectra_data_details, "MS:1001529", "spectra data details", "Child-terms contain information to map the results back to spectra.", false},
    {MS_mzML_unique_identifier, "MS:1001530", "mzML unique identifier", "Native format defined by mzMLid=xsd:IDREF.", false},
    {MS_spectrum_from_ProteinScape_database_nativeID_format, "MS:1001531", "spectrum from ProteinScape database nativeID format", "Native format defined by databasekey=xsd:long.", false},
    {MS_spectrum_from_database_string_nativeID_format, "MS:1001532", "spectrum from database string nativeID format", "Native format defined by databasekey=xsd:string.", false},
    {MS_Bruker_Daltonics_esquire_series, "MS:1001533", "Bruker Daltonics esquire series", "Bruker Daltonics' esquire series.", false},
    {MS_Bruker_Daltonics_flex_series, "MS:1001534", "Bruker Daltonics flex series", "Bruker Daltonics' flex series.", false},
    {MS_Bruker_Daltonics_BioTOF_series, "MS:1001535", "Bruker Daltonics BioTOF series", "Bruker Daltonics' BioTOF series.", false},
    {MS_Bruker_Daltonics_micrOTOF_series, "MS:1001536", "Bruker Daltonics micrOTOF series", "Bruker Daltonics' micrOTOF series.", false},
    {MS_BioTOF, "MS:1001537", "BioTOF", "Bruker Daltonics' BioTOF: ESI TOF.", false},
    {MS_BioTOF_III, "MS:1001538", "BioTOF III", "Bruker Daltonics' BioTOF III: ESI TOF.", false},
    {MS_UltroTOF_Q, "MS:1001539", "UltroTOF-Q", "Bruker Daltonics' UltroTOF-Q: ESI Q-TOF (MALDI optional).", false},
    {MS_micrOTOF_II, "MS:1001540", "micrOTOF II", "Bruker Daltonics' micrOTOF II: ESI TOF, Nanospray, APCI, APPI.", false},
    {MS_maXis, "MS:1001541", "maXis", "Bruker Daltonics' maXis: ESI Q-TOF, Nanospray, APCI, APPI.", false},
    {MS_amaZon_ETD, "MS:1001542", "amaZon ETD", "Bruker Daltonics' amaZon ETD: ESI quadrupole ion trap, Nanospray, APCI, APPI, ETD, PTR.", false},
    {MS_microflex_LRF, "MS:1001543", "microflex LRF", "Bruker Daltonics' microflex LRF: MALDI TOF.", false},
    {MS_ultrafleXtreme, "MS:1001544", "ultrafleXtreme", "Bruker Daltonics' ultrafleXtreme: MALDI TOF.", false},
    {MS_Bruker_Daltonics_amaZon_series, "MS:1001545", "Bruker Daltonics amaZon series", "Bruker Daltonics' amaZon series.", false},
    {MS_amaZon_X, "MS:1001546", "amaZon X", "Bruker Daltonics' amaZon X: ESI quadrupole ion trap, APCI, APPI, ETD, PTR.", false},
    {MS_Bruker_Daltonics_maXis_series, "MS:1001547", "Bruker Daltonics maXis series", "Bruker Daltonics' maXis series.", false},
    {MS_Bruker_Daltonics_solarix_series, "MS:1001548", "Bruker Daltonics solarix series", "Bruker Daltonics' solarix: ESI quadrupole ion trap, APCI, APPI, ETD, PTR.", false},
    {MS_solariX, "MS:1001549", "solariX", "Bruker Daltonics' solariX: ESI, MALDI, Qh-FT_ICR.", false},
    {MS_microflex_II, "MS:1001550", "microflex II", "Bruker Daltonics' microflex II: MALDI TOF.", false},
    {MS_autoflex_II_TOF_TOF, "MS:1001553", "autoflex II TOF/TOF", "Bruker Daltonics' autoflex II TOF/TOF: MALDI TOF.", false},
    {MS_autoflex_III_TOF_TOF_smartbeam, "MS:1001554", "autoflex III TOF/TOF smartbeam", "Bruker Daltonics' autoflex III TOF/TOF smartbeam: MALDI TOF.", false},
    {MS_autoflex, "MS:1001555", "autoflex", "Bruker Daltonics' autoflex: MALDI TOF.", false},
    {MS_Bruker_Daltonics_apex_series, "MS:1001556", "Bruker Daltonics apex series", "Bruker Daltonics' apex series.", false},
    {MS_Shimadzu_Corporation_software, "MS:1001557", "Shimadzu Corporation software", "Shimadzu Corporation software.", false},
    {MS_MALDI_Solutions, "MS:1001558", "MALDI Solutions", "Shimadzu Biotech software for data acquisition, processing, and analysis.", false},
    {MS_SCIEX_TOF_TOF_T2D_nativeID_format, "MS:1001559", "SCIEX TOF/TOF T2D nativeID format", "Native format defined by file=xsd:IDREF.", false},
    {MS_SCIEX_TOF_TOF_T2D_format, "MS:1001560", "SCIEX TOF/TOF T2D format", "Applied Biosystems/MDS Analytical Technologies TOF/TOF instrument export format.", false},
    {MS_Scaffold, "MS:1001561", "Scaffold", "Scaffold analysis software.", false},
    {MS_Scaffold_nativeID_format, "MS:1001562", "Scaffold nativeID format", "Scaffold native ID format.", false},
    {MS_SEQUEST_SQT_format, "MS:1001563", "SEQUEST SQT format", "Source file for this mzIdentML was in SEQUEST SQT format.", false},
    {MS_Discoverer_MSF_format, "MS:1001564", "Discoverer MSF format", "Source file for this mzIdentML was in Thermo Scientific Discoverer MSF format.", false},
    {MS_IdentityE_XML_format, "MS:1001565", "IdentityE XML format", "Source file for this mzIdentML was in Waters IdentityE XML format.", false},
    {MS_ProteinLynx_XML_format, "MS:1001566", "ProteinLynx XML format", "Source file for this mzIdentML was in Waters ProteinLynx XML format.", false},
    {MS_SpectrumMill_directories, "MS:1001567", "SpectrumMill directories", "Source file for this mzIdentML was in Agilent SpectrumMill directory format.", false},
    {MS_Scaffold_Peptide_Probability, "MS:1001568", "Scaffold:Peptide Probability", "Scaffold peptide probability score.", false},
    {MS_IdentityE_Score, "MS:1001569", "IdentityE Score", "Waters IdentityE peptide score.", false},
    {MS_ProteinLynx_Log_Likelihood, "MS:1001570", "ProteinLynx:Log Likelihood", "ProteinLynx log likelihood score.", false},
    {MS_ProteinLynx_Ladder_Score, "MS:1001571", "ProteinLynx:Ladder Score", "Waters ProteinLynx Ladder score.", false},
    {MS_SpectrumMill_Score, "MS:1001572", "SpectrumMill:Score", "Spectrum mill peptide score.", false},
    {MS_SpectrumMill_SPI, "MS:1001573", "SpectrumMill:SPI", "SpectrumMill SPI score (%).", false},
    {MS_report_only_spectra_assigned_to_identified_proteins, "MS:1001574", "report only spectra assigned to identified proteins", "Flag indicating to report only the spectra assigned to identified proteins.", false},
    {MS_Scaffold__Minimum_Peptide_Count, "MS:1001575", "Scaffold: Minimum Peptide Count", "Minimum number of peptides a protein must have to be accepted.", false},
    {MS_Scaffold__Minimum_Protein_Probability, "MS:1001576", "Scaffold: Minimum Protein Probability", "Minimum protein probability a protein must have to be accepted.", false},
    {MS_Scaffold__Minimum_Peptide_Probability, "MS:1001577", "Scaffold: Minimum Peptide Probability", "Minimum probability a peptide must have to be accepted for protein scoring.", false},
    {MS_minimum_number_of_enzymatic_termini, "MS:1001578", "minimum number of enzymatic termini", "Minimum number of enzymatic termini a peptide must have to be accepted.", false},
    {MS_Scaffold_Protein_Probability, "MS:1001579", "Scaffold:Protein Probability", "Scaffold protein probability score.", false},
    {MS_SpectrumMill_Discriminant_Score, "MS:1001580", "SpectrumMill:Discriminant Score", "Discriminant score from Agilent SpectrumMill software.", false},
    {MS_FAIMS_compensation_voltage, "MS:1001581", "FAIMS compensation voltage", "The DC potential applied to the asymmetric waveform in FAIMS that compensates for the difference between high and low field mobility of an ion.", false},
    {MS_XCMS, "MS:1001582", "XCMS", "Bioconductor package XCMS for preprocessing high-throughput, untargeted analyte profiling data.", false},
    {MS_MaxQuant, "MS:1001583", "MaxQuant", "MaxQuant is a quantitative proteomics software package designed for analyzing large mass spectrometric data sets. It is specifically aimed at high resolution MS data.", false},
    {MS_combined_pmf___ms_ms_search, "MS:1001584", "combined pmf + ms-ms search", "Search that includes data from Peptide Mass Fingerprint (PMF) and MS2 (aka Peptide Fragment Fingerprint - PFF).", false},
    {MS_MyriMatch, "MS:1001585", "MyriMatch", "Tabb Lab software for directly comparing peptides in a database to tandem mass spectra.", false},
    {MS_DirecTag, "MS:1001586", "DirecTag", "Tabb Lab software for generating sequence tags from tandem mass spectra.", false},
    {MS_TagRecon, "MS:1001587", "TagRecon", "Tabb Lab software for reconciling sequence tags to a protein database.", false},
    {MS_Pepitome, "MS:1001588", "Pepitome", "Tabb Lab software for spectral library searches on tandem mass spectra.", false},
    {MS_MyriMatch_MVH, "MS:1001589", "MyriMatch:MVH", "Using the multivariate hypergeometric distribution and a peak list divided into several intensity classes, this score is the negative natural log probability that the predicted peaks matched to experimental peaks by random chance.", false},
    {MS_MyriMatch_mzFidelity, "MS:1001590", "MyriMatch:mzFidelity", "The negative natural log probability that predicted peaks match to experimental peaks by random chance by scoring the m/z delta of the matches in a multinomial distribution.", false},
    {MS_anchor_protein, "MS:1001591", "anchor protein", "A representative protein selected from a set of sequence same-set or spectrum same-set proteins.", false},
    {MS_family_member_protein, "MS:1001592", "family member protein", "A protein with significant homology to another protein, but some distinguishing peptide matches.", false},
    {MS_group_member_with_undefined_relationship_OR_ortholog_protein, "MS:1001593", "group member with undefined relationship OR ortholog protein", "TO ENDETAIL: a really generic relationship OR ortholog protein.", false},
    {MS_sequence_same_set_protein, "MS:1001594", "sequence same-set protein", "A protein which is indistinguishable or equivalent to another protein, having matches to an identical set of peptide sequences.", false},
    {MS_spectrum_same_set_protein, "MS:1001595", "spectrum same-set protein", "A protein which is indistinguishable or equivalent to another protein, having matches to a set of peptide sequences that cannot be distinguished using the evidence in the mass spectra.", false},
    {MS_sequence_sub_set_protein, "MS:1001596", "sequence sub-set protein", "A protein with a sub-set of the peptide sequence matches for another protein, and no distinguishing peptide matches.", false},
    {MS_spectrum_sub_set_protein, "MS:1001597", "spectrum sub-set protein", "A protein with a sub-set of the matched spectra for another protein, where the matches cannot be distinguished using the evidence in the mass spectra, and no distinguishing peptide matches.", false},
    {MS_sequence_subsumable_protein, "MS:1001598", "sequence subsumable protein", "A sequence same-set or sequence sub-set protein where the matches are distributed across two or more proteins.", false},
    {MS_spectrum_subsumable_protein, "MS:1001599", "spectrum subsumable protein", "A spectrum same-set or spectrum sub-set protein where the matches are distributed across two or more proteins.", false},
    {MS_protein_inference_confidence_category, "MS:1001600", "protein inference confidence category", "Confidence category of inferred protein (conclusive, non conclusive, ambiguous group or indistinguishable).", false},
    {MS_ProteomeDiscoverer_Spectrum_Files_Raw_File_names_OBSOLETE, "MS:1001601", "ProteomeDiscoverer:Spectrum Files:Raw File names", "Name and location of the .raw file or files.", true},
    {MS_ProteomeDiscoverer_SRF_File_Selector_SRF_File_Path_OBSOLETE, "MS:1001602", "ProteomeDiscoverer:SRF File Selector:SRF File Path", "Path and name of the .srf (SEQUEST Result Format) file.", true},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Ionization_Source_OBSOLETE, "MS:1001603", "ProteomeDiscoverer:Spectrum Selector:Ionization Source", "Ionization source (electro-, nano-, thermospray, electron impact, APCI, MALDI, FAB etc).", true},
    {MS_ProteomeDiscoverer_Activation_Type_OBSOLETE, "MS:1001604", "ProteomeDiscoverer:Activation Type", "Fragmentation method used (CID, MPD, ECD, PQD, ETD, HCD, Any).", true},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Lower_RT_Limit, "MS:1001605", "ProteomeDiscoverer:Spectrum Selector:Lower RT Limit", "Lower retention-time limit.", false},
    {MS_ProteomeDiscoverer_Mass_Analyzer_OBSOLETE, "MS:1001606", "ProteomeDiscoverer:Mass Analyzer", "Type of mass spectrometer used (ITMS, FTMS, TOFMS, SQMS, TQMS, SectorMS).", true},
    {MS_ProteomeDiscoverer_Max_Precursor_Mass, "MS:1001607", "ProteomeDiscoverer:Max Precursor Mass", "Maximum mass limit of a singly charged precursor ion.", false},
    {MS_ProteomeDiscoverer_Min_Precursor_Mass, "MS:1001608", "ProteomeDiscoverer:Min Precursor Mass", "Minimum mass limit of a singly charged precursor ion.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Minimum_Peak_Count, "MS:1001609", "ProteomeDiscoverer:Spectrum Selector:Minimum Peak Count", "Minimum number of peaks in a tandem mass spectrum that is allowed to pass the filter and to be subjected to further processing in the workflow.", false},
    {MS_ProteomeDiscoverer_MS_Order_OBSOLETE, "MS:1001610", "ProteomeDiscoverer:MS Order", "Level of the mass spectrum (MS2 ... MS10).", true},
    {MS_ProteomeDiscoverer_Polarity_Mode_OBSOLETE, "MS:1001611", "ProteomeDiscoverer:Polarity Mode", "Polarity mode (positive or negative).", true},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Selection, "MS:1001612", "ProteomeDiscoverer:Spectrum Selector:Precursor Selection", "Determines which precursor mass to use for a given MSn scan. This option applies only to higher-order MSn scans (n >= 3).", false},
    {MS_ProteomeDiscoverer_SN_Threshold, "MS:1001613", "ProteomeDiscoverer:SN Threshold", "Signal-to-Noise ratio below which peaks are removed.", false},
    {MS_ProteomeDiscoverer_Scan_Type_OBSOLETE, "MS:1001614", "ProteomeDiscoverer:Scan Type", "Scan type for the precursor ion (full, Single Ion Monitoring (SIM), Single Reaction Monitoring (SRM)).", true},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Total_Intensity_Threshold, "MS:1001615", "ProteomeDiscoverer:Spectrum Selector:Total Intensity Threshold", "Used to filter out tandem mass spectra that have a total intensity current(sum of the intensities of all peaks in a spectrum) below the specified value.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Activation_Type_Replacements, "MS:1001616", "ProteomeDiscoverer:Spectrum Selector:Unrecognized Activation Type Replacements", "Specifies the fragmentation method to use in the search algorithm if it is not included in the scan header.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Charge_Replacements, "MS:1001617", "ProteomeDiscoverer:Spectrum Selector:Unrecognized Charge Replacements", "Specifies the charge state of the precursor ions, if it is not defined in the scan header.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Mass_Analyzer_Replacements, "MS:1001618", "ProteomeDiscoverer:Spectrum Selector:Unrecognized Mass Analyzer Replacements", "Specifies the mass spectrometer to use to produce the spectra, if it is not included in the scan header.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_MS_Order_Replacements, "MS:1001619", "ProteomeDiscoverer:Spectrum Selector:Unrecognized MS Order Replacements", "Specifies the MS scan order used to produce the product spectra, if it is not included in the scan header.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Polarity_Replacements, "MS:1001620", "ProteomeDiscoverer:Spectrum Selector:Unrecognized Polarity Replacements", "Specifies the polarity of the ions monitored if it is not included in the scan header.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Upper_RT_Limit, "MS:1001621", "ProteomeDiscoverer:Spectrum Selector:Upper RT Limit", "Upper retention-time limit.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Mass_Window_Offset, "MS:1001622", "ProteomeDiscoverer:Non-Fragment Filter:Mass Window Offset", "Specifies the size of the mass-to-charge ratio (m/z) window in daltons used to remove precursors.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Maximum_Neutral_Loss_Mass, "MS:1001623", "ProteomeDiscoverer:Non-Fragment Filter:Maximum Neutral Loss Mass", "Maximum allowed mass of a neutral loss.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Charge_Reduced_Precursor, "MS:1001624", "ProteomeDiscoverer:Non-Fragment Filter:Remove Charge Reduced Precursor", "Determines whether the charge-reduced precursor peaks found in an ETD or ECD spectrum are removed.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Neutral_Loss_Peaks, "MS:1001625", "ProteomeDiscoverer:Non-Fragment Filter:Remove Neutral Loss Peaks", "Determines whether neutral loss peaks are removed from ETD and ECD spectra.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Only_Known_Masses, "MS:1001626", "ProteomeDiscoverer:Non-Fragment Filter:Remove Only Known Masses", "Determines whether overtone peaks are removed from LTQ FT or LTQ FT Ultra ECD spectra.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Precursor_Overtones, "MS:1001627", "ProteomeDiscoverer:Non-Fragment Filter:Remove Precursor Overtones", "Determines whether precursor overtone peaks in the spectrum are removed from the input spectrum.", false},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Precursor_Peak, "MS:1001628", "ProteomeDiscoverer:Non-Fragment Filter:Remove Precursor Peak", "Determines whether precursor artifact peaks from the MS2 input spectra are removed.", false},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Allow_Mass_Analyzer_Mismatch, "MS:1001629", "ProteomeDiscoverer:Spectrum Grouper:Allow Mass Analyzer Mismatch", "Determines whether the fragment spectrum for scans with the same precursor mass is grouped, regardless of mass analyzer and activation type.", false},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Allow_MS_Order_Mismatch, "MS:1001630", "ProteomeDiscoverer:Spectrum Grouper:Allow MS Order Mismatch", "Determines whether spectra from different MS order scans can be grouped together.", false},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Max_RT_Difference_OBSOLETE, "MS:1001631", "ProteomeDiscoverer:Spectrum Grouper:Max RT Difference", "Chromatographic window where precursors to be grouped must reside to be considered the same species.", true},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Precursor_Mass_Criterion, "MS:1001632", "ProteomeDiscoverer:Spectrum Grouper:Precursor Mass Criterion", "Groups spectra measured within the given mass and retention-time tolerances into a single spectrum for analysis.", false},
    {MS_ProteomeDiscoverer_Xtract_Highest_Charge, "MS:1001633", "ProteomeDiscoverer:Xtract:Highest Charge", "Highest charge state that is allowed for the deconvolution of multiply charged data.", false},
    {MS_ProteomeDiscoverer_Xtract_Highest_MZ_OBSOLETE, "MS:1001634", "ProteomeDiscoverer:Xtract:Highest MZ", "Highest mass-to-charge (mz) value for spectral peaks in the measured spectrum that are considered for Xtract.", true},
    {MS_ProteomeDiscoverer_Xtract_Lowest_Charge, "MS:1001635", "ProteomeDiscoverer:Xtract:Lowest Charge", "Lowest charge state that is allowed for the deconvolution of multiply charged data.", false},
    {MS_ProteomeDiscoverer_Xtract_Lowest_MZ_OBSOLETE, "MS:1001636", "ProteomeDiscoverer:Xtract:Lowest MZ", "Lowest mass-to-charge (mz) value for spectral peaks in the measured spectrum that are considered for Xtract.", true},
    {MS_ProteomeDiscoverer_Xtract_Monoisotopic_Mass_Only, "MS:1001637", "ProteomeDiscoverer:Xtract:Monoisotopic Mass Only", "Determines whether the isotopic pattern, i.e. all isotopes of a mass are removed from the spectrum.", false},
    {MS_ProteomeDiscoverer_Xtract_Overlapping_Remainder, "MS:1001638", "ProteomeDiscoverer:Xtract:Overlapping Remainder", "Fraction of the more abundant peak that an overlapping multiplet must exceed in order to be processed (deconvoluted).", false},
    {MS_ProteomeDiscoverer_Xtract_Required_Fitting_Accuracy, "MS:1001639", "ProteomeDiscoverer:Xtract:Required Fitting Accuracy", "Accuracy required for a pattern fit to be considered valid.", false},
    {MS_ProteomeDiscoverer_Xtract_Resolution_At_400, "MS:1001640", "ProteomeDiscoverer:Xtract:Resolution At 400", "Resolution at mass 400.", false},
    {MS_ProteomeDiscoverer_Lowest_Charge_State, "MS:1001641", "ProteomeDiscoverer:Lowest Charge State", "Minimum charge state below which peptides are filtered out.", false},
    {MS_ProteomeDiscoverer_Highest_Charge_State, "MS:1001642", "ProteomeDiscoverer:Highest Charge State", "Maximum charge above which peptides are filtered out.", false},
    {MS_ProteomeDiscoverer_Spectrum_Score_Filter_Let_Pass_Above_Scores, "MS:1001643", "ProteomeDiscoverer:Spectrum Score Filter:Let Pass Above Scores", "Determines whether spectra with scores above the threshold score are retained rather than filtered out.", false},
    {MS_ProteomeDiscoverer_Dynamic_Modification, "MS:1001644", "ProteomeDiscoverer:Dynamic Modification", "Determine dynamic post-translational modifications (PTMs).", false},
    {MS_ProteomeDiscoverer_Static_Modification, "MS:1001645", "ProteomeDiscoverer:Static Modification", "Static Modification to all occurrences of a named amino acid.", false},
    {MS_ProteomeDiscoverer_Mascot_Decoy_Search_OBSOLETE, "MS:1001646", "ProteomeDiscoverer:Mascot:Decoy Search", "Determines whether the Proteome Discoverer application searches an additional decoy database.", true},
    {MS_ProteomeDiscoverer_Mascot_Error_tolerant_Search, "MS:1001647", "ProteomeDiscoverer:Mascot:Error tolerant Search", "Determines whether to search error-tolerant.", false},
    {MS_ProteomeDiscoverer_Mascot_Max_MGF_File_Size, "MS:1001648", "ProteomeDiscoverer:Mascot:Max MGF File Size", "Maximum size of the .mgf (Mascot Generic Format) file in MByte.", false},
    {MS_ProteomeDiscoverer_Mascot_Mascot_Server_URL, "MS:1001649", "ProteomeDiscoverer:Mascot:Mascot Server URL", "URL (Uniform resource Locator) of the Mascot server.", false},
    {MS_ProteomeDiscoverer_Mascot_Number_of_attempts_to_submit_the_search, "MS:1001650", "ProteomeDiscoverer:Mascot:Number of attempts to submit the search", "Number of attempts to submit the Mascot search.", false},
    {MS_ProteomeDiscoverer_Mascot_X_Static_Modification, "MS:1001651", "ProteomeDiscoverer:Mascot:X Static Modification", "Number of attempts to submit the Mascot search.", false},
    {MS_ProteomeDiscoverer_Mascot_User_Name_OBSOLETE, "MS:1001652", "ProteomeDiscoverer:Mascot:User Name", "Name of the user submitting the Mascot search.", true},
    {MS_ProteomeDiscoverer_Mascot_Time_interval_between_attempts_to_submit_a_search, "MS:1001653", "ProteomeDiscoverer:Mascot:Time interval between attempts to submit a search", "Time interval between attempts to submit a search in seconds.", false},
    {MS_ProteomeDiscoverer_Enzyme_Name_OBSOLETE, "MS:1001654", "ProteomeDiscoverer:Enzyme Name", "Specifies the enzyme reagent used for protein digestion.", true},
    {MS_ProteomeDiscoverer_Fragment_Mass_Tolerance_OBSOLETE, "MS:1001655", "ProteomeDiscoverer:Fragment Mass Tolerance", "Mass tolerance used for matching fragment peaks in Da or mmu.", true},
    {MS_Mascot_Instrument, "MS:1001656", "Mascot:Instrument", "Type of instrument used to acquire the data in the raw file.", false},
    {MS_ProteomeDiscoverer_Maximum_Missed_Cleavage_Sites, "MS:1001657", "ProteomeDiscoverer:Maximum Missed Cleavage Sites", "Maximum number of missed cleavage sites to consider during the digest.", false},
    {MS_ProteomeDiscoverer_Mascot_Peptide_CutOff_Score, "MS:1001658", "ProteomeDiscoverer:Mascot:Peptide CutOff Score", "Minimum score in the IonScore column that each peptide must exceed in order to be reported.", false},
    {MS_ProteomeDiscoverer_Precursor_Mass_Tolerance_OBSOLETE, "MS:1001659", "ProteomeDiscoverer:Precursor Mass Tolerance", "Mass window for which precursor ions are considered to be the same species.", true},
    {MS_ProteomeDiscoverer_Mascot_Protein_CutOff_Score, "MS:1001660", "ProteomeDiscoverer:Mascot:Protein CutOff Score", "Minimum protein score in the IonScore column that each protein must exceed in order to be reported.", false},
    {MS_ProteomeDiscoverer_Protein_Database_OBSOLETE, "MS:1001661", "ProteomeDiscoverer:Protein Database", "Database to use in the search (configured on the Mascot server).", true},
    {MS_ProteomeDiscoverer_Mascot_Protein_Relevance_Factor, "MS:1001662", "ProteomeDiscoverer:Mascot:Protein Relevance Factor", "Specifies a factor that is used in calculating a threshold that determines whether a protein appears in the results report.", false},
    {MS_ProteomeDiscoverer_Target_FDR_Relaxed, "MS:1001663", "ProteomeDiscoverer:Target FDR Relaxed", "Specifies the relaxed target false discovery rate (FDR, 0.0 - 1.0) for peptide hits with moderate confidence.", false},
    {MS_ProteomeDiscoverer_Target_FDR_Strict, "MS:1001664", "ProteomeDiscoverer:Target FDR Strict", "Specifies the strict target false discovery rate (FDR, 0.0 - 1.0) for peptide hits with high confidence.", false},
    {MS_ProteomeDiscoverer_Mascot_Taxonomy_OBSOLETE, "MS:1001665", "ProteomeDiscoverer:Mascot:Taxonomy", "Limits searches to entries from a particular species or group of species.", true},
    {MS_ProteomeDiscoverer_Use_Average_Precursor_Mass_OBSOLETE, "MS:1001666", "ProteomeDiscoverer:Use Average Precursor Mass", "Use average mass for the precursor.", true},
    {MS_Mascot_use_MudPIT_scoring_OBSOLETE, "MS:1001667", "Mascot:use MudPIT scoring", "Determines whether to use MudPIT or normal scoring.", true},
    {MS_ProteomeDiscoverer_Absolute_XCorr_Threshold, "MS:1001668", "ProteomeDiscoverer:Absolute XCorr Threshold", "Minimum cross-correlation threshold that determines whether peptides in an .srf file are imported.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Calculate_Probability_Score, "MS:1001669", "ProteomeDiscoverer:SEQUEST:Calculate Probability Score", "Determines whether to calculate a probability score for every peptide match.", false},
    {MS_ProteomeDiscoverer_SEQUEST_CTerminal_Modification, "MS:1001670", "ProteomeDiscoverer:SEQUEST:CTerminal Modification", "Dynamic C-terminal modification that is used during the search.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Fragment_Ion_Cutoff_Percentage, "MS:1001671", "ProteomeDiscoverer:SEQUEST:Fragment Ion Cutoff Percentage", "Percentage of the theoretical ions that must be found in order for a peptide to be scored and retained.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Max_Identical_Modifications_Per_Peptide, "MS:1001672", "ProteomeDiscoverer:SEQUEST:Max Identical Modifications Per Peptide", "Maximum number of identical modifications that a single peptide can have.", false},
    {MS_ProteomeDiscoverer_Max_Modifications_Per_Peptide, "MS:1001673", "ProteomeDiscoverer:Max Modifications Per Peptide", "Maximum number of different modifications that a peptide can have, e.g. because of steric hindrance.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Maximum_Peptides_Considered, "MS:1001674", "ProteomeDiscoverer:SEQUEST:Maximum Peptides Considered", "Maximum number of peptides that are searched and scored per spectrum.", false},
    {MS_ProteomeDiscoverer_Maximum_Peptides_Output, "MS:1001675", "ProteomeDiscoverer:Maximum Peptides Output", "Maximum number of peptide matches reported per spectrum.", false},
    {MS_ProteomeDiscoverer_Maximum_Protein_References_Per_Peptide, "MS:1001676", "ProteomeDiscoverer:Maximum Protein References Per Peptide", "Maximum number of proteins that a single identified peptide can be associated with during protein assembly.", false},
    {MS_ProteomeDiscoverer_SEQUEST_NTerminal_Modification, "MS:1001677", "ProteomeDiscoverer:SEQUEST:NTerminal Modification", "Dynamic N-terminal modification that is used during the search.", false},
    {MS_ProteomeDiscoverer_Peptide_CTerminus, "MS:1001678", "ProteomeDiscoverer:Peptide CTerminus", "Static modification for the C terminal of the peptide used during the search.", false},
    {MS_ProteomeDiscoverer_Peptide_NTerminus, "MS:1001679", "ProteomeDiscoverer:Peptide NTerminus", "Static modification for the N terminal of the peptide used during the search.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Peptide_Relevance_Factor, "MS:1001680", "ProteomeDiscoverer:SEQUEST:Peptide Relevance Factor", "Specifies a factor to apply to the protein score.", false},
    {MS_ProteomeDiscoverer_Protein_Relevance_Threshold, "MS:1001681", "ProteomeDiscoverer:Protein Relevance Threshold", "Specifies a peptide threshold that determines whether the protein that it is a part of is scored and retained in the report.", false},
    {MS_ProteomeDiscoverer_Search_Against_Decoy_Database_OBSOLETE, "MS:1001682", "ProteomeDiscoverer:Search Against Decoy Database", "Determines whether the Proteome Discoverer application searches against a decoy database.", true},
    {MS_ProteomeDiscoverer_SEQUEST_Use_Average_Fragment_Masses, "MS:1001683", "ProteomeDiscoverer:SEQUEST:Use Average Fragment Masses", "Use average masses for the fragments.", false},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_a_Ions, "MS:1001684", "ProteomeDiscoverer:Use Neutral Loss a Ions", "Determines whether a ions with neutral loss are used for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_b_Ions, "MS:1001685", "ProteomeDiscoverer:Use Neutral Loss b Ions", "Determines whether b ions with neutral loss are used for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_y_Ions, "MS:1001686", "ProteomeDiscoverer:Use Neutral Loss y Ions", "Determines whether y ions with neutral loss are used for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_z_Ions, "MS:1001687", "ProteomeDiscoverer:Use Neutral Loss z Ions", "Determines whether z ions with neutral loss are used for spectrum matching.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_a_Ions, "MS:1001688", "ProteomeDiscoverer:SEQUEST:Weight of a Ions", "Uses a ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_b_Ions, "MS:1001689", "ProteomeDiscoverer:SEQUEST:Weight of b Ions", "Uses b ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_c_Ions, "MS:1001690", "ProteomeDiscoverer:SEQUEST:Weight of c Ions", "Uses c ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_d_Ions, "MS:1001691", "ProteomeDiscoverer:SEQUEST:Weight of d Ions", "Uses c ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_v_Ions, "MS:1001692", "ProteomeDiscoverer:SEQUEST:Weight of v Ions", "Uses c ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_w_Ions, "MS:1001693", "ProteomeDiscoverer:SEQUEST:Weight of w Ions", "Uses c ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_x_Ions, "MS:1001694", "ProteomeDiscoverer:SEQUEST:Weight of x Ions", "Uses x ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_y_Ions, "MS:1001695", "ProteomeDiscoverer:SEQUEST:Weight of y Ions", "Uses y ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_z_Ions, "MS:1001696", "ProteomeDiscoverer:SEQUEST:Weight of z Ions", "Uses z ions for spectrum matching with this relative factor.", false},
    {MS_ProteomeDiscoverer_ZCore_Protein_Score_Cutoff, "MS:1001697", "ProteomeDiscoverer:ZCore:Protein Score Cutoff", "Sets a minimum protein score that each protein must exceed in order to be reported.", false},
    {MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Integration_Method, "MS:1001698", "ProteomeDiscoverer:Reporter Ions Quantizer:Integration Method", "Specifies which peak to select if more than one peak is found inside the integration window.", false},
    {MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Integration_Window_Tolerance, "MS:1001699", "ProteomeDiscoverer:Reporter Ions Quantizer:Integration Window Tolerance", "Specifies the mass-to-charge window that enables one to look for the reporter peaks.", false},
    {MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Quantitation_Method, "MS:1001700", "ProteomeDiscoverer:Reporter Ions Quantizer:Quantitation Method", "Quantitation method for isobarically labeled quantitation.", false},
    {MS_ProteomeDiscoverer_Spectrum_Exporter_Export_Format_OBSOLETE, "MS:1001701", "ProteomeDiscoverer:Spectrum Exporter:Export Format", "Format of the exported spectra (dta, mgf or mzData).", true},
    {MS_ProteomeDiscoverer_Spectrum_Exporter_File_name, "MS:1001702", "ProteomeDiscoverer:Spectrum Exporter:File name", "Name of the output file that contains the exported data.", false},
    {MS_ProteomeDiscoverer_Search_Modifications_Only_For_Identified_Proteins, "MS:1001703", "ProteomeDiscoverer:Search Modifications Only For Identified Proteins", "Influences the modifications search.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge1, "MS:1001704", "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge1", "Standard high confidence XCorr parameter for charge = 1.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge2, "MS:1001705", "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge2", "Standard high confidence XCorr parameter for charge = 2.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge3, "MS:1001706", "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge3", "Standard high confidence XCorr parameter for charge = 3.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge4, "MS:1001707", "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge4", "Standard high confidence XCorr parameter for charge >= 4.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge1, "MS:1001708", "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge1", "Standard medium confidence XCorr parameter for charge = 1.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge2, "MS:1001709", "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge2", "Standard medium confidence XCorr parameter for charge = 2.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge3, "MS:1001710", "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge3", "Standard medium confidence XCorr parameter for charge = 3.", false},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge4, "MS:1001711", "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge4", "Standard medium confidence XCorr parameter for charge >= 4.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge1, "MS:1001712", "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge1", "FT high confidence XCorr parameter for charge = 1.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge2, "MS:1001713", "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge2", "FT high confidence XCorr parameter for charge = 2.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge3, "MS:1001714", "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge3", "FT high confidence XCorr parameter for charge = 3.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge4, "MS:1001715", "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge4", "FT high confidence XCorr parameter for charge >= 4.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge1, "MS:1001716", "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge1", "FT medium confidence XCorr parameter for charge = 1.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge2, "MS:1001717", "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge2", "FT medium confidence XCorr parameter for charge = 2.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge3, "MS:1001718", "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge3", "FT medium confidence XCorr parameter for charge = 3.", false},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge4, "MS:1001719", "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge4", "FT medium confidence XCorr parameter for charge >= 4.", false},
    {MS_ProteomeDiscoverer_1__Dynamic_Modification_OBSOLETE, "MS:1001720", "ProteomeDiscoverer:1. Dynamic Modification", "ProteomeDiscoverer's 1st dynamic post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_2__Dynamic_Modification_OBSOLETE, "MS:1001721", "ProteomeDiscoverer:2. Dynamic Modification", "ProteomeDiscoverer's 2nd dynamic post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_3__Dynamic_Modification_OBSOLETE, "MS:1001722", "ProteomeDiscoverer:3. Dynamic Modification", "ProteomeDiscoverer's 3rd dynamic post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_4__Dynamic_Modification_OBSOLETE, "MS:1001723", "ProteomeDiscoverer:4. Dynamic Modification", "ProteomeDiscoverer's 4th dynamic post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_Static_Modification_for_X, "MS:1001724", "ProteomeDiscoverer:Static Modification for X", "Static Modification for X.", false},
    {MS_ProteomeDiscoverer_Initial_minimal_peptide_probability, "MS:1001725", "ProteomeDiscoverer:Initial minimal peptide probability", "Minimal initial peptide probability to contribute to analysis.", false},
    {MS_ProteomeDiscoverer_Minimal_peptide_probability, "MS:1001726", "ProteomeDiscoverer:Minimal peptide probability", "Minimum adjusted peptide probability contributing to protein probability.", false},
    {MS_ProteomeDiscoverer_Minimal_peptide_weight, "MS:1001727", "ProteomeDiscoverer:Minimal peptide weight", "Minimum peptide weight contributing to protein probability.", false},
    {MS_ProteomeDiscoverer_Number_of_input1_spectra, "MS:1001728", "ProteomeDiscoverer:Number of input1 spectra", "Number of spectra from 1+ precursor ions.", false},
    {MS_ProteomeDiscoverer_Number_of_input2_spectra, "MS:1001729", "ProteomeDiscoverer:Number of input2 spectra", "Number of spectra from 2+ precursor ions.", false},
    {MS_ProteomeDiscoverer_Number_of_input3_spectra, "MS:1001730", "ProteomeDiscoverer:Number of input3 spectra", "Number of spectra from 3+ precursor ions.", false},
    {MS_ProteomeDiscoverer_Number_of_input4_spectra, "MS:1001731", "ProteomeDiscoverer:Number of input4 spectra", "Number of spectra from 4+ precursor ions.", false},
    {MS_ProteomeDiscoverer_Number_of_input5_spectra, "MS:1001732", "ProteomeDiscoverer:Number of input5 spectra", "Number of spectra from 5+ precursor ions.", false},
    {MS_ProteomeDiscoverer_Number_of_predicted_correct_proteins, "MS:1001733", "ProteomeDiscoverer:Number of predicted correct proteins", "Total number of predicted correct protein ids (sum of probabilities).", false},
    {MS_ProteomeDiscoverer_Organism_OBSOLETE, "MS:1001734", "ProteomeDiscoverer:Organism", "Sample organism (used for annotation purposes).", true},
    {MS_ProteomeDiscoverer_Reference_Database_OBSOLETE, "MS:1001735", "ProteomeDiscoverer:Reference Database", "Full path database name.", true},
    {MS_ProteomeDiscoverer_Residue_substitution_list, "MS:1001736", "ProteomeDiscoverer:Residue substitution list", "Residues considered equivalent when comparing peptides.", false},
    {MS_ProteomeDiscoverer_Source_file_extension_OBSOLETE, "MS:1001737", "ProteomeDiscoverer:Source file extension", "File type (if not pepXML).", true},
    {MS_ProteomeDiscoverer_Source_Files_OBSOLETE, "MS:1001738", "ProteomeDiscoverer:Source Files", "Input pepXML files.", true},
    {MS_ProteomeDiscoverer_Source_Files_old_OBSOLETE, "MS:1001739", "ProteomeDiscoverer:Source Files old", "Input pepXML files (old).", true},
    {MS_ProteomeDiscoverer_WinCyg_reference_database, "MS:1001740", "ProteomeDiscoverer:WinCyg reference database", "Windows full path for database.", false},
    {MS_ProteomeDiscoverer_WinCyg_source_files, "MS:1001741", "ProteomeDiscoverer:WinCyg source files", "Windows pepXML file names.", false},
    {MS_LTQ_Orbitrap_Velos, "MS:1001742", "LTQ Orbitrap Velos", "Finnigan LTQ Orbitrap Velos MS.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_A_Ions, "MS:1001743", "ProteomeDiscoverer:Mascot:Weight of A Ions", "Determines if to use A ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_B_Ions, "MS:1001744", "ProteomeDiscoverer:Mascot:Weight of B Ions", "Determines if to use B ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_C_Ions, "MS:1001745", "ProteomeDiscoverer:Mascot:Weight of C Ions", "Determines if to use C ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_D_Ions, "MS:1001746", "ProteomeDiscoverer:Mascot:Weight of D Ions", "Determines if to use D ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_V_Ions, "MS:1001747", "ProteomeDiscoverer:Mascot:Weight of V Ions", "Determines if to use V ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_W_Ions, "MS:1001748", "ProteomeDiscoverer:Mascot:Weight of W Ions", "Determines if to use W ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_X_Ions, "MS:1001749", "ProteomeDiscoverer:Mascot:Weight of X Ions", "Determines if to use X ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_Y_Ions, "MS:1001750", "ProteomeDiscoverer:Mascot:Weight of Y Ions", "Determines if to use Y ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_Z_Ions, "MS:1001751", "ProteomeDiscoverer:Mascot:Weight of Z Ions", "Determines if to use z ions for spectrum matching.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Use_New_Precursor_Reevaluation, "MS:1001752", "ProteomeDiscoverer:Spectrum Selector:Use New Precursor Reevaluation", "Determines if to use precursor reevaluation.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_SN_Threshold_FTonly, "MS:1001753", "ProteomeDiscoverer:Spectrum Selector:SN Threshold FTonly", "Signal-to-Noise ratio below which peaks are removed (in FT mode only).", false},
    {MS_ProteomeDiscoverer_Mascot_Please_Do_not_Touch_this, "MS:1001754", "ProteomeDiscoverer:Mascot:Please Do not Touch this", "Unknown Mascot parameter which ProteomeDiscoverer uses for mascot searches.", false},
    {MS_contact_phone_number, "MS:1001755", "contact phone number", "Phone number of the contact person or organization.", false},
    {MS_contact_fax_number, "MS:1001756", "contact fax number", "Fax number for the contact person or organization.", false},
    {MS_contact_toll_free_phone_number, "MS:1001757", "contact toll-free phone number", "Toll-free phone number of the contact person or organization.", false},
    {MS_Mascot_SigThresholdType, "MS:1001758", "Mascot:SigThresholdType", "Significance threshold type used in Mascot reporting (either 'identity' or 'homology').", false},
    {MS_Mascot_ProteinGrouping, "MS:1001759", "Mascot:ProteinGrouping", "Strategy used by Mascot to group proteins with same peptide matches (one of 'none', 'Occam's razor' or 'family clustering').", false},
    {MS_Percolator_features, "MS:1001760", "Percolator:features", "List of Percolator features that were used in processing the peptide matches. Typical Percolator features are 'retentionTime', 'dM', 'mScore', 'lgDScore', 'mrCalc', 'charge' and 'dMppm'.", false},
    {MS_ACQUITY_UPLC, "MS:1001761", "ACQUITY UPLC", "Waters LC-system ACQUITY UPLC.", false},
    {MS_ACQUITY_UPLC_H_Class, "MS:1001762", "ACQUITY UPLC H-Class", "Waters LC-system ACQUITY UPLC H-Class.", false},
    {MS_ACQUITY_UPLC_H_Class_Bio, "MS:1001763", "ACQUITY UPLC H-Class Bio", "Waters LC-system ACQUITY UPLC H-Class Bio.", false},
    {MS_ACQUITY_UPLC_I_Class, "MS:1001764", "ACQUITY UPLC I-Class", "Waters LC-system ACQUITY UPLC I-Class.", false},
    {MS_ACQUITY_UPLC_Systems_with_2D_Technology, "MS:1001765", "ACQUITY UPLC Systems with 2D Technology", "Waters LC-system ACQUITY UPLC Systems with 2D Technology.", false},
    {MS_nanoACQUITY_UPLC, "MS:1001766", "nanoACQUITY UPLC", "Waters LC-system nanoACQUITY UPLC.", false},
    {MS_nanoACQUITY_UPLC_System_with_1D_Technology, "MS:1001767", "nanoACQUITY UPLC System with 1D Technology", "Waters LC-system nanoACQUITY UPLC System with 1D Technology.", false},
    {MS_nanoACQUITY_UPLC_with_HDX_Technology, "MS:1001768", "nanoACQUITY UPLC with HDX Technology", "Waters LC-system nanoACQUITY UPLC with HDX Technology.", false},
    {MS_TRIZAIC_UPLC_nanoTile, "MS:1001769", "TRIZAIC UPLC nanoTile", "Waters LC-system TRIZAIC UPLC nanoTile.", false},
    {MS_GCT_Premier, "MS:1001770", "GCT Premier", "Waters oa-ToF based GCT Premier.", false},
    {MS_MALDI_Synapt_G2_HDMS, "MS:1001771", "MALDI Synapt G2 HDMS", "Waters oa-ToF based MALDI Synapt G2 HDMS.", false},
    {MS_MALDI_Synapt_G2_MS, "MS:1001772", "MALDI Synapt G2 MS", "Waters oa-ToF based MALDI Synapt G2 MS.", false},
    {MS_MALDI_Synapt_G2_S_HDMS, "MS:1001773", "MALDI Synapt G2-S HDMS", "Waters oa-ToF based MALDI Synapt G2 MS.", false},
    {MS_MALDI_Synapt_G2_S_MS, "MS:1001774", "MALDI Synapt G2-S MS", "Waters oa-ToF based MALDI Synapt G2-S MS.", false},
    {MS_MALDI_Synapt_HDMS, "MS:1001775", "MALDI Synapt HDMS", "Waters oa-ToF based MALDI Synapt HDMS.", false},
    {MS_MALDI_Synapt_MS, "MS:1001776", "MALDI Synapt MS", "Waters oa-ToF based MALDI Synapt MS.", false},
    {MS_Synapt_G2_HDMS, "MS:1001777", "Synapt G2 HDMS", "Waters oa-ToF based Synapt G2 HDMS.", false},
    {MS_Synapt_G2_MS, "MS:1001778", "Synapt G2 MS", "Waters oa-ToF based Synapt G2 MS.", false},
    {MS_Synapt_G2_S_HDMS, "MS:1001779", "Synapt G2-S HDMS", "Waters oa-ToF based Synapt G2-S HDMS.", false},
    {MS_Synapt_G2_S_MS, "MS:1001780", "Synapt G2-S MS", "Waters oa-ToF based Synapt G2-S MS.", false},
    {MS_Synapt_HDMS, "MS:1001781", "Synapt HDMS", "Waters oa-ToF based Synapt HDMS.", false},
    {MS_Synapt_MS, "MS:1001782", "Synapt MS", "Waters oa-ToF based Synapt MS.", false},
    {MS_Xevo_G2_Q_Tof, "MS:1001783", "Xevo G2 Q-Tof", "Waters oa-ToF based Xevo G2 Q-Tof.", false},
    {MS_Xevo_G2_Tof, "MS:1001784", "Xevo G2 Tof", "Waters oa-ToF based Xevo G2 Tof.", false},
    {MS_Xevo_Q_Tof, "MS:1001785", "Xevo Q-Tof", "Waters oa-ToF based Xevo Q-Tof.", false},
    {MS_3100, "MS:1001786", "3100", "Waters quadrupole based 3100.", false},
    {MS_Acquity_SQD, "MS:1001787", "Acquity SQD", "Waters quadrupole based Acquity SQD.", false},
    {MS_Acquity_TQD, "MS:1001788", "Acquity TQD", "Waters quadrupole based Acquity TQD.", false},
    {MS_Quattro_micro_GC, "MS:1001789", "Quattro micro GC", "Waters (triple) quadrupole based Quattro micro GC.", false},
    {MS_Xevo_TQ_MS, "MS:1001790", "Xevo TQ MS", "Waters quadrupole based Xevo TQ MS.", false},
    {MS_Xevo_TQD, "MS:1001791", "Xevo TQD", "Waters quadrupole based Xevo TQD.", false},
    {MS_Xevo_TQ_S, "MS:1001792", "Xevo TQ-S", "Waters quadrupole based Xevo TQ-S.", false},
    {MS_Mascot_PreferredTaxonomy, "MS:1001793", "Mascot:PreferredTaxonomy", "NCBI TaxID taxonomy ID to prefer when two or more proteins match the same set of peptides or when protein entry in database represents multiple sequences.", false},
    {MS_Empower, "MS:1001795", "Empower", "Waters Empower software for liquid chromatography and mass spectrometry acquisition.", false},
    {MS_UNIFY, "MS:1001796", "UNIFY", "Waters UNIFY software for liquid chromatography and mass spectrometry acquisition.", false},
    {MS_travelling_wave_ion_mobility_mass_spectrometer_OBSOLETE, "MS:1001797", "travelling wave ion mobility mass spectrometer", "An ion mobility mass spectrometry technique based on the superimposition of travelling voltage waves on a radially-confining RF voltage in a gas-filled, stacked-ring ion guide.", true},
    {MS_LECO_software, "MS:1001798", "LECO software", "LECO software for data acquisition and analysis.", false},
    {MS_ChromaTOF_software, "MS:1001799", "ChromaTOF software", "Software for acquisition, processing and analysis of data for LECO instruments.", false},
    {MS_LECO_instrument_model, "MS:1001800", "LECO instrument model", "LECO instrument model.", false},
    {MS_Pegasus_HRT, "MS:1001801", "Pegasus HRT", "LECO high resolution time-of-flight GC mass spectrometer.", false},
    {MS_Citius_HRT, "MS:1001802", "Citius HRT", "LECO high resolution time-of-flight LC mass spectrometer.", false},
    {MS_Pegasus, "MS:1001803", "Pegasus", "LECO GC time-of-flight mass spectrometer.", false},
    {MS_TruTOF, "MS:1001804", "TruTOF", "LECO bench-top GC time-of-flight mass spectrometer.", false},
    {MS_quantification_datatype, "MS:1001805", "quantification datatype", "The data type of the value reported in a QuantLayer.", false},
    {MS_quantification_object_attribute, "MS:1001806", "quantification object attribute", "Attributes describing the details of an object relevant for reporting quantification workflows or values.", false},
    {MS_study_variable_attribute, "MS:1001807", "study variable attribute", "Attribute describing a study variable.", false},
    {MS_technical_replicate, "MS:1001808", "technical replicate", "The study variable is 'technical replicate'. The string value denotes the category of technical replicate, e.g. 'run generated from same sample'.", false},
    {MS_biological_replicate, "MS:1001809", "biological replicate", "The study variable is 'biological replicate'. This means, the run was generated from another individual or sample.", false},
    {MS_experimental_condition__case_, "MS:1001810", "experimental condition 'case'", "The experimental condition is 'case' in contrast to 'control'.", false},
    {MS_experimental_condition__control_, "MS:1001811", "experimental condition 'control'", "The experimental condition is 'control' in contrast to 'case'.", false},
    {MS_experimental_condition__disease_, "MS:1001812", "experimental condition 'disease'", "The experimental condition is 'disease' in contrast to 'healthy'.", false},
    {MS_experimental_condition__healthy_, "MS:1001813", "experimental condition 'healthy'", "The experimental condition is 'healthy' in contrast to 'disease'.", false},
    {MS_generic_experimental_condition, "MS:1001814", "generic experimental condition", "The experimental condition is given in the value of this term.", false},
    {MS_time_series__time_point_X, "MS:1001815", "time series, time point X", "The experimental design followed a time series design. The time point of this run is given in the value of this term.", false},
    {MS_dilution_series__concentration_X, "MS:1001816", "dilution series, concentration X", "The experimental design followed a dilution series design. The concentration of this run is given in the value of this term.", false},
    {MS_raw_file_attribute, "MS:1001817", "raw file attribute", "Attribute describing a raw file.", false},
    {MS_one_sample_run, "MS:1001818", "one sample run", "The raw file contains the run of one sample (e.g. spectral counting, LC-MS label-free).", false},
    {MS_two_sample_run, "MS:1001819", "two sample run", "The raw file contains the run of two samples (e.g. SILAC, metabolic labelling).", false},
    {MS_three_sample_run, "MS:1001820", "three sample run", "The raw file contains the run of three samples (e.g. 3-plex SILAC).", false},
    {MS_four_sample_run, "MS:1001821", "four sample run", "The raw file contains the run of four samples (e.g. 4-plex iTraq).", false},
    {MS_eight_sample_run, "MS:1001822", "eight sample run", "The raw file contains the run of eight samples (e.g. 8-plex iTraq).", false},
    {MS_raw_files_group_attribute, "MS:1001823", "raw files group attribute", "Attribute describing, how raw files build a raw file group.", false},
    {MS_merge_of_runs_of_1D_gel_bands, "MS:1001824", "merge of runs of 1D gel bands", "Attribute describing, how raw files build a raw file group.", false},
    {MS_feature_list_attribute, "MS:1001825", "feature list attribute", "Attribute describing a feature list.", false},
    {MS_mass_trace_reporting__rectangles, "MS:1001826", "mass trace reporting: rectangles", "The mass trace of the features of this feature list specifies rectangles. Each mass trace has the syntax (RT_start,MZ_start,RT_end,MZ_end), i.e. opposite corners are given.", false},
    {MS_mass_trace_reporting__polygons, "MS:1001827", "mass trace reporting: polygons", "The mass trace of the features of this feature list specifies polygons. Each mass trace has the syntax (RT_1, MZ_1, RT_2, MZ_2, ... , RT_i, MZ_i, ... , RT_n, MZ_n), where the line (RT_n, MZ_n)->(RT_1, MZ_1) is implicit.", false},
    {MS_feature_attribute, "MS:1001828", "feature attribute", "Attribute describing a feature.", false},
    {MS_SRM_transition_ID, "MS:1001829", "SRM transition ID", "Identifier for an SRM transition in an external document describing additional information about the transition.", false},
    {MS_Progenesis_LC_MS, "MS:1001830", "Progenesis LC-MS", "Software from Nonlinear Dynamics for LC-MS label-free workflow.", false},
    {MS_SILACAnalyzer, "MS:1001831", "SILACAnalyzer", "Software for SILAC workflow.", false},
    {MS_quantitation_software_comment_or_customizations, "MS:1001832", "quantitation software comment or customizations", "Quantitation software comment or any customizations to the default setup of the software.", false},
    {MS_quantitation_analysis_summary, "MS:1001833", "quantitation analysis summary", "The overall workflow of this quantitation report.", false},
    {MS_LC_MS_label_free_quantitation_analysis, "MS:1001834", "LC-MS label-free quantitation analysis", "LC-MS label-free workflow (RT m/z map).", false},
    {MS_SILAC_quantitation_analysis, "MS:1001835", "SILAC quantitation analysis", "SILAC workflow (heavy, light, and sometimes medium peak).", false},
    {MS_spectral_counting_quantitation_analysis, "MS:1001836", "spectral counting quantitation analysis", "Spectral counting workflow (number of identified MS2 spectra as approximation of peptide / protein quant).", false},
    {MS_iTRAQ_quantitation_analysis, "MS:1001837", "iTRAQ quantitation analysis", "Quantification analysis using the SCIEX amine-reactive isobaric tags for relative and absolute quantification (iTRAQ) labelling workflow, wherein 2-8 reporter ions are measured in MS2 spectra near in the 114-121 m/z range.", false},
    {MS_SRM_quantitation_analysis, "MS:1001838", "SRM quantitation analysis", "Selected Reaction Monitoring workflow (XIC quantitation of precursor / fragment mass pair).", false},
    {MS_metabolic_labeling_14N___15N_quantitation_analysis, "MS:1001839", "metabolic labeling 14N / 15N quantitation analysis", "Metabolic labeling workflow (heavy and light versions of peptides, depending on number of nitrogens).", false},
    {MS_LC_MS_feature_intensity, "MS:1001840", "LC-MS feature intensity", "Maximum peak intensity of the LC-MS feature.", false},
    {MS_LC_MS_feature_volume, "MS:1001841", "LC-MS feature volume", "Real (intensity times area) volume of the LC-MS feature.", false},
    {MS_sequence_level_spectral_count, "MS:1001842", "sequence-level spectral count", "The number of MS2 spectra identified for a raw peptide sequence without PTMs and charge state in spectral counting.", false},
    {MS_MS1_feature_maximum_intensity, "MS:1001843", "MS1 feature maximum intensity", "Maximum intensity of MS1 feature.", false},
    {MS_MS1_feature_area, "MS:1001844", "MS1 feature area", "Area of MS1 feature.", false},
    {MS_peak_area_OBSOLETE, "MS:1001845", "peak area", "Area of MS1 peak (e.g. SILAC, 15N).", true},
    {MS_isotopic_pattern_area, "MS:1001846", "isotopic pattern area", "Area of all peaks belonging to the isotopic pattern of light or heavy peak (e.g. 15N).", false},
    {MS_reporter_ion_intensity, "MS:1001847", "reporter ion intensity", "Intensity of MS2 reporter ion (e.g. iTraq).", false},
    {MS_simple_ratio_of_two_values, "MS:1001848", "simple ratio of two values", "Simple ratio of two values (enumerator and denominator).", false},
    {MS_sum_of_MatchedFeature_values_OBSOLETE, "MS:1001849", "sum of MatchedFeature values", "Peptide quantification value calculated as sum of MatchedFeature quantification values.", true},
    {MS_normalized_peptide_value, "MS:1001850", "normalized peptide value", "Normalized peptide value.", false},
    {MS_protein_value__sum_of_peptide_values, "MS:1001851", "protein value: sum of peptide values", "Protein quantification value calculated as sum of peptide values.", false},
    {MS_normalized_protein_value, "MS:1001852", "normalized protein value", "Normalized protein value.", false},
    {MS_max_fold_change, "MS:1001853", "max fold change", "Global datatype: Maximum of all pair-wise fold changes of group means (e.g. Progenesis).", false},
    {MS_ANOVA_p_value, "MS:1001854", "ANOVA p-value", "Global datatype: p-value of ANOVA of group means (e.g. Progenesis).", false},
    {MS_t_test_p_value, "MS:1001855", "t-test p-value", "P-value of t-Test of two groups.", false},
    {MS_reporter_ion_raw_value, "MS:1001856", "reporter ion raw value", "Intensity (or area) of MS2 reporter ion (e.g. iTraq).", false},
    {MS_reporter_ion_normalized_value, "MS:1001857", "reporter ion normalized value", "Normalized value of MS2 reporter ion (e.g. iTraq).", false},
    {MS_XIC_area, "MS:1001858", "XIC area", "Area of the extracted ion chromatogram (e.g. of a transition in SRM).", false},
    {MS_normalized_XIC_area, "MS:1001859", "normalized XIC area", "Normalized area of the extracted ion chromatogram (e.g. of a transition in SRM).", false},
    {MS_protein_value__mean_of_peptide_ratios, "MS:1001860", "protein value: mean of peptide ratios", "Protein quantification value calculated as mean of peptide ratios.", false},
    {MS_quantification_data_processing, "MS:1001861", "quantification data processing", "Terms used to describe types of quantification data processing.", false},
    {MS_normalization_to_mean_of_sum_of_all_proteins, "MS:1001862", "normalization to mean of sum of all proteins", "Normalization of protein values to the mean of the sum of all protein PSM counts (e.g. spectral counting).", false},
    {MS_quantile_normalization__proteins, "MS:1001863", "quantile normalization, proteins", "Normalization of protein values to approach the same distribution.", false},
    {MS_quantile_normalization__peptides, "MS:1001864", "quantile normalization, peptides", "Normalization of peptide values to approach the same distribution.", false},
    {MS_Progenesis_automatic_alignment, "MS:1001865", "Progenesis automatic alignment", "Automatic RT alignment of Progenesis software.", false},
    {MS_Progenesis_manual_alignment, "MS:1001866", "Progenesis manual alignment", "RT alignment of Progenesis software using automatic and manual vectors.", false},
    {MS_Progenesis_normalization, "MS:1001867", "Progenesis normalization", "Normalization as performed by Progenesis LC-MS.", false},
    {MS_distinct_peptide_level_q_value, "MS:1001868", "distinct peptide-level q-value", "Estimation of the q-value for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs, possibly with different mass modifications, mapping to the same sequence have been collapsed to one entry).", false},
    {MS_protein_level_q_value, "MS:1001869", "protein-level q-value", "Estimation of the q-value for proteins.", false},
    {MS_peptide_sequence_level_p_value, "MS:1001870", "peptide sequence-level p-value", "Estimation of the p-value for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_protein_level_p_value, "MS:1001871", "protein-level p-value", "Estimation of the p-value for proteins.", false},
    {MS_peptide_sequence_level_e_value, "MS:1001872", "peptide sequence-level e-value", "Estimation of the e-value for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_protein_level_e_value, "MS:1001873", "protein-level e-value", "Estimation of the e-value for proteins.", false},
    {MS_FDRScore_OBSOLETE, "MS:1001874", "FDRScore", "A smoothing of the distribution of q-values calculated for PSMs from individual search engines, such that ordering of result quality is maintained and all FDRScore values are guaranteed to have a value > 0.", true},
    {MS_modification_motif, "MS:1001875", "modification motif", "The regular expression describing the sequence motif for a modification.", false},
    {MS_modification_probability, "MS:1001876", "modification probability", "The a priori probability of a modification.", false},
    {MS_ChromaTOF_HRT_software, "MS:1001877", "ChromaTOF HRT software", "Software for acquisition, processing and analysis of data for LECO instruments.", false},
    {MS_MALDI_Solutions_Microbial_Identification, "MS:1001878", "MALDI Solutions Microbial Identification", "Shimadzu Biotech software for data acquisition, processing, and analysis.", false},
    {MS_offset_voltage, "MS:1001879", "offset voltage", "The potential difference between two adjacent interface voltages affecting in-source collision induced dissociation.", false},
    {MS_in_source_collision_induced_dissociation, "MS:1001880", "in-source collision-induced dissociation", "The dissociation of an ion as a result of collisional excitation during ion transfer from an atmospheric pressure ion source and the mass spectrometer vacuum.", false},
    {MS_mz5_format, "MS:1001881", "mz5 format", "mz5 file format, modelled after mzML.", false},
    {MS_transition_validation_attribute, "MS:1001882", "transition validation attribute", "Attributes of the quality of a transition that affect its selection as appropriate.", false},
    {MS_coefficient_of_variation, "MS:1001883", "coefficient of variation", "Variation of a set of signal measurements calculated as the standard deviation relative to the mean.", false},
    {MS_signal_to_noise_ratio, "MS:1001884", "signal-to-noise ratio", "Unitless number providing the ratio of the total measured intensity of a signal relative to the estimated noise level for that signal.", false},
    {MS_command_line_parameters, "MS:1001885", "command-line parameters", "Parameters string passed to a command-line interface software application, omitting the executable name.", false},
    {MS_SQID, "MS:1001886", "SQID", "Software for data analysis of peptides and proteins.", false},
    {MS_SQID_score, "MS:1001887", "SQID:score", "The SQID result 'Score'.", false},
    {MS_SQID_deltaScore, "MS:1001888", "SQID:deltaScore", "The SQID result 'deltaScore'.", false},
    {MS_SQID_protein_score, "MS:1001889", "SQID:protein score", "The SQID result 'protein score'.", false},
    {MS_Progenesis_protein_normalised_abundance, "MS:1001890", "Progenesis:protein normalised abundance", "The data type normalised abundance for proteins produced by Progenesis LC-MS.", false},
    {MS_Progenesis_peptide_normalised_abundance, "MS:1001891", "Progenesis:peptide normalised abundance", "The data type normalised abundance for peptides produced by Progenesis LC-MS.", false},
    {MS_Progenesis_protein_raw_abundance, "MS:1001892", "Progenesis:protein raw abundance", "The data type raw abundance for proteins produced by Progenesis LC-MS.", false},
    {MS_Progenesis_peptide_raw_abundance, "MS:1001893", "Progenesis:peptide raw abundance", "The data type raw abundance for peptide produced by Progenesis LC-MS.", false},
    {MS_Progenesis_confidence_score, "MS:1001894", "Progenesis:confidence score", "The data type confidence score produced by Progenesis LC-MS.", false},
    {MS_Progenesis_peptide_count, "MS:1001895", "Progenesis:peptide count", "The data type peptide count produced by Progenesis LC-MS.", false},
    {MS_Progenesis_feature_intensity, "MS:1001896", "Progenesis:feature intensity", "The data type feature intensity produced by Progenesis LC-MS.", false},
    {MS_MaxQuant_peptide_counts__unique_, "MS:1001897", "MaxQuant:peptide counts (unique)", "The data type peptide counts (unique) produced by MaxQuant.", false},
    {MS_MaxQuant_peptide_counts__all_, "MS:1001898", "MaxQuant:peptide counts (all)", "The data type peptide counts (all) produced by MaxQuant.", false},
    {MS_MaxQuant_peptide_counts__razor_unique_, "MS:1001899", "MaxQuant:peptide counts (razor+unique)", "The data type peptide counts (razor+unique) produced by MaxQuant.", false},
    {MS_MaxQuant_sequence_length, "MS:1001900", "MaxQuant:sequence length", "The data type sequence length produced by MaxQuant.", false},
    {MS_MaxQuant_PEP, "MS:1001901", "MaxQuant:PEP", "The data type PEP (posterior error probability) produced by MaxQuant.", false},
    {MS_MaxQuant_LFQ_intensity, "MS:1001902", "MaxQuant:LFQ intensity", "The data type LFQ intensity produced by MaxQuant.", false},
    {MS_MaxQuant_feature_intensity, "MS:1001903", "MaxQuant:feature intensity", "The data type feature intensity produced by MaxQuant.", false},
    {MS_MaxQuant_MS_MS_count, "MS:1001904", "MaxQuant:MS/MS count", "The data type MS2 count produced by MaxQuant.", false},
    {MS_emPAI_value, "MS:1001905", "emPAI value", "The emPAI value of protein abundance, produced from the emPAI algorithm.", false},
    {MS_APEX_value, "MS:1001906", "APEX value", "The APEX value of protein abundance, produced from the APEX software.", false},
    {MS_retention_time_window_width, "MS:1001907", "retention time window width", "The full width of a retention time window for a chromatographic peak.", false},
    {MS_ISQ, "MS:1001908", "ISQ", "Thermo Scientific ISQ single quadrupole MS with the ExtractraBrite source.", false},
    {MS_Velos_Plus, "MS:1001909", "Velos Plus", "Thermo Scientific second generation Velos.", false},
    {MS_LTQ_Orbitrap_Elite, "MS:1001910", "LTQ Orbitrap Elite", "Thermo Scientific LTQ Orbitrap Elite, often just referred to as the Orbitrap Elite.", false},
    {MS_Q_Exactive, "MS:1001911", "Q Exactive", "Thermo Scientific Q Exactive.", false},
    {MS_PinPoint, "MS:1001912", "PinPoint", "Thermo Scientific PinPoint SRM analysis software.", false},
    {MS_S_lens_voltage, "MS:1001913", "S-lens voltage", "Potential difference setting of the Thermo Scientific S-lens stacked-ring ion guide in volts.", false},
    {MS_pymzML, "MS:1001914", "pymzML", "Python module to interface mzML Data.", false},
    {MS_leukocyte_elastase, "MS:1001915", "leukocyte elastase", "Enzyme leukocyte elastase (EC 3.4.21.37).", false},
    {MS_proline_endopeptidase, "MS:1001916", "proline endopeptidase", "Enzyme proline endopeptidase (EC 3.4.21.26).", false},
    {MS_glutamyl_endopeptidase, "MS:1001917", "glutamyl endopeptidase", "Enzyme glutamyl endopeptidase (EC 3.4.21.19).", false},
    {MS_2_iodobenzoate, "MS:1001918", "2-iodobenzoate", "Chemical iodobenzoate. Cleaves after W.", false},
    {MS_ProteomeXchange_accession_number, "MS:1001919", "ProteomeXchange accession number", "Main identifier of a ProteomeXchange dataset.", false},
    {MS_ProteomeXchange_accession_number_version_number, "MS:1001921", "ProteomeXchange accession number version number", "Version number of a ProteomeXchange accession number.", false},
    {MS_Digital_Object_Identifier__DOI_, "MS:1001922", "Digital Object Identifier (DOI)", "DOI unique identifier of a publication.", false},
    {MS_external_reference_keyword, "MS:1001923", "external reference keyword", "Free text attribute that can enrich the information about an entity.", false},
    {MS_journal_article_keyword, "MS:1001924", "journal article keyword", "Keyword present in a scientific publication.", false},
    {MS_submitter_keyword, "MS:1001925", "submitter keyword", "Keyword assigned by the data submitter.", false},
    {MS_curator_keyword, "MS:1001926", "curator keyword", "Keyword assigned by a data curator.", false},
    {MS_Tranche_file_hash, "MS:1001927", "Tranche file hash", "Hash assigned by the Tranche resource to an individual file.", false},
    {MS_Tranche_project_hash, "MS:1001928", "Tranche project hash", "Hash assigned by the Tranche resource to a whole project.", false},
    {MS_PRIDE_experiment_URI, "MS:1001929", "PRIDE experiment URI", "URI that allows the access to one experiment in the PRIDE database.", false},
    {MS_PRIDE_project_URI, "MS:1001930", "PRIDE project URI", "URI that allows the access to one project in the PRIDE database.", false},
    {MS_source_interface, "MS:1001931", "source interface", "The source interface.", false},
    {MS_source_interface_model, "MS:1001932", "source interface model", "The source interface model.", false},
    {MS_source_sprayer, "MS:1001933", "source sprayer", "The source sprayer.", false},
    {MS_source_sprayer_type, "MS:1001934", "source sprayer type", "The source sprayer type.", false},
    {MS_source_sprayer_manufacturer, "MS:1001935", "source sprayer manufacturer", "The source sprayer manufacturer.", false},
    {MS_source_sprayer_model, "MS:1001936", "source sprayer model", "The source sprayer model.", false},
    {MS_sample_plate, "MS:1001937", "sample plate", "Plate where the sample solution is spotted in a MALDI or similar instrument.", false},
    {MS_sample_plate_type, "MS:1001938", "sample plate type", "The sample plate type.", false},
    {MS_stainless_steel_plate, "MS:1001939", "stainless steel plate", "Stainless steel plate.", false},
    {MS_coated_glass_plate, "MS:1001940", "coated glass plate", "Coated glass plate.", false},
    {MS_electrospray_supply_type, "MS:1001941", "electrospray supply type", "Whether the sprayer is fed or is loaded with sample once.", false},
    {MS_static_supply_electrospray, "MS:1001942", "static supply electrospray", "The sprayer is loaded with sample once.", false},
    {MS_fed_supply_electrospray, "MS:1001943", "fed supply electrospray", "The sprayer is continuously fed with sample.", false},
    {MS_Collision_cell_exit_potential, "MS:1001944", "Collision cell exit potential", "Potential difference between Q2 and Q3 in a triple quadrupole instrument in volts.", false},
    {MS_Pegasus_4D, "MS:1001945", "Pegasus 4D", "LECO nominal mass resolution time-of-flight GCxGC mass spectrometer.", false},
    {MS_PEAKS_Studio, "MS:1001946", "PEAKS Studio", "PEAKS Studio software for data analysis.", false},
    {MS_PEAKS_Online, "MS:1001947", "PEAKS Online", "PEAKS Online software for high throughput data analysis.", false},
    {MS_PEAKS_Node, "MS:1001948", "PEAKS Node", "PEAKS Node software for high throughput data analysis.", false},
    {MS_BSI_software, "MS:1001949", "BSI software", "Bioinformatics Solutions Inc. Software for data processing and analysis.", false},
    {MS_PEAKS_peptideScore, "MS:1001950", "PEAKS:peptideScore", "The PEAKS peptide '-10lgP Score'.", false},
    {MS_PEAKS_proteinScore, "MS:1001951", "PEAKS:proteinScore", "The PEAKS protein '-10lgP Score'.", false},
    {MS_ZCore_probScore, "MS:1001952", "ZCore:probScore", "The ZCore probability score.", false},
    {MS_source_interface_manufacturer, "MS:1001953", "source interface manufacturer", "The source interface manufacturer.", false},
    {MS_acquisition_parameter, "MS:1001954", "acquisition parameter", "Parameters used in the mass spectrometry acquisition.", false},
    {MS_no_cleavage, "MS:1001955", "no cleavage", "No cleavage.", false},
    {MS_unspecific_cleavage, "MS:1001956", "unspecific cleavage", "Unspecific cleavage.", false},
    {MS______ALIV_____P_, "MS:1001957", "(?<=[ALIV])(?!P)", "Regular expression for leukocyte elastase.", false},
    {MS______HKR_P____P_, "MS:1001958", "(?<=[HKR]P)(?!P)", "Regular expression for proline endopeptidase.", false},
    {MS_______E_E_, "MS:1001959", "(?<=[^E]E)", "Regular expression for glutamyl endopeptidase.", false},
    {MS_____W_, "MS:1001960", "(?<=W)", "Regular expression for 2-iodobenzoate.", false},
    {MS_peptide_spectrum_match_scoring_algorithm, "MS:1001961", "peptide spectrum match scoring algorithm", "Algorithm used to score the match between a spectrum and a peptide ion.", false},
    {MS_Mascot_C13_counts, "MS:1001962", "Mascot:C13 counts", "C13 peaks to use in peak detection.", false},
    {MS_ProteinExtractor_Weighting, "MS:1001963", "ProteinExtractor:Weighting", "Weighting factor for protein list compilation by ProteinExtractor.", false},
    {MS_ProteinScape_second_round_Mascot, "MS:1001964", "ProteinScape:second round Mascot", "Flag indicating a second round search with Mascot.", false},
    {MS_ProteinScape_second_round_Phenyx, "MS:1001965", "ProteinScape:second round Phenyx", "Flag indicating a second round search with Phenyx.", false},
    {MS_product_ion_mobility, "MS:1001966", "product ion mobility", "The mobility of an MS2 product ion, as measured by ion mobility mass spectrometry.", false},
    {MS_product_ion_drift_time_OBSOLETE, "MS:1001967", "product ion drift time", "The ion drift time of an MS2 product ion.", true},
    {MS_PTM_localization_PSM_level_statistic, "MS:1001968", "PTM localization PSM-level statistic", "Statistic to convey the confidence of the localization of an amino acid modification on a peptide sequence at the PSM-level.", false},
    {MS_phosphoRS_score, "MS:1001969", "phosphoRS score", "phosphoRS score for PTM site location at the PSM-level.", false},
    {MS_phosphoRS_sequence_probability, "MS:1001970", "phosphoRS sequence probability", "Probability that the respective isoform is correct.", false},
    {MS_phosphoRS_site_probability, "MS:1001971", "phosphoRS site probability", "Estimate of the probability that the respective site is truly phosphorylated.", false},
    {MS_PTM_scoring_algorithm_version, "MS:1001972", "PTM scoring algorithm version", "Version of the post-translational modification scoring algorithm.", false},
    {MS_DeBunker, "MS:1001973", "DeBunker", "DeBunker software.", false},
    {MS_DeBunker_score, "MS:1001974", "DeBunker:score", "Score specific to DeBunker.", false},
    {MS_delta_m_z, "MS:1001975", "delta m/z", "The difference between a theoretically calculated m/z and the corresponding experimentally measured m/z. It can be expressed as absolute or relative value.", false},
    {MS_delta_M, "MS:1001976", "delta M", "The difference between a theoretically calculated molecular mass M and the corresponding experimentally measured M. It can be expressed as absolute or relative value.", false},
    {MS_MSQuant, "MS:1001977", "MSQuant", "MSQuant software.", false},
    {MS_MSQuant_PTM_score, "MS:1001978", "MSQuant:PTM-score", "The PTM score from MSQuant software.", false},
    {MS_MaxQuant_PTM_Score, "MS:1001979", "MaxQuant:PTM Score", "The PTM score from MaxQuant software.", false},
    {MS_MaxQuant_Phospho__STY__Probabilities, "MS:1001980", "MaxQuant:Phospho (STY) Probabilities", "The Phospho (STY) Probabilities from MaxQuant software.", false},
    {MS_MaxQuant_Phospho__STY__Score_Diffs, "MS:1001981", "MaxQuant:Phospho (STY) Score Diffs", "The Phospho (STY) Score Diffs from MaxQuant software.", false},
    {MS_MaxQuant_P_site_localization_probability, "MS:1001982", "MaxQuant:P-site localization probability", "The P-site localization probability value from MaxQuant software.", false},
    {MS_MaxQuant_PTM_Delta_Score, "MS:1001983", "MaxQuant:PTM Delta Score", "The PTM Delta Score value from MaxQuant software (Difference between highest scoring site and second highest).", false},
    {MS_Ascore_software, "MS:1001984", "Ascore software", "Ascore software.", false},
    {MS_Ascore, "MS:1001985", "Ascore", "A-score for PTM site location at the PSM-level.", false},
    {MS_H_Score, "MS:1001986", "H-Score", "H-Score for peptide phosphorylation site location.", false},
    {MS_vacuum_drying_MALDI_sample_preparation, "MS:1001987", "vacuum drying MALDI sample preparation", "Vacuum-drying MALDI sample preparation crystallization method.", false},
    {MS_crushed_crystal_MALDI_sample_preparation, "MS:1001988", "crushed crystal MALDI sample preparation", "Crushed-crystal MALDI sample preparation method.", false},
    {MS_fast_evaporation_MALDI_sample_preparation, "MS:1001989", "fast evaporation MALDI sample preparation", "Fast-evaporation MALDI sample preparation method.", false},
    {MS_overlayer_MALDI_sample_preparation, "MS:1001990", "overlayer MALDI sample preparation", "Overlayer method combining features of the crushed-crystal method and the fast-evaporation method.", false},
    {MS_sandwich_MALDI_sample_preparation, "MS:1001991", "sandwich MALDI sample preparation", "Sandwich MALDI sample preparation method.", false},
    {MS_spin_coating_MALDI_sample_preparation, "MS:1001992", "spin coating MALDI sample preparation", "Spin coating MALDI sample preparation method.", false},
    {MS_quick_and_dirty_MALDI_sample_preparation, "MS:1001993", "quick and dirty MALDI sample preparation", "Quick & dirty (Q&D) sample preparation separating matrix handling from sample handling.", false},
    {MS_top_hat_baseline_reduction, "MS:1001994", "top hat baseline reduction", "Top-hat morphological filter based on the basic morphological operations 'erosion' and 'dilatation'.", false},
    {MS_convex_hull_baseline_reduction, "MS:1001995", "convex hull baseline reduction", "Constructs the baseline by fitting multiple parabolas to the spectrum starting with the large scale structures.", false},
    {MS_median_baseline_reduction, "MS:1001996", "median baseline reduction", "The spectrum that will be baseline subtracted is divided into a number of segments.", false},
    {MS_wavelet_transformation_smoothing, "MS:1001997", "wavelet transformation smoothing", "The random noise is removed by using the undecimated wavelet transform.", false},
    {MS_sophisticated_numerical_annotation_procedure, "MS:1001998", "sophisticated numerical annotation procedure", "It searches for known patterns in the measured spectrum.", false},
    {MS_area_normalization, "MS:1001999", "area normalization", "Normalization of areas below the curves.", false},
    {MS_LIFT, "MS:1002000", "LIFT", "A Bruker's proprietary technique where molecular ions are initially accelerated at lower energy, then collide with inert gas in a collision cell that is then 'lifted' to high potential. The use of inert gas is optional, as it could lift also fragments provided by LID.", false},
    {MS_MS1_label_based_raw_feature_quantitation, "MS:1002001", "MS1 label-based raw feature quantitation", "MS1 label-based raw feature quantitation.", false},
    {MS_MS1_label_based_peptide_level_quantitation, "MS:1002002", "MS1 label-based peptide level quantitation", "MS1 label-based peptide level quantitation.", false},
    {MS_MS1_label_based_protein_level_quantitation, "MS:1002003", "MS1 label-based protein level quantitation", "MS1 label-based protein level quantitation.", false},
    {MS_MS1_label_based_proteingroup_level_quantitation, "MS:1002004", "MS1 label-based proteingroup level quantitation", "MS1 label-based proteingroup level quantitation.", false},
    {MS_iRT_retention_time_normalization_standard, "MS:1002005", "iRT retention time normalization standard", "A de facto standard providing the retention times at which a specific set of 10 reference peptides exit the reference chromatographic column. The kit may be obtain from Biognosys.", false},
    {MS_SRM_transition_type, "MS:1002006", "SRM transition type", "The type of the transitions, e.g. target or decoy.", false},
    {MS_target_SRM_transition, "MS:1002007", "target SRM transition", "A transition used to target a specific compound that may be in the sample.", false},
    {MS_decoy_SRM_transition, "MS:1002008", "decoy SRM transition", "A transition not expected to be present in the sample and used to calculate statistical confidence of target transition detections in some workflows.", false},
    {MS_isobaric_label_quantitation_analysis, "MS:1002009", "isobaric label quantitation analysis", "Quantitation analysis using an isobaric labelling workflow.", false},
    {MS_TMT_quantitation_analysis, "MS:1002010", "TMT quantitation analysis", "Quantitation analysis using the Thermo Fisher amine-reactive tandem mass tag (TMT) labelling workflow, wherein 2-10 reporter ions are measured in MS2 spectra in the 126-131 m/z.", false},
    {MS_desorption_electrospray_ionization, "MS:1002011", "desorption electrospray ionization", "Combination of electrospray and desorption ionization method that ionizes gases, liquids and solids in open air under atmospheric pressure.", false},
    {MS_Mascot_PTM_site_assignment_confidence, "MS:1002012", "Mascot:PTM site assignment confidence", "Relative probability that PTM site assignment is correct, derived from the Mascot score difference between matches to the same spectrum (Mascot Delta Score).", false},
    {MS_collision_energy_ramp_start, "MS:1002013", "collision energy ramp start", "Collision energy at the start of the collision energy ramp.", false},
    {MS_collision_energy_ramp_end, "MS:1002014", "collision energy ramp end", "Collision energy at the end of the collision energy ramp.", false},
    {MS_spectral_count_peptide_level_quantitation, "MS:1002015", "spectral count peptide level quantitation", "Spectral count peptide level quantitation.", false},
    {MS_spectral_count_protein_level_quantitation, "MS:1002016", "spectral count protein level quantitation", "Spectral count protein level quantitation.", false},
    {MS_spectral_count_proteingroup_level_quantitation, "MS:1002017", "spectral count proteingroup level quantitation", "Spectral count proteingroup level quantitation.", false},
    {MS_MS1_label_based_analysis, "MS:1002018", "MS1 label-based analysis", "MS1 label-based analysis.", false},
    {MS_label_free_raw_feature_quantitation, "MS:1002019", "label-free raw feature quantitation", "Label-free raw feature quantitation.", false},
    {MS_label_free_peptide_level_quantitation, "MS:1002020", "label-free peptide level quantitation", "Label-free peptide level quantitation.", false},
    {MS_label_free_protein_level_quantitation, "MS:1002021", "label-free protein level quantitation", "Label-free protein level quantitation.", false},
    {MS_label_free_proteingroup_level_quantitation, "MS:1002022", "label-free proteingroup level quantitation", "Label-free proteingroup level quantitation.", false},
    {MS_MS2_tag_based_analysis, "MS:1002023", "MS2 tag-based analysis", "MS2 tag-based analysis.", false},
    {MS_MS2_tag_based_feature_level_quantitation, "MS:1002024", "MS2 tag-based feature level quantitation", "MS2 tag-based feature level quantitation.", false},
    {MS_MS2_tag_based_peptide_level_quantitation, "MS:1002025", "MS2 tag-based peptide level quantitation", "MS2 tag-based peptide level quantitation.", false},
    {MS_MS2_tag_based_protein_level_quantitation, "MS:1002026", "MS2 tag-based protein level quantitation", "MS2 tag-based protein level quantitation.", false},
    {MS_MS2_tag_based_proteingroup_level_quantitation, "MS:1002027", "MS2 tag-based proteingroup level quantitation", "MS2 tag-based proteingroup level quantitation.", false},
    {MS_nucleic_acid_base_modification, "MS:1002028", "nucleic acid base modification", "Nucleic acid base modification (substitution, insertion or deletion).", false},
    {MS_original_nucleic_acid_sequence, "MS:1002029", "original nucleic acid sequence", "Specification of the original nucleic acid sequence, prior to a modification. The value slot should hold the DNA or RNA sequence.", false},
    {MS_modified_nucleic_acid_sequence, "MS:1002030", "modified nucleic acid sequence", "Specification of the modified nucleic acid sequence. The value slot should hold the DNA or RNA sequence.", false},
    {MS_PASSEL_transition_group_browser_URI, "MS:1002031", "PASSEL transition group browser URI", "URI to retrieve transition group data for a PASSEL (PeptideAtlas SRM Experiment Library) experiment.", false},
    {MS_PeptideAtlas_dataset_URI, "MS:1002032", "PeptideAtlas dataset URI", "URI that allows access to a PeptideAtlas dataset.", false},
    {MS_contact_role, "MS:1002033", "contact role", "Role of the contact person.", false},
    {MS_first_author, "MS:1002034", "first author", "The first of a set of authors associated with a publication or release. There may be more than one first author in cases where several authors share primary attribution.", false},
    {MS_senior_author, "MS:1002035", "senior author", "The last of a set of authors associated with a publication or release. There may be more than one senior author in cases where several authors share senior attribution.", false},
    {MS_co_author, "MS:1002036", "co-author", "One of a set of authors associated with a publication or release.", false},
    {MS_dataset_submitter, "MS:1002037", "dataset submitter", "A person who submits a dataset to a repository.", false},
    {MS_label_free_sample, "MS:1002038", "label free sample", "A sample that has not been labelled or modified. This is often referred to as \\\"light\\\" to distinguish from \\\"heavy\\\".", false},
    {MS_inlet_attribute, "MS:1002039", "inlet attribute", "Inlet properties that are associated with a value.", false},
    {MS_inlet_temperature, "MS:1002040", "inlet temperature", "The temperature of the inlet of a mass spectrometer.", false},
    {MS_source_temperature, "MS:1002041", "source temperature", "The temperature of the source of a mass spectrometer.", false},
    {MS_modulation_time, "MS:1002042", "modulation time", "The duration of a complete cycle of modulation in a comprehensive two-dimensional separation system, equals the length of a second dimension chromatogram, i.e., the time between two successive injections into the second column.", false},
    {MS_ProteinProspector, "MS:1002043", "ProteinProspector", "ProteinProspector software for data acquisition and analysis.", false},
    {MS_ProteinProspector_score, "MS:1002044", "ProteinProspector:score", "The ProteinProspector result 'Score'.", false},
    {MS_ProteinProspector_expectation_value, "MS:1002045", "ProteinProspector:expectation value", "The ProteinProspector result 'Expectation value'.", false},
    {MS_native_source_path, "MS:1002046", "native source path", "The original source path used for directory-based sources.", false},
    {MS_MS_GF, "MS:1002047", "MS-GF", "MS-GF software used to re-score the peptide-spectrum matches.", false},
    {MS_MS_GF_, "MS:1002048", "MS-GF+", "MS-GF+ software used to analyze the spectra.", false},
    {MS_MS_GF_RawScore, "MS:1002049", "MS-GF:RawScore", "MS-GF raw score.", false},
    {MS_MS_GF_DeNovoScore, "MS:1002050", "MS-GF:DeNovoScore", "MS-GF de novo score.", false},
    {MS_MS_GF_Energy, "MS:1002051", "MS-GF:Energy", "MS-GF energy score.", false},
    {MS_MS_GF_SpecEValue, "MS:1002052", "MS-GF:SpecEValue", "MS-GF spectral E-value.", false},
    {MS_MS_GF_EValue, "MS:1002053", "MS-GF:EValue", "MS-GF E-value.", false},
    {MS_MS_GF_QValue, "MS:1002054", "MS-GF:QValue", "MS-GF Q-value.", false},
    {MS_MS_GF_PepQValue, "MS:1002055", "MS-GF:PepQValue", "MS-GF peptide-level Q-value.", false},
    {MS_MS_GF_PEP, "MS:1002056", "MS-GF:PEP", "MS-GF posterior error probability.", false},
    {MS_modification_specificity_protein_N_term, "MS:1002057", "modification specificity protein N-term", "As parameter for search engine: apply the modification only at the N-terminus of a protein.", false},
    {MS_modification_specificity_protein_C_term, "MS:1002058", "modification specificity protein C-term", "As parameter for search engine: apply the modification only at the C-terminus of a protein.", false},
    {MS_Microsoft_Excel, "MS:1002059", "Microsoft Excel", "Microsoft Excel (can be used for spectral counting).", false},
    {MS_database_UniProtKB_TrEMBL, "MS:1002060", "database UniProtKB/TrEMBL", "The name of the UniProtKB/TrEMBL database.", false},
    {MS_decoy_DB_from_UniProtKB_TrEMBL_OBSOLETE, "MS:1002061", "decoy DB from UniProtKB/TrEMBL", "Decoy database from a TrEMBL protein sequence database.", true},
    {MS_metabolic_labelling__natural_N__mainly_14N_, "MS:1002062", "metabolic labelling: natural N (mainly 14N)", "Metabolic labelling: natural N (mainly 14N).", false},
    {MS_FindPairs, "MS:1002063", "FindPairs", "Software e.g. for SILAC and 14N/15N workflow, part of the PeakQuant suite.", false},
    {MS_peptide_consensus_RT, "MS:1002064", "peptide consensus RT", "Peptide consensus retention time.", false},
    {MS_peptide_consensus_m_z, "MS:1002065", "peptide consensus m/z", "Peptide consensus mass/charge ratio.", false},
    {MS_ratio_calculation_method, "MS:1002066", "ratio calculation method", "Method used to calculate the ratio.", false},
    {MS_protein_value__median_of_peptide_ratios, "MS:1002067", "protein value: median of peptide ratios", "Protein quantification value calculated as median of peptide ratios.", false},
    {MS_metabolic_labelling__heavy_N__mainly_15N_, "MS:1002068", "metabolic labelling: heavy N (mainly 15N)", "Metabolic labelling: heavy N (mainly 15N).", false},
    {MS_metabolic_labelling_purity, "MS:1002069", "metabolic labelling purity", "Metabolic labelling: Description of labelling purity. Usually the purity of feeding material (e.g. 95%), or the inclusion rate derived from isotopic peak pattern shape.", false},
    {MS_t_test, "MS:1002070", "t-test", "Perform a t-test (two groups). Specify in string value, whether paired / unpaired, variance equal / different, one- / two-sided version is performed.", false},
    {MS_ANOVA_test, "MS:1002071", "ANOVA-test", "Perform an ANOVA-test (more than two groups). Specify in string value, which version is performed.", false},
    {MS_p_value, "MS:1002072", "p-value", "P-value as result of one of the processing steps described. Specify in the description, which processing step it was.", false},
    {MS_mzIdentML_format, "MS:1002073", "mzIdentML format", "The mzIdentML format for peptide and protein identification data from the PSI. File extension '.mzid'.", false},
    {MS_quantification_file_format, "MS:1002074", "quantification file format", "File format containing quantification results.", false},
    {MS_mzQuantML_format, "MS:1002075", "mzQuantML format", "The mzQuantML format for quantification data from the PSI. File extension '.mzq'.", false},
    {MS_PAnalyzer, "MS:1002076", "PAnalyzer", "PAnalyzer software for getting protein evidence categories.", false},
    {MS_impact, "MS:1002077", "impact", "Bruker Daltonics' impact: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.", false},
    {MS_ProteomeDiscoverer_1__Static_Modification_OBSOLETE, "MS:1002078", "ProteomeDiscoverer:1. Static Modification", "ProteomeDiscoverer's 1st static post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_2__Static_Modification_OBSOLETE, "MS:1002079", "ProteomeDiscoverer:2. Static Modification", "ProteomeDiscoverer's 2nd static post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Clipping_Range_Before, "MS:1002080", "ProteomeDiscoverer:Spectrum Selector:Precursor Clipping Range Before", "Precursor clipping range before.", false},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Clipping_Range_After, "MS:1002081", "ProteomeDiscoverer:Spectrum Selector:Precursor Clipping Range After", "Precursor clipping range after.", false},
    {MS_first_column_elution_time, "MS:1002082", "first column elution time", "The time of elution from the first chromatographic column in the chromatographic separation step, relative to the start of chromatography on the first column.", false},
    {MS_second_column_elution_time, "MS:1002083", "second column elution time", "The time of elution from the second chromatographic column in the chromatographic separation step, relative to the start of the chromatography on the second column.", false},
    {MS_multidimensional_chromatography_modulation_description, "MS:1002084", "multidimensional chromatography modulation description", "Multidimensional chromatography modulation description.", false},
    {MS_two_dimensional_gas_chromatography_with_fixed_modulation_time, "MS:1002085", "two-dimensional gas chromatography with fixed modulation time", "Two-dimensional gas chromatography where a single modulation time is used throughout the acquisition.", false},
    {MS_two_dimensional_gas_chromatography_with_discrete_modulation_time_steps, "MS:1002086", "two-dimensional gas chromatography with discrete modulation time steps", "Two-dimensional gas chromatography where the acquisition is divided into steps, each with a different modulation time.", false},
    {MS_two_dimensional_liquid_chromatography_with_fixed_modulation_time, "MS:1002087", "two-dimensional liquid chromatography with fixed modulation time", "Two-dimensional liquid chromatography where a single modulation time is used throughout the acquisition.", false},
    {MS_two_dimensional_liquid_chromatography_with_discrete_modulation_time_steps, "MS:1002088", "two-dimensional liquid chromatography with discrete modulation time steps", "Two-dimensional liquid chromatography where the acquisition is divided into steps, each with a different modulation time.", false},
    {MS_ProteomeDiscoverer_Peptide_Without_Protein_XCorr_Threshold, "MS:1002089", "ProteomeDiscoverer:Peptide Without Protein XCorr Threshold", "XCorr threshold for storing peptides that do not belong to a protein.", false},
    {MS_Calculate_Probability_Scores, "MS:1002090", "Calculate Probability Scores", "Flag indicating that a probability score for the assessment that a reported peptide match is a random occurrence is calculated.", false},
    {MS_ProteomeDiscoverer_Maximum_Delta_Cn, "MS:1002091", "ProteomeDiscoverer:Maximum Delta Cn", "Delta Cn threshold for filtering out PSM's.", false},
    {MS_Percolator_Validation_based_on, "MS:1002092", "Percolator:Validation based on", "Algorithm (e.g. q-value or PEP) used for calculation of the validation score using Percolator.", false},
    {MS_search_engine_input_parameter, "MS:1002093", "search engine input parameter", "Search engine input parameter.", false},
    {MS_common_search_engine_input_parameter, "MS:1002094", "common search engine input parameter", "Search engine input parameter that is shared by more than one search engine.", false},
    {MS_Mascot_input_parameter, "MS:1002095", "Mascot input parameter", "Search engine input parameters specific to Mascot.", false},
    {MS_SEQUEST_input_parameter, "MS:1002096", "SEQUEST input parameter", "Search engine input parameters specific to SEQUEST.", false},
    {MS_Phenyx_input_parameter, "MS:1002097", "Phenyx input parameter", "Search engine input parameters specific to Phenyx.", false},
    {MS_ProteinExtractor_input_parameter, "MS:1002098", "ProteinExtractor input parameter", "Search engine input parameters specific to ProteinExtractor.", false},
    {MS_OMSSA_input_parameter, "MS:1002099", "OMSSA input parameter", "Search engine input parameters specific to OMSSA.", false},
    {MS_ProteinScape_input_parameter, "MS:1002100", "ProteinScape input parameter", "Search engine input parameters specific to ProteinScape.", false},
    {MS_ProteomeDiscoverer_input_parameter, "MS:1002101", "ProteomeDiscoverer input parameter", "Search engine input parameters specific to ProteomeDiscoverer.", false},
    {MS_software_input_parameter, "MS:1002103", "software input parameter", "Software input parameters.", false},
    {MS_common_software_input_parameter, "MS:1002104", "common software input parameter", "Software input parameter that is shared by more than one software.", false},
    {MS_software_specific_input_parameter, "MS:1002105", "software specific input parameter", "Software specific input parameter.", false},
    {MS_Scaffold_input_parameter, "MS:1002106", "Scaffold input parameter", "Search engine input parameters specific to Scaffold.", false},
    {MS_Percolator_input_parameter, "MS:1002107", "Percolator input parameter", "Search engine input parameters specific to Percolator.", false},
    {MS_higher_score_better, "MS:1002108", "higher score better", "Indicates that a higher score is better.", false},
    {MS_lower_score_better, "MS:1002109", "lower score better", "Indicates that a lower score is better.", false},
    {MS_assay_attribute, "MS:1002110", "assay attribute", "Attribute describing an assay.", false},
    {MS_assay_label_attribute, "MS:1002111", "assay label attribute", "Attribute describing an assay label.", false},
    {MS_protein_group_list_attribute, "MS:1002112", "protein group list attribute", "Attribute describing a protein group list.", false},
    {MS_protein_group_attribute, "MS:1002113", "protein group attribute", "Attribute describing a protein group.", false},
    {MS_protein_list_attribute, "MS:1002114", "protein list attribute", "Attribute describing a protein list.", false},
    {MS_peptide_consensus_list_attribute, "MS:1002115", "peptide consensus list attribute", "Attribute describing a peptide consensus list.", false},
    {MS_peptide_consensus_attribute, "MS:1002116", "peptide consensus attribute", "Attribute describing a peptide consensus.", false},
    {MS_small_molecule_list_attribute, "MS:1002117", "small molecule list attribute", "Attribute describing a small molecule list.", false},
    {MS_small_molecule_attribute, "MS:1002118", "small molecule attribute", "Attribute describing a small molecule.", false},
    {MS_small_molecule_modification_attribute, "MS:1002119", "small molecule modification attribute", "Attribute describing a small molecule modification.", false},
    {MS_experiment_name, "MS:1002120", "experiment name", "The name for identifying an experiment.", false},
    {MS_spectral_count_feature, "MS:1002121", "spectral count feature", "Dummy decribing a spectral count feature.", false},
    {MS_counts_reporting, "MS:1002122", "counts reporting", "FeatureList of spectral counts.", false},
    {MS_x_Tracker, "MS:1002123", "x-Tracker", "X-Tracker generic tool for quantitative proteomics.", false},
    {MS_ProteoSuite, "MS:1002124", "ProteoSuite", "ProteoSuite software for the analysis of quantitative proteomics data.", false},
    {MS_combined_FDRScore_OBSOLETE, "MS:1002125", "combined FDRScore", "FDRScore values specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.", true},
    {MS_database_UniProtKB, "MS:1002126", "database UniProtKB", "The name of the UniProtKB knowledgebase.", false},
    {MS_identification_file_attribute, "MS:1002127", "identification file attribute", "Attribute describing an identification file.", false},
    {MS_method_file_format, "MS:1002128", "method file format", "Attribute describing a method file format.", false},
    {MS_ITRAQAnalyzer, "MS:1002129", "ITRAQAnalyzer", "Software for iTRAQ workflow. Extracts and normalizes iTRAQ information from an MS experiment.", false},
    {MS_identification_file_format, "MS:1002130", "identification file format", "Attribute describing an identification file format.", false},
    {MS_TOPP_noise_filter, "MS:1002131", "TOPP noise filter", "Noise filter component of the TOPP software.", false},
    {MS_TOPP_NoiseFilterGaussian, "MS:1002132", "TOPP NoiseFilterGaussian", "Removes noise from profile spectra by using a gaussian smoothing.", false},
    {MS_TOPP_NoiseFilterSGolay, "MS:1002133", "TOPP NoiseFilterSGolay", "Removes noise from profile spectra by using a Savitzky-Golay smoothing.", false},
    {MS_TOPP_peak_picker, "MS:1002134", "TOPP peak picker", "Peak picker component of the TOPP software.", false},
    {MS_TOPP_PeakPickerHiRes, "MS:1002135", "TOPP PeakPickerHiRes", "Finds mass spectrometric peaks in high-resoluted profile mass spectra.", false},
    {MS_TOPP_PeakPickerWavelet, "MS:1002136", "TOPP PeakPickerWavelet", "Finds mass spectrometric peaks with a wavelet algorithm in low-resoluted profile mass spectra.", false},
    {MS_TOPP_spectra_filter, "MS:1002137", "TOPP spectra filter", "Spectra filter component of the TOPP software.", false},
    {MS_TOPP_SpectraFilterBernNorm, "MS:1002138", "TOPP SpectraFilterBernNorm", "Applies a Bern et al normalization to peak spectra.", false},
    {MS_TOPP_SpectraFilterMarkerMower, "MS:1002139", "TOPP SpectraFilterMarkerMower", "Applies a filter to peak spectra for marked peaks.", false},
    {MS_TOPP_SpectraFilterNLargest, "MS:1002140", "TOPP SpectraFilterNLargest", "Retains the n largest peaks of a peak spectra.", false},
    {MS_TOPP_SpectraFilterNormalizer, "MS:1002141", "TOPP SpectraFilterNormalizer", "Applies a TIC/maximal intensity normalization to peak spectra.", false},
    {MS_TOPP_SpectraFilterParentPeakMower, "MS:1002142", "TOPP SpectraFilterParentPeakMower", "Filters putative unfragmented precursor ions from tandem spectra.", false},
    {MS_TOPP_SpectraFilterScaler, "MS:1002143", "TOPP SpectraFilterScaler", "Applies a filter to peak spectra after intensity scaling according to rank.", false},
    {MS_TOPP_SpectraFilterSqrtMower, "MS:1002144", "TOPP SpectraFilterSqrtMower", "Applies a filter to peak spectra after intensity scaling to the square root.", false},
    {MS_TOPP_SpectraFilterThresholdMower, "MS:1002145", "TOPP SpectraFilterThresholdMower", "Applies a filter of peaks below a given threshold to peak spectra.", false},
    {MS_TOPP_SpectraFilterWindowMower, "MS:1002146", "TOPP SpectraFilterWindowMower", "Applies a filter of the largest peaks in a sliding window over a peak spectrum.", false},
    {MS_TOPP_map_aligner, "MS:1002147", "TOPP map aligner", "Map aligner component of the TOPP software.", false},
    {MS_TOPP_MapAlignerIdentification, "MS:1002148", "TOPP MapAlignerIdentification", "Corrects retention time distortions between maps based on common peptide identifications.", false},
    {MS_TOPP_MapAlignerPoseClustering, "MS:1002149", "TOPP MapAlignerPoseClustering", "Corrects retention time distortions between maps using a pose clustering approach.", false},
    {MS_TOPP_MapAlignerSpectrum, "MS:1002150", "TOPP MapAlignerSpectrum", "Corrects retention time distortions between maps by spectrum alignment.", false},
    {MS_numerator_data_type_attribute, "MS:1002151", "numerator data type attribute", "Attribute describing the data type of the numerator of a ratio.", false},
    {MS_denominator_data_type_attribute, "MS:1002152", "denominator data type attribute", "Attribute describing the data type of the denominator of a ratio.", false},
    {MS_protein_level_PSM_counts, "MS:1002153", "protein level PSM counts", "The number of spectra identified for this protein in spectral counting.", false},
    {MS_TOPP_DTAExtractor, "MS:1002154", "TOPP DTAExtractor", "Extracts spectra of an MS run file to several files in DTA format.", false},
    {MS_TOPP_IDMerger, "MS:1002155", "TOPP IDMerger", "Merges several protein/peptide identification files into one file.", false},
    {MS_TOPP_IDFileConverter, "MS:1002156", "TOPP IDFileConverter", "Converts identification engine file formats.", false},
    {MS_TOPP_SpectraMerger, "MS:1002157", "TOPP SpectraMerger", "Merges spectra from an LC/MS map, either by precursor or by RT blocks.", false},
    {MS_TOPP_MzTabExporter, "MS:1002158", "TOPP MzTabExporter", "Exports various XML formats to an mzTab file.", false},
    {MS_TOPP_MassTraceExtractor, "MS:1002159", "TOPP MassTraceExtractor", "Annotates mass traces in centroided LC/MS maps.", false},
    {MS_TOPP_PrecursorMassCorrector, "MS:1002160", "TOPP PrecursorMassCorrector", "Correct the precursor entries of tandem MS scans.", false},
    {MS_TOPP_HighResPrecursorMassCorrector, "MS:1002161", "TOPP HighResPrecursorMassCorrector", "Performs precursor mz correction on centroided high resolution data.", false},
    {MS_TOPP_AdditiveSeries, "MS:1002162", "TOPP AdditiveSeries", "Computes an additive series to quantify a peptide in a set of samples.", false},
    {MS_TOPP_Decharger, "MS:1002163", "TOPP Decharger", "Decharges and merges different feature charge variants of the same chemical entity.", false},
    {MS_TOPP_EICExtractor, "MS:1002164", "TOPP EICExtractor", "Quantifies signals at given positions in (raw or picked) LC/MS maps.", false},
    {MS_TOPP_feature_finder, "MS:1002165", "TOPP feature finder", "Feature finder component of the TOPP software.", false},
    {MS_TOPP_FeatureFinderCentroided, "MS:1002166", "TOPP FeatureFinderCentroided", "Detects two-dimensional features in centroided LC-MS data.", false},
    {MS_TOPP_FeatureFinderRaw, "MS:1002167", "TOPP FeatureFinderRaw", "Detects two-dimensional features in uncentroided LC-MS data.", false},
    {MS_TOPP_FeatureFinderIsotopeWavelet, "MS:1002168", "TOPP FeatureFinderIsotopeWavelet", "Detects two-dimensional features in uncentroided LC-MS data with a wavelet algorithm.", false},
    {MS_TOPP_FeatureFinderMetabo, "MS:1002169", "TOPP FeatureFinderMetabo", "Detects two-dimensional features in centroided LC-MS data of metabolites.", false},
    {MS_TOPP_FeatureFinderMRM, "MS:1002170", "TOPP FeatureFinderMRM", "Quantifies features LC-MS/MS MRM data.", false},
    {MS_TOPP_ProteinQuantifier, "MS:1002171", "TOPP ProteinQuantifier", "Computes protein abundances from annotated feature/consensus maps.", false},
    {MS_TOPP_ConsensusMapNormalizer, "MS:1002172", "TOPP ConsensusMapNormalizer", "Normalizes maps of one consensus XML file (after linking).", false},
    {MS_TOPP_MapRTTransformer, "MS:1002173", "TOPP MapRTTransformer", "Applies retention time transformations to maps.", false},
    {MS_TOPP_feature_linker, "MS:1002174", "TOPP feature linker", "Feature linker component of the TOPP software.", false},
    {MS_TOPP_FeatureLinkerLabeled, "MS:1002175", "TOPP FeatureLinkerLabeled", "Groups corresponding isotope-labeled features in a feature map.", false},
    {MS_TOPP_FeatureLinkerUnlabeled, "MS:1002176", "TOPP FeatureLinkerUnlabeled", "Groups corresponding features from multiple maps.", false},
    {MS_TOPP_FeatureLinkerUnlabeledQT, "MS:1002177", "TOPP FeatureLinkerUnlabeledQT", "Groups corresponding features from multiple maps using a quality threshold clustering approach.", false},
    {MS_TOPP_CompNovo, "MS:1002178", "TOPP CompNovo", "Performs a peptide/protein identification with the CompNovo engine.", false},
    {MS_TOPP_CompNovoCID, "MS:1002179", "TOPP CompNovoCID", "Performs a peptide/protein identification with the CompNovo engine in collision-induced dissociation (CID) mode.", false},
    {MS_TOPP_software_adaptor, "MS:1002180", "TOPP software adaptor", "Software adaptor to an external program in the TOPP software.", false},
    {MS_TOPP_InspectAdapter, "MS:1002181", "TOPP InspectAdapter", "Identifies MS2 spectra using the external program Inspect.", false},
    {MS_TOPP_MascotAdapter, "MS:1002182", "TOPP MascotAdapter", "Identifies MS2 spectra using the external program Mascot.", false},
    {MS_TOPP_MascotAdapterOnline, "MS:1002183", "TOPP MascotAdapterOnline", "Identifies MS2 spectra using the online version of the external program Mascot.", false},
    {MS_TOPP_OMSSAAdapter, "MS:1002184", "TOPP OMSSAAdapter", "Identifies MS2 spectra using the external program OMSSA.", false},
    {MS_TOPP_PepNovoAdapter, "MS:1002185", "TOPP PepNovoAdapter", "Identifies MS2 spectra using the external program PepNovo.", false},
    {MS_TOPP_XTandemAdapter, "MS:1002186", "TOPP XTandemAdapter", "Identifies MS2 spectra using the external program XTandem.", false},
    {MS_TOPP_SpecLibSearcher, "MS:1002187", "TOPP SpecLibSearcher", "Identifies peptide MS2 spectra by spectral matching with a searchable spectral library.", false},
    {MS_TOPP_ConsensusID, "MS:1002188", "TOPP ConsensusID", "Computes a consensus identification from peptide identifications of several identification engines.", false},
    {MS_TOPP_IDConflictResolver, "MS:1002189", "TOPP IDConflictResolver", "Resolves ambiguous annotations of features with peptide identifications.", false},
    {MS_TOPP_IDFilter, "MS:1002190", "TOPP IDFilter", "Filters results from protein or peptide identification engines based on different criteria.", false},
    {MS_TOPP_IDMapper, "MS:1002191", "TOPP IDMapper", "Assigns protein/peptide identifications to feature or consensus features.", false},
    {MS_TOPP_IDPosteriorErrorProbability, "MS:1002192", "TOPP IDPosteriorErrorProbability", "Estimates posterior error probabilities using a mixture model.", false},
    {MS_TOPP_IDRTCalibration, "MS:1002193", "TOPP IDRTCalibration", "Calibrate Retention times of peptide hits to standards.", false},
    {MS_TOPP_PeptideIndexer, "MS:1002194", "TOPP PeptideIndexer", "Refreshes the protein references for all peptide hits.", false},
    {MS_TOPP_PrecursorIonSelector, "MS:1002195", "TOPP PrecursorIonSelector", "A tool for precursor ion selection based on identification results.", false},
    {MS_TOPP_MRMMapper, "MS:1002196", "TOPP MRMMapper", "MRMMapper maps measured chromatograms (mzML) and the transitions used (TraML).", false},
    {MS_TOPP_OpenSwath_component, "MS:1002197", "TOPP OpenSwath component", "OpenSwath component of the TOPP software.", false},
    {MS_TOPP_OpenSwathAnalyzer, "MS:1002198", "TOPP OpenSwathAnalyzer", "Picks peaks and finds features in an SRM experiment.", false},
    {MS_TOPP_OpenSwathChromatogramExtractor, "MS:1002199", "TOPP OpenSwathChromatogramExtractor", "Extract chromatograms (XIC) from a MS2 map file.", false},
    {MS_TOPP_OpenSwathDecoyGenerator, "MS:1002200", "TOPP OpenSwathDecoyGenerator", "Generates decoys according to different models for a specific TraML.", false},
    {MS_TOPP_OpenSwathFeatureXMLToTSV, "MS:1002201", "TOPP OpenSwathFeatureXMLToTSV", "Converts a featureXML to a mProphet tsv (tab separated values).", false},
    {MS_TOPP_OpenSwathRTNormalizer, "MS:1002202", "TOPP OpenSwathRTNormalizer", "Generates a transformation file for retention time space into normalized space.", false},
    {MS_TOPP_ProteinInference, "MS:1002203", "TOPP ProteinInference", "Infer proteins from a list of (high-confidence) peptides.", false},
    {MS_TOPP_FalseDiscoveryRate, "MS:1002204", "TOPP FalseDiscoveryRate", "Estimates the false discovery rate on peptide and protein level using decoy searches.", false},
    {MS_ProteoWizard_msconvert, "MS:1002205", "ProteoWizard msconvert", "Converts, filters, and processes mass spectrometry data in variety of formats.", false},
    {MS_ProteoWizard_idconvert, "MS:1002206", "ProteoWizard idconvert", "Converts, filters, and processes identifications from shotgun proteomics experiments.", false},
    {MS_ProteoWizard_chainsaw, "MS:1002207", "ProteoWizard chainsaw", "Filters and processes protein sequence databases.", false},
    {MS_ProteoWizard_msaccess, "MS:1002208", "ProteoWizard msaccess", "Filters, processes, and displays mass spectrometry data in a variety of ways.", false},
    {MS_ProteoWizard_SeeMS, "MS:1002209", "ProteoWizard SeeMS", "An interactive GUI application to view and filter mass spectrometry data in a variety of formats.", false},
    {MS_IsobariQ, "MS:1002210", "IsobariQ", "A quantitative software package designed for analysis of IPTL, TMT and iTRAQ data.", false},
    {MS_Variance_stabilizing_normalization, "MS:1002211", "Variance stabilizing normalization", "The model incorporates data calibration (normalization), a model for the dependence of the variance on the mean intensity, and a variance stabilizing data transformation.", false},
    {MS_IPTL_quantitation_analysis, "MS:1002212", "IPTL quantitation analysis", "Quantification analysis using a labelling strategy where both peptide termini are labelled so that the peptides from different labelling schema are isobaric.", false},
    {MS_PAnalyzer_conclusive_protein, "MS:1002213", "PAnalyzer:conclusive protein", "A protein identified by at least one unique (distinct, discrete) peptide (peptides are considered different only if they can be distinguished by evidence in mass spectrum).", false},
    {MS_PAnalyzer_indistinguishable_protein, "MS:1002214", "PAnalyzer:indistinguishable protein", "A member of a group of proteins sharing all peptides that are exclusive to the group (peptides are considered different only if they can be distinguished by evidence in mass spectrum).", false},
    {MS_PAnalyzer_non_conclusive_protein, "MS:1002215", "PAnalyzer:non-conclusive protein", "A protein sharing all its matched peptides with either conclusive or indistinguishable proteins (peptides are considered different only if they can be distinguished by evidence in mass spectrum).", false},
    {MS_PAnalyzer_ambiguous_group_member, "MS:1002216", "PAnalyzer:ambiguous group member", "A protein sharing at least one peptide not matched to either conclusive or indistinguishable proteins (peptides are considered different only if they can be distinguished by evidence in mass spectrum).", false},
    {MS_decoy_peptide, "MS:1002217", "decoy peptide", "A putative identified peptide issued from a decoy sequence database.", false},
    {MS_percent_collision_energy_ramp_start, "MS:1002218", "percent collision energy ramp start", "Collision energy at the start of the collision energy ramp in percent, normalized to the mass of the ion.", false},
    {MS_percent_collision_energy_ramp_end, "MS:1002219", "percent collision energy ramp end", "Collision energy at the end of the collision energy ramp in percent, normalized to the mass of the ion.", false},
    {MS_MRMaid, "MS:1002220", "MRMaid", "A web-based SRM assay design tool whose transitions are generated by mining the millions of identified peptide spectra held in the EBI's PRIDE database.", false},
    {MS_MRMaid_peptide_score, "MS:1002221", "MRMaid:peptide score", "Score in MRMaid to indicate the expected performance of the peptide in SRM.", false},
    {MS_SRM_transition_attribute, "MS:1002222", "SRM transition attribute", "Attribute associated with a SRM transition.", false},
    {MS_precursor_ion_detection_probability, "MS:1002223", "precursor ion detection probability", "Probability of detecting precursor when parent protein is present.", false},
    {MS_product_ion_detection_probability, "MS:1002224", "product ion detection probability", "Probability of detecting product ion when precursor ion is present.", false},
    {MS_average_product_ion_intensity, "MS:1002225", "average product ion intensity", "Average value of product ion intensity in a collection of identified spectra.", false},
    {MS_product_ion_intensity_standard_deviation, "MS:1002226", "product ion intensity standard deviation", "Standard deviation of product ion intensity in a collection of identified spectra.", false},
    {MS_number_of_product_ion_observations, "MS:1002227", "number of product ion observations", "The number of times the specific product ion has been observed in a series of SRM experiments.", false},
    {MS_number_of_precursor_ion_observations, "MS:1002228", "number of precursor ion observations", "The number of times the specific precursor ion has been observed in a series of SRM experiments.", false},
    {MS_ProteomeDiscoverer_Mascot_Significance_Middle, "MS:1002229", "ProteomeDiscoverer:Mascot:Significance Middle", "Calculated relaxed significance when performing a decoy search for high-confidence peptides.", false},
    {MS_ProteomeDiscoverer_Mascot_Significance_High, "MS:1002230", "ProteomeDiscoverer:Mascot:Significance High", "Calculated relaxed significance when performing a decoy search for medium-confidence peptides.", false},
    {MS_regular_expressions_for_a_GUID, "MS:1002231", "regular expressions for a GUID", "([A-Fa-f0-9]\\{8\\}-([A-Fa-f0-9]\\{4\\}-)\\{3\\}[A-Fa-f0-9]\\{12\\}).", false},
    {MS_ProteomeDiscoverer_Default_FDR_calculator, "MS:1002232", "ProteomeDiscoverer:Default FDR calculator", "The default FDR calculator as globally unique identifier (GUID).", false},
    {MS_ProteomeDiscoverer_SEQUEST_Low_resolution_spectra_contained, "MS:1002233", "ProteomeDiscoverer:SEQUEST:Low resolution spectra contained", "Flag indicating if low-resolution spectra are taken into consideration.", false},
    {MS_selected_precursor_m_z, "MS:1002234", "selected precursor m/z", "Mass-to-charge ratio of a precursor ion selected for fragmentation.", false},
    {MS_ProteoGrouper_PDH_score, "MS:1002235", "ProteoGrouper:PDH score", "A score assigned to a single protein accession (modelled as ProteinDetectionHypothesis in mzIdentML), based on summed peptide level scores.", false},
    {MS_ProteoGrouper_PAG_score, "MS:1002236", "ProteoGrouper:PAG score", "A score assigned to a protein group (modelled as ProteinAmbiguityGroup in mzIdentML), based on all summed peptide level scores that have been assigned to the group as unique or razor peptides.", false},
    {MS_mzidLib, "MS:1002237", "mzidLib", "A library of Java routines for manipulating mzIdentML files.", false},
    {MS_mzidLib_Omssa2Mzid, "MS:1002238", "mzidLib:Omssa2Mzid", "A converter for OMSSA OMX to mzIdentML.", false},
    {MS_mzidLib_Tandem2Mzid, "MS:1002239", "mzidLib:Tandem2Mzid", "A converter for Tandem XML to mzIdentML.", false},
    {MS_mzidLib_Csv2Mzid, "MS:1002240", "mzidLib:Csv2Mzid", "A converter for CSV files (following OMSSA CSV style) to mzIdentML.", false},
    {MS_mzidLib_ProteoGrouper, "MS:1002241", "mzidLib:ProteoGrouper", "A generic and parameterizable protein inference algorithm for mzIdentML files.", false},
    {MS_mzidLib_Thresholder, "MS:1002242", "mzidLib:Thresholder", "A routine for keeping only identifications passing a given threshold or setting passThreshold to true or false for SpectrumIdentificationItem or ProteinDetectionHypothesis in mzIdentML files.", false},
    {MS_mzidLib_Perform_emPAI_on_mzid, "MS:1002243", "mzidLib:Perform emPAI on mzid", "A routine for adding emPAI quantitative values to an mzIdentML file.", false},
    {MS_mzidLib_FalseDiscoveryRate, "MS:1002244", "mzidLib:FalseDiscoveryRate", "A routine for calculating local FDR, q-value and FDRScore for mzIdentML files, based on a decoy search.", false},
    {MS_mzidLib_Mzidentml2Csv, "MS:1002245", "mzidLib:Mzidentml2Csv", "A tool for converting mzIdentML files to CSV format.", false},
    {MS_mzidLib_CombineSearchEngines, "MS:1002246", "mzidLib:CombineSearchEngines", "A tool for combining results analysed in parallel in two or three search engines into a single mzIdentML file.", false},
    {MS_mzidLib_InsertMetaDataFromFasta, "MS:1002247", "mzidLib:InsertMetaDataFromFasta", "A tool for adding additional meta data from a FASTA file to DBSequence entries (sequence and description) in mzIdentML files.", false},
    {MS_SEQUEST_spscore, "MS:1002248", "SEQUEST:spscore", "The SEQUEST result 'SpScore'.", false},
    {MS_SEQUEST_sprank, "MS:1002249", "SEQUEST:sprank", "The SEQUEST result 'SpRank'.", false},
    {MS_SEQUEST_deltacnstar, "MS:1002250", "SEQUEST:deltacnstar", "The SEQUEST result 'DeltaCnStar'.", false},
    {MS_Comet, "MS:1002251", "Comet", "Comet open-source sequence search engine developed at the University of Washington.", false},
    {MS_Comet_xcorr, "MS:1002252", "Comet:xcorr", "The Comet result 'XCorr'.", false},
    {MS_Comet_deltacn, "MS:1002253", "Comet:deltacn", "The Comet result 'DeltaCn'.", false},
    {MS_Comet_deltacnstar, "MS:1002254", "Comet:deltacnstar", "The Comet result 'DeltaCnStar'.", false},
    {MS_Comet_spscore, "MS:1002255", "Comet:spscore", "The Comet result 'SpScore'.", false},
    {MS_Comet_sprank, "MS:1002256", "Comet:sprank", "The Comet result 'SpRank'.", false},
    {MS_Comet_expectation_value, "MS:1002257", "Comet:expectation value", "The Comet result 'Expectation value'.", false},
    {MS_Comet_matched_ions, "MS:1002258", "Comet:matched ions", "The Comet result 'Matched Ions'.", false},
    {MS_Comet_total_ions, "MS:1002259", "Comet:total ions", "The Comet result 'Total Ions'.", false},
    {MS_PSM_FDR_threshold, "MS:1002260", "PSM:FDR threshold", "False-discovery rate threshold for peptide-spectrum matches.", false},
    {MS_Byonic, "MS:1002261", "Byonic", "Byonic search engine from Protein Metrics.", false},
    {MS_Byonic_Score, "MS:1002262", "Byonic:Score", "The Byonic score is the primary indicator of PSM correctness. The Byonic score reflects the absolute quality of the peptide-spectrum match, not the relative quality compared to other candidate peptides. Byonic scores range from 0 to about 1000, with 300 a good score, 400 a very good score, and PSMs with scores over 500 almost sure to be correct.", false},
    {MS_Byonic_Delta_Score, "MS:1002263", "Byonic:Delta Score", "The drop in Byonic score from the top-scoring peptide to the next peptide with distinct sequence. In this computation, the same peptide with different modifications is not considered distinct.", false},
    {MS_Byonic_DeltaMod_Score, "MS:1002264", "Byonic:DeltaMod Score", "The drop in Byonic score from the top-scoring peptide to the next peptide different in any way, including placement of modifications. DeltaMod gives an indication of whether modifications are confidently localized; DeltaMod over 10.0 means that there is high likelihood that all modification placements are correct.", false},
    {MS_Byonic_PEP, "MS:1002265", "Byonic:PEP", "Byonic posterior error probability.", false},
    {MS_Byonic_Peptide_LogProb, "MS:1002266", "Byonic:Peptide LogProb", "The log p-value of the PSM. This is the log of the probability that the PSM with such a score and delta would arise by chance in a search of this size (the size of the protein database, as expanded by the modification rules). A log p-value of -3.0 should happen by chance on only one of a thousand spectra. Caveat: it is very hard to compute a p-value that works for all searches and all spectra, so read Byonic p-values with a certain amount of skepticism.", false},
    {MS_Byonic_Protein_LogProb, "MS:1002267", "Byonic:Protein LogProb", "The log p-value of the protein.", false},
    {MS_Byonic_Best_LogProb, "MS:1002268", "Byonic:Best LogProb", "Best (most negative) log p-value of an individual PSM.", false},
    {MS_Byonic_Best_Score, "MS:1002269", "Byonic:Best Score", "Best (largest) Byonic score of a PSM.", false},
    {MS_chromatography_separation, "MS:1002270", "chromatography separation", "A technique by which molecules are separated by chemical and physical properties such as hydrophobicity or vapour pressure.", false},
    {MS_liquid_chromatography_separation, "MS:1002271", "liquid chromatography separation", "Liquid chromatography (LC) is a separation technique in which the mobile phase is a liquid.", false},
    {MS_gas_chromatography_separation, "MS:1002272", "gas chromatography separation", "Gas chromatography (GC) is a separation technique in which the mobile phase is a gas.", false},
    {MS_detector_potential, "MS:1002273", "detector potential", "Detector potential difference in volts.", false},
    {MS_SQ_Detector_2, "MS:1002274", "SQ Detector 2", "Waters quadrupole based SQ Detector 2.", false},
    {MS_Xevo_G2_S_Tof, "MS:1002275", "Xevo G2-S Tof", "Waters oa-ToF based Xevo G2-S Tof.", false},
    {MS_Xevo_G2_S_QTof, "MS:1002276", "Xevo G2-S QTof", "Waters oa-ToF based Xevo G2-S QTof.", false},
    {MS_AutoSpec_Premier, "MS:1002277", "AutoSpec Premier", "Waters AutoSpec Premier magnetic sector instrument.", false},
    {MS_Pegasus_III, "MS:1002278", "Pegasus III", "LECO nominal mass resolution time-of-flight GC mass spectrometer.", false},
    {MS_maXis_4G, "MS:1002279", "maXis 4G", "Bruker Daltonics' maXis 4G: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.", false},
    {MS_compact, "MS:1002280", "compact", "Bruker Daltonics' compact: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.", false},
    {MS_SRM_feature_level_quantitation, "MS:1002281", "SRM feature level quantitation", "Selected Reaction Monitoring feature level quantitation.", false},
    {MS_SRM_peptide_level_quantitation, "MS:1002282", "SRM peptide level quantitation", "Selected Reaction Monitoring peptide level quantitation.", false},
    {MS_SRM_protein_level_quantitation, "MS:1002283", "SRM protein level quantitation", "Selected Reaction Monitoring protein level quantitation.", false},
    {MS_SRM_proteingroup_level_quantitation, "MS:1002284", "SRM proteingroup level quantitation", "Selected Reaction Monitoring proteingroup level quantitation.", false},
    {MS_Trans_Proteomic_Pipeline, "MS:1002285", "Trans-Proteomic Pipeline", "A suite of open source tools for the processing of MS2 proteomics data developed by the Seattle Proteome Center at the Institute for Systems Biology.", false},
    {MS_Trans_Proteomic_Pipeline_software, "MS:1002286", "Trans-Proteomic Pipeline software", "A software program that is a component of the Trans-Proteomic Pipeline.", false},
    {MS_PeptideProphet, "MS:1002287", "PeptideProphet", "A program in the TPP that calculates PSM probabilities for MS2 proteomics data searched with any of the supported sequence or spectral library search engines via the pepXML format.", false},
    {MS_iProphet, "MS:1002288", "iProphet", "A program in the TPP that calculates distinct peptide probabilities based on several lines of corroborating evidence including search results from multiple search engines via the pepXML format.", false},
    {MS_ProteinProphet, "MS:1002289", "ProteinProphet", "A program in the TPP that calculates protein-level probabilities based on input PSM or peptide-level probabilities from PeptideProphet or iProphet. The output is written in the protXML format.", false},
    {MS_XPRESS, "MS:1002290", "XPRESS", "A program in the TPP that calculates PSM-level abundances based on 2-channel isotope-labelled data such as ICAT, SILAC, etc.", false},
    {MS_Libra, "MS:1002291", "Libra", "A program in the TPP that calculates PSM, peptide, and protein-level abundances based on N-channel isobaric label peptide data such as iTRAQ, TMT, etc.", false},
    {MS_PTMProphet, "MS:1002292", "PTMProphet", "A program in the TPP that calculates PTM localization probabilities by re-analyzing the peaks that are available to distinguish between possible modification sites.", false},
    {MS_Bruker_Daltonics_SCION_series, "MS:1002293", "Bruker Daltonics SCION series", "Bruker Daltonics' SCION series.", false},
    {MS_Bruker_Daltonics_EVOQ_series, "MS:1002294", "Bruker Daltonics EVOQ series", "Bruker Daltonics' EVOQ series.", false},
    {MS_SCION_SQ, "MS:1002295", "SCION SQ", "Bruker Daltonics' SCION SQ: GC-single quadrupole.", false},
    {MS_SCION_TQ, "MS:1002296", "SCION TQ", "Bruker Daltonics' SCION TQ: GC-triple quadrupole.", false},
    {MS_EVOQ_Elite, "MS:1002297", "EVOQ Elite", "Bruker Daltonics' EVOQ Elite: LC-triple quadrupole.", false},
    {MS_EVOQ_Qube, "MS:1002298", "EVOQ Qube", "Bruker Daltonics' EVOQ Qube: LC-triple quadrupole.", false},
    {MS_micrOTOF_Q_III, "MS:1002299", "micrOTOF-Q III", "Bruker Daltonics' micrOTOF-Q III: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.", false},
    {MS_amaZon_Speed_ETD, "MS:1002300", "amaZon Speed ETD", "Bruker Daltonics' amaZon Speed ETD: ESI quadrupole ion trap, Nanospray, APCI, APPI, ETD, PTR, GC-APCI, CaptiveSpray.", false},
    {MS_amaZon_Speed, "MS:1002301", "amaZon Speed", "Bruker Daltonics' amaZon ETD: ESI quadrupole ion trap, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.", false},
    {MS_Bruker_Container_format, "MS:1002302", "Bruker Container format", "Bruker Container raw file format.", false},
    {MS_Bruker_Container_nativeID_format, "MS:1002303", "Bruker Container nativeID format", "Native identifier (UUID).", false},
    {MS_domain_range, "MS:1002304", "domain range", "Domain range of a numerical value.", false},
    {MS_value_between_0_and_1_inclusive, "MS:1002305", "value between 0 and 1 inclusive", "Value range for probabilities.", false},
    {MS_value_greater_than_zero, "MS:1002306", "value greater than zero", "Positive value range.", false},
    {MS_fragmentation_ion_type, "MS:1002307", "fragmentation ion type", "Type of fragment ion based on where the backbone breaks, such as a y ion or a c ion.", false},
    {MS_fluorescence_detector, "MS:1002308", "fluorescence detector", "A detector using a fluorescent signal after excitation with light.", false},
    {MS_Byonic__Peptide_AbsLogProb, "MS:1002309", "Byonic: Peptide AbsLogProb", "The absolute value of the log-base10 of the Byonic posterior error probability (PEP) of the PSM.", false},
    {MS_Byonic__Protein_AbsLogProb, "MS:1002310", "Byonic: Protein AbsLogProb", "The absolute value of the log-base10 of the Byonic posterior error probability (PEP) of the protein.", false},
    {MS_Byonic__Peptide_AbsLogProb2D, "MS:1002311", "Byonic: Peptide AbsLogProb2D", "The absolute value of the log-base10 Byonic two-dimensional posterior error probability (PEP) of the PSM. The two-dimensional PEP takes into account protein ranking information as well as PSM information.", false},
    {MS_MS_Numpress_linear_prediction_compression, "MS:1002312", "MS-Numpress linear prediction compression", "Compression using MS-Numpress linear prediction compression.", false},
    {MS_MS_Numpress_positive_integer_compression, "MS:1002313", "MS-Numpress positive integer compression", "Compression using MS-Numpress positive integer compression.", false},
    {MS_MS_Numpress_short_logged_float_compression, "MS:1002314", "MS-Numpress short logged float compression", "Compression using MS-Numpress short logged float compression.", false},
    {MS_consensus_result, "MS:1002315", "consensus result", "Indicates a consensus result from several search engine runs.", false},
    {MS_ProteomeDiscoverer_Amanda_high_confidence_threshold, "MS:1002316", "ProteomeDiscoverer:Amanda:high confidence threshold", "Strict confidence probability score.", false},
    {MS_ProteomeDiscoverer_Amanda_middle_confidence_threshold, "MS:1002317", "ProteomeDiscoverer:Amanda:middle confidence threshold", "Relaxed confidence probability score.", false},
    {MS_ProteomeDiscoverer_automatic_workload, "MS:1002318", "ProteomeDiscoverer:automatic workload", "Flag indicating automatic estimation of the workload level.", false},
    {MS_Amanda_AmandaScore, "MS:1002319", "Amanda:AmandaScore", "The Amanda score of the scoring function for a PSM.", false},
    {MS_ProteomeDiscoverer_max_differential_modifications, "MS:1002320", "ProteomeDiscoverer:max differential modifications", "Maximum dynamic modifications per PSM.", false},
    {MS_ProteomeDiscoverer_max_equal_modifications, "MS:1002321", "ProteomeDiscoverer:max equal modifications", "Maximum equal modifications per PSM.", false},
    {MS_ProteomeDiscoverer_min_peptide_length, "MS:1002322", "ProteomeDiscoverer:min peptide length", "Minimum peptide length.", false},
    {MS_ProteomeDiscoverer_max_peptide_length, "MS:1002323", "ProteomeDiscoverer:max peptide length", "Maximum peptide length.", false},
    {MS_ProteomeDiscoverer_max_number_neutral_loss, "MS:1002324", "ProteomeDiscoverer:max number neutral loss", "Maximum number of same neutral losses.", false},
    {MS_ProteomeDiscoverer_max_number_neutral_loss_modifications, "MS:1002325", "ProteomeDiscoverer:max number neutral loss modifications", "Max number of same neutral losses of modifications.", false},
    {MS_ProteomeDiscoverer_use_flanking_ions, "MS:1002326", "ProteomeDiscoverer:use flanking ions", "Flag for usage of flanking ions.", false},
    {MS_ProteomeDiscoverer_max_number_of_same_modifs, "MS:1002327", "ProteomeDiscoverer:max number of same modifs", "The maximum number of possible equal modifications per PSM.", false},
    {MS_ProteomeDiscoverer_perform_deisotoping, "MS:1002328", "ProteomeDiscoverer:perform deisotoping", "Defines whether a simple deisotoping shall be performed.", false},
    {MS_ProteomeDiscoverer_ion_settings, "MS:1002329", "ProteomeDiscoverer:ion settings", "Specifies the fragment ions and neutral losses that are calculated.", false},
    {MS_ProteomeDiscoverer_3__Static_Modification_OBSOLETE, "MS:1002330", "ProteomeDiscoverer:3. Static Modification", "ProteomeDiscoverer's 3rd static post-translational modification (PTM) input parameter.", true},
    {MS_ProteomeDiscoverer_5__Dynamic_Modification_OBSOLETE, "MS:1002331", "ProteomeDiscoverer:5. Dynamic Modification", "ProteomeDiscoverer's 5th dynamic post-translational modification (PTM) input parameter.", true},
    {MS_lab_head, "MS:1002332", "lab head", "The scientist responsible for personnel, grants, and instrumentation in a functional laboratory group.", false},
    {MS_conversion_software, "MS:1002333", "conversion software", "Computer software primarily designed to convert data represented in one format to another format, sometimes with minor data alterations in the process.", false},
    {MS_ProCon, "MS:1002334", "ProCon", "Java software designed to convert one of several proteomics identification results formats into mzIdentML or PRIDE XML.", false},
    {MS_PRIDE_Converter2, "MS:1002335", "PRIDE Converter2", "Java software designed to convert one of several proteomics identification results formats into PRIDE XML.", false},
    {MS_Amanda, "MS:1002336", "Amanda", "Amanda scoring system for PSM identification.", false},
    {MS_Andromeda, "MS:1002337", "Andromeda", "Andromeda is a peptide search engine.", false},
    {MS_Andromeda_score, "MS:1002338", "Andromeda:score", "The probability based score of the Andromeda search engine.", false},
    {MS_site_global_FDR, "MS:1002339", "site:global FDR", "Estimation of global false discovery rate of peptides with a post-translational modification.", false},
    {MS_ProteomeXchange_project_tag, "MS:1002340", "ProteomeXchange project tag", "Tag that can be added to a ProteomeXchange dataset, to enable the grouping of datasets. One tag can be used for indicating that a given dataset is part of a bigger project, like e.g. the Human Proteome Project.", false},
    {MS_second_pass_peptide_identification, "MS:1002341", "second-pass peptide identification", "A putative identified peptide found in a second-pass search of protein sequences selected from a first-pass search.", false},
    {MS_MZmine, "MS:1002342", "MZmine", "A framework for differential analysis of mass spectrometry data.", false},
    {MS_ion_stability_type_OBSOLETE, "MS:1002343", "ion stability type", "Stability type of the ion.", true},
    {MS_Maltcms, "MS:1002344", "Maltcms", "Modular Application Toolkit for Chromatography Mass-Spectrometry is an application framework mainly for developers.", false},
    {MS_PSM_level_attribute, "MS:1002345", "PSM-level attribute", "Attribute of a single peptide-spectrum match.", false},
    {MS_protein_group_level_identification_attribute, "MS:1002346", "protein group-level identification attribute", "Protein group level information.", false},
    {MS_PSM_level_identification_statistic, "MS:1002347", "PSM-level identification statistic", "Identification confidence metric for a peptide spectrum match.", false},
    {MS_protein_group_level_identification_statistic, "MS:1002348", "protein group-level identification statistic", "Identification confidence metric for a protein group.", false},
    {MS_value_greater_than_zero_but_less_than_or_equal_to_one, "MS:1002349", "value greater than zero but less than or equal to one", "Positive value range less than or equal to 1.", false},
    {MS_PSM_level_global_FDR, "MS:1002350", "PSM-level global FDR", "Estimation of the global false discovery rate of peptide spectrum matches.", false},
    {MS_PSM_level_local_FDR, "MS:1002351", "PSM-level local FDR", "Estimation of the local false discovery rate of peptide spectrum matches.", false},
    {MS_PSM_level_p_value, "MS:1002352", "PSM-level p-value", "Estimation of the p-value for peptide spectrum matches.", false},
    {MS_PSM_level_e_value, "MS:1002353", "PSM-level e-value", "Estimation of the e-value for peptide spectrum matches.", false},
    {MS_PSM_level_q_value, "MS:1002354", "PSM-level q-value", "Estimation of the q-value for peptide spectrum matches.", false},
    {MS_PSM_level_FDRScore, "MS:1002355", "PSM-level FDRScore", "mzidLibrary FDRScore for peptide spectrum matches.", false},
    {MS_PSM_level_combined_FDRScore, "MS:1002356", "PSM-level combined FDRScore", "mzidLibrary Combined FDRScore for peptide spectrum matches specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.", false},
    {MS_PSM_level_probability, "MS:1002357", "PSM-level probability", "Probability that the reported peptide ion is truly responsible for some or all of the components of the specified mass spectrum.", false},
    {MS_search_engine_specific_peptide_sequence_level_identification_statistic, "MS:1002358", "search engine specific peptide sequence-level identification statistic", "Search engine specific distinct peptide score.", false},
    {MS_peptide_sequence_level_local_FDR, "MS:1002359", "peptide sequence-level local FDR", "Estimation of the local false discovery rate for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_distinct_peptide_level_FDRScore, "MS:1002360", "distinct peptide-level FDRScore", "MzidLibrary FDRScore for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_distinct_peptide_level_combined_FDRScore, "MS:1002361", "distinct peptide-level combined FDRScore", "Combined FDRScore for peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry) specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given peptide, used for integrating results from these distinct pools.", false},
    {MS_peptide_sequence_level_probability, "MS:1002362", "peptide sequence-level probability", "Probability that the reported distinct peptide sequence (irrespective of mass modifications) has been correctly identified via the referenced PSMs.", false},
    {MS_search_engine_specific_score_for_proteins, "MS:1002363", "search engine specific score for proteins", "Search engine specific protein scores.", false},
    {MS_protein_level_local_FDR, "MS:1002364", "protein-level local FDR", "Estimation of the local false discovery rate of proteins.", false},
    {MS_FDRScore_for_proteins, "MS:1002365", "FDRScore for proteins", "MzidLibrary FDRScore for proteins specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.", false},
    {MS_combined_FDRScore_for_proteins, "MS:1002366", "combined FDRScore for proteins", "MzidLibrary Combined FDRScore for proteins.", false},
    {MS_probability_for_proteins, "MS:1002367", "probability for proteins", "Probability that a specific protein sequence has been correctly identified from the PSM and distinct peptide evidence, and based on the available protein sequences presented to the analysis software.", false},
    {MS_search_engine_specific_score_for_protein_groups, "MS:1002368", "search engine specific score for protein groups", "Search engine specific protein group scores.", false},
    {MS_protein_group_level_global_FDR, "MS:1002369", "protein group-level global FDR", "Estimation of the global false discovery rate of protein groups.", false},
    {MS_protein_group_level_local_FDR, "MS:1002370", "protein group-level local FDR", "Estimation of the local false discovery rate of protein groups.", false},
    {MS_protein_group_level_p_value, "MS:1002371", "protein group-level p-value", "Estimation of the p-value for protein groups.", false},
    {MS_protein_group_level_e_value, "MS:1002372", "protein group-level e-value", "Estimation of the e-value for protein groups.", false},
    {MS_protein_group_level_q_value, "MS:1002373", "protein group-level q-value", "Estimation of the q-value for protein groups.", false},
    {MS_protein_group_level_FDRScore, "MS:1002374", "protein group-level FDRScore", "mzidLibrary FDRScore for protein groups.", false},
    {MS_protein_group_level_combined_FDRScore, "MS:1002375", "protein group-level combined FDRScore", "mzidLibrary Combined FDRScore for proteins specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.", false},
    {MS_protein_group_level_probability, "MS:1002376", "protein group-level probability", "Probability that at least one of the members of a group of protein sequences has been correctly identified from the PSM and distinct peptide evidence, and based on the available protein sequences presented to the analysis software.", false},
    {MS_ProteomeDiscoverer_Relaxed_Score_Threshold, "MS:1002377", "ProteomeDiscoverer:Relaxed Score Threshold", "Specifies the threshold value for relaxed scoring.", false},
    {MS_ProteomeDiscoverer_Strict_Score_Threshold, "MS:1002378", "ProteomeDiscoverer:Strict Score Threshold", "Specifies the threshold value for strict scoring.", false},
    {MS_ProteomeDiscoverer_Peptide_Without_Protein_Cut_Off_Score, "MS:1002379", "ProteomeDiscoverer:Peptide Without Protein Cut Off Score", "Cut off score for storing peptides that do not belong to a protein.", false},
    {MS_false_localization_rate, "MS:1002380", "false localization rate", "Estimation of the false localization rate for modification site assignment.", false},
    {MS_MALDI_Solutions_LC_MALDI, "MS:1002381", "MALDI Solutions LC-MALDI", "Software for automated LC-MALDI analysis and reporting.", false},
    {MS_Shimadzu_MALDI_7090, "MS:1002382", "Shimadzu MALDI-7090", "Shimadzu MALDI-7090: MALDI-TOF-TOF.", false},
    {MS_SCiLS_software, "MS:1002383", "SCiLS software", "SCiLS software for data acquisition and analysis.", false},
    {MS_SCiLS_Lab, "MS:1002384", "SCiLS Lab", "SCiLS Lab software.", false},
    {MS_SCiLS_Lab_format, "MS:1002385", "SCiLS Lab format", "SCiLS Lab file format.", false},
    {MS_preprocessing_software, "MS:1002386", "preprocessing software", "Preprocessing software.", false},
    {MS_PIA, "MS:1002387", "PIA", "PIA - Protein Inference Algorithms, a toolbox for protein inference and identification analysis.", false},
    {MS_PIA_XML_format, "MS:1002388", "PIA XML format", "A compilation of search engine results in the PIA XML format.", false},
    {MS_PIA_workflow_parameter, "MS:1002389", "PIA workflow parameter", "A parameter set for a single PIA analysis.", false},
    {MS_PIA_FDRScore_calculated, "MS:1002390", "PIA:FDRScore calculated", "Indicates whether the FDR score was calculated for the input file.", false},
    {MS_PIA_Combined_FDRScore_calculated, "MS:1002391", "PIA:Combined FDRScore calculated", "Indicates whether the combined FDR score was calculated for the PIA compilation.", false},
    {MS_PIA_PSM_sets_created, "MS:1002392", "PIA:PSM sets created", "Indicates whether PSM sets were created.", false},
    {MS_PIA_used_top_identifications_for_FDR, "MS:1002393", "PIA:used top identifications for FDR", "The number of top identifications per spectrum used for the FDR calculation, 0 means all.", false},
    {MS_PIA_protein_score, "MS:1002394", "PIA:protein score", "The score given to a protein by any protein inference.", false},
    {MS_PIA_protein_inference, "MS:1002395", "PIA:protein inference", "The used algorithm for the protein inference using PIA.", false},
    {MS_PIA_protein_inference_filter, "MS:1002396", "PIA:protein inference filter", "A filter used by PIA for the protein inference.", false},
    {MS_PIA_protein_inference_scoring, "MS:1002397", "PIA:protein inference scoring", "The used scoring method for the protein inference using PIA.", false},
    {MS_PIA_protein_inference_used_score, "MS:1002398", "PIA:protein inference used score", "The used base score for the protein inference using PIA.", false},
    {MS_PIA_protein_inference_used_PSMs, "MS:1002399", "PIA:protein inference used PSMs", "The method to determine the PSMs used for scoring by the protein inference.", false},
    {MS_PIA_filter, "MS:1002400", "PIA:filter", "A filter used for the report generation.", false},
    {MS_leading_protein, "MS:1002401", "leading protein", "At least one protein within each group should be annotated as a leading protein to indicate it has the strongest evidence, or approximately equal evidence as other group members.", false},
    {MS_non_leading_protein, "MS:1002402", "non-leading protein", "Zero to many proteins within each group should be annotated as non-leading to indicate that other proteins have stronger evidence.", false},
    {MS_group_representative, "MS:1002403", "group representative", "An arbitrary and optional flag applied to exactly one protein per group to indicate it can serve as the representative of the group, amongst leading proteins, in effect serving as a tiebreaker for approaches that require exactly one group representative.", false},
    {MS_count_of_identified_proteins, "MS:1002404", "count of identified proteins", "The number of proteins that have been identified, which must match the number of groups that pass the threshold in the file.", false},
    {MS_protein_group_level_result_list_attribute, "MS:1002405", "protein group-level result list attribute", "Details describing a protein cluster.", false},
    {MS_count_of_identified_clusters, "MS:1002406", "count of identified clusters", "The number of protein clusters that have been identified, which must match the number of clusters that pass the threshold in the file.", false},
    {MS_cluster_identifier, "MS:1002407", "cluster identifier", "An identifier applied to protein groups to indicate that they are linked by shared peptides.", false},
    {MS_number_of_distinct_protein_sequences, "MS:1002408", "number of distinct protein sequences", "The number of protein clusters that have been identified, which must match the number of clusters that pass the threshold in the file.", false},
    {MS_marginally_distinguished_protein, "MS:1002409", "marginally distinguished protein", "Assigned to a non-leading protein that has some independent evidence to support its presence relative to the leading protein(s), e.g. the protein may have a unique peptide but not sufficient to be promoted as a leading protein of another group.", false},
    {MS_Anubis, "MS:1002410", "Anubis", "Anubis software for selected reaction monitoring data.", false},
    {MS_TraML_format, "MS:1002411", "TraML format", "The TraML format for transitions in SRM from the PSI. File extension '.TraML'.", false},
    {MS_total_XIC_area, "MS:1002412", "total XIC area", "Summed area of all the extracted ion chromatogram for the peptide (e.g. of all the transitions in SRM).", false},
    {MS_product_background, "MS:1002413", "product background", "The background area for the quantified transition.", false},
    {MS_postprocessing_software, "MS:1002414", "postprocessing software", "Postprocessing software.", false},
    {MS_protein_group_passes_threshold, "MS:1002415", "protein group passes threshold", "A Boolean attribute to determine whether the protein group has passed the threshold indicated in the file.", false},
    {MS_Orbitrap_Fusion, "MS:1002416", "Orbitrap Fusion", "Thermo Scientific Orbitrap Fusion.", false},
    {MS_Orbitrap_Fusion_ETD, "MS:1002417", "Orbitrap Fusion ETD", "Thermo Scientific Orbitrap Fusion with ETD.", false},
    {MS_TSQ_Quantiva, "MS:1002418", "TSQ Quantiva", "Thermo Scientific TSQ Quantiva MS.", false},
    {MS_TSQ_Endura, "MS:1002419", "TSQ Endura", "Thermo Scientific TSQ Endura MS.", false},
    {MS_PASSEL_experiment_URI, "MS:1002420", "PASSEL experiment URI", "URI that allows access to a PASSEL experiment.", false},
    {MS_Paragon_input_parameter, "MS:1002421", "Paragon input parameter", "Search engine input parameters specific to Paragon.", false},
    {MS_Paragon__sample_type, "MS:1002422", "Paragon: sample type", "The Paragon method setting indicating the type of sample at the high level, generally meaning the type of quantitation labelling or lack thereof. 'Identification' is indicated for samples without any labels for quantitation.", false},
    {MS_Paragon__cysteine_alkylation, "MS:1002423", "Paragon: cysteine alkylation", "The Paragon method setting indicating the actual cysteine alkylation agent; 'None' is indicated if there was no cysteine alkylation.", false},
    {MS_Paragon__instrument_setting, "MS:1002424", "Paragon: instrument setting", "The Paragon method setting (translating to a large number of lower level settings) indicating the instrument used or a category of instrument.", false},
    {MS_Paragon__search_effort, "MS:1002425", "Paragon: search effort", "The Paragon method setting that controls the two major modes of search effort of the Paragon algorithm: the Rapid mode uses a conventional database search, while the Thorough mode uses a hybrid search, starting with the same approach as the Rapid mode but then follows it with a separate tag-based approach enabling a more extensive search.", false},
    {MS_Paragon__ID_focus, "MS:1002426", "Paragon: ID focus", "A Paragon method setting that allows the inclusion of large sets of features such as biological modification or substitutions.", false},
    {MS_Paragon__FDR_analysis, "MS:1002427", "Paragon: FDR analysis", "The Paragon method setting that controls whether FDR analysis is conducted.", false},
    {MS_Paragon__quantitation, "MS:1002428", "Paragon: quantitation", "The Paragon method setting that controls whether quantitation analysis is conducted.", false},
    {MS_Paragon__background_correction, "MS:1002429", "Paragon: background correction", "The Paragon method setting that controls whether the 'Background Correction' analysis is conducted; this processing estimates a correction to the attenuation in extremity ratios that can occur in isobaric quantatitation workflows on complex samples.", false},
    {MS_Paragon__bias_correction, "MS:1002430", "Paragon: bias correction", "The Paragon method setting that controls whether 'Bias Correction' is invoked in quantitation analysis; this correction is a normalization to set the central tendency of protein ratios to unity.", false},
    {MS_Paragon__channel_to_use_as_denominator_in_ratios, "MS:1002431", "Paragon: channel to use as denominator in ratios", "The Paragon method setting that controls which label channel is used as the denominator in calculating relative expression ratios.", false},
    {MS_search_engine_specific_input_metadata, "MS:1002432", "search engine specific input metadata", "Search engine specific metadata that are not user-controlled settings.", false},
    {MS_Paragon__modified_data_dictionary_or_parameter_translation, "MS:1002433", "Paragon: modified data dictionary or parameter translation", "This metric detects if any changes have been made to the originally installed key control files for the software; if no changes have been made, then the software version and settings are sufficient to enable exact reproduction; if changes have been made, then the modified ParameterTranslation- and ProteinPilot DataDictionary-XML files much also be provided in order to exactly reproduce a result.", false},
    {MS_number_of_spectra_searched, "MS:1002434", "number of spectra searched", "Number of spectra in a search.", false},
    {MS_data_processing_start_time, "MS:1002435", "data processing start time", "The time that a data processing action was started.", false},
    {MS_Paragon__digestion, "MS:1002436", "Paragon: digestion", "The Paragon method setting indicating the actual digestion agent - unlike other search tools, this setting does not include options that control partial specificity like 'semitrypsin'; if trypsin is used, trypsin is set, and partially conforming peptides are found in the Thorough mode of search; 'None' should be indicated only if there was really no digestion done.", false},
    {MS_number_of_decoy_sequences, "MS:1002437", "number of decoy sequences", "The number of decoy sequences, if the concatenated target-decoy approach is used.", false},
    {MS_spectrum_identification_list_result_details, "MS:1002438", "spectrum identification list result details", "Information about the list of PSMs (SpectrumIdentificationList).", false},
    {MS_final_PSM_list, "MS:1002439", "final PSM list", "A flag on a list of PSMs (SpectrumIdentificationList) to indicate that this is the final set of identifications to be interpreted by consuming software. Amongst the set of SpectrumIdentificationList(s) that are flagged with the term, each spectrum must not be referenced from more than one SpectrumIdentificationResult.", false},
    {MS_intermediate_PSM_list, "MS:1002440", "intermediate PSM list", "A flag on a list of PSMs (SpectrumIdentificationList) to indicate that this is not the final set of identifications to be interpreted by consuming software. This term should be used when results are provided from multiple search engines for the results from each search engine before they are combined to give consensus identifications. Amongst the set of SpectrumIdentificationList(s) that are flagged with the term, each spectrum may be referenced from more than one SpectrumIdentificationResult.", false},
    {MS_Andi_MS_format, "MS:1002441", "Andi-MS format", "AIA Analytical Data Interchange file format for mass spectrometry data.", false},
    {MS_chromatograph_file_format, "MS:1002442", "chromatograph file format", "The format of the chromatography file being used. This could be a instrument or vendor specific proprietary file format or a converted open file format.", false},
    {MS_Andi_CHROM_format, "MS:1002443", "Andi-CHROM format", "AIA Analytical Data Interchange file format for chromatography data.", false},
    {MS_6420_Triple_Quadrupole_LC_MS, "MS:1002444", "6420 Triple Quadrupole LC/MS", "The 6420 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_6460_Triple_Quadrupole_LC_MS, "MS:1002445", "6460 Triple Quadrupole LC/MS", "The 6460 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. It is similar to the 6420 but adds Agilent Jet Stream (AJS) technology to increase sensitivity.", false},
    {MS_6490_Triple_Quadrupole_LC_MS, "MS:1002446", "6490 Triple Quadrupole LC/MS", "The 6490 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. It is similar to the 6420 but adds the Agilent iFunnel technology to increase sensitivity.", false},
    {MS_Paragon_special_factor, "MS:1002447", "Paragon:special factor", "The Paragon method setting indicating a list of one or more 'special factors', which generally capture secondary effects (relative to other settings) as a set of probabilities of modification features that override the assumed levels. For example the 'gel-based ID' special factor causes an increase probability of oxidation on several resides because of the air exposure impact on a gel, in addition to other effects.", false},
    {MS_PEAKS_inChorusPeptideScore, "MS:1002448", "PEAKS:inChorusPeptideScore", "The PEAKS inChorus peptide score.", false},
    {MS_PEAKS_inChorusProteinScore, "MS:1002449", "PEAKS:inChorusProteinScore", "The PEAKS inChorus protein score.", false},
    {MS_param__b_ion_H3PO4_DEPRECATED, "MS:1002450", "param: b ion-H3PO4 DEPRECATED", "Ion b-H3PO4: b ion with lost phosphoric acid.", false},
    {MS_param__y_ion_H3PO4_DEPRECATED, "MS:1002451", "param: y ion-H3PO4 DEPRECATED", "Ion y-H3PO4: y ion with lost phosphoric acid.", false},
    {MS_Maui, "MS:1002452", "Maui", "The Maltcms Graphical User Interface.", false},
    {MS_No_fixed_modifications_searched, "MS:1002453", "No fixed modifications searched", "No fixed modifications are included as a parameter for the search, and therefore they are not reported.", false},
    {MS_No_variable_modifications_searched, "MS:1002454", "No variable modifications searched", "No variable modifications are included as a parameter for the search, and therefore they are not reported.", false},
    {MS_H2O_neutral_loss_OBSOLETE, "MS:1002455", "H2O neutral loss", "Neutral loss of water.", true},
    {MS_NH3_neutral_loss_OBSOLETE, "MS:1002456", "NH3 neutral loss", "Neutral loss of ammonia.", true},
    {MS_H3PO4_neutral_loss_OBSOLETE, "MS:1002457", "H3PO4 neutral loss", "Neutral loss of phosphoric acid.", true},
    {MS_PeptideShaker, "MS:1002458", "PeptideShaker", "PeptideShaker is a software for the interpretation of proteomics identification results.", false},
    {MS_MS_Amanda_csv_format, "MS:1002459", "MS Amanda csv format", "MS Amanda csv output format.", false},
    {MS_protein_group_level_global_FNR, "MS:1002460", "protein group-level global FNR", "Estimation of the global false negative rate of protein groups.", false},
    {MS_protein_group_level_confidence, "MS:1002461", "protein group-level confidence", "Estimation of the global confidence of protein groups.", false},
    {MS_peptide_sequence_level_global_FNR, "MS:1002462", "peptide sequence-level global FNR", "Estimation of the global false negative rate for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_peptide_sequence_level_global_confidence, "MS:1002463", "peptide sequence-level global confidence", "Estimation of the global confidence for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).", false},
    {MS_PSM_level_global_FNR, "MS:1002464", "PSM-level global FNR", "Estimation of the global false negative rate of peptide spectrum matches.", false},
    {MS_PSM_level_global_confidence, "MS:1002465", "PSM-level global confidence", "Estimation of the global confidence of peptide spectrum matches.", false},
    {MS_PeptideShaker_PSM_score, "MS:1002466", "PeptideShaker PSM score", "The probability based PeptideShaker PSM score.", false},
    {MS_PeptideShaker_PSM_confidence, "MS:1002467", "PeptideShaker PSM confidence", "The probability based PeptideShaker PSM confidence.", false},
    {MS_PeptideShaker_peptide_score, "MS:1002468", "PeptideShaker peptide score", "The probability based PeptideShaker peptide score.", false},
    {MS_PeptideShaker_peptide_confidence, "MS:1002469", "PeptideShaker peptide confidence", "The probability based PeptideShaker peptide confidence.", false},
    {MS_PeptideShaker_protein_group_score, "MS:1002470", "PeptideShaker protein group score", "The probability based PeptideShaker protein group score.", false},
    {MS_PeptideShaker_protein_group_confidence, "MS:1002471", "PeptideShaker protein group confidence", "The probability based PeptideShaker protein group confidence.", false},
    {MS_trap_type_collision_induced_dissociation, "MS:1002472", "trap-type collision-induced dissociation", "A collision-induced dissociation process that occurs in a trap-type collision cell.", false},
    {MS_ion_series_considered_in_search, "MS:1002473", "ion series considered in search", "The description of the ion fragment series (including charges and neutral losses) that are considered by the search engine.", false},
    {MS_ProteoAnnotator_non_canonical_gene_model_score, "MS:1002474", "ProteoAnnotator:non-canonical gene model score", "The sum of peptide-level scores for peptides mapped only to non-canonical gene models within the group.", false},
    {MS_ProteoAnnotator_count_alternative_peptides, "MS:1002475", "ProteoAnnotator:count alternative peptides", "The count of the number of peptide sequences mapped to non-canonical gene models only within the group.", false},
    {MS_ion_mobility_drift_time, "MS:1002476", "ion mobility drift time", "Drift time of an ion or spectrum of ions as measured in an ion mobility mass spectrometer. This time might refer to the central value of a bin into which all ions within a narrow range of drift time have been aggregated.", false},
    {MS_mean_ion_mobility_drift_time_array, "MS:1002477", "mean ion mobility drift time array", "Array of population mean ion mobility values from a drift time device, reported in seconds (or milliseconds), corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_mean_charge_array, "MS:1002478", "mean charge array", "Array of mean charge values where the mean charge is calculated as a weighted mean of the charges of individual peaks that are aggregated into a processed spectrum.", false},
    {MS_regular_expression, "MS:1002479", "regular expression", "Regular expression.", false},
    {MS_regular_expression_for_a_digital_object_identifier__DOI_, "MS:1002480", "regular expression for a digital object identifier (DOI)", "(10[.][0-9]\\{4,\\}(?:[.][0-9]+)*/(?:(?![\\\"&\\'<>])[^ \\t\\\\r\\n\\\\v\\\\f])+).", false},
    {MS_higher_energy_beam_type_collision_induced_dissociation, "MS:1002481", "higher energy beam-type collision-induced dissociation", "A collision-induced dissociation process wherein the projectile ion has the translational energy higher than approximately 1000 eV.", false},
    {MS_statistical_threshold, "MS:1002482", "statistical threshold", "Estimated statistical threshold.", false},
    {MS_PSM_level_statistical_threshold, "MS:1002483", "PSM-level statistical threshold", "Estimated statistical threshold at PSM-level.", false},
    {MS_peptide_level_statistical_threshold, "MS:1002484", "peptide-level statistical threshold", "Estimated statistical threshold at peptide-level.", false},
    {MS_protein_level_statistical_threshold, "MS:1002485", "protein-level statistical threshold", "Estimated statistical threshold at protein-level.", false},
    {MS_protein_group_level_statistical_threshold, "MS:1002486", "protein group-level statistical threshold", "Estimated statistical threshold at protein group-level.", false},
    {MS_MassIVE_dataset_identifier, "MS:1002487", "MassIVE dataset identifier", "Dataset identifier issued by the MassIVE repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_MassIVE_dataset_URI, "MS:1002488", "MassIVE dataset URI", "URI that allows the access to one dataset in the MassIVE repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_special_processing, "MS:1002489", "special processing", "Details describing a special processing.", false},
    {MS_peptide_level_scoring, "MS:1002490", "peptide-level scoring", "Peptide-level scoring performed.", false},
    {MS_modification_localization_scoring, "MS:1002491", "modification localization scoring", "Modification localization scoring performed.", false},
    {MS_consensus_scoring, "MS:1002492", "consensus scoring", "Consensus multiple search engine approach performed.", false},
    {MS_sample_pre_fractionation, "MS:1002493", "sample pre-fractionation", "Sample pre-fractionation performed.", false},
    {MS_crosslinking_search, "MS:1002494", "crosslinking search", "Crosslinking search performed.", false},
    {MS_no_special_processing, "MS:1002495", "no special processing", "No special processing performed.", false},
    {MS_group_PSMs_by_sequence, "MS:1002496", "group PSMs by sequence", "Group PSMs by distinct peptide sequence ignoring modifications.", false},
    {MS_group_PSMs_by_sequence_with_modifications, "MS:1002497", "group PSMs by sequence with modifications", "Group PSMs by distinct peptide sequence with taking modifications into account.", false},
    {MS_group_PSMs_by_sequence_with_modifications_and_charge, "MS:1002498", "group PSMs by sequence with modifications and charge", "Group PSMs by distinct peptide sequence with taking modifications and charge into account.", false},
    {MS_peptide_level_score_OBSOLETE, "MS:1002499", "peptide level score", "Peptide level score.", true},
    {MS_peptide_passes_threshold, "MS:1002500", "peptide passes threshold", "A Boolean attribute to determine whether the peptide has passed the threshold indicated in the file.", false},
    {MS_no_PSM_threshold, "MS:1002501", "no PSM threshold", "Indicating that no PSM threshold was used.", false},
    {MS_no_peptide_level_threshold, "MS:1002502", "no peptide-level threshold", "Indicating that no peptide-level threshold was used.", false},
    {MS_PSM_is_used_for_peptide_level_scoring, "MS:1002503", "PSM is used for peptide-level scoring", "Flags a PSM that it is used for peptide-level scoring.", false},
    {MS_modification_index, "MS:1002504", "modification index", "The order of modifications to be referenced elsewhere in the document.", false},
    {MS_regular_expression_for_modification_localization_scoring, "MS:1002505", "regular expression for modification localization scoring", "(?<MOD_INDEX>[0-9]+):(?<SCORE>[01][.][0-9]+(?:[Ee][+\\-]?[0-9]+)?):(?<POSITION>[0-9]+(?:[|][0-9]+)*):(?<PASS_THRESHOLD>true|false)", false},
    {MS_modification_position_score, "MS:1002506", "modification position score", "Modification position score.", false},
    {MS_modification_rescoring_false_localization_rate, "MS:1002507", "modification rescoring:false localization rate", "Mod position score: false localization rate.", false},
    {MS_crosslinking_attribute, "MS:1002508", "crosslinking attribute", "Crosslinking attribute.", false},
    {MS_crosslink_donor, "MS:1002509", "crosslink donor", "The  crosslinking donor, assigned according to the following rules: the export software SHOULD use the following rules to choose the crosslink donor as the: longer peptide, then higher peptide neutral mass, then alphabetical order.", false},
    {MS_crosslink_acceptor, "MS:1002510", "crosslink acceptor", "Crosslinking acceptor, assigned according to the following rules: the export software SHOULD use the following rules to choose the crosslink donor as the: longer peptide, then higher peptide neutral mass, then alphabetical order.", false},
    {MS_crosslink_spectrum_identification_item, "MS:1002511", "crosslink spectrum identification item", "Crosslinked spectrum identification item.", false},
    {MS_crosslinking_score, "MS:1002512", "crosslinking score", "Crosslinking scoring value.", false},
    {MS_molecules_per_cell, "MS:1002513", "molecules per cell", "The absolute abundance of protein in a cell.", false},
    {MS_absolute_quantitation_analysis, "MS:1002514", "absolute quantitation analysis", "Absolute quantitation analysis.", false},
    {MS_internal_peptide_reference_used, "MS:1002515", "internal peptide reference used", "States whether an internal peptide reference is used or not in absolute quantitation analysis.", false},
    {MS_internal_protein_reference_used, "MS:1002516", "internal protein reference used", "States whether an internal protein reference is used or not in absolute quantitation analysis.", false},
    {MS_internal_reference_abundance, "MS:1002517", "internal reference abundance", "The absolute abundance of the spiked in reference peptide or protein used for absolute quantitation analysis.", false},
    {MS_Progenesis_protein_group_normalised_abundance, "MS:1002518", "Progenesis:protein group normalised abundance", "The data type normalised abundance for protein groups produced by Progenesis LC-MS.", false},
    {MS_Progenesis_protein_group_raw_abundance, "MS:1002519", "Progenesis:protein group raw abundance", "The data type raw abundance for protein groups produced by Progenesis LC-MS.", false},
    {MS_peptide_group_ID, "MS:1002520", "peptide group ID", "Peptide group identifier for peptide-level stats.", false},
    {MS_mass_spectrometry_imaging, "MS:1002521", "mass spectrometry imaging", "A technique in which mass spectra are acquired in a spatially resolved manner. This is typically achieved by scanning a laser or primary ion beam over a sample and acquiring a mass spectrum at each position.", false},
    {MS_ProteomeDiscoverer_1__Static_Terminal_Modification, "MS:1002522", "ProteomeDiscoverer:1. Static Terminal Modification", "Determine 1st static terminal post-translational modifications (PTMs).", false},
    {MS_Q_Exactive_HF, "MS:1002523", "Q Exactive HF", "Thermo Scientific Q Exactive.", false},
    {MS_PepFinder, "MS:1002524", "PepFinder", "Thermo Scientific PepFinder BioPharma analysis software.", false},
    {MS_TSQ_8000_Evo, "MS:1002525", "TSQ 8000 Evo", "Thermo Scientific TSQ 8000 Evo MS.", false},
    {MS_Exactive_Plus, "MS:1002526", "Exactive Plus", "Thermo Scientific Exactive Plus MS.", false},
    {MS_instrument_specific_scan_attribute, "MS:1002527", "instrument specific scan attribute", "Instrument specific scan properties that are associated with a value.", false},
    {MS_synchronous_prefilter_selection, "MS:1002528", "synchronous prefilter selection", "Synchronous prefilter selection.", false},
    {MS_resolution_array, "MS:1002529", "resolution array", "A data array of resolution values.", false},
    {MS_baseline_array, "MS:1002530", "baseline array", "A data array of signal baseline values (the signal in the absence of analytes).", false},
    {MS_UIMF_format, "MS:1002531", "UIMF format", "SQLite-based file format created at Pacific Northwest National Lab. It stores an intermediate analysis of ion-mobility mass spectrometry data.", false},
    {MS_UIMF_nativeID_format, "MS:1002532", "UIMF nativeID format", "Native format defined by frame=xsd:nonNegativeInteger scan=xsd:nonNegativeInteger frameType=xsd:nonNegativeInteger.", false},
    {MS_TripleTOF_6600, "MS:1002533", "TripleTOF 6600", "SCIEX TripleTOF 6600, a quadrupole - quadrupole - time-of-flight mass spectrometer.", false},
    {MS_ProLuCID_xcorr, "MS:1002534", "ProLuCID:xcorr", "The ProLuCID result 'XCorr'.", false},
    {MS_ProLuCID_deltacn, "MS:1002535", "ProLuCID:deltacn", "The ProLuCID result 'DeltaCn'.", false},
    {MS_D_Score, "MS:1002536", "D-Score", "D-Score for PTM site location at the PSM-level.", false},
    {MS_MD_Score, "MS:1002537", "MD-Score", "MD-Score for PTM site location at the PSM-level.", false},
    {MS_PTM_localization_confidence_metric, "MS:1002538", "PTM localization confidence metric", "Localization confidence metric for a post translational modification (PTM).", false},
    {MS_PeptideShaker_PTM_confidence_type, "MS:1002539", "PeptideShaker PTM confidence type", "PeptideShaker quality criteria for the confidence of PTM localizations.", false},
    {MS_PeptideShaker_PSM_confidence_type, "MS:1002540", "PeptideShaker PSM confidence type", "PeptideShaker quality criteria for the confidence of PSM's.", false},
    {MS_PeptideShaker_peptide_confidence_type, "MS:1002541", "PeptideShaker peptide confidence type", "PeptideShaker quality criteria for the confidence of peptide identifications.", false},
    {MS_PeptideShaker_protein_confidence_type, "MS:1002542", "PeptideShaker protein confidence type", "PeptideShaker quality criteria for the confidence of protein identifications.", false},
    {MS_xiFDR, "MS:1002543", "xiFDR", "Target/Decoy based FDR estimation for crosslinking peptide-identifications.", false},
    {MS_xi, "MS:1002544", "xi", "Search engine for crosslinked peptides.", false},
    {MS_xi_score, "MS:1002545", "xi:score", "The xi result 'Score'.", false},
    {MS_Skyline_mzQuantML_converter, "MS:1002546", "Skyline mzQuantML converter", "A software package to convert Skyline report to mzQuantML.", false},
    {MS_normalized_spectral_abundance_factor, "MS:1002547", "normalized spectral abundance factor", "A normalized spectral abundance factor (NSAF).", false},
    {MS_distributed_normalized_spectral_abundance_factor, "MS:1002548", "distributed normalized spectral abundance factor", "A distributed normalized spectral abundance factor (dNSAF).", false},
    {MS_PTM_localization_distinct_peptide_level_statistic, "MS:1002549", "PTM localization distinct peptide-level statistic", "Statistic to convey the confidence of the localization of an amino acid modification on a peptide sequence.", false},
    {MS_peptide_phosphoRS_score, "MS:1002550", "peptide:phosphoRS score", "phosphoRS score for PTM site location at the peptide-level.", false},
    {MS_peptide_Ascore, "MS:1002551", "peptide:Ascore", "A-score for PTM site location at the peptide-level.", false},
    {MS_peptide_H_Score, "MS:1002552", "peptide:H-Score", "H-Score for peptide phosphorylation site location at the peptide-level.", false},
    {MS_peptide_D_Score, "MS:1002553", "peptide:D-Score", "D-Score for PTM site location at the peptide-level.", false},
    {MS_peptide_MD_Score, "MS:1002554", "peptide:MD-Score", "MD-Score for PTM site location at the peptide-level.", false},
    {MS_PTM_localization_score_threshold, "MS:1002555", "PTM localization score threshold", "Threshold for PTM site location score.", false},
    {MS_Ascore_threshold, "MS:1002556", "Ascore threshold", "Threshold for Ascore PTM site location score.", false},
    {MS_D_Score_threshold, "MS:1002557", "D-Score threshold", "Threshold for D-score PTM site location score.", false},
    {MS_MD_Score_threshold, "MS:1002558", "MD-Score threshold", "Threshold for MD-score PTM site location score.", false},
    {MS_H_Score_threshold, "MS:1002559", "H-Score threshold", "Threshold for H-score PTM site location score.", false},
    {MS_DeBunker_score_threshold, "MS:1002560", "DeBunker:score threshold", "Threshold for DeBunker PTM site location score.", false},
    {MS_Mascot_PTM_site_assignment_confidence_threshold, "MS:1002561", "Mascot:PTM site assignment confidence threshold", "Threshold for Mascot PTM site assignment confidence.", false},
    {MS_MSQuant_PTM_score_threshold, "MS:1002562", "MSQuant:PTM-score threshold", "Threshold for MSQuant:PTM-score.", false},
    {MS_MaxQuant_PTM_Score_threshold, "MS:1002563", "MaxQuant:PTM Score threshold", "Threshold for MaxQuant:PTM Score.", false},
    {MS_MaxQuant_P_site_localization_probability_threshold, "MS:1002564", "MaxQuant:P-site localization probability threshold", "Threshold for MaxQuant:P-site localization probability.", false},
    {MS_MaxQuant_PTM_Delta_Score_threshold, "MS:1002565", "MaxQuant:PTM Delta Score threshold", "Threshold for MaxQuant:PTM Delta Score.", false},
    {MS_MaxQuant_Phospho__STY__Probabilities_threshold, "MS:1002566", "MaxQuant:Phospho (STY) Probabilities threshold", "Threshold for MaxQuant:Phospho (STY) Probabilities.", false},
    {MS_phosphoRS_score_threshold, "MS:1002567", "phosphoRS score threshold", "Threshold for phosphoRS score.", false},
    {MS_phosphoRS_site_probability_threshold, "MS:1002568", "phosphoRS site probability threshold", "Threshold for phosphoRS site probability.", false},
    {MS_ProteomeDiscoverer_Number_of_Spectra_Processed_At_Once, "MS:1002569", "ProteomeDiscoverer:Number of Spectra Processed At Once", "Number of spectra processed at once in a ProteomeDiscoverer search.", false},
    {MS_sequence_multiply_subsumable_protein, "MS:1002570", "sequence multiply subsumable protein", "A protein for which the matched peptide sequences are the same, or a subset of, the matched peptide sequences for two or more other proteins combined. These other proteins need not all be in the same group.", false},
    {MS_spectrum_multiply_subsumable_protein, "MS:1002571", "spectrum multiply subsumable protein", "A protein for which the matched spectra are the same, or a subset of, the matched spectra for two or more other proteins combined. These other proteins need not all be in the same group.", false},
    {MS_protein_detection_statistical_threshold, "MS:1002572", "protein detection statistical threshold", "Estimated statistical threshold used for protein detection.", false},
    {MS_spectrum_identification_statistical_threshold, "MS:1002573", "spectrum identification statistical threshold", "Estimated statistical threshold used for spectrum identification.", false},
    {MS_ASAPRatio, "MS:1002574", "ASAPRatio", "A program in the TPP that calculates PSM, peptide, and protein-level abundances based on 2-channel isotope-labelled data such as ICAT, SILAC, etc.", false},
    {MS_Tide, "MS:1002575", "Tide", "Tide open-source sequence search program developed at the University of Washington.", false},
    {MS_Andromeda_result_format, "MS:1002576", "Andromeda result format", "Andromeda result file output format.", false},
    {MS_2000_QTRAP, "MS:1002577", "2000 QTRAP", "SCIEX 2000 QTRAP.", false},
    {MS_2500_QTRAP, "MS:1002578", "2500 QTRAP", "SCIEX 2500 QTRAP.", false},
    {MS_3500_QTRAP, "MS:1002579", "3500 QTRAP", "SCIEX 3500 QTRAP.", false},
    {MS_QTRAP_4500, "MS:1002580", "QTRAP 4500", "SCIEX QTRAP 4500.", false},
    {MS_QTRAP_6500, "MS:1002581", "QTRAP 6500", "SCIEX QTRAP 6500.", false},
    {MS_QTRAP_6500_, "MS:1002582", "QTRAP 6500+", "SCIEX QTRAP 6500+.", false},
    {MS_TripleTOF_4600, "MS:1002583", "TripleTOF 4600", "SCIEX TripleTOF 4600 time-of-flight mass spectrometer.", false},
    {MS_TripleTOF_5600_, "MS:1002584", "TripleTOF 5600+", "SCIEX TripleTOF 5600+ time-of-flight mass spectrometer.", false},
    {MS_API_100, "MS:1002585", "API 100", "Applied Biosystems/MDS SCIEX API 100 MS.", false},
    {MS_API_100LC, "MS:1002586", "API 100LC", "Applied Biosystems/MDS SCIEX API 100LC MS.", false},
    {MS_API_165, "MS:1002587", "API 165", "Applied Biosystems/MDS SCIEX API 165 MS.", false},
    {MS_API_300, "MS:1002588", "API 300", "Applied Biosystems/MDS SCIEX API 300 MS.", false},
    {MS_API_350, "MS:1002589", "API 350", "Applied Biosystems/MDS SCIEX API 350 MS.", false},
    {MS_API_365, "MS:1002590", "API 365", "Applied Biosystems/MDS SCIEX API 365 MS.", false},
    {MS_Triple_Quad_3500, "MS:1002591", "Triple Quad 3500", "SCIEX Triple Quad 3500.", false},
    {MS_Triple_Quad_4500, "MS:1002592", "Triple Quad 4500", "SCIEX Triple Quad 4500.", false},
    {MS_Triple_Quad_5500, "MS:1002593", "Triple Quad 5500", "SCIEX Triple Quad 5500.", false},
    {MS_Triple_Quad_6500, "MS:1002594", "Triple Quad 6500", "SCIEX Triple Quad 6500.", false},
    {MS_Triple_Quad_6500_, "MS:1002595", "Triple Quad 6500+", "SCIEX Triple Quad 6500+.", false},
    {MS_ProLuCID, "MS:1002596", "ProLuCID", "The SEQUEST-like sequence search engine ProLuCID, developed in the Yates Lab at the Scripps Research Institute.", false},
    {MS_MS1_format, "MS:1002597", "MS1 format", "MS1 file format for MS1 spectral data.", false},
    {MS_DTASelect, "MS:1002598", "DTASelect", "Analysis software designed to reassemble the SEQUEST peptide identifications and to highlight the most significant matches.", false},
    {MS_splash_key, "MS:1002599", "splash key", "Spectral Hash key, an unique identifier for spectra.", false},
    {MS_PRIDE_XML, "MS:1002600", "PRIDE XML", "Internal data and submission format of the PRIDE database.", false},
    {MS_mzTab, "MS:1002601", "mzTab", "Tabular result format for proteomics and metabolomics experiments.", false},
    {MS_sample_label, "MS:1002602", "sample label", "Reagent used in labeled quantification methods.", false},
    {MS_ICAT_reagent, "MS:1002603", "ICAT reagent", "Isotope coded affinity tag reagent.", false},
    {MS_ICAT_heavy_reagent, "MS:1002604", "ICAT heavy reagent", "The name of the sample labelled with the heavy ICAT label.", false},
    {MS_ICAT_light_reagent, "MS:1002605", "ICAT light reagent", "The name of the sample labelled with the light ICAT label.", false},
    {MS_ICPL_reagent, "MS:1002606", "ICPL reagent", "Isotope coded protein labeling reagent.", false},
    {MS_ICPL_reagent_0, "MS:1002607", "ICPL reagent 0", "The name of the sample labelled with the ICPL reagent 0.", false},
    {MS_ICPL_reagent_4, "MS:1002608", "ICPL reagent 4", "The name of the sample labelled with the ICPL reagent 4.", false},
    {MS_ICPL_reagent_6, "MS:1002609", "ICPL reagent 6", "The name of the sample labelled with the ICPL reagent 6.", false},
    {MS_ICPL_reagent_10, "MS:1002610", "ICPL reagent 10", "The name of the sample labelled with the ICPL reagent 10.", false},
    {MS_SILAC_reagent, "MS:1002611", "SILAC reagent", "Stable isotope labeling with amino acids in cell culture reagent.", false},
    {MS_SILAC_heavy_reagent, "MS:1002612", "SILAC heavy reagent", "The name of the sample labelled with the heavy SILAC label.", false},
    {MS_SILAC_medium_reagent, "MS:1002613", "SILAC medium reagent", "The name of the sample labelled with the medium SILAC label.", false},
    {MS_SILAC_light_reagent, "MS:1002614", "SILAC light reagent", "The name of the sample labelled with the light SILAC label.", false},
    {MS_TMT_reagent, "MS:1002615", "TMT reagent", "Tandem mass tag reagent used in TMT, glycoTMT, iodoTMT, aminoxyTMT or hydrazideTMT isobaric labeling.", false},
    {MS_TMT_reagent_126, "MS:1002616", "TMT reagent 126", "The name of the sample labelled with the TMT reagent 126.", false},
    {MS_TMT_reagent_127, "MS:1002617", "TMT reagent 127", "The name of the sample labelled with the TMT reagent 127.", false},
    {MS_TMT_reagent_128, "MS:1002618", "TMT reagent 128", "The name of the sample labelled with the TMT reagent 128.", false},
    {MS_TMT_reagent_129, "MS:1002619", "TMT reagent 129", "The name of the sample labelled with the TMT reagent 129.", false},
    {MS_TMT_reagent_130, "MS:1002620", "TMT reagent 130", "The name of the sample labelled with the TMT reagent 130.", false},
    {MS_TMT_reagent_131, "MS:1002621", "TMT reagent 131", "The name of the sample labelled with the TMT reagent 131.", false},
    {MS_iTRAQ_reagent, "MS:1002622", "iTRAQ reagent", "Isobaric tag for relative and absolute quantitation (iTRAQ or iTRAQH) reagent.", false},
    {MS_iTRAQ_reagent_113, "MS:1002623", "iTRAQ reagent 113", "The name of the sample labelled with the iTRAQ reagent 113.", false},
    {MS_iTRAQ_reagent_114, "MS:1002624", "iTRAQ reagent 114", "The name of the sample labelled with the iTRAQ reagent 114.", false},
    {MS_iTRAQ_reagent_115, "MS:1002625", "iTRAQ reagent 115", "The name of the sample labelled with the iTRAQ reagent 115.", false},
    {MS_iTRAQ_reagent_116, "MS:1002626", "iTRAQ reagent 116", "The name of the sample labelled with the iTRAQ reagent 116.", false},
    {MS_iTRAQ_reagent_117, "MS:1002627", "iTRAQ reagent 117", "The name of the sample labelled with the iTRAQ reagent 117.", false},
    {MS_iTRAQ_reagent_118, "MS:1002628", "iTRAQ reagent 118", "The name of the sample labelled with the iTRAQ reagent 118.", false},
    {MS_iTRAQ_reagent_119, "MS:1002629", "iTRAQ reagent 119", "The name of the sample labelled with the iTRAQ reagent 119.", false},
    {MS_iTRAQ_reagent_121, "MS:1002630", "iTRAQ reagent 121", "The name of the sample labelled with the iTRAQ reagent 121.", false},
    {MS_electron_transfer_higher_energy_collision_dissociation, "MS:1002631", "electron-transfer/higher-energy collision dissociation", "Dissociation process combining electron-transfer dissociation and higher-energy collision dissociation. It combines ETD (reaction time) followed by HCD (activation energy).", false},
    {MS_jPOST_dataset_identifier, "MS:1002632", "jPOST dataset identifier", "Dataset identifier issued by the jPOST repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_jPOST_dataset_URI, "MS:1002633", "jPOST dataset URI", "URI that allows the access to one dataset in the jPOST repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_Q_Exactive_Plus, "MS:1002634", "Q Exactive Plus", "Thermo Scientific Q Exactive Plus.", false},
    {MS_proteogenomics_search, "MS:1002635", "proteogenomics search", "Proteogenomics search performed.", false},
    {MS_proteogenomics_attribute, "MS:1002636", "proteogenomics attribute", "Proteogenomics attribute.", false},
    {MS_chromosome_name, "MS:1002637", "chromosome name", "The name or number of the chromosome to which a given peptide has been mapped.", false},
    {MS_chromosome_strand, "MS:1002638", "chromosome strand", "The strand (+ or -) to which the peptide has been mapped.", false},
    {MS_peptide_start_on_chromosome_OBSOLETE, "MS:1002639", "peptide start on chromosome", "The overall start position on the chromosome to which a peptide has been mapped i.e. the position of the first base of the first codon, using a zero-based counting system.", true},
    {MS_peptide_end_on_chromosome, "MS:1002640", "peptide end on chromosome", "The overall end position on the chromosome to which a peptide has been mapped i.e. the position of the third base of the last codon, using a zero-based counting system.", false},
    {MS_peptide_exon_count, "MS:1002641", "peptide exon count", "The number of exons to which the peptide has been mapped.", false},
    {MS_peptide_exon_nucleotide_sizes, "MS:1002642", "peptide exon nucleotide sizes", "A comma separated list of the number of DNA bases within each exon to which a peptide has been mapped. Assuming standard operation of a search engine, the peptide exon sizes should sum to exactly three times the peptide length.", false},
    {MS_peptide_start_positions_on_chromosome, "MS:1002643", "peptide start positions on chromosome", "A comma separated list of start positions within exons to which the peptide has been mapped, relative to peptide-chromosome start, assuming a zero-based counting system. The first value MUST match the value in peptide start on chromosome.", false},
    {MS_genome_reference_version, "MS:1002644", "genome reference version", "The reference genome and versioning string as used for mapping. All coordinates are within this frame of reference.", false},
    {MS_MSDK, "MS:1002645", "MSDK", "Mass Spectrometry Development Kit (MSDK) is a Java library of algorithms for processing of mass spectrometry data.", false},
    {MS_native_spectrum_identifier_format__combined_spectra, "MS:1002646", "native spectrum identifier format, combined spectra", "Describes how the native spectrum identifiers that have been combined prior to searching or interpretation are formated.", false},
    {MS_Thermo_nativeID_format__combined_spectra, "MS:1002647", "Thermo nativeID format, combined spectra", "Thermo comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_Waters_nativeID_format__combined_spectra, "MS:1002648", "Waters nativeID format, combined spectra", "Waters comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_WIFF_nativeID_format__combined_spectra, "MS:1002649", "WIFF nativeID format, combined spectra", "WIFF comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_Bruker_Agilent_YEP_nativeID_format__combined_spectra, "MS:1002650", "Bruker/Agilent YEP nativeID format, combined spectra", "Bruker/Agilent comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_Bruker_BAF_nativeID_format__combined_spectra, "MS:1002651", "Bruker BAF nativeID format, combined spectra", "Bruker BAF comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_Bruker_FID_nativeID_format__combined_spectra, "MS:1002652", "Bruker FID nativeID format, combined spectra", "Bruker FID comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_multiple_peak_list_nativeID_format__combined_spectra, "MS:1002653", "multiple peak list nativeID format, combined spectra", "Comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_single_peak_list_nativeID_format__combined_spectra, "MS:1002654", "single peak list nativeID format, combined spectra", "Comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_scan_number_only_nativeID_format__combined_spectra, "MS:1002655", "scan number only nativeID format, combined spectra", "Comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_spectrum_identifier_nativeID_format__combined_spectra, "MS:1002656", "spectrum identifier nativeID format, combined spectra", "Comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_mzML_unique_identifier__combined_spectra, "MS:1002657", "mzML unique identifier, combined spectra", "Comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_identification_parameter, "MS:1002658", "identification parameter", "Identification parameter for the search engine run.", false},
    {MS_UniProtKB_text_sequence_format, "MS:1002659", "UniProtKB text sequence format", "Text-based format used by UniProtKB for sequence entries.", false},
    {MS_UniProtKB_XML_sequence_format, "MS:1002660", "UniProtKB XML sequence format", "XML-based format used by UniProtKB for sequence entries.", false},
    {MS_Morpheus, "MS:1002661", "Morpheus", "Morpheus search engine.", false},
    {MS_Morpheus_Morpheus_score, "MS:1002662", "Morpheus:Morpheus score", "Morpheus score for PSMs.", false},
    {MS_Morpheus_summed_Morpheus_score, "MS:1002663", "Morpheus:summed Morpheus score", "Summed Morpheus score for protein groups.", false},
    {MS_interaction_score_derived_from_crosslinking, "MS:1002664", "interaction score derived from crosslinking", "Parent term for interaction scores derived from crosslinking.", false},
    {MS_regular_expression_for_interaction_scores_derived_from_crosslinking, "MS:1002665", "regular expression for interaction scores derived from crosslinking", "((?<int_ID>[0-9]+)[.](?<SUFFIX>[a|b]):(?<POS>[0-9]+|null):(?<SCORE_OR_VALUE>[-+]?[0-9]+(?:[.][0-9]+)?(?:[Ee][-+]?[0-9]+)?):(?<PASS_THRESHOLD>true|false))|(?<SCORE_ONLY>[-+]?[0-9]+(?:[.][0-9]+)?(?:[Ee][-+]?[0-9]+)?)", false},
    {MS_impact_II, "MS:1002666", "impact II", "Bruker Daltonics' impact II.", false},
    {MS_impact_HD, "MS:1002667", "impact HD", "Bruker Daltonics' impact HD.", false},
    {MS_frag__iTRAQ_4plex_reporter_ion, "MS:1002668", "frag: iTRAQ 4plex reporter ion", "Standard reporter ion for iTRAQ 4Plex. The value slot holds the integer mass of the iTRAQ 4Plex reporter ion, e.g. 114.", false},
    {MS_frag__iTRAQ_8plex_reporter_ion, "MS:1002669", "frag: iTRAQ 8plex reporter ion", "Standard reporter ion for iTRAQ 8Plex. The value slot holds the integer mass of the iTRAQ 8Plex reporter ion, e.g. 113.", false},
    {MS_frag__TMT_reporter_ion, "MS:1002670", "frag: TMT reporter ion", "Standard reporter ion for TMT. The value slot holds the integer mass of the TMT reporter ion and can be suffixed with either N or C, indicating whether the mass difference is encoded at a Nitrogen or Carbon atom, e.g. 127N.", false},
    {MS_frag__TMT_ETD_reporter_ion, "MS:1002671", "frag: TMT ETD reporter ion", "Standard reporter ion for TMT with ETD fragmentation. The value slot holds the integer mass of the TMT ETD reporter ion and can be suffixed with either N or C, indicating whether the mass difference is encoded at a Nitrogen or Carbon atom, e.g. 127C.", false},
    {MS_no_modification_threshold, "MS:1002672", "no modification threshold", "No statistical threshold for accepting or rejecting that a modification position.", false},
    {MS_OpenXQuest, "MS:1002673", "OpenXQuest", "Cross-Linking MS search engine.", false},
    {MS_X500R_QTOF, "MS:1002674", "X500R QTOF", "SCIEX X500R QTOF, a quadrupole - quadrupole - time-of-flight mass spectrometer.", false},
    {MS_crosslinking_result_details, "MS:1002675", "crosslinking result details", "This subsection describes terms which can describe details of crosslinking results.", false},
    {MS_protein_pair_level_global_FDR, "MS:1002676", "protein-pair-level global FDR", "Estimation of the global false discovery rate of proteins-pairs in crosslinking experiments.", false},
    {MS_residue_pair_level_global_FDR, "MS:1002677", "residue-pair-level global FDR", "Estimation of the global false discovery rate of residue-pairs in crosslinking experiments.", false},
    {MS_supplemental_beam_type_collision_induced_dissociation, "MS:1002678", "supplemental beam-type collision-induced dissociation", "A supplemental collision-induced dissociation process that occurs in a beam-type collision cell in addition to another primary type of dissociation.", false},
    {MS_supplemental_collision_induced_dissociation, "MS:1002679", "supplemental collision-induced dissociation", "The dissociation of an ion after supplemental collisional excitation.", false},
    {MS_supplemental_collision_energy, "MS:1002680", "supplemental collision energy", "Energy for an ion experiencing supplemental collision with a stationary gas particle resulting in dissociation of the ion.", false},
    {MS_OpenXQuest_combined_score, "MS:1002681", "OpenXQuest:combined score", "OpenXQuest's combined score for a crosslink spectrum match.", false},
    {MS_OpenXQuest_xcorr_xlink, "MS:1002682", "OpenXQuest:xcorr xlink", "OpenXQuest's cross-correlation of crosslinked ions subscore.", false},
    {MS_OpenXQuest_xcorr_common, "MS:1002683", "OpenXQuest:xcorr common", "OpenXQuest's cross-correlation of unlinked ions subscore.", false},
    {MS_OpenXQuest_match_odds, "MS:1002684", "OpenXQuest:match-odds", "OpenXQuest's match-odds subscore.", false},
    {MS_OpenXQuest_intsum, "MS:1002685", "OpenXQuest:intsum", "OpenXQuest's sum of matched peak intensity subscore.", false},
    {MS_OpenXQuest_wTIC, "MS:1002686", "OpenXQuest:wTIC", "OpenXQuest's weighted percent of total ion current subscore.", false},
    {MS_analysis_attribute, "MS:1002687", "analysis attribute", "Attribute of an item in the result of mass spectrometry proteomics data analysis.", false},
    {MS_PTM_localization_attribute, "MS:1002688", "PTM localization attribute", "Statistic derived from a post-translational modification localization analysis.", false},
    {MS_PTM_localization_single_result_statistic, "MS:1002689", "PTM localization single result statistic", "Statistic for a single item derived from a post-translational modification localization analysis.", false},
    {MS_PTM_localization_result_list_statistic, "MS:1002690", "PTM localization result list statistic", "Statistic for all items derived from a post-translational modification localization analysis.", false},
    {MS_global_FLR, "MS:1002691", "global FLR", "Global false localization rate for all localizations in a dataset.", false},
    {MS_local_FLR_at_threshold, "MS:1002692", "local FLR at threshold", "Local false localization rate for the bottom item in list of localizations sorted from most to least confident.", false},
    {MS_identification_attribute, "MS:1002693", "identification attribute", "Attribute of an identification item in the result of mass spectrometry proteomics data analysis.", false},
    {MS_single_identification_result_attribute, "MS:1002694", "single identification result attribute", "Attribute of a single identification item (as opposed to a list) in the result of mass spectrometry proteomics data analysis.", false},
    {MS_frag__isobaric_label_ion, "MS:1002695", "frag: isobaric label ion", "Fragment ion corresponding to an isobaric label artifact.", false},
    {MS_secondary_isotope_peak, "MS:1002697", "secondary isotope peak", "Fragment ion is an isotopic peak other than that monoisotopic peak. This is used in conjuction with another ion type, such as frag: y ion.", false},
    {MS_protein_cluster_identification_attribute, "MS:1002698", "protein cluster identification attribute", "An attribute of the protein cluster concept as used in mzIdentML.", false},
    {MS_result_list_attribute, "MS:1002699", "result list attribute", "General property of an entire result list.", false},
    {MS_PSM_level_result_list_attribute, "MS:1002700", "PSM-level result list attribute", "General property of the list of all PSMs.", false},
    {MS_PSM_level_result_list_statistic, "MS:1002701", "PSM-level result list statistic", "Statistic pertaining to the full list of all PSMs.", false},
    {MS_peptide_sequence_level_result_list_attribute, "MS:1002702", "peptide sequence-level result list attribute", "General property of all peptide sequences in the list.", false},
    {MS_peptide_sequence_level_result_list_statistic, "MS:1002703", "peptide sequence-level result list statistic", "Statistic pertaining to all peptide sequences in the list.", false},
    {MS_protein_level_result_list_attribute, "MS:1002704", "protein-level result list attribute", "Attribute of an entire protein list.", false},
    {MS_protein_level_result_list_statistic, "MS:1002705", "protein-level result list statistic", "A statistical metric of an entire protein list.", false},
    {MS_protein_group_level_result_list_statistic, "MS:1002706", "protein group-level result list statistic", "Attrbiute of an entire list of protein groups.", false},
    {MS_____KR__, "MS:1002707", "(?=[KR])", "Regular expression for LysargiNase.", false},
    {MS_LysargiNase, "MS:1002708", "LysargiNase", "Metalloproteinase found in Methanosarcina acetivorans that cleaves on the N-terminal side of lysine and arginine residues.", false},
    {MS_compound_data_type, "MS:1002709", "compound data type", "A data type representing more than a single value.", false},
    {MS_list_of_type, "MS:1002710", "list of type", "A data type defining a list of values of a single type.", false},
    {MS_list_of_strings, "MS:1002711", "list of strings", "A list of xsd:string.", false},
    {MS_list_of_integers, "MS:1002712", "list of integers", "A list of xsd:integer.", false},
    {MS_list_of_floats, "MS:1002713", "list of floats", "A list of xsd:float.", false},
    {MS_FLASHDeconv, "MS:1002714", "FLASHDeconv", "Ultrafast, High-Quality Feature Deconvolution for Top-Down Proteomics.", false},
    {MS_Pegasus_BT, "MS:1002719", "Pegasus BT", "LECO bench-top GC time-of-flight mass spectrometer.", false},
    {MS_MSPathFinder, "MS:1002720", "MSPathFinder", "PNNL top-down/bottom-up analysis software for identifying peptides and proteoforms in fragmentation mass spectra.", false},
    {MS_MSPathFinder_SpecEValue, "MS:1002721", "MSPathFinder:SpecEValue", "MSPathFinder spectral E-value.", false},
    {MS_MSPathFinder_EValue, "MS:1002722", "MSPathFinder:EValue", "MSPathFinder E-value.", false},
    {MS_MSPathFinder_QValue, "MS:1002723", "MSPathFinder:QValue", "MSPathFinder Q-value.", false},
    {MS_MSPathFinder_PepQValue, "MS:1002724", "MSPathFinder:PepQValue", "MSPathFinder peptide-level Q-value.", false},
    {MS_MSPathFinder_RawScore, "MS:1002725", "MSPathFinder:RawScore", "MSPathFinder raw score.", false},
    {MS_SYNAPT_G2_Si, "MS:1002726", "SYNAPT G2-Si", "Waters Corporation SYNAPT G2-Si orthogonal acceleration time-of-flight mass spectrometer.", false},
    {MS_MALDI_SYNAPT_G2_Si, "MS:1002727", "MALDI SYNAPT G2-Si", "Waters Corporation MALDI SYNAPT G2-Si orthogonal acceleration time-of-flight mass spectrometer.", false},
    {MS_Vion_IMS_QTof, "MS:1002728", "Vion IMS QTof", "Waters Corporation Vion IMS QTof orthogonal acceleration time-of-flight mass spectrometer.", false},
    {MS_Xevo_G2_XS_Tof, "MS:1002729", "Xevo G2-XS Tof", "Waters Corporation Xevo G2 XS Tof orthogonal acceleration time-of-flight mass spectrometer.", false},
    {MS_Xevo_TQ_XS, "MS:1002730", "Xevo TQ-XS", "Waters Corporation Xevo TQ-XS triple quadrupole mass spectrometer.", false},
    {MS_Xevo_TQ_S_micro, "MS:1002731", "Xevo TQ-S micro", "Waters Corporation Xevo TQ-S micro triple quadrupole mass spectrometer.", false},
    {MS_Orbitrap_Fusion_Lumos, "MS:1002732", "Orbitrap Fusion Lumos", "Thermo Scientific Orbitrap Fusion Lumos mass spectrometer with Tribrid architecture consisting of quadrupole mass filter, linear ion trap and Orbitrap mass analyzers.", false},
    {MS_peptide_level_spectral_count, "MS:1002733", "peptide-level spectral count", "The number of MS2 spectra identified for a peptide sequence specified by the amino acid one-letter codes plus optional PTMs in spectral counting.", false},
    {MS_peptide_ion_level_spectral_count, "MS:1002734", "peptide ion-level spectral count", "The number of MS2 spectra identified for a molecular ion defined by the peptide sequence represented by the amino acid one-letter codes, plus optional PTMs plus optional charged aducts plus the charge state, in spectral counting.", false},
    {MS_feature_level_quantification_datatype, "MS:1002735", "feature-level quantification datatype", "The data type of the value reported in a QuantLayer for a feature.", false},
    {MS_PSM_level_quantification_datatype, "MS:1002736", "PSM-level quantification datatype", "The data type of the value reported in a QuantLayer for a PSM.", false},
    {MS_peptide_level_quantification_datatype, "MS:1002737", "peptide-level quantification datatype", "The data type of the value reported in a QuantLayer for a peptide.", false},
    {MS_protein_level_quantification_datatype, "MS:1002738", "protein-level quantification datatype", "The data type of the value reported in a QuantLayer for a protein.", false},
    {MS_protein_group_level_quantification_datatype, "MS:1002739", "protein group-level quantification datatype", "The data type of the value reported in a QuantLayer for a protein group.", false},
    {MS_unmapped_peptide, "MS:1002740", "unmapped peptide", "Within the context of a proteogenomics approach, a peptide sequence that has not been mapped to a genomic location.", false},
    {MS_unmapped_protein, "MS:1002741", "unmapped protein", "Within the context of a proteogenomics approach, a protein sequence that has not been mapped to a genomic location.", false},
    {MS_noise_array, "MS:1002742", "noise array", "A data array of noise values.", false},
    {MS_sampled_noise_m_z_array, "MS:1002743", "sampled noise m/z array", "A data array of parallel, independent m/z values for a sampling of noise across a spectrum (typically much smaller than MS:1000514, the m/z array).", false},
    {MS_sampled_noise_intensity_array, "MS:1002744", "sampled noise intensity array", "A data array of intensity values for the amplitude of noise variation superposed on the baseline (MS:1002745) across a spectrum (for use with MS:1002743, sampled noise m/z array).", false},
    {MS_sampled_noise_baseline_array, "MS:1002745", "sampled noise baseline array", "A data array of baseline intensity values (the intensity in the absence of analytes) for a sampling of noise across a spectrum (for use with MS:1002743, sampled noise m/z array).", false},
    {MS_MS_Numpress_linear_prediction_compression_followed_by_zlib_compression, "MS:1002746", "MS-Numpress linear prediction compression followed by zlib compression", "Compression using MS-Numpress linear prediction compression and zlib.", false},
    {MS_MS_Numpress_positive_integer_compression_followed_by_zlib_compression, "MS:1002747", "MS-Numpress positive integer compression followed by zlib compression", "Compression using MS-Numpress positive integer compression and zlib.", false},
    {MS_MS_Numpress_short_logged_float_compression_followed_by_zlib_compression, "MS:1002748", "MS-Numpress short logged float compression followed by zlib compression", "Compression using MS-Numpress short logged float compression and zlib.", false},
    {MS_Mascot_IntegratedSpectralLibrarySearch, "MS:1002749", "Mascot:IntegratedSpectralLibrarySearch", "Means that Mascot has integrated the search results of database and spectral library search into a single data set.", false},
    {MS_NIST_MSPepSearch, "MS:1002750", "NIST MSPepSearch", "Search tool of the NIST (National Institute of Standards and Technology) for spectral library searches.", false},
    {MS_NIST_MSP_format, "MS:1002751", "NIST MSP format", "MSP text format defined by the NIST.", false},
    {MS_database_type_spectral_library, "MS:1002752", "database type spectral library", "Database containing spectra.", false},
    {MS_value_between_0_and_1000_inclusive, "MS:1002753", "value between 0 and 1000 inclusive", "Value range for scores.", false},
    {MS_MSPepSearch_score, "MS:1002754", "MSPepSearch:score", "MSPepSearch score (0 for entirely dissimilar and 1000 for identical observed spectrum and library spectrum.", false},
    {MS_combined_ms_ms___spectral_library_search, "MS:1002755", "combined ms-ms + spectral library search", "A combined MS2 (with fragment ions) and spectral library search.", false},
    {MS_iodoTMT_quantitation_analysis, "MS:1002756", "iodoTMT quantitation analysis", "Quantitation analysis using the Thermo Fisher sulfhydryl-reactive iodo tandem mass tag (iodoTMT) labelling workflow.", false},
    {MS_glyco_TMT_quantitation_analysis, "MS:1002757", "glyco-TMT quantitation analysis", "Quantitation analysis using the Thermo Fisher carbonyl-reactive glyco-tandem mass tag (glyco-TMT) labelling workflow.", false},
    {MS_aminoxyTMT_quantitation_analysis, "MS:1002758", "aminoxyTMT quantitation analysis", "Quantitation analysis using the Thermo Fisher carbonyl-reactive aminoxy tandem mass tag (aminoxyTMT) labelling workflow.", false},
    {MS_hydrazideTMT_quantitation_analysis, "MS:1002759", "hydrazideTMT quantitation analysis", "Quantitation analysis using the Thermo Fisher carbonyl-reactive hydrazide tandem mass tag (hydrazide-TMT) labelling workflow.", false},
    {MS_iTRAQH_quantitation_analysis, "MS:1002760", "iTRAQH quantitation analysis", "Quantification analysis using the carbonyl-reactive isobaric tags for relative and absolute quantification hydrazide (iTRAQH) labelling workflow.", false},
    {MS_DiART_quantitation_analysis, "MS:1002761", "DiART quantitation analysis", "Quantification analysis using the amine-reactive deuterium isobaric amine reactive tag (DiART) labelling workflow.", false},
    {MS_DiLeu_quantitation_analysis, "MS:1002762", "DiLeu quantitation analysis", "Quantification analysis using the amine-reactive dimethyl leucine (DiLeu) tag labelling workflow.", false},
    {MS_TMT_reagent_127N, "MS:1002763", "TMT reagent 127N", "The name of the sample labelled with the TMT reagent 127N.", false},
    {MS_TMT_reagent_127C, "MS:1002764", "TMT reagent 127C", "The name of the sample labelled with the TMT reagent 127C.", false},
    {MS_TMT_reagent_128N, "MS:1002765", "TMT reagent 128N", "The name of the sample labelled with the TMT reagent 128N.", false},
    {MS_TMT_reagent_128C, "MS:1002766", "TMT reagent 128C", "The name of the sample labelled with the TMT reagent 128C.", false},
    {MS_TMT_reagent_129N, "MS:1002767", "TMT reagent 129N", "The name of the sample labelled with the TMT reagent 129N.", false},
    {MS_TMT_reagent_129C, "MS:1002768", "TMT reagent 129C", "The name of the sample labelled with the TMT reagent 129C.", false},
    {MS_TMT_reagent_130N, "MS:1002769", "TMT reagent 130N", "The name of the sample labelled with the TMT reagent 130N.", false},
    {MS_TMT_reagent_130C, "MS:1002770", "TMT reagent 130C", "The name of the sample labelled with the TMT reagent 130C.", false},
    {MS_DiART_reagent, "MS:1002771", "DiART reagent", "Deuterium isobaric amine reactive tag labeling reagent.", false},
    {MS_DiART_reagent_114, "MS:1002772", "DiART reagent 114", "The name of the sample labelled with the DiART reagent 114.", false},
    {MS_DiART_reagent_115, "MS:1002773", "DiART reagent 115", "The name of the sample labelled with the DiART reagent 115.", false},
    {MS_DiART_reagent_116, "MS:1002774", "DiART reagent 116", "The name of the sample labelled with the DiART reagent 116.", false},
    {MS_DiART_reagent_117, "MS:1002775", "DiART reagent 117", "The name of the sample labelled with the DiART reagent 117.", false},
    {MS_DiART_reagent_118, "MS:1002776", "DiART reagent 118", "The name of the sample labelled with the DiART reagent 118.", false},
    {MS_DiART_reagent_119, "MS:1002777", "DiART reagent 119", "The name of the sample labelled with the DiART reagent 119.", false},
    {MS_DiLeu_reagent, "MS:1002778", "DiLeu reagent", "Dimethyl leucine labeling reagent.", false},
    {MS_DiLeu_reagent_115, "MS:1002779", "DiLeu reagent 115", "The name of the sample labelled with the DiLeu reagent 115.", false},
    {MS_DiLeu_reagent_116, "MS:1002780", "DiLeu reagent 116", "The name of the sample labelled with the DiLeu reagent 116.", false},
    {MS_DiLeu_reagent_117, "MS:1002781", "DiLeu reagent 117", "The name of the sample labelled with the DiLeu reagent 117.", false},
    {MS_DiLeu_reagent_118, "MS:1002782", "DiLeu reagent 118", "The name of the sample labelled with the DiLeu reagent 118.", false},
    {MS_6550_iFunnel_Q_TOF_LC_MS, "MS:1002783", "6550 iFunnel Q-TOF LC/MS", "The 6550 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6550A_iFunnel_Q_TOF_LC_MS, "MS:1002784", "6550A iFunnel Q-TOF LC/MS", "The 6550A Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6520B_Q_TOF_LC_MS, "MS:1002785", "6520B Q-TOF LC/MS", "The 6520B Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6530A_Q_TOF_LC_MS, "MS:1002786", "6530A Q-TOF LC/MS", "The 6530A Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6530B_Q_TOF_LC_MS, "MS:1002787", "6530B Q-TOF LC/MS", "The 6530B Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6538_Q_TOF_LC_MS, "MS:1002788", "6538 Q-TOF LC/MS", "The 6538 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6540_Q_TOF_LC_MS, "MS:1002789", "6540 Q-TOF LC/MS", "The 6540 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6542_Q_TOF_LC_MS, "MS:1002790", "6542 Q-TOF LC/MS", "The 6542 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6545_Q_TOF_LC_MS, "MS:1002791", "6545 Q-TOF LC/MS", "The 6545 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6560_Q_TOF_LC_MS, "MS:1002792", "6560 Q-TOF LC/MS", "The 6560 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6570_Q_TOF_LC_MS, "MS:1002793", "6570 Q-TOF LC/MS", "The 6570 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6120B_Quadrupole_LC_MS, "MS:1002794", "6120B Quadrupole LC/MS", "The 6120B Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 Series of Agilent mass spectrometers.", false},
    {MS_6150_Quadrupole_LC_MS, "MS:1002795", "6150 Quadrupole LC/MS", "The 6150 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 Series of Agilent mass spectrometers.", false},
    {MS_6224_Time_of_Flight_LC_MS, "MS:1002796", "6224 Time-of-Flight LC/MS", "The 6224 Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6230A_Time_of_Flight_LC_MS, "MS:1002797", "6230A Time-of-Flight LC/MS", "The 6230A Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6230B_Time_of_Flight_LC_MS, "MS:1002798", "6230B Time-of-Flight LC/MS", "The 6230B Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer.", false},
    {MS_6430_Triple_Quadrupole_LC_MS, "MS:1002799", "6430 Triple Quadrupole LC/MS", "The 6430 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_6495A_Triple_Quadrupole_LC_MS, "MS:1002800", "6495A Triple Quadrupole LC/MS", "The 6495A Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_6495B_Triple_Quadrupole_LC_MS, "MS:1002801", "6495B Triple Quadrupole LC/MS", "The 6495B Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_7000A_Triple_Quadrupole_GC_MS, "MS:1002802", "7000A Triple Quadrupole GC/MS", "The 7000A Quadrupole GC/MS system is a Agilent gas chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_7000B_Triple_Quadrupole_GC_MS, "MS:1002803", "7000B Triple Quadrupole GC/MS", "The 7000B Quadrupole GC/MS system is a Agilent gas chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.", false},
    {MS_7800_Quadrupole_ICP_MS, "MS:1002804", "7800 Quadrupole ICP-MS", "The 7800 Quadrupole ICP-MS system is a Agilent inductively couple plasma instrument combined with a Agilent quadrupole mass spectrometer.", false},
    {MS_8800_Triple_Quadrupole_ICP_MS, "MS:1002805", "8800 Triple Quadrupole ICP-MS", "The 8800 Quadrupole ICP-MS system is a Agilent inductively couple plasma instrument combined with a Agilent quadrupole mass spectrometer.", false},
    {MS_ion, "MS:1002806", "ion", "Molecular entity having a net positive or negative electric charge.", false},
    {MS_positive_mode_adduct_ion, "MS:1002807", "positive mode adduct ion", "Adduct ion with positive ionization.", false},
    {MS_negative_mode_adduct_ion, "MS:1002808", "negative mode adduct ion", "Adduct ion with negative ionization.", false},
    {MS_adduct_ion_attribute, "MS:1002809", "adduct ion attribute", "Nonphysical characteristic attributed to an adduct ion.", false},
    {MS_adduct_ion_X_m_z, "MS:1002810", "adduct ion X m/z", "Theoretical m/z of the X component in the adduct (addition product) M+X or M-X. This term was formerly called 'adduct ion mass', but it is not really a mass. It corresponds to the column mislabelled as 'mass' at https://fiehnlab.ucdavis.edu/staff/kind/Metabolomics/MS-Adduct-Calculator.", false},
    {MS_adduct_ion_isotope, "MS:1002811", "adduct ion isotope", "Isotope of the matrix molecule M of an adduct formation.", false},
    {MS_Regular_expression_for_adduct_ion_formula, "MS:1002812", "Regular expression for adduct ion formula", "(\\[[:digit:]{0,1}M([+][:digit:]{0,1}(H|K|(Na)|(Li)|(Cl)|(Br)|(NH3)|(NH4)|(CH3OH)|(IsoProp)|(DMSO)|(FA)|(Hac)|(TFA)|(NaCOOH)|(HCOOH)|(CF3COOH)|(ACN))){0,}([-][:digit:]{0,1}(H|(H2O)|(CH2)|(CH4)|(NH3)|(CO)|(CO2)|(COCH2)|(HCOOH)|(C2H4)|(C4H8)|(C3H2O3)|(C5H8O4)|(C6H10O4)|(C6H10O5)|(C6H8O6))){0,}\\][:digit:]{0,1}[+-]).", false},
    {MS_adduct_ion_formula, "MS:1002813", "adduct ion formula", "Adduct formation formula of the form M+X or M-X, as constrained by the provided regular expression.", false},
    {MS_volt_second_per_square_centimeter, "MS:1002814", "volt-second per square centimeter", "An electrical mobility unit that equals the speed [cm/s] an ion reaches when pulled through a gas by a Voltage[V] over a certain distance [cm].", false},
    {MS_inverse_reduced_ion_mobility, "MS:1002815", "inverse reduced ion mobility", "Ion mobility measurement for an ion or spectrum of ions as measured in an ion mobility mass spectrometer. This might refer to the central value of a bin into which all ions within a narrow range of mobilities have been aggregated.", false},
    {MS_mean_ion_mobility_array, "MS:1002816", "mean ion mobility array", "Array of population mean ion mobility values (K or K0) based on ion separation in gaseous phase due to different ion mobilities under an electric field based on ion size, m/z and shape, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_Bruker_TDF_format, "MS:1002817", "Bruker TDF format", "Bruker TDF raw file format.", false},
    {MS_Bruker_TDF_nativeID_format, "MS:1002818", "Bruker TDF nativeID format", "Native format defined by frame=xsd:nonNegativeInteger scan=xsd:nonNegativeInteger.", false},
    {MS_Bruker_TDF_nativeID_format__combined_spectra, "MS:1002819", "Bruker TDF nativeID format, combined spectra", "Bruker TDF comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_M_H_ion_1002820, "MS:1002820", "M+H ion (MS:1002820)", "Adduct formed by protonation of a matrix molecule M, i.e. the addition of a matrix molecule M plus a proton.", false},
    {MS_M_H_ion_1002821, "MS:1002821", "M-H ion (MS:1002821)", "Adduct formed by deprotonation of a matrix molecule M, i.e. the removal of a proton from a matrix molecule M.", false},
    {MS_OpenMS_file_format, "MS:1002822", "OpenMS file format", "File format developed by the OpenMS team.", false},
    {MS_idXML, "MS:1002823", "idXML", "OpenMS intermediate identification format.", false},
    {MS_featureXML, "MS:1002824", "featureXML", "OpenMS feature file format.", false},
    {MS_consensusXML, "MS:1002825", "consensusXML", "OpenMS consensus map format.", false},
    {MS_MetaMorpheus, "MS:1002826", "MetaMorpheus", "MetaMorpheus search engine.", false},
    {MS_MetaMorpheus_score, "MS:1002827", "MetaMorpheus:score", "MetaMorpheus score for PSMs.", false},
    {MS_MetaMorpheus_protein_score, "MS:1002828", "MetaMorpheus:protein score", "MetaMorpheus score for protein groups.", false},
    {MS_XCMS_into, "MS:1002829", "XCMS:into", "Feature intensity produced by XCMS findPeaks() from integrated peak intensity.", false},
    {MS_XCMS_intf, "MS:1002830", "XCMS:intf", "Feature intensity produced by XCMS findPeaks() from baseline corrected integrated peak intensity.", false},
    {MS_XCMS_maxo, "MS:1002831", "XCMS:maxo", "Feature intensity produced by XCMS findPeaks() from maximum peak intensity.", false},
    {MS_XCMS_area, "MS:1002832", "XCMS:area", "Feature intensity produced by XCMS findPeaks() from feature area that is not normalized by the scan rate.", false},
    {MS_alternating_polarity_mode, "MS:1002833", "alternating polarity mode", "Polarities of the scans of a run are alternating, i.e. both positive and negative mode scans are acquired.", false},
    {MS_ProteomeDiscoverer_Delta_Score, "MS:1002834", "ProteomeDiscoverer:Delta Score", "The Delta Score reported by Proteome Discoverer version 2.", false},
    {MS_LTQ_Orbitrap_Classic, "MS:1002835", "LTQ Orbitrap Classic", "Thermo Fisher Scientific LTQ Orbitrap Classic.", false},
    {MS_iProX_dataset_identifier, "MS:1002836", "iProX dataset identifier", "Dataset identifier issued by the iProX repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_iProX_dataset_URI, "MS:1002837", "iProX dataset URI", "URI that allows the access to one dataset in the iProX repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_mzMLb_format, "MS:1002838", "mzMLb format", "mzMLb file format, mzML encapsulated within HDF5.", false},
    {MS_Conversion_to_mzMLb, "MS:1002839", "Conversion to mzMLb", "Conversion of a file format to Proteomics Standards Initiative mzMLb file format.", false},
    {MS_external_reference_data, "MS:1002840", "external reference data", "Data belonging to an external reference.", false},
    {MS_external_HDF5_dataset, "MS:1002841", "external HDF5 dataset", "The HDF5 dataset location containing the binary data, relative to the dataset containing the mzML. Also indicates that there is no data in the <binary> section of the BinaryDataArray.", false},
    {MS_external_offset, "MS:1002842", "external offset", "The position in the external data where the array begins.", false},
    {MS_external_array_length, "MS:1002843", "external array length", "Describes how many fields an array contains.", false},
    {MS_Experiment_additional_parameter, "MS:1002844", "Experiment additional parameter", "Root node for terms relating to the description of an Experiment in relation to the PRIDE-XML element ExperimentCollection/Experiment/additional/cvParam.", false},
    {MS_Associated_file_URI, "MS:1002845", "Associated file URI", "URI of one external file associated to the PRIDE experiment (maybe through a PX submission).", false},
    {MS_Associated_raw_file_URI, "MS:1002846", "Associated raw file URI", "URI of one raw data file associated to the PRIDE experiment (maybe through a PX submission).", false},
    {MS_ProteomeCentral_dataset_URI, "MS:1002847", "ProteomeCentral dataset URI", "URI associated to one PX submission in ProteomeCentral.", false},
    {MS_Result_file_URI, "MS:1002848", "Result file URI", "URI of one file labeled as 'Result', associated to one PX submission.", false},
    {MS_Search_engine_output_file_URI, "MS:1002849", "Search engine output file URI", "URI of one search engine output file associated to one PX submission.", false},
    {MS_Peak_list_file_URI, "MS:1002850", "Peak list file URI", "URI of one of one search engine output file associated to one PX submission.", false},
    {MS_Other_type_file_URI, "MS:1002851", "Other type file URI", "URI of one file labeled as 'Other', associated to one PX submission.", false},
    {MS_Dataset_FTP_location, "MS:1002852", "Dataset FTP location", "FTP location of one entire PX data set.", false},
    {MS_Dataset_with_no_associated_published_manuscript, "MS:1002853", "Dataset with no associated published manuscript", "A dataset which does not have an associated published manuscript.", false},
    {MS_Peer_reviewed_dataset, "MS:1002854", "Peer-reviewed dataset", "Dataset has been peer-reviewed somehow.", false},
    {MS_Non_peer_reviewed_dataset, "MS:1002855", "Non peer-reviewed dataset", "Dataset that has not been peer-reviewed by any means.", false},
    {MS_Supported_dataset_by_repository, "MS:1002856", "Supported dataset by repository", "Dataset for which the identifications and/or spectra/traces are in formats that can be parsed by the hosting data repository such that internal references between identifications and spectra/traces are preserved and browsable at the repository. This is usually called a complete submission.", false},
    {MS_Unsupported_dataset_by_repository, "MS:1002857", "Unsupported dataset by repository", "Dataset for which the identifications and/or spectra/traces are in formats that cannot be parsed by the hosting data repository and thus internal references between identifications and spectra/traces are not browsable at the repository. This is usually called a partial submission.", false},
    {MS_Dataset_with_its_publication_pending, "MS:1002858", "Dataset with its publication pending", "A dataset which has an associated manuscript pending for publication.", false},
    {MS_Additional_associated_raw_file_URI, "MS:1002859", "Additional associated raw file URI", "Additional URI of one raw data file associated to the PRIDE experiment (maybe through a PX submission). The URI is provided via an additional resource to PRIDE.", false},
    {MS_Gel_image_file_URI, "MS:1002860", "Gel image file URI", "URI of one gel image file associated to one PX submission.", false},
    {MS_Reprocessed_complete_dataset, "MS:1002861", "Reprocessed complete dataset", "All the raw files included in the original dataset (or group of original datasets) have been reanalysed.", false},
    {MS_Reprocessed_subset_dataset, "MS:1002862", "Reprocessed subset dataset", "A subset of the raw files included in the original dataset (or group of original datasets) has been reanalysed.", false},
    {MS_Data_derived_from_previous_dataset, "MS:1002863", "Data derived from previous dataset", "One dataset is a reanalysis of previously published data.", false},
    {MS_No_PTMs_are_included_in_the_dataset, "MS:1002864", "No PTMs are included in the dataset", "No post-translational-modifications are been included in the identified peptides of one dataset.", false},
    {MS_Accepted_manuscript, "MS:1002865", "Accepted manuscript", "A dataset has one associated manuscript, which has been accepted but no PubMedID is available yet.", false},
    {MS_Reference, "MS:1002866", "Reference", "Literature reference associated with one dataset (including the authors, title, year and journal details). The value field can be used for the PubMedID, or to specify if one manuscript is just submitted or accepted, but it does not have a PubMedID yet.", false},
    {MS_Experimental_information_has_been_refined_since_this_experiment_was_originally_made_publicly_available, "MS:1002867", "Experimental information has been refined since this experiment was originally made publicly available", "This means that the experimental information available has been improved, for instance precursor charges were added.", false},
    {MS_Original_data, "MS:1002868", "Original data", "One dataset is not a reanalysis of previously published data.", false},
    {MS_mzR, "MS:1002869", "mzR", "Bioconductor package mzR for reading and writing mass spectrometry data files.", false},
    {MS_MSnbase, "MS:1002870", "MSnbase", "Bioconductor package MSnbase provides infrastructure for manipulation, processing and visualization of mass spectrometry and proteomics data, ranging from raw to quantitative and annotated data.", false},
    {MS_CAMERA, "MS:1002871", "CAMERA", "Bioconductor package CAMERA for annotation of peak lists generated by xcms, rule based annotation of isotopes and adducts, isotope validation, EIC correlation based tagging of unknown adducts and fragments.", false},
    {MS_Panorama_Public_dataset_identifier, "MS:1002872", "Panorama Public dataset identifier", "Dataset identifier issued by the Panorama Public repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_Panorama_Public_dataset_URI, "MS:1002873", "Panorama Public dataset URI", "URI that allows the access to one dataset in the Panorama Public repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.", false},
    {MS_TSQ_Altis, "MS:1002874", "TSQ Altis", "Thermo Scientific TSQ Altis Triple Quadrupole MS.", false},
    {MS_TSQ_Quantis, "MS:1002875", "TSQ Quantis", "Thermo Scientific TSQ Quantis Triple Quadrupole MS.", false},
    {MS_TSQ_9000, "MS:1002876", "TSQ 9000", "Thermo Scientific TSQ 9000 Triple Quadrupole MS.", false},
    {MS_Q_Exactive_HF_X, "MS:1002877", "Q Exactive HF-X", "Thermo Scientific Q Exactive HF-X Hybrid Quadrupole Orbitrap MS.", false},
    {MS_small_molecule_analysis_software, "MS:1002878", "small molecule analysis software", "Software for the analysis of small molecules.", false},
    {MS_Progenesis_QI, "MS:1002879", "Progenesis QI", "Metabolomics analysis software for LC-MS data from Nonlinear Dynamics.", false},
    {MS_Compound_Discoverer, "MS:1002880", "Compound Discoverer", "Metabolomics analysis software from Thermo Fisher Scientific.", false},
    {MS_MyCompoundID, "MS:1002881", "MyCompoundID", "Metabolite identification tool MyCompoundID.", false},
    {MS_study_variable_average_function, "MS:1002882", "study variable average function", "Function used to calculate the study variable quantification value.", false},
    {MS_median, "MS:1002883", "median", "Median function.", false},
    {MS_study_variable_variation_function, "MS:1002884", "study variable variation function", "Function used to calculate the study variable quantification variation value.", false},
    {MS_standard_error, "MS:1002885", "standard error", "Standard error function.", false},
    {MS_small_molecule_quantification_datatype, "MS:1002886", "small molecule quantification datatype", "The value reported in a small molecule quantification.", false},
    {MS_Progenesis_QI_normalised_abundance, "MS:1002887", "Progenesis QI normalised abundance", "The normalised abundance produced by Progenesis QI LC-MS.", false},
    {MS_small_molecule_confidence_measure, "MS:1002888", "small molecule confidence measure", "The confidence score produced by a small molecule analysis software.", false},
    {MS_Progenesis_MetaScope_score, "MS:1002889", "Progenesis MetaScope score", "The confidence score produced by Progenesis QI.", false},
    {MS_fragmentation_score, "MS:1002890", "fragmentation score", "The fragmentation confidence score.", false},
    {MS_isotopic_fit_score, "MS:1002891", "isotopic fit score", "The isotopic fit confidence score.", false},
    {MS_ion_mobility_attribute, "MS:1002892", "ion mobility attribute", "An attribute describing ion mobility searches.", false},
    {MS_ion_mobility_array, "MS:1002893", "ion mobility array", "Abstract array of ion mobility data values. A more specific child term concept should be specified in data files to make precise the nature of the data being provided.", false},
    {MS_InChIKey, "MS:1002894", "InChIKey", "Unique chemical structure identifier for chemical compounds.", false},
    {MS_small_molecule_identification_attribute, "MS:1002895", "small molecule identification attribute", "Compound identification information.", false},
    {MS_compound_identification_confidence_level, "MS:1002896", "compound identification confidence level", "Confidence level for annotation of identified compounds as defined by the Metabolomics Standards Initiative (MSI). The value slot can have the values 'Level 0' until 'Level 4'.", false},
    {MS_isotopomer_peak_OBSOLETE, "MS:1002897", "isotopomer peak", "Identifies a peak when no de-isotoping has been performed. The value slot reports the isotopomer peak, e.g. '2H', '13C', '15N', '18O', '31P'.", true},
    {MS_Shimadzu_Biotech_QTOF_nativeID_format, "MS:1002898", "Shimadzu Biotech QTOF nativeID format", "Native format defined by scan=xsd:nonNegativeInteger.", false},
    {MS_msalign_format, "MS:1002899", "msalign format", "msalign file format.", false},
    {MS_feature_format, "MS:1002900", "feature format", "TopFD feature file format.", false},
    {MS_TopPIC, "MS:1002901", "TopPIC", "TopPIC: a software tool for top-down mass spectrometry-based proteoform identification and characterization.", false},
    {MS_TopFD, "MS:1002902", "TopFD", "Top-down mass spectral feature detection.", false},
    {MS_TopMG, "MS:1002903", "TopMG", "A mass graph-based approach for the identification of modified proteoforms using top-down tandem mass spectra.", false},
    {MS_proteoform_level_identification_attribute, "MS:1002904", "proteoform-level identification attribute", "Proteoform level information.", false},
    {MS_proteoform_level_identification_statistic, "MS:1002905", "proteoform-level identification statistic", "Identification confidence metric for a proteoform.", false},
    {MS_search_engine_specific_score_for_proteoforms, "MS:1002906", "search engine specific score for proteoforms", "Search engine specific proteoform scores.", false},
    {MS_proteoform_level_global_FDR, "MS:1002907", "proteoform-level global FDR", "Estimation of the global false discovery rate of proteoforms.", false},
    {MS_proteoform_level_local_FDR, "MS:1002908", "proteoform-level local FDR", "Estimation of the local false discovery rate of proteoforms.", false},
    {MS_proteoform_level_statistical_threshold, "MS:1002909", "proteoform-level statistical threshold", "Estimated statistical threshold at proteoform-level.", false},
    {MS_proteoform_level_global_FDR_threshold, "MS:1002910", "proteoform-level global FDR threshold", "Threshold for the global false discovery rate of proteoforms.", false},
    {MS_proteoform_level_local_FDR_threshold, "MS:1002911", "proteoform-level local FDR threshold", "Threshold for the local false discovery rate of proteoforms.", false},
    {MS_TopPIC_input_parameter, "MS:1002912", "TopPIC input parameter", "Search engine input parameters specific to TopPIC.", false},
    {MS_TopPIC_fixed_modification, "MS:1002913", "TopPIC:fixed modification", "Fixed modifications for TopPIC searching.", false},
    {MS_TopPIC_N_term_form, "MS:1002914", "TopPIC:N-term form", "N-terminal forms of proteins allowed in TopPIC searching.", false},
    {MS_TopPIC_error_tolerance, "MS:1002915", "TopPIC:error tolerance", "Error tolerance for precursor and fragment masses in PPM.", false},
    {MS_TopPIC_max_shift, "MS:1002916", "TopPIC:max shift", "Maximum value of the mass shift (in Dalton) of an unexpected modification.", false},
    {MS_TopPIC_min_shift, "MS:1002917", "TopPIC:min shift", "Minimum value of the mass shift (in Dalton) of an unexpected modification.", false},
    {MS_TopPIC_shift_num, "MS:1002918", "TopPIC:shift num", "Maximum number of unexpected modifications in a proteoform spectrum match.", false},
    {MS_TopPIC_spectral_cutoff_type, "MS:1002919", "TopPIC:spectral cutoff type", "Spectrum-level cutoff type for filtering identified proteoform spectrum matches.", false},
    {MS_TopPIC_spectral_cutoff_value, "MS:1002920", "TopPIC:spectral cutoff value", "Spectrum-level cutoff value for filtering identified proteoform spectrum matches.", false},
    {MS_TopPIC_proteoform_level_cutoff_type, "MS:1002921", "TopPIC:proteoform-level cutoff type", "Proteoform-level cutoff type for filtering identified proteoform spectrum matches.", false},
    {MS_TopPIC_proteoform_level_cutoff_value, "MS:1002922", "TopPIC:proteoform-level cutoff value", "Proteoform-level cutoff value for filtering identified proteoform spectrum matches.", false},
    {MS_TopPIC_generating_function, "MS:1002923", "TopPIC:generating function", "P-value and E-value estimation using generating function.", false},
    {MS_TopPIC_combined_spectrum_number, "MS:1002924", "TopPIC:combined spectrum number", "Number of combined spectra.", false},
    {MS_TopPIC_mod_file, "MS:1002925", "TopPIC:mod file", "The text file containing the information of common PTMs.", false},
    {MS_TopPIC_thread_number, "MS:1002926", "TopPIC:thread number", "Number of threads used in TopPIC.", false},
    {MS_TopPIC_use_TopFD_feature, "MS:1002927", "TopPIC:use TopFD feature", "Proteoform identification using TopFD feature file.", false},
    {MS_TopPIC_spectral_E_value, "MS:1002928", "TopPIC:spectral E-value", "TopPIC spectrum-level E-value.", false},
    {MS_TopPIC_spectral_FDR, "MS:1002929", "TopPIC:spectral FDR", "TopPIC spectrum-level FDR.", false},
    {MS_TopPIC_proteoform_level_FDR, "MS:1002930", "TopPIC:proteoform-level FDR", "TopPIC proteoform-level FDR.", false},
    {MS_TopPIC_spectral_p_value, "MS:1002931", "TopPIC:spectral p-value", "TopPIC spectrum-level p-value.", false},
    {MS_TopPIC_MIScore, "MS:1002932", "TopPIC:MIScore", "Modification identification score.", false},
    {MS_TopPIC_MIScore_threshold, "MS:1002933", "TopPIC:MIScore threshold", "TopPIC:MIScore threshold.", false},
    {MS_TopMG_input_parameter, "MS:1002934", "TopMG input parameter", "Search engine input parameters specific to TopMG.", false},
    {MS_TopMG_fixed_modification, "MS:1002935", "TopMG:fixed modification", "Fixed modifications for TopMG searching.", false},
    {MS_TopMG_N_term_form, "MS:1002936", "TopMG:N-term form", "N-terminal forms of proteins allowed in TopMG searching.", false},
    {MS_TopMG_error_tolerance, "MS:1002937", "TopMG:error tolerance", "Error tolerance for precursor and fragment masses in PPM.", false},
    {MS_TopMG_max_shift, "MS:1002938", "TopMG:max shift", "Maximum value of the mass shift (in Dalton).", false},
    {MS_TopMG_spectral_cutoff_type, "MS:1002939", "TopMG:spectral cutoff type", "Spectrum-level cutoff type for filtering identified proteoform spectrum matches.", false},
    {MS_TopMG_spectral_cutoff_value, "MS:1002940", "TopMG:spectral cutoff value", "Spectrum-level cutoff value for filtering identified proteoform spectrum matches.", false},
    {MS_TopMG_proteoform_level_cutoff_type, "MS:1002941", "TopMG:proteoform-level cutoff type", "Proteoform-level cutoff type for filtering identified proteoform spectrum matches.", false},
    {MS_TopMG_proteoform_level_cutoff_value, "MS:1002942", "TopMG:proteoform-level cutoff value", "Proteoform-level cutoff value for filtering identified proteoform spectrum matches.", false},
    {MS_TopMG_mod_file, "MS:1002943", "TopMG:mod file", "The text file containing the information of common PTMs.", false},
    {MS_TopMG_thread_number, "MS:1002944", "TopMG:thread number", "Number of threads used in TopMG.", false},
    {MS_TopMG_use_TopFD_feature, "MS:1002945", "TopMG:use TopFD feature", "Proteoform identification using TopFD feature file.", false},
    {MS_TopMG_proteoform_graph_gap_size, "MS:1002946", "TopMG:proteoform graph gap size", "Gap size in constructing proteoform graph.", false},
    {MS_TopMG_variable_PTM_number, "MS:1002947", "TopMG:variable PTM number", "Maximum number of variable PTMs.", false},
    {MS_TopMG_variable_PTM_number_in_proteoform_graph_gap, "MS:1002948", "TopMG:variable PTM number in proteoform graph gap", "Maximum number of variable PTMs in a proteoform graph gap.", false},
    {MS_TopMG_use_ASF_DIAGONAL, "MS:1002949", "TopMG:use ASF-DIAGONAL", "Protein filtering using ASF-DIAGONAL method.", false},
    {MS_TopMG_spectral_E_value, "MS:1002950", "TopMG:spectral E-value", "TopMG spectrum-level E-value.", false},
    {MS_TopMG_spectral_FDR, "MS:1002951", "TopMG:spectral FDR", "TopMG spectrum-level FDR.", false},
    {MS_TopMG_proteoform_level_FDR, "MS:1002952", "TopMG:proteoform-level FDR", "TopMG proteoform-level FDR.", false},
    {MS_TopMG_spectral_p_value, "MS:1002953", "TopMG:spectral p-value", "TopMG spectrum-level p-value.", false},
    {MS_collisional_cross_sectional_area, "MS:1002954", "collisional cross sectional area", "Structural molecular descriptor for the effective interaction area between the ion and neutral gas measured in ion mobility mass spectrometry.", false},
    {MS_hr_ms_compound_identification_confidence_level, "MS:1002955", "hr-ms compound identification confidence level", "Refined High Resolution mass spectrometry confidence level for annotation of identified compounds as proposed by Schymanski et al. The value slot can have the values 'Level 1', 'Level 2', 'Level 2a', 'Level 2b', 'Level 3', 'Level 4', and 'Level 5'.", false},
    {MS_isotopic_ion_MS_peak, "MS:1002956", "isotopic ion MS peak", "A mass spectrometry peak that represents one or more isotopic ions. The value slot contains a description of the represented isotope set, e.g. 'M+1 peak'.", false},
    {MS_isotopomer_MS_peak, "MS:1002957", "isotopomer MS peak", "The described isotopomer mass spectrometric signal. The value slot contains a description of the represented isotopomer, e.g. '13C peak', '15N peak', '2H peak', '18O peak' or '31P peak'.", false},
    {MS_isotopologue_MS_peak, "MS:1002958", "isotopologue MS peak", "The described isotopologue mass spectrometric signal. The value slot contains a description of the represented isotopologue, e.g. '13C1 peak' or '15N1 peak'.", false},
    {MS_isomer, "MS:1002959", "isomer", "One of several species (or molecular entities) that have the same atomic composition (molecular formula) but different line formulae or different stereochemical formulae.", false},
    {MS_isotopomer, "MS:1002960", "isotopomer", "An isomer that differs from another only in the spatial distribution of the constitutive isotopic atoms.", false},
    {MS_isotopologue, "MS:1002961", "isotopologue", "A molecular entity that differs only in isotopic composition (number of isotopic substitutions).", false},
    {MS_mean, "MS:1002962", "mean", "The arithmetic mean.", false},
    {MS_variation_coefficient, "MS:1002963", "variation coefficient", "The coefficient of variation.", false},
    {MS_lipidomics_analysis_software, "MS:1002964", "lipidomics analysis software", "Lipidomics analysis software.", false},
    {MS_Lipid_Data_Analyzer, "MS:1002965", "Lipid Data Analyzer", "Lipid Data Analyzer software for lipid quantification.", false},
    {MS_chrom_format, "MS:1002966", "chrom format", "The Lipid Data Analyzer native chrom format.", false},
    {MS_LipidHunter, "MS:1002967", "LipidHunter", "Software for identification of phospholipids by high-throughput processing of LC-MS and shotgun lipidomics datasets.", false},
    {MS_LipidXplorer, "MS:1002968", "LipidXplorer", "Software for consensual cross-platform lipidomics.", false},
    {MS_LipidMatch, "MS:1002969", "LipidMatch", "An automated workflow for rule-based lipid identification using untargeted high-resolution tandem mass spectrometry data.", false},
    {MS_Greazy, "MS:1002970", "Greazy", "Open-source software for automated phospholipid tandem mass spectrometry identification.", false},
    {MS_LipidBlast, "MS:1002971", "LipidBlast", "LC-MS-based lipidomics and automated identification of lipids using the LipidBlast in-silico MS/MS library.", false},
    {MS_Lipid_Pro, "MS:1002972", "Lipid-Pro", "A computational lipid identification solution for untargeted lipidomics on data-independent acquisition tandem mass spectrometry platforms.", false},
    {MS_LipidFinder, "MS:1002973", "LipidFinder", "A computational workflow for the discovery of lipids for the identification of eicosanoid-phosphoinositides in platelets.", false},
    {MS_LipiDex, "MS:1002974", "LipiDex", "An integrated software package for high-confidence lipid identification.", false},
    {MS_LIQUID, "MS:1002975", "LIQUID", "An-open source software for identifying lipids in LC-MS/MS-based lipidomics data.", false},
    {MS_ALEX, "MS:1002976", "ALEX", "Analysis of lipid experiments, a calculator for m/z values of intact lipid molecules (MS1).", false},
    {MS_ALEX123, "MS:1002977", "ALEX123", "Analysis of lipid experiments 123, a calculator with m/z values of intact lipid molecules (MS1) and their fragment ions at the MS2 and MS3 level.", false},
    {MS_LIMSA, "MS:1002978", "LIMSA", "Software tool for the quantitative analysis of mass spectrometric lipidome data.", false},
    {MS_LOBSTAHS, "MS:1002979", "LOBSTAHS", "Adduct-Based lipidomics software for the discovery and identification of oxidative stress biomarkers.", false},
    {MS_LipidQA, "MS:1002980", "LipidQA", "Lipid qualitative/quantitative analysis software for identification and quantitation of complex lipid molecular species.", false},
    {MS_Proline, "MS:1002981", "Proline", "The Proline software suite for mass spectrometry based proteomics.", false},
    {MS_PepNovo, "MS:1002982", "PepNovo", "PepNovo tool for de novo peptide sequencing.", false},
    {MS_pNovo, "MS:1002983", "pNovo", "pNovo tool for de novo peptide sequencing and identification using HCD spectra.", false},
    {MS_Novor, "MS:1002984", "Novor", "Novor real-time peptide de novo sequencing software tool.", false},
    {MS_in_gel_digestion, "MS:1002985", "in-gel digestion", "Digestion of proteins separated by gel electrophoresis for mass spectrometric characterization of proteins and proteomes.", false},
    {MS_in_solution_digestion, "MS:1002986", "in-solution digestion", "Digestion of proteins in solution for mass spectrometric characterization of proteins and proteomes.", false},
    {MS_IdentiPy, "MS:1002987", "IdentiPy", "IdentiPy.", false},
    {MS_IdentiPy_RHNS, "MS:1002988", "IdentiPy:RHNS", "The IdentiPy result 'RHNS'.", false},
    {MS_IdentiPy_hyperscore, "MS:1002989", "IdentiPy:hyperscore", "The IdentiPy result 'hyperscore'.", false},
    {MS_ms_deisotope, "MS:1002990", "ms_deisotope", "ms_deisotope, a library for deisotoping and charge state deconvolution of mass spectra.", false},
    {MS_python_psims, "MS:1002991", "python-psims", "python-psims, a library for generating mzML and mzIdentML.", false},
    {MS_Andromeda_PEP, "MS:1002995", "Andromeda:PEP", "Posterior error probability of the best identified peptide of the Andromeda search engine.", false},
    {MS_Andromeda_apl_file_format, "MS:1002996", "Andromeda:apl file format", "Peak list file format of the Andromeda search engine.", false},
    {MS_ProteomeXchange_dataset_identifier_reanalysis_number, "MS:1002997", "ProteomeXchange dataset identifier reanalysis number", "Index number of a reanalysis within a ProteomeXchange reprocessed dataset identifier container (RPXD).", false},
    {MS_LCMS_9030, "MS:1002998", "LCMS-9030", "Shimadzu Scientific Instruments LCMS-9030 Q-TOF MS.", false},
    {MS_LCMS_8060, "MS:1002999", "LCMS-8060", "Shimadzu Scientific Instruments LCMS-8060 MS.", false},
    {MS_LCMS_8050, "MS:1003000", "LCMS-8050", "Shimadzu Scientific Instruments LCMS-8050 MS.", false},
    {MS_LCMS_8045, "MS:1003001", "LCMS-8045", "Shimadzu Scientific Instruments LCMS-8045 MS.", false},
    {MS_LCMS_8040, "MS:1003002", "LCMS-8040", "Shimadzu Scientific Instruments LCMS-8040 MS.", false},
    {MS_LCMS_2020, "MS:1003003", "LCMS-2020", "Shimadzu Scientific Instruments LCMS-2020.", false},
    {MS_maXis_II, "MS:1003004", "maXis II", "Bruker Daltonics' maXis II.", false},
    {MS_timsTOF_Pro, "MS:1003005", "timsTOF Pro", "Bruker Daltonics' timsTOF Pro.", false},
    {MS_mean_inverse_reduced_ion_mobility_array, "MS:1003006", "mean inverse reduced ion mobility array", "Array of population mean ion mobility values based on ion separation in gaseous phase due to different ion mobilities under an electric field based on ion size, m/z and shape, normalized for the local conditions and reported in volt-second per square centimeter, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_raw_ion_mobility_array, "MS:1003007", "raw ion mobility array", "Array of raw ion mobility values (K or K0) based on ion separation in gaseous phase due to different ion mobilities under an electric field based on ion size, m/z and shape, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_raw_inverse_reduced_ion_mobility_array, "MS:1003008", "raw inverse reduced ion mobility array", "Array of raw ion mobility values based on ion separation in gaseous phase due to different ion mobilities under an electric field based on ion size, m/z and shape, normalized for the local conditions and reported in volt-second per square centimeter, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_Shimadzu_Biotech_LCD_format, "MS:1003009", "Shimadzu Biotech LCD format", "Shimadzu Biotech LCD file format.", false},
    {MS_LPPtiger, "MS:1003010", "LPPtiger", "Software for lipidome-specific prediction and identification of oxidized phospholipids from LC-MS datasets.", false},
    {MS_pFind, "MS:1003011", "pFind", "Sequence-tag-based search engine pFind.", false},
    {MS_KSDP_score, "MS:1003012", "KSDP score", "Kernel mass spectral dot product scoring function.", false},
    {MS_i3tms, "MS:1003013", "i3tms", "i3-tms search engine and data-analysis software.", false},
    {MS_MSFragger, "MS:1003014", "MSFragger", "A database search-based peptide identification tool.", false},
    {MS_razor_peptide, "MS:1003015", "razor peptide", "Peptide that is shared between protein groups and assigned to the protein group with the largest number of identified peptides.", false},
    {MS_ProteinProphet_peptide_weight, "MS:1003016", "ProteinProphet:peptide weight", "Fraction of peptide evidence attributable to a protein or a set of indistinguishable proteins.", false},
    {MS_ProteinProphet_peptide_group_weight, "MS:1003017", "ProteinProphet:peptide group weight", "Fraction of peptide evidence attributable to a group of proteins.", false},
    {MS_Philosopher, "MS:1003018", "Philosopher", "General proteomics processing toolkit for shotgun proteomics.", false},
    {MS_pressure_chromatogram, "MS:1003019", "pressure chromatogram", "Representation of chromatographic pressure versus time.", false},
    {MS_flow_rate_chromatogram, "MS:1003020", "flow rate chromatogram", "Representation of the chromatographic flow rate versus time.", false},
    {MS_Fixed_modification, "MS:1003021", "Fixed modification", "Post-translational modification which is assumed to be present at each instance of a residue type.", false},
    {MS_Variable_modification, "MS:1003022", "Variable modification", "Post-translational modification which may or may not be present at a residue type.", false},
    {MS_OpenPepXL, "MS:1003023", "OpenPepXL", "Cross-Linking MS search engine.", false},
    {MS_OpenPepXL_score, "MS:1003024", "OpenPepXL:score", "The OpenPepXL score for a crosslink spectrum match.", false},
    {MS_named_element, "MS:1003025", "named element", "A named element that is an attribute in a proteomics standards file.", false},
    {MS_named_element_in_mzIdentML, "MS:1003026", "named element in mzIdentML", "A named element that is an attribute in a mzIdentML file.", false},
    {MS_named_element_in_mzML, "MS:1003027", "named element in mzML", "A named element that is an attribute in a mzML file.", false},
    {MS_Orbitrap_Exploris_480, "MS:1003028", "Orbitrap Exploris 480", "Thermo Scientific Orbitrap Exploris 480 Quadrupole Orbitrap MS.", false},
    {MS_Orbitrap_Eclipse, "MS:1003029", "Orbitrap Eclipse", "Thermo Scientific Orbitrap Eclipse mass spectrometer with Tribrid architecture consisting of quadrupole mass filter, linear ion trap and Orbitrap mass analyzers.", false},
    {MS_Mascot_MinNumSigUniqueSeqs, "MS:1003030", "Mascot:MinNumSigUniqueSeqs", "Minimum number of significant unique sequences required in a protein hit. The setting is only relevant if the protein grouping strategy is 'family clustering'.", false},
    {MS_CPTAC_accession_number, "MS:1003031", "CPTAC accession number", "Main identifier of a CPTAC dataset.", false},
    {MS_compound_identification_confidence_code_in_MS_DIAL, "MS:1003032", "compound identification confidence code in MS-DIAL", "The confidence code to describe the confidence of annotated compounds as defined by the MS-DIAL program.", false},
    {MS_molecular_entity_attribute, "MS:1003033", "molecular entity attribute", "Non-inherent characteristic attributed to a molecular entity.", false},
    {MS_atom, "MS:1003034", "atom", "Smallest constituent unit of ordinary matter that constitutes a chemical element.", false},
    {MS_small_molecule, "MS:1003035", "small molecule", "Low molecular weight (< 900 daltons) organic compound that may regulate a biological process.", false},
    {MS_metabolite, "MS:1003036", "metabolite", "Small molecule that is the intermediate end product of metabolism.", false},
    {MS_ribonucleotide, "MS:1003037", "ribonucleotide", "Nucleotide containing ribose as its pentose component.", false},
    {MS_deoxyribonucleotide, "MS:1003038", "deoxyribonucleotide", "Monomer, or single unit, of DNA, or deoxyribonucleic acid.", false},
    {MS_amino_acid, "MS:1003039", "amino acid", "Organic molecule that contains amine (-NH2) and carboxyl (-COOH) functional groups, along with a side chain (R group) that is specific to each amino acid.", false},
    {MS_monosaccharide, "MS:1003040", "monosaccharide", "Simplest form of sugar and the most basic units of carbohydrate that cannot be further hydrolyzed to a simpler molecule.", false},
    {MS_nucleic_acid, "MS:1003041", "nucleic acid", "Molecule composed of a chain of nucleotides.", false},
    {MS_polysaccharide, "MS:1003042", "polysaccharide", "Polymeric carbohydrate molecules composed of long chains of monosaccharide units bound together by glycosidic linkages.", false},
    {MS_number_of_residues, "MS:1003043", "number of residues", "Number of amino acid residues in a peptide, commonly referred to as the peptide length.", false},
    {MS_number_of_missed_cleavages, "MS:1003044", "number of missed cleavages", "Number of amino acid residue bonds that should have been cleaved by the cleavage agent used, but were not.", false},
    {MS_peptide_to_protein_mapping, "MS:1003045", "peptide-to-protein mapping", "Process of mapping a peptide sequence to a protein sequence.", false},
    {MS_peptide_to_protein_mapping_attribute, "MS:1003046", "peptide-to-protein mapping attribute", "Nonphysical characteristic attributed to the result of peptide-to-protein mapping.", false},
    {MS_protein_sequence_offset, "MS:1003047", "protein sequence offset", "Offset in number of residues from the n terminus of the protein at which the peptide begins. Use 1 when the first residue of the peptide sequence is the first residue of the protein sequence.", false},
    {MS_number_of_enzymatic_termini, "MS:1003048", "number of enzymatic termini", "Total number of termini that match standard rules for the cleavage agent, 2 when both termini match cleavage agent rules, 1 when only one terminus does, and 0 if neither terminus matches cleavage agent rules.", false},
    {MS_peptidoform, "MS:1003049", "peptidoform", "Peptide that contains zero or more mass modifications on the termini or side chains of its amino acid residues, and may be differentiated from other peptidoforms with the same peptide sequence but different mass modification configurations.", false},
    {MS_peptidoform_attribute, "MS:1003050", "peptidoform attribute", "Non-inherent characteristic attributed to a peptidoform.", false},
    {MS_peptidoform_ion, "MS:1003051", "peptidoform ion", "Peptidoform that has formed an adduct with an ion, thereby rendering it potentially detectable with a mass spectrometer. Commonly called a 'precursor' or 'precursor ion' or 'parent ion'.", false},
    {MS_peptidoform_ion_property, "MS:1003052", "peptidoform ion property", "Inherent or measurable characteristic of a peptidoform ion.", false},
    {MS_theoretical_monoisotopic_m_z, "MS:1003053", "theoretical monoisotopic m/z", "Mass-to-charge ratio of a peptidoform ion composed of the most common isotope of each atom computed from the putative knowledge of its molecular constituents.", false},
    {MS_theoretical_average_m_z, "MS:1003054", "theoretical average m/z", "Mass-to-charge ratio of a peptidoform ion computed from the putative knowledge of its molecular constituents, averaged over the distribution of naturally occurring isotopes.", false},
    {MS_adduct, "MS:1003055", "adduct", "Product of a direct addition of two or more distinct molecules, resulting in a single reaction product containing all atoms of all components. The resultant is considered a distinct molecular species.", false},
    {MS_adduct_ion_property, "MS:1003056", "adduct ion property", "Physical measurable characteristic of an adduct ion.", false},
    {MS_scan_number, "MS:1003057", "scan number", "Ordinal number of the scan indicating its order of acquisition within a mass spectrometry acquisition run.", false},
    {MS_spectrum_property, "MS:1003058", "spectrum property", "Inherent or measurable characteristic of a spectrum.", false},
    {MS_number_of_peaks, "MS:1003059", "number of peaks", "Number of peaks or features in a spectrum. For a peak-picked spectrum, this will correspond to the number of data points. For a non-peak-picked spectrum, this corresponds to the number of features discernable in the spectrum, which will be fewer than the number of data points.", false},
    {MS_number_of_data_points, "MS:1003060", "number of data points", "Number of data points in a spectrum. For a peak-picked spectrum, this will correspond to the number of peaks. For a non-peak-picked spectrum, this corresponds to the number of values in the data array, which are not all peaks.", false},
    {MS_library_spectrum_name, "MS:1003061", "library spectrum name", "Label attached to a spectrum uniquely naming it within a collection of spectra, often in a spectral library. It is often a string combination of peptide sequence, charge, mass modifications, collision energy, but will obviously be different for small molecules or unidentified spectra. It must be unique within a collection.", false},
    {MS_library_spectrum_index, "MS:1003062", "library spectrum index", "Integer index value that indicates the spectrum's ordered position within a spectral library. By custom, index counters should begin with 0.", false},
    {MS_universal_spectrum_identifier, "MS:1003063", "universal spectrum identifier", "PSI universal spectrum identifier (USI) multipart key that uniquely identifies a spectrum available in a ProteomeXchange datasets or spectral library.", false},
    {MS_spectrum_aggregation_attribute, "MS:1003064", "spectrum aggregation attribute", "Non-inherent characteristic attributed to spectrum aggregation.", false},
    {MS_spectrum_aggregation_type, "MS:1003065", "spectrum aggregation type", "Categorization of a spectrum based on its type of aggregation (e.g., individual spectrum, consensus spectrum, best replicate spectrum, etc.).", false},
    {MS_singleton_spectrum, "MS:1003066", "singleton spectrum", "Spectrum that is not the result of some aggregation process.", false},
    {MS_consensus_spectrum, "MS:1003067", "consensus spectrum", "Spectrum that is the result of merging several replicate spectra to form a spectrum that is more representative of its class and ideally less noisy that any of its source replicates.", false},
    {MS_best_replicate_spectrum, "MS:1003068", "best replicate spectrum", "Spectrum that is considered the most representative from a pool of replicate spectra.", false},
    {MS_number_of_replicate_spectra_available, "MS:1003069", "number of replicate spectra available", "Number of replicate spectra available for use during the aggregation process.", false},
    {MS_number_of_replicate_spectra_used, "MS:1003070", "number of replicate spectra used", "Number of replicate spectra used during the aggregation process. This is generally applicable when there are many replicates available, but some are discarded as being low S/N, blended, or otherwise unsuitable, and the remaining set is then used for merging via a consensus algorithm.", false},
    {MS_spectrum_origin_attribute, "MS:1003071", "spectrum origin attribute", "Non-inherent characteristic attributed to spectrum aggregation.", false},
    {MS_spectrum_origin_type, "MS:1003072", "spectrum origin type", "Categorization of a spectrum based on its origin (e.g., observed spectrum, predicted spectrum, demultiplexed spectrum, etc.).", false},
    {MS_observed_spectrum, "MS:1003073", "observed spectrum", "Spectrum that originates from an analysis attempt of a single analyte species on an instrument.", false},
    {MS_predicted_spectrum, "MS:1003074", "predicted spectrum", "Spectrum that originates from a compututational algorithm that attempts to predict spectra.", false},
    {MS_demultiplexed_spectrum, "MS:1003075", "demultiplexed spectrum", "Spectrum that originates from an attempted extraction of a single ion spieces from a multiplexed spectrum that contains multiple ion species.", false},
    {MS_uninterpreted_spectrum, "MS:1003076", "uninterpreted spectrum", "Spectrum provided in the form of plain numerical values without any information pertaining to the interpretation of features.", false},
    {MS_interpreted_spectrum, "MS:1003077", "interpreted spectrum", "Spectrum provided in a form where specific features of the spectrum are interpreted to provide putative explanations for some feature.", false},
    {MS_interpreted_spectrum_attribute, "MS:1003078", "interpreted spectrum attribute", "Non-inherent characteristic attributed to an interpreted spectrum.", false},
    {MS_total_unassigned_intensity_fraction, "MS:1003079", "total unassigned intensity fraction", "Fraction of intensity summed from all unassigned peaks divided by the intensity summed from all peaks in the spectrum.", false},
    {MS_top_20_peak_unassigned_intensity_fraction, "MS:1003080", "top 20 peak unassigned intensity fraction", "Fraction of intensity summed from unassigned peaks among the top 20 divided by the intensity summed from all top 20 peaks in the spectrum.", false},
    {MS_unidentified_modification_monoisotopic_mass_delta, "MS:1003081", "unidentified modification monoisotopic mass delta", "Monoisotopic mass delta in Daltons of an amino acid residue modification whose atomic composition or molecular identity has not been determined. This term should not be used for modifications of known molecular identity such as those available in Unimod, RESID or PSI-MOD. This term MUST NOT be used inside the <Modification> element in mzIdentML.", false},
    {MS_MS_DIAL, "MS:1003082", "MS-DIAL", "Data processing software for untargeted metabolomics and lipidomics that supports multiple instruments and MS vendors.", false},
    {MS_raw_data_file, "MS:1003083", "raw data file", "Data file that contains original data as generated by an instrument, although not necessarily in the original data format (i.e. an original raw file converted to a different format is still a raw data file).", false},
    {MS_processed_data_file, "MS:1003084", "processed data file", "File that contains data that has been substantially processed or transformed from what was originally acquired by an instrument.", false},
    {MS_previous_MSn_1_scan_precursor_intensity, "MS:1003085", "previous MSn-1 scan precursor intensity", "Intensity of the precursor ion in the previous MSn-1 scan (prior in time to the referencing MSn scan). For an MS2 scan, this means the MS1 precursor intensity. It is unspecified on whether this is an apex (across m/z) intensity, integrated (across m/z) intensity, a centroided peak intensity of unknown origin, or even summed across several isotopes.", false},
    {MS_precursor_apex_intensity, "MS:1003086", "precursor apex intensity", "Intensity of the precursor ion current as measured by its apex point over time and m/z. It is unspecified whether this is the intensity of the selected isotope or the most intense isotope.", false},
    {MS_supported_by_repository_but_incomplete_data_and_or_metadata, "MS:1003087", "supported by repository but incomplete data and/or metadata", "Dataset for which the identifications and/or spectra/traces are in formats that can be parsed by the hosting data repository such that internal references between identifications and spectra/traces are preserved and browsable at the repository. However, some metadata is not properly described due to lack of CV terms or some auxiliary data, such as data used to create a spectral library or a sequence search database crucial to the analysis, is not available.", false},
    {MS_truncation_and_zlib_compression, "MS:1003088", "truncation and zlib compression", "Data array compression using mantissa bit truncation followed by zlib compression.", false},
    {MS_truncation__delta_prediction_and_zlib_compression, "MS:1003089", "truncation, delta prediction and zlib compression", "Data array compression using mantissa bit truncation, delta prediction and zlib compression.", false},
    {MS_truncation__linear_prediction_and_zlib_compression, "MS:1003090", "truncation, linear prediction and zlib compression", "Data array compression using mantissa bit truncation, linear prediction and zlib compression.", false},
    {MS_binary_data_compression_parameter, "MS:1003091", "binary data compression parameter", "Settable parameter for a binary data compression event.", false},
    {MS_number_of_mantissa_bits_truncated, "MS:1003092", "number of mantissa bits truncated", "Number of extraneous mantissa bits truncated to improve subsequent compression.", false},
    {MS_Lys_N, "MS:1003093", "Lys-N", "Metalloendopeptidase found in the mushroom Grifola frondosa that cleaves proteins on the amino side of lysine residues.", false},
    {MS_Orbitrap_Exploris_240, "MS:1003094", "Orbitrap Exploris 240", "Thermo Scientific Orbitrap Exploris 240 Quadrupole Orbitrap MS.", false},
    {MS_Orbitrap_Exploris_120, "MS:1003095", "Orbitrap Exploris 120", "Thermo Scientific Orbitrap Exploris 120 Quadrupole Orbitrap MS.", false},
    {MS_LTQ_Orbitrap_Velos_Pro, "MS:1003096", "LTQ Orbitrap Velos Pro", "Thermo Scientific LTQ Orbitrap Velos Pro, often just referred to as the Orbitrap Velos Pro.", false},
    {MS_MaxQuant_protein_group_level_score, "MS:1003097", "MaxQuant protein group-level score", "The probability based MaxQuant protein group score.", false},
    {MS_Andromeda_peptide_PEP, "MS:1003098", "Andromeda peptide PEP", "Peptide probability from Andromeda.", false},
    {MS_MaxQuant_DIA_peptide_PEP, "MS:1003099", "MaxQuant-DIA peptide PEP", "Peptide probability from MaxQuant-DIA algorithm.", false},
    {MS_MaxQuant_DIA_score, "MS:1003100", "MaxQuant-DIA score", "PSM evidence score from MaxQuant-DIA algorithm.", false},
    {MS_MaxQuant_DIA_PEP, "MS:1003101", "MaxQuant-DIA PEP", "PSM evidence PEP probability from MaxQuant-DIA algorithm.", false},
    {MS_NIST_msp_comment, "MS:1003102", "NIST msp comment", "Term for a comment field withing the NIST msp file format", false},
    {MS_ion_annotation_format, "MS:1003103", "ion annotation format", "Annotation format used for annotating individual spectrum ion peaks.", false},
    {MS_mzPAF_peptide_ion_annotation_format, "MS:1003104", "mzPAF peptide ion annotation format", "Annotation format designed primarily for peptides, with allowances for generic chemical formulas and other miscellaneous named ions.", false},
    {MS_crosslinked_peptide_ion_annotation_format, "MS:1003105", "crosslinked peptide ion annotation format", "Annotation format designed specifically for crosslinked peptide ion peaks.", false},
    {MS_glycan_ion_annotation_format, "MS:1003106", "glycan ion annotation format", "Annotation format designed specifically for glycan ion peaks.", false},
    {MS_lipid_ion_annotation_format, "MS:1003107", "lipid ion annotation format", "Annotation format designed specifically for lipid ion peaks.", false},
    {MS_PatternLab, "MS:1003108", "PatternLab", "PatternLab for Proteomics is an integrated computational environment for analyzing shotgun proteomic data.", false},
    {MS_SIM_XL, "MS:1003109", "SIM-XL", "Identifying crosslinked peptides in complex protein mixtures", false},
    {MS_SIM_XL_score, "MS:1003110", "SIM-XL score", "SIM-XL identification search engine score", false},
    {MS_QUIN_XL, "MS:1003111", "QUIN-XL", "Quantification of crosslinked peptides in complex protein mixtures", false},
    {MS_Orbitrap_ID_X, "MS:1003112", "Orbitrap ID-X", "Thermo Scientific Orbitrap ID-X mass spectrometer with Tribrid architecture consisting of quadrupole mass filter, linear ion trap and Orbitrap mass analyzers.", false},
    {MS_OpenMS_ConsensusID_PEP, "MS:1003113", "OpenMS:ConsensusID PEP", "The OpenMS ConsesusID tool posterior error probability", false},
    {MS_OpenMS_Best_PSM_Score, "MS:1003114", "OpenMS:Best PSM Score", "The score of the best PSM selected by the underlying identification tool", false},
    {MS_OpenMS_Target_decoy_PSM_q_value, "MS:1003115", "OpenMS:Target-decoy PSM q-value", "The OpenMS Target-decoy q-values at PSM level", false},
    {MS_OpenMS_Target_decoy_peptide_q_value, "MS:1003116", "OpenMS:Target-decoy peptide q-value", "The OpenMS Target-decoy q-values at peptide sequence level", false},
    {MS_OpenMS_Target_decoy_protein_q_value, "MS:1003117", "OpenMS:Target-decoy protein q-value", "The OpenMS Target-decoy q-values at protein level", false},
    {MS_EPIFANY, "MS:1003118", "EPIFANY", "A Method for Efficient High-Confidence Protein Inference. The tool is part of the OpenMS framework", false},
    {MS_EPIFANY_Protein_posterior_probability, "MS:1003119", "EPIFANY:Protein posterior probability", "Protein Posterior probability calculated by EPIFANY protein inference algorithm", false},
    {MS_OpenMS_LFQ_intensity, "MS:1003120", "OpenMS:LFQ intensity", "The data type LFQ intensity produced by OpenMS.", false},
    {MS_OpenMS_LFQ_spectral_count, "MS:1003121", "OpenMS:LFQ spectral count", "The data type LFQ spectral count produced by OpenMS.", false},
    {MS_rapifleX, "MS:1003122", "rapifleX", "Bruker Daltonics' rapiflex: MALDI TOF/TOF.", false},
    {MS_Bruker_Daltonics_timsTOF_series, "MS:1003123", "Bruker Daltonics timsTOF series", "Bruker Daltonics timsTOF series", false},
    {MS_timsTOF_fleX, "MS:1003124", "timsTOF fleX", "Bruker Daltonics' timsTOF fleX", false},
    {MS_ProSight_spectral_Q_value, "MS:1003125", "ProSight:spectral Q-value", "ProSight spectrum-level Q-value.", false},
    {MS_ProSight_spectral_P_score, "MS:1003126", "ProSight:spectral P-score", "ProSight spectrum-level P-score.", false},
    {MS_ProSight_spectral_E_value, "MS:1003127", "ProSight:spectral E-value", "ProSight spectrum-level E-value.", false},
    {MS_ProSight_spectral_C_score, "MS:1003128", "ProSight:spectral C-score", "ProSight spectrum-level C-score.", false},
    {MS_proteoform_level_Q_value, "MS:1003129", "proteoform-level Q-value", "Estimation of the Q-value for proteoforms.", false},
    {MS_ProSight_proteoform_Q_value, "MS:1003130", "ProSight:proteoform Q-value", "ProSight proteoform-level Q-value.", false},
    {MS_isoform_level_identification_attribute, "MS:1003131", "isoform-level identification attribute", "Isoform level information.", false},
    {MS_isoform_level_identification_statistic, "MS:1003132", "isoform-level identification statistic", "Identification confidence metric for a isoform.", false},
    {MS_isoform_level_Q_value, "MS:1003133", "isoform-level Q-value", "Estimation of the Q-value for isoforms.", false},
    {MS_ProSight_isoform_Q_value, "MS:1003134", "ProSight:isoform Q-value", "ProSight isoform-level Q-value.", false},
    {MS_ProSight_protein_Q_value, "MS:1003135", "ProSight:protein Q-value", "ProSight protein-level Q-value.", false},
    {MS_ProSight_input_parameter, "MS:1003136", "ProSight input parameter", "Search engine input parameters specific to ProSight.", false},
    {MS_TDPortal_input_parameter, "MS:1003137", "TDPortal input parameter", "Search engine input parameters specific to TDPortal.", false},
    {MS_ProSight_Run_delta_m_mode, "MS:1003138", "ProSight:Run delta m mode", "If true, runs delta m mode in ProSight.", false},
    {MS_ProSight_Run_Subsequence_Search_mode, "MS:1003139", "ProSight:Run Subsequence Search mode", "If true, runs Subsequence Search mode in ProSight.", false},
    {MS_ProSight_Run_Annotated_Proteoform_Search_mode, "MS:1003140", "ProSight:Run Annotated Proteoform Search mode", "If true, runs Annotated Proteoform Search mode in ProSight.", false},
    {MS_ProSight, "MS:1003141", "ProSight", "ProSight: Database search engine for top-down proteomics.", false},
    {MS_TDPortal, "MS:1003142", "TDPortal", "TDPortal: Database search engine for top-down proteomics.", false},
    {MS_mass_array, "MS:1003143", "mass array", "A data array of mass values.", false},
    {MS_Triple_Quad_7500, "MS:1003144", "Triple Quad 7500", "SCIEX Triple Quad 7500.", false},
    {MS_ThermoRawFileParser, "MS:1003145", "ThermoRawFileParser", "Cross-platform software to convert Thermo RAW files to a number of open formats.", false},
    {MS_pyteomics, "MS:1003146", "pyteomics", "Python module that helps handling various proteomics data analysis tasks.", false},
    {MS_PTMProphet_probability, "MS:1003147", "PTMProphet probability", "Probability that one mass modification has been correctly localized to a specific residue as computed by PTMProphet.", false},
    {MS_PTMProphet_mean_best_probability, "MS:1003148", "PTMProphet mean best probability", "PSM-specific average of the m best site probabilities over all potential sites where m is the number of modifications of a specific type, as computed by PTMProphet.", false},
    {MS_PTMProphet_normalized_information_content, "MS:1003149", "PTMProphet normalized information content", " PTMProphet-computed PSM-specific normalized (0.0 - 1.0) measure of information content across all modifications of a specific type.", false},
    {MS_PTMProphet_information_content, "MS:1003150", "PTMProphet information content", " PTMProphet-computed PSM-specific measure of information content per modification type ranging from 0 to m, where m is the number of modifications of a specific type.", false},
    {MS_SHA_256, "MS:1003151", "SHA-256", "SHA-256 (member of Secure Hash Algorithm-2 family) is a cryptographic hash function designed by the National Security Agency (NSA) and published by the NIST as a U. S. government standard. It is also used to verify file integrity.", false},
    {MS_GCMS_QP2010SE, "MS:1003152", "GCMS-QP2010SE", "Shimadzu Scientific Instruments GCMS-QP2010SE.", false},
    {MS_raw_ion_mobility_drift_time_array, "MS:1003153", "raw ion mobility drift time array", "Array of raw ion mobility values from a drift time device, reported in seconds (or milliseconds), corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_deconvoluted_ion_mobility_array, "MS:1003154", "deconvoluted ion mobility array", "Array of ion mobility values (K or K0) based on ion separation in gaseous phase due to different ion mobilities under an electric field based on ion size, m/z and shape, as an average property of an analyte post peak-detection, weighted charge state reduction, and/or adduct aggregation, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_deconvoluted_inverse_reduced_ion_mobility_array, "MS:1003155", "deconvoluted inverse reduced ion mobility array", "Array of ion mobility values based on ion separation in gaseous phase due to different ion mobilities under an electric field based on ion size, m/z and shape, normalized for the local conditions and reported in volt-second per square centimeter, as an average property of an analyte post peak-detection, weighted charge state reduction, and/or adduct aggregation, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_deconvoluted_ion_mobility_drift_time_array, "MS:1003156", "deconvoluted ion mobility drift time array", "Array of mean ion mobility values from a drift time device, reported in seconds (or milliseconds), as an average property of an analyte post peak-detection, weighted charge state reduction, and/or adduct aggregation, corresponding to a spectrum of individual peaks encoded with an m/z array.", false},
    {MS_scanning_quadrupole_position_lower_bound_m_z_array, "MS:1003157", "scanning quadrupole position lower bound m/z array", "Array of m/z values representing the lower bound m/z of the quadrupole position at each point in the spectrum.", false},
    {MS_scanning_quadrupole_position_upper_bound_m_z_array, "MS:1003158", "scanning quadrupole position upper bound m/z array", "Array of m/z values representing the upper bound m/z of the quadrupole position at each point in the spectrum.", false},
    {MS_isolation_window_full_range, "MS:1003159", "isolation window full range", "Indicates an acquisition mode in which the isolation window is a full range, rather than a subset of the full range.", false},
    {MS_mzQC_format, "MS:1003160", "mzQC format", "Proteomics Standards Initiative mzQC format for quality control data.", false},
    {MS_quality_control_data_format, "MS:1003161", "quality control data format", "Grouping term for quality control data formats.", false},
    {MS_PTX_QC, "MS:1003162", "PTX-QC", "Proteomics (PTX) - QualityControl (QC) software for QC report generation and visualization.", false},
    {MS_analyte_mixture_members, "MS:1003163", "analyte mixture members", "The set of analyte identifiers that compose an interpretation of a spectrum.", false},
    {MS_QuaMeter_IDFree, "MS:1003164", "QuaMeter IDFree", "QuaMeter IDFree software for QC metric calculation.", false},
    {MS_iMonDB, "MS:1003165", "iMonDB", "iMonDB software to extract, store, and manage mass spectrometry instrument parameters from raw data files.", false},
    {MS_assigned_intensity_fraction, "MS:1003166", "assigned intensity fraction", "Fraction of intensity summed from all peaks that can be attributed to expected fragments of the analyte, divided by the intensity summed from all peaks in the spectrum", false},
    {MS_MSn_1_isolation_window_precursor_purity, "MS:1003167", "MSn-1 isolation window precursor purity", "The fraction of total intensities in the isolation window in the previous round of MS (i.e. the MSn-1 scan) that can be assigned to this identified analyte", false},
    {MS_library_spectrum_comment, "MS:1003168", "library spectrum comment", "A free-text string providing additional information of the library spectrum not encoded otherwise, usually for human use and not parsed by software tools.", false},
    {MS_proforma_peptidoform_sequence, "MS:1003169", "proforma peptidoform sequence", "Sequence string describing the amino acids and mass modifications of a peptidoform using the PSI ProForma notation", false},
    {MS_spectral_library, "MS:1003170", "spectral library", "A collection of spectra organized by their originating analyte, compiled deliberately for use in MS data analysis in future experiments", false},
    {MS_spectral_library_attribute, "MS:1003171", "spectral library attribute", "An attribute of a spectral library", false},
    {MS_library_spectrum, "MS:1003172", "library spectrum", "An entry in a spectral library representing a spectrum", false},
    {MS_numeric_attribute, "MS:1003173", "numeric attribute", "An attribute that takes on a numeric value", false},
    {MS_attribute_maximum, "MS:1003174", "attribute maximum", "The maximum value for this attribute", false},
    {MS_attribute_minimum, "MS:1003175", "attribute minimum", "The minimum value for this attribute", false},
    {MS_attribute_mean, "MS:1003176", "attribute mean", "The arithmetic mean value for this attribute", false},
    {MS_attribute_standard_deviation, "MS:1003177", "attribute standard deviation", "The standard deviation (exact value of population, or estimate from sample) of this attribute", false},
    {MS_attribute_coefficient_of_variation, "MS:1003178", "attribute coefficient of variation", "The coefficient of variation of this attribute, i.e. standard deviation divided by the mean", false},
    {MS_attribute_summary_value, "MS:1003179", "attribute summary value", "The most appropriate summary value of the attribute, usually but not necessarily the mean", false},
    {MS_attribute_median, "MS:1003180", "attribute median", "The median of this attribute", false},
    {MS_combined_dissociation_method, "MS:1003181", "combined dissociation method", "Combination of two or more dissociation methods that are known by a special term.", false},
    {MS_electron_transfer_collision_induced_dissociation, "MS:1003182", "electron-transfer/collision-induced dissociation", "Dissociation process combining electron-transfer dissociation (ETD) and collision-induced dissociation (CID).", false},
    {MS_Synapt_XS, "MS:1003183", "Synapt XS", "Waters oa-ToF based Synapt XS.", false},
    {MS_SELECT_SERIES_Cyclic_IMS, "MS:1003184", "SELECT SERIES Cyclic IMS", "Waters oa-ToF based SELECT SERIES Cyclic IMS.", false},
    {MS_SELECT_SERIES_MRT, "MS:1003185", "SELECT SERIES MRT", "Waters oa-ToF based SELECT SERIES MRT.", false},
    {MS_library_format_version, "MS:1003186", "library format version", "Version number of the [PSI] library format specification", false},
    {MS_library_identifier, "MS:1003187", "library identifier", "Short identifier for the library for easy reference, preferably but not necessarily globally unique", false},
    {MS_library_name, "MS:1003188", "library name", "A short name identifying the library to potential users. The same name may refer to multiple versions of the same continually updated library.", false},
    {MS_library_description, "MS:1003189", "library description", "Extended free-text description of the library", false},
    {MS_library_version, "MS:1003190", "library version", "Version number of the library, usually refering to a certain release of a continually updated library ", false},
    {MS_library_URI, "MS:1003191", "library URI", "URI or URL that uniquely identifies the library", false},
    {MS_decoy_spectrum, "MS:1003192", "decoy spectrum", "A spectrum deliberately introduced into a spectral library that necessarily produces incorrect identifications when matched, for the purpose of error control in spectral library searching", false},
    {MS_shuffle_and_reposition_decoy_spectrum, "MS:1003193", "shuffle-and-reposition decoy spectrum", "A decoy spectrum generated from a real spectrum, by shuffling the amino acid sequence of the identification of the real spectrum, followed by re-positioning annotated peaks to match the shuffled sequence.", false},
    {MS_precursor_shift_decoy_spectrum, "MS:1003194", "precursor shift decoy spectrum", "A decoy spectrum generated from a real spectrum, by changing the precursor m/z value of the real spectrum.", false},
    {MS_unnatural_peptidoform_decoy_spectrum, "MS:1003195", "unnatural peptidoform decoy spectrum", "A decoy spectrum that is either a real spectrum of an unnatural peptidoform (e.g. a synthetic peptide that cannot be found in nature), or an artificial spectrum predicted for such unnatural peptidoform", false},
    {MS_unrelated_species_decoy_spectrum, "MS:1003196", "unrelated species decoy spectrum", "A decoy spectrum that is a real spectrum of a naturally occuring peptidoform of an unrelated species that should not be found in the sample", false},
    {MS_license_URI, "MS:1003197", "license URI", "URI of the license controlling use of the library (e.g. https://creativecommons.org/publicdomain/zero/1.0/)", false},
    {MS_copyright_notice, "MS:1003198", "copyright notice", "Notice of statutorily prescribed form that informs users of the underlying claim to copyright ownership in a published work", false},
    {MS_change_log, "MS:1003199", "change log", "Extended free-text description of the difference from the previous version", false},
    {MS_software_version, "MS:1003200", "software version", "Version number of the software package used for library creation", false},
    {MS_library_provenance_attribute, "MS:1003201", "library provenance attribute", "Abstract term containing several different types of provenance information", false},
    {MS_BiblioSpec, "MS:1003202", "BiblioSpec", "A suite of software tools for creating and searching MS/MS peptide spectrum libraries, developed at the University of Washington", false},
    {MS_constituent_spectrum_file, "MS:1003203", "constituent spectrum file", "Spectrum data file from which (at least) a subset of spectra were extracted from. Should use USI notation mzspec:PXDxxxx:msRunName if possible, or a URI if USI notation is not possible.", false},
    {MS_constituent_identification_file, "MS:1003204", "constituent identification file", "Identification file where (at least) a subset of identifications were extracted from. Should use a URI if possible", false},
    {MS_constituent_library_file, "MS:1003205", "constituent library file", "Source library URI which(at least) a subset of spectra were extracted from.", false},
    {MS_library_creation_log, "MS:1003206", "library creation log", "String of logging information generated when the library was constructed from its constituent files. Multiple lines should be separated with escaped \\n", false},
    {MS_library_creation_software, "MS:1003207", "library creation software", "Library creation software", false},
    {MS_experimental_precursor_monoisotopic_m_z, "MS:1003208", "experimental precursor monoisotopic m/z", "The measured or inferred m/z (as reported by the mass spectrometer acquisition software or post-processing software) of the monoisotopic peak of the precursor ion based on the MSn-1 spectrum.", false},
    {MS_monoisotopic_m_z_deviation, "MS:1003209", "monoisotopic m/z deviation", "The measured monoisotopic m/z (as reported by the mass spectrometer acquisition software or post-processing software) minus the theoretical monoisotopic m/z of the analyte assigned to the spectrum.", false},
    {MS_average_m_z_deviation, "MS:1003210", "average m/z deviation", "The measured average m/z (as reported by the mass spectrometer acquisition software or post-processing software) minus the theoretical average m/z of the analyte assigned to the spectrum.", false},
    {MS_library_spectrum_attribute_set, "MS:1003211", "library spectrum attribute set", "A set of spectrum-related attributes that is shared by a subset of spectra within the same spectral library", false},
    {MS_library_attribute_set_name, "MS:1003212", "library attribute set name", "A name to refer to a library attribute set", false},
    {MS_mass_spectrometry_acquisition_method, "MS:1003213", "mass spectrometry acquisition method", "Mode of running a mass spectrometer method by which mass ranges are selected and possibly dissociated.", false},
    {MS_mass_spectrometry_acquisition_method_aspect, "MS:1003214", "mass spectrometry acquisition method aspect", "Specific aspect of a mass spectrometer method by which mass ranges are selected and possibly dissociated.", false},
    {MS_data_independent_acquisition, "MS:1003215", "data-independent acquisition", "Mass spectrometer data acquisition method wherein mass selection for fragmentation is configured according to a pre-determined program, rather than based on any detected precursor ions.", false},
    {MS_dissociation_of_full_mass_range, "MS:1003216", "dissociation of full mass range", "Mass spectrometer data acquisition method wherein all precursor ions of which the instrument is capable are fragmented at once..", false},
    {MS_dissociation_of_scanning_quadrupole_across_a_specified_mass_range, "MS:1003217", "dissociation of scanning quadrupole across a specified mass range", "Mass spectrometer data acquisition method wherein ????.", false},
    {MS_dissociation_of_sequential_mass_ranges, "MS:1003218", "dissociation of sequential mass ranges", "Mass spectrometer data acquisition method wherein a series of limited mass range fragmentation selection windows are preconfigured.", false},
    {MS_ion_mobility_separation, "MS:1003219", "ion mobility separation", "Mass spectrometer data acquisition method wherein precursor ions are separated by their ion mobility properties prior to measurement.", false},
    {MS_adduct_deconvolution, "MS:1003220", "adduct deconvolution", "Data processing action of merging of the measurements of potentially multiple adducts into a single representation that is independent of the small ion that adds charge to a larger molecule.", false},
    {MS_data_dependent_acquisition, "MS:1003221", "data-dependent acquisition", "Mass spectrometer data acquisition method wherein MSn spectra are triggered based on the m/z of precursor ions detected in the same run.", false},
    {MS_ion_mobility_deconvolution, "MS:1003222", "ion mobility deconvolution", "Data processing action of merging multiple ion peaks acquired at different ion mobility steps into a single mass spectrum representing a single analyte.", false},
    {MS_data_independent_acquisition_from_dissociation_of_sequential_mass_ranges, "MS:1003224", "data independent acquisition from dissociation of sequential mass ranges", "Data independent mass spectrometer acquisition method wherein a preconfigured sequence of mass ranges are fragmented. Examples of such an approach include SWATH-MS, FT-ARM, HRM, and PAcIFIC.", false},
    {MS_data_independent_acquisition_from_dissociation_of_sequential_mass_ranges_after_ion_mobility_separation, "MS:1003225", "data independent acquisition from dissociation of sequential mass ranges after ion mobility separation", "Data independent mass spectrometer acquisition method wherein a preconfigured sequence of mass ranges are fragmented after being separated by ion mobility. An example of such an approach is Bruker diaPASEF.", false},
    {MS_data_independent_acquisition_from_dissociation_of_full_mass_range_after_ion_mobility_separation, "MS:1003226", "data independent acquisition from dissociation of full mass range after ion mobility separation", "Data independent mass spectrometer acquisition method wherein the full mass range is fragmented after being separated by ion mobility. Examples of such an approach include HDMS^E and IMS-AIF.", false},
    {MS_data_independent_acquisition_from_dissociation_of_full_mass_range, "MS:1003227", "data independent acquisition from dissociation of full mass range", "Data independent mass spectrometer acquisition method wherein the full mass range is fragmented. Examples of such an approach include MS^E, AIF, and bbCID.", false},
    {MS_data_independent_acquisition_from_dissociation_of_scanning_quadrupole_across_mass_range, "MS:1003228", "data independent acquisition from dissociation of scanning quadrupole across mass range", "Data independent mass spectrometer acquisition method wherein ???. An example of such an approach is Waters SONAR.", false},
    {MS_timsTOF, "MS:1003229", "timsTOF", "Bruker Daltonics' timsTOF.", false},
    {MS_timsTOF_Pro_2, "MS:1003230", "timsTOF Pro 2", "Bruker Daltonics' timsTOF Pro 2.", false},
    {MS_timsTOF_SCP, "MS:1003231", "timsTOF SCP", "Bruker Daltonics' timsTOF SCP.", false},
    {MS_PeakForest, "MS:1003232", "PeakForest", "comprehensive infrastructure to organize, curate and share a multi- instrument spectral library for metabolomics data annotation developed and distributed by the French National infrastructure in metabolomics and fluxomics (MetaboHUB).", false},
    {MS_library_spectrum_attribute, "MS:1003234", "library spectrum attribute", "An attribute that describes information about an entry in a spectral library", false},
    {MS_paper_spray_ionization, "MS:1003235", "paper spray ionization", "The ionization of analytes from a piece of paper by applying a solvent and voltage.", false},
    {MS_library_spectrum_key, "MS:1003237", "library spectrum key", "An ordinal number uniquely identifying a spectrum in a library. Library spectrum keys should start at 1. Library spectrum keys SHOULD not change if entries are re-ordered or removed from a library.", false},
    {MS_library_analyte_attribute_set, "MS:1003238", "library analyte attribute set", "A set of analyte-related attributes that is shared by a subset of spectra within the same spectral library", false},
    {MS_library_interpretation_attribute_set, "MS:1003239", "library interpretation attribute set", "A set of interpretation-related attributes that is shared by a subset of spectra within the same spectral library", false},
    {MS_peak_intensity_transform, "MS:1003240", "peak intensity transform", "A mathematical transformation applied to peak intensities, for example, as a way to modify the weight put on each peak when computing spectral match scores", false},
    {MS_square_root_transform, "MS:1003241", "square root transform", "A mathematical transformation applied to peak intensities, in which peak intensities are replaced by their square roots", false},
    {MS_rank_transform, "MS:1003242", "rank transform", "A mathematical transformation applied to peak intensities, in which peak intensities are replaced by their ranks", false},
    {MS_adduct_ion_mass, "MS:1003243", "adduct ion mass", "The theoretical mass of the adduct ion (e.g. for a singly-charged protonated peptide ion, this value would be the neutral peptide molecule's mass plus the mass of a proton)", false},
    {MS_peptide_accession_number, "MS:1003244", "peptide accession number", "Accession number (e.g. in PeptideAtlas) of the peptide sequence", false},
    {MS_Q_Exactive_UHMR, "MS:1003245", "Q Exactive UHMR", "Thermo Scientific Q Exactive UHMR (Ultra High Mass Range) Hybrid Quadrupole Orbitrap MS.", false},
    {MS_ultraviolet_photodissociation, "MS:1003246", "ultraviolet photodissociation", "Multiphoton ionization where the reactant ion dissociates as a result of the absorption of multiple UV photons.", false},
    {MS_negative_electron_transfer_dissociation, "MS:1003247", "negative electron transfer dissociation", "A process to fragment ions in a mass spectrometer by inducing fragmentation of anions (e.g. peptides or proteins) by transferring electrons to a radical-cation.", false},
    {MS_proton_transfer_reaction, "MS:1003248", "proton transfer reaction", "Process to transfer a proton from a hydronium ion (H3O+) to neutral analyte, leading to a protonated analyte, which typically does not lead to fragmentation.", false},
    {MS_proton_transfer_charge_reduction, "MS:1003249", "proton transfer charge reduction", "Process to transfer one or more protons from a multiply charged cation (peptide or protein ion) to a proton acceptor anion or neutral basic compound, thereby reducing the charge of the original analyte.", false},
    {MS_count_of_identified_peptidoforms, "MS:1003250", "count of identified peptidoforms", "The number of peptidoforms that pass the threshold to be considered identified with sufficient confidence.", false},
    {MS_count_of_identified_spectra, "MS:1003251", "count of identified spectra", "The number of spectra that pass the threshold to be considered identified with sufficient confidence.", false},
    {MS_Xevo_G2_XS_QTof, "MS:1003252", "Xevo G2-XS QTof", "Waters Corporation Xevo G2-XS QTof quadrupole time-of-flight mass spectrometer.", false},
    {MS_DIA_NN, "MS:1003253", "DIA-NN", "A universal software for data-independent acquisition (DIA) proteomics data processing", false},
    {MS_peak_attribute, "MS:1003254", "peak attribute", "An attribute of a peak in a mass spectrum other than its m/z, intensity, and annotation. ", false},
    {MS_pre_decharged_charge_state, "MS:1003255", "pre-decharged charge state", "For a de-charged spectrum, the original charge state of the ion observed in a mass spectrum determined by charge deconvolution. ", false},
    {MS_peptidoform_ion_attribute, "MS:1003256", "peptidoform ion attribute", "Non-inherent characteristic attributed to a peptidoform", false},
    {MS_library_spectrum_cross_reference, "MS:1003257", "library spectrum cross reference", "A link from one spectrum to another spectrum of interest ", false},
    {MS_related_spectrum, "MS:1003258", "related spectrum", "A cross reference to another spectrum that has some relationship with this one, but is not necessarily spectrally similar. ", false},
    {MS_related_spectrum_keys, "MS:1003259", "related spectrum keys", "A list of cross references to a related spectrum in the same library, in the form of the library spectrum key.  ", false},
    {MS_related_spectrum_USI, "MS:1003260", "related spectrum USI", "A cross reference to a related spectrum in the form of a PSI Universal Spectrum Identifier", false},
    {MS_related_spectrum_description, "MS:1003261", "related spectrum description", "A free-text string describing the related spectrum and/or its relationship to this spectrum", false},
    {MS_similar_spectrum, "MS:1003262", "similar spectrum", "A cross reference to another spectrum that has high spectral similarity with this one, usually assumed to originate from the same analyte ion.", false},
    {MS_similar_spectrum_keys, "MS:1003263", "similar spectrum keys", "A list of cross references to a similar spectrum in the same library, in the form of the library spectrum key.  ", false},
    {MS_similar_spectrum_USI, "MS:1003264", "similar spectrum USI", "A cross reference to a similar spectrum in the form of a PSI Universal Spectrum Identifier", false},
    {MS_spectrum_cluster, "MS:1003265", "spectrum cluster", "A group of spectra that are spectrally similar to each other", false},
    {MS_spectrum_cluster_attribute, "MS:1003266", "spectrum cluster attribute", "A non-inherent characteristic of a spectrum cluster", false},
    {MS_spectrum_cluster_key, "MS:1003267", "spectrum cluster key", "An ordinal number uniquely identifying a spectrum cluster. It should start with 1.", false},
    {MS_spectrum_cluster_member_spectrum_keys, "MS:1003268", "spectrum cluster member spectrum keys", "A list of integers corresponding to the library spectrum keys of the members of this cluster. These members must be in the same library.", false},
    {MS_spectrum_cluster_member_USI, "MS:1003269", "spectrum cluster member USI", "A member of this cluster external to the library, specified using a PSI Universal Spectrum Identifier.", false},
    {MS_proforma_peptidoform_ion_notation, "MS:1003270", "proforma peptidoform ion notation", "A string describing the peptidoform ion using the PSI ProForma notation, which should include the charge state, and optionally the adduct type.", false},
    {MS_peak_annotation, "MS:1003271", "peak annotation", "The molecular identity(-ies) of the ion(s) producing this peak, inferred manually or computationally based on its m/z and the molecular interpretation of the spectrum.", false},
    {MS_peak_annotation_string, "MS:1003272", "peak annotation string", "A string representing the peak annotation, in a defined format specified by the attribute 'ion annotation format'.", false},
    {MS_peak_annotation_confidence, "MS:1003273", "peak annotation confidence", "A confidence value of assigning a peak annotation to a peak, as defined by the attribute 'peak annotation confidence metric'.", false},
    {MS_peak_annotation_confidence_metric, "MS:1003274", "peak annotation confidence metric", "A confidence metric of assigning a peak annotation to a peak. By default, this should range from 0 (no confidence) to 1 (certain), and if there are multiple annotations of the same peak, the sum of their confidence levels should be no more than 1.", false},
    {MS_other_attribute_name, "MS:1003275", "other attribute name", "A user-provided name for a user-defined value describing a trait not covered by an existing controlled vocabulary term. This term should be used sparingly, preferring existing terms that describe the specific concept. Should be used with MS:1003276 to provide the attribute's value", false},
    {MS_other_attribute_value, "MS:1003276", "other attribute value", "A user-provided value for a user-defined name describing a trait not covered by an existing controlled vocabulary term. This term should be used sparingly, preferring existing terms that describe the specific concept. Should be used with MS:1003275 to provide the attribute's name", false},
    {MS_value_between__1_and_1_inclusive, "MS:1003277", "value between -1 and 1 inclusive", "Value range for signed normalized score values.", false},
    {MS_m_z_variability_of_peak, "MS:1003278", "m/z variability of peak", "A measure of the statistical variability of the m/z value of this peak, usually estimated from replicate spectra of the same analyte.", false},
    {MS_observation_frequency_of_peak, "MS:1003279", "observation frequency of peak", "The frequency at which this peak is observed among replicate spectra of the same analyte.", false},
    {MS_intensity_variability_of_peak, "MS:1003280", "intensity variability of peak", "A measure of the statistical variability of the intensity of this peak, usually estimated from replicate spectra of the same analyte.", false},
    {MS_Casanovo, "MS:1003281", "Casanovo", "Casanovo is a deep learning-based de novo spectrum identification tool. Official website https://github.com/Noble-Lab/casanovo/.", false},
    {MS_Bruker_TSF_format, "MS:1003282", "Bruker TSF format", "Bruker TSF raw file format.", false},
    {MS_Bruker_TSF_nativeID_format, "MS:1003283", "Bruker TSF nativeID format", "Native format defined by frame=xsd:nonNegativeInteger.", false},
    {MS_Bruker_TSF_nativeID_format__combined_spectra, "MS:1003284", "Bruker TSF nativeID format, combined spectra", "Bruker TSF comma separated list of spectra that have been combined prior to searching or interpretation.", false},
    {MS_standard_deviation_of_m_z_values_of_peak_among_replicates, "MS:1003285", "standard deviation of m/z values of peak among replicates", "The standard deviation of the m/z values of this peak among the replicate spectra of the same analyte.", false},
    {MS_coefficient_of_variation_of_intensity_of_peak_among_replicates, "MS:1003286", "coefficient of variation of intensity of peak among replicates", "The coefficient of variation (standard deviation divided by mean) of the intensities of this peak among the replicate spectra of the same analyte.", false},
    {MS_standard_deviation_of_intensity_of_peak_among_replicates, "MS:1003287", "standard deviation of intensity of peak among replicates", "The standard deviation of the intensities of this peak among the replicate spectra of the same analyte.", false},
    {MS_number_of_unassigned_peaks, "MS:1003288", "number of unassigned peaks", "The number of unassigned peaks in the spectrum.", false},
    {MS_intensity_of_highest_unassigned_peak, "MS:1003289", "intensity of highest unassigned peak", "The intensity of the highest unassigned peak in the spectrum.", false},
    {MS_number_of_unassigned_peaks_among_top_20_peaks, "MS:1003290", "number of unassigned peaks among top 20 peaks", "The number of unassigned peaks among the most intense 20 peaks in the spectrum.", false},
    {MS_Luciphor_deltaScore, "MS:1003291", "Luciphor deltaScore", "Luciphor phosphosite localization score", false},
    {MS_TSQ_Altis_Plus, "MS:1003292", "TSQ Altis Plus", "Thermo Scientific TSQ Altis Plus Triple Quadrupole MS.", false},
    {MS_ZenoTOF_7600, "MS:1003293", "ZenoTOF 7600", "SCIEX ZenoTOF 7600.", false},
    {MS_electron_activated_dissociation, "MS:1003294", "electron activated dissociation", "A process to fragment ions in a high intensity electron beam which results in a dissociation of various analytes ranging from singly charged small molecules to multiply protonated proteins.", false},
    {MS_summary_statistics_of_replicates, "MS:1003295", "summary statistics of replicates", "Summary statistics of an attribute among all replicates that are aggregated to generate this spectrum.", false},
    {MS_number_of_replicates_spectra_used_from_source, "MS:1003296", "number of replicates spectra used from source", "The number of replicate spectra used during the aggregation process that originate from a specified source (e.g. a file, a dataset, a sample type, etc.). This term must appear in a group alongside a source term, which is one of: 'ProteomeXchange accession number', 'constituent spectrum file', or 'sample name'", false},
    {MS_contributing_replicate_spectrum, "MS:1003297", "contributing replicate spectrum", "A cross reference to another spectrum that is a replicate spectrum of the same analyte and contributes to the generation of this aggregated spectrum.", false},
    {MS_contributing_replicate_spectrum_keys, "MS:1003298", "contributing replicate spectrum keys", "A list of cross references to contributing replicate spectra in the same library, in the form of library spectrum keys.", false},
    {MS_contributing_replicate_spectrum_USI, "MS:1003299", "contributing replicate spectrum USI", "A list of cross references to contributing replicate spectra, in the form of PSI Universal Spectrum Identifiers.", false},
    {MS_spectrum_match, "MS:1003300", "spectrum match", "Result of a comparison of a spectrum to another spectrum, usually to assess the plausibility that the two spectra originate from the same analyte.", false},
    {MS_peptide_spectrum_match, "MS:1003301", "peptide-spectrum match", "Result of a comparison of an observed fragment ion spectrum to the theoretically predicted fragmentation pattern of a peptide sequence, to assess the plausibility that the observed spectrum originates from the putative peptide sequence.", false},
    {MS_spectrum_spectrum_match, "MS:1003302", "spectrum-spectrum match", "Result of a comparison of an observed fragment ion spectrum to another observed fragment ion spectrum, to assess the plausibility that two spectra originate from the same analyte, e.g., in spectral library searching and spectrum clustering.", false},
    {MS_spectral_similarity, "MS:1003303", "spectral similarity", "A measure of how similar two spectra are, based on the features of the spectra (the locations and intensities of peaks) alone.", false},
    {MS_spectral_dot_product, "MS:1003304", "spectral dot product", "The dot (inner) product of two vectorized spectra divided by the product of their vector norms. It ranges from 0 (orthogonal vectors) to 1 (collinear vectors). Also known as cosine similarity.", false},
    {MS_spectral_Euclidean_distance, "MS:1003305", "spectral Euclidean distance", "The Euclidean distance between a pair of points representing two vectorized spectra in high-dimensional space.", false},
    {MS_shared_peak_count, "MS:1003306", "shared peak count", "The number of peaks with closely matching m/z values that are common to two spectra.", false},
    {MS_normalized_spectral_angle, "MS:1003307", "normalized spectral angle", "The angle subtended by two vectorized spectra in high-dimensional space. It is equal to the 1 - (2 * inverse cosine of the spectral dot product) / pi.", false},
    {MS_spectral_Pearson_correlation, "MS:1003308", "spectral Pearson correlation", "The Pearson's rho statistic between a pair of points representing two vectorized spectra.", false},
    {MS_Goslin, "MS:1003309", "Goslin", "The Goslin implementations parse common lipid name dialects and normalize them to the recent lipid shorthand nomenclature based on grammars on succinct lipid nomenclature.", false},
    {MS_Lipid_shorthand_identification_confidence_level, "MS:1003310", "Lipid shorthand identification confidence level", "Identification confidence levels based on the updated lipid shorthand nomenclature. The value slot can have the values 'Category', 'Class', 'Species', 'Phosphate-position', 'Molecular species', 'sn-position', 'DBE position', 'Structure defined', 'Full structure', 'Complete structure'.", false},
    {MS_Lipid_empirical_score, "MS:1003311", "Lipid empirical score", "The lipid empirical score is a point-based lipid class-specific scoring system based on MS and other evidence sources as defined by the Lipidomics Standards Initiative (LSI). The score has a numeric value between 0 and 100. Score values are lipid class-specific and are therefore not immediately comparable between lipid classes.", false},
    {MS_Lipid_shorthand_identification_confidence___Category, "MS:1003312", "Lipid shorthand identification confidence - Category", "Lipid shorthand identification confidence level 'Category'.", false},
    {MS_Lipid_shorthand_identification_confidence___Class, "MS:1003313", "Lipid shorthand identification confidence - Class", "Lipid shorthand identification confidence level 'Class'.", false},
    {MS_Lipid_shorthand_identification_confidence___Species, "MS:1003314", "Lipid shorthand identification confidence - Species", "Lipid shorthand identification confidence level 'Species'.", false},
    {MS_Lipid_shorthand_identification_confidence___Phosphate_position, "MS:1003315", "Lipid shorthand identification confidence - Phosphate-position", "Lipid shorthand identification confidence level 'Phosphate-position'.", false},
    {MS_Lipid_shorthand_identification_confidence___Molecular_species, "MS:1003316", "Lipid shorthand identification confidence - Molecular species", "Lipid shorthand identification confidence level 'Molecular species'.", false},
    {MS_Lipid_shorthand_identification_confidence___sn_position, "MS:1003317", "Lipid shorthand identification confidence - sn-position", "Lipid shorthand identification confidence level 'sn-position'.", false},
    {MS_Lipid_shorthand_identification_confidence___DBE_pos, "MS:1003318", "Lipid shorthand identification confidence - DBE pos", "Lipid shorthand identification confidence level 'DBE pos'.", false},
    {MS_Lipid_shorthand_identification_confidence___Structure_defined, "MS:1003319", "Lipid shorthand identification confidence - Structure defined", "Lipid shorthand identification confidence level 'Structure defined'.", false},
    {MS_spectrum_cluster_size, "MS:1003320", "spectrum cluster size", "The number of spectra in a spectrum cluster.", false},
    {MS_summary_statistics_of_clustered_spectra, "MS:1003321", "summary statistics of clustered spectra", "Summary statistics of an attribute among all spectra of a spectrum cluster.", false},
    {MS_spectrum_cluster_best_representative, "MS:1003322", "spectrum cluster best representative", "Cross reference to the spectrum that is considered the most representative among spectra in a cluster, either as a library spectrum key if the best representative is in the same library, or a universal spectrum identifier if it is not.", false},
    {MS_spectrum_cluster_consensus_spectrum, "MS:1003323", "spectrum cluster consensus spectrum", "Cross reference to a consensus spectrum that is constructed from aggregating spectra in a cluster, either as a library spectrum key if the consensus spectrum is in the same library, or a universal spectrum identifier if it is not.", false},
    {MS_spectral_dot_product_to_aggregated_spectrum, "MS:1003324", "spectral dot product to aggregated spectrum", "Spectral similarity measured by the spectral dot product between a replicate to its corresponding aggregated (e.g. consensus) spectrum.", false},
    {MS_Lipid_shorthand_identification_confidence___Full_structure, "MS:1003325", "Lipid shorthand identification confidence - Full structure", "Lipid shorthand identification confidence level 'Full structure'.", false},
    {MS_Lipid_shorthand_identification_confidence___Complete_structure, "MS:1003326", "Lipid shorthand identification confidence - Complete structure", "Lipid shorthand identification confidence level 'Complete structure'.", false},
    {MS_number_of_identified_protein_groups, "MS:1003327", "number of identified protein groups", "The number of protein groups that pass the threshold to be considered identified with sufficient confidence.", false},
    {MS_number_of_identified_proteoforms, "MS:1003328", "number of identified proteoforms", "The number of proteoforms that pass the threshold to be considered identified with sufficient confidence.", false},
    {MS_looplink_spectrum_identification_item, "MS:1003329", "looplink spectrum identification item", "Identification of an internally linked peptide (a peptide that contains both ends of a crosslink), also known as a looplink.", false},
    {MS_noncovalently_associated_peptides_search, "MS:1003330", "noncovalently associated peptides search", "Noncovalently associated peptides search performed. Noncovalently associated peptides are two different peptides which were not crosslinked but stayed associated with each other throughout the workflow, due to noncovalent interactions.", false},
    {MS_noncovalently_associated_peptides_spectrum_identification_item, "MS:1003331", "noncovalently associated peptides spectrum identification item", "Noncovalently associated peptides spectrum identification item.", false},
    {MS_identification_based_on_multiple_spectra, "MS:1003332", "identification based on multiple spectra", "Provides an identifier to encode identifications based on multiple spectra.", false},
    {MS_regular_expression_for_encoding_identifications_based_on_multiple_spectra_, "MS:1003333", "regular expression for encoding identifications based on multiple spectra.", "^(?<MULTIPLE_SPECTRA_IDENTIFIER>[0-9]+)(?::(?<PARENT_OR_CHILD>P|C))$", false},
    {MS_parent_term_for_PSM_level_scores_for_identifications_based_on_multiple_spectra, "MS:1003334", "parent term for PSM-level scores for identifications based on multiple spectra", "Parent term for PSM-level scores for identifications based on multiple spectra.", false},
    {MS_regular_expression_for_PSM_level_scores_for_identifications_based_on_multiple_spectra, "MS:1003335", "regular expression for PSM-level scores for identifications based on multiple spectra", "^(?<MULTIPLE_SPECTRA_IDENTIFIER>[0-9]+):(?<SCORE>[-+]?[0-9]+(?:[.][0-9]+)?(?:[Ee][-+]?[0-9]+))$", false},
    {MS_posterior_error_probability_from_identification_based_on_multiple_spectra, "MS:1003336", "posterior error probability from identification based on multiple spectra", "PEP score for identifications based on multiple spectra.", false},
    {MS_crosslinked_PSM_level_global_FDR, "MS:1003337", "crosslinked PSM-level global FDR", "Estimation of the global false discovery rate of crosslinked peptide spectrum matches.", false},
    {MS_peptide_pair_sequence_level_global_FDR, "MS:1003338", "peptide-pair sequence-level global FDR", "Estimation of the global false discovery rate for distinct peptide-pairs (id est multiple PSMs have been collapsed to one entry). Applicable in the case of crosslinked peptides or noncovalently associated peptides.", false},
    {MS_peptide_pair_passes_threshold, "MS:1003339", "peptide-pair passes threshold", "Peptide-pair passes threshold. Applicable in the case of crosslinked peptides or noncovalently associated peptides.", false},
    {MS_residue_pair_passes_threshold, "MS:1003340", "residue-pair passes threshold", "Residue-pair passes threshold. In the context of crosslinking experiments, a residue-pair is a unique pair of crosslinked residues, irrespective of the peptides identified (A level of consolidation higher than unique peptide but lower than PPI).", false},
    {MS_protein_protein_interaction_passes_threshold, "MS:1003341", "protein-protein interaction passes threshold", "Protein-protein interaction passes threshold.", false},
    {MS_regular_expression_for_whether_interaction_score_derived_from_crosslinking_passes_threshold, "MS:1003342", "regular expression for whether interaction score derived from crosslinking passes threshold", "^((?<int_ID>[0-9]+):(?<PASS_THRESHOLD>true|false))$", false},
    {MS_FDR_applied_separately_to_self_crosslinks_and_protein_heteromeric_crosslinks, "MS:1003343", "FDR applied separately to self crosslinks and protein heteromeric crosslinks", "States whether FDR was applied separately to self crosslinks (crosslinks between peptides within one protein sequence) and protein heteromeric crosslinks (crosslinks between distinct protein sequences).", false},
    {MS_residue_pair_ref, "MS:1003344", "residue-pair ref", "Reference to a residue-pair supported by this identification item, the value is the identifier for the residue-pair. In the context of crosslinking experiments, a residue-pair is a unique pair of crosslinked residues, irrespective of the peptides identified (A level of consolidation higher than unique peptide but lower than PPI).", false},
    {MS_regular_expression_for_residue_pair_ref, "MS:1003345", "regular expression for residue-pair ref", "^(([0-9]+).(a|b))$", false},
    {MS_cleavable_crosslinker_stub, "MS:1003346", "cleavable crosslinker stub", "This term indicates that a given  protein modification is a derivative of a cleavable crosslinker.", false},
    {MS_Unimod_derivative_code, "MS:1003347", "Unimod derivative code", "The single letter code in Unimod that identifies a specific derivative of a modification. For example, in UNIMOD:1842 (http://www.unimod.org/modifications_view.php?editid1=1842) the letter ‘W’ represents the derivative ‘water quenched monolink’.", false},
    {MS_proteomics, "MS:1003348", "proteomics", "large-scale study of proteins and proteomes.", false},
    {MS_affinity_proteomics, "MS:1003349", "affinity proteomics", "large-scale study of proteins and proteomes via the use of affinity reagents.", false},
    {MS_mass_spectrometry_proteomics, "MS:1003350", "mass spectrometry proteomics", "large-scale study of proteins and proteomes via the use of mass spectrometers to measure the masses and abundances of charged proteins or protein fragments.", false},
    {MS_top_down_proteomics, "MS:1003351", "top-down proteomics", "study of proteins via the use of mass spectrometers to measure the masses and abundances of charged intact proteins.", false},
    {MS_native_top_down_proteomics, "MS:1003352", "native top-down proteomics", "study of proteins via the use of mass spectrometers to measure the masses and abundances of charged intact folded proteins.", false},
    {MS_non_native_top_down_proteomics, "MS:1003353", "non-native top-down proteomics", "study of proteins via the use of mass spectrometers to measure the masses and abundances of charged intact denatured proteins.", false},
    {MS_middle_down_proteomics, "MS:1003354", "middle-down proteomics", "study of proteins via the use of mass spectrometers to measure the masses and abundances of large protein fragments after partial digestion of denatured proteins.", false},
    {MS_bottom_up_proteomics, "MS:1003355", "bottom-up proteomics", "study of proteins via the use of mass spectrometers to measure the masses and abundances of peptides after complete digestion of denatured proteins.", false},
    {MS_Orbitrap_Ascend, "MS:1003356", "Orbitrap Ascend", "Thermo Scientific Orbitrap Ascend mass spectrometer with Tribrid architecture consisting of quadrupole mass filter, linear ion trap and Orbitrap mass analyzers.", false},
    {MS_ANN_SoLo, "MS:1003357", "ANN-SoLo", "ANN-SoLo (Approximate Nearest Neighbor Spectral Library) is a spectral library search engine for fast and accurate open modification searching. ANN-SoLo uses approximate nearest neighbor indexing to speed up open modification searching by selecting only a limited number of the most relevant library spectra to compare to an unknown query spectrum. This is combined with a cascade search strategy to maximize the number of identified unmodified and modified spectra while strictly controlling the false discovery rate and the shifted dot product score to sensitively match modified spectra to their unmodified counterpart.", false},
    {MS_XCorr_rank, "MS:1003358", "XCorr rank", "The rank of this PSM relative to all other PSMs involving this spectrum, when sorting by the XCorr score.", false},
    {MS_exact_p_value, "MS:1003359", "exact p-value", "A p-value for the XCorr score, calculated using dynamic programming.", false},
    {MS_refactored_XCorr, "MS:1003360", "refactored XCorr", "A modified version of the XCorr score that is made amenable to dynamic programming calculation of p-values by changing a max operation to a sum.", false},
    {MS_res_ev_score, "MS:1003361", "res-ev score", "The residue-evidence (res-ev) score measures the quality of a match between a peptide and observed spectrum using a method similar to XCorr, but considering all pairs of observed peaks.", false},
    {MS_res_ev_rank, "MS:1003362", "res-ev rank", "The rank of this PSM relative to all other PSMs involving this spectrum, when sorting by the res-ev score.", false},
    {MS_res_ev_p_value, "MS:1003363", "res-ev p-value", "The residue-evidence p-value is computed from the residue-evidence score using a dynamic programming procedure.", false},
    {MS_combined_p_value, "MS:1003364", "combined p-value", "A p-value that is computed by taking the product of the exact p-value and the res-ev p-value and then adjusting for dependencies between them.", false},
    {MS_combined_p_value_rank, "MS:1003365", "combined p-value rank", "The rank of this PSM relative to all other PSMs involving this spectrum, when sorting by the combined p-value.", false},
    {MS_tailor_score, "MS:1003366", "tailor score", "A calibrated version of the XCorr score, computed by dividing the XCorr by the 99th percentile of the distribution of all scores for a particular spectrum.", false},
    {MS_monoisotopic_mass_deisotoping, "MS:1003367", "monoisotopic mass deisotoping", "The removal of isotope peaks to represent each ion as one data point corresponding to the ion's monoisotopic mass. It is done in conjunction with the charge state deconvolution.", false},
    {MS_most_abundant_mass_deisotoping, "MS:1003368", "most abundant mass deisotoping", "The removal of isotope peaks to represent each ion as one data point corresponding to the ion's most abundant isotopic mass. It is done in conjunction with the charge state deconvolution.", false},
    {MS_average_mass_deisotoping, "MS:1003369", "average mass deisotoping", "The removal of isotope peaks to represent each ion as one data point corresponding to the ion's average mass. It is done in conjunction with the charge state deconvolution.", false},
    {MS_reduction_to_summed_singly_charged_peak_list, "MS:1003370", "reduction to summed singly charged peak list", "The summing of peaks corresponding to the same mass at multiple charge states and presented as singly charged m/z.", false},
    {MS_SelexION_compensation_voltage, "MS:1003371", "SelexION compensation voltage", "The voltage applied in the SelexION device to allow certain ions to transmit through to the mass spectrometer.", false},
    {MS_specification_document_extension_version, "MS:1003372", "specification document extension version", "The versioning of a an extension to a specification document that the current file requires to be read correctly. The version should encode the name of the extension, and some ordinal expression of its revision, preferably in semantic versioning notation. Signals that readers that do not know this extension should return an appropriately informative error if they do not think they can or should try to interpret the file.", false},
    {MS_mzIdentML_extension_version, "MS:1003373", "mzIdentML extension version", "The versioning of an mzIdentML extension document.", false},
    {MS_Open_Chromatography_Binary_OCB_format, "MS:1003374", "Open Chromatography Binary OCB format", "ChemClipse/OpenChrom file format.", false},
    {MS_Conversion_to_OCB, "MS:1003375", "Conversion to OCB", "Conversion of a file format to Open Chromatography Binary OCB file format.", false},
    {MS_ChemClipse, "MS:1003376", "ChemClipse", "ChemClipse is part of the Eclipse Science project. Primarily developed by Lablicate GmbH.", false},
    {MS_OpenChrom, "MS:1003377", "OpenChrom", "OpenChrom is an Open Source software for data processing and analysis. Based upon Eclipse ChemClipse.", false},
    {MS_Orbitrap_Astral, "MS:1003378", "Orbitrap Astral", "Thermo Scientific Orbitrap Astral mass spectrometer contains three mass analyzers: a quadrupole analyzer, an Orbitrap analyzer, and the Astral analyzer.", false},
    {MS_asymmetric_track_lossless_time_of_flight_analyzer, "MS:1003379", "asymmetric track lossless time-of-flight analyzer", "A TOF-like mass analyzer with asymmetric ion mirrors to direct ions into transversal asymmetric oscillations and ion foil shapes and maintains ion packet for transmission and resolution.", false},
    {MS_Xevo_G3_QTof, "MS:1003380", "Xevo G3 QTof", "Waters Corporation Xevo G3 QTof quadrupole time-of-flight mass spectrometer.", false},
    {MS_ACQUITY_RDa_Detector, "MS:1003381", "ACQUITY RDa Detector", "Waters Corporation RDa time-of-flight mass detector.", false},
    {MS_waters_connect, "MS:1003382", "waters_connect", "Waters Corporation waters_connect software for liquid chromatography and mass spectrometry acquisition and processing.", false},
    {MS_timsTOF_Ultra, "MS:1003383", "timsTOF Ultra", "Bruker Daltonics' timsTOF Ultra.", false},
    {MS_semantic_version_regexp, "MS:1003384", "semantic version regexp", "v?(\\d+)\\.(\\d+)\\.(\\d+)(?:-(\\S+))?", false},
    {MS_mzIdentML_crosslinking_extension_document_version, "MS:1003385", "mzIdentML crosslinking extension document version", "The versioning of the crosslinking mzIdentML extension document.", false},
    {MS_Spectra, "MS:1003386", "Spectra", "Bioconductor package Spectra for mass spectrometry data representation and processing.", false},
    {MS_MetaboAnnotation, "MS:1003387", "MetaboAnnotation", "Bioconductor package MetaboAnnotation for annotation of untargeted metabolomics data.", false},
    {MS_CompoundDb, "MS:1003388", "CompoundDb", "Bioconductor package CompoundDb for creation, usage and maintenance of public or library-specific annotation databases and spectra libraries.", false},
    {MS_mzTab_M, "MS:1003389", "mzTab-M", "Expanded tabular result format for metabolomics experiments reporting quantitative summary data, MS features and identification evidence.", false},
    {MS_crosslinker_cleavage_characteristics, "MS:1003390", "crosslinker cleavage characteristics", "Signifies that the crosslinker is cleavable and on cleavage can leave a given stub. The pattern specifies three slots <name>:<mass>:<pairs with>.", false},
    {MS_crosslinker_cleavage_regular_expression, "MS:1003391", "crosslinker cleavage regular expression", "^(?<NAME>[A-Za-z]):(?<MASS>[+-]?[0-9]+(\\.[0-9]+)?([eE][+-]?[0-9]+(\\.[0-9]+)?)?):(?<PAIRS_WITH>[A-Za-z]+)$", false},
    {MS_search_modification_id, "MS:1003392", "search modification id", "A unique identifier within an in mzIdentML document denoting a search modification rule. The same modification may be present multiple times with different id values to reflect different specificities or neutral losses.", false},
    {MS_search_modification_id_ref, "MS:1003393", "search modification id ref", "A reference to a `search modification id` in the current mzIdentML document that defines the properties of this modification instance.", false},
    {MS_SelexION_separation_voltage, "MS:1003394", "SelexION separation voltage", "RF voltage applied in the SelexION device to separate ions in trajectory based on the difference in their mobility between the high field and low field portions of the applied RF.", false},
    {MS_Q_Exactive_GC_Orbitrap, "MS:1003395", "Q Exactive GC Orbitrap", "Q Exactive GC Orbitrap GC-MS/MS hybrid quadrupole Orbitrap mass spectrometer.", false},
    {MS_8890_GC_MS, "MS:1003396", "8890 GC/MS", "Agilent 8890 Gas Chromatograph System.", false},
    {MS_timsTOF_fleX_MALDI_2, "MS:1003397", "timsTOF fleX MALDI-2", "Bruker Daltonics' timsTOF fleX MALDI-2.", false},
    {MS_deconvoluted_data, "MS:1003398", "deconvoluted data", "The data contained in this file have been processed to remove, collapse, or label one or more dimensions of the original dataset, such as charge deconvolution or ion mobility deconvolution. To determine the type of deconvolution done, the reader should consult the appropriate section of the file, such as the data processing methods in an mzML file.", false},
    {MS_quality_control_software, "MS:1003399", "quality control software", "Software that creates or manipulates QC-related data.", false},
    {MS_rmzqc, "MS:1003400", "rmzqc", "An R package for reading, validating, and writing mzQC files.", false},
    {MS_jmzqc, "MS:1003401", "jmzqc", "A Java package for reading, validating, and writing mzQC files.", false},
    {MS_pymzqc, "MS:1003402", "pymzqc", "A Python package for reading, validating, and writing mzQC files.", false},
    {MS_PSI_MS_CV_Quality_Control_Vocabulary, "MS:4000000", "PSI-MS CV Quality Control Vocabulary", "PSI Quality Control controlled vocabulary term.", false},
    {MS_QC_metric, "MS:4000001", "QC metric", "Parent term for QC metrics, each metric MUST have this as an ancestor in its is_a relations.", false},
    {MS_QC_metric_value_type, "MS:4000002", "QC metric value type", "The QC metric type describes what type the corresponding metric is. Possible types are single value, n-tuple, table, or matrix.", false},
    {MS_single_value, "MS:4000003", "single value", "Metrics consisting of a single value. The value must have a unit (e.g. UO:0000221 ! dalton or UO:0000187 ! percent), and optionally a type (e.g. STATO:0000574 ! median or MS:1002354 ! PSM-level q-value).", false},
    {MS_n_tuple, "MS:4000004", "n-tuple", "Metrics consisting of multiple values, with the number of values implicitly specified by length of the JSON array (e.g. length 4 for quartiles). All values must be given a unit (e.g. UO:0000221 ! dalton or UO:0000187 ! percent), and optionally a type (e.g. STATO:0000574 ! median or MS:1002354 ! PSM-level q-value). All values in the tuple must have the same unit and type (if applicable).", false},
    {MS_table, "MS:4000005", "table", "Metrics consisting of a table or data frame. The values of the table may have different types in each column (in contrast to a matrix). Each column must have a unit (identical for all entries of this column) and may have a value type (e.g. STATO:0000574 ! median or MS:1002354 ! PSM-level q-value).", false},
    {MS_matrix, "MS:4000006", "matrix", "A matrix is a rectangular array of values of the same type (in contrast to a table). All values must be given a unit (e.g. UO:0000221 ! dalton or UO:0000187 ! percent), and optionally a type (e.g. STATO:0000574 ! median or MS:1002354 ! PSM-level q-value). All values in the matrix must have the same unit and type (if applicable).", false},
    {MS_QC_metric_category, "MS:4000007", "QC metric category", "Categorization of the QC metric.", false},
    {MS_ID_based_metric, "MS:4000008", "ID based metric", "QC metric based on identification results.", false},
    {MS_ID_free_metric, "MS:4000009", "ID free metric", "QC metric not based on identification results.", false},
    {MS_quantification_based_metric, "MS:4000010", "quantification based metric", "QC metric based on quantification results.", false},
    {MS_single_run_based_metric, "MS:4000012", "single run based metric", "QC metric calculated from a single run (e.g. one .raw file).", false},
    {MS_multiple_runs_based_metric, "MS:4000013", "multiple runs based metric", "QC metric calculated from multiple runs (e.g. multiple .raw files).", false},
    {MS_single_spectrum_based_metric, "MS:4000014", "single spectrum based metric", "QC metric calculated from a single spectrum.", false},
    {MS_multiple_spectra_based_metric, "MS:4000015", "multiple spectra based metric", "QC metric calculated from multiple spectra.", false},
    {MS_retention_time_metric, "MS:4000016", "retention time metric", "QC metric related to retention time.", false},
    {MS_chromatogram_metric, "MS:4000017", "chromatogram metric", "QC metric related to a chromatogram.", false},
    {MS_XIC_metric, "MS:4000018", "XIC metric", "QC metric related to an extracted ion chromatogram.", false},
    {MS_MS_metric, "MS:4000019", "MS metric", "QC metric related to the mass spectrometry acquisition.", false},
    {MS_ion_source_metric, "MS:4000020", "ion source metric", "QC metric related to events in the ion source.", false},
    {MS_MS1_metric, "MS:4000021", "MS1 metric", "QC metric based on MS1 events.", false},
    {MS_MS2_metric, "MS:4000022", "MS2 metric", "QC metric based on MS2 events.", false},
    {MS_sample_preparation_metric, "MS:4000023", "sample preparation metric", "QC metric related to the sample preparation.", false},
    {MS_environment_metric, "MS:4000024", "environment metric", "QC metric related to measurements of the ambient environment, such as the laboratory.", false},
    {MS_XIC50_fraction, "MS:4000050", "XIC50 fraction", "The number of XIC that account for the top half of all XIC-FWHM divided by the number of all XIC.", false},
    {MS_XIC_FWHM_quantiles, "MS:4000051", "XIC-FWHM quantiles", "The first to n-th quantile of peak widths for XICs. A metric's value triplet represents the related QuaMeter metrics of XIC-FWHM-Q1,Q2,Q3.", false},
    {MS_XIC_Height_quartile_ratios, "MS:4000052", "XIC-Height quartile ratios", "The log ratio of successive XIC height quartiles. The metric's value triplet represents the log ratios of XIC-height-Q2 to XIC-height-Q1, XIC-height-Q3 to XIC-height-Q2, XIC-height max to XIC-height-Q3.", false},
    {MS_chromatography_duration, "MS:4000053", "chromatography duration", "The retention time duration of the chromatography in seconds.", false},
    {MS_TIC_quarters_RT_fraction, "MS:4000054", "TIC quarters RT fraction", "The interval when the respective quarter of the TIC accumulates divided by retention time duration.", false},
    {MS_MS1_quarter_RT_fraction, "MS:4000055", "MS1 quarter RT fraction", "The interval used for acquisition of the first, second, third, and fourth quarter of all MS1 events divided by retention time duration.", false},
    {MS_MS2_quarter_RT_fraction, "MS:4000056", "MS2 quarter RT fraction", "The interval used for acquisition of the first, second, third, and fourth quarter of all MS2 events divided by retention time duration.", false},
    {MS_MS1_TIC_change_quartile_ratios, "MS:4000057", "MS1 TIC-change quartile ratios", "The log ratios of successive TIC-change quartiles. The TIC changes are the list of MS1 total ion current (TIC) value changes from one to the next scan, produced when each MS1 TIC is subtracted from the preceding MS1 TIC. The metric's value triplet represents the log ratio of the TIC-change Q2 to Q1, Q3 to Q2, TIC-change-max to Q3", false},
    {MS_MS1_TIC_quartile_ratios, "MS:4000058", "MS1 TIC quartile ratios", "The log ratios of successive TIC quartiles. The metric's value triplet represents the log ratios of TIC-Q2 to TIC-Q1, TIC-Q3 to TIC-Q2, TIC-max to TIC-Q3.", false},
    {MS_number_of_MS1_spectra, "MS:4000059", "number of MS1 spectra", "The number of MS1 events in the run.", false},
    {MS_number_of_MS2_spectra, "MS:4000060", "number of MS2 spectra", "The number of MS2 events in the run.", false},
    {MS_MS1_density_quantiles, "MS:4000061", "MS1 density quantiles", "The first to n-th quantile of MS1 peak density (scan peak counts). A value triplet represents the original QuaMeter metrics, the quartiles of MS1 density. The number of values in the tuple implies the quantile mode.", false},
    {MS_MS2_density_quantiles, "MS:4000062", "MS2 density quantiles", "The first to n-th quantile of MS2 peak density (scan peak counts). A value triplet represents the original QuaMeter metrics, the quartiles of MS2 density. The number of values in the tuple implies the quantile mode.", false},
    {MS_MS2_known_precursor_charges_fractions, "MS:4000063", "MS2 known precursor charges fractions", "The fraction of MS/MS precursors of the corresponding charge. The fractions [0,1] are given in the 'Fraction' column, corresponding charges in the 'Charge state' column. The highest charge state is to be interpreted as that charge state or higher.", false},
    {MS_MS2_unknown_and_likely_precursor_charges_fractions, "MS:4000064", "MS2 unknown and likely precursor charges fractions", "The fractions of inferred charge state of MS/MS precursors. The fractions [0,1] are given in the 'Fraction' column, corresponding charges in the 'Charge state' column. Charge 0 represents unknown charge states.", false},
    {MS_fastest_frequency_for_MS_level_1_collection, "MS:4000065", "fastest frequency for MS level 1 collection", "Fastest frequency for MS level 1 collection", false},
    {MS_fastest_frequency_for_MS_level_2_collection, "MS:4000066", "fastest frequency for MS level 2 collection", "Fastest frequency for MS level 2 collection", false},
    {MS_MS_run_duration, "MS:4000067", "MS run duration", "The duration of the mass spectrometry acquisition (as measured by the time between the last scan and first scan) in seconds.", false},
    {MS_spectra_half_TIC, "MS:4000068", "spectra half-TIC", "The minimal proportion of peaks needed to account for at least 50% of the total ion current in each individual spectrum considered, recorded in a mandatory fraction column. Either USI or native spectrum identifier columns must be present as well.", false},
    {MS_m_z_acquisition_range, "MS:4000069", "m/z acquisition range", "Upper and lower limit of m/z precursor values at which MSn spectra are recorded.", false},
    {MS_retention_time_acquisition_range, "MS:4000070", "retention time acquisition range", "Upper and lower limit of retention time at which spectra are recorded.", false},
    {MS_number_of_chromatograms, "MS:4000071", "number of chromatograms", "The number of chromatograms recorded for the run.", false},
    {MS_observed_mass_accuracy, "MS:4000072", "observed mass accuracy", "Observed mass accuracy in ppm, calculated by 1E6 x (observed m/z - theoretical m/z)/theoretical m/z of a selected and identified ion in a mass spectrum.", false},
    {MS_QC_sample_metric, "MS:4000073", "QC sample metric", "A QC metric based on a QC sample of known content.", false},
    {MS_high_complexity_QC_sample_metric, "MS:4000074", "high complexity QC sample metric", "A QC metric based on a QC sample of known and high complexity content.", false},
    {MS_low_complexity_QC_sample_metric, "MS:4000075", "low complexity QC sample metric", "A QC metric based on a QC sample of known and low complexity content.", false},
    {MS_QC2_sample_metric, "MS:4000076", "QC2 sample metric", "A QC metric based on the results of a QC2 sample measurement. A QC2 sample is made from Pierce HeLa protein digest standard, see Pichler et al. Chiva et al. for details on QC sample design.", false},
    {MS_QC1_sample_metric, "MS:4000077", "QC1 sample metric", "A QC metric based on the results of a QC1 sample measurement. A QC1 sample is made from trypsin-digested BSA MS Standard (CAM modified), see Pichler et al. Chiva et al. for details on QC sample design).", false},
    {MS_QC2_sample_mass_accuracies, "MS:4000078", "QC2 sample mass accuracies", "Observed mass accuracy for the peptides of a QC2 sample measurement. The table should contain the peptides as described in the QC2 sample metric term, missing are interpreted as not detected.", false},
    {MS_QC2_sample_intensities, "MS:4000079", "QC2 sample intensities", "Observed intensities for the peptides of a QC2 sample measurement within 5 ppm and +/- 240 s RT tolerance. Different metrics of observed intensities are possible, at least one must be present. The table should contain the peptides as defined in the parent QC2 sample metric term, missing are interpreted as not detected.", false},
    {MS_QC_non_metric_term, "MS:4000080", "QC non-metric term", "QC terms associated but not directly metrics themselves.", false},
    {MS_first_principal_component, "MS:4000081", "first principal component", "Data from the first principal component of a PCA.", false},
    {MS_second_principal_component, "MS:4000082", "second principal component", "Data from the second principal component of a PCA.", false},
    {MS_third_principal_component, "MS:4000083", "third principal component", "Data from the third principal component of a PCA.", false},
    {MS_fourth_principal_component, "MS:4000084", "fourth principal component", "Data from the fourth principal component of a PCA.", false},
    {MS_fifth_principal_component, "MS:4000085", "fifth principal component", "Data from the fifth principal component of a PCA.", false},
    {MS_mzQC_input_reference, "MS:4000086", "mzQC input reference", "Used to refer to data elements of input sections in mzQC, either inputFile names or metadata labels.", false},
    {MS_mzQC_plot_label, "MS:4000087", "mzQC plot label", "Used to supply alternative labels for plotting figures.", false},
    {MS_batch_label, "MS:4000088", "batch label", "Used to supply batch label information with any string value.", false},
    {MS_injection_sequence_label, "MS:4000089", "injection sequence label", "Used to supply injection sequence information with consecutive whole numbers.", false},
    {MS_principal_component_analysis_of_MaxQuant_s_protein_group_raw_intensities, "MS:4000090", "principal component analysis of MaxQuant's protein group raw intensities", "A table with the PCA results of MaxQuant's protein group raw intensities.", false},
    {MS_principal_component_analysis_of_MaxQuant_s_protein_group_lfq_intensities, "MS:4000091", "principal component analysis of MaxQuant's protein group lfq intensities", "A table with the PCA results of MaxQuant's protein group lfq intensities.", false},
    {MS_identified_MS1_feature_area_principal_component_analysis_result, "MS:4000092", "identified MS1 feature area principal component analysis result", "A table with the PCA results of identified MS1 feature areas.", false},
    {MS_unidentified_MS1_feature_area_principal_component_analysis_result, "MS:4000093", "unidentified MS1 feature area principal component analysis result", "A table with the PCA results of unidentified but multiple-run-matched MS1 feature areas.", false},
    {MS_batch_corrected_identified_MS1_feature_area_principal_component_analysis_result, "MS:4000094", "batch-corrected identified MS1 feature area principal component analysis result", "A table with the PCA results of identified MS1 feature areas after batch-correction.", false},
    {MS_slowest_frequency_for_MS_level_1_collection, "MS:4000095", "slowest frequency for MS level 1 collection", "The slowest acquisition speed with which precursor MS scans were collected. Scan acquisition frequency can be used to gauge the suitability of used instrument settings for the sample content used.", false},
    {MS_slowest_frequency_for_MS_level_2_collection, "MS:4000096", "slowest frequency for MS level 2 collection", "The slowest acquisition speed with which product MS scans were collected. Scan acquisition frequency can be used to gauge the suitability of used instrument settings for the sample content used.", false},
    {MS_MS1_signal_jump__10x__count, "MS:4000097", "MS1 signal jump (10x) count", "The number of times where MS1 TIC increased more than 10-fold between adjacent MS1 scans.", false},
    {MS_MS1_signal_fall__10x__count, "MS:4000098", "MS1 signal fall (10x) count", "The number of times where MS1 TIC decreased more than 10-fold between adjacent MS1 scans.", false},
    {MS_number_of_empty_MS1_scans, "MS:4000099", "number of empty MS1 scans", "Number of MS1 scans where the scans' peaks intensity sums to 0 (i.e. no peaks or only 0-intensity peaks).", false},
    {MS_number_of_empty_MS2_scans, "MS:4000100", "number of empty MS2 scans", "Number of MS2 scans where the scans' peaks intensity sums to 0 (i.e. no peaks or only 0-intensity peaks).", false},
    {MS_number_of_empty_MS3_scans, "MS:4000101", "number of empty MS3 scans", "Number of MS3 scans where the scans' peaks intensity sums to 0 (i.e. no peaks or only 0-intensity peaks).", false},
    {MS_number_of_detected_quantification_data_points, "MS:4000102", "number of detected quantification data points", "The number of data points detected for quantification purposes within the run. These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run.", false},
    {MS_number_of_identified_quantification_data_points, "MS:4000103", "number of identified quantification data points", "The number of identified data points for quantification purposes within the run after user defined acceptance criteria are applied.  These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_total_ion_currents, "MS:4000104", "total ion currents", "Tabular representation of the total ion current detected in each of a series of mass spectra.", false},
    {MS_ion_injection_parameters, "MS:4000105", "ion injection parameters", "Tabular representation of the parameters around ion selection like the amount of time spent filling an ion trapping device for each scan acquisition.", false},
    {MS_MS1_frequency_in_equal_parts_of_subsequent_RT, "MS:4000106", "MS1 frequency in equal parts of subsequent RT", "Average MS1 frequency during retention time periods between adjacent retention time quantiles. (Four values implies values for 1st, 2nd, 3rd, 4th quarter.)", false},
    {MS_MS2_frequency_in_equal_parts_of_subsequent_RT, "MS:4000107", "MS2 frequency in equal parts of subsequent RT", "Average MS2 frequency  during retention time periods between adjacent retention time quantiles. (Four values implies values for 1st, 2nd, 3rd, 4th quarter.)", false},
    {MS_MS1_peak_density_distribution_mean, "MS:4000108", "MS1 peak density distribution mean", "From the distribution of peak densities in MS1, the mean", false},
    {MS_MS1_peak_density_distribution_sigma, "MS:4000109", "MS1 peak density distribution sigma", "From the distribution of peak densities in MS1, the sigma value", false},
    {MS_MS1_peak_density_distribution_low_outliers, "MS:4000110", "MS1 peak density distribution low outliers", "From the distribution of peak densities in MS1, the list of outliers below a in-file defined threshold", false},
    {MS_MS1_peak_density_distribution_high_outliers, "MS:4000111", "MS1 peak density distribution high outliers", "From the distribution of peak densities in MS1, the list of outliers above a in-file defined threshold", false},
    {MS_MS2_peak_density_distribution_mean, "MS:4000112", "MS2 peak density distribution mean", "From the distribution of peak densities in MS2, the mean", false},
    {MS_MS2_peak_density_distribution_sigma, "MS:4000113", "MS2 peak density distribution sigma", "From the distribution of peak densities in MS2, the sigma value", false},
    {MS_MS2_peak_density_distribution_low_outliers, "MS:4000114", "MS2 peak density distribution low outliers", "From the distribution of peak densities in MS2, the list of outliers below a in-file defined threshold", false},
    {MS_MS2_peak_density_distribution_high_outliers, "MS:4000115", "MS2 peak density distribution high outliers", "From the distribution of peak densities in MS2, the list of outliers above a in-file defined threshold", false},
    {MS_MS2_precursor_intensity_distribution, "MS:4000116", "MS2 precursor intensity distribution", "From the distribution of MS2 precursor intensities, the quantiles. E.g. a value triplet represents the quartiles Q1, Q2, Q3.", false},
    {MS_MS2_precursor_intensity_distribution_mean, "MS:4000117", "MS2 precursor intensity distribution mean", "From the distribution of MS2 precursor intensities, the mean", false},
    {MS_MS2_precursor_intensity_distribution_sigma, "MS:4000118", "MS2 precursor intensity distribution sigma", "From the distribution of MS2 precursor intensities, the sigma value", false},
    {MS_MS2_precursor_intensity_distribution_low_outliers, "MS:4000119", "MS2 precursor intensity distribution low outliers", "From the distribution of precursor intensities, the list of outliers below a in-file defined threshold", false},
    {MS_MS2_precursor_intensity_distribution_high_outliers, "MS:4000120", "MS2 precursor intensity distribution high outliers", "From the distribution of precursor intensities, the list of outliers above a in-file defined threshold", false},
    {MS_MS1_signal_to_noise_ratio_quantiles, "MS:4000121", "MS1 signal-to-noise ratio quantiles", "From the distribution of signal-to-noise ratio in MS1, the quantiles. I.e. a value triplet represents the quartiles Q1, Q2, Q3", false},
    {MS_MS1_signal_to_noise_ratio_mean, "MS:4000122", "MS1 signal-to-noise ratio mean", "From the distribution of signal-to-noise ratio in MS1, the mean", false},
    {MS_MS1_signal_to_noise_ratio_sigma, "MS:4000123", "MS1 signal-to-noise ratio sigma", "From the distribution of signal-to-noise ratio in MS1, the sigma value", false},
    {MS_MS1_signal_to_noise_ratio_low_outliers, "MS:4000124", "MS1 signal-to-noise ratio low outliers", "From the distribution of signal-to-noise ratio in MS1, the list of outliers below a in-file defined threshold", false},
    {MS_MS1_signal_to_noise_ratio_high_outliers, "MS:4000125", "MS1 signal-to-noise ratio high outliers", "From the distribution of signal-to-noise ratio in MS1, the list of outliers above a in-file defined threshold", false},
    {MS_MS2_signal_to_noise_ratio_quantiles, "MS:4000126", "MS2 signal-to-noise ratio quantiles", "From the distribution of signal-to-noise ratio in MS2, the quantiles. I.e. a value triplet represents the quartiles Q1, Q2, Q3", false},
    {MS_MS2_signal_to_noise_ratio_mean, "MS:4000127", "MS2 signal-to-noise ratio mean", "From the distribution of signal-to-noise ratio in MS2, the mean", false},
    {MS_MS2_signal_to_noise_ratio_sigma, "MS:4000128", "MS2 signal-to-noise ratio sigma", "From the distribution of signal-to-noise ratio in MS2, the sigma value", false},
    {MS_MS2_signal_to_noise_ratio_low_outliers, "MS:4000129", "MS2 signal-to-noise ratio low outliers", "From the distribution of signal-to-noise ratio in MS2, the list of outliers below a in-file defined threshold", false},
    {MS_MS2_signal_to_noise_ratio_high_outliers, "MS:4000130", "MS2 signal-to-noise ratio high outliers", "From the distribution of signal-to-noise ratio in MS2, the list of outliers above a in-file defined threshold", false},
    {MS_MS1_ion_collection_time_quantiles, "MS:4000131", "MS1 ion collection time quantiles", "From the distribution of ion injection times (MS:1000927) for MS1, the quantiles. I.e. a value triplet represents the quartiles Q1, Q2, Q3", false},
    {MS_MS1_ion_collection_time_mean, "MS:4000132", "MS1 ion collection time mean", "From the distribution of ion injection times (MS:1000927) for MS1, the mean", false},
    {MS_MS1_ion_collection_time_sigma, "MS:4000133", "MS1 ion collection time sigma", "From the distribution of ion injection times (MS:1000927) for MS1, the sigma value", false},
    {MS_MS1_ion_collection_time_low_outliers, "MS:4000134", "MS1 ion collection time low outliers", "From the distribution of ion injection times (MS:1000927) for MS1, the list of outliers below a in-file defined threshold", false},
    {MS_MS1_ion_collection_time_high_outliers, "MS:4000135", "MS1 ion collection time high outliers", "From the distribution of ion injection times (MS:1000927) for MS1, the list of outliers above a in-file defined threshold", false},
    {MS_MS2_ion_collection_time_quantiles, "MS:4000136", "MS2 ion collection time quantiles", "From the distribution of ion injection times (MS:1000927) for MS2, the quantiles. I.e. a value triplet represents the quartiles Q1, Q2, Q3", false},
    {MS_MS2_ion_collection_time_mean, "MS:4000137", "MS2 ion collection time mean", "From the distribution of ion injection times (MS:1000927) for MS2, the mean", false},
    {MS_MS2_ion_collection_time_sigma, "MS:4000138", "MS2 ion collection time sigma", "From the distribution of ion injection times (MS:1000927) for MS2, the sigma value", false},
    {MS_MS2_ion_collection_time_low_outliers, "MS:4000139", "MS2 ion collection time low outliers", "From the distribution of ion injection times (MS:1000927) for MS2, the list of outliers below a in-file defined threshold", false},
    {MS_MS2_ion_collection_time_high_outliers, "MS:4000140", "MS2 ion collection time high outliers", "From the distribution of ion injection times (MS:1000927) for MS2, the list of outliers above a in-file defined threshold", false},
    {MS_outlier_threshold_criterion, "MS:4000141", "outlier threshold criterion", "The definition of the outlier criteria applied.", false},
    {MS_Tukey_s_fence, "MS:4000142", "Tukey's fence", "Defines outliers with Tukey's fence as <(Q1-x*IQR) for low outliers and >(Q3+x*IQR) for high outliers, where x is defined by the term's value. The default is x=1.5.", false},
    {MS_Tukey_s_fence_high_outliers, "MS:4000143", "Tukey's fence high outliers", "Defines high outliers with Tukey's fence as >(Q3+x*IQR) for high outliers, where x is defined by the term's value. The default is x=1.5.", false},
    {MS_Tukey_s_fence_low_outliers, "MS:4000144", "Tukey's fence low outliers", "Defines low outliers with Tukey's fence as <(Q1-x*IQR) for low outliers, where x is defined by the term's value. The default is x=1.5.", false},
    {MS_Z_score_threshold, "MS:4000145", "Z-score threshold", "Defines outliers with a Z-score threshold as <(-x) for low outliers and >(+x) for high outliers, where x is defined by the term's value. The default is x=3.", false},
    {MS_Z_score_threshold_high_outliers, "MS:4000146", "Z-score threshold high outliers", "Defines outliers with a Z-score threshold as <(-x) for low outliers and >(+x) for high outliers, where x is defined by the term's value. The default is x=3.", false},
    {MS_Z_score_threshold_low_outliers, "MS:4000147", "Z-score threshold low outliers", "Defines outliers with a Z-score threshold as <(-x) for low outliers and >(+x) for high outliers, where x is defined by the term's value. The default is x=3.", false},
    {MS_algorithmical_threshold, "MS:4000148", "algorithmical threshold", "Defines outliers algorithmically, where a single value threshold might not be applicable or p.r.n. multivariate decision making is applied. The value of the term should name the algorithmical method used.", false},
    {MS_iRT_calibration_formula, "MS:4000149", "iRT calibration formula", "A polynomial formula to calibrate retention time based on iRT reference peptides. The order of the values corresponds to polynomial terms. I.e. a linear equation is represented by a two-tuple consisting of (slope, intercept). More general, the position in the n_tuple indicates the power of `x`: position `n → x^0`, position `n - 1 → x^1`, position `n - 2 → x^2`, etc.", false},
    {MS_iRT_calibration_adjusted_r_squared, "MS:4000150", "iRT calibration adjusted r-squared", "The goodness of fit statistic between observed retention times and iRT calibrated retention times.", false},
    {MS_MsQuality, "MS:4000151", "MsQuality", "MsQuality – an interoperable open-source package for the calculation of standardized quality metrics of mass spectrometry data.", false},
    {MS_MS2_precursor_median_m_z_of_identified_quantification_data_points, "MS:4000152", "MS2 precursor median m/z of identified quantification data points", "Median m/z value for MS2 precursors of all quantification data points after user-defined acceptance criteria are applied. These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_interquartile_RT_period_for_identified_quantification_data_points, "MS:4000153", "interquartile RT period for identified quantification data points", "The interquartile retention time period, in seconds, for all quantification data points after user-defined acceptance criteria are applied over the complete run. These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_rate_of_the_interquartile_RT_period_for_identified_quantification_data_points, "MS:4000154", "rate of the interquartile RT period for identified quantification data points", "The rate of identified quantification data points for the interquartile retention time period, in identified quantification data points per second. These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_area_under_TIC, "MS:4000155", "area under TIC", "The area under the total ion chromatogram.", false},
    {MS_area_under_TIC_RT_quantiles, "MS:4000156", "area under TIC RT quantiles", "The area under the total ion chromatogram of the retention time quantiles. Number of quantiles are given by the n-tuple.", false},
    {MS_extent_of_identified_MS2_precursor_intensity, "MS:4000157", "extent of identified MS2 precursor intensity", "Ratio of 95th over 5th percentile of MS2 precursor intensity for all quantification data points after user-defined acceptance criteria are applied. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_median_of_TIC_values_in_the_RT_range_in_which_the_middle_half_of_quantification_data_points_are_identified, "MS:4000158", "median of TIC values in the RT range in which the middle half of quantification data points are identified", "Median of TIC values in the RT range in which half of quantification data points are identified (RT values of Q1 to Q3 of identifications). These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_median_of_TIC_values_in_the_shortest_RT_range_in_which_half_of_the_quantification_data_points_are_identified, "MS:4000159", "median of TIC values in the shortest RT range in which half of the quantification data points are identified", "Median of TIC values in the shortest RT range in which half of the quantification data points are identified. These data points may be for example XIC profiles, isotopic pattern areas, or reporter ions (see MS:1001805). The used type should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_MS2_precursor_intensity_range, "MS:4000160", "MS2 precursor intensity range", "Minimum and maximum MS2 precursor intensity recorded.", false},
    {MS_identified_MS2_precursor_intensity_distribution, "MS:4000161", "identified MS2 precursor intensity distribution", "From the distribution of identified MS2 precursor intensities, the quantiles. E.g. a value triplet represents the quartiles Q1, Q2, Q3. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_unidentified_MS2_precursor_intensity_distribution, "MS:4000162", "unidentified MS2 precursor intensity distribution", "From the distribution of unidentified MS2 precursor intensities, the quantiles. E.g. a value triplet represents the quartiles Q1, Q2, Q3. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_identified_MS2_precursor_intensity_distribution_mean, "MS:4000163", "identified MS2 precursor intensity distribution mean", "From the distribution of identified MS2 precursor intensities, the mean. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_unidentified_MS2_precursor_intensity_distribution_mean, "MS:4000164", "unidentified MS2 precursor intensity distribution mean", "From the distribution of unidentified MS2 precursor intensities, the mean. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_identified_MS2_precursor_intensity_distribution_sigma, "MS:4000165", "identified MS2 precursor intensity distribution sigma", "From the distribution of identified MS2 precursor intensities, the sigma value. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_unidentified_MS2_precursor_intensity_distribution_sigma, "MS:4000166", "unidentified MS2 precursor intensity distribution sigma", "From the distribution of unidentified MS2 precursor intensities, the sigma value. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_ratio_of_1__over_2__of_all_MS2_known_precursor_charges, "MS:4000167", "ratio of 1+ over 2+ of all MS2 known precursor charges", "The ratio of 1+ over 2+ MS2 precursor charge count of all spectra.", false},
    {MS_ratio_of_1__over_2__of_identified_MS2_known_precursor_charges, "MS:4000168", "ratio of 1+ over 2+ of identified MS2 known precursor charges", "The ratio of 1+ over 2+ MS2 precursor charge count of identified spectra. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_ratio_of_3__over_2__of_all_MS2_known_precursor_charges, "MS:4000169", "ratio of 3+ over 2+ of all MS2 known precursor charges", "The ratio of 3+ over 2+ MS2 precursor charge count of all spectra.", false},
    {MS_ratio_of_3__over_2__of_identified_MS2_known_precursor_charges, "MS:4000170", "ratio of 3+ over 2+ of identified MS2 known precursor charges", "The ratio of 3+ over 2+ MS2 precursor charge count of identified spectra. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_ratio_of_4__over_2__of_all_MS2_known_precursor_charges, "MS:4000171", "ratio of 4+ over 2+ of all MS2 known precursor charges", "The ratio of 4+ over 2+ MS2 precursor charge count of all spectra.", false},
    {MS_ratio_of_4__over_2__of_identified_MS2_known_precursor_charges, "MS:4000172", "ratio of 4+ over 2+ of identified MS2 known precursor charges", "The ratio of 4+ over 2+ MS2 precursor charge count of identified spectra. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_mean_MS2_precursor_charge_in_all_spectra, "MS:4000173", "mean MS2 precursor charge in all spectra", "Mean MS2 precursor charge in all spectra", false},
    {MS_mean_MS2_precursor_charge_in_identified_spectra, "MS:4000174", "mean MS2 precursor charge in identified spectra", "Mean MS2 precursor charge in identified spectra. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {MS_median_MS2_precursor_charge_in_all_spectra, "MS:4000175", "median MS2 precursor charge in all spectra", "Median MS2 precursor charge in all spectra", false},
    {MS_median_MS2_precursor_charge_in_identified_spectra, "MS:4000176", "median MS2 precursor charge in identified spectra", "Median MS2 precursor charge in identified spectra. The used type of identification should be noted in the metadata or analysis methods section of the recording file for the respective run. In case of multiple acceptance criteria (FDR) available in proteomics, PSM-level FDR should be used for better comparability.", false},
    {UNIMOD_unimod_root_node, "UNIMOD:0", "unimod root node", "The root node of the unimod modifications ontology.", false},
    {UNIMOD_Acetyl, "UNIMOD:1", "Acetyl", "Acetylation.", false},
    {UNIMOD_Amidated, "UNIMOD:2", "Amidated", "Amidation.", false},
    {UNIMOD_Biotin, "UNIMOD:3", "Biotin", "Biotinylation.", false},
    {UNIMOD_Carbamidomethyl, "UNIMOD:4", "Carbamidomethyl", "Iodoacetamide derivative.", false},
    {UNIMOD_Carbamyl, "UNIMOD:5", "Carbamyl", "Carbamylation.", false},
    {UNIMOD_Carboxymethyl, "UNIMOD:6", "Carboxymethyl", "Iodoacetic acid derivative.", false},
    {UNIMOD_Deamidated, "UNIMOD:7", "Deamidated", "Deamidation.", false},
    {UNIMOD_ICAT_G, "UNIMOD:8", "ICAT-G", "Gygi ICAT(TM) d0.", false},
    {UNIMOD_ICAT_G_2H_8_, "UNIMOD:9", "ICAT-G:2H(8)", "Gygi ICAT(TM) d8.", false},
    {UNIMOD_Met__Hse, "UNIMOD:10", "Met->Hse", "Homoserine.", false},
    {UNIMOD_Met__Hsl, "UNIMOD:11", "Met->Hsl", "Homoserine lactone.", false},
    {UNIMOD_ICAT_D_2H_8_, "UNIMOD:12", "ICAT-D:2H(8)", "Applied Biosystems original ICAT(TM) d8.", false},
    {UNIMOD_ICAT_D, "UNIMOD:13", "ICAT-D", "Applied Biosystems original ICAT(TM) d0.", false},
    {UNIMOD_NIPCAM, "UNIMOD:17", "NIPCAM", "N-isopropylcarboxamidomethyl.", false},
    {UNIMOD_PEO_Iodoacetyl_LC_Biotin, "UNIMOD:20", "PEO-Iodoacetyl-LC-Biotin", "Biotinyl-iodoacetamidyl-3,6-dioxaoctanediamine.", false},
    {UNIMOD_Phospho, "UNIMOD:21", "Phospho", "Phosphorylation.", false},
    {UNIMOD_Dehydrated, "UNIMOD:23", "Dehydrated", "Dehydration.", false},
    {UNIMOD_Propionamide, "UNIMOD:24", "Propionamide", "Acrylamide adduct.", false},
    {UNIMOD_Pyridylacetyl, "UNIMOD:25", "Pyridylacetyl", "Pyridylacetyl.", false},
    {UNIMOD_Pyro_carbamidomethyl, "UNIMOD:26", "Pyro-carbamidomethyl", "S-carbamoylmethylcysteine cyclization (N-terminus).", false},
    {UNIMOD_Glu__pyro_Glu, "UNIMOD:27", "Glu->pyro-Glu", "Pyro-glu from E.", false},
    {UNIMOD_Gln__pyro_Glu, "UNIMOD:28", "Gln->pyro-Glu", "Pyro-glu from Q.", false},
    {UNIMOD_SMA, "UNIMOD:29", "SMA", "N-Succinimidyl-2-morpholine acetate.", false},
    {UNIMOD_Cation_Na, "UNIMOD:30", "Cation:Na", "Sodium adduct.", false},
    {UNIMOD_Pyridylethyl, "UNIMOD:31", "Pyridylethyl", "S-pyridylethylation.", false},
    {UNIMOD_Methyl, "UNIMOD:34", "Methyl", "Methylation.", false},
    {UNIMOD_Oxidation, "UNIMOD:35", "Oxidation", "Oxidation or Hydroxylation.", false},
    {UNIMOD_Dimethyl, "UNIMOD:36", "Dimethyl", "Di-Methylation.", false},
    {UNIMOD_Trimethyl, "UNIMOD:37", "Trimethyl", "Tri-Methylation.", false},
    {UNIMOD_Methylthio, "UNIMOD:39", "Methylthio", "Beta-methylthiolation.", false},
    {UNIMOD_Sulfo, "UNIMOD:40", "Sulfo", "O-Sulfonation.", false},
    {UNIMOD_Hex, "UNIMOD:41", "Hex", "Hexose.", false},
    {UNIMOD_Lipoyl, "UNIMOD:42", "Lipoyl", "Lipoyl.", false},
    {UNIMOD_HexNAc, "UNIMOD:43", "HexNAc", "N-Acetylhexosamine.", false},
    {UNIMOD_Farnesyl, "UNIMOD:44", "Farnesyl", "Farnesylation.", false},
    {UNIMOD_Myristoyl, "UNIMOD:45", "Myristoyl", "Myristoylation.", false},
    {UNIMOD_PyridoxalPhosphate, "UNIMOD:46", "PyridoxalPhosphate", "Pyridoxal phosphate.", false},
    {UNIMOD_Palmitoyl, "UNIMOD:47", "Palmitoyl", "Palmitoylation.", false},
    {UNIMOD_GeranylGeranyl, "UNIMOD:48", "GeranylGeranyl", "Geranyl-geranyl.", false},
    {UNIMOD_Phosphopantetheine, "UNIMOD:49", "Phosphopantetheine", "Phosphopantetheine.", false},
    {UNIMOD_FAD, "UNIMOD:50", "FAD", "Flavin adenine dinucleotide.", false},
    {UNIMOD_Tripalmitate, "UNIMOD:51", "Tripalmitate", "N-acyl diglyceride cysteine.", false},
    {UNIMOD_Guanidinyl, "UNIMOD:52", "Guanidinyl", "Guanidination.", false},
    {UNIMOD_HNE, "UNIMOD:53", "HNE", "4-hydroxynonenal (HNE).", false},
    {UNIMOD_Glucuronyl, "UNIMOD:54", "Glucuronyl", "Hexuronic acid.", false},
    {UNIMOD_Glutathione, "UNIMOD:55", "Glutathione", "Glutathione disulfide.", false},
    {UNIMOD_Acetyl_2H_3_, "UNIMOD:56", "Acetyl:2H(3)", "Acetate labeling reagent (N-term & K) (heavy form, +3amu).", false},
    {UNIMOD_Propionyl, "UNIMOD:58", "Propionyl", "Propionate labeling reagent light form (N-term & K).", false},
    {UNIMOD_Propionyl_13C_3_, "UNIMOD:59", "Propionyl:13C(3)", "Propionate labeling reagent heavy form (+3amu), N-term & K.", false},
    {UNIMOD_GIST_Quat, "UNIMOD:60", "GIST-Quat", "Quaternary amine labeling reagent light form (N-term & K).", false},
    {UNIMOD_GIST_Quat_2H_3_, "UNIMOD:61", "GIST-Quat:2H(3)", "Quaternary amine labeling reagent heavy (+3amu) form, N-term & K.", false},
    {UNIMOD_GIST_Quat_2H_6_, "UNIMOD:62", "GIST-Quat:2H(6)", "Quaternary amine labeling reagent heavy form (+6amu), N-term & K.", false},
    {UNIMOD_GIST_Quat_2H_9_, "UNIMOD:63", "GIST-Quat:2H(9)", "Quaternary amine labeling reagent heavy form (+9amu), N-term & K.", false},
    {UNIMOD_Succinyl, "UNIMOD:64", "Succinyl", "Succinic anhydride labeling reagent light form (N-term & K).", false},
    {UNIMOD_Succinyl_2H_4_, "UNIMOD:65", "Succinyl:2H(4)", "Succinic anhydride labeling reagent, heavy form (+4amu, 4H2), N-term & K.", false},
    {UNIMOD_Succinyl_13C_4_, "UNIMOD:66", "Succinyl:13C(4)", "Succinic anhydride labeling reagent, heavy form (+4amu, 4C13), N-term & K.", false},
    {UNIMOD_Iminobiotin, "UNIMOD:89", "Iminobiotin", "Iminobiotinylation.", false},
    {UNIMOD_ESP, "UNIMOD:90", "ESP", "ESP-Tag light d0.", false},
    {UNIMOD_ESP_2H_10_, "UNIMOD:91", "ESP:2H(10)", "ESP-Tag heavy d10.", false},
    {UNIMOD_NHS_LC_Biotin, "UNIMOD:92", "NHS-LC-Biotin", "NHS-LC-Biotin.", false},
    {UNIMOD_EDT_maleimide_PEO_biotin, "UNIMOD:93", "EDT-maleimide-PEO-biotin", "EDT-maleimide-PEO-biotin.", false},
    {UNIMOD_IMID, "UNIMOD:94", "IMID", "IMID d0.", false},
    {UNIMOD_IMID_2H_4_, "UNIMOD:95", "IMID:2H(4)", "IMID d4.", false},
    {UNIMOD_Propionamide_2H_3_, "UNIMOD:97", "Propionamide:2H(3)", "Acrylamide d3.", false},
    {UNIMOD_ICAT_C, "UNIMOD:105", "ICAT-C", "Applied Biosystems cleavable ICAT(TM) light.", false},
    {UNIMOD_ICAT_C_13C_9_, "UNIMOD:106", "ICAT-C:13C(9)", "Applied Biosystems cleavable ICAT(TM) heavy.", false},
    {UNIMOD_FormylMet, "UNIMOD:107", "FormylMet", "Addition of N-formyl met.", false},
    {UNIMOD_Nethylmaleimide, "UNIMOD:108", "Nethylmaleimide", "N-ethylmaleimide on cysteines.", false},
    {UNIMOD_OxLysBiotinRed, "UNIMOD:112", "OxLysBiotinRed", "Oxidized lysine biotinylated with biotin-LC-hydrazide, reduced.", false},
    {UNIMOD_OxLysBiotin, "UNIMOD:113", "OxLysBiotin", "Oxidized lysine biotinylated with biotin-LC-hydrazide.", false},
    {UNIMOD_OxProBiotinRed, "UNIMOD:114", "OxProBiotinRed", "Oxidized proline biotinylated with biotin-LC-hydrazide, reduced.", false},
    {UNIMOD_OxProBiotin, "UNIMOD:115", "OxProBiotin", "Oxidized Proline biotinylated with biotin-LC-hydrazide.", false},
    {UNIMOD_OxArgBiotin, "UNIMOD:116", "OxArgBiotin", "Oxidized arginine biotinylated with biotin-LC-hydrazide.", false},
    {UNIMOD_OxArgBiotinRed, "UNIMOD:117", "OxArgBiotinRed", "Oxidized arginine biotinylated with biotin-LC-hydrazide, reduced.", false},
    {UNIMOD_EDT_iodoacetyl_PEO_biotin, "UNIMOD:118", "EDT-iodoacetyl-PEO-biotin", "EDT-iodo-PEO-biotin.", false},
    {UNIMOD_IBTP, "UNIMOD:119", "IBTP", "Thio Ether Formation - BTP Adduct.", false},
    {UNIMOD_GG, "UNIMOD:121", "GG", "Ubiquitinylation residue.", false},
    {UNIMOD_Formyl, "UNIMOD:122", "Formyl", "Formylation.", false},
    {UNIMOD_ICAT_H, "UNIMOD:123", "ICAT-H", "N-iodoacetyl, p-chlorobenzyl-12C6-glucamine.", false},
    {UNIMOD_ICAT_H_13C_6_, "UNIMOD:124", "ICAT-H:13C(6)", "N-iodoacetyl, p-chlorobenzyl-13C6-glucamine.", false},
    {UNIMOD_Xlink_DTSSP_88_, "UNIMOD:126", "Xlink:DTSSP[88]", "Cleaved and reduced DSP/DTSSP crosslinker.", false},
    {UNIMOD_Fluoro, "UNIMOD:127", "Fluoro", "Fluorination.", false},
    {UNIMOD_Fluorescein, "UNIMOD:128", "Fluorescein", "5-Iodoacetamidofluorescein (Molecular Probe, Eugene, OR).", false},
    {UNIMOD_Iodo, "UNIMOD:129", "Iodo", "Iodination.", false},
    {UNIMOD_Diiodo, "UNIMOD:130", "Diiodo", "Di-Iodination.", false},
    {UNIMOD_Triiodo, "UNIMOD:131", "Triiodo", "Tri-Iodination.", false},
    {UNIMOD_Myristoleyl, "UNIMOD:134", "Myristoleyl", "(cis-delta 5)-tetradecaenoyl.", false},
    {UNIMOD_Myristoyl_Delta_H__4_, "UNIMOD:135", "Myristoyl+Delta:H(-4)", "(cis,cis-delta 5, delta 8)-tetradecadienoyl.", false},
    {UNIMOD_Benzoyl, "UNIMOD:136", "Benzoyl", "Labeling reagent light form (N-term & K).", false},
    {UNIMOD_Hex_5_HexNAc_2_, "UNIMOD:137", "Hex(5)HexNAc(2)", "M5/Man5.", false},
    {UNIMOD_Dansyl, "UNIMOD:139", "Dansyl", "5-dimethylaminonaphthalene-1-sulfonyl.", false},
    {UNIMOD_a_type_ion, "UNIMOD:140", "a-type-ion", "ISD a-series (C-Term).", false},
    {UNIMOD_Amidine, "UNIMOD:141", "Amidine", "Amidination of lysines or N-terminal amines with methyl acetimidate.", false},
    {UNIMOD_HexNAc_1_dHex_1_, "UNIMOD:142", "HexNAc(1)dHex(1)", "HexNAc1dHex1.", false},
    {UNIMOD_HexNAc_2_, "UNIMOD:143", "HexNAc(2)", "HexNAc2.", false},
    {UNIMOD_Hex_3_, "UNIMOD:144", "Hex(3)", "Hex3.", false},
    {UNIMOD_HexNAc_1_dHex_2_, "UNIMOD:145", "HexNAc(1)dHex(2)", "HexNAc1dHex2.", false},
    {UNIMOD_Hex_1_HexNAc_1_dHex_1_, "UNIMOD:146", "Hex(1)HexNAc(1)dHex(1)", "Hex1HexNAc1dHex1.", false},
    {UNIMOD_HexNAc_2_dHex_1_, "UNIMOD:147", "HexNAc(2)dHex(1)", "HexNAc2dHex1.", false},
    {UNIMOD_Hex_1_HexNAc_2_, "UNIMOD:148", "Hex(1)HexNAc(2)", "Hex1HexNAc2.", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_1_, "UNIMOD:149", "Hex(1)HexNAc(1)NeuAc(1)", "Hex1HexNAc1NeuAc1.", false},
    {UNIMOD_HexNAc_2_dHex_2_, "UNIMOD:150", "HexNAc(2)dHex(2)", "HexNAc2dHex2.", false},
    {UNIMOD_Hex_1_HexNAc_2_Pent_1_, "UNIMOD:151", "Hex(1)HexNAc(2)Pent(1)", "Hex1HexNAc2Pent1.", false},
    {UNIMOD_Hex_1_HexNAc_2_dHex_1_, "UNIMOD:152", "Hex(1)HexNAc(2)dHex(1)", "Hex1HexNAc2dHex1.", false},
    {UNIMOD_Hex_2_HexNAc_2_, "UNIMOD:153", "Hex(2)HexNAc(2)", "Hex2HexNAc2.", false},
    {UNIMOD_Hex_3_HexNAc_1_Pent_1_, "UNIMOD:154", "Hex(3)HexNAc(1)Pent(1)", "Hex3HexNAc1Pent1.", false},
    {UNIMOD_Hex_1_HexNAc_2_dHex_1_Pent_1_, "UNIMOD:155", "Hex(1)HexNAc(2)dHex(1)Pent(1)", "Hex1HexNAc2dHex1Pent1.", false},
    {UNIMOD_Hex_1_HexNAc_2_dHex_2_, "UNIMOD:156", "Hex(1)HexNAc(2)dHex(2)", "Hex1HexNAc2dHex2.", false},
    {UNIMOD_Hex_2_HexNAc_2_Pent_1_, "UNIMOD:157", "Hex(2)HexNAc(2)Pent(1)", "Hex2HexNAc2Pent1.", false},
    {UNIMOD_Hex_2_HexNAc_2_dHex_1_, "UNIMOD:158", "Hex(2)HexNAc(2)dHex(1)", "Hex2HexNAc2dHex1.", false},
    {UNIMOD_Hex_3_HexNAc_2_, "UNIMOD:159", "Hex(3)HexNAc(2)", "M3/Man3.", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_2_, "UNIMOD:160", "Hex(1)HexNAc(1)NeuAc(2)", "Hex HexNAc NeuAc(2) ---OR--- Hex HexNAc(3) HexA.", false},
    {UNIMOD_Hex_3_HexNAc_2_Phos_1_, "UNIMOD:161", "Hex(3)HexNAc(2)Phos(1)", "Hex(3) HexNAc(2) Phos.", false},
    {UNIMOD_Delta_S__1_Se_1_, "UNIMOD:162", "Delta:S(-1)Se(1)", "Selenium replaces sulfur.", false},
    {UNIMOD_Delta_H__1_N__1_18O_1_, "UNIMOD:170", "Delta:H(-1)N(-1)18O(1)", "Glycosylated asparagine 18O labeling.", false},
    {UNIMOD_NBS_13C_6_, "UNIMOD:171", "NBS:13C(6)", "Shimadzu NBS-13C.", false},
    {UNIMOD_NBS, "UNIMOD:172", "NBS", "Shimadzu NBS-12C.", false},
    {UNIMOD_BHT, "UNIMOD:176", "BHT", "Michael addition of BHT quinone methide to Cysteine and Lysine.", false},
    {UNIMOD_DAET, "UNIMOD:178", "DAET", "Phosphorylation to amine thiol.", false},
    {UNIMOD_Label_13C_9_, "UNIMOD:184", "Label:13C(9)", "13C(9) Silac label.", false},
    {UNIMOD_Label_13C_9__Phospho, "UNIMOD:185", "Label:13C(9)+Phospho", "C13 label (Phosphotyrosine).", false},
    {UNIMOD_HPG, "UNIMOD:186", "HPG", "Hydroxyphenylglyoxal arginine.", false},
    {UNIMOD_2HPG, "UNIMOD:187", "2HPG", "Bis(hydroxphenylglyoxal) arginine.", false},
    {UNIMOD_Label_13C_6_, "UNIMOD:188", "Label:13C(6)", "13C(6) Silac label.", false},
    {UNIMOD_Label_18O_2_, "UNIMOD:193", "Label:18O(2)", "O18 label at both C-terminal oxygens.", false},
    {UNIMOD_AccQTag, "UNIMOD:194", "AccQTag", "6-aminoquinolyl-N-hydroxysuccinimidyl carbamate.", false},
    {UNIMOD_QAT, "UNIMOD:195", "QAT", "APTA-d0.", false},
    {UNIMOD_QAT_2H_3_, "UNIMOD:196", "QAT:2H(3)", "APTA d3.", false},
    {UNIMOD_EQAT, "UNIMOD:197", "EQAT", "EAPTA d0.", false},
    {UNIMOD_EQAT_2H_5_, "UNIMOD:198", "EQAT:2H(5)", "EAPTA d5.", false},
    {UNIMOD_Dimethyl_2H_4_, "UNIMOD:199", "Dimethyl:2H(4)", "DiMethyl-CHD2.", false},
    {UNIMOD_Ethanedithiol, "UNIMOD:200", "Ethanedithiol", "EDT.", false},
    {UNIMOD_Delta_H_6_C_6_O_1_, "UNIMOD:205", "Delta:H(6)C(6)O(1)", "Acrolein addition +94.", false},
    {UNIMOD_Delta_H_4_C_3_O_1_, "UNIMOD:206", "Delta:H(4)C(3)O(1)", "Acrolein addition +56.", false},
    {UNIMOD_Delta_H_2_C_3_, "UNIMOD:207", "Delta:H(2)C(3)", "Acrolein addition +38.", false},
    {UNIMOD_Delta_H_4_C_6_, "UNIMOD:208", "Delta:H(4)C(6)", "Acrolein addition +76.", false},
    {UNIMOD_Delta_H_8_C_6_O_2_, "UNIMOD:209", "Delta:H(8)C(6)O(2)", "Acrolein addition +112.", false},
    {UNIMOD_NEIAA, "UNIMOD:211", "NEIAA", "N-ethyl iodoacetamide-d0.", false},
    {UNIMOD_NEIAA_2H_5_, "UNIMOD:212", "NEIAA:2H(5)", "N-ethyl iodoacetamide-d5.", false},
    {UNIMOD_ADP_Ribosyl, "UNIMOD:213", "ADP-Ribosyl", "ADP Ribose addition.", false},
    {UNIMOD_iTRAQ4plex, "UNIMOD:214", "iTRAQ4plex", "Representative mass and accurate mass for 116 & 117.", false},
    {UNIMOD_IGBP, "UNIMOD:243", "IGBP", "Light IDBEST tag for quantitation.", false},
    {UNIMOD_Crotonaldehyde, "UNIMOD:253", "Crotonaldehyde", "Crotonaldehyde.", false},
    {UNIMOD_Delta_H_2_C_2_, "UNIMOD:254", "Delta:H(2)C(2)", "Acetaldehyde +26.", false},
    {UNIMOD_Delta_H_4_C_2_, "UNIMOD:255", "Delta:H(4)C(2)", "Acetaldehyde +28.", false},
    {UNIMOD_Delta_H_4_C_3_, "UNIMOD:256", "Delta:H(4)C(3)", "Propionaldehyde +40.", false},
    {UNIMOD_Label_18O_1_, "UNIMOD:258", "Label:18O(1)", "O18 Labeling.", false},
    {UNIMOD_Label_13C_6_15N_2_, "UNIMOD:259", "Label:13C(6)15N(2)", "13C(6) 15N(2) Silac label.", false},
    {UNIMOD_Thiophospho, "UNIMOD:260", "Thiophospho", "Thiophosphorylation.", false},
    {UNIMOD_SPITC, "UNIMOD:261", "SPITC", "4-sulfophenyl isothiocyanate.", false},
    {UNIMOD_Label_2H_3_, "UNIMOD:262", "Label:2H(3)", "Trideuteration.", false},
    {UNIMOD_PET, "UNIMOD:264", "PET", "Phosphorylation to pyridyl thiol.", false},
    {UNIMOD_Label_13C_6_15N_4_, "UNIMOD:267", "Label:13C(6)15N(4)", "13C(6) 15N(4) Silac label.", false},
    {UNIMOD_Label_13C_5_15N_1_, "UNIMOD:268", "Label:13C(5)15N(1)", "13C(5) 15N(1) Silac label.", false},
    {UNIMOD_Label_13C_9_15N_1_, "UNIMOD:269", "Label:13C(9)15N(1)", "13C(9) 15N(1) Silac label.", false},
    {UNIMOD_Cytopiloyne, "UNIMOD:270", "Cytopiloyne", "Nucleophilic addtion to cytopiloyne.", false},
    {UNIMOD_Cytopiloyne_water, "UNIMOD:271", "Cytopiloyne+water", "Nucleophilic addition to cytopiloyne+H2O.", false},
    {UNIMOD_CAF, "UNIMOD:272", "CAF", "Sulfonation of N-terminus.", false},
    {UNIMOD_Nitrosyl, "UNIMOD:275", "Nitrosyl", "Nitrosylation.", false},
    {UNIMOD_AEBS, "UNIMOD:276", "AEBS", "Aminoethylbenzenesulfonylation.", false},
    {UNIMOD_Ethanolyl, "UNIMOD:278", "Ethanolyl", "Ethanolation.", false},
    {UNIMOD_Ethyl, "UNIMOD:280", "Ethyl", "Ethylation.", false},
    {UNIMOD_CoenzymeA, "UNIMOD:281", "CoenzymeA", "Cysteine modified Coenzyme A.", false},
    {UNIMOD_Methyl_2H_2_, "UNIMOD:284", "Methyl:2H(2)", "Deuterium Methylation of Lysine.", false},
    {UNIMOD_SulfanilicAcid, "UNIMOD:285", "SulfanilicAcid", "Light Sulfanilic Acid (SA) C12.", false},
    {UNIMOD_SulfanilicAcid_13C_6_, "UNIMOD:286", "SulfanilicAcid:13C(6)", "Heavy Sulfanilic Acid (SA) C13.", false},
    {UNIMOD_Trp__Oxolactone, "UNIMOD:288", "Trp->Oxolactone", "Tryptophan oxidation to oxolactone.", false},
    {UNIMOD_Biotin_PEO_Amine, "UNIMOD:289", "Biotin-PEO-Amine", "Biotin polyethyleneoxide amine.", false},
    {UNIMOD_Biotin_HPDP, "UNIMOD:290", "Biotin-HPDP", "Pierce EZ-Link Biotin-HPDP.", false},
    {UNIMOD_Delta_Hg_1_, "UNIMOD:291", "Delta:Hg(1)", "Mercury Mercaptan.", false},
    {UNIMOD_IodoU_AMP, "UNIMOD:292", "IodoU-AMP", "(Iodo)-uracil MP.", false},
    {UNIMOD_CAMthiopropanoyl, "UNIMOD:293", "CAMthiopropanoyl", "3-(carbamidomethylthio)propanoyl.", false},
    {UNIMOD_IED_Biotin, "UNIMOD:294", "IED-Biotin", "Biotinoyl-iodoacetyl-ethylenediamine.", false},
    {UNIMOD_dHex, "UNIMOD:295", "dHex", "Fucose.", false},
    {UNIMOD_Methyl_2H_3_, "UNIMOD:298", "Methyl:2H(3)", "Deuterated methyl ester.", false},
    {UNIMOD_Carboxy, "UNIMOD:299", "Carboxy", "Carboxylation.", false},
    {UNIMOD_Bromobimane, "UNIMOD:301", "Bromobimane", "Monobromobimane derivative.", false},
    {UNIMOD_Menadione, "UNIMOD:302", "Menadione", "Menadione quinone derivative.", false},
    {UNIMOD_DeStreak, "UNIMOD:303", "DeStreak", "Cysteine mercaptoethanol.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_4_, "UNIMOD:305", "dHex(1)Hex(3)HexNAc(4)", "FA2/G0F.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_4_, "UNIMOD:307", "dHex(1)Hex(4)HexNAc(4)", "FA2G1/G1F.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_, "UNIMOD:308", "dHex(1)Hex(5)HexNAc(4)", "FA2G2/G2F.", false},
    {UNIMOD_Hex_3_HexNAc_4_, "UNIMOD:309", "Hex(3)HexNAc(4)", "A2/G0.", false},
    {UNIMOD_Hex_4_HexNAc_4_, "UNIMOD:310", "Hex(4)HexNAc(4)", "A2G1/G1.", false},
    {UNIMOD_Hex_5_HexNAc_4_, "UNIMOD:311", "Hex(5)HexNAc(4)", "A2G2/G2.", false},
    {UNIMOD_Cysteinyl, "UNIMOD:312", "Cysteinyl", "Cysteinylation.", false},
    {UNIMOD_Lys_loss, "UNIMOD:313", "Lys-loss", "Loss of Lysine.", false},
    {UNIMOD_Nmethylmaleimide, "UNIMOD:314", "Nmethylmaleimide", "Nmethylmaleimide.", false},
    {UNIMOD_DimethylpyrroleAdduct, "UNIMOD:316", "DimethylpyrroleAdduct", "2,5-dimethypyrrole.", false},
    {UNIMOD_Delta_H_2_C_5_, "UNIMOD:318", "Delta:H(2)C(5)", "MDA adduct +62.", false},
    {UNIMOD_Delta_H_2_C_3_O_1_, "UNIMOD:319", "Delta:H(2)C(3)O(1)", "MDA adduct +54.", false},
    {UNIMOD_Nethylmaleimide_water, "UNIMOD:320", "Nethylmaleimide+water", "Nethylmaleimidehydrolysis.", false},
    {UNIMOD_Xlink_B10621, "UNIMOD:323", "Xlink:B10621", "Bis-((N-iodoacetyl)piperazinyl)sulfonerhodamine.", false},
    {UNIMOD_Xlink_DTBP_87_, "UNIMOD:324", "Xlink:DTBP[87]", "Cleaved and reduced DTBP crosslinker.", false},
    {UNIMOD_FP_Biotin, "UNIMOD:325", "FP-Biotin", "10-ethoxyphosphinyl-N-(biotinamidopentyl)decanamide.", false},
    {UNIMOD_Delta_H_4_C_2_O__1_S_1_, "UNIMOD:327", "Delta:H(4)C(2)O(-1)S(1)", "S-Ethylcystine from Serine.", false},
    {UNIMOD_Methyl_2H_3_13C_1_, "UNIMOD:329", "Methyl:2H(3)13C(1)", "Monomethylation.", false},
    {UNIMOD_Dimethyl_2H_6_13C_2_, "UNIMOD:330", "Dimethyl:2H(6)13C(2)", "Dimethylation.", false},
    {UNIMOD_Thiophos_S_S_biotin, "UNIMOD:332", "Thiophos-S-S-biotin", "Thiophosphate labeled with biotin-HPDP.", false},
    {UNIMOD_Can_FP_biotin, "UNIMOD:333", "Can-FP-biotin", "6-N-biotinylaminohexyl isopropyl phosphate.", false},
    {UNIMOD_HNE_Delta_H_2_, "UNIMOD:335", "HNE+Delta:H(2)", "Reduced 4-Hydroxynonenal.", false},
    {UNIMOD_Methylamine, "UNIMOD:337", "Methylamine", "Michael addition with methylamine.", false},
    {UNIMOD_Bromo, "UNIMOD:340", "Bromo", "Bromination.", false},
    {UNIMOD_Amino, "UNIMOD:342", "Amino", "Tyrosine oxidation to 2-aminotyrosine.", false},
    {UNIMOD_Argbiotinhydrazide, "UNIMOD:343", "Argbiotinhydrazide", "Oxidized Arginine biotinylated with biotin hydrazide.", false},
    {UNIMOD_Arg__GluSA, "UNIMOD:344", "Arg->GluSA", "Arginine oxidation to glutamic semialdehyde.", false},
    {UNIMOD_Trioxidation, "UNIMOD:345", "Trioxidation", "Cysteine oxidation to cysteic acid.", false},
    {UNIMOD_His__Asn, "UNIMOD:348", "His->Asn", "His->Asn substitution.", false},
    {UNIMOD_His__Asp, "UNIMOD:349", "His->Asp", "His->Asp substitution.", false},
    {UNIMOD_Trp__Hydroxykynurenin, "UNIMOD:350", "Trp->Hydroxykynurenin", "Tryptophan oxidation to hydroxykynurenin.", false},
    {UNIMOD_Trp__Kynurenin, "UNIMOD:351", "Trp->Kynurenin", "Tryptophan oxidation to kynurenin.", false},
    {UNIMOD_Lys__Allysine, "UNIMOD:352", "Lys->Allysine", "Lysine oxidation to aminoadipic semialdehyde.", false},
    {UNIMOD_Lysbiotinhydrazide, "UNIMOD:353", "Lysbiotinhydrazide", "Oxidized Lysine biotinylated with biotin hydrazide.", false},
    {UNIMOD_Nitro, "UNIMOD:354", "Nitro", "Oxidation to nitro.", false},
    {UNIMOD_probiotinhydrazide, "UNIMOD:357", "probiotinhydrazide", "Oxidized proline biotinylated with biotin hydrazide.", false},
    {UNIMOD_Pro__pyro_Glu, "UNIMOD:359", "Pro->pyro-Glu", "Proline oxidation to pyroglutamic acid.", false},
    {UNIMOD_Pro__Pyrrolidinone, "UNIMOD:360", "Pro->Pyrrolidinone", "Proline oxidation to pyrrolidinone.", false},
    {UNIMOD_Thrbiotinhydrazide, "UNIMOD:361", "Thrbiotinhydrazide", "Oxidized Threonine biotinylated with biotin hydrazide.", false},
    {UNIMOD_Diisopropylphosphate, "UNIMOD:362", "Diisopropylphosphate", "O-Diisopropylphosphorylation.", false},
    {UNIMOD_Isopropylphospho, "UNIMOD:363", "Isopropylphospho", "O-Isopropylphosphorylation.", false},
    {UNIMOD_ICPL_13C_6_, "UNIMOD:364", "ICPL:13C(6)", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, heavy form.", false},
    {UNIMOD_ICPL, "UNIMOD:365", "ICPL", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, light form.", false},
    {UNIMOD_Deamidated_18O_1_, "UNIMOD:366", "Deamidated:18O(1)", "Deamidation in presence of O18.", false},
    {UNIMOD_Cys__Dha, "UNIMOD:368", "Cys->Dha", "Dehydroalanine (from Cysteine).", false},
    {UNIMOD_Pro__Pyrrolidone, "UNIMOD:369", "Pro->Pyrrolidone", "Pyrrolidone from Proline.", false},
    {UNIMOD_HMVK, "UNIMOD:371", "HMVK", "Michael addition of hydroxymethylvinyl ketone to cysteine.", false},
    {UNIMOD_Arg__Orn, "UNIMOD:372", "Arg->Orn", "Ornithine from Arginine.", false},
    {UNIMOD_Dehydro, "UNIMOD:374", "Dehydro", "Half of a disulfide bridge.", false},
    {UNIMOD_Diphthamide, "UNIMOD:375", "Diphthamide", "Diphthamide.", false},
    {UNIMOD_Hydroxyfarnesyl, "UNIMOD:376", "Hydroxyfarnesyl", "Hydroxyfarnesyl.", false},
    {UNIMOD_Diacylglycerol, "UNIMOD:377", "Diacylglycerol", "Diacylglycerol.", false},
    {UNIMOD_Carboxyethyl, "UNIMOD:378", "Carboxyethyl", "Carboxyethyl.", false},
    {UNIMOD_Hypusine, "UNIMOD:379", "Hypusine", "Hypusine.", false},
    {UNIMOD_Retinylidene, "UNIMOD:380", "Retinylidene", "Retinal.", false},
    {UNIMOD_Lys__AminoadipicAcid, "UNIMOD:381", "Lys->AminoadipicAcid", "Alpha-amino adipic acid.", false},
    {UNIMOD_Cys__PyruvicAcid, "UNIMOD:382", "Cys->PyruvicAcid", "Pyruvic acid from N-term cys.", false},
    {UNIMOD_Ammonia_loss, "UNIMOD:385", "Ammonia-loss", "Loss of ammonia.", false},
    {UNIMOD_Phycocyanobilin, "UNIMOD:387", "Phycocyanobilin", "Phycocyanobilin.", false},
    {UNIMOD_Phycoerythrobilin, "UNIMOD:388", "Phycoerythrobilin", "Phycoerythrobilin.", false},
    {UNIMOD_Phytochromobilin, "UNIMOD:389", "Phytochromobilin", "Phytochromobilin.", false},
    {UNIMOD_Heme, "UNIMOD:390", "Heme", "Heme.", false},
    {UNIMOD_Molybdopterin, "UNIMOD:391", "Molybdopterin", "Molybdopterin.", false},
    {UNIMOD_Quinone, "UNIMOD:392", "Quinone", "Quinone.", false},
    {UNIMOD_Glucosylgalactosyl, "UNIMOD:393", "Glucosylgalactosyl", "Glucosylgalactosyl hydroxylysine.", false},
    {UNIMOD_GPIanchor, "UNIMOD:394", "GPIanchor", "Glycosylphosphatidylinositol.", false},
    {UNIMOD_PhosphoribosyldephosphoCoA, "UNIMOD:395", "PhosphoribosyldephosphoCoA", "Phosphoribosyl dephospho-coenzyme A.", false},
    {UNIMOD_GlycerylPE, "UNIMOD:396", "GlycerylPE", "Glycerylphosphorylethanolamine.", false},
    {UNIMOD_Triiodothyronine, "UNIMOD:397", "Triiodothyronine", "Triiodo.", false},
    {UNIMOD_Thyroxine, "UNIMOD:398", "Thyroxine", "Tetraiodo.", false},
    {UNIMOD_Tyr__Dha, "UNIMOD:400", "Tyr->Dha", "Dehydroalanine (from Tyrosine).", false},
    {UNIMOD_Didehydro, "UNIMOD:401", "Didehydro", "2-amino-3-oxo-butanoic_acid.", false},
    {UNIMOD_Cys__Oxoalanine, "UNIMOD:402", "Cys->Oxoalanine", "Oxoalanine.", false},
    {UNIMOD_Ser__LacticAcid, "UNIMOD:403", "Ser->LacticAcid", "Lactic acid from N-term Ser.", false},
    {UNIMOD_Phosphoadenosine, "UNIMOD:405", "Phosphoadenosine", "AMP.", false},
    {UNIMOD_Hydroxycinnamyl, "UNIMOD:407", "Hydroxycinnamyl", "Hydroxycinnamyl.", false},
    {UNIMOD_Glycosyl, "UNIMOD:408", "Glycosyl", "Glycosyl-L-hydroxyproline.", false},
    {UNIMOD_FMNH, "UNIMOD:409", "FMNH", "Flavin mononucleotide.", false},
    {UNIMOD_Archaeol, "UNIMOD:410", "Archaeol", "S-diphytanylglycerol diether.", false},
    {UNIMOD_Phenylisocyanate, "UNIMOD:411", "Phenylisocyanate", "Phenyl isocyanate.", false},
    {UNIMOD_Phenylisocyanate_2H_5_, "UNIMOD:412", "Phenylisocyanate:2H(5)", "D5-phenyl isocyanate.", false},
    {UNIMOD_Phosphoguanosine, "UNIMOD:413", "Phosphoguanosine", "Phospho-guanosine.", false},
    {UNIMOD_Hydroxymethyl, "UNIMOD:414", "Hydroxymethyl", "Hydroxymethyl.", false},
    {UNIMOD_MolybdopterinGD_Delta_S__1_Se_1_, "UNIMOD:415", "MolybdopterinGD+Delta:S(-1)Se(1)", "L-selenocysteinyl molybdenum bis(molybdopterin guanine dinucleotide).", false},
    {UNIMOD_Dipyrrolylmethanemethyl, "UNIMOD:416", "Dipyrrolylmethanemethyl", "Dipyrrolylmethanemethyl.", false},
    {UNIMOD_PhosphoUridine, "UNIMOD:417", "PhosphoUridine", "Uridine phosphodiester.", false},
    {UNIMOD_Glycerophospho, "UNIMOD:419", "Glycerophospho", "Glycerophospho.", false},
    {UNIMOD_Carboxy__Thiocarboxy, "UNIMOD:420", "Carboxy->Thiocarboxy", "Thiocarboxylic acid.", false},
    {UNIMOD_Sulfide, "UNIMOD:421", "Sulfide", "Persulfide.", false},
    {UNIMOD_PyruvicAcidIminyl, "UNIMOD:422", "PyruvicAcidIminyl", "N-pyruvic acid 2-iminyl.", false},
    {UNIMOD_Delta_Se_1_, "UNIMOD:423", "Delta:Se(1)", "Selenyl.", false},
    {UNIMOD_MolybdopterinGD, "UNIMOD:424", "MolybdopterinGD", "Molybdenum bis(molybdopterin guanine dinucleotide).", false},
    {UNIMOD_Dioxidation, "UNIMOD:425", "Dioxidation", "Dihydroxy.", false},
    {UNIMOD_Octanoyl, "UNIMOD:426", "Octanoyl", "Octanoyl.", false},
    {UNIMOD_PhosphoHexNAc, "UNIMOD:428", "PhosphoHexNAc", "N-acetylglucosamine-1-phosphoryl.", false},
    {UNIMOD_PhosphoHex, "UNIMOD:429", "PhosphoHex", "Phosphoglycosyl-D-mannose-1-phosphoryl.", false},
    {UNIMOD_Palmitoleyl, "UNIMOD:431", "Palmitoleyl", "Palmitoleyl.", false},
    {UNIMOD_Cholesterol, "UNIMOD:432", "Cholesterol", "Cholesterol ester.", false},
    {UNIMOD_Didehydroretinylidene, "UNIMOD:433", "Didehydroretinylidene", "3,4-didehydroretinylidene.", false},
    {UNIMOD_CHDH, "UNIMOD:434", "CHDH", "Cis-14-hydroxy-10,13-dioxo-7-heptadecenoic ester.", false},
    {UNIMOD_Methylpyrroline, "UNIMOD:435", "Methylpyrroline", "4-methyl-delta-1-pyrroline-5-carboxyl.", false},
    {UNIMOD_Hydroxyheme, "UNIMOD:436", "Hydroxyheme", "Hydroxyheme.", false},
    {UNIMOD_MicrocinC7, "UNIMOD:437", "MicrocinC7", "(3-aminopropyl)(L-aspartyl-1-amino)phosphoryl-5-adenosine.", false},
    {UNIMOD_Cyano, "UNIMOD:438", "Cyano", "Cyano.", false},
    {UNIMOD_Diironsubcluster, "UNIMOD:439", "Diironsubcluster", "Hydrogenase diiron subcluster.", false},
    {UNIMOD_Amidino, "UNIMOD:440", "Amidino", "Amidino.", false},
    {UNIMOD_FMN, "UNIMOD:442", "FMN", "O3-(riboflavin phosphoryl).", false},
    {UNIMOD_FMNC, "UNIMOD:443", "FMNC", "S-(4a-FMN).", false},
    {UNIMOD_CuSMo, "UNIMOD:444", "CuSMo", "Copper sulfido molybdopterin cytosine dinuncleotide.", false},
    {UNIMOD_Hydroxytrimethyl, "UNIMOD:445", "Hydroxytrimethyl", "5-hydroxy-N6,N6,N6-trimethyl.", false},
    {UNIMOD_Deoxy, "UNIMOD:447", "Deoxy", "Reduction.", false},
    {UNIMOD_Microcin, "UNIMOD:448", "Microcin", "Microcin E492 siderophore ester from serine.", false},
    {UNIMOD_Decanoyl, "UNIMOD:449", "Decanoyl", "Lipid.", false},
    {UNIMOD_Glu, "UNIMOD:450", "Glu", "Monoglutamyl.", false},
    {UNIMOD_GluGlu, "UNIMOD:451", "GluGlu", "Diglutamyl.", false},
    {UNIMOD_GluGluGlu, "UNIMOD:452", "GluGluGlu", "Triglutamyl.", false},
    {UNIMOD_GluGluGluGlu, "UNIMOD:453", "GluGluGluGlu", "Tetraglutamyl.", false},
    {UNIMOD_HexN, "UNIMOD:454", "HexN", "Hexosamine.", false},
    {UNIMOD_Xlink_DMP_154_, "UNIMOD:455", "Xlink:DMP[154]", "Free monolink of DMP crosslinker.", false},
    {UNIMOD_NDA, "UNIMOD:457", "NDA", "Naphthalene-2,3-dicarboxaldehyde.", false},
    {UNIMOD_SPITC_13C_6_, "UNIMOD:464", "SPITC:13C(6)", "4-sulfophenyl isothiocyanate (Heavy C13).", false},
    {UNIMOD_AEC_MAEC, "UNIMOD:472", "AEC-MAEC", "Aminoethylcysteine.", false},
    {UNIMOD_TMAB, "UNIMOD:476", "TMAB", "4-trimethyllammoniumbutyryl-.", false},
    {UNIMOD_TMAB_2H_9_, "UNIMOD:477", "TMAB:2H(9)", "D9-4-trimethyllammoniumbutyryl-.", false},
    {UNIMOD_FTC, "UNIMOD:478", "FTC", "Fluorescein-5-thiosemicarbazide.", false},
    {UNIMOD_Label_2H_4_, "UNIMOD:481", "Label:2H(4)", "4,4,5,5-D4 Lysine.", false},
    {UNIMOD_DHP, "UNIMOD:488", "DHP", "Dehydropyrrolizidine alkaloid (dehydroretronecine) on cysteines.", false},
    {UNIMOD_Hep, "UNIMOD:490", "Hep", "Heptose.", false},
    {UNIMOD_BADGE, "UNIMOD:493", "BADGE", "Bisphenol A diglycidyl ether derivative.", false},
    {UNIMOD_CyDye_Cy3, "UNIMOD:494", "CyDye-Cy3", "Cy3 CyDye DIGE Fluor saturation dye.", false},
    {UNIMOD_CyDye_Cy5, "UNIMOD:495", "CyDye-Cy5", "Cy5 CyDye DIGE Fluor saturation dye.", false},
    {UNIMOD_BHTOH, "UNIMOD:498", "BHTOH", "Michael addition of t-butyl hydroxylated BHT (BHTOH) to C, H or K.", false},
    {UNIMOD_IGBP_13C_2_, "UNIMOD:499", "IGBP:13C(2)", "Heavy IDBEST tag for quantitation.", false},
    {UNIMOD_Nmethylmaleimide_water, "UNIMOD:500", "Nmethylmaleimide+water", "Nmethylmaleimidehydrolysis.", false},
    {UNIMOD_PyMIC, "UNIMOD:501", "PyMIC", "3-methyl-2-pyridyl isocyanate.", false},
    {UNIMOD_LG_lactam_K, "UNIMOD:503", "LG-lactam-K", "Levuglandinyl - lysine lactam adduct.", false},
    {UNIMOD_LG_Hlactam_K, "UNIMOD:504", "LG-Hlactam-K", "Levuglandinyl - lysine hydroxylactam adduct.", false},
    {UNIMOD_LG_lactam_R, "UNIMOD:505", "LG-lactam-R", "Levuglandinyl - arginine lactam adduct.", false},
    {UNIMOD_LG_Hlactam_R, "UNIMOD:506", "LG-Hlactam-R", "Levuglandinyl - arginine hydroxylactam adduct.", false},
    {UNIMOD_Dimethyl_2H_4_13C_2_, "UNIMOD:510", "Dimethyl:2H(4)13C(2)", "DiMethyl-C13HD2.", false},
    {UNIMOD_Hex_2_, "UNIMOD:512", "Hex(2)", "Lactosylation.", false},
    {UNIMOD_C8_QAT, "UNIMOD:513", "C8-QAT", "[3-(2,5)-Dioxopyrrolidin-1-yloxycarbonyl)-propyl]dimethyloctylammonium.", false},
    {UNIMOD_PropylNAGthiazoline, "UNIMOD:514", "PropylNAGthiazoline", "Propyl-1,2-dideoxy-2\\'-methyl-alpha-D-glucopyranoso-[2,1-d]-Delta2\\'-thiazoline.", false},
    {UNIMOD_FNEM, "UNIMOD:515", "FNEM", "Fluorescein-5-maleimide.", false},
    {UNIMOD_Diethyl, "UNIMOD:518", "Diethyl", "Diethylation, analogous to Dimethylation.", false},
    {UNIMOD_BisANS, "UNIMOD:519", "BisANS", "4,4\\'-dianilino-1,1\\'-binaphthyl-5,5\\'-disulfonic acid.", false},
    {UNIMOD_Piperidine, "UNIMOD:520", "Piperidine", "Piperidination.", false},
    {UNIMOD_Maleimide_PEO2_Biotin, "UNIMOD:522", "Maleimide-PEO2-Biotin", "Maleimide-Biotin.", false},
    {UNIMOD_Sulfo_NHS_LC_LC_Biotin, "UNIMOD:523", "Sulfo-NHS-LC-LC-Biotin", "Biot_LC_LC.", false},
    {UNIMOD_CLIP_TRAQ_2, "UNIMOD:525", "CLIP_TRAQ_2", "CLIP_TRAQ_2.", false},
    {UNIMOD_Dethiomethyl, "UNIMOD:526", "Dethiomethyl", "Prompt loss of side chain from oxidised Met.", false},
    {UNIMOD_Methyl_Deamidated, "UNIMOD:528", "Methyl+Deamidated", "Deamidation followed by a methylation.", false},
    {UNIMOD_Delta_H_5_C_2_, "UNIMOD:529", "Delta:H(5)C(2)", "Dimethylation of proline residue.", false},
    {UNIMOD_Cation_K, "UNIMOD:530", "Cation:K", "Replacement of proton by potassium.", false},
    {UNIMOD_Cation_Cu_I_, "UNIMOD:531", "Cation:Cu[I]", "Replacement of proton by copper.", false},
    {UNIMOD_iTRAQ4plex114, "UNIMOD:532", "iTRAQ4plex114", "Accurate mass for 114.", false},
    {UNIMOD_iTRAQ4plex115, "UNIMOD:533", "iTRAQ4plex115", "Accurate mass for 115.", false},
    {UNIMOD_Dibromo, "UNIMOD:534", "Dibromo", "Dibromo.", false},
    {UNIMOD_LRGG, "UNIMOD:535", "LRGG", "Ubiquitination.", false},
    {UNIMOD_CLIP_TRAQ_3, "UNIMOD:536", "CLIP_TRAQ_3", "CLIP_TRAQ_3.", false},
    {UNIMOD_CLIP_TRAQ_4, "UNIMOD:537", "CLIP_TRAQ_4", "CLIP_TRAQ_4.", false},
    {UNIMOD_Biotin_Cayman_10141, "UNIMOD:538", "Biotin:Cayman-10141", "Was 15dB-biotin.", false},
    {UNIMOD_Biotin_Cayman_10013, "UNIMOD:539", "Biotin:Cayman-10013", "Was PGA1-biotin.", false},
    {UNIMOD_Ala__Ser, "UNIMOD:540", "Ala->Ser", "Ala->Ser substitution.", false},
    {UNIMOD_Ala__Thr, "UNIMOD:541", "Ala->Thr", "Ala->Thr substitution.", false},
    {UNIMOD_Ala__Asp, "UNIMOD:542", "Ala->Asp", "Ala->Asp substitution.", false},
    {UNIMOD_Ala__Pro, "UNIMOD:543", "Ala->Pro", "Ala->Pro substitution.", false},
    {UNIMOD_Ala__Gly, "UNIMOD:544", "Ala->Gly", "Ala->Gly substitution.", false},
    {UNIMOD_Ala__Glu, "UNIMOD:545", "Ala->Glu", "Ala->Glu substitution.", false},
    {UNIMOD_Ala__Val, "UNIMOD:546", "Ala->Val", "Ala->Val substitution.", false},
    {UNIMOD_Cys__Phe, "UNIMOD:547", "Cys->Phe", "Cys->Phe substitution.", false},
    {UNIMOD_Cys__Ser, "UNIMOD:548", "Cys->Ser", "Cys->Ser substitution.", false},
    {UNIMOD_Cys__Trp, "UNIMOD:549", "Cys->Trp", "Cys->Trp substitution.", false},
    {UNIMOD_Cys__Tyr, "UNIMOD:550", "Cys->Tyr", "Cys->Tyr substitution.", false},
    {UNIMOD_Cys__Arg, "UNIMOD:551", "Cys->Arg", "Cys->Arg substitution.", false},
    {UNIMOD_Cys__Gly, "UNIMOD:552", "Cys->Gly", "Cys->Gly substitution.", false},
    {UNIMOD_Asp__Ala, "UNIMOD:553", "Asp->Ala", "Asp->Ala substitution.", false},
    {UNIMOD_Asp__His, "UNIMOD:554", "Asp->His", "Asp->His substitution.", false},
    {UNIMOD_Asp__Asn, "UNIMOD:555", "Asp->Asn", "Asp->Asn substitution.", false},
    {UNIMOD_Asp__Gly, "UNIMOD:556", "Asp->Gly", "Asp->Gly substitution.", false},
    {UNIMOD_Asp__Tyr, "UNIMOD:557", "Asp->Tyr", "Asp->Tyr substitution.", false},
    {UNIMOD_Asp__Glu, "UNIMOD:558", "Asp->Glu", "Asp->Glu substitution.", false},
    {UNIMOD_Asp__Val, "UNIMOD:559", "Asp->Val", "Asp->Val substitution.", false},
    {UNIMOD_Glu__Ala, "UNIMOD:560", "Glu->Ala", "Glu->Ala substitution.", false},
    {UNIMOD_Glu__Gln, "UNIMOD:561", "Glu->Gln", "Glu->Gln substitution.", false},
    {UNIMOD_Glu__Asp, "UNIMOD:562", "Glu->Asp", "Glu->Asp substitution.", false},
    {UNIMOD_Glu__Lys, "UNIMOD:563", "Glu->Lys", "Glu->Lys substitution.", false},
    {UNIMOD_Glu__Gly, "UNIMOD:564", "Glu->Gly", "Glu->Gly substitution.", false},
    {UNIMOD_Glu__Val, "UNIMOD:565", "Glu->Val", "Glu->Val substitution.", false},
    {UNIMOD_Phe__Ser, "UNIMOD:566", "Phe->Ser", "Phe->Ser substitution.", false},
    {UNIMOD_Phe__Cys, "UNIMOD:567", "Phe->Cys", "Phe->Cys substitution.", false},
    {UNIMOD_Phe__Xle, "UNIMOD:568", "Phe->Xle", "Phe->Leu/Ile substitution.", false},
    {UNIMOD_Phe__Tyr, "UNIMOD:569", "Phe->Tyr", "Phe->Tyr substitution.", false},
    {UNIMOD_Phe__Val, "UNIMOD:570", "Phe->Val", "Phe->Val substitution.", false},
    {UNIMOD_Gly__Ala, "UNIMOD:571", "Gly->Ala", "Gly->Ala substitution.", false},
    {UNIMOD_Gly__Ser, "UNIMOD:572", "Gly->Ser", "Gly->Ser substitution.", false},
    {UNIMOD_Gly__Trp, "UNIMOD:573", "Gly->Trp", "Gly->Trp substitution.", false},
    {UNIMOD_Gly__Glu, "UNIMOD:574", "Gly->Glu", "Gly->Glu substitution.", false},
    {UNIMOD_Gly__Val, "UNIMOD:575", "Gly->Val", "Gly->Val substitution.", false},
    {UNIMOD_Gly__Asp, "UNIMOD:576", "Gly->Asp", "Gly->Asp substitution.", false},
    {UNIMOD_Gly__Cys, "UNIMOD:577", "Gly->Cys", "Gly->Cys substitution.", false},
    {UNIMOD_Gly__Arg, "UNIMOD:578", "Gly->Arg", "Gly->Arg substitution.", false},
    {UNIMOD_His__Pro, "UNIMOD:580", "His->Pro", "His->Pro substitution.", false},
    {UNIMOD_His__Tyr, "UNIMOD:581", "His->Tyr", "His->Tyr substitution.", false},
    {UNIMOD_His__Gln, "UNIMOD:582", "His->Gln", "His->Gln substitution.", false},
    {UNIMOD_His__Arg, "UNIMOD:584", "His->Arg", "His->Arg substitution.", false},
    {UNIMOD_His__Xle, "UNIMOD:585", "His->Xle", "His->Leu/Ile substitution.", false},
    {UNIMOD_Xle__Thr, "UNIMOD:588", "Xle->Thr", "Leu/Ile->Thr substitution.", false},
    {UNIMOD_Xle__Asn, "UNIMOD:589", "Xle->Asn", "Leu/Ile->Asn substitution.", false},
    {UNIMOD_Xle__Lys, "UNIMOD:590", "Xle->Lys", "Leu/Ile->Lys substitution.", false},
    {UNIMOD_Lys__Thr, "UNIMOD:594", "Lys->Thr", "Lys->Thr substitution.", false},
    {UNIMOD_Lys__Asn, "UNIMOD:595", "Lys->Asn", "Lys->Asn substitution.", false},
    {UNIMOD_Lys__Glu, "UNIMOD:596", "Lys->Glu", "Lys->Glu substitution.", false},
    {UNIMOD_Lys__Gln, "UNIMOD:597", "Lys->Gln", "Lys->Gln substitution.", false},
    {UNIMOD_Lys__Met, "UNIMOD:598", "Lys->Met", "Lys->Met substitution.", false},
    {UNIMOD_Lys__Arg, "UNIMOD:599", "Lys->Arg", "Lys->Arg substitution.", false},
    {UNIMOD_Lys__Xle, "UNIMOD:600", "Lys->Xle", "Lys->Leu/Ile substitution.", false},
    {UNIMOD_Xle__Ser, "UNIMOD:601", "Xle->Ser", "Leu/Ile->Ser substitution.", false},
    {UNIMOD_Xle__Phe, "UNIMOD:602", "Xle->Phe", "Leu/Ile->Phe substitution.", false},
    {UNIMOD_Xle__Trp, "UNIMOD:603", "Xle->Trp", "Leu/Ile->Trp substitution.", false},
    {UNIMOD_Xle__Pro, "UNIMOD:604", "Xle->Pro", "Leu/Ile->Pro substitution.", false},
    {UNIMOD_Xle__Val, "UNIMOD:605", "Xle->Val", "Leu/Ile->Val substitution.", false},
    {UNIMOD_Xle__His, "UNIMOD:606", "Xle->His", "Leu/Ile->His substitution.", false},
    {UNIMOD_Xle__Gln, "UNIMOD:607", "Xle->Gln", "Leu/Ile->Gln substitution.", false},
    {UNIMOD_Xle__Met, "UNIMOD:608", "Xle->Met", "Leu/Ile->Met substitution.", false},
    {UNIMOD_Xle__Arg, "UNIMOD:609", "Xle->Arg", "Leu/Ile->Arg substitution.", false},
    {UNIMOD_Met__Thr, "UNIMOD:610", "Met->Thr", "Met->Thr substitution.", false},
    {UNIMOD_Met__Arg, "UNIMOD:611", "Met->Arg", "Met->Arg substitution.", false},
    {UNIMOD_Met__Lys, "UNIMOD:613", "Met->Lys", "Met->Lys substitution.", false},
    {UNIMOD_Met__Xle, "UNIMOD:614", "Met->Xle", "Met->Leu/Ile substitution.", false},
    {UNIMOD_Met__Val, "UNIMOD:615", "Met->Val", "Met->Val substitution.", false},
    {UNIMOD_Asn__Ser, "UNIMOD:616", "Asn->Ser", "Asn->Ser substitution.", false},
    {UNIMOD_Asn__Thr, "UNIMOD:617", "Asn->Thr", "Asn->Thr substitution.", false},
    {UNIMOD_Asn__Lys, "UNIMOD:618", "Asn->Lys", "Asn->Lys substitution.", false},
    {UNIMOD_Asn__Tyr, "UNIMOD:619", "Asn->Tyr", "Asn->Tyr substitution.", false},
    {UNIMOD_Asn__His, "UNIMOD:620", "Asn->His", "Asn->His substitution.", false},
    {UNIMOD_Asn__Asp, "UNIMOD:621", "Asn->Asp", "Asn->Asp substitution.", false},
    {UNIMOD_Asn__Xle, "UNIMOD:622", "Asn->Xle", "Asn->Leu/Ile substitution.", false},
    {UNIMOD_Pro__Ser, "UNIMOD:623", "Pro->Ser", "Pro->Ser substitution.", false},
    {UNIMOD_Pro__Ala, "UNIMOD:624", "Pro->Ala", "Pro->Ala substitution.", false},
    {UNIMOD_Pro__His, "UNIMOD:625", "Pro->His", "Pro->His substitution.", false},
    {UNIMOD_Pro__Gln, "UNIMOD:626", "Pro->Gln", "Pro->Gln substitution.", false},
    {UNIMOD_Pro__Thr, "UNIMOD:627", "Pro->Thr", "Pro->Thr substitution.", false},
    {UNIMOD_Pro__Arg, "UNIMOD:628", "Pro->Arg", "Pro->Arg substitution.", false},
    {UNIMOD_Pro__Xle, "UNIMOD:629", "Pro->Xle", "Pro->Leu/Ile substitution.", false},
    {UNIMOD_Gln__Pro, "UNIMOD:630", "Gln->Pro", "Gln->Pro substitution.", false},
    {UNIMOD_Gln__Lys, "UNIMOD:631", "Gln->Lys", "Gln->Lys substitution.", false},
    {UNIMOD_Gln__Glu, "UNIMOD:632", "Gln->Glu", "Gln->Glu substitution.", false},
    {UNIMOD_Gln__His, "UNIMOD:633", "Gln->His", "Gln->His substitution.", false},
    {UNIMOD_Gln__Arg, "UNIMOD:634", "Gln->Arg", "Gln->Arg substitution.", false},
    {UNIMOD_Gln__Xle, "UNIMOD:635", "Gln->Xle", "Gln->Leu/Ile substitution.", false},
    {UNIMOD_Arg__Ser, "UNIMOD:636", "Arg->Ser", "Arg->Ser substitution.", false},
    {UNIMOD_Arg__Trp, "UNIMOD:637", "Arg->Trp", "Arg->Trp substitution.", false},
    {UNIMOD_Arg__Thr, "UNIMOD:638", "Arg->Thr", "Arg->Thr substitution.", false},
    {UNIMOD_Arg__Pro, "UNIMOD:639", "Arg->Pro", "Arg->Pro substitution.", false},
    {UNIMOD_Arg__Lys, "UNIMOD:640", "Arg->Lys", "Arg->Lys substitution.", false},
    {UNIMOD_Arg__His, "UNIMOD:641", "Arg->His", "Arg->His substitution.", false},
    {UNIMOD_Arg__Gln, "UNIMOD:642", "Arg->Gln", "Arg->Gln substitution.", false},
    {UNIMOD_Arg__Met, "UNIMOD:643", "Arg->Met", "Arg->Met substitution.", false},
    {UNIMOD_Arg__Cys, "UNIMOD:644", "Arg->Cys", "Arg->Cys substitution.", false},
    {UNIMOD_Arg__Xle, "UNIMOD:645", "Arg->Xle", "Arg->Leu/Ile substitution.", false},
    {UNIMOD_Arg__Gly, "UNIMOD:646", "Arg->Gly", "Arg->Gly substitution.", false},
    {UNIMOD_Ser__Phe, "UNIMOD:647", "Ser->Phe", "Ser->Phe substitution.", false},
    {UNIMOD_Ser__Ala, "UNIMOD:648", "Ser->Ala", "Ser->Ala substitution.", false},
    {UNIMOD_Ser__Trp, "UNIMOD:649", "Ser->Trp", "Ser->Trp substitution.", false},
    {UNIMOD_Ser__Thr, "UNIMOD:650", "Ser->Thr", "Ser->Thr substitution.", false},
    {UNIMOD_Ser__Asn, "UNIMOD:651", "Ser->Asn", "Ser->Asn substitution.", false},
    {UNIMOD_Ser__Pro, "UNIMOD:652", "Ser->Pro", "Ser->Pro substitution.", false},
    {UNIMOD_Ser__Tyr, "UNIMOD:653", "Ser->Tyr", "Ser->Tyr substitution.", false},
    {UNIMOD_Ser__Cys, "UNIMOD:654", "Ser->Cys", "Ser->Cys substitution.", false},
    {UNIMOD_Ser__Arg, "UNIMOD:655", "Ser->Arg", "Ser->Arg substitution.", false},
    {UNIMOD_Ser__Xle, "UNIMOD:656", "Ser->Xle", "Ser->Leu/Ile substitution.", false},
    {UNIMOD_Ser__Gly, "UNIMOD:657", "Ser->Gly", "Ser->Gly substitution.", false},
    {UNIMOD_Thr__Ser, "UNIMOD:658", "Thr->Ser", "Thr->Ser substitution.", false},
    {UNIMOD_Thr__Ala, "UNIMOD:659", "Thr->Ala", "Thr->Ala substitution.", false},
    {UNIMOD_Thr__Asn, "UNIMOD:660", "Thr->Asn", "Thr->Asn substitution.", false},
    {UNIMOD_Thr__Lys, "UNIMOD:661", "Thr->Lys", "Thr->Lys substitution.", false},
    {UNIMOD_Thr__Pro, "UNIMOD:662", "Thr->Pro", "Thr->Pro substitution.", false},
    {UNIMOD_Thr__Met, "UNIMOD:663", "Thr->Met", "Thr->Met substitution.", false},
    {UNIMOD_Thr__Xle, "UNIMOD:664", "Thr->Xle", "Thr->Leu/Ile substitution.", false},
    {UNIMOD_Thr__Arg, "UNIMOD:665", "Thr->Arg", "Thr->Arg substitution.", false},
    {UNIMOD_Val__Phe, "UNIMOD:666", "Val->Phe", "Val->Phe substitution.", false},
    {UNIMOD_Val__Ala, "UNIMOD:667", "Val->Ala", "Val->Ala substitution.", false},
    {UNIMOD_Val__Glu, "UNIMOD:668", "Val->Glu", "Val->Glu substitution.", false},
    {UNIMOD_Val__Met, "UNIMOD:669", "Val->Met", "Val->Met substitution.", false},
    {UNIMOD_Val__Asp, "UNIMOD:670", "Val->Asp", "Val->Asp substitution.", false},
    {UNIMOD_Val__Xle, "UNIMOD:671", "Val->Xle", "Val->Leu/Ile substitution.", false},
    {UNIMOD_Val__Gly, "UNIMOD:672", "Val->Gly", "Val->Gly substitution.", false},
    {UNIMOD_Trp__Ser, "UNIMOD:673", "Trp->Ser", "Trp->Ser substitution.", false},
    {UNIMOD_Trp__Cys, "UNIMOD:674", "Trp->Cys", "Trp->Cys substitution.", false},
    {UNIMOD_Trp__Arg, "UNIMOD:675", "Trp->Arg", "Trp->Arg substitution.", false},
    {UNIMOD_Trp__Gly, "UNIMOD:676", "Trp->Gly", "Trp->Gly substitution.", false},
    {UNIMOD_Trp__Xle, "UNIMOD:677", "Trp->Xle", "Trp->Leu/Ile substitution.", false},
    {UNIMOD_Tyr__Phe, "UNIMOD:678", "Tyr->Phe", "Tyr->Phe substitution.", false},
    {UNIMOD_Tyr__Ser, "UNIMOD:679", "Tyr->Ser", "Tyr->Ser substitution.", false},
    {UNIMOD_Tyr__Asn, "UNIMOD:680", "Tyr->Asn", "Tyr->Asn substitution.", false},
    {UNIMOD_Tyr__His, "UNIMOD:681", "Tyr->His", "Tyr->His substitution.", false},
    {UNIMOD_Tyr__Asp, "UNIMOD:682", "Tyr->Asp", "Tyr->Asp substitution.", false},
    {UNIMOD_Tyr__Cys, "UNIMOD:683", "Tyr->Cys", "Tyr->Cys substitution.", false},
    {UNIMOD_BDMAPP, "UNIMOD:684", "BDMAPP", "Mass Defect Tag on lysine e-amino.", false},
    {UNIMOD_NA_LNO2, "UNIMOD:685", "NA-LNO2", "Nitroalkylation by Nitro Linoleic Acid.", false},
    {UNIMOD_NA_OA_NO2, "UNIMOD:686", "NA-OA-NO2", "Nitroalkylation by Nitro Oleic Acid.", false},
    {UNIMOD_ICPL_2H_4_, "UNIMOD:687", "ICPL:2H(4)", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, medium form.", false},
    {UNIMOD_Label_13C_6_15N_1_, "UNIMOD:695", "Label:13C(6)15N(1)", "13C(6) 15N(1) Silac label.", false},
    {UNIMOD_Label_2H_9_13C_6_15N_2_, "UNIMOD:696", "Label:2H(9)13C(6)15N(2)", "13C(6) 15N(2) (D)9 SILAC label.", false},
    {UNIMOD_NIC, "UNIMOD:697", "NIC", "Nicotinic Acid.", false},
    {UNIMOD_dNIC, "UNIMOD:698", "dNIC", "Deuterated Nicotinic Acid.", false},
    {UNIMOD_HNE_Delta_H_2_O, "UNIMOD:720", "HNE-Delta:H(2)O", "Dehydrated 4-hydroxynonenal.", false},
    {UNIMOD_4_ONE, "UNIMOD:721", "4-ONE", "4-Oxononenal (ONE).", false},
    {UNIMOD_O_Dimethylphosphate, "UNIMOD:723", "O-Dimethylphosphate", "O-Dimethylphosphorylation.", false},
    {UNIMOD_O_Methylphosphate, "UNIMOD:724", "O-Methylphosphate", "O-Methylphosphorylation.", false},
    {UNIMOD_Diethylphosphate, "UNIMOD:725", "Diethylphosphate", "O-Diethylphosphorylation.", false},
    {UNIMOD_Ethylphosphate, "UNIMOD:726", "Ethylphosphate", "O-Ethylphosphorylation.", false},
    {UNIMOD_O_pinacolylmethylphosphonate, "UNIMOD:727", "O-pinacolylmethylphosphonate", "O-pinacolylmethylphosphonylation.", false},
    {UNIMOD_Methylphosphonate, "UNIMOD:728", "Methylphosphonate", "Methylphosphonylation.", false},
    {UNIMOD_O_Isopropylmethylphosphonate, "UNIMOD:729", "O-Isopropylmethylphosphonate", "O-Isopropylmethylphosphonylation.", false},
    {UNIMOD_iTRAQ8plex, "UNIMOD:730", "iTRAQ8plex", "Representative mass and accurate mass for 113, 114, 116 & 117.", false},
    {UNIMOD_iTRAQ8plex_13C_6_15N_2_, "UNIMOD:731", "iTRAQ8plex:13C(6)15N(2)", "Accurate mass for 115, 118, 119 & 121.", false},
    {UNIMOD_Ethanolamine, "UNIMOD:734", "Ethanolamine", "Carboxyl modification with ethanolamine.", false},
    {UNIMOD_BEMAD_ST, "UNIMOD:735", "BEMAD_ST", "Beta elimination of modified S or T followed by Michael addition of DTT.", false},
    {UNIMOD_BEMAD_C, "UNIMOD:736", "BEMAD_C", "Beta elimination of alkylated Cys followed by Michael addition of DTT.", false},
    {UNIMOD_TMT6plex, "UNIMOD:737", "TMT6plex", "Sixplex Tandem Mass Tag®.", false},
    {UNIMOD_TMT2plex, "UNIMOD:738", "TMT2plex", "Duplex Tandem Mass Tag®.", false},
    {UNIMOD_TMT, "UNIMOD:739", "TMT", "Native Tandem Mass Tag®.", false},
    {UNIMOD_ExacTagThiol, "UNIMOD:740", "ExacTagThiol", "ExacTag Thiol label mass for 2-4-7-10 plex.", false},
    {UNIMOD_ExacTagAmine, "UNIMOD:741", "ExacTagAmine", "ExacTag Amine label mass for 2-4-7-10 plex.", false},
    {UNIMOD_4_ONE_Delta_H__2_O__1_, "UNIMOD:743", "4-ONE+Delta:H(-2)O(-1)", "Dehydrated 4-Oxononenal Michael adduct.", false},
    {UNIMOD_NO_SMX_SEMD, "UNIMOD:744", "NO_SMX_SEMD", "Nitroso Sulfamethoxazole Sulphenamide thiol adduct.", false},
    {UNIMOD_NO_SMX_SIMD, "UNIMOD:746", "NO_SMX_SIMD", "Nitroso Sulfamethoxazole Sulfinamide thiol adduct.", false},
    {UNIMOD_Malonyl, "UNIMOD:747", "Malonyl", "Malonylation.", false},
    {UNIMOD_3sulfo, "UNIMOD:748", "3sulfo", "Derivatization by N-term modification using 3-Sulfobenzoic succinimidyl ester.", false},
    {UNIMOD_trifluoro, "UNIMOD:750", "trifluoro", "Trifluoroleucine replacement of leucine.", false},
    {UNIMOD_TNBS, "UNIMOD:751", "TNBS", "Tri nitro benzene.", false},
    {UNIMOD_IDEnT, "UNIMOD:762", "IDEnT", "Isotope Distribution Encoded Tag.", false},
    {UNIMOD_BEMAD_ST_2H_6_, "UNIMOD:763", "BEMAD_ST:2H(6)", "Beta elimination of modified S or T followed by Michael addition of labelled DTT.", false},
    {UNIMOD_BEMAD_C_2H_6_, "UNIMOD:764", "BEMAD_C:2H(6)", "Beta elimination of alkylated Cys followed by Michael addition of labelled DTT.", false},
    {UNIMOD_Met_loss, "UNIMOD:765", "Met-loss", "Removal of initiator methionine from protein N-terminus.", false},
    {UNIMOD_Met_loss_Acetyl, "UNIMOD:766", "Met-loss+Acetyl", "Removal of initiator methionine from protein N-terminus, then acetylation of the new N-terminus.", false},
    {UNIMOD_Menadione_HQ, "UNIMOD:767", "Menadione-HQ", "Menadione hydroquinone derivative.", false},
    {UNIMOD_Methyl_Acetyl_2H_3_, "UNIMOD:768", "Methyl+Acetyl:2H(3)", "Mono-methylated lysine labelled with Acetyl_heavy.", false},
    {UNIMOD_lapachenole, "UNIMOD:771", "lapachenole", "Lapachenole photochemically added to cysteine.", false},
    {UNIMOD_Label_13C_5_, "UNIMOD:772", "Label:13C(5)", "13C(5) Silac label.", false},
    {UNIMOD_maleimide, "UNIMOD:773", "maleimide", "Maleimide.", false},
    {UNIMOD_Biotin_phenacyl, "UNIMOD:774", "Biotin-phenacyl", "Alkylation by biotinylated form of phenacyl bromide.", false},
    {UNIMOD_Carboxymethyl_13C_2_, "UNIMOD:775", "Carboxymethyl:13C(2)", "Iodoacetic acid derivative w/ 13C label.", false},
    {UNIMOD_NEM_2H_5_, "UNIMOD:776", "NEM:2H(5)", "D5 N-ethylmaleimide on cysteines.", false},
    {UNIMOD_AEC_MAEC_2H_4_, "UNIMOD:792", "AEC-MAEC:2H(4)", "Deuterium cysteamine modification to S or T.", false},
    {UNIMOD_Hex_1_HexNAc_1_, "UNIMOD:793", "Hex(1)HexNAc(1)", "Hex1HexNAc1.", false},
    {UNIMOD_Label_13C_6__GG, "UNIMOD:799", "Label:13C(6)+GG", "13C6 labeled ubiquitinylation residue.", false},
    {UNIMOD_Biotin_Thermo_21345, "UNIMOD:800", "Biotin:Thermo-21345", "Was PentylamineBiotin.", false},
    {UNIMOD_Pentylamine, "UNIMOD:801", "Pentylamine", "Labeling transglutaminase substrate on glutamine side chain.", false},
    {UNIMOD_Biotin_Thermo_21360, "UNIMOD:811", "Biotin:Thermo-21360", "Was Biotin-PEO4-hydrazide.", false},
    {UNIMOD_Cy3b_maleimide, "UNIMOD:821", "Cy3b-maleimide", "Fluorescent dye that labels cysteines.", false},
    {UNIMOD_Gly_loss_Amide, "UNIMOD:822", "Gly-loss+Amide", "Enzymatic glycine removal leaving an amidated C-terminus.", false},
    {UNIMOD_Xlink_BMOE, "UNIMOD:824", "Xlink:BMOE", "Intact or monolink BMOE crosslinker.", false},
    {UNIMOD_Xlink_DFDNB, "UNIMOD:825", "Xlink:DFDNB", "Intact DFDNB crosslinker.", false},
    {UNIMOD_TMPP_Ac, "UNIMOD:827", "TMPP-Ac", "Tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative.", false},
    {UNIMOD_Dihydroxyimidazolidine, "UNIMOD:830", "Dihydroxyimidazolidine", "Dihydroxy methylglyoxal adduct.", false},
    {UNIMOD_Label_2H_4__Acetyl, "UNIMOD:834", "Label:2H(4)+Acetyl", "Acetyl 4,4,5,5-D4 Lysine.", false},
    {UNIMOD_Label_13C_6__Acetyl, "UNIMOD:835", "Label:13C(6)+Acetyl", "Acetyl 13C(6) Silac label.", false},
    {UNIMOD_Label_13C_6_15N_2__Acetyl, "UNIMOD:836", "Label:13C(6)15N(2)+Acetyl", "Acetyl_13C(6) 15N(2) Silac label.", false},
    {UNIMOD_Arg__Npo, "UNIMOD:837", "Arg->Npo", "Arginine replacement by Nitropyrimidyl ornithine.", false},
    {UNIMOD_EQIGG, "UNIMOD:846", "EQIGG", "Sumo mutant Smt3-WT tail following trypsin digestion.", false},
    {UNIMOD_Arg2PG, "UNIMOD:848", "Arg2PG", "Adduct of phenylglyoxal with Arg.", false},
    {UNIMOD_cGMP, "UNIMOD:849", "cGMP", "S-guanylation.", false},
    {UNIMOD_cGMP_RMP_loss, "UNIMOD:851", "cGMP+RMP-loss", "S-guanylation-2.", false},
    {UNIMOD_Label_2H_4__GG, "UNIMOD:853", "Label:2H(4)+GG", "Ubiquitination 2H4 lysine.", false},
    {UNIMOD_MG_H1, "UNIMOD:859", "MG-H1", "Methylglyoxal-derived hydroimidazolone.", false},
    {UNIMOD_G_H1, "UNIMOD:860", "G-H1", "Glyoxal-derived hydroimiadazolone.", false},
    {UNIMOD_ZGB, "UNIMOD:861", "ZGB", "NHS ester linked Green Fluorescent Bodipy Dye.", false},
    {UNIMOD_Label_13C_1_2H_3_, "UNIMOD:862", "Label:13C(1)2H(3)", "SILAC.", false},
    {UNIMOD_Label_13C_6_15N_2__GG, "UNIMOD:864", "Label:13C(6)15N(2)+GG", "13C(6) 15N(2) Lysine glygly.", false},
    {UNIMOD_ICPL_13C_6_2H_4_, "UNIMOD:866", "ICPL:13C(6)2H(4)", "Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, +10 Da form.", false},
    {UNIMOD_QEQTGG, "UNIMOD:876", "QEQTGG", "SUMOylation by SUMO-1.", false},
    {UNIMOD_QQQTGG, "UNIMOD:877", "QQQTGG", "SUMOylation by SUMO-2/3.", false},
    {UNIMOD_Biotin_Thermo_21325, "UNIMOD:884", "Biotin:Thermo-21325", "Was ChromoBiotin.", false},
    {UNIMOD_Label_13C_1_2H_3__Oxidation, "UNIMOD:885", "Label:13C(1)2H(3)+Oxidation", "Oxidised methionine 13C(1)2H(3) SILAC label.", false},
    {UNIMOD_HydroxymethylOP, "UNIMOD:886", "HydroxymethylOP", "2-ammonio-6-[4-(hydroxymethyl)-3-oxidopyridinium-1-yl]- hexanoate.", false},
    {UNIMOD_MDCC, "UNIMOD:887", "MDCC", "Covalent linkage of maleimidyl coumarin probe (Molecular Probes D-10253).", false},
    {UNIMOD_mTRAQ, "UNIMOD:888", "mTRAQ", "MTRAQ light.", false},
    {UNIMOD_mTRAQ_13C_3_15N_1_, "UNIMOD:889", "mTRAQ:13C(3)15N(1)", "MTRAQ medium.", false},
    {UNIMOD_DyLight_maleimide, "UNIMOD:890", "DyLight-maleimide", "Thiol-reactive dye for fluorescence labelling of proteins.", false},
    {UNIMOD_Methyl_PEO12_Maleimide, "UNIMOD:891", "Methyl-PEO12-Maleimide", "Methyl-PEO12-Maleimide.", false},
    {UNIMOD_CarbamidomethylDTT, "UNIMOD:893", "CarbamidomethylDTT", "Carbamidomethylated DTT modification of cysteine.", false},
    {UNIMOD_CarboxymethylDTT, "UNIMOD:894", "CarboxymethylDTT", "Carboxymethylated DTT modification of cysteine.", false},
    {UNIMOD_Biotin_PEG_PRA, "UNIMOD:895", "Biotin-PEG-PRA", "Biotin polyethyleneoxide (n=3) alkyne.", false},
    {UNIMOD_Met__Aha, "UNIMOD:896", "Met->Aha", "Methionine replacement by azido homoalanine.", false},
    {UNIMOD_Label_15N_4_, "UNIMOD:897", "Label:15N(4)", "SILAC 15N(4).", false},
    {UNIMOD_pyrophospho, "UNIMOD:898", "pyrophospho", "Pyrophosphorylation of Ser/Thr.", false},
    {UNIMOD_Met__Hpg, "UNIMOD:899", "Met->Hpg", "Methionine replacement by homopropargylglycine.", false},
    {UNIMOD_4AcAllylGal, "UNIMOD:901", "4AcAllylGal", "2,3,4,6-tetra-O-Acetyl-1-allyl-alpha-D-galactopyranoside modification of cysteine.", false},
    {UNIMOD_DimethylArsino, "UNIMOD:902", "DimethylArsino", "Reaction with dimethylarsinous (AsIII) acid.", false},
    {UNIMOD_Lys__CamCys, "UNIMOD:903", "Lys->CamCys", "Lys->Cys substitution and carbamidomethylation.", false},
    {UNIMOD_Phe__CamCys, "UNIMOD:904", "Phe->CamCys", "Phe->Cys substitution and carbamidomethylation.", false},
    {UNIMOD_Leu__MetOx, "UNIMOD:905", "Leu->MetOx", "Leu->Met substitution and sulfoxidation.", false},
    {UNIMOD_Lys__MetOx, "UNIMOD:906", "Lys->MetOx", "Lys->Met substitution and sulfoxidation.", false},
    {UNIMOD_Galactosyl, "UNIMOD:907", "Galactosyl", "Gluconoylation.", false},
    {UNIMOD_Xlink_SMCC_321_, "UNIMOD:908", "Xlink:SMCC[321]", "Monolink of SMCC terminated with 3-(dimethylamino)-1-propylamine.", false},
    {UNIMOD_Bacillosamine, "UNIMOD:910", "Bacillosamine", "2,4-diacetamido-2,4,6-trideoxyglucopyranose.", false},
    {UNIMOD_MTSL, "UNIMOD:911", "MTSL", "Cys modification by (1-oxyl-2,2,5,5-tetramethyl-3-pyrroline-3-methyl)methanesulfonate (MTSL).", false},
    {UNIMOD_HNE_BAHAH, "UNIMOD:912", "HNE-BAHAH", "4-hydroxy-2-nonenal and biotinamidohexanoic acid hydrazide, reduced.", false},
    {UNIMOD_Methylmalonylation, "UNIMOD:914", "Methylmalonylation", "Methylmalonylation on Serine.", false},
    {UNIMOD_Label_13C_4_15N_2__GG, "UNIMOD:923", "Label:13C(4)15N(2)+GG", "13C(4) 15N(2) Lysine glygly.", false},
    {UNIMOD_ethylamino, "UNIMOD:926", "ethylamino", "Ethyl amino.", false},
    {UNIMOD_MercaptoEthanol, "UNIMOD:928", "MercaptoEthanol", "2-OH-ethyl thio-Ser.", false},
    {UNIMOD_Ethyl_Deamidated, "UNIMOD:931", "Ethyl+Deamidated", "Deamidation followed by esterification with ethanol.", false},
    {UNIMOD_VFQQQTGG, "UNIMOD:932", "VFQQQTGG", "SUMOylation by SUMO-2/3 (formic acid cleavage).", false},
    {UNIMOD_VIEVYQEQTGG, "UNIMOD:933", "VIEVYQEQTGG", "SUMOylation by SUMO-1 (formic acid cleavage).", false},
    {UNIMOD_AMTzHexNAc2, "UNIMOD:934", "AMTzHexNAc2", "Photocleavable Biotin + GalNAz on O-GlcNAc.", false},
    {UNIMOD_Atto495Maleimide, "UNIMOD:935", "Atto495Maleimide", "High molecular absorption maleimide label for proteins.", false},
    {UNIMOD_Chlorination, "UNIMOD:936", "Chlorination", "Chlorination of tyrosine residues.", false},
    {UNIMOD_dichlorination, "UNIMOD:937", "dichlorination", "Dichlorination.", false},
    {UNIMOD_AROD, "UNIMOD:938", "AROD", "Cysteine modifier.", false},
    {UNIMOD_Cys__methylaminoAla, "UNIMOD:939", "Cys->methylaminoAla", "Carbamidomethylated Cys that undergoes beta-elimination and Michael addition of methylamine.", false},
    {UNIMOD_Cys__ethylaminoAla, "UNIMOD:940", "Cys->ethylaminoAla", "Carbamidomethylated Cys that undergoes beta-elimination and Michael addition of ethylamine.", false},
    {UNIMOD_DNPS, "UNIMOD:941", "DNPS", "2,4-Dinitrobenzenesulfenyl.", false},
    {UNIMOD_SulfoGMBS, "UNIMOD:942", "SulfoGMBS", "High molecular absorption label for proteins.", false},
    {UNIMOD_DimethylamineGMBS, "UNIMOD:943", "DimethylamineGMBS", "Modified GMBS X linker.", false},
    {UNIMOD_Label_15N_2_2H_9_, "UNIMOD:944", "Label:15N(2)2H(9)", "SILAC label.", false},
    {UNIMOD_LG_anhydrolactam, "UNIMOD:946", "LG-anhydrolactam", "Levuglandinyl-lysine anhydrolactam adduct.", false},
    {UNIMOD_LG_pyrrole, "UNIMOD:947", "LG-pyrrole", "Levuglandinyl-lysine pyrrole adduct.", false},
    {UNIMOD_LG_anhyropyrrole, "UNIMOD:948", "LG-anhyropyrrole", "Levuglandinyl-lysine anhyropyrrole adduct.", false},
    {UNIMOD_3_deoxyglucosone, "UNIMOD:949", "3-deoxyglucosone", "Condensation product of 3-deoxyglucosone.", false},
    {UNIMOD_Cation_Li, "UNIMOD:950", "Cation:Li", "Replacement of proton by lithium.", false},
    {UNIMOD_Cation_Ca_II_, "UNIMOD:951", "Cation:Ca[II]", "Replacement of 2 protons by calcium.", false},
    {UNIMOD_Cation_Fe_II_, "UNIMOD:952", "Cation:Fe[II]", "Replacement of 2 protons by iron.", false},
    {UNIMOD_Cation_Ni_II_, "UNIMOD:953", "Cation:Ni[II]", "Replacement of 2 protons by nickel.", false},
    {UNIMOD_Cation_Zn_II_, "UNIMOD:954", "Cation:Zn[II]", "Replacement of 2 protons by zinc.", false},
    {UNIMOD_Cation_Ag, "UNIMOD:955", "Cation:Ag", "Replacement of proton by silver.", false},
    {UNIMOD_Cation_Mg_II_, "UNIMOD:956", "Cation:Mg[II]", "Replacement of 2 protons by magnesium.", false},
    {UNIMOD_2_succinyl, "UNIMOD:957", "2-succinyl", "S-(2-succinyl) cysteine.", false},
    {UNIMOD_Propargylamine, "UNIMOD:958", "Propargylamine", "Propargylamine.", false},
    {UNIMOD_Phosphopropargyl, "UNIMOD:959", "Phosphopropargyl", "Phospho-propargylamine.", false},
    {UNIMOD_SUMO2135, "UNIMOD:960", "SUMO2135", "SUMOylation by SUMO-1 after tryptic cleavage.", false},
    {UNIMOD_SUMO3549, "UNIMOD:961", "SUMO3549", "SUMOylation by SUMO-2/3 after tryptic cleavage.", false},
    {UNIMOD_thioacylPA, "UNIMOD:967", "thioacylPA", "Membrane protein extraction.", false},
    {UNIMOD_maleimide3, "UNIMOD:971", "maleimide3", "Maleimide-3-saccharide.", false},
    {UNIMOD_maleimide5, "UNIMOD:972", "maleimide5", "Maleimide-5-saccharide.", false},
    {UNIMOD_Puromycin, "UNIMOD:973", "Puromycin", "Puromycin.", false},
    {UNIMOD_Carbofuran, "UNIMOD:977", "Carbofuran", "2,3-dihydro-2,2-dimethyl-7-benzofuranol N-methyl carbamate.", false},
    {UNIMOD_BITC, "UNIMOD:978", "BITC", "Benzyl isothiocyanate.", false},
    {UNIMOD_PEITC, "UNIMOD:979", "PEITC", "Phenethyl isothiocyanate.", false},
    {UNIMOD_glucosone, "UNIMOD:981", "glucosone", "Condensation product of glucosone.", false},
    {UNIMOD_cysTMT, "UNIMOD:984", "cysTMT", "Native cysteine-reactive Tandem Mass Tag®.", false},
    {UNIMOD_cysTMT6plex, "UNIMOD:985", "cysTMT6plex", "Cysteine-reactive Sixplex Tandem Mass Tag®.", false},
    {UNIMOD_Label_13C_6__Dimethyl, "UNIMOD:986", "Label:13C(6)+Dimethyl", "Dimethyl 13C(6) Silac label.", false},
    {UNIMOD_Label_13C_6_15N_2__Dimethyl, "UNIMOD:987", "Label:13C(6)15N(2)+Dimethyl", "Dimethyl 13C(6)15N(2) Silac label.", false},
    {UNIMOD_Ammonium, "UNIMOD:989", "Ammonium", "Replacement of proton with ammonium ion.", false},
    {UNIMOD_ISD_z_2_ion, "UNIMOD:991", "ISD_z+2_ion", "ISD (z+2)-series.", false},
    {UNIMOD_Biotin_Sigma_B1267, "UNIMOD:993", "Biotin:Sigma-B1267", "Was Biotin-maleimide.", false},
    {UNIMOD_Label_15N_1_, "UNIMOD:994", "Label:15N(1)", "15N(1).", false},
    {UNIMOD_Label_15N_2_, "UNIMOD:995", "Label:15N(2)", "15N(2).", false},
    {UNIMOD_Label_15N_3_, "UNIMOD:996", "Label:15N(3)", "15N(3).", false},
    {UNIMOD_sulfo_amino, "UNIMOD:997", "sulfo+amino", "Aminotyrosine with sulfation.", false},
    {UNIMOD_AHA_Alkyne, "UNIMOD:1000", "AHA-Alkyne", "Azidohomoalanine (AHA) bound to propargylglycine-NH2 (alkyne).", false},
    {UNIMOD_AHA_Alkyne_KDDDD, "UNIMOD:1001", "AHA-Alkyne-KDDDD", "Azidohomoalanine (AHA) bound to DDDDK-propargylglycine-NH2 (alkyne).", false},
    {UNIMOD_EGCG1, "UNIMOD:1002", "EGCG1", "(-)-epigallocatechin-3-gallate.", false},
    {UNIMOD_EGCG2, "UNIMOD:1003", "EGCG2", "(-)-dehydroepigallocatechin.", false},
    {UNIMOD_Label_13C_6_15N_4__Methyl, "UNIMOD:1004", "Label:13C(6)15N(4)+Methyl", "Monomethylated Arg13C(6) 15N(4).", false},
    {UNIMOD_Label_13C_6_15N_4__Dimethyl, "UNIMOD:1005", "Label:13C(6)15N(4)+Dimethyl", "Dimethylated Arg13C(6) 15N(4).", false},
    {UNIMOD_Label_13C_6_15N_4__Methyl_2H_3_13C_1_, "UNIMOD:1006", "Label:13C(6)15N(4)+Methyl:2H(3)13C(1)", "2H(3) 13C(1) monomethylated Arg13C(6) 15N(4).", false},
    {UNIMOD_Label_13C_6_15N_4__Dimethyl_2H_6_13C_2_, "UNIMOD:1007", "Label:13C(6)15N(4)+Dimethyl:2H(6)13C(2)", "2H(6) 13C(2) Dimethylated Arg13C(6) 15N(4).", false},
    {UNIMOD_Cys__CamSec, "UNIMOD:1008", "Cys->CamSec", "Sec Iodoacetamide derivative.", false},
    {UNIMOD_Thiazolidine, "UNIMOD:1009", "Thiazolidine", "Formaldehyde adduct.", false},
    {UNIMOD_DEDGFLYMVYASQETFG, "UNIMOD:1010", "DEDGFLYMVYASQETFG", "Addition of DEDGFLYMVYASQETFG.", false},
    {UNIMOD_Biotin_Invitrogen_M1602, "UNIMOD:1012", "Biotin:Invitrogen-M1602", "Nalpha-(3-maleimidylpropionyl)biocytin.", false},
    {UNIMOD_glycidamide, "UNIMOD:1014", "glycidamide", "Glycidamide adduct.", false},
    {UNIMOD_Ahx2_Hsl, "UNIMOD:1015", "Ahx2+Hsl", "C-terminal homoserine lactone and two aminohexanoic acids.", false},
    {UNIMOD_DMPO, "UNIMOD:1017", "DMPO", "DMPO spin-trap nitrone adduct.", false},
    {UNIMOD_ICDID, "UNIMOD:1018", "ICDID", "Isotope-Coded Dimedone light form.", false},
    {UNIMOD_ICDID_2H_6_, "UNIMOD:1019", "ICDID:2H(6)", "Isotope-Coded Dimedone heavy form.", false},
    {UNIMOD_Xlink_DSS_156_, "UNIMOD:1020", "Xlink:DSS[156]", "Water-quenched monolink of DSS/BS3 crosslinker.", false},
    {UNIMOD_Xlink_EGS_244_, "UNIMOD:1021", "Xlink:EGS[244]", "Water quenched monolink of EGS cross-linker.", false},
    {UNIMOD_Xlink_DST_132_, "UNIMOD:1022", "Xlink:DST[132]", "Water quenched monolink of DST crosslinker.", false},
    {UNIMOD_Xlink_DTSSP_192_, "UNIMOD:1023", "Xlink:DTSSP[192]", "Water quenched monolink of DSP/DTSSP crosslinker.", false},
    {UNIMOD_Xlink_SMCC_237_, "UNIMOD:1024", "Xlink:SMCC[237]", "Water quenched monolink of SMCC.", false},
    {UNIMOD_Xlink_DMP_140_, "UNIMOD:1027", "Xlink:DMP[140]", "Water quenched monolink of DMP crosslinker.", false},
    {UNIMOD_Xlink_EGS_115_, "UNIMOD:1028", "Xlink:EGS[115]", "Cleavage product of EGS protein crosslinks by hydroylamine treatment.", false},
    {UNIMOD_Biotin_Thermo_88310, "UNIMOD:1031", "Biotin:Thermo-88310", "Desthiobiotin modification of lysine.", false},
    {UNIMOD_2_nitrobenzyl, "UNIMOD:1032", "2-nitrobenzyl", "Tyrosine caged with 2-nitrobenzyl (ONB).", false},
    {UNIMOD_Cys__SecNEM, "UNIMOD:1033", "Cys->SecNEM", "N-ethylmaleimide on selenocysteines.", false},
    {UNIMOD_Cys__SecNEM_2H_5_, "UNIMOD:1034", "Cys->SecNEM:2H(5)", "D5 N-ethylmaleimide on selenocysteines.", false},
    {UNIMOD_Thiadiazole, "UNIMOD:1035", "Thiadiazole", "Thiadiazolydation of Cys.", false},
    {UNIMOD_Withaferin, "UNIMOD:1036", "Withaferin", "Modification of cystein by withaferin.", false},
    {UNIMOD_Biotin_Thermo_88317, "UNIMOD:1037", "Biotin:Thermo-88317", "Desthiobiotin fluorophosphonate.", false},
    {UNIMOD_TAMRA_FP, "UNIMOD:1038", "TAMRA-FP", "TAMRA fluorophosphonate modification of serine.", false},
    {UNIMOD_Biotin_Thermo_21901_H2O, "UNIMOD:1039", "Biotin:Thermo-21901+H2O", "Maleimide-Biotin + Water.", false},
    {UNIMOD_Deoxyhypusine, "UNIMOD:1041", "Deoxyhypusine", "Deoxyhypusine.", false},
    {UNIMOD_Acetyldeoxyhypusine, "UNIMOD:1042", "Acetyldeoxyhypusine", "Acetyldeoxyhypusine.", false},
    {UNIMOD_Acetylhypusine, "UNIMOD:1043", "Acetylhypusine", "Acetylhypusine.", false},
    {UNIMOD_Ala__Cys, "UNIMOD:1044", "Ala->Cys", "Ala->Cys substitution.", false},
    {UNIMOD_Ala__Phe, "UNIMOD:1045", "Ala->Phe", "Ala->Phe substitution.", false},
    {UNIMOD_Ala__His, "UNIMOD:1046", "Ala->His", "Ala->His substitution.", false},
    {UNIMOD_Ala__Xle, "UNIMOD:1047", "Ala->Xle", "Ala->Leu/Ile substitution.", false},
    {UNIMOD_Ala__Lys, "UNIMOD:1048", "Ala->Lys", "Ala->Lys substitution.", false},
    {UNIMOD_Ala__Met, "UNIMOD:1049", "Ala->Met", "Ala->Met substitution.", false},
    {UNIMOD_Ala__Asn, "UNIMOD:1050", "Ala->Asn", "Ala->Asn substitution.", false},
    {UNIMOD_Ala__Gln, "UNIMOD:1051", "Ala->Gln", "Ala->Gln substitution.", false},
    {UNIMOD_Ala__Arg, "UNIMOD:1052", "Ala->Arg", "Ala->Arg substitution.", false},
    {UNIMOD_Ala__Trp, "UNIMOD:1053", "Ala->Trp", "Ala->Trp substitution.", false},
    {UNIMOD_Ala__Tyr, "UNIMOD:1054", "Ala->Tyr", "Ala->Tyr substitution.", false},
    {UNIMOD_Cys__Ala, "UNIMOD:1055", "Cys->Ala", "Cys->Ala substitution.", false},
    {UNIMOD_Cys__Asp, "UNIMOD:1056", "Cys->Asp", "Cys->Asp substitution.", false},
    {UNIMOD_Cys__Glu, "UNIMOD:1057", "Cys->Glu", "Cys->Glu substitution.", false},
    {UNIMOD_Cys__His, "UNIMOD:1058", "Cys->His", "Cys->His substitution.", false},
    {UNIMOD_Cys__Xle, "UNIMOD:1059", "Cys->Xle", "Cys->Leu/Ile substitution.", false},
    {UNIMOD_Cys__Lys, "UNIMOD:1060", "Cys->Lys", "Cys->Lys substitution.", false},
    {UNIMOD_Cys__Met, "UNIMOD:1061", "Cys->Met", "Cys->Met substitution.", false},
    {UNIMOD_Cys__Asn, "UNIMOD:1062", "Cys->Asn", "Cys->Asn substitution.", false},
    {UNIMOD_Cys__Pro, "UNIMOD:1063", "Cys->Pro", "Cys->Pro substitution.", false},
    {UNIMOD_Cys__Gln, "UNIMOD:1064", "Cys->Gln", "Cys->Gln substitution.", false},
    {UNIMOD_Cys__Thr, "UNIMOD:1065", "Cys->Thr", "Cys->Thr substitution.", false},
    {UNIMOD_Cys__Val, "UNIMOD:1066", "Cys->Val", "Cys->Val substitution.", false},
    {UNIMOD_Asp__Cys, "UNIMOD:1067", "Asp->Cys", "Asp->Cys substitution.", false},
    {UNIMOD_Asp__Phe, "UNIMOD:1068", "Asp->Phe", "Asp->Phe substitution.", false},
    {UNIMOD_Asp__Xle, "UNIMOD:1069", "Asp->Xle", "Asp->Leu/Ile substitution.", false},
    {UNIMOD_Asp__Lys, "UNIMOD:1070", "Asp->Lys", "Asp->Lys substitution.", false},
    {UNIMOD_Asp__Met, "UNIMOD:1071", "Asp->Met", "Asp->Met substitution.", false},
    {UNIMOD_Asp__Pro, "UNIMOD:1072", "Asp->Pro", "Asp->Pro substitution.", false},
    {UNIMOD_Asp__Gln, "UNIMOD:1073", "Asp->Gln", "Asp->Gln substitution.", false},
    {UNIMOD_Asp__Arg, "UNIMOD:1074", "Asp->Arg", "Asp->Arg substitution.", false},
    {UNIMOD_Asp__Ser, "UNIMOD:1075", "Asp->Ser", "Asp->Ser substitution.", false},
    {UNIMOD_Asp__Thr, "UNIMOD:1076", "Asp->Thr", "Asp->Thr substitution.", false},
    {UNIMOD_Asp__Trp, "UNIMOD:1077", "Asp->Trp", "Asp->Trp substitution.", false},
    {UNIMOD_Glu__Cys, "UNIMOD:1078", "Glu->Cys", "Glu->Cys substitution.", false},
    {UNIMOD_Glu__Phe, "UNIMOD:1079", "Glu->Phe", "Glu->Phe substitution.", false},
    {UNIMOD_Glu__His, "UNIMOD:1080", "Glu->His", "Glu->His substitution.", false},
    {UNIMOD_Glu__Xle, "UNIMOD:1081", "Glu->Xle", "Glu->Leu/Ile substitution.", false},
    {UNIMOD_Glu__Met, "UNIMOD:1082", "Glu->Met", "Glu->Met substitution.", false},
    {UNIMOD_Glu__Asn, "UNIMOD:1083", "Glu->Asn", "Glu->Asn substitution.", false},
    {UNIMOD_Glu__Pro, "UNIMOD:1084", "Glu->Pro", "Glu->Pro substitution.", false},
    {UNIMOD_Glu__Arg, "UNIMOD:1085", "Glu->Arg", "Glu->Arg substitution.", false},
    {UNIMOD_Glu__Ser, "UNIMOD:1086", "Glu->Ser", "Glu->Ser substitution.", false},
    {UNIMOD_Glu__Thr, "UNIMOD:1087", "Glu->Thr", "Glu->Thr substitution.", false},
    {UNIMOD_Glu__Trp, "UNIMOD:1088", "Glu->Trp", "Glu->Trp substitution.", false},
    {UNIMOD_Glu__Tyr, "UNIMOD:1089", "Glu->Tyr", "Glu->Tyr substitution.", false},
    {UNIMOD_Phe__Ala, "UNIMOD:1090", "Phe->Ala", "Phe->Ala substitution.", false},
    {UNIMOD_Phe__Asp, "UNIMOD:1091", "Phe->Asp", "Phe->Asp substitution.", false},
    {UNIMOD_Phe__Glu, "UNIMOD:1092", "Phe->Glu", "Phe->Glu substitution.", false},
    {UNIMOD_Phe__Gly, "UNIMOD:1093", "Phe->Gly", "Phe->Gly substitution.", false},
    {UNIMOD_Phe__His, "UNIMOD:1094", "Phe->His", "Phe->His substitution.", false},
    {UNIMOD_Phe__Lys, "UNIMOD:1095", "Phe->Lys", "Phe->Lys substitution.", false},
    {UNIMOD_Phe__Met, "UNIMOD:1096", "Phe->Met", "Phe->Met substitution.", false},
    {UNIMOD_Phe__Asn, "UNIMOD:1097", "Phe->Asn", "Phe->Asn substitution.", false},
    {UNIMOD_Phe__Pro, "UNIMOD:1098", "Phe->Pro", "Phe->Pro substitution.", false},
    {UNIMOD_Phe__Gln, "UNIMOD:1099", "Phe->Gln", "Phe->Gln substitution.", false},
    {UNIMOD_Phe__Arg, "UNIMOD:1100", "Phe->Arg", "Phe->Arg substitution.", false},
    {UNIMOD_Phe__Thr, "UNIMOD:1101", "Phe->Thr", "Phe->Thr substitution.", false},
    {UNIMOD_Phe__Trp, "UNIMOD:1102", "Phe->Trp", "Phe->Trp substitution.", false},
    {UNIMOD_Gly__Phe, "UNIMOD:1103", "Gly->Phe", "Gly->Phe substitution.", false},
    {UNIMOD_Gly__His, "UNIMOD:1104", "Gly->His", "Gly->His substitution.", false},
    {UNIMOD_Gly__Xle, "UNIMOD:1105", "Gly->Xle", "Gly->Leu/Ile substitution.", false},
    {UNIMOD_Gly__Lys, "UNIMOD:1106", "Gly->Lys", "Gly->Lys substitution.", false},
    {UNIMOD_Gly__Met, "UNIMOD:1107", "Gly->Met", "Gly->Met substitution.", false},
    {UNIMOD_Gly__Asn, "UNIMOD:1108", "Gly->Asn", "Gly->Asn substitution.", false},
    {UNIMOD_Gly__Pro, "UNIMOD:1109", "Gly->Pro", "Gly->Pro substitution.", false},
    {UNIMOD_Gly__Gln, "UNIMOD:1110", "Gly->Gln", "Gly->Gln substitution.", false},
    {UNIMOD_Gly__Thr, "UNIMOD:1111", "Gly->Thr", "Gly->Thr substitution.", false},
    {UNIMOD_Gly__Tyr, "UNIMOD:1112", "Gly->Tyr", "Gly->Tyr substitution.", false},
    {UNIMOD_His__Ala, "UNIMOD:1113", "His->Ala", "His->Ala substitution.", false},
    {UNIMOD_His__Cys, "UNIMOD:1114", "His->Cys", "His->Cys substitution.", false},
    {UNIMOD_His__Glu, "UNIMOD:1115", "His->Glu", "His->Glu substitution.", false},
    {UNIMOD_His__Phe, "UNIMOD:1116", "His->Phe", "His->Phe substitution.", false},
    {UNIMOD_His__Gly, "UNIMOD:1117", "His->Gly", "His->Gly substitution.", false},
    {UNIMOD_His__Lys, "UNIMOD:1119", "His->Lys", "His->Lys substitution.", false},
    {UNIMOD_His__Met, "UNIMOD:1120", "His->Met", "His->Met substitution.", false},
    {UNIMOD_His__Ser, "UNIMOD:1121", "His->Ser", "His->Ser substitution.", false},
    {UNIMOD_His__Thr, "UNIMOD:1122", "His->Thr", "His->Thr substitution.", false},
    {UNIMOD_His__Val, "UNIMOD:1123", "His->Val", "His->Val substitution.", false},
    {UNIMOD_His__Trp, "UNIMOD:1124", "His->Trp", "His->Trp substitution.", false},
    {UNIMOD_Xle__Ala, "UNIMOD:1125", "Xle->Ala", "Leu/Ile->Ala substitution.", false},
    {UNIMOD_Xle__Cys, "UNIMOD:1126", "Xle->Cys", "Leu/Ile->Cys substitution.", false},
    {UNIMOD_Xle__Asp, "UNIMOD:1127", "Xle->Asp", "Leu/Ile->Asp substitution.", false},
    {UNIMOD_Xle__Glu, "UNIMOD:1128", "Xle->Glu", "Leu/Ile->Glu substitution.", false},
    {UNIMOD_Xle__Gly, "UNIMOD:1129", "Xle->Gly", "Leu/Ile->Gly substitution.", false},
    {UNIMOD_Xle__Tyr, "UNIMOD:1130", "Xle->Tyr", "Leu/Ile->Tyr substitution.", false},
    {UNIMOD_Lys__Ala, "UNIMOD:1131", "Lys->Ala", "Lys->Ala substitution.", false},
    {UNIMOD_Lys__Cys, "UNIMOD:1132", "Lys->Cys", "Lys->Cys substitution.", false},
    {UNIMOD_Lys__Asp, "UNIMOD:1133", "Lys->Asp", "Lys->Asp substitution.", false},
    {UNIMOD_Lys__Phe, "UNIMOD:1134", "Lys->Phe", "Lys->Phe substitution.", false},
    {UNIMOD_Lys__Gly, "UNIMOD:1135", "Lys->Gly", "Lys->Gly substitution.", false},
    {UNIMOD_Lys__His, "UNIMOD:1136", "Lys->His", "Lys->His substitution.", false},
    {UNIMOD_Lys__Pro, "UNIMOD:1137", "Lys->Pro", "Lys->Pro substitution.", false},
    {UNIMOD_Lys__Ser, "UNIMOD:1138", "Lys->Ser", "Lys->Ser substitution.", false},
    {UNIMOD_Lys__Val, "UNIMOD:1139", "Lys->Val", "Lys->Val substitution.", false},
    {UNIMOD_Lys__Trp, "UNIMOD:1140", "Lys->Trp", "Lys->Trp substitution.", false},
    {UNIMOD_Lys__Tyr, "UNIMOD:1141", "Lys->Tyr", "Lys->Tyr substitution.", false},
    {UNIMOD_Met__Ala, "UNIMOD:1142", "Met->Ala", "Met->Ala substitution.", false},
    {UNIMOD_Met__Cys, "UNIMOD:1143", "Met->Cys", "Met->Cys substitution.", false},
    {UNIMOD_Met__Asp, "UNIMOD:1144", "Met->Asp", "Met->Asp substitution.", false},
    {UNIMOD_Met__Glu, "UNIMOD:1145", "Met->Glu", "Met->Glu substitution.", false},
    {UNIMOD_Met__Phe, "UNIMOD:1146", "Met->Phe", "Met->Phe substitution.", false},
    {UNIMOD_Met__Gly, "UNIMOD:1147", "Met->Gly", "Met->Gly substitution.", false},
    {UNIMOD_Met__His, "UNIMOD:1148", "Met->His", "Met->His substitution.", false},
    {UNIMOD_Met__Asn, "UNIMOD:1149", "Met->Asn", "Met->Asn substitution.", false},
    {UNIMOD_Met__Pro, "UNIMOD:1150", "Met->Pro", "Met->Pro substitution.", false},
    {UNIMOD_Met__Gln, "UNIMOD:1151", "Met->Gln", "Met->Gln substitution.", false},
    {UNIMOD_Met__Ser, "UNIMOD:1152", "Met->Ser", "Met->Ser substitution.", false},
    {UNIMOD_Met__Trp, "UNIMOD:1153", "Met->Trp", "Met->Trp substitution.", false},
    {UNIMOD_Met__Tyr, "UNIMOD:1154", "Met->Tyr", "Met->Tyr substitution.", false},
    {UNIMOD_Asn__Ala, "UNIMOD:1155", "Asn->Ala", "Asn->Ala substitution.", false},
    {UNIMOD_Asn__Cys, "UNIMOD:1156", "Asn->Cys", "Asn->Cys substitution.", false},
    {UNIMOD_Asn__Glu, "UNIMOD:1157", "Asn->Glu", "Asn->Glu substitution.", false},
    {UNIMOD_Asn__Phe, "UNIMOD:1158", "Asn->Phe", "Asn->Phe substitution.", false},
    {UNIMOD_Asn__Gly, "UNIMOD:1159", "Asn->Gly", "Asn->Gly substitution.", false},
    {UNIMOD_Asn__Met, "UNIMOD:1160", "Asn->Met", "Asn->Met substitution.", false},
    {UNIMOD_Asn__Pro, "UNIMOD:1161", "Asn->Pro", "Asn->Pro substitution.", false},
    {UNIMOD_Asn__Gln, "UNIMOD:1162", "Asn->Gln", "Asn->Gln substitution.", false},
    {UNIMOD_Asn__Arg, "UNIMOD:1163", "Asn->Arg", "Asn->Arg substitution.", false},
    {UNIMOD_Asn__Val, "UNIMOD:1164", "Asn->Val", "Asn->Val substitution.", false},
    {UNIMOD_Asn__Trp, "UNIMOD:1165", "Asn->Trp", "Asn->Trp substitution.", false},
    {UNIMOD_Pro__Cys, "UNIMOD:1166", "Pro->Cys", "Pro->Cys substitution.", false},
    {UNIMOD_Pro__Asp, "UNIMOD:1167", "Pro->Asp", "Pro->Asp substitution.", false},
    {UNIMOD_Pro__Glu, "UNIMOD:1168", "Pro->Glu", "Pro->Glu substitution.", false},
    {UNIMOD_Pro__Phe, "UNIMOD:1169", "Pro->Phe", "Pro->Phe substitution.", false},
    {UNIMOD_Pro__Gly, "UNIMOD:1170", "Pro->Gly", "Pro->Gly substitution.", false},
    {UNIMOD_Pro__Lys, "UNIMOD:1171", "Pro->Lys", "Pro->Lys substitution.", false},
    {UNIMOD_Pro__Met, "UNIMOD:1172", "Pro->Met", "Pro->Met substitution.", false},
    {UNIMOD_Pro__Asn, "UNIMOD:1173", "Pro->Asn", "Pro->Asn substitution.", false},
    {UNIMOD_Pro__Val, "UNIMOD:1174", "Pro->Val", "Pro->Val substitution.", false},
    {UNIMOD_Pro__Trp, "UNIMOD:1175", "Pro->Trp", "Pro->Trp substitution.", false},
    {UNIMOD_Pro__Tyr, "UNIMOD:1176", "Pro->Tyr", "Pro->Tyr substitution.", false},
    {UNIMOD_Gln__Ala, "UNIMOD:1177", "Gln->Ala", "Gln->Ala substitution.", false},
    {UNIMOD_Gln__Cys, "UNIMOD:1178", "Gln->Cys", "Gln->Cys substitution.", false},
    {UNIMOD_Gln__Asp, "UNIMOD:1179", "Gln->Asp", "Gln->Asp substitution.", false},
    {UNIMOD_Gln__Phe, "UNIMOD:1180", "Gln->Phe", "Gln->Phe substitution.", false},
    {UNIMOD_Gln__Gly, "UNIMOD:1181", "Gln->Gly", "Gln->Gly substitution.", false},
    {UNIMOD_Gln__Met, "UNIMOD:1182", "Gln->Met", "Gln->Met substitution.", false},
    {UNIMOD_Gln__Asn, "UNIMOD:1183", "Gln->Asn", "Gln->Asn substitution.", false},
    {UNIMOD_Gln__Ser, "UNIMOD:1184", "Gln->Ser", "Gln->Ser substitution.", false},
    {UNIMOD_Gln__Thr, "UNIMOD:1185", "Gln->Thr", "Gln->Thr substitution.", false},
    {UNIMOD_Gln__Val, "UNIMOD:1186", "Gln->Val", "Gln->Val substitution.", false},
    {UNIMOD_Gln__Trp, "UNIMOD:1187", "Gln->Trp", "Gln->Trp substitution.", false},
    {UNIMOD_Gln__Tyr, "UNIMOD:1188", "Gln->Tyr", "Gln->Tyr substitution.", false},
    {UNIMOD_Arg__Ala, "UNIMOD:1189", "Arg->Ala", "Arg->Ala substitution.", false},
    {UNIMOD_Arg__Asp, "UNIMOD:1190", "Arg->Asp", "Arg->Asp substitution.", false},
    {UNIMOD_Arg__Glu, "UNIMOD:1191", "Arg->Glu", "Arg->Glu substitution.", false},
    {UNIMOD_Arg__Asn, "UNIMOD:1192", "Arg->Asn", "Arg->Asn substitution.", false},
    {UNIMOD_Arg__Val, "UNIMOD:1193", "Arg->Val", "Arg->Val substitution.", false},
    {UNIMOD_Arg__Tyr, "UNIMOD:1194", "Arg->Tyr", "Arg->Tyr substitution.", false},
    {UNIMOD_Arg__Phe, "UNIMOD:1195", "Arg->Phe", "Arg->Phe substitution.", false},
    {UNIMOD_Ser__Asp, "UNIMOD:1196", "Ser->Asp", "Ser->Asp substitution.", false},
    {UNIMOD_Ser__Glu, "UNIMOD:1197", "Ser->Glu", "Ser->Glu substitution.", false},
    {UNIMOD_Ser__His, "UNIMOD:1198", "Ser->His", "Ser->His substitution.", false},
    {UNIMOD_Ser__Lys, "UNIMOD:1199", "Ser->Lys", "Ser->Lys substitution.", false},
    {UNIMOD_Ser__Met, "UNIMOD:1200", "Ser->Met", "Ser->Met substitution.", false},
    {UNIMOD_Ser__Gln, "UNIMOD:1201", "Ser->Gln", "Ser->Gln substitution.", false},
    {UNIMOD_Ser__Val, "UNIMOD:1202", "Ser->Val", "Ser->Val substitution.", false},
    {UNIMOD_Thr__Cys, "UNIMOD:1203", "Thr->Cys", "Thr->Cys substitution.", false},
    {UNIMOD_Thr__Asp, "UNIMOD:1204", "Thr->Asp", "Thr->Asp substitution.", false},
    {UNIMOD_Thr__Glu, "UNIMOD:1205", "Thr->Glu", "Thr->Glu substitution.", false},
    {UNIMOD_Thr__Phe, "UNIMOD:1206", "Thr->Phe", "Thr->Phe substitution.", false},
    {UNIMOD_Thr__Gly, "UNIMOD:1207", "Thr->Gly", "Thr->Gly substitution.", false},
    {UNIMOD_Thr__His, "UNIMOD:1208", "Thr->His", "Thr->His substitution.", false},
    {UNIMOD_Thr__Gln, "UNIMOD:1209", "Thr->Gln", "Thr->Gln substitution.", false},
    {UNIMOD_Thr__Val, "UNIMOD:1210", "Thr->Val", "Thr->Val substitution.", false},
    {UNIMOD_Thr__Trp, "UNIMOD:1211", "Thr->Trp", "Thr->Trp substitution.", false},
    {UNIMOD_Thr__Tyr, "UNIMOD:1212", "Thr->Tyr", "Thr->Tyr substitution.", false},
    {UNIMOD_Val__Cys, "UNIMOD:1213", "Val->Cys", "Val->Cys substitution.", false},
    {UNIMOD_Val__His, "UNIMOD:1214", "Val->His", "Val->His substitution.", false},
    {UNIMOD_Val__Lys, "UNIMOD:1215", "Val->Lys", "Val->Lys substitution.", false},
    {UNIMOD_Val__Asn, "UNIMOD:1216", "Val->Asn", "Val->Asn substitution.", false},
    {UNIMOD_Val__Pro, "UNIMOD:1217", "Val->Pro", "Val->Pro substitution.", false},
    {UNIMOD_Val__Gln, "UNIMOD:1218", "Val->Gln", "Val->Gln substitution.", false},
    {UNIMOD_Val__Arg, "UNIMOD:1219", "Val->Arg", "Val->Arg substitution.", false},
    {UNIMOD_Val__Ser, "UNIMOD:1220", "Val->Ser", "Val->Ser substitution.", false},
    {UNIMOD_Val__Thr, "UNIMOD:1221", "Val->Thr", "Val->Thr substitution.", false},
    {UNIMOD_Val__Trp, "UNIMOD:1222", "Val->Trp", "Val->Trp substitution.", false},
    {UNIMOD_Val__Tyr, "UNIMOD:1223", "Val->Tyr", "Val->Tyr substitution.", false},
    {UNIMOD_Trp__Ala, "UNIMOD:1224", "Trp->Ala", "Trp->Ala substitution.", false},
    {UNIMOD_Trp__Asp, "UNIMOD:1225", "Trp->Asp", "Trp->Asp substitution.", false},
    {UNIMOD_Trp__Glu, "UNIMOD:1226", "Trp->Glu", "Trp->Glu substitution.", false},
    {UNIMOD_Trp__Phe, "UNIMOD:1227", "Trp->Phe", "Trp->Phe substitution.", false},
    {UNIMOD_Trp__His, "UNIMOD:1228", "Trp->His", "Trp->His substitution.", false},
    {UNIMOD_Trp__Lys, "UNIMOD:1229", "Trp->Lys", "Trp->Lys substitution.", false},
    {UNIMOD_Trp__Met, "UNIMOD:1230", "Trp->Met", "Trp->Met substitution.", false},
    {UNIMOD_Trp__Asn, "UNIMOD:1231", "Trp->Asn", "Trp->Asn substitution.", false},
    {UNIMOD_Trp__Pro, "UNIMOD:1232", "Trp->Pro", "Trp->Pro substitution.", false},
    {UNIMOD_Trp__Gln, "UNIMOD:1233", "Trp->Gln", "Trp->Gln substitution.", false},
    {UNIMOD_Trp__Thr, "UNIMOD:1234", "Trp->Thr", "Trp->Thr substitution.", false},
    {UNIMOD_Trp__Val, "UNIMOD:1235", "Trp->Val", "Trp->Val substitution.", false},
    {UNIMOD_Trp__Tyr, "UNIMOD:1236", "Trp->Tyr", "Trp->Tyr substitution.", false},
    {UNIMOD_Tyr__Ala, "UNIMOD:1237", "Tyr->Ala", "Tyr->Ala substitution.", false},
    {UNIMOD_Tyr__Glu, "UNIMOD:1238", "Tyr->Glu", "Tyr->Glu substitution.", false},
    {UNIMOD_Tyr__Gly, "UNIMOD:1239", "Tyr->Gly", "Tyr->Gly substitution.", false},
    {UNIMOD_Tyr__Lys, "UNIMOD:1240", "Tyr->Lys", "Tyr->Lys substitution.", false},
    {UNIMOD_Tyr__Met, "UNIMOD:1241", "Tyr->Met", "Tyr->Met substitution.", false},
    {UNIMOD_Tyr__Pro, "UNIMOD:1242", "Tyr->Pro", "Tyr->Pro substitution.", false},
    {UNIMOD_Tyr__Gln, "UNIMOD:1243", "Tyr->Gln", "Tyr->Gln substitution.", false},
    {UNIMOD_Tyr__Arg, "UNIMOD:1244", "Tyr->Arg", "Tyr->Arg substitution.", false},
    {UNIMOD_Tyr__Thr, "UNIMOD:1245", "Tyr->Thr", "Tyr->Thr substitution.", false},
    {UNIMOD_Tyr__Val, "UNIMOD:1246", "Tyr->Val", "Tyr->Val substitution.", false},
    {UNIMOD_Tyr__Trp, "UNIMOD:1247", "Tyr->Trp", "Tyr->Trp substitution.", false},
    {UNIMOD_Tyr__Xle, "UNIMOD:1248", "Tyr->Xle", "Tyr->Leu/Ile substitution.", false},
    {UNIMOD_AHA_SS, "UNIMOD:1249", "AHA-SS", "Azidohomoalanine coupled to reductively cleaved tag.", false},
    {UNIMOD_AHA_SS_CAM, "UNIMOD:1250", "AHA-SS_CAM", "Carbamidomethylated form of reductively cleaved tag coupled to azidohomoalanine.", false},
    {UNIMOD_Biotin_Thermo_33033, "UNIMOD:1251", "Biotin:Thermo-33033", "Sulfo-SBED Label Photoreactive Biotin Crosslinker.", false},
    {UNIMOD_Biotin_Thermo_33033_H, "UNIMOD:1252", "Biotin:Thermo-33033-H", "Sulfo-SBED Label Photoreactive Biotin Crosslinker minus Hydrogen.", false},
    {UNIMOD_2_monomethylsuccinyl, "UNIMOD:1253", "2-monomethylsuccinyl", "S-(2-monomethylsuccinyl) cysteine.", false},
    {UNIMOD_Saligenin, "UNIMOD:1254", "Saligenin", "O-toluene.", false},
    {UNIMOD_Cresylphosphate, "UNIMOD:1255", "Cresylphosphate", "O-toluyl-phosphorylation.", false},
    {UNIMOD_CresylSaligeninPhosphate, "UNIMOD:1256", "CresylSaligeninPhosphate", "Cresyl-Saligenin-phosphorylation.", false},
    {UNIMOD_Ub_Br2, "UNIMOD:1257", "Ub-Br2", "Ub Bromide probe addition.", false},
    {UNIMOD_Ub_VME, "UNIMOD:1258", "Ub-VME", "Ubiquitin vinylmethylester.", false},
    {UNIMOD_Ub_fluorescein, "UNIMOD:1261", "Ub-fluorescein", "Ub Fluorescein probe addition.", false},
    {UNIMOD_2_dimethylsuccinyl, "UNIMOD:1262", "2-dimethylsuccinyl", "S-(2-dimethylsuccinyl) cysteine.", false},
    {UNIMOD_Gly, "UNIMOD:1263", "Gly", "Addition of Glycine.", false},
    {UNIMOD_pupylation, "UNIMOD:1264", "pupylation", "Addition of GGE.", false},
    {UNIMOD_Label_13C_4_, "UNIMOD:1266", "Label:13C(4)", "13C4 Methionine label.", false},
    {UNIMOD_Label_13C_4__Oxidation, "UNIMOD:1267", "Label:13C(4)+Oxidation", "Oxidised 13C4 labelled Methionine.", false},
    {UNIMOD_HCysThiolactone, "UNIMOD:1270", "HCysThiolactone", "N-Homocysteine thiolactone.", false},
    {UNIMOD_HCysteinyl, "UNIMOD:1271", "HCysteinyl", "S-homocysteinylation.", false},
    {UNIMOD_UgiJoullie, "UNIMOD:1276", "UgiJoullie", "Side reaction of HisTag.", false},
    {UNIMOD_Dipyridyl, "UNIMOD:1277", "Dipyridyl", "Cys modified with dipy ligand.", false},
    {UNIMOD_Furan, "UNIMOD:1278", "Furan", "Chemical modification of the iodinated sites of thyroglobulin by Suzuki reaction.", false},
    {UNIMOD_Difuran, "UNIMOD:1279", "Difuran", "Chemical modification of the diiodinated sites of thyroglobulin by Suzuki reaction.", false},
    {UNIMOD_BMP_piperidinol, "UNIMOD:1281", "BMP-piperidinol", "1-methyl-3-benzoyl-4-hydroxy-4-phenylpiperidine.", false},
    {UNIMOD_UgiJoullieProGly, "UNIMOD:1282", "UgiJoullieProGly", "Side reaction of PG with Side chain of aspartic or glutamic acid.", false},
    {UNIMOD_UgiJoullieProGlyProGly, "UNIMOD:1283", "UgiJoullieProGlyProGly", "Side reaction of PGPG with Side chain of aspartic or glutamic acid.", false},
    {UNIMOD_IMEHex_2_NeuAc_1_, "UNIMOD:1286", "IMEHex(2)NeuAc(1)", "Glycosylation with IME linked Hex(2) NeuAc.", false},
    {UNIMOD_Arg_loss, "UNIMOD:1287", "Arg-loss", "Loss of arginine due to transpeptidation.", false},
    {UNIMOD_Arg, "UNIMOD:1288", "Arg", "Addition of arginine due to transpeptidation.", false},
    {UNIMOD_Butyryl, "UNIMOD:1289", "Butyryl", "Butyryl.", false},
    {UNIMOD_Dicarbamidomethyl, "UNIMOD:1290", "Dicarbamidomethyl", "Double Carbamidomethylation.", false},
    {UNIMOD_Dimethyl_2H_6_, "UNIMOD:1291", "Dimethyl:2H(6)", "Dimethyl-Medium.", false},
    {UNIMOD_GGQ, "UNIMOD:1292", "GGQ", "SUMOylation leaving GlyGlyGln.", false},
    {UNIMOD_QTGG, "UNIMOD:1293", "QTGG", "SUMOylation leaving GlnThrGlyGly.", false},
    {UNIMOD_Label_13C_3_, "UNIMOD:1296", "Label:13C(3)", "13C3 label for SILAC.", false},
    {UNIMOD_Label_13C_3_15N_1_, "UNIMOD:1297", "Label:13C(3)15N(1)", "SILAC or AQUA label.", false},
    {UNIMOD_Label_13C_4_15N_1_, "UNIMOD:1298", "Label:13C(4)15N(1)", "13C4 15N1 label for SILAC.", false},
    {UNIMOD_Label_2H_10_, "UNIMOD:1299", "Label:2H(10)", "2H(10) label.", false},
    {UNIMOD_Label_2H_4_13C_1_, "UNIMOD:1300", "Label:2H(4)13C(1)", "Label:2H(4)13C(1).", false},
    {UNIMOD_Lys, "UNIMOD:1301", "Lys", "Addition of lysine due to transpeptidation.", false},
    {UNIMOD_mTRAQ_13C_6_15N_2_, "UNIMOD:1302", "mTRAQ:13C(6)15N(2)", "MTRAQ heavy.", false},
    {UNIMOD_NeuAc, "UNIMOD:1303", "NeuAc", "N-acetyl neuraminic acid.", false},
    {UNIMOD_NeuGc, "UNIMOD:1304", "NeuGc", "N-glycoyl neuraminic acid.", false},
    {UNIMOD_Propyl, "UNIMOD:1305", "Propyl", "Propyl.", false},
    {UNIMOD_Propyl_2H_6_, "UNIMOD:1306", "Propyl:2H(6)", "Propyl:2H(6).", false},
    {UNIMOD_Propiophenone, "UNIMOD:1310", "Propiophenone", "Propiophenone.", false},
    {UNIMOD_Delta_H_6_C_3_O_1_, "UNIMOD:1312", "Delta:H(6)C(3)O(1)", "Reduced acrolein addition +58.", false},
    {UNIMOD_Delta_H_8_C_6_O_1_, "UNIMOD:1313", "Delta:H(8)C(6)O(1)", "Reduced acrolein addition +96.", false},
    {UNIMOD_biotinAcrolein298, "UNIMOD:1314", "biotinAcrolein298", "Biotin hydrazide labeled acrolein addition +298.", false},
    {UNIMOD_MM_diphenylpentanone, "UNIMOD:1315", "MM-diphenylpentanone", "3-methyl-5-(methylamino)-1,3-diphenylpentan-1-one.", false},
    {UNIMOD_EHD_diphenylpentanone, "UNIMOD:1317", "EHD-diphenylpentanone", "2-ethyl-3-hydroxy-1,3-diphenylpentan-1-one.", false},
    {UNIMOD_Biotin_Thermo_21901_2H2O, "UNIMOD:1320", "Biotin:Thermo-21901+2H2O", "Maleimide-Biotin + 2Water.", false},
    {UNIMOD_DiLeu4plex115, "UNIMOD:1321", "DiLeu4plex115", "Accurate mass for DiLeu 115 isobaric tag.", false},
    {UNIMOD_DiLeu4plex, "UNIMOD:1322", "DiLeu4plex", "Accurate mass for DiLeu 116 isobaric tag.", false},
    {UNIMOD_DiLeu4plex117, "UNIMOD:1323", "DiLeu4plex117", "Accurate mass for DiLeu 117 isobaric tag.", false},
    {UNIMOD_DiLeu4plex118, "UNIMOD:1324", "DiLeu4plex118", "Accurate mass for DiLeu 118 isobaric tag.", false},
    {UNIMOD_NEMsulfur, "UNIMOD:1326", "NEMsulfur", "N-ethylmaleimideSulfur.", false},
    {UNIMOD_SulfurDioxide, "UNIMOD:1327", "SulfurDioxide", "SulfurDioxide.", false},
    {UNIMOD_NEMsulfurWater, "UNIMOD:1328", "NEMsulfurWater", "N-ethylmaleimideSulfurWater.", false},
    {UNIMOD_bisANS_sulfonates, "UNIMOD:1330", "bisANS-sulfonates", "BisANS with loss of both sulfonates.", false},
    {UNIMOD_DNCB_hapten, "UNIMOD:1331", "DNCB_hapten", "Chemical reaction with 2,4-dinitro-1-chloro benzene (DNCB).", false},
    {UNIMOD_Biotin_Thermo_21911, "UNIMOD:1340", "Biotin:Thermo-21911", "Biotin-PEG11-maleimide.", false},
    {UNIMOD_iodoTMT, "UNIMOD:1341", "iodoTMT", "Native iodoacetyl Tandem Mass Tag®.", false},
    {UNIMOD_iodoTMT6plex, "UNIMOD:1342", "iodoTMT6plex", "Sixplex iodoacetyl Tandem Mass Tag®.", false},
    {UNIMOD_Phosphogluconoylation, "UNIMOD:1344", "Phosphogluconoylation", "Phosphogluconoylation.", false},
    {UNIMOD_PS_Hapten, "UNIMOD:1345", "PS_Hapten", "Reaction with phenyl salicylate (PS).", false},
    {UNIMOD_Cy3_maleimide, "UNIMOD:1348", "Cy3-maleimide", "Cy3 Maleimide mono-Reactive dye.", false},
    {UNIMOD_benzylguanidine, "UNIMOD:1349", "benzylguanidine", "Modification of the lysine side chain from NH2 to guanidine with a H removed in favor of a benzyl group.", false},
    {UNIMOD_CarboxymethylDMAP, "UNIMOD:1350", "CarboxymethylDMAP", "A fixed +1 charge tag attached to the N-terminus of peptides.", false},
    {UNIMOD_azole, "UNIMOD:1355", "azole", "Formation of five membered aromatic heterocycle.", false},
    {UNIMOD_phosphoRibosyl, "UNIMOD:1356", "phosphoRibosyl", "Phosphate-ribosylation.", false},
    {UNIMOD_NEM_2H_5__H2O, "UNIMOD:1358", "NEM:2H(5)+H2O", "D5 N-ethylmaleimide+water on cysteines.", false},
    {UNIMOD_Crotonyl, "UNIMOD:1363", "Crotonyl", "Crotonylation.", false},
    {UNIMOD_O_Et_N_diMePhospho, "UNIMOD:1364", "O-Et-N-diMePhospho", "O-ethyl, N-dimethyl phosphate.", false},
    {UNIMOD_N_dimethylphosphate, "UNIMOD:1365", "N-dimethylphosphate", "N-dimethylphosphate.", false},
    {UNIMOD_dHex_1_Hex_1_, "UNIMOD:1367", "dHex(1)Hex(1)", "Hex1dHex1.", false},
    {UNIMOD_Methyl_2H_3__Acetyl_2H_3_, "UNIMOD:1368", "Methyl:2H(3)+Acetyl:2H(3)", "3-fold methylated lysine labelled with Acetyl_heavy.", false},
    {UNIMOD_Label_2H_3__Oxidation, "UNIMOD:1370", "Label:2H(3)+Oxidation", "Oxidised 2H(3) labelled Methionine.", false},
    {UNIMOD_Trimethyl_2H_9_, "UNIMOD:1371", "Trimethyl:2H(9)", "3-fold methylation with deuterated methyl groups.", false},
    {UNIMOD_Acetyl_13C_2_, "UNIMOD:1372", "Acetyl:13C(2)", "Heavy acetylation.", false},
    {UNIMOD_dHex_1_Hex_2_, "UNIMOD:1375", "dHex(1)Hex(2)", "Hex2dHex1.", false},
    {UNIMOD_dHex_1_Hex_3_, "UNIMOD:1376", "dHex(1)Hex(3)", "Hex3dHex1.", false},
    {UNIMOD_dHex_1_Hex_4_, "UNIMOD:1377", "dHex(1)Hex(4)", "Hex4dHex1.", false},
    {UNIMOD_dHex_1_Hex_5_, "UNIMOD:1378", "dHex(1)Hex(5)", "Hex5dHex1.", false},
    {UNIMOD_dHex_1_Hex_6_, "UNIMOD:1379", "dHex(1)Hex(6)", "Hex6dHex1.", false},
    {UNIMOD_methylsulfonylethyl, "UNIMOD:1380", "methylsulfonylethyl", "Reaction with methyl vinyl sulfone.", false},
    {UNIMOD_ethylsulfonylethyl, "UNIMOD:1381", "ethylsulfonylethyl", "Reaction with ethyl vinyl sulfone.", false},
    {UNIMOD_phenylsulfonylethyl, "UNIMOD:1382", "phenylsulfonylethyl", "Reaction with phenyl vinyl sulfone.", false},
    {UNIMOD_PyridoxalPhosphateH2, "UNIMOD:1383", "PyridoxalPhosphateH2", "PLP bound to lysine reduced by sodium borohydride (NaBH4) to create amine linkage.", false},
    {UNIMOD_Homocysteic_acid, "UNIMOD:1384", "Homocysteic_acid", "Methionine oxidation to homocysteic acid.", false},
    {UNIMOD_Hydroxamic_acid, "UNIMOD:1385", "Hydroxamic_acid", "ADP-ribosylation followed by conversion to hydroxamic acid via hydroxylamine.", false},
    {UNIMOD_3_phosphoglyceryl, "UNIMOD:1387", "3-phosphoglyceryl", "3-phosphoglyceryl.", false},
    {UNIMOD_HN2_mustard, "UNIMOD:1388", "HN2_mustard", "Modification by hydroxylated mechloroethamine (HN-2).", false},
    {UNIMOD_HN3_mustard, "UNIMOD:1389", "HN3_mustard", "Modification by hydroxylated tris-(2-chloroethyl)amine (HN-3).", false},
    {UNIMOD_Oxidation_NEM, "UNIMOD:1390", "Oxidation+NEM", "N-ethylmaleimide on cysteine sulfenic acid.", false},
    {UNIMOD_NHS_fluorescein, "UNIMOD:1391", "NHS-fluorescein", "Fluorescein-hexanoate-NHS hydrolysis.", false},
    {UNIMOD_DiART6plex, "UNIMOD:1392", "DiART6plex", "Representative mass and accurate mass for 114.", false},
    {UNIMOD_DiART6plex115, "UNIMOD:1393", "DiART6plex115", "Accurate mass for DiART6plex 115.", false},
    {UNIMOD_DiART6plex116_119, "UNIMOD:1394", "DiART6plex116/119", "Accurate mass for DiART6plex 116 and 119.", false},
    {UNIMOD_DiART6plex117, "UNIMOD:1395", "DiART6plex117", "Accurate mass for DiART6plex 117.", false},
    {UNIMOD_DiART6plex118, "UNIMOD:1396", "DiART6plex118", "Accurate mass for DiART6plex 118.", false},
    {UNIMOD_Iodoacetanilide, "UNIMOD:1397", "Iodoacetanilide", "Iodoacetanilide derivative.", false},
    {UNIMOD_Iodoacetanilide_13C_6_, "UNIMOD:1398", "Iodoacetanilide:13C(6)", "13C labelled iodoacetanilide derivative.", false},
    {UNIMOD_Dap_DSP, "UNIMOD:1399", "Dap-DSP", "Diaminopimelic acid-DSP monolinked.", false},
    {UNIMOD_MurNAc, "UNIMOD:1400", "MurNAc", "N-Acetylmuramic acid.", false},
    {UNIMOD_Label_2H_7_15N_4_, "UNIMOD:1402", "Label:2H(7)15N(4)", "Label:2H(7)15N(4).", false},
    {UNIMOD_Label_2H_6_15N_1_, "UNIMOD:1403", "Label:2H(6)15N(1)", "Label:2H(6)15N(1).", false},
    {UNIMOD_EEEDVIEVYQEQTGG, "UNIMOD:1405", "EEEDVIEVYQEQTGG", "Sumoylation by SUMO-1 after Cyanogen bromide (CNBr) cleavage.", false},
    {UNIMOD_EDEDTIDVFQQQTGG, "UNIMOD:1406", "EDEDTIDVFQQQTGG", "Sumoylation by SUMO-2/3 after Cyanogen bromide (CNBr) cleavage.", false},
    {UNIMOD_Hex_5_HexNAc_4_NeuAc_2_, "UNIMOD:1408", "Hex(5)HexNAc(4)NeuAc(2)", "A2G2S2/G2S2.", false},
    {UNIMOD_Hex_5_HexNAc_4_NeuAc_1_, "UNIMOD:1409", "Hex(5)HexNAc(4)NeuAc(1)", "A2G2S1/G2S1.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_NeuAc_1_, "UNIMOD:1410", "dHex(1)Hex(5)HexNAc(4)NeuAc(1)", "FA2G2S1/G2FS1.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_NeuAc_2_, "UNIMOD:1411", "dHex(1)Hex(5)HexNAc(4)NeuAc(2)", "FA2G2S2/G2FS2.", false},
    {UNIMOD_s_GlcNAc, "UNIMOD:1412", "s-GlcNAc", "O3S1HexNAc1.", false},
    {UNIMOD_PhosphoHex_2_, "UNIMOD:1413", "PhosphoHex(2)", "H1O3P1Hex2.", false},
    {UNIMOD_Trimethyl_13C_3_2H_9_, "UNIMOD:1414", "Trimethyl:13C(3)2H(9)", "3-fold methylation with fully labelled methyl groups.", false},
    {UNIMOD_15N_oxobutanoic, "UNIMOD:1419", "15N-oxobutanoic", "Loss of ammonia (15N).", false},
    {UNIMOD_spermine, "UNIMOD:1420", "spermine", "Spermine adduct.", false},
    {UNIMOD_spermidine, "UNIMOD:1421", "spermidine", "Spermidine adduct.", false},
    {UNIMOD_Biotin_Thermo_21330, "UNIMOD:1423", "Biotin:Thermo-21330", "Biotin_PEG4.", false},
    {UNIMOD_Pentose, "UNIMOD:1425", "Pentose", "Pentose.", false},
    {UNIMOD_Hex_1_Pent_1_, "UNIMOD:1426", "Hex(1)Pent(1)", "Hex Pent.", false},
    {UNIMOD_Hex_1_HexA_1_, "UNIMOD:1427", "Hex(1)HexA(1)", "Hex HexA.", false},
    {UNIMOD_Hex_1_Pent_2_, "UNIMOD:1428", "Hex(1)Pent(2)", "Hex Pent(2).", false},
    {UNIMOD_Hex_1_HexNAc_1_Phos_1_, "UNIMOD:1429", "Hex(1)HexNAc(1)Phos(1)", "Hex HexNAc Phos.", false},
    {UNIMOD_Hex_1_HexNAc_1_Sulf_1_, "UNIMOD:1430", "Hex(1)HexNAc(1)Sulf(1)", "Hex HexNAc Sulf.", false},
    {UNIMOD_Hex_1_NeuAc_1_, "UNIMOD:1431", "Hex(1)NeuAc(1)", "Hex NeuAc ---OR--- HexNAc Kdn.", false},
    {UNIMOD_Hex_1_NeuGc_1_, "UNIMOD:1432", "Hex(1)NeuGc(1)", "Hex NeuGc.", false},
    {UNIMOD_HexNAc_3_, "UNIMOD:1433", "HexNAc(3)", "HexNAc(3).", false},
    {UNIMOD_HexNAc_1_NeuAc_1_, "UNIMOD:1434", "HexNAc(1)NeuAc(1)", "HexNAc NeuAc.", false},
    {UNIMOD_HexNAc_1_NeuGc_1_, "UNIMOD:1435", "HexNAc(1)NeuGc(1)", "HexNAc NeuGc.", false},
    {UNIMOD_Hex_1_HexNAc_1_dHex_1_Me_1_, "UNIMOD:1436", "Hex(1)HexNAc(1)dHex(1)Me(1)", "Hex HexNAc dHex Me.", false},
    {UNIMOD_Hex_1_HexNAc_1_dHex_1_Me_2_, "UNIMOD:1437", "Hex(1)HexNAc(1)dHex(1)Me(2)", "Hex HexNAc dHex Me(2).", false},
    {UNIMOD_Hex_2_HexNAc_1_, "UNIMOD:1438", "Hex(2)HexNAc(1)", "Hex(2) HexNAc.", false},
    {UNIMOD_Hex_1_HexA_1_HexNAc_1_, "UNIMOD:1439", "Hex(1)HexA(1)HexNAc(1)", "Hex HexA HexNAc.", false},
    {UNIMOD_Hex_2_HexNAc_1_Me_1_, "UNIMOD:1440", "Hex(2)HexNAc(1)Me(1)", "Hex(2) HexNAc Me.", false},
    {UNIMOD_Hex_1_Pent_3_, "UNIMOD:1441", "Hex(1)Pent(3)", "Hex Pent(3).", false},
    {UNIMOD_Hex_1_NeuAc_1_Pent_1_, "UNIMOD:1442", "Hex(1)NeuAc(1)Pent(1)", "Hex NeuAc Pent.", false},
    {UNIMOD_Hex_2_HexNAc_1_Sulf_1_, "UNIMOD:1443", "Hex(2)HexNAc(1)Sulf(1)", "Hex(2) HexNAc Sulf.", false},
    {UNIMOD_Hex_2_NeuAc_1_, "UNIMOD:1444", "Hex(2)NeuAc(1)", "Hex(2) NeuAc ---OR--- Hex HexNAc Kdn.", false},
    {UNIMOD_dHex_2_Hex_2_, "UNIMOD:1445", "dHex(2)Hex(2)", "Hex2 dHex2.", false},
    {UNIMOD_dHex_1_Hex_2_HexA_1_, "UNIMOD:1446", "dHex(1)Hex(2)HexA(1)", "DHex Hex(2) HexA.", false},
    {UNIMOD_Hex_1_HexNAc_2_Sulf_1_, "UNIMOD:1447", "Hex(1)HexNAc(2)Sulf(1)", "Hex HexNAc(2) Sulf.", false},
    {UNIMOD_Hex_4_, "UNIMOD:1448", "Hex(4)", "Hex(4).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_Pent_1_, "UNIMOD:1449", "dHex(1)Hex(2)HexNAc(2)Pent(1)", "DHex Hex(2) HexNAc(2) Pent.", false},
    {UNIMOD_Hex_2_HexNAc_2_NeuAc_1_, "UNIMOD:1450", "Hex(2)HexNAc(2)NeuAc(1)", "Hex(2) HexNAc(2) NeuAc ---OR--- dHex Hex HexNAc(2) NeuGc.", false},
    {UNIMOD_Hex_3_HexNAc_2_Pent_1_, "UNIMOD:1451", "Hex(3)HexNAc(2)Pent(1)", "Hex(3) HexNAc(2) Pent.", false},
    {UNIMOD_Hex_4_HexNAc_2_, "UNIMOD:1452", "Hex(4)HexNAc(2)", "Hex(4) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_1_Pent_1_, "UNIMOD:1453", "dHex(1)Hex(4)HexNAc(1)Pent(1)", "DHex Hex(4) HexNAc Pent.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_2_Pent_1_, "UNIMOD:1454", "dHex(1)Hex(3)HexNAc(2)Pent(1)", "DHex Hex(3) HexNAc(2) Pent.", false},
    {UNIMOD_Hex_3_HexNAc_2_NeuAc_1_, "UNIMOD:1455", "Hex(3)HexNAc(2)NeuAc(1)", "Hex(3) HexNAc(2) NeuAc.", false},
    {UNIMOD_Hex_4_HexNAc_2_Pent_1_, "UNIMOD:1456", "Hex(4)HexNAc(2)Pent(1)", "Hex(4) HexNAc(2) Pent.", false},
    {UNIMOD_Hex_3_HexNAc_3_Pent_1_, "UNIMOD:1457", "Hex(3)HexNAc(3)Pent(1)", "Hex(3) HexNAc(3) Pent.", false},
    {UNIMOD_Hex_5_HexNAc_2_Phos_1_, "UNIMOD:1458", "Hex(5)HexNAc(2)Phos(1)", "Hex(5) HexNAc(2) Phos.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_2_Pent_1_, "UNIMOD:1459", "dHex(1)Hex(4)HexNAc(2)Pent(1)", "DHex Hex(4) HexNAc(2) Pent.", false},
    {UNIMOD_Hex_7_HexNAc_1_, "UNIMOD:1460", "Hex(7)HexNAc(1)", "Hex(7) HexNAc.", false},
    {UNIMOD_Hex_4_HexNAc_2_NeuAc_1_, "UNIMOD:1461", "Hex(4)HexNAc(2)NeuAc(1)", "Hex(4) HexNAc(2) NeuAc ---OR--- Hex(3) HexNAc(2) dHex NeuGc.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_2_, "UNIMOD:1462", "dHex(1)Hex(5)HexNAc(2)", "DHex Hex(5) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_3_Pent_1_, "UNIMOD:1463", "dHex(1)Hex(3)HexNAc(3)Pent(1)", "DHex Hex(3) HexNAc(3) Pent.", false},
    {UNIMOD_Hex_3_HexNAc_4_Sulf_1_, "UNIMOD:1464", "Hex(3)HexNAc(4)Sulf(1)", "Hex(3) HexNAc(4) Sulf.", false},
    {UNIMOD_Hex_6_HexNAc_2_, "UNIMOD:1465", "Hex(6)HexNAc(2)", "M6/Man6.", false},
    {UNIMOD_Hex_4_HexNAc_3_Pent_1_, "UNIMOD:1466", "Hex(4)HexNAc(3)Pent(1)", "Hex(4) HexNAc(3) Pent.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_3_, "UNIMOD:1467", "dHex(1)Hex(4)HexNAc(3)", "DHex Hex(4) HexNAc(3).", false},
    {UNIMOD_Hex_5_HexNAc_3_, "UNIMOD:1468", "Hex(5)HexNAc(3)", "Hex(5) HexNAc(3).", false},
    {UNIMOD_Hex_3_HexNAc_4_Pent_1_, "UNIMOD:1469", "Hex(3)HexNAc(4)Pent(1)", "Hex(3) HexNAc(4) Pent.", false},
    {UNIMOD_Hex_6_HexNAc_2_Phos_1_, "UNIMOD:1470", "Hex(6)HexNAc(2)Phos(1)", "Hex(6) HexNAc(2) Phos.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_3_Sulf_1_, "UNIMOD:1471", "dHex(1)Hex(4)HexNAc(3)Sulf(1)", "DHex Hex(4) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_2_Pent_1_, "UNIMOD:1472", "dHex(1)Hex(5)HexNAc(2)Pent(1)", "DHex Hex(5) HexNAc(2) Pent.", false},
    {UNIMOD_Hex_8_HexNAc_1_, "UNIMOD:1473", "Hex(8)HexNAc(1)", "Hex(8) HexNAc.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_3_Pent_2_, "UNIMOD:1474", "dHex(1)Hex(3)HexNAc(3)Pent(2)", "DHex Hex(3) HexNAc(3) Pent(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_3_Pent_1_, "UNIMOD:1475", "dHex(2)Hex(3)HexNAc(3)Pent(1)", "DHex(2) Hex(3) HexNAc(3) Pent.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_4_Sulf_1_, "UNIMOD:1476", "dHex(1)Hex(3)HexNAc(4)Sulf(1)", "DHex Hex(3) HexNAc(4) Sulf.", false},
    {UNIMOD_dHex_1_Hex_6_HexNAc_2_, "UNIMOD:1477", "dHex(1)Hex(6)HexNAc(2)", "DHex Hex(6) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_3_Pent_1_, "UNIMOD:1478", "dHex(1)Hex(4)HexNAc(3)Pent(1)", "DHex Hex(4) HexNAc(3) Pent.", false},
    {UNIMOD_Hex_4_HexNAc_4_Sulf_1_, "UNIMOD:1479", "Hex(4)HexNAc(4)Sulf(1)", "Hex(4) HexNAc(4) Sulf.", false},
    {UNIMOD_Hex_7_HexNAc_2_, "UNIMOD:1480", "Hex(7)HexNAc(2)", "M7/Man7.", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_3_, "UNIMOD:1481", "dHex(2)Hex(4)HexNAc(3)", "DHex(2) Hex(4) HexNAc(3).", false},
    {UNIMOD_Hex_5_HexNAc_3_Pent_1_, "UNIMOD:1482", "Hex(5)HexNAc(3)Pent(1)", "Hex(5) HexNAc(3) Pent.", false},
    {UNIMOD_Hex_4_HexNAc_3_NeuGc_1_, "UNIMOD:1483", "Hex(4)HexNAc(3)NeuGc(1)", "Hex(4) HexNAc(3) NeuGc.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_3_, "UNIMOD:1484", "dHex(1)Hex(5)HexNAc(3)", "DHex Hex(5) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_4_Pent_1_, "UNIMOD:1485", "dHex(1)Hex(3)HexNAc(4)Pent(1)", "DHex Hex(3) HexNAc(4) Pent.", false},
    {UNIMOD_Hex_3_HexNAc_5_Sulf_1_, "UNIMOD:1486", "Hex(3)HexNAc(5)Sulf(1)", "Hex(3) HexNAc(5) Sulf.", false},
    {UNIMOD_Hex_6_HexNAc_3_, "UNIMOD:1487", "Hex(6)HexNAc(3)", "Hex(6) HexNAc(3).", false},
    {UNIMOD_Hex_3_HexNAc_4_NeuAc_1_, "UNIMOD:1488", "Hex(3)HexNAc(4)NeuAc(1)", "Hex(3) HexNAc(4) NeuAc ---OR--- Hex(2) HexNAc(4) dHex NeuGc.", false},
    {UNIMOD_Hex_4_HexNAc_4_Pent_1_, "UNIMOD:1489", "Hex(4)HexNAc(4)Pent(1)", "Hex(4) HexNAc(4) Pent.", false},
    {UNIMOD_Hex_7_HexNAc_2_Phos_1_, "UNIMOD:1490", "Hex(7)HexNAc(2)Phos(1)", "Hex(7) HexNAc(2) Phos.", false},
    {UNIMOD_Hex_4_HexNAc_4_Me_2_Pent_1_, "UNIMOD:1491", "Hex(4)HexNAc(4)Me(2)Pent(1)", "Hex(4) HexNAc(4) Me(2) Pent.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_3_Pent_3_, "UNIMOD:1492", "dHex(1)Hex(3)HexNAc(3)Pent(3)", "DHex Hex(3) HexNAc(3) Pent(3) ---OR--- Hex(4) HexNAc(2) dHex(2) NeuAc.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_3_Sulf_1_, "UNIMOD:1493", "dHex(1)Hex(5)HexNAc(3)Sulf(1)", "DHex Hex(5) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_3_Pent_2_, "UNIMOD:1494", "dHex(2)Hex(3)HexNAc(3)Pent(2)", "DHex(2) Hex(3) HexNAc(3) Pent(2).", false},
    {UNIMOD_Hex_6_HexNAc_3_Phos_1_, "UNIMOD:1495", "Hex(6)HexNAc(3)Phos(1)", "Hex(6) HexNAc(3) Phos.", false},
    {UNIMOD_Hex_4_HexNAc_5_, "UNIMOD:1496", "Hex(4)HexNAc(5)", "Hex(4) HexNAc(5).", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_3_Pent_1_, "UNIMOD:1497", "dHex(3)Hex(3)HexNAc(3)Pent(1)", "DHex(3) Hex(3) HexNAc(3) Pent.", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_3_Pent_1_, "UNIMOD:1498", "dHex(2)Hex(4)HexNAc(3)Pent(1)", "DHex(2) Hex(4) HexNAc(3) Pent.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_4_Sulf_1_, "UNIMOD:1499", "dHex(1)Hex(4)HexNAc(4)Sulf(1)", "DHex Hex(4) HexNAc(4) Sulf.", false},
    {UNIMOD_dHex_1_Hex_7_HexNAc_2_, "UNIMOD:1500", "dHex(1)Hex(7)HexNAc(2)", "DHex Hex(7) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_3_NeuAc_1_, "UNIMOD:1501", "dHex(1)Hex(4)HexNAc(3)NeuAc(1)", "DHex Hex(4) HexNAc(3) NeuAc ---OR--- dHex(2) Hex(3) HexNAc(3) NeuGc.", false},
    {UNIMOD_Hex_7_HexNAc_2_Phos_2_, "UNIMOD:1502", "Hex(7)HexNAc(2)Phos(2)", "Hex(7) HexNAc(2) Phos(2).", false},
    {UNIMOD_Hex_5_HexNAc_4_Sulf_1_, "UNIMOD:1503", "Hex(5)HexNAc(4)Sulf(1)", "Hex(5) HexNAc(4) Sulf.", false},
    {UNIMOD_Hex_8_HexNAc_2_, "UNIMOD:1504", "Hex(8)HexNAc(2)", "M8/Man8.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_4_Pent_2_, "UNIMOD:1505", "dHex(1)Hex(3)HexNAc(4)Pent(2)", "DHex Hex(3) HexNAc(4) Pent(2).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_3_NeuGc_1_, "UNIMOD:1506", "dHex(1)Hex(4)HexNAc(3)NeuGc(1)", "DHex Hex(4) HexNAc(3) NeuGc ---OR--- Hex(5) HexNAc(3) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_4_Pent_1_, "UNIMOD:1507", "dHex(2)Hex(3)HexNAc(4)Pent(1)", "DHex(2) Hex(3) HexNAc(4) Pent.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_5_Sulf_1_, "UNIMOD:1508", "dHex(1)Hex(3)HexNAc(5)Sulf(1)", "DHex Hex(3) HexNAc(5) Sulf.", false},
    {UNIMOD_dHex_1_Hex_6_HexNAc_3_, "UNIMOD:1509", "dHex(1)Hex(6)HexNAc(3)", "DHex Hex(6) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_4_NeuAc_1_, "UNIMOD:1510", "dHex(1)Hex(3)HexNAc(4)NeuAc(1)", "DHex Hex(3) HexNAc(4) NeuAc.", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_4_, "UNIMOD:1511", "dHex(3)Hex(3)HexNAc(4)", "DHex(3) Hex(3) HexNAc(4).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_4_Pent_1_, "UNIMOD:1512", "dHex(1)Hex(4)HexNAc(4)Pent(1)", "DHex Hex(4) HexNAc(4) Pent.", false},
    {UNIMOD_Hex_4_HexNAc_5_Sulf_1_, "UNIMOD:1513", "Hex(4)HexNAc(5)Sulf(1)", "Hex(4) HexNAc(5) Sulf.", false},
    {UNIMOD_Hex_7_HexNAc_3_, "UNIMOD:1514", "Hex(7)HexNAc(3)", "Hex(7) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1515", "dHex(1)Hex(4)HexNAc(3)NeuAc(1)Sulf(1)", "DHex Hex(4) HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_Hex_5_HexNAc_4_Me_2_Pent_1_, "UNIMOD:1516", "Hex(5)HexNAc(4)Me(2)Pent(1)", "Hex(5) HexNAc(4) Me(2) Pent.", false},
    {UNIMOD_Hex_3_HexNAc_6_Sulf_1_, "UNIMOD:1517", "Hex(3)HexNAc(6)Sulf(1)", "Hex(3) HexNAc(6) Sulf.", false},
    {UNIMOD_dHex_1_Hex_6_HexNAc_3_Sulf_1_, "UNIMOD:1518", "dHex(1)Hex(6)HexNAc(3)Sulf(1)", "DHex Hex(6) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_5_, "UNIMOD:1519", "dHex(1)Hex(4)HexNAc(5)", "DHex Hex(4) HexNAc(5).", false},
    {UNIMOD_dHex_1_Hex_5_HexA_1_HexNAc_3_Sulf_1_, "UNIMOD:1520", "dHex(1)Hex(5)HexA(1)HexNAc(3)Sulf(1)", "DHex Hex(5) HexA HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_7_HexNAc_3_Phos_1_, "UNIMOD:1521", "Hex(7)HexNAc(3)Phos(1)", "Hex(7) HexNAc(3) Phos.", false},
    {UNIMOD_Hex_6_HexNAc_4_Me_3_, "UNIMOD:1522", "Hex(6)HexNAc(4)Me(3)", "Hex(6) HexNAc(4) Me(3).", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_4_Sulf_1_, "UNIMOD:1523", "dHex(2)Hex(4)HexNAc(4)Sulf(1)", "DHex(2) Hex(4) HexNAc(4) Sulf.", false},
    {UNIMOD_Hex_4_HexNAc_3_NeuAc_2_, "UNIMOD:1524", "Hex(4)HexNAc(3)NeuAc(2)", "Hex(4) HexNAc(3) NeuAc(2).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_4_Pent_3_, "UNIMOD:1525", "dHex(1)Hex(3)HexNAc(4)Pent(3)", "DHex Hex(3) HexNAc(4) Pent(3).", false},
    {UNIMOD_dHex_2_Hex_5_HexNAc_3_Pent_1_, "UNIMOD:1526", "dHex(2)Hex(5)HexNAc(3)Pent(1)", "DHex(2) Hex(5) HexNAc(3) Pent.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_Sulf_1_, "UNIMOD:1527", "dHex(1)Hex(5)HexNAc(4)Sulf(1)", "DHex Hex(5) HexNAc(4) Sulf.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_4_Pent_2_, "UNIMOD:1528", "dHex(2)Hex(3)HexNAc(4)Pent(2)", "DHex(2) Hex(3) HexNAc(4) Pent(2).", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_3_NeuAc_1_, "UNIMOD:1529", "dHex(1)Hex(5)HexNAc(3)NeuAc(1)", "DHex Hex(5) HexNAc(3) NeuAc.", false},
    {UNIMOD_Hex_3_HexNAc_6_Sulf_2_, "UNIMOD:1530", "Hex(3)HexNAc(6)Sulf(2)", "Hex(3) HexNAc(6) Sulf(2).", false},
    {UNIMOD_Hex_9_HexNAc_2_, "UNIMOD:1531", "Hex(9)HexNAc(2)", "M9/Man9.", false},
    {UNIMOD_Hex_4_HexNAc_6_, "UNIMOD:1532", "Hex(4)HexNAc(6)", "Hex(4) HexNAc(6).", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_4_Pent_1_, "UNIMOD:1533", "dHex(3)Hex(3)HexNAc(4)Pent(1)", "DHex(3) Hex(3) HexNAc(4) Pent.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_3_NeuGc_1_, "UNIMOD:1534", "dHex(1)Hex(5)HexNAc(3)NeuGc(1)", "DHex Hex(5) HexNAc(3) NeuGc ---OR--- Hex(6) HexNAc(3) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_4_Pent_1_, "UNIMOD:1535", "dHex(2)Hex(4)HexNAc(4)Pent(1)", "DHex(2) Hex(4) HexNAc(4) Pent.", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_5_Sulf_1_, "UNIMOD:1536", "dHex(1)Hex(4)HexNAc(5)Sulf(1)", "DHex Hex(4) HexNAc(5) Sulf.", false},
    {UNIMOD_dHex_1_Hex_7_HexNAc_3_, "UNIMOD:1537", "dHex(1)Hex(7)HexNAc(3)", "DHex Hex(7) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_Pent_1_, "UNIMOD:1538", "dHex(1)Hex(5)HexNAc(4)Pent(1)", "DHex Hex(5) HexNAc(4) Pent.", false},
    {UNIMOD_dHex_1_Hex_5_HexA_1_HexNAc_3_Sulf_2_, "UNIMOD:1539", "dHex(1)Hex(5)HexA(1)HexNAc(3)Sulf(2)", "DHex Hex(5) HexA HexNAc(3) Sulf(2).", false},
    {UNIMOD_Hex_3_HexNAc_7_, "UNIMOD:1540", "Hex(3)HexNAc(7)", "Hex(3) HexNAc(7).", false},
    {UNIMOD_dHex_2_Hex_5_HexNAc_4_, "UNIMOD:1541", "dHex(2)Hex(5)HexNAc(4)", "DHex(2) Hex(5) HexNAc(4).", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1542", "dHex(2)Hex(4)HexNAc(3)NeuAc(1)Sulf(1)", "DHex(2) Hex(4) HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_Sulf_2_, "UNIMOD:1543", "dHex(1)Hex(5)HexNAc(4)Sulf(2)", "DHex Hex(5) HexNAc(4) Sulf(2).", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_4_Me_2_Pent_1_, "UNIMOD:1544", "dHex(1)Hex(5)HexNAc(4)Me(2)Pent(1)", "DHex Hex(5) HexNAc(4) Me(2) Pent.", false},
    {UNIMOD_Hex_5_HexNAc_4_NeuGc_1_, "UNIMOD:1545", "Hex(5)HexNAc(4)NeuGc(1)", "Hex(5) HexNAc(4) NeuGc.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_6_Sulf_1_, "UNIMOD:1546", "dHex(1)Hex(3)HexNAc(6)Sulf(1)", "DHex Hex(3) HexNAc(6) Sulf.", false},
    {UNIMOD_dHex_1_Hex_6_HexNAc_4_, "UNIMOD:1547", "dHex(1)Hex(6)HexNAc(4)", "DHex Hex(6) HexNAc(4).", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1548", "dHex(1)Hex(5)HexNAc(3)NeuAc(1)Sulf(1)", "DHex Hex(5) HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_Hex_7_HexNAc_4_, "UNIMOD:1549", "Hex(7)HexNAc(4)", "Hex(7) HexNAc(4).", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_3_NeuGc_1_Sulf_1_, "UNIMOD:1550", "dHex(1)Hex(5)HexNAc(3)NeuGc(1)Sulf(1)", "DHex Hex(5) HexNAc(3) NeuGc Sulf.", false},
    {UNIMOD_Hex_4_HexNAc_5_NeuAc_1_, "UNIMOD:1551", "Hex(4)HexNAc(5)NeuAc(1)", "Hex(4) HexNAc(5) NeuAc.", false},
    {UNIMOD_Hex_6_HexNAc_4_Me_3_Pent_1_, "UNIMOD:1552", "Hex(6)HexNAc(4)Me(3)Pent(1)", "Hex(6) HexNAc(4) Me(3) Pent.", false},
    {UNIMOD_dHex_1_Hex_7_HexNAc_3_Sulf_1_, "UNIMOD:1553", "dHex(1)Hex(7)HexNAc(3)Sulf(1)", "DHex Hex(7) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_1_Hex_7_HexNAc_3_Phos_1_, "UNIMOD:1554", "dHex(1)Hex(7)HexNAc(3)Phos(1)", "DHex Hex(7) HexNAc(3) Phos.", false},
    {UNIMOD_dHex_1_Hex_5_HexNAc_5_, "UNIMOD:1555", "dHex(1)Hex(5)HexNAc(5)", "DHex Hex(5) HexNAc(5).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_4_NeuAc_1_Sulf_1_, "UNIMOD:1556", "dHex(1)Hex(4)HexNAc(4)NeuAc(1)Sulf(1)", "DHex Hex(4) HexNAc(4) NeuAc Sulf.", false},
    {UNIMOD_dHex_3_Hex_4_HexNAc_4_Sulf_1_, "UNIMOD:1557", "dHex(3)Hex(4)HexNAc(4)Sulf(1)", "DHex(3) Hex(4) HexNAc(4) Sulf.", false},
    {UNIMOD_Hex_3_HexNAc_7_Sulf_1_, "UNIMOD:1558", "Hex(3)HexNAc(7)Sulf(1)", "Hex(3) HexNAc(7) Sulf.", false},
    {UNIMOD_Hex_6_HexNAc_5_, "UNIMOD:1559", "Hex(6)HexNAc(5)", "A3G3.", false},
    {UNIMOD_Hex_5_HexNAc_4_NeuAc_1_Sulf_1_, "UNIMOD:1560", "Hex(5)HexNAc(4)NeuAc(1)Sulf(1)", "Hex(5) HexNAc(4) NeuAc Sulf.", false},
    {UNIMOD_Hex_3_HexNAc_6_NeuAc_1_, "UNIMOD:1561", "Hex(3)HexNAc(6)NeuAc(1)", "Hex(3) HexNAc(6) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_6_, "UNIMOD:1562", "dHex(2)Hex(3)HexNAc(6)", "DHex(2) Hex(3) HexNAc(6).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuGc_1_, "UNIMOD:1563", "Hex(1)HexNAc(1)NeuGc(1)", "Hex HexNAc NeuGc.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_1_, "UNIMOD:1564", "dHex(1)Hex(2)HexNAc(1)", "DHex Hex(2) HexNAc.", false},
    {UNIMOD_HexNAc_3_Sulf_1_, "UNIMOD:1565", "HexNAc(3)Sulf(1)", "HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_3_HexNAc_1_, "UNIMOD:1566", "Hex(3)HexNAc(1)", "Hex(3) HexNAc.", false},
    {UNIMOD_Hex_1_HexNAc_1_Kdn_1_Sulf_1_, "UNIMOD:1567", "Hex(1)HexNAc(1)Kdn(1)Sulf(1)", "Hex HexNAc Kdn Sulf.", false},
    {UNIMOD_HexNAc_2_NeuAc_1_, "UNIMOD:1568", "HexNAc(2)NeuAc(1)", "HexNAc(2) NeuAc.", false},
    {UNIMOD_HexNAc_1_Kdn_2_, "UNIMOD:1570", "HexNAc(1)Kdn(2)", "HexNAc Kdn(2) ---OR--- Hex(2) HexNAc HexA.", false},
    {UNIMOD_Hex_3_HexNAc_1_Me_1_, "UNIMOD:1571", "Hex(3)HexNAc(1)Me(1)", "Hex(3) HexNAc Me.", false},
    {UNIMOD_Hex_2_HexA_1_Pent_1_Sulf_1_, "UNIMOD:1572", "Hex(2)HexA(1)Pent(1)Sulf(1)", "Hex(2) HexA Pent Sulf.", false},
    {UNIMOD_HexNAc_2_NeuGc_1_, "UNIMOD:1573", "HexNAc(2)NeuGc(1)", "HexNAc(2) NeuGc.", false},
    {UNIMOD_Hex_4_Phos_1_, "UNIMOD:1575", "Hex(4)Phos(1)", "Hex(4) Phos.", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_1_Sulf_1_, "UNIMOD:1577", "Hex(1)HexNAc(1)NeuAc(1)Sulf(1)", "Hex HexNAc NeuAc Sulf.", false},
    {UNIMOD_Hex_1_HexA_1_HexNAc_2_, "UNIMOD:1578", "Hex(1)HexA(1)HexNAc(2)", "Hex HexA HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_1_Sulf_1_, "UNIMOD:1579", "dHex(1)Hex(2)HexNAc(1)Sulf(1)", "DHex Hex(2) HexNAc Sulf.", false},
    {UNIMOD_dHex_1_HexNAc_3_, "UNIMOD:1580", "dHex(1)HexNAc(3)", "DHex HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_1_Kdn_1_, "UNIMOD:1581", "dHex(1)Hex(1)HexNAc(1)Kdn(1)", "DHex Hex HexNAc Kdn ---OR--- Hex(2) dHex NeuAc.", false},
    {UNIMOD_Hex_1_HexNAc_3_, "UNIMOD:1582", "Hex(1)HexNAc(3)", "Hex HexNAc(3).", false},
    {UNIMOD_HexNAc_2_NeuAc_1_Sulf_1_, "UNIMOD:1583", "HexNAc(2)NeuAc(1)Sulf(1)", "HexNAc(2) NeuAc Sulf.", false},
    {UNIMOD_dHex_2_Hex_3_, "UNIMOD:1584", "dHex(2)Hex(3)", "DHex(2) Hex(3).", false},
    {UNIMOD_Hex_2_HexA_1_HexNAc_1_Sulf_1_, "UNIMOD:1585", "Hex(2)HexA(1)HexNAc(1)Sulf(1)", "Hex(2) HexA HexNAc Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexA_1_, "UNIMOD:1586", "dHex(2)Hex(2)HexA(1)", "DHex(2) Hex(2) HexA.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_2_Sulf_1_, "UNIMOD:1587", "dHex(1)Hex(1)HexNAc(2)Sulf(1)", "DHex Hex HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_1_NeuAc_1_, "UNIMOD:1588", "dHex(1)Hex(1)HexNAc(1)NeuAc(1)", "DHex Hex HexNAc NeuAc.", false},
    {UNIMOD_Hex_2_HexNAc_2_Sulf_1_, "UNIMOD:1589", "Hex(2)HexNAc(2)Sulf(1)", "Hex(2) HexNAc(2) Sulf.", false},
    {UNIMOD_Hex_5_, "UNIMOD:1590", "Hex(5)", "Hex(5).", false},
    {UNIMOD_HexNAc_4_, "UNIMOD:1591", "HexNAc(4)", "HexNAc(4).", false},
    {UNIMOD_HexNAc_1_NeuGc_2_, "UNIMOD:1592", "HexNAc(1)NeuGc(2)", "HexNAc NeuGc(2).", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_1_NeuGc_1_, "UNIMOD:1593", "dHex(1)Hex(1)HexNAc(1)NeuGc(1)", "DHex Hex HexNAc NeuGc ---OR--- Hex(2) HexNAc NeuAc.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_1_, "UNIMOD:1594", "dHex(2)Hex(2)HexNAc(1)", "DHex(2) Hex(2) HexNAc.", false},
    {UNIMOD_Hex_2_HexNAc_1_NeuGc_1_, "UNIMOD:1595", "Hex(2)HexNAc(1)NeuGc(1)", "Hex(2) HexNAc NeuGc.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_1_, "UNIMOD:1596", "dHex(1)Hex(3)HexNAc(1)", "DHex Hex(3) HexNAc.", false},
    {UNIMOD_dHex_1_Hex_2_HexA_1_HexNAc_1_, "UNIMOD:1597", "dHex(1)Hex(2)HexA(1)HexNAc(1)", "DHex Hex(2) HexA HexNAc.", false},
    {UNIMOD_Hex_1_HexNAc_3_Sulf_1_, "UNIMOD:1598", "Hex(1)HexNAc(3)Sulf(1)", "Hex HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_4_HexNAc_1_, "UNIMOD:1599", "Hex(4)HexNAc(1)", "Hex(4) HexNAc.", false},
    {UNIMOD_Hex_1_HexNAc_2_NeuAc_1_, "UNIMOD:1600", "Hex(1)HexNAc(2)NeuAc(1)", "Hex HexNAc(2) NeuAc.", false},
    {UNIMOD_Hex_1_HexNAc_2_NeuGc_1_, "UNIMOD:1602", "Hex(1)HexNAc(2)NeuGc(1)", "Hex HexNAc(2) NeuGc.", false},
    {UNIMOD_Hex_5_Phos_1_, "UNIMOD:1604", "Hex(5)Phos(1)", "Hex(5) Phos.", false},
    {UNIMOD_dHex_2_Hex_1_HexNAc_1_Kdn_1_, "UNIMOD:1606", "dHex(2)Hex(1)HexNAc(1)Kdn(1)", "DHex(2) Hex HexNAc Kdn.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_1_Sulf_1_, "UNIMOD:1607", "dHex(1)Hex(3)HexNAc(1)Sulf(1)", "DHex Hex(3) HexNAc Sulf.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_3_, "UNIMOD:1608", "dHex(1)Hex(1)HexNAc(3)", "DHex Hex HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_2_HexA_1_HexNAc_1_Sulf_1_, "UNIMOD:1609", "dHex(1)Hex(2)HexA(1)HexNAc(1)Sulf(1)", "DHex Hex(2) HexA HexNAc Sulf.", false},
    {UNIMOD_Hex_2_HexNAc_3_, "UNIMOD:1610", "Hex(2)HexNAc(3)", "Hex(2) HexNAc(3).", false},
    {UNIMOD_Hex_1_HexNAc_2_NeuAc_1_Sulf_1_, "UNIMOD:1611", "Hex(1)HexNAc(2)NeuAc(1)Sulf(1)", "Hex HexNAc(2) NeuAc Sulf.", false},
    {UNIMOD_dHex_2_Hex_4_, "UNIMOD:1612", "dHex(2)Hex(4)", "DHex(2) Hex(4).", false},
    {UNIMOD_dHex_2_HexNAc_2_Kdn_1_, "UNIMOD:1614", "dHex(2)HexNAc(2)Kdn(1)", "DHex(2) HexNAc(2) Kdn.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_Sulf_1_, "UNIMOD:1615", "dHex(1)Hex(2)HexNAc(2)Sulf(1)", "DHex Hex(2) HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_1_HexNAc_4_, "UNIMOD:1616", "dHex(1)HexNAc(4)", "DHex HexNAc(4).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_1_NeuGc_1_, "UNIMOD:1617", "Hex(1)HexNAc(1)NeuAc(1)NeuGc(1)", "Hex HexNAc NeuAc NeuGc.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_2_Kdn_1_, "UNIMOD:1618", "dHex(1)Hex(1)HexNAc(2)Kdn(1)", "DHex Hex HexNAc(2) Kdn ---OR--- Hex(2) HexNAc dHex NeuAc.", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuGc_2_, "UNIMOD:1619", "Hex(1)HexNAc(1)NeuGc(2)", "Hex HexNAc NeuGc(2).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_2_Ac_1_, "UNIMOD:1620", "Hex(1)HexNAc(1)NeuAc(2)Ac(1)", "Ac Hex HexNAc NeuAc(2).", false},
    {UNIMOD_dHex_2_Hex_2_HexA_1_HexNAc_1_, "UNIMOD:1621", "dHex(2)Hex(2)HexA(1)HexNAc(1)", "DHex(2) Hex(2) HexA HexNAc.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_3_Sulf_1_, "UNIMOD:1622", "dHex(1)Hex(1)HexNAc(3)Sulf(1)", "DHex Hex HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_2_HexA_1_NeuAc_1_Pent_1_Sulf_1_, "UNIMOD:1623", "Hex(2)HexA(1)NeuAc(1)Pent(1)Sulf(1)", "Hex(2) HexA NeuAc Pent Sulf.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_2_NeuAc_1_, "UNIMOD:1624", "dHex(1)Hex(1)HexNAc(2)NeuAc(1)", "DHex Hex HexNAc(2) NeuAc.", false},
    {UNIMOD_dHex_1_Hex_3_HexA_1_HexNAc_1_, "UNIMOD:1625", "dHex(1)Hex(3)HexA(1)HexNAc(1)", "DHex Hex(3) HexA HexNAc.", false},
    {UNIMOD_Hex_2_HexNAc_3_Sulf_1_, "UNIMOD:1626", "Hex(2)HexNAc(3)Sulf(1)", "Hex(2) HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_5_HexNAc_1_, "UNIMOD:1627", "Hex(5)HexNAc(1)", "Hex(5) HexNAc.", false},
    {UNIMOD_HexNAc_5_, "UNIMOD:1628", "HexNAc(5)", "HexNAc(5).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_2_Ac_2_, "UNIMOD:1630", "Hex(1)HexNAc(1)NeuAc(2)Ac(2)", "Ac(2) Hex HexNAc NeuAc(2).", false},
    {UNIMOD_Hex_2_HexNAc_2_NeuGc_1_, "UNIMOD:1631", "Hex(2)HexNAc(2)NeuGc(1)", "Hex(2) HexNAc(2) NeuGc.", false},
    {UNIMOD_Hex_5_Phos_3_, "UNIMOD:1632", "Hex(5)Phos(3)", "Hex(5) Phos(3).", false},
    {UNIMOD_Hex_6_Phos_1_, "UNIMOD:1633", "Hex(6)Phos(1)", "Hex(6) Phos.", false},
    {UNIMOD_dHex_1_Hex_2_HexA_1_HexNAc_2_, "UNIMOD:1634", "dHex(1)Hex(2)HexA(1)HexNAc(2)", "DHex Hex(2) HexA HexNAc(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_1_Sulf_1_, "UNIMOD:1635", "dHex(2)Hex(3)HexNAc(1)Sulf(1)", "DHex(2) Hex(3) HexNAc Sulf.", false},
    {UNIMOD_Hex_1_HexNAc_3_NeuAc_1_, "UNIMOD:1636", "Hex(1)HexNAc(3)NeuAc(1)", "Hex HexNAc(3) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_1_HexNAc_3_, "UNIMOD:1637", "dHex(2)Hex(1)HexNAc(3)", "DHex(2) Hex HexNAc(3).", false},
    {UNIMOD_Hex_1_HexNAc_3_NeuGc_1_, "UNIMOD:1638", "Hex(1)HexNAc(3)NeuGc(1)", "Hex HexNAc(3) NeuGc.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_2_NeuAc_1_Sulf_1_, "UNIMOD:1639", "dHex(1)Hex(1)HexNAc(2)NeuAc(1)Sulf(1)", "DHex Hex HexNAc(2) NeuAc Sulf.", false},
    {UNIMOD_dHex_1_Hex_3_HexA_1_HexNAc_1_Sulf_1_, "UNIMOD:1640", "dHex(1)Hex(3)HexA(1)HexNAc(1)Sulf(1)", "DHex Hex(3) HexA HexNAc Sulf.", false},
    {UNIMOD_dHex_1_Hex_1_HexA_1_HexNAc_3_, "UNIMOD:1641", "dHex(1)Hex(1)HexA(1)HexNAc(3)", "DHex Hex HexA HexNAc(3).", false},
    {UNIMOD_Hex_2_HexNAc_2_NeuAc_1_Sulf_1_, "UNIMOD:1642", "Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "Hex(2) HexNAc(2) NeuAc Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_Sulf_1_, "UNIMOD:1643", "dHex(2)Hex(2)HexNAc(2)Sulf(1)", "DHex(2) Hex(2) HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_2_Hex_1_HexNAc_2_Kdn_1_, "UNIMOD:1644", "dHex(2)Hex(1)HexNAc(2)Kdn(1)", "DHex(2) Hex HexNAc(2) Kdn ---OR--- Hex(2) HexNAc dHex(2) NeuAc.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_4_, "UNIMOD:1645", "dHex(1)Hex(1)HexNAc(4)", "DHex Hex HexNAc(4).", false},
    {UNIMOD_Hex_2_HexNAc_4_, "UNIMOD:1646", "Hex(2)HexNAc(4)", "Hex(2) HexNAc(4).", false},
    {UNIMOD_Hex_2_HexNAc_1_NeuGc_2_, "UNIMOD:1647", "Hex(2)HexNAc(1)NeuGc(2)", "Hex(2) HexNAc NeuGc(2).", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_1_, "UNIMOD:1648", "dHex(2)Hex(4)HexNAc(1)", "DHex(2) Hex(4) HexNAc.", false},
    {UNIMOD_Hex_1_HexNAc_2_NeuAc_2_, "UNIMOD:1649", "Hex(1)HexNAc(2)NeuAc(2)", "Hex HexNAc(2) NeuAc(2).", false},
    {UNIMOD_dHex_2_Hex_1_HexNAc_2_NeuAc_1_, "UNIMOD:1650", "dHex(2)Hex(1)HexNAc(2)NeuAc(1)", "DHex(2) Hex HexNAc(2) NeuAc.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_3_Sulf_1_, "UNIMOD:1651", "dHex(1)Hex(2)HexNAc(3)Sulf(1)", "DHex Hex(2) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_1_HexNAc_5_, "UNIMOD:1652", "dHex(1)HexNAc(5)", "DHex HexNAc(5).", false},
    {UNIMOD_dHex_2_Hex_1_HexNAc_2_NeuGc_1_, "UNIMOD:1653", "dHex(2)Hex(1)HexNAc(2)NeuGc(1)", "DHex(2) Hex HexNAc(2) NeuGc ---OR--- Hex(2) HexNAc(2) dHex NeuAc ---OR--- Hex HexNAc(3) dHex Kdn.", false},
    {UNIMOD_dHex_3_Hex_2_HexNAc_2_, "UNIMOD:1654", "dHex(3)Hex(2)HexNAc(2)", "DHex(3) Hex(2) HexNAc(2).", false},
    {UNIMOD_Hex_3_HexNAc_3_Sulf_1_, "UNIMOD:1655", "Hex(3)HexNAc(3)Sulf(1)", "Hex(3) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_Sulf_2_, "UNIMOD:1656", "dHex(2)Hex(2)HexNAc(2)Sulf(2)", "DHex(2) Hex(2) HexNAc(2) Sulf(2).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_NeuGc_1_, "UNIMOD:1657", "dHex(1)Hex(2)HexNAc(2)NeuGc(1)", "DHex Hex(2) HexNAc(2) NeuGc ---OR--- Hex(3) HexNAc(2) NeuAc.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_3_NeuAc_1_, "UNIMOD:1658", "dHex(1)Hex(1)HexNAc(3)NeuAc(1)", "DHex Hex HexNAc(3) NeuAc.", false},
    {UNIMOD_Hex_6_Phos_3_, "UNIMOD:1659", "Hex(6)Phos(3)", "Hex(6) Phos(3).", false},
    {UNIMOD_dHex_1_Hex_3_HexA_1_HexNAc_2_, "UNIMOD:1660", "dHex(1)Hex(3)HexA(1)HexNAc(2)", "DHex Hex(3) HexA HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_3_NeuGc_1_, "UNIMOD:1661", "dHex(1)Hex(1)HexNAc(3)NeuGc(1)", "DHex Hex HexNAc(3) NeuGc ---OR--- Hex(2) HexNAc(3) NeuAc.", false},
    {UNIMOD_Hex_1_HexNAc_2_NeuAc_2_Sulf_1_, "UNIMOD:1662", "Hex(1)HexNAc(2)NeuAc(2)Sulf(1)", "Hex HexNAc(2) NeuAc(2) Sulf.", false},
    {UNIMOD_dHex_2_Hex_3_HexA_1_HexNAc_1_Sulf_1_, "UNIMOD:1663", "dHex(2)Hex(3)HexA(1)HexNAc(1)Sulf(1)", "DHex(2) Hex(3) HexA HexNAc Sulf.", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_3_, "UNIMOD:1664", "Hex(1)HexNAc(1)NeuAc(3)", "Hex HexNAc NeuAc(3).", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuGc_1_, "UNIMOD:1665", "Hex(2)HexNAc(3)NeuGc(1)", "Hex(2) HexNAc(3) NeuGc.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_NeuAc_1_Sulf_1_, "UNIMOD:1666", "dHex(1)Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "DHex Hex(2) HexNAc(2) NeuAc Sulf.", false},
    {UNIMOD_dHex_3_Hex_1_HexNAc_2_Kdn_1_, "UNIMOD:1667", "dHex(3)Hex(1)HexNAc(2)Kdn(1)", "DHex(3) Hex HexNAc(2) Kdn.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_2_Sulf_1_, "UNIMOD:1668", "dHex(2)Hex(3)HexNAc(2)Sulf(1)", "DHex(2) Hex(3) HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_Kdn_1_, "UNIMOD:1669", "dHex(2)Hex(2)HexNAc(2)Kdn(1)", "DHex(2) Hex(2) HexNAc(2) Kdn.", false},
    {UNIMOD_dHex_2_Hex_2_HexA_1_HexNAc_2_Sulf_1_, "UNIMOD:1670", "dHex(2)Hex(2)HexA(1)HexNAc(2)Sulf(1)", "DHex(2) Hex(2) HexA HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_4_, "UNIMOD:1671", "dHex(1)Hex(2)HexNAc(4)", "DHex Hex(2) HexNAc(4).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuGc_3_, "UNIMOD:1672", "Hex(1)HexNAc(1)NeuGc(3)", "Hex HexNAc NeuGc(3).", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1673", "dHex(1)Hex(1)HexNAc(3)NeuAc(1)Sulf(1)", "DHex Hex HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_dHex_1_Hex_3_HexA_1_HexNAc_2_Sulf_1_, "UNIMOD:1674", "dHex(1)Hex(3)HexA(1)HexNAc(2)Sulf(1)", "DHex Hex(3) HexA HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_1_Hex_1_HexNAc_2_NeuAc_2_, "UNIMOD:1675", "dHex(1)Hex(1)HexNAc(2)NeuAc(2)", "DHex Hex HexNAc(2) NeuAc(2).", false},
    {UNIMOD_dHex_3_HexNAc_3_Kdn_1_, "UNIMOD:1676", "dHex(3)HexNAc(3)Kdn(1)", "DHex(3) HexNAc(3) Kdn.", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1678", "Hex(2)HexNAc(3)NeuAc(1)Sulf(1)", "Hex(2) HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_3_Sulf_1_, "UNIMOD:1679", "dHex(2)Hex(2)HexNAc(3)Sulf(1)", "DHex(2) Hex(2) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_2_HexNAc_5_, "UNIMOD:1680", "dHex(2)HexNAc(5)", "DHex(2) HexNAc(5).", false},
    {UNIMOD_Hex_2_HexNAc_2_NeuAc_2_, "UNIMOD:1681", "Hex(2)HexNAc(2)NeuAc(2)", "Hex(2) HexNAc(2) NeuAc(2).", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_NeuAc_1_, "UNIMOD:1682", "dHex(2)Hex(2)HexNAc(2)NeuAc(1)", "DHex(2) Hex(2) HexNAc(2) NeuAc ---OR--- Hex HexNAc(3) dHex(2) Kdn.", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_3_Sulf_1_, "UNIMOD:1683", "dHex(1)Hex(3)HexNAc(3)Sulf(1)", "DHex Hex(3) HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_NeuGc_1_, "UNIMOD:1684", "dHex(2)Hex(2)HexNAc(2)NeuGc(1)", "DHex(2) Hex(2) HexNAc(2) NeuGc ---OR--- Hex(3) HexNAc(2) dHex NeuAc ---OR--- Hex(2) HexNAc(3) dHex Kdn.", false},
    {UNIMOD_Hex_2_HexNAc_5_, "UNIMOD:1685", "Hex(2)HexNAc(5)", "Hex(2) HexNAc(5).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_2_NeuGc_1_, "UNIMOD:1686", "dHex(1)Hex(3)HexNAc(2)NeuGc(1)", "DHex Hex(3) HexNAc(2) NeuGc.", false},
    {UNIMOD_Hex_1_HexNAc_3_NeuAc_2_, "UNIMOD:1687", "Hex(1)HexNAc(3)NeuAc(2)", "Hex HexNAc(3) NeuAc(2).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_3_NeuAc_1_, "UNIMOD:1688", "dHex(1)Hex(2)HexNAc(3)NeuAc(1)", "DHex Hex(2) HexNAc(3) NeuAc.", false},
    {UNIMOD_dHex_3_Hex_2_HexNAc_3_, "UNIMOD:1689", "dHex(3)Hex(2)HexNAc(3)", "DHex(3) Hex(2) HexNAc(3).", false},
    {UNIMOD_Hex_7_Phos_3_, "UNIMOD:1690", "Hex(7)Phos(3)", "Hex(7) Phos(3).", false},
    {UNIMOD_dHex_1_Hex_4_HexA_1_HexNAc_2_, "UNIMOD:1691", "dHex(1)Hex(4)HexA(1)HexNAc(2)", "DHex Hex(4) HexA HexNAc(2).", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuAc_1_, "UNIMOD:1692", "Hex(3)HexNAc(3)NeuAc(1)", "Hex(3) HexNAc(3) NeuAc ---OR--- Hex(2) HexNAc(3) dHex NeuGc ---OR--- Hex(2) HexNAc(4) Kdn.", false},
    {UNIMOD_dHex_1_Hex_3_HexA_2_HexNAc_2_, "UNIMOD:1693", "dHex(1)Hex(3)HexA(2)HexNAc(2)", "DHex Hex(3) HexA(2) HexNAc(2).", false},
    {UNIMOD_Hex_2_HexNAc_2_NeuAc_2_Sulf_1_, "UNIMOD:1694", "Hex(2)HexNAc(2)NeuAc(2)Sulf(1)", "Hex(2) HexNAc(2) NeuAc(2) Sulf.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_NeuAc_1_Sulf_1_, "UNIMOD:1695", "dHex(2)Hex(2)HexNAc(2)NeuAc(1)Sulf(1)", "DHex(2) Hex(2) HexNAc(2) NeuAc Sulf.", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuGc_1_, "UNIMOD:1696", "Hex(3)HexNAc(3)NeuGc(1)", "Hex(3) HexNAc(3) NeuGc.", false},
    {UNIMOD_dHex_4_Hex_1_HexNAc_2_Kdn_1_, "UNIMOD:1697", "dHex(4)Hex(1)HexNAc(2)Kdn(1)", "DHex(4) Hex HexNAc(2) Kdn.", false},
    {UNIMOD_dHex_3_Hex_2_HexNAc_2_Kdn_1_, "UNIMOD:1698", "dHex(3)Hex(2)HexNAc(2)Kdn(1)", "DHex(3) Hex(2) HexNAc(2) Kdn.", false},
    {UNIMOD_dHex_3_Hex_2_HexA_1_HexNAc_2_Sulf_1_, "UNIMOD:1699", "dHex(3)Hex(2)HexA(1)HexNAc(2)Sulf(1)", "DHex(3) Hex(2) HexA HexNAc(2) Sulf.", false},
    {UNIMOD_Hex_2_HexNAc_4_NeuAc_1_, "UNIMOD:1700", "Hex(2)HexNAc(4)NeuAc(1)", "Hex(2) HexNAc(4) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_4_, "UNIMOD:1701", "dHex(2)Hex(2)HexNAc(4)", "DHex(2) Hex(2) HexNAc(4).", false},
    {UNIMOD_dHex_2_Hex_3_HexA_1_HexNAc_2_Sulf_1_, "UNIMOD:1702", "dHex(2)Hex(3)HexA(1)HexNAc(2)Sulf(1)", "DHex(2) Hex(3) HexA HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_4_HexNAc_3_Kdn_1_, "UNIMOD:1703", "dHex(4)HexNAc(3)Kdn(1)", "DHex(4) HexNAc(3) Kdn.", false},
    {UNIMOD_Hex_2_HexNAc_1_NeuGc_3_, "UNIMOD:1705", "Hex(2)HexNAc(1)NeuGc(3)", "Hex(2) HexNAc NeuGc(3).", false},
    {UNIMOD_dHex_4_Hex_1_HexNAc_1_Kdn_2_, "UNIMOD:1706", "dHex(4)Hex(1)HexNAc(1)Kdn(2)", "DHex(4) Hex HexNAc Kdn(2).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1707", "dHex(1)Hex(2)HexNAc(3)NeuAc(1)Sulf(1)", "DHex Hex(2) HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_NeuAc_2_, "UNIMOD:1708", "dHex(1)Hex(2)HexNAc(2)NeuAc(2)", "DHex Hex(2) HexNAc(2) NeuAc(2).", false},
    {UNIMOD_dHex_3_Hex_1_HexNAc_3_Kdn_1_, "UNIMOD:1709", "dHex(3)Hex(1)HexNAc(3)Kdn(1)", "DHex(3) Hex HexNAc(3) Kdn.", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuAc_1_Sulf_1_, "UNIMOD:1711", "Hex(3)HexNAc(3)NeuAc(1)Sulf(1)", "Hex(3) HexNAc(3) NeuAc Sulf.", false},
    {UNIMOD_Hex_3_HexNAc_2_NeuAc_2_, "UNIMOD:1712", "Hex(3)HexNAc(2)NeuAc(2)", "Hex(3) HexNAc(2) NeuAc(2).", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuGc_1_Sulf_1_, "UNIMOD:1713", "Hex(3)HexNAc(3)NeuGc(1)Sulf(1)", "Hex(3) HexNAc(3) NeuGc Sulf.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_NeuGc_2_, "UNIMOD:1714", "dHex(1)Hex(2)HexNAc(2)NeuGc(2)", "DHex Hex(2) HexNAc(2) NeuGc(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_2_NeuGc_1_, "UNIMOD:1715", "dHex(2)Hex(3)HexNAc(2)NeuGc(1)", "DHex(2) Hex(3) HexNAc(2) NeuGc ---OR--- Hex(4) HexNAc(2) dHex NeuAc.", false},
    {UNIMOD_dHex_1_Hex_3_HexA_1_HexNAc_3_Sulf_1_, "UNIMOD:1716", "dHex(1)Hex(3)HexA(1)HexNAc(3)Sulf(1)", "DHex Hex(3) HexA HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuAc_2_, "UNIMOD:1717", "Hex(2)HexNAc(3)NeuAc(2)", "Hex(2) HexNAc(3) NeuAc(2).", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_3_NeuAc_1_, "UNIMOD:1718", "dHex(2)Hex(2)HexNAc(3)NeuAc(1)", "DHex(2) Hex(2) HexNAc(3) NeuAc.", false},
    {UNIMOD_dHex_4_Hex_2_HexNAc_3_, "UNIMOD:1719", "dHex(4)Hex(2)HexNAc(3)", "DHex(4) Hex(2) HexNAc(3).", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuAc_1_NeuGc_1_, "UNIMOD:1720", "Hex(2)HexNAc(3)NeuAc(1)NeuGc(1)", "Hex(2) HexNAc(3) NeuAc NeuGc.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_3_NeuGc_1_, "UNIMOD:1721", "dHex(2)Hex(2)HexNAc(3)NeuGc(1)", "DHex(2) Hex(2) HexNAc(3) NeuGc ---OR--- Hex(3) HexNAc(3) dHex NeuAc ---OR--- Hex(2) HexNAc(4) dHex Kdn.", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_3_, "UNIMOD:1722", "dHex(3)Hex(3)HexNAc(3)", "DHex(3) Hex(3) HexNAc(3).", false},
    {UNIMOD_Hex_8_Phos_3_, "UNIMOD:1723", "Hex(8)Phos(3)", "Hex(8) Phos(3).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_NeuAc_2_Sulf_1_, "UNIMOD:1724", "dHex(1)Hex(2)HexNAc(2)NeuAc(2)Sulf(1)", "DHex Hex(2) HexNAc(2) NeuAc(2) Sulf.", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuGc_2_, "UNIMOD:1725", "Hex(2)HexNAc(3)NeuGc(2)", "Hex(2) HexNAc(3) NeuGc(2).", false},
    {UNIMOD_dHex_4_Hex_2_HexNAc_2_Kdn_1_, "UNIMOD:1726", "dHex(4)Hex(2)HexNAc(2)Kdn(1)", "DHex(4) Hex(2) HexNAc(2) Kdn.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_4_NeuAc_1_, "UNIMOD:1727", "dHex(1)Hex(2)HexNAc(4)NeuAc(1)", "DHex Hex(2) HexNAc(4) NeuAc.", false},
    {UNIMOD_dHex_3_Hex_2_HexNAc_4_, "UNIMOD:1728", "dHex(3)Hex(2)HexNAc(4)", "DHex(3) Hex(2) HexNAc(4).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuGc_4_, "UNIMOD:1729", "Hex(1)HexNAc(1)NeuGc(4)", "Hex HexNAc NeuGc(4).", false},
    {UNIMOD_dHex_4_Hex_1_HexNAc_3_Kdn_1_, "UNIMOD:1730", "dHex(4)Hex(1)HexNAc(3)Kdn(1)", "DHex(4) Hex HexNAc(3) Kdn.", false},
    {UNIMOD_Hex_4_HexNAc_4_Sulf_2_, "UNIMOD:1732", "Hex(4)HexNAc(4)Sulf(2)", "Hex(4) HexNAc(4) Sulf(2).", false},
    {UNIMOD_dHex_3_Hex_2_HexNAc_3_Kdn_1_, "UNIMOD:1733", "dHex(3)Hex(2)HexNAc(3)Kdn(1)", "DHex(3) Hex(2) HexNAc(3) Kdn ---OR--- Hex(3) HexNAc(2) dHex(3) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_5_, "UNIMOD:1735", "dHex(2)Hex(2)HexNAc(5)", "DHex(2) Hex(2) HexNAc(5).", false},
    {UNIMOD_dHex_2_Hex_3_HexA_1_HexNAc_3_Sulf_1_, "UNIMOD:1736", "dHex(2)Hex(3)HexA(1)HexNAc(3)Sulf(1)", "DHex(2) Hex(3) HexA HexNAc(3) Sulf.", false},
    {UNIMOD_dHex_1_Hex_4_HexA_1_HexNAc_3_Sulf_1_, "UNIMOD:1737", "dHex(1)Hex(4)HexA(1)HexNAc(3)Sulf(1)", "DHex Hex(4) HexA HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuAc_2_, "UNIMOD:1738", "Hex(3)HexNAc(3)NeuAc(2)", "Hex(3) HexNAc(3) NeuAc(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_3_NeuAc_1_, "UNIMOD:1739", "dHex(2)Hex(3)HexNAc(3)NeuAc(1)", "DHex(2) Hex(3) HexNAc(3) NeuAc ---OR--- Hex(2) HexNAc(4) dHex(2) Kdn.", false},
    {UNIMOD_dHex_4_Hex_3_HexNAc_3_, "UNIMOD:1740", "dHex(4)Hex(3)HexNAc(3)", "DHex(4) Hex(3) HexNAc(3).", false},
    {UNIMOD_Hex_9_Phos_3_, "UNIMOD:1742", "Hex(9)Phos(3)", "Hex(9) Phos(3).", false},
    {UNIMOD_dHex_2_HexNAc_7_, "UNIMOD:1743", "dHex(2)HexNAc(7)", "DHex(2) HexNAc(7).", false},
    {UNIMOD_Hex_2_HexNAc_1_NeuGc_4_, "UNIMOD:1744", "Hex(2)HexNAc(1)NeuGc(4)", "Hex(2) HexNAc NeuGc(4).", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuAc_2_Sulf_1_, "UNIMOD:1745", "Hex(3)HexNAc(3)NeuAc(2)Sulf(1)", "Hex(3) HexNAc(3) NeuAc(2) Sulf.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_5_, "UNIMOD:1746", "dHex(2)Hex(3)HexNAc(5)", "DHex(2) Hex(3) HexNAc(5).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_2_NeuGc_3_, "UNIMOD:1747", "dHex(1)Hex(2)HexNAc(2)NeuGc(3)", "DHex Hex(2) HexNAc(2) NeuGc(3).", false},
    {UNIMOD_dHex_2_Hex_4_HexA_1_HexNAc_3_Sulf_1_, "UNIMOD:1748", "dHex(2)Hex(4)HexA(1)HexNAc(3)Sulf(1)", "DHex(2) Hex(4) HexA HexNAc(3) Sulf.", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuAc_3_, "UNIMOD:1749", "Hex(2)HexNAc(3)NeuAc(3)", "Hex(2) HexNAc(3) NeuAc(3).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_3_NeuAc_2_, "UNIMOD:1750", "dHex(1)Hex(3)HexNAc(3)NeuAc(2)", "DHex Hex(3) HexNAc(3) NeuAc(2).", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_3_NeuAc_1_, "UNIMOD:1751", "dHex(3)Hex(3)HexNAc(3)NeuAc(1)", "DHex(3) Hex(3) HexNAc(3) NeuAc.", false},
    {UNIMOD_Hex_2_HexNAc_3_NeuGc_3_, "UNIMOD:1752", "Hex(2)HexNAc(3)NeuGc(3)", "Hex(2) HexNAc(3) NeuGc(3).", false},
    {UNIMOD_Hex_10_Phos_3_, "UNIMOD:1753", "Hex(10)Phos(3)", "Hex(10) Phos(3).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_4_NeuAc_2_, "UNIMOD:1754", "dHex(1)Hex(2)HexNAc(4)NeuAc(2)", "DHex Hex(2) HexNAc(4) NeuAc(2).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuGc_5_, "UNIMOD:1755", "Hex(1)HexNAc(1)NeuGc(5)", "Hex HexNAc NeuGc(5).", false},
    {UNIMOD_Hex_4_HexNAc_4_NeuAc_1_Sulf_2_, "UNIMOD:1756", "Hex(4)HexNAc(4)NeuAc(1)Sulf(2)", "Hex(4) HexNAc(4) NeuAc Sulf(2).", false},
    {UNIMOD_Hex_4_HexNAc_4_NeuGc_1_Sulf_2_, "UNIMOD:1757", "Hex(4)HexNAc(4)NeuGc(1)Sulf(2)", "Hex(4) HexNAc(4) NeuGc Sulf(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_3_NeuAc_2_, "UNIMOD:1758", "dHex(2)Hex(3)HexNAc(3)NeuAc(2)", "DHex(2) Hex(3) HexNAc(3) NeuAc(2).", false},
    {UNIMOD_Hex_4_HexNAc_4_NeuAc_1_Sulf_3_, "UNIMOD:1759", "Hex(4)HexNAc(4)NeuAc(1)Sulf(3)", "Hex(4) HexNAc(4) NeuAc Sulf(3).", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_2_, "UNIMOD:1760", "dHex(2)Hex(2)HexNAc(2)", "DHex(2) Hex(2) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_2_, "UNIMOD:1761", "dHex(1)Hex(3)HexNAc(2)", "DHex Hex(3) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_3_, "UNIMOD:1762", "dHex(1)Hex(2)HexNAc(3)", "DHex Hex(2) HexNAc(3).", false},
    {UNIMOD_Hex_3_HexNAc_3_, "UNIMOD:1763", "Hex(3)HexNAc(3)", "Hex(3) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_2_Sulf_1_, "UNIMOD:1764", "dHex(1)Hex(3)HexNAc(2)Sulf(1)", "DHex Hex(3) HexNAc(2) Sulf.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_2_, "UNIMOD:1765", "dHex(2)Hex(3)HexNAc(2)", "DHex(2) Hex(3) HexNAc(2).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_2_, "UNIMOD:1766", "dHex(1)Hex(4)HexNAc(2)", "DHex Hex(4) HexNAc(2).", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_3_, "UNIMOD:1767", "dHex(2)Hex(2)HexNAc(3)", "DHex(2) Hex(2) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_3_, "UNIMOD:1768", "dHex(1)Hex(3)HexNAc(3)", "DHex Hex(3) HexNAc(3).", false},
    {UNIMOD_Hex_4_HexNAc_3_, "UNIMOD:1769", "Hex(4)HexNAc(3)", "Hex(4) HexNAc(3).", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_2_, "UNIMOD:1770", "dHex(2)Hex(4)HexNAc(2)", "DHex(2) Hex(4) HexNAc(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_3_, "UNIMOD:1771", "dHex(2)Hex(3)HexNAc(3)", "DHex(2) Hex(3) HexNAc(3).", false},
    {UNIMOD_Hex_3_HexNAc_5_, "UNIMOD:1772", "Hex(3)HexNAc(5)", "A3.", false},
    {UNIMOD_Hex_4_HexNAc_3_NeuAc_1_, "UNIMOD:1773", "Hex(4)HexNAc(3)NeuAc(1)", "Hex(4) HexNAc(3) NeuAc ---OR--- Hex(3) HexNAc(4) Kdn.", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_4_, "UNIMOD:1774", "dHex(2)Hex(3)HexNAc(4)", "DHex(2) Hex(3) HexNAc(4).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_5_, "UNIMOD:1775", "dHex(1)Hex(3)HexNAc(5)", "DHex Hex(3) HexNAc(5).", false},
    {UNIMOD_Hex_3_HexNAc_6_, "UNIMOD:1776", "Hex(3)HexNAc(6)", "A4.", false},
    {UNIMOD_Hex_4_HexNAc_4_NeuAc_1_, "UNIMOD:1777", "Hex(4)HexNAc(4)NeuAc(1)", "Hex(4) HexNAc(4) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_4_, "UNIMOD:1778", "dHex(2)Hex(4)HexNAc(4)", "DHex(2) Hex(4) HexNAc(4) ---OR--- Hex(4) HexNAc(4) dHex Pent Me.", false},
    {UNIMOD_Hex_6_HexNAc_4_, "UNIMOD:1779", "Hex(6)HexNAc(4)", "Hex(6) HexNAc(4).", false},
    {UNIMOD_Hex_5_HexNAc_5_, "UNIMOD:1780", "Hex(5)HexNAc(5)", "Hex(5) HexNAc(5).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_6_, "UNIMOD:1781", "dHex(1)Hex(3)HexNAc(6)", "DHex Hex(3) HexNAc(6).", false},
    {UNIMOD_dHex_1_Hex_4_HexNAc_4_NeuAc_1_, "UNIMOD:1782", "dHex(1)Hex(4)HexNAc(4)NeuAc(1)", "DHex Hex(4) HexNAc(4) NeuAc ---OR--- Hex(3) HexNAc(5) dHex Kdn.", false},
    {UNIMOD_dHex_3_Hex_4_HexNAc_4_, "UNIMOD:1783", "dHex(3)Hex(4)HexNAc(4)", "DHex(3) Hex(4) HexNAc(4).", false},
    {UNIMOD_dHex_1_Hex_3_HexNAc_5_NeuAc_1_, "UNIMOD:1784", "dHex(1)Hex(3)HexNAc(5)NeuAc(1)", "DHex Hex(3) HexNAc(5) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_4_HexNAc_5_, "UNIMOD:1785", "dHex(2)Hex(4)HexNAc(5)", "DHex(2) Hex(4) HexNAc(5).", false},
    {UNIMOD_Hex_1_HexNAc_1_NeuAc_1_Ac_1_, "UNIMOD:1786", "Hex(1)HexNAc(1)NeuAc(1)Ac(1)", "Ac Hex HexNAc NeuAc.", false},
    {UNIMOD_Label_13C_2_15N_2_, "UNIMOD:1787", "Label:13C(2)15N(2)", "13C(2) 15N(2).", false},
    {UNIMOD_Xlink_DSS_155_, "UNIMOD:1789", "Xlink:DSS[155]", "Ammonium-quenched monolink of DSS/BS3 crosslinker.", false},
    {UNIMOD_NQIGG, "UNIMOD:1799", "NQIGG", "SUMOylation by Giardia lamblia.", false},
    {UNIMOD_Carboxyethylpyrrole, "UNIMOD:1800", "Carboxyethylpyrrole", "Carboxyethylpyrrole.", false},
    {UNIMOD_Fluorescein_tyramine, "UNIMOD:1801", "Fluorescein-tyramine", "Fluorescein-tyramine adduct by peroxidase activity.", false},
    {UNIMOD_GEE, "UNIMOD:1824", "GEE", "Transamidation of glycine ethyl ester to glutamine.", false},
    {UNIMOD_RNPXL, "UNIMOD:1825", "RNPXL", "Simulate peptide-RNA conjugates.", false},
    {UNIMOD_Glu__pyro_Glu_Methyl, "UNIMOD:1826", "Glu->pyro-Glu+Methyl", "Pyro-Glu from E + Methylation.", false},
    {UNIMOD_Glu__pyro_Glu_Methyl_2H_2_13C_1_, "UNIMOD:1827", "Glu->pyro-Glu+Methyl:2H(2)13C(1)", "Pyro-Glu from E + Methylation Medium.", false},
    {UNIMOD_LRGG_methyl, "UNIMOD:1828", "LRGG+methyl", "LeumethylArgGlyGly.", false},
    {UNIMOD_LRGG_dimethyl, "UNIMOD:1829", "LRGG+dimethyl", "LeudimethylArgGlyGly.", false},
    {UNIMOD_Biotin_tyramide, "UNIMOD:1830", "Biotin-tyramide", "Biotin-Phenol.", false},
    {UNIMOD_Tris, "UNIMOD:1831", "Tris", "Tris adduct causes 104 Da addition at asparagine-succinimide intermediate.", false},
    {UNIMOD_IASD, "UNIMOD:1832", "IASD", "Iodoacetamide derivative of stilbene (reaction product with thiol).", false},
    {UNIMOD_NP40, "UNIMOD:1833", "NP40", "NP-40 synthetic polymer terminus.", false},
    {UNIMOD_Tween20, "UNIMOD:1834", "Tween20", "Tween 20 synthetic polymer terminus.", false},
    {UNIMOD_Tween80, "UNIMOD:1835", "Tween80", "Tween 80 synthetic polymer terminus.", false},
    {UNIMOD_Triton, "UNIMOD:1836", "Triton", "Triton synthetic polymer terminus.", false},
    {UNIMOD_Brij35, "UNIMOD:1837", "Brij35", "Brij 35 synthetic polymer terminus.", false},
    {UNIMOD_Brij58, "UNIMOD:1838", "Brij58", "Brij 58 synthetic polymer terminus.", false},
    {UNIMOD_betaFNA, "UNIMOD:1839", "betaFNA", "Beta-Funaltrexamine.", false},
    {UNIMOD_dHex_1_Hex_7_HexNAc_4_, "UNIMOD:1840", "dHex(1)Hex(7)HexNAc(4)", "Fucosylated biantennary + 2 alphaGal.", false},
    {UNIMOD_Biotin_Thermo_21328, "UNIMOD:1841", "Biotin:Thermo-21328", "EZ-Link Sulfo-NHS-SS-Biotin.", false},
    {UNIMOD_PhosphoCytidine, "UNIMOD:1843", "PhosphoCytidine", "Cytidine monophosphate.", false},
    {UNIMOD_AzidoF, "UNIMOD:1845", "AzidoF", "Azidophenylalanine.", false},
    {UNIMOD_Dimethylaminoethyl, "UNIMOD:1846", "Dimethylaminoethyl", "Cys alkylation by dimethylaminoethyl halide.", false},
    {UNIMOD_Gluratylation, "UNIMOD:1848", "Gluratylation", "Glutarylation.", false},
    {UNIMOD_hydroxyisobutyryl, "UNIMOD:1849", "hydroxyisobutyryl", "2-hydroxyisobutyrylation.", false},
    {UNIMOD_MeMePhosphorothioate, "UNIMOD:1868", "MeMePhosphorothioate", "S-Methyl Methyl phosphorothioate.", false},
    {UNIMOD_Cation_Fe_III_, "UNIMOD:1870", "Cation:Fe[III]", "Replacement of 3 protons by iron.", false},
    {UNIMOD_DTT, "UNIMOD:1871", "DTT", "DTT adduct of cysteine.", false},
    {UNIMOD_DYn_2, "UNIMOD:1872", "DYn-2", "Sulfenic Acid specific probe.", false},
    {UNIMOD_MesitylOxide, "UNIMOD:1873", "MesitylOxide", "Acetone chemical artifact.", false},
    {UNIMOD_methylol, "UNIMOD:1875", "methylol", "Formaldehyde induced modifications.", false},
    {UNIMOD_Xlink_DSS_259_, "UNIMOD:1877", "Xlink:DSS[259]", "Tris-quenched monolink of DSS/BS3 crosslinker.", false},
    {UNIMOD_Xlink_DSSO_176_, "UNIMOD:1878", "Xlink:DSSO[176]", "Water-quenched monolink of DSSO crosslinker.", false},
    {UNIMOD_Xlink_DSSO_175_, "UNIMOD:1879", "Xlink:DSSO[175]", "Ammonia-quenched monolink of DSSO crosslinker.", false},
    {UNIMOD_Xlink_DSSO_279_, "UNIMOD:1880", "Xlink:DSSO[279]", "Tris-quenched monolink of DSSO crosslinker.", false},
    {UNIMOD_Xlink_DSSO_54_, "UNIMOD:1881", "Xlink:DSSO[54]", "Alkene fragment of DSSO crosslinker.", false},
    {UNIMOD_Xlink_DSSO_86_, "UNIMOD:1882", "Xlink:DSSO[86]", "Thiol fragment of DSSO crosslinker.", false},
    {UNIMOD_Xlink_DSSO_104_, "UNIMOD:1883", "Xlink:DSSO[104]", "Sulfenic acid fragment of DSSO crosslinker.", false},
    {UNIMOD_Xlink_BuUrBu_111_, "UNIMOD:1885", "Xlink:BuUrBu[111]", "BuUr fragment of BuUrBu crosslinker.", false},
    {UNIMOD_Xlink_BuUrBu_85_, "UNIMOD:1886", "Xlink:BuUrBu[85]", "Bu fragment of BuUrBu crosslinker.", false},
    {UNIMOD_Xlink_BuUrBu_213_, "UNIMOD:1887", "Xlink:BuUrBu[213]", "Ammonia quenched monolink of BuUrBu crosslinker.", false},
    {UNIMOD_Xlink_BuUrBu_214_, "UNIMOD:1888", "Xlink:BuUrBu[214]", "Water quenched monolink of BuUrBu crosslinker.", false},
    {UNIMOD_Xlink_BuUrBu_317_, "UNIMOD:1889", "Xlink:BuUrBu[317]", "Tris quenched monolink of BuUrBu crosslinker.", false},
    {UNIMOD_Xlink_DSSO_158_, "UNIMOD:1896", "Xlink:DSSO[158]", "Intact DSSO crosslinker.", false},
    {UNIMOD_Xlink_EGS_226_, "UNIMOD:1897", "Xlink:EGS[226]", "Intact EGS cross-linker.", false},
    {UNIMOD_Xlink_DSS_138_, "UNIMOD:1898", "Xlink:DSS[138]", "Intact DSS/BS3 crosslinker.", false},
    {UNIMOD_Xlink_BuUrBu_196_, "UNIMOD:1899", "Xlink:BuUrBu[196]", "Intact BuUrBu crosslinker.", false},
    {UNIMOD_Xlink_DTBP_172_, "UNIMOD:1900", "Xlink:DTBP[172]", "Intact DTBP crosslinker.", false},
    {UNIMOD_Xlink_DST_114_, "UNIMOD:1901", "Xlink:DST[114]", "Intact DST crosslinker.", false},
    {UNIMOD_Xlink_DTSSP_174_, "UNIMOD:1902", "Xlink:DTSSP[174]", "Intact DSP/DTSSP crosslinker.", false},
    {UNIMOD_Xlink_SMCC_219_, "UNIMOD:1903", "Xlink:SMCC[219]", "Intact SMCC cross-link.", false},
    {UNIMOD_Xlink_BS2G_96_, "UNIMOD:1905", "Xlink:BS2G[96]", "Intact BS2-G crosslinker.", false},
    {UNIMOD_Xlink_BS2G_113_, "UNIMOD:1906", "Xlink:BS2G[113]", "Ammonium-quenched monolink of BS2-G crosslinker.", false},
    {UNIMOD_Xlink_BS2G_114_, "UNIMOD:1907", "Xlink:BS2G[114]", "Water-quenched monolink of BS2-G crosslinker.", false},
    {UNIMOD_Xlink_BS2G_217_, "UNIMOD:1908", "Xlink:BS2G[217]", "Tris-quenched monolink of BS2-G crosslinker.", false},
    {UNIMOD_Cation_Al_III_, "UNIMOD:1910", "Cation:Al[III]", "Replacement of 3 protons by aluminium.", false},
    {UNIMOD_Xlink_DMP_139_, "UNIMOD:1911", "Xlink:DMP[139]", "Ammonia quenched monolink of DMP crosslinker.", false},
    {UNIMOD_Xlink_DMP_122_, "UNIMOD:1912", "Xlink:DMP[122]", "Intact DMP crosslinker.", false},
    {UNIMOD_glyoxalAGE, "UNIMOD:1913", "glyoxalAGE", "Glyoxal-derived AGE.", false},
    {UNIMOD_Met__AspSA, "UNIMOD:1914", "Met->AspSA", "Methionine oxidation to aspartic semialdehyde.", false},
    {UNIMOD_Decarboxylation, "UNIMOD:1915", "Decarboxylation", "Decarboxylation.", false},
    {UNIMOD_Aspartylurea, "UNIMOD:1916", "Aspartylurea", "Aspartylurea.", false},
    {UNIMOD_Formylasparagine, "UNIMOD:1917", "Formylasparagine", "In Bachi as Formylaspargine (typo?).", false},
    {UNIMOD_Carbonyl, "UNIMOD:1918", "Carbonyl", "Aldehyde and ketone modifications.", false},
    {UNIMOD_AFB1_Dialdehyde, "UNIMOD:1920", "AFB1_Dialdehyde", "Adduction of aflatoxin B1 Dialdehyde to lysine.", false},
    {UNIMOD_Pro__HAVA, "UNIMOD:1922", "Pro->HAVA", "Proline oxidation to 5-hydroxy-2-aminovaleric acid.", false},
    {UNIMOD_Delta_H__4_O_2_, "UNIMOD:1923", "Delta:H(-4)O(2)", "Tryptophan oxidation to beta-unsaturated-2,4-bis-tryptophandione.", false},
    {UNIMOD_Delta_H__4_O_3_, "UNIMOD:1924", "Delta:H(-4)O(3)", "Tryptophan oxidation to hydroxy-bis-tryptophandione.", false},
    {UNIMOD_Delta_O_4_, "UNIMOD:1925", "Delta:O(4)", "Tryptophan oxidation to dihydroxy-N-formaylkynurenine.", false},
    {UNIMOD_Delta_H_4_C_3_O_2_, "UNIMOD:1926", "Delta:H(4)C(3)O(2)", "Methylglyoxal-derived carboxyethyllysine.", false},
    {UNIMOD_Delta_H_4_C_5_O_1_, "UNIMOD:1927", "Delta:H(4)C(5)O(1)", "Methylglyoxal-derived argpyrimidine.", false},
    {UNIMOD_Delta_H_10_C_8_O_1_, "UNIMOD:1928", "Delta:H(10)C(8)O(1)", "Crotonaldehyde-derived dimethyl-FDP-lysine.", false},
    {UNIMOD_Delta_H_6_C_7_O_4_, "UNIMOD:1929", "Delta:H(6)C(7)O(4)", "Methylglyoxal-derived tetrahydropyrimidine.", false},
    {UNIMOD_Pent_2_, "UNIMOD:1930", "Pent(2)", "Pent(2).", false},
    {UNIMOD_Pent_1_HexNAc_1_, "UNIMOD:1931", "Pent(1)HexNAc(1)", "Pent HexNAc.", false},
    {UNIMOD_Hex_2_Sulf_1_, "UNIMOD:1932", "Hex(2)Sulf(1)", "Hex(2) O(3) S.", false},
    {UNIMOD_Hex_1_Pent_2_Me_1_, "UNIMOD:1933", "Hex(1)Pent(2)Me(1)", "Hex:1 Pent:2 Me:1.", false},
    {UNIMOD_HexNAc_2_Sulf_1_, "UNIMOD:1934", "HexNAc(2)Sulf(1)", "HexNAc(2) Sulf.", false},
    {UNIMOD_Hex_1_Pent_3_Me_1_, "UNIMOD:1935", "Hex(1)Pent(3)Me(1)", "Hex Pent(3) Me.", false},
    {UNIMOD_Hex_2_Pent_2_, "UNIMOD:1936", "Hex(2)Pent(2)", "Hex(2) Pent(2).", false},
    {UNIMOD_Hex_2_Pent_2_Me_1_, "UNIMOD:1937", "Hex(2)Pent(2)Me(1)", "Hex(2) Pent(2) Me.", false},
    {UNIMOD_Hex_4_HexA_1_, "UNIMOD:1938", "Hex(4)HexA(1)", "Hex(4) HexA.", false},
    {UNIMOD_Hex_2_HexNAc_1_Pent_1_HexA_1_, "UNIMOD:1939", "Hex(2)HexNAc(1)Pent(1)HexA(1)", "Hex(2) HexNAc Pent HexA.", false},
    {UNIMOD_Hex_3_HexNAc_1_HexA_1_, "UNIMOD:1940", "Hex(3)HexNAc(1)HexA(1)", "Hex(3) HexNAc HexA.", false},
    {UNIMOD_Hex_1_HexNAc_2_dHex_2_Sulf_1_, "UNIMOD:1941", "Hex(1)HexNAc(2)dHex(2)Sulf(1)", "Hex HexNAc(2) dHex(2) Sulf.", false},
    {UNIMOD_HexA_2_HexNAc_3_, "UNIMOD:1942", "HexA(2)HexNAc(3)", "HexA(2) HexNAc(3).", false},
    {UNIMOD_dHex_1_Hex_4_HexA_1_, "UNIMOD:1943", "dHex(1)Hex(4)HexA(1)", "DHex Hex(4) HexA.", false},
    {UNIMOD_Hex_5_HexA_1_, "UNIMOD:1944", "Hex(5)HexA(1)", "Hex(5) HexA.", false},
    {UNIMOD_Hex_4_HexA_1_HexNAc_1_, "UNIMOD:1945", "Hex(4)HexA(1)HexNAc(1)", "Hex(4) HexA HexNAc.", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_1_, "UNIMOD:1946", "dHex(3)Hex(3)HexNAc(1)", "DHex(3) Hex(3) HexNAc.", false},
    {UNIMOD_Hex_6_HexNAc_1_, "UNIMOD:1947", "Hex(6)HexNAc(1)", "Hex(6) HexNAc.", false},
    {UNIMOD_Hex_1_HexNAc_4_dHex_1_Sulf_1_, "UNIMOD:1948", "Hex(1)HexNAc(4)dHex(1)Sulf(1)", "Sulf dHex Hex HexNAc(4).", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_1_NeuAc_2_, "UNIMOD:1949", "dHex(1)Hex(2)HexNAc(1)NeuAc(2)", "DHex Hex(2) HexNAc NeuAc(2).", false},
    {UNIMOD_dHex_3_Hex_3_HexNAc_2_, "UNIMOD:1950", "dHex(3)Hex(3)HexNAc(2)", "DHex(3) Hex(3) HexNAc(2).", false},
    {UNIMOD_dHex_2_Hex_1_HexNAc_4_Sulf_1_, "UNIMOD:1951", "dHex(2)Hex(1)HexNAc(4)Sulf(1)", "DHex(2) Hex HexNAc(4) Sulf.", false},
    {UNIMOD_dHex_1_Hex_2_HexNAc_4_Sulf_2_, "UNIMOD:1952", "dHex(1)Hex(2)HexNAc(4)Sulf(2)", "DHex Hex(2) HexNAc(4) Sulf(2).", false},
    {UNIMOD_Hex_9_, "UNIMOD:1953", "Hex(9)", "Hex(9).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_3_Sulf_1_, "UNIMOD:1954", "dHex(2)Hex(3)HexNAc(3)Sulf(1)", "Sulf dHex(2) Hex(3) HexNAc(3).", false},
    {UNIMOD_dHex_2_Hex_5_HexNAc_2_Me_1_, "UNIMOD:1955", "dHex(2)Hex(5)HexNAc(2)Me(1)", "Me dHex(2) Hex(5) HexNAc(2).", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_4_Sulf_2_, "UNIMOD:1956", "dHex(2)Hex(2)HexNAc(4)Sulf(2)", "Sulf(2) dHex(2) Hex(2) HexNAc(4).", false},
    {UNIMOD_Hex_9_HexNAc_1_, "UNIMOD:1957", "Hex(9)HexNAc(1)", "Hex(9) HexNAc.", false},
    {UNIMOD_dHex_3_Hex_2_HexNAc_4_Sulf_2_, "UNIMOD:1958", "dHex(3)Hex(2)HexNAc(4)Sulf(2)", "DHex(3) Hex(2) HexNAc(4) Sulf(2).", false},
    {UNIMOD_Hex_4_HexNAc_4_NeuGc_1_, "UNIMOD:1959", "Hex(4)HexNAc(4)NeuGc(1)", "Hex(4) HexNAc(4) NeuGc.", false},
    {UNIMOD_dHex_4_Hex_3_HexNAc_2_NeuAc_1_, "UNIMOD:1960", "dHex(4)Hex(3)HexNAc(2)NeuAc(1)", "DHex(4) Hex(3) HexNAc(2) NeuAc(1).", false},
    {UNIMOD_Hex_3_HexNAc_5_NeuAc_1_, "UNIMOD:1961", "Hex(3)HexNAc(5)NeuAc(1)", "Hex(3) HexNAc(5) NeuAc(1).", false},
    {UNIMOD_Hex_10_HexNAc_1_, "UNIMOD:1962", "Hex(10)HexNAc(1)", "Hex(10) HexNAc(1).", false},
    {UNIMOD_dHex_1_Hex_8_HexNAc_2_, "UNIMOD:1963", "dHex(1)Hex(8)HexNAc(2)", "DHex Hex(8) HexNAc(2).", false},
    {UNIMOD_Hex_3_HexNAc_4_NeuAc_2_, "UNIMOD:1964", "Hex(3)HexNAc(4)NeuAc(2)", "Hex(3) HexNAc(4) NeuAc(2).", false},
    {UNIMOD_dHex_2_Hex_3_HexNAc_4_NeuAc_1_, "UNIMOD:1965", "dHex(2)Hex(3)HexNAc(4)NeuAc(1)", "DHex(2) Hex(3) HexNAc(4) NeuAc.", false},
    {UNIMOD_dHex_2_Hex_2_HexNAc_6_Sulf_1_, "UNIMOD:1966", "dHex(2)Hex(2)HexNAc(6)Sulf(1)", "DHex(2) Hex(2) HexNAc(6) Sulf.", false},
    {UNIMOD_Hex_5_HexNAc_4_NeuAc_1_Ac_1_, "UNIMOD:1967", "Hex(5)HexNAc(4)NeuAc(1)Ac(1)", "Hex(5) HexNAc(4) NeuAc Ac.", false},
    {UNIMOD_Hex_3_HexNAc_3_NeuAc_3_, "UNIMOD:1968", "Hex(3)HexNAc(3)NeuAc(3)", "Hex(3) HexNAc(3) NeuAc(3).", false},
    {UNIMOD_Hex_5_HexNAc_4_NeuAc_1_Ac_2_, "UNIMOD:1969", "Hex(5)HexNAc(4)NeuAc(1)Ac(2)", "Hex(5) HexNAc(4) NeuAc Ac(2).", false},
    {UNIMOD_Unknown_162, "UNIMOD:1970", "Unknown:162", "Unidentified modification of 162.1258 found in open search.", false},
    {UNIMOD_Unknown_177, "UNIMOD:1971", "Unknown:177", "Unidentified modification of 176.7462 found in open search.", false},
    {UNIMOD_Unknown_210, "UNIMOD:1972", "Unknown:210", "Unidentified modification of 210.1616 found in open search.", false},
    {UNIMOD_Unknown_216, "UNIMOD:1973", "Unknown:216", "Unidentified modification of 216.1002 found in open search.", false},
    {UNIMOD_Unknown_234, "UNIMOD:1974", "Unknown:234", "Unidentified modification of 234.0742 found in open search.", false},
    {UNIMOD_Unknown_248, "UNIMOD:1975", "Unknown:248", "Unidentified modification of 248.1986 found in open search.", false},
    {UNIMOD_Unknown_250, "UNIMOD:1976", "Unknown:250", "Unidentified modification of 249.981 found in open search.", false},
    {UNIMOD_Unknown_302, "UNIMOD:1977", "Unknown:302", "Unidentified modification of 301.9864 found in open search.", false},
    {UNIMOD_Unknown_306, "UNIMOD:1978", "Unknown:306", "Unidentified modification of 306.0952 found in open search.", false},
    {UNIMOD_Unknown_420, "UNIMOD:1979", "Unknown:420", "Unidentified modification of 420.0506 found in open search.", false},
    {UNIMOD_Diethylphosphothione, "UNIMOD:1986", "Diethylphosphothione", "O-diethylphosphothione.", false},
    {UNIMOD_Dimethylphosphothione, "UNIMOD:1987", "Dimethylphosphothione", "O-dimethylphosphothione.", false},
    {UNIMOD_monomethylphosphothione, "UNIMOD:1989", "monomethylphosphothione", "O-methylphosphothione.", false},
    {UNIMOD_CIGG, "UNIMOD:1990", "CIGG", "Ubiquitin D (FAT10) leaving after chymotrypsin digestion Cys-Ile-Gly-Gly.", false},
    {UNIMOD_GNLLFLACYCIGG, "UNIMOD:1991", "GNLLFLACYCIGG", "Ubiquitin D (FAT10) leaving after trypsin digestion Gly-Asn-Leu-Leu-Phe-Leu-Ala-Cys-Tyr-Cys-Ile-Gly-Gly.", false},
    {UNIMOD_serotonylation, "UNIMOD:1992", "serotonylation", "5-glutamyl serotonin.", false},
    {UNIMOD_TMPP_Ac_13C_9_, "UNIMOD:1993", "TMPP-Ac:13C(9)", "Heavy tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative.", false},
    {UNIMOD_Xlink_DST_56_, "UNIMOD:1999", "Xlink:DST[56]", "DST crosslinker cleaved by sodium periodate.", false},
    {UNIMOD_ZQG, "UNIMOD:2001", "ZQG", "Carbobenzoxy-L-glutaminyl-glycine.", false},
    {UNIMOD_Haloxon, "UNIMOD:2006", "Haloxon", "O-Dichloroethylphosphate.", false},
    {UNIMOD_Methamidophos_S, "UNIMOD:2007", "Methamidophos-S", "S-methyl amino phosphinate.", false},
    {UNIMOD_Methamidophos_O, "UNIMOD:2008", "Methamidophos-O", "O-methyl amino phosphinate.", false},
    {UNIMOD_Nitrene, "UNIMOD:2014", "Nitrene", "Loss of O2; nitro photochemical decomposition.", false},
    {UNIMOD_shTMT, "UNIMOD:2015", "shTMT", "Super Heavy Tandem Mass Tag.", false},
    {UNIMOD_TMTpro, "UNIMOD:2016", "TMTpro", "TMTpro 16plex Tandem Mass Tag.", false},
    {UNIMOD_TMTpro_zero, "UNIMOD:2017", "TMTpro_zero", "Native TMTpro Tandem Mass Tag.", false},
    {UNIMOD_Ser_Thr_KDO, "UNIMOD:2022", "Ser/Thr-KDO", "Glycosylation of Serine/Threonine residues with KDO.", false},
    {UNIMOD_Andro_H2O, "UNIMOD:2025", "Andro-H2O", "Andrographolide with the loss of H2O.", false},
    {UNIMOD_His_O_2_, "UNIMOD:2027", "His+O(2)", "Photo-induced histidine adduct.", false},
    {UNIMOD_Hex_6_HexNAc_5_NeuAc_3_, "UNIMOD:2028", "Hex(6)HexNAc(5)NeuAc(3)", "A3G3S3.", false},
    {UNIMOD_Hex_7_HexNAc_6_, "UNIMOD:2029", "Hex(7)HexNAc(6)", "A4G4.", false},
    {UNIMOD_Met_O_2_, "UNIMOD:2033", "Met+O(2)", "Photo-induced Methionine Adduct.", false},
    {UNIMOD_Gly_O_2_, "UNIMOD:2034", "Gly+O(2)", "Photo-induced Glycine Adduct.", false},
    {UNIMOD_Pro_O_2_, "UNIMOD:2035", "Pro+O(2)", "Photo-induced Proline adduct.", false},
    {UNIMOD_Lys_O_2_, "UNIMOD:2036", "Lys+O(2)", "Photo-induced Lysine adduct.", false},
    {UNIMOD_Glu_O_2_, "UNIMOD:2037", "Glu+O(2)", "Photo-induced Glutamate adduct.", false},
    {UNIMOD_LTX_Lophotoxin, "UNIMOD:2039", "LTX+Lophotoxin", "Addition of lophotoxin to tyrosine.", false},
    {UNIMOD_MBS_peptide, "UNIMOD:2040", "MBS+peptide", "MBS_233p24 plus peptide 1250p53.", false},
    {UNIMOD_3_hydroxybenzyl_phosphate, "UNIMOD:2041", "3-hydroxybenzyl-phosphate", "3-hydroxybenzyl phosphate.", false},
    {UNIMOD_phenyl_phosphate, "UNIMOD:2042", "phenyl-phosphate", "Phenyl phosphate.", false},
    {UNIMOD_RBS_ID_Uridine, "UNIMOD:2044", "RBS-ID_Uridine", "RNA-protein UVC-crosslinked, hydrofluoride-digested uridine adduct.", false},
    {UNIMOD_shTMTpro, "UNIMOD:2050", "shTMTpro", "Super Heavy TMTpro.", false},
    {UNIMOD_Biotin_Aha_DADPS, "UNIMOD:2052", "Biotin:Aha-DADPS", "Intact DADPS Biotin Alkyne tag.", false},
    {UNIMOD_Biotin_Aha_PC, "UNIMOD:2053", "Biotin:Aha-PC", "Intact PC Biotin Alkyne tag.", false},
    {UNIMOD_pRBS_ID_4_thiouridine, "UNIMOD:2054", "pRBS-ID_4-thiouridine", "RNA-protein UVA-crosslinked, hydrofluoride-digested 4-thiouridine adduct.", false},
    {UNIMOD_pRBS_ID_6_thioguanosine, "UNIMOD:2055", "pRBS-ID_6-thioguanosine", "RNA-protein UVA-crosslinked, hydrofluoride-digested 6-thioguanosine adduct.", false},
    {UNIMOD_6C_CysPAT, "UNIMOD:2057", "6C-CysPAT", "Iodoacetamido-LC-Phosphonic Acid derivative.", false},
    {UNIMOD_Xlink_DSPP_210_, "UNIMOD:2058", "Xlink:DSPP[210]", "Intact DSPP/TBDSPP crosslinker.", false},
    {UNIMOD_Xlink_DSPP_228_, "UNIMOD:2059", "Xlink:DSPP[228]", "Water-quenched monolink of DSPP/TBDSPP crosslinker.", false},
    {UNIMOD_Xlink_DSPP_331_, "UNIMOD:2060", "Xlink:DSPP[331]", "Tris-quenched monolink of DSPP/TBDSPP crosslinker.", false},
    {UNIMOD_Xlink_DSPP_226_, "UNIMOD:2061", "Xlink:DSPP[226]", "Ammonia-quenched monolink of DSPP/TBDSPP crosslinker.", false},
    {UNIMOD_DBIA, "UNIMOD:2062", "DBIA", "Desthiobiotinylation of cysteine with DBIA probe.", false},
    {UNIMOD_Mono_N___propargyl_L_Gln_desthiobiotin, "UNIMOD:2067", "Mono_Nγ-propargyl-L-Gln_desthiobiotin", "Monomodification of Nγ-propargyl-L-Gln probe with clicked desthiobiotin-azide.", false},
    {UNIMOD_Di_L_Glu_N___propargyl_L_Gln_desthiobiotin, "UNIMOD:2068", "Di_L-Glu_Nγ-propargyl-L-Gln_desthiobiotin", "Dimodification of L-Glu and Nγ-propargyl-L-Gln probe with clicked desthiobiotin-azide.", false},
    {UNIMOD_Di_L_Gln_N___propargyl_L_Gln_desthiobiotin, "UNIMOD:2069", "Di_L-Gln_Nγ-propargyl-L-Gln_desthiobiotin", "Dimodification of L-Gln and Nγ-propargyl-L-Gln probe with clicked desthiobiotin-azide.", false},
    {UNIMOD_L_Gln, "UNIMOD:2070", "L-Gln", "Monomodification with glutamine.", false},
    {UNIMOD_Glyceroyl, "UNIMOD:2072", "Glyceroyl", "Glyceroylation.", false},
    {UNIMOD_N6pAMP, "UNIMOD:2073", "N6pAMP", "Plain N6-Propargyl-AMP modified proteins without any clicked enrichment tag.", false},
    {UNIMOD_DABCYL_C2_maleimide, "UNIMOD:2074", "DABCYL-C2-maleimide", "DABCYL-C2-maleimide Thiol-reactive dye for fluorescence labelling of proteins.", false},
    {UNIMOD_NBF, "UNIMOD:2079", "NBF", "Thiol blocking reagent.", false},
    {UNIMOD_DCP, "UNIMOD:2080", "DCP", "Dimedone-Based Chemical Probes.", false},
    {UNIMOD_Ethynyl, "UNIMOD:2081", "Ethynyl", "Ethynlation of cysteine residues.", false},
    {UNIMOD_QQTGG, "UNIMOD:2082", "QQTGG", "SUMOylation leaving QQTGG.", false},
    {UNIMOD_Pyro_QQTGG, "UNIMOD:2083", "Pyro-QQTGG", "SUMOylation leaving Pyro-QQTGG.", false},
    {UNIMOD_NQTGG, "UNIMOD:2084", "NQTGG", "SUMOylation leaving NQTGG.", false},
    {UNIMOD_DVFQQQTGG, "UNIMOD:2085", "DVFQQQTGG", "SUMOylation by Endogenous SUMO2/3 following Lys C and Asp-N serial digestion.", false},
    {UO_unit, "UO:0000000", "unit", "A unit of measurement is a standardized quantity of a physical quality.", false},
    {UO_length_unit, "UO:0000001", "length unit", "A unit which is a standard measure of the distance between two points.", false},
    {UO_mass_unit, "UO:0000002", "mass unit", "A unit which is a standard measure of the amount of matter/energy of a physical object.", false},
    {UO_time_unit, "UO:0000003", "time unit", "A unit which is a standard measure of the dimension in which events occur in sequence.", false},
    {UO_electric_current_unit, "UO:0000004", "electric current unit", "A unit which is a standard measure of the flow of electric charge.", false},
    {UO_temperature_unit, "UO:0000005", "temperature unit", "A unit which is a standard measure of the average kinetic energy of the particles in a sample of matter.", false},
    {UO_substance_unit, "UO:0000006", "substance unit", "A unit which is a standardised quantity of an element or compound with uniform composition.", false},
    {UO_luminous_intensity_unit, "UO:0000007", "luminous intensity unit", "A unit which is a standard measure of the wavelength-weighted power emitted by a light source in a particular direction.", false},
    {UO_meter, "UO:0000008", "meter", "A length unit which is equal to the length of the path traveled by light in vacuum during a time interval of 1/299 792 458 of a second.", false},
    {UO_kilogram, "UO:0000009", "kilogram", "A mass unit which is equal to the mass of the International Prototype Kilogram kept by the BIPM at Svres, France.", false},
    {UO_second, "UO:0000010", "second", "A time unit which is equal to the duration of 9 192 631 770 periods of the radiation corresponding to the transition between the two hyperfine levels of the ground state of the caesium 133 atom.", false},
    {UO_ampere, "UO:0000011", "ampere", "An electric current unit which is equal to the constant current which, if maintained in two straight parallel conductors of infinite length, of negligible circular cross-section, and placed 1 m apart in vacuum, would produce between these conductors a force equal to 2 x 10^[-7] newton per meter of length.", false},
    {UO_kelvin, "UO:0000012", "kelvin", "A thermodynamic temperature unit which is equal to the fraction 1/273.16 of the thermodynamic temperature of the triple point of water.", false},
    {UO_mole, "UO:0000013", "mole", "A substance unit which is equal to the amount of substance of a molecular system which contains as many elementary entities as there are atoms in 0.012 kilogram of carbon 12.", false},
    {UO_candela, "UO:0000014", "candela", "A luminous intensity unit which equal to the luminous intensity, in a given direction, of a source that emits monochromatic radiation of frequency 540 x 1012 hertz and that has a radiant intensity in that direction of 1/683 watt per steradian.", false},
    {UO_centimeter, "UO:0000015", "centimeter", "A length unit which is equal to one hundredth of a meter or 10^[-2] m.", false},
    {UO_millimeter, "UO:0000016", "millimeter", "A length unit which is equal to one thousandth of a meter or 10^[-3] m.", false},
    {UO_micrometer, "UO:0000017", "micrometer", "A length unit which is equal to one millionth of a meter or 10^[-6] m.", false},
    {UO_nanometer, "UO:0000018", "nanometer", "A length unit which is equal to one thousandth of one millionth of a meter or 10^[-9] m.", false},
    {UO_angstrom, "UO:0000019", "angstrom", "A length unit which is equal to 10 [-10] m.", false},
    {UO_picometer, "UO:0000020", "picometer", "A length unit which is equal to 10^[-12] m.", false},
    {UO_gram, "UO:0000021", "gram", "A mass unit which is equal to one thousandth of a kilogram or 10^[-3] kg.", false},
    {UO_milligram, "UO:0000022", "milligram", "A mass unit which is equal to one thousandth of a gram or 10^[-3] g.", false},
    {UO_microgram, "UO:0000023", "microgram", "A mass unit which is equal to one millionth of a gram or 10^[-6] g.", false},
    {UO_nanogram, "UO:0000024", "nanogram", "A mass unit which is equal to one thousandth of one millionth of a gram or 10^[-9] g.", false},
    {UO_picogram, "UO:0000025", "picogram", "A mass unit which is equal to 10^[-12] g.", false},
    {UO_femtogram, "UO:0000026", "femtogram", "A mass unit which is equal to 10^[-15] g.", false},
    {UO_degree_Celsius, "UO:0000027", "degree Celsius", "A temperature unit which is equal to one kelvin degree. However, they have their zeros at different points. The centigrade scale has its zero at 273.15 K.", false},
    {UO_millisecond, "UO:0000028", "millisecond", "A time unit which is equal to one thousandth of a second or 10^[-3] s.", false},
    {UO_microsecond, "UO:0000029", "microsecond", "A time unit which is equal to one millionth of a second or 10^[-6] s.", false},
    {UO_picosecond, "UO:0000030", "picosecond", "A time unit which is equal to 10^[-12] s.", false},
    {UO_minute, "UO:0000031", "minute", "A time unit which is equal to 60 seconds.", false},
    {UO_hour, "UO:0000032", "hour", "A time unit which is equal to 3600 seconds or 60 minutes.", false},
    {UO_day, "UO:0000033", "day", "A time unit which is equal to 24 hours.", false},
    {UO_week, "UO:0000034", "week", "A time unit which is equal to 7 days.", false},
    {UO_month, "UO:0000035", "month", "A time unit which is approximately equal to the length of time of one of cycle of the moon's phases which in science is taken to be equal to 30 days.", false},
    {UO_year, "UO:0000036", "year", "A time unit which is equal to 12 months which in science is taken to be equal to 365.25 days.", false},
    {UO_milliampere, "UO:0000037", "milliampere", "An electric current unit current which is equal to one thousandth of an ampere or 10^[-3] A.", false},
    {UO_microampere, "UO:0000038", "microampere", "An electric current unit current which is equal to one millionth of an ampere or 10^[-6] A.", false},
    {UO_micromole_400000039, "UO:0000039", "micromole (UO:400000039)", "A substance unit equal to a millionth of a mol or 10^[-6] mol.", false},
    {UO_millimole, "UO:0000040", "millimole", "A substance unit equal to a thousandth of a mol or 10^[-3] mol.", false},
    {UO_nanomole, "UO:0000041", "nanomole", "A substance unit equal to one thousandth of one millionth of a mole or 10^[-9] mol.", false},
    {UO_picomole, "UO:0000042", "picomole", "A substance unit equal to 10^[-12] mol.", false},
    {UO_femtomole, "UO:0000043", "femtomole", "A substance unit equal to 10^[-15] mol.", false},
    {UO_attomole, "UO:0000044", "attomole", "A substance unit equal to 10^[-18] mol.", false},
    {UO_base_unit, "UO:0000045", "base unit", "A unit which is one of a particular measure to which all measures of that type can be related.", false},
    {UO_prefix, "UO:0000046", "prefix", "", false},
    {UO_area_unit, "UO:0000047", "area unit", "A unit which is a standard measure of the amount of a 2-dimensional flat surface.", false},
    {UO_acceleration_unit, "UO:0000048", "acceleration unit", "A unit which is a standard measure of the rate of change of velocity in either speed or direction.", false},
    {UO_angular_velocity_unit, "UO:0000049", "angular velocity unit", "A unit which is a standard measure of the rate of angular movement about an axis; the angle rotated in a given time.", false},
    {UO_angular_acceleration_unit, "UO:0000050", "angular acceleration unit", "A unit which is a standard measure of the rate of change of angular velocity.", false},
    {UO_concentration_unit, "UO:0000051", "concentration unit", "A unit which represents a standard measurement of how much of a given substance there is mixed with another substance.", false},
    {UO_mass_density_unit, "UO:0000052", "mass density unit", "A density unit which is a standard measure of the mass of a substance in a given volume.", false},
    {UO_luminance_unit, "UO:0000053", "luminance unit", "A unit which is a standard measure of the luminous intensity impinging on a given area.", false},
    {UO_area_density_unit, "UO:0000054", "area density unit", "A density unit which is a standard measure of the mass exerting an influence on a given area.", false},
    {UO_molar_mass_unit, "UO:0000055", "molar mass unit", "A unit which is a standard measure of the mass of a homogeneous substance containing 6.02 x 1023 atoms or molecules.", false},
    {UO_molar_volume_unit, "UO:0000056", "molar volume unit", "A unit which is a standard measure of the volume of a homogeneous substance containing 6.02 x 1023 atoms or molecules.", false},
    {UO_momentum_unit, "UO:0000057", "momentum unit", "A unit which is a standard measure of the quantity of motion measured by the product of mass and velocity.", false},
    {UO_rotational_frequency_unit, "UO:0000058", "rotational frequency unit", "A unit which is a standard measure of the number of rotations in a given time.", false},
    {UO_specific_volume_unit, "UO:0000059", "specific volume unit", "A unit which is a standard measure of the volume of a given mass of substance (the reciprocal of density).", false},
    {UO_speed_velocity_unit, "UO:0000060", "speed/velocity unit", "A unit which is a standard measure of the rate of movement. Speed is measured in the same physical units of measurement as velocity, but does not contain the element of direction that velocity has. Speed is thus the magnitude component of velocity.", false},
    {UO_unit_of_molarity, "UO:0000061", "unit of molarity", "A concentration unit which is a standard measure of the number of moles of a given substance per liter of solution.", false},
    {UO_molar, "UO:0000062", "molar", "A unit of concentration which expresses a concentration of 1 mole of solute per liter of solution (mol/L).", false},
    {UO_millimolar, "UO:0000063", "millimolar", "A unit of molarity which is equal to one thousandth of a molar or 10^[-3] M.", false},
    {UO_micromolar, "UO:0000064", "micromolar", "A unit of molarity which is equal to one millionth of a molar or 10^[-6] M.", false},
    {UO_nanomolar, "UO:0000065", "nanomolar", "A unit of molarity which is equal to one thousandth of one millionth of a molar or 10^[-9] M.", false},
    {UO_picomolar, "UO:0000066", "picomolar", "A unit of molarity which is equal to 10^[-12] M.", false},
    {UO_unit_of_molality, "UO:0000067", "unit of molality", "A concentration unit which is a standard measure of the number of moles of a given substance per kilogram of solvent.", false},
    {UO_molal, "UO:0000068", "molal", "A unit of concentration which expresses a concentration of a solution of 1 mole per kilogram of solvent (mol/kg).", false},
    {UO_millimolal, "UO:0000069", "millimolal", "A molality unit which is equal to one thousandth of a molal or 10^[-3] m.", false},
    {UO_micromolal, "UO:0000070", "micromolal", "A molality unit which is equal to one millionth of a molal or 10^[-6] m.", false},
    {UO_nanomolal, "UO:0000071", "nanomolal", "A molality unit which is equal to one thousandth of one millionth of a molal or 10^[-9] m.", false},
    {UO_picomolal, "UO:0000072", "picomolal", "A molality unit which is equal to 10^[-12] m.", false},
    {UO_femtomolar, "UO:0000073", "femtomolar", "A unit of molarity which is equal to 10^[-15] M.", false},
    {UO_unit_of_normality, "UO:0000074", "unit of normality", "A unit of concentration which highlights the chemical nature of salts.", false},
    {UO_normal, "UO:0000075", "normal", "A unit of concentration which is one gram equivalent of a solute per liter of solution. A gram equivalent weight or equivalent is a measure of the reactive capacity of a given molecule.", false},
    {UO_mole_fraction, "UO:0000076", "mole fraction", "A concentration unit which denotes the number of moles of solute as a proportion of the total number of moles in a solution.", false},
    {UO_meter_per_second_per_second, "UO:0000077", "meter per second per second", "An acceleration unit which is equal to the acceleration an object changing its velocity by 1meter/s over a time period that equals one second.", false},
    {UO_radian_per_second_per_second, "UO:0000078", "radian per second per second", "An angular unit acceleration which is equal to the angular acceleration of an object changing its angular velocity by 1rad/s over a time period that equals one second.", false},
    {UO_radian_per_second, "UO:0000079", "radian per second", "An angular unit velocity which is equal to about 9.54930 rpm (revolutions per minute).", false},
    {UO_square_meter, "UO:0000080", "square meter", "An area unit which is equal to an area enclosed by a square with sides each 1 meter long.", false},
    {UO_square_centimeter, "UO:0000081", "square centimeter", "An area unit which is equal to one ten thousandth of a square meter or 10^[-4] m^[2].", false},
    {UO_square_millimeter, "UO:0000082", "square millimeter", "An area unit which is equal to one millionth of a square meter or 10^[-6] m^[2].", false},
    {UO_kilogram_per_cubic_meter, "UO:0000083", "kilogram per cubic meter", "A mass unit density which is equal to mass of an object in kilograms divided by the volume in cubic meters.", false},
    {UO_gram_per_cubic_centimeter, "UO:0000084", "gram per cubic centimeter", "A mass unit density which is equal to mass of an object in grams divided by the volume in cubic centimeters.", false},
    {UO_candela_per_square_meter, "UO:0000085", "candela per square meter", "A luminance unit which is equal to a luminous intensity of one candela radiating from a surface whose area is one square meter.", false},
    {UO_kilogram_per_square_meter, "UO:0000086", "kilogram per square meter", "An area density unit which is equal to the mass of an object in kilograms divided by the surface area in meters squared.", false},
    {UO_kilogram_per_mole, "UO:0000087", "kilogram per mole", "A molar mass unit which is equal to one kilogram of mass of one mole of chemical element or chemical compound.", false},
    {UO_gram_per_mole, "UO:0000088", "gram per mole", "A molar mass unit which is equal to one gram of mass of one mole of chemical element or chemical compound.", false},
    {UO_cubic_meter_per_mole, "UO:0000089", "cubic meter per mole", "A molar volume unit which is equal to 1 cubic meter occupied by one mole of a substance in the form of a solid, liquid, or gas.", false},
    {UO_cubic_centimeter_per_mole, "UO:0000090", "cubic centimeter per mole", "A molar volume unit which is equal to 1 cubic centimeter occupied by one mole of a substance in the form of a solid, liquid, or gas.", false},
    {UO_kilogram_meter_per_second, "UO:0000091", "kilogram meter per second", "A momentum unit which is equal to the momentum of a one kilogram mass object with a speed of one meter per second.", false},
    {UO_turns_per_second, "UO:0000092", "turns per second", "A rotational frequency unit which is equal to the number complete turn in a period of time that equals to 1 second.", false},
    {UO_cubic_meter_per_kilogram, "UO:0000093", "cubic meter per kilogram", "A specific volume unit which is equal to one cubic meter volume occupied by one kilogram of a particular substance.", false},
    {UO_meter_per_second, "UO:0000094", "meter per second", "A speed/velocity unit which is equal to the speed of an object traveling 1 meter distance in one second.", false},
    {UO_volume_unit, "UO:0000095", "volume unit", "A unit which is a standard measure of the amount of space occupied by any substance, whether solid, liquid, or gas.", false},
    {UO_cubic_meter, "UO:0000096", "cubic meter", "A volume unit which is equal to the volume of a cube with edges one meter in length. One cubic meter equals to 1000 liters.", false},
    {UO_cubic_centimeter, "UO:0000097", "cubic centimeter", "A volume unit which is equal to one millionth of a cubic meter or 10^[-9] m^[3], or to 1 ml.", false},
    {UO_milliliter, "UO:0000098", "milliliter", "A volume unit which is equal to one thousandth of a liter or 10^[-3] L, or to 1 cubic centimeter.", false},
    {UO_liter, "UO:0000099", "liter", "A volume unit which is equal to one thousandth of a cubic meter or 10^[-3] m^[3], or to 1 decimeter.", false},
    {UO_cubic_decimeter, "UO:0000100", "cubic decimeter", "A volume unit which is equal to one thousand of a cubic meter or 10^[-3] m^[3], or to 1 L.", false},
    {UO_microliter, "UO:0000101", "microliter", "A volume unit which is equal to one millionth of a liter or 10^[-6] L.", false},
    {UO_nanoliter, "UO:0000102", "nanoliter", "A volume unit which is equal to one thousandth of one millionth of a liter or 10^[-9] L.", false},
    {UO_picoliter, "UO:0000103", "picoliter", "A volume unit which is equal to 10^[-12] L.", false},
    {UO_femtoliter, "UO:0000104", "femtoliter", "A volume unit which is equal to 10^[-15] L.", false},
    {UO_frequency_unit, "UO:0000105", "frequency unit", "A unit which is a standard measure of the number of repetitive actions in a particular time.", false},
    {UO_hertz, "UO:0000106", "hertz", "A frequency unit which is equal to 1 complete cycle of a recurring phenomenon in 1 second.", false},
    {UO_force_unit, "UO:0000107", "force unit", "A unit which is a standard measure of the force is applied when a mass is accelerated.", false},
    {UO_newton, "UO:0000108", "newton", "A force unit which is equal to the force required to cause an acceleration of 1m/s2 of a mass of 1 Kg in the direction of the force.", false},
    {UO_pressure_unit, "UO:0000109", "pressure unit", "A unit which is a standard measure of the force applied to a given area.", false},
    {UO_pascal, "UO:0000110", "pascal", "A pressure unit which is equal to the pressure or stress on a surface caused by a force of 1 newton spread over a surface of 1 m^[2].", false},
    {UO_energy_unit, "UO:0000111", "energy unit", "A unit which is a standard measure of the work done by a certain force (gravitational, electric, magnetic, force of inertia, etc).", false},
    {UO_joule, "UO:0000112", "joule", "An energy unit which is equal to the energy required when a force of 1 newton moves an object 1 meter in the direction of the force.", false},
    {UO_power_unit, "UO:0000113", "power unit", "A unit which is a standard measure power or the rate of doing work.", false},
    {UO_watt, "UO:0000114", "watt", "A power unit which is equal to the power used when work is done at the rate of 1 joule per second.", false},
    {UO_illuminance_unit, "UO:0000115", "illuminance unit", "A unit which is a standard measure of the luminous flux incident on a unit area.", false},
    {UO_lux, "UO:0000116", "lux", "An illuminance unit which is equal to the illuminance produced by 1 lumen evenly spread over an area 1 m^[2].", false},
    {UO_luminous_flux_unit, "UO:0000117", "luminous flux unit", "A unit which is a standard measure of the flow of radiant energy.", false},
    {UO_lumen, "UO:0000118", "lumen", "A luminous flux unit which is equal to the luminous flux emitted into 1 steradian by a point source of 1 candela.", false},
    {UO_catalytic_activity_unit, "UO:0000119", "catalytic activity unit", "A unit which is a standard measure of the amount of the action of a catalyst.", false},
    {UO_katal, "UO:0000120", "katal", "A catalytic unit activity which is equal to the activity of a catalyst in moles per second, such as the amount of an enzyme needed to transform one mole of substrate per second.", false},
    {UO_angle_unit, "UO:0000121", "angle unit", "A unit which is a standard measure of the figure or space formed by the junction of two lines or planes.", false},
    {UO_plane_angle_unit, "UO:0000122", "plane angle unit", "A unit which is a standard measure of the angle formed by two straight lines in the same plane.", false},
    {UO_radian, "UO:0000123", "radian", "A plane angle unit which is equal to the angle subtended at the center of a circle by an arc equal in length to the radius of the circle, approximately 57 degrees 17 minutes and 44.6 seconds.", false},
    {UO_solid_angle_unit, "UO:0000124", "solid angle unit", "A unit which is a standard measure of the angle formed by three or more planes intersecting at a common point.", false},
    {UO_steradian, "UO:0000125", "steradian", "A solid angle unit which is equal to the solid angle subtended at the center of a sphere by an area on the surface of the sphere that is equal to the radius squared.", false},
    {UO_radiation_unit, "UO:0000127", "radiation unit", "A unit which is a standard measure of the amount of radiation emitted by a given radiation source as well as the amount of radiation absorbed or deposited in a specific material by a radiation source.", false},
    {UO_activity__of_a_radionuclide__unit, "UO:0000128", "activity (of a radionuclide) unit", "A unit which is a standard measure of the transformation (disintegration) rate of a radioactive substance.", false},
    {UO_absorbed_dose_unit, "UO:0000129", "absorbed dose unit", "A unit which is a standard measure of the energy imparted by ionizing radiation to unit mass of matter such as tissue.", false},
    {UO_dose_equivalent_unit, "UO:0000130", "dose equivalent unit", "A unit which is a standard measure of the expression of dose in terms of its biological effect.", false},
    {UO_exposure_unit, "UO:0000131", "exposure unit", "A unit which is a standard measure of the quantity that expresses the ability of radiation to ionize air and thereby create electric charges which can be collected and measured.", false},
    {UO_becquerel, "UO:0000132", "becquerel", "An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which one nucleus decays per second or there is one atom disintegration per second (dps).", false},
    {UO_curie, "UO:0000133", "curie", "An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which there are 3.7 x 10^[10] atom disintegration per second (dps).", false},
    {UO_gray, "UO:0000134", "gray", "An absorbed dose unit which is equal to the absorption of one joule of radiation energy by one kilogram of matter.", false},
    {UO_rad, "UO:0000135", "rad", "An absorbed dose unit which is equal to 0.01 gray (Gy).", false},
    {UO_roentgen, "UO:0000136", "roentgen", "An exposure unit which is equal to the amount of radiation required to liberate positive and negative charges of one electrostatic unit of charge in 1 cm^[3] of air at standard temperature and pressure (STP). This corresponds to the generation of approximately 2.0810^[9] ion pairs.", false},
    {UO_sievert, "UO:0000137", "sievert", "A dose equivalent unit which is equal to the absorption of one joule of radiation energy by one kilogram of matter.", false},
    {UO_millisievert, "UO:0000138", "millisievert", "A dose equivalent unit which is equal to one thousandth of a sievert or 10^[-3] Sv.", false},
    {UO_microsievert, "UO:0000139", "microsievert", "A dose equivalent unit which is equal to one millionth of a sievert or 10^[-6] Sv.", false},
    {UO_Roentgen_equivalent_man, "UO:0000140", "Roentgen equivalent man", "A dose equivalent unit which when multiplied by hundred is equal to one sievert or 1 Sv. 1 Sv is equal to 100 rem.", false},
    {UO_microgray, "UO:0000141", "microgray", "An absorbed dose unit which is equal to one millionth of a gray or 10^[-6] Gy.", false},
    {UO_milligray, "UO:0000142", "milligray", "An absorbed dose unit which is equal to one thousandth of a gray or 10^[-3] Gy.", false},
    {UO_nanogray, "UO:0000143", "nanogray", "An absorbed dose unit which is equal to one thousandth of a millionth of a gray or 10^[-9] Gy.", false},
    {UO_nanosievert, "UO:0000144", "nanosievert", "A dose equivalent unit which is equal to one thousandth of a millionth of a sievert or 10^[-9] Sv.", false},
    {UO_millicurie, "UO:0000145", "millicurie", "An activity (of a radionuclide) unit which is equal to one thousandth of a curie or 10^[-3] Ci.", false},
    {UO_microcurie, "UO:0000146", "microcurie", "An activity (of a radionuclide) unit which is equal to one millionth of a curie or 10^[-6] Ci.", false},
    {UO_disintegrations_per_minute, "UO:0000147", "disintegrations per minute", "An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which one nucleus decays per minute or there is one atom disintegration per minute.", false},
    {UO_counts_per_minute, "UO:0000148", "counts per minute", "An activity (of a radionuclide) unit which is equal to the number of light emissions produced by ionizing radiation in one minute.", false},
    {UO_nanosecond, "UO:0000150", "nanosecond", "A time unit which is equal to one thousandth of one millionth of a second or 10^[-9] s.", false},
    {UO_century, "UO:0000151", "century", "A time unit which is equal to 100 years.", false},
    {UO_half_life, "UO:0000152", "half life", "A time unit which represents the period over which the activity or concentration of a specified chemical or element falls to half its original activity or concentration.", false},
    {UO_foot_candle, "UO:0000153", "foot candle", "An illuminance unit which is equal to the illuminance produced by 1 lumen evenly spread over an area 1 foot^[2]. One footcandle is equal to 10.76 lux.", false},
    {UO_irradiance_unit, "UO:0000154", "irradiance unit", "A unit which is a standard measure of the power of electromagnetic radiation at a surface, per unit area.", false},
    {UO_watt_per_square_meter, "UO:0000155", "watt per square meter", "An irradiance unit which is equal to 1 watt of radiant power incident per one square meter surface area.", false},
    {UO_einstein_per_square_meter_per_second, "UO:0000156", "einstein per square meter per second", "An irradiance unit which is equal to one einstein per square meter per second. One einstein is one mole of photons, regardless of their frequency. Therefore, the number of photons in an einstein is Avogadro's number.", false},
    {UO_light_unit, "UO:0000157", "light unit", "A unit which is a standard measure of the intensity of light.", false},
    {UO_watt_per_steradian_per_square_meter, "UO:0000158", "watt per steradian per square meter", "A radiance unit which is equal to one watt of radiant power incident per steradian solid angle per one square meter projected area of the source, as viewed from the given direction.", false},
    {UO_radiant_intensity_unit, "UO:0000159", "radiant intensity unit", "A unit which is a standard measure of the intensity of electromagnetic radiation.", false},
    {UO_microeinstein_per_square_meter_per_second, "UO:0000160", "microeinstein per square meter per second", "An irradiance unit which is equal to one microeinstein per square meter per second or 10^[-6] microeinstein/sm^[2].", false},
    {UO_radiance_unit, "UO:0000161", "radiance unit", "A unit which is a standard measure of the power of electromagnetic radiation through space or through a material medium in the form of electromagnetic waves.", false},
    {UO_watt_per_steradian, "UO:0000162", "watt per steradian", "A radiant intensity unit which is equal to one kilogram meter squared per second cubed per steradian.", false},
    {UO_mass_percentage, "UO:0000163", "mass percentage", "A dimensionless concentration unit which denotes the mass of a substance in a mixture as a percentage of the mass of the entire mixture.", false},
    {UO_mass_volume_percentage, "UO:0000164", "mass volume percentage", "A dimensionless concentration unit which denotes the mass of the substance in a mixture as a percentage of the volume of the entire mixture.", false},
    {UO_volume_percentage, "UO:0000165", "volume percentage", "A dimensionless concentration unit which denotes the volume of the solute in mL per 100 mL of the resulting solution.", false},
    {UO_parts_per_notation_unit, "UO:0000166", "parts per notation unit", "A dimensionless concentration notation which describes the amount of one substance in another. It is the ratio of the amount of the substance of interest to the amount of that substance plus the amount of the substance.", false},
    {UO_parts_per_hundred, "UO:0000167", "parts per hundred", "A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 100 regardless of the units of measure as long as they are the same.", false},
    {UO_parts_per_thousand, "UO:0000168", "parts per thousand", "A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1000 regardless of the units of measure as long as they are the same.", false},
    {UO_parts_per_million, "UO:0000169", "parts per million", "A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000 regardless of the units of measure used as long as they are the same or 1 part in 10^[6].", false},
    {UO_parts_per_billion, "UO:0000170", "parts per billion", "A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000,000 regardless of the units of measure as long as they are the same or 1 part in 10^[9].", false},
    {UO_parts_per_trillion, "UO:0000171", "parts per trillion", "A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000,000 regardless of the units of measure used as long as they are the same or 1 part in 10^[12].", false},
    {UO_parts_per_quadrillion, "UO:0000172", "parts per quadrillion", "A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000,000,000 regardless of the units of measure used as long as they are the same or 1 part in 10^[15].", false},
    {UO_gram_per_milliliter, "UO:0000173", "gram per milliliter", "A mass unit density which is equal to mass of an object in grams divided by the volume in milliliter.", false},
    {UO_kilogram_per_liter, "UO:0000174", "kilogram per liter", "A mass unit density which is equal to mass of an object in kilograms divided by the volume in liters.", false},
    {UO_gram_per_liter, "UO:0000175", "gram per liter", "A mass unit density which is equal to mass of an object in grams divided by the volume in liters.", false},
    {UO_milligram_per_milliliter, "UO:0000176", "milligram per milliliter", "A mass unit density which is equal to mass of an object in milligrams divided by the volume in milliliters.", false},
    {UO_unit_per_volume_unit, "UO:0000177", "unit per volume unit", "A concentration unit which is a standard measure of the number of units, as an agreed arbitrary amount, of a given substance per a specific volume of solution.", false},
    {UO_unit_per_milliliter, "UO:0000178", "unit per milliliter", "A unit per milliliter unit which is equal to one unit of an agreed arbitrary amount per one milliliter.", false},
    {UO_unit_per_liter, "UO:0000179", "unit per liter", "A unit per milliliter unit which is equal to one unit of an agreed arbitrary amount per one liter.", false},
    {UO_mass_per_unit_volume, "UO:0000180", "mass per unit volume", "A concentration unit which is a standard measure of the mass of a substance in a given volume (density).", false},
    {UO_enzyme_unit, "UO:0000181", "enzyme unit", "A catalytic unit activity which is equal to the amount of the enzyme that catalyzes the conversion of 1 micro mole of substrate per minute.", false},
    {UO_density_unit, "UO:0000182", "density unit", "A unit which is a standard measure of the influence exerted by some mass.", false},
    {UO_linear_density_unit, "UO:0000183", "linear density unit", "A density unit which is a standard measure of the mass exerting an influence on a one-dimensional object.", false},
    {UO_kilogram_per_meter, "UO:0000184", "kilogram per meter", "An area density unit which is equal to the mass of an object in kilograms divided by one meter.", false},
    {UO_degree, "UO:0000185", "degree", "A plane angle unit which is equal to 1/360 of a full rotation or 1.7453310^[-2] rad.", false},
    {UO_dimensionless_unit, "UO:0000186", "dimensionless unit", "A unit which is a standard measure of physical quantity consisting of only a numerical number without any units.", false},
    {UO_percent, "UO:0000187", "percent", "A dimensionless ratio unit which denotes numbers as fractions of 100.", false},
    {UO_pi, "UO:0000188", "pi", "A dimensionless unit which denoted an irrational real number, approximately equal to 3.14159 which is the ratio of a circle's circumference to its diameter in Euclidean geometry.", false},
    {UO_count_unit, "UO:0000189", "count unit", "A dimensionless unit which denotes a simple count of things.", false},
    {UO_ratio_400000190, "UO:0000190", "ratio (UO:400000190)", "A dimensionless unit which denotes an amount or magnitude of one quantity relative to another.", false},
    {UO_fraction, "UO:0000191", "fraction", "A dimensionless ratio unit which relates the part (the numerator) to the whole (the denominator).", false},
    {UO_molecule_count, "UO:0000192", "molecule count", "A dimensionless count unit which denotes the number of molecules.", false},
    {UO_purity_percentage, "UO:0000193", "purity percentage", "A dimensionless percent unit which denotes the homogeneity of a biomaterial.", false},
    {UO_confluence_percentage, "UO:0000194", "confluence percentage", "A dimensionless percent unit which denotes the density of an attached or monolayer culture (e.g., cell culture).", false},
    {UO_degree_Fahrenheit, "UO:0000195", "degree Fahrenheit", "A temperature unit which is equal to 5/9ths of a kelvin. Negative 40 degrees Fahrenheit is equal to negative 40 degrees Celsius.", false},
    {UO_pH, "UO:0000196", "pH", "A dimensionless concentration notation which denotes the acidity of a solution in terms of activity of hydrogen ions (H+).", false},
    {UO_liter_per_kilogram, "UO:0000197", "liter per kilogram", "A specific volume unit which is equal to one liter volume occupied by one kilogram of a particular substance.", false},
    {UO_milliliter_per_kilogram, "UO:0000198", "milliliter per kilogram", "A specific volume unit which is equal to a thousandth of a liter per kilogram or 10^[-3] l/kg.", false},
    {UO_microliter_per_kilogram, "UO:0000199", "microliter per kilogram", "A specific volume unit which is equal to one millionth of a liter per kilogram or 10^[-6] l/kg.", false},
    {UO_cell_concentration_unit, "UO:0000200", "cell concentration unit", "A concentration unit which denotes the average cell number in a given volume.", false},
    {UO_cells_per_milliliter, "UO:0000201", "cells per milliliter", "A unit of cell concentration which is equal to one cell in a volume of 1 milliliter.", false},
    {UO_catalytic__activity__concentration_unit, "UO:0000202", "catalytic (activity) concentration unit", "A concentration unit which is a standard measure of the amount of the action of a catalyst in a given volume.", false},
    {UO_katal_per_cubic_meter, "UO:0000203", "katal per cubic meter", "A catalytic (activity) concentration unit which is equal to 1 katal activity of a catalyst in a given volume of one cubic meter.", false},
    {UO_katal_per_liter, "UO:0000204", "katal per liter", "A catalytic (activity) concentration unit which is equal to 1 katal activity of a catalyst in a given volume of one thousandth of a cubic meter.", false},
    {UO_volume_per_unit_volume, "UO:0000205", "volume per unit volume", "A dimensionless concentration unit which denotes the given volume of the solute in the total volume of the resulting solution.", false},
    {UO_milliliter_per_cubic_meter, "UO:0000206", "milliliter per cubic meter", "A volume per unit volume unit which is equal to one millionth of a liter of solute in one cubic meter of solution.", false},
    {UO_milliliter_per_liter, "UO:0000207", "milliliter per liter", "A volume per unit volume unit which is equal to one millionth of a liter of solute in one liter of solution.", false},
    {UO_gram_per_deciliter, "UO:0000208", "gram per deciliter", "A mass density unit which is equal to mass of an object in grams divided by the volume in deciliters.", false},
    {UO_deciliter, "UO:0000209", "deciliter", "A volume unit which is equal to one tenth of a liter or 10^[-1] L.", false},
    {UO_colony_forming_unit, "UO:0000210", "colony forming unit", "A dimensionless count unit which a measure of viable bacterial numbers.", false},
    {UO_plaque_forming_unit, "UO:0000211", "plaque forming unit", "A dimensionless count unit which a measure of plague forming units in a given volume.", false},
    {UO_colony_forming_unit_per_volume, "UO:0000212", "colony forming unit per volume", "A concentration unit which a measure of viable bacterial numbers in a given volume.", false},
    {UO_colony_forming_unit_per_milliliter, "UO:0000213", "colony forming unit per milliliter", "A colony forming unit which a measure of viable bacterial numbers in one milliliter.", false},
    {UO_plaque_forming_unit_per_volume, "UO:0000214", "plaque forming unit per volume", "A concentration unit which a measure of plague forming units in a given volume.", false},
    {UO_plaque_forming_unit_per_milliliter, "UO:0000215", "plaque forming unit per milliliter", "A concentration unit which a measure of plague forming units in one milliliter.", false},
    {UO_disintegrations_per_second, "UO:0000216", "disintegrations per second", "An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which one nucleus decays per second or there is one atom disintegration per second.", false},
    {UO_electric_potential_difference_unit, "UO:0000217", "electric potential difference unit", "A unit which is a standard measure of the work done per unit charge as a charge is moved between two points in an electric field.", false},
    {UO_volt, "UO:0000218", "volt", "An electric potential difference unit which is equal to the work per unit charge. One volt is the potential difference required to move one coulomb of charge between two points in a circuit while using one joule of energy.", false},
    {UO_electric_charge, "UO:0000219", "electric charge", "A unit which is a standard measure of the quantity of unbalanced electricity in a body (either positive or negative) and construed as an excess or deficiency of electrons.", false},
    {UO_coulomb, "UO:0000220", "coulomb", "An electrical charge unit which is equal to the amount of charge transferred by a current of 1 ampere in 1 second.", false},
    {UO_dalton, "UO:0000221", "dalton", "An independently to the base SI units defined mass unit which is equal to one twelfth of the mass of an unbound atom of the carbon-12 nuclide, at rest and in its ground state.", false},
    {UO_kilodalton, "UO:0000222", "kilodalton", "A mass unit which is equal to one thousand daltons.", false},
    {UO_watt_hour, "UO:0000223", "watt-hour", "An energy unit which is equal to the amount of electrical energy equivalent to a one-watt load drawing power for one hour.", false},
    {UO_kilowatt_hour, "UO:0000224", "kilowatt-hour", "An energy unit which is equal to 1,000 watt-hours.", false},
    {UO_magnetic_flux_unit, "UO:0000225", "magnetic flux unit", "A unit which is a standard measure of quantity of magnetism, taking account of the strength and the extent of a magnetic field.", false},
    {UO_weber, "UO:0000226", "weber", "A magnetic flux unit which is equal to the amount of flux that when linked with a single turn of wire for an interval of one second will induce an electromotive force of one volt.", false},
    {UO_magnetic_flux_density_unit, "UO:0000227", "magnetic flux density unit", "A unit which is a standard measure of the strength of a magnetic field.", false},
    {UO_tesla, "UO:0000228", "tesla", "A magnetic flux density unit which is equal to one weber per square meter.", false},
    {UO_volt_hour, "UO:0000229", "volt-hour", "A magnetic flux unit which is equal to 3600 Wb.", false},
    {UO_kilovolt_hour, "UO:0000230", "kilovolt-hour", "A magnetic flux unit which is equal to one thousand volt-hours.", false},
    {UO_information_unit, "UO:0000231", "information unit", "A unit which is a standard measure of the amount of information.", false},
    {UO_bit, "UO:0000232", "bit", "An information unit which refers to a digit in the binary numeral system, which consists of base 2 digits (ie there are only 2 possible values: 0 or 1).", false},
    {UO_byte, "UO:0000233", "byte", "An information unit which is equal to 8 bits.", false},
    {UO_kilobyte, "UO:0000234", "kilobyte", "An information unit which is equal to 1000 bytes.", false},
    {UO_megabyte, "UO:0000235", "megabyte", "An information unit which is equal to 1000 kB.", false},
    {UO_image_resolution_unit, "UO:0000236", "image resolution unit", "An information unit which is a standard measure of the detail an image holds.", false},
    {UO_chroma_sampling_unit, "UO:0000237", "chroma sampling unit", "An image resolution unit which is a standard measure of the amount of spatial detail in an image.", false},
    {UO_dynamic_range_unit, "UO:0000238", "dynamic range unit", "An image resolution unit which is a standard measure of the amount of contrast available in a pixel.", false},
    {UO_spatial_resolution_unit, "UO:0000239", "spatial resolution unit", "An image resolution unit which is a standard measure of the way luminance and chrominance may be sampled at different levels.", false},
    {UO_dots_per_inch, "UO:0000240", "dots per inch", "A spatial resolution unit which is a standard measure of the printing resolution, in particular the number of individual dots of ink a printer or toner can produce within a linear one-inch space.", false},
    {UO_micron_pixel, "UO:0000241", "micron pixel", "A spatial resolution unit which is equal to a pixel size of one micrometer.", false},
    {UO_pixels_per_inch, "UO:0000242", "pixels per inch", "A spatial resolution unit which is a standard measure of the resolution of a computer display, related to the size of the display in inches and the total number of pixels in the horizontal and vertical directions.", false},
    {UO_pixels_per_millimeter, "UO:0000243", "pixels per millimeter", "A spatial resolution unit which is a standard measure of the number of pixels in one millimeter length or width of a digital image divided by the physical length or width of a printed image.", false},
    {UO_base_pair, "UO:0000244", "base pair", "A count unit which contains one nucleotide.", false},
    {UO_kibibyte, "UO:0000245", "kibibyte", "An information unit which is equal to 1024 B.", false},
    {UO_mebibyte, "UO:0000246", "mebibyte", "An information unit which is equal to 1024 KiB.", false},
    {UO_millivolt, "UO:0000247", "millivolt", "An electric potential difference unit which is equal to one thousandth of a volt or 10^[-3] V.", false},
    {UO_kilovolt, "UO:0000248", "kilovolt", "An electric potential difference unit which is equal to one thousand volts or 10^[3] V.", false},
    {UO_microvolt, "UO:0000249", "microvolt", "An electric potential difference unit which is equal to one millionth of a volt or 10^[-6] V.", false},
    {UO_nanovolt, "UO:0000250", "nanovolt", "An electric potential difference unit which is equal to one billionth of a volt or 10^[-12] V.", false},
    {UO_picovolt, "UO:0000251", "picovolt", "An electric potential difference unit which is equal to one trillionth of a volt or 10^[-12] V.", false},
    {UO_megavolt, "UO:0000252", "megavolt", "An electric potential difference unit which is equal to one million volts or 10^[6] V.", false},
    {UO_surface_tension_unit, "UO:0000253", "surface tension unit", "A unit which is a standard measure of the ability of a liguid to attraction of molecules at its surface as a result of unbalanced molecular cohesive forces.", false},
    {UO_newton_per_meter, "UO:0000254", "newton per meter", "A surface tension unit which is equal to one newton per meter.", false},
    {UO_dyne_per_cm, "UO:0000255", "dyne per cm", "A surface tension unit which is equal to one dyne per centimeter.", false},
    {UO_viscosity_unit, "UO:0000256", "viscosity unit", "A unit which is a standard measure of the internal resistance of fluids to flow.", false},
    {UO_pascal_second, "UO:0000257", "pascal second", "A viscosity unit which is equal to one pascale per second.", false},
    {UO_poise, "UO:0000258", "poise", "A viscosity unit which is equal to one dyne second per square centimeter.", false},
    {UO_decibel, "UO:0000259", "decibel", "A ratio unit which is an indicator of sound power per unit area.", false},
    {UO_effective_dose_unit, "UO:0000260", "effective dose unit", "A unit which is a standard measure of the estimate of the stochastic effect that a non-uniform radiation dose has on a human.", false},
    {UO_conduction_unit, "UO:0000261", "conduction unit", "A unit which represents a standard measurement of the transmission of an entity through a medium.", false},
    {UO_electrical_conduction_unit, "UO:0000262", "electrical conduction unit", "A unit which represents a standard measurement of the movement of electrically charged particles through a transmission medium (electrical conductor).", false},
    {UO_heat_conduction_unit, "UO:0000263", "heat conduction unit", "A unit which represents a standard measurement of the spontaneous transfer of thermal energy through matter, from a region of higher temperature to a region of lower temperature.", false},
    {UO_siemens, "UO:0000264", "siemens", "An electrical conduction unit which is equal to A/V.", false},
    {UO_watt_per_meter_kelvin, "UO:0000265", "watt per meter kelvin", "An heat conduction unit which is equal to one watt divided by meter kelvin.", false},
    {UO_electronvolt, "UO:0000266", "electronvolt", "A non-SI unit of energy (eV) defined as the energy acquired by a single unbound electron when it passes through an electrostatic potential difference of one volt. An electronvolt is equal to 1.602 176 53(14) x 10^-19 J.", false},
    {UO_electric_field_strength_unit, "UO:0000267", "electric field strength unit", "The electric field strength is a unit which is a measure of the potential difference between two points some distance apart.", false},
    {UO_volt_per_meter, "UO:0000268", "volt per meter", "The volt per meter is a unit of electric field strength equal to the a potential difference of 1 volt existing between two points that are 1 meter apart.", false},
    {UO_absorbance_unit, "UO:0000269", "absorbance unit", "A dimensionless logarithmic unit assigned to a measure of absorbance of light through a partially absorbing substance, defined as -log10(I/I_0) where I = transmitted light and I_0 = incident light.", false},
    {UO_volumetric_flow_rate_unit, "UO:0000270", "volumetric flow rate unit", "A unit which is a standard measure of the volume of fluid which passes through a given surface per unit time .", false},
    {UO_microliters_per_minute, "UO:0000271", "microliters per minute", "A volumetric flow rate unit which is equal to one microliter volume through a given surface in one minute.", false},
    {UO_millimetres_of_mercury, "UO:0000272", "millimetres of mercury", "A unit of pressure equal to the amount of fluid pressure one millimeter deep in mercury at zero degrees centigrade on Earth.", false},
    {UO_milligram_per_liter, "UO:0000273", "milligram per liter", "A mass unit density which is equal to mass of an object in milligrams divided by the volume in liters.", false},
    {UO_microgram_per_milliliter, "UO:0000274", "microgram per milliliter", "A mass unit density which is equal to mass of an object in micrograms divided by the volume in millliters.", false},
    {UO_nanogram_per_milliliter, "UO:0000275", "nanogram per milliliter", "A mass unit density which is equal to mass of an object in nanograms divided by the volume in milliliters.", false},
    {UO_amount_per_container, "UO:0000276", "amount per container", "A concentration unit which is a standard measure of the amount of a substance in a given container.", false},
    {UO_ug_disk, "UO:0000277", "ug/disk", "A unit which is equal to one microgram per disk, where a disk is some physical surface/container upon which the substance is deposited.", false},
    {UO_nmole_disk, "UO:0000278", "nmole/disk", "A unit which is equal to one nanomole per disk, where a disk is some physical surface/container upon which the substance is deposited.", false},
    {UO_milliunits_per_milliliter, "UO:0000279", "milliunits per milliliter", "A unit per milliliter unit which is equal to one thousandth of a unit of an agreed arbitrary amount per one milliliter.", false},
    {UO_rate_unit, "UO:0000280", "rate unit", "A unit which represents a standard measurement occurrence of a process per unit time.", false},
    {UO_count_per_nanomolar_second, "UO:0000281", "count per nanomolar second", "A rate unit which is equal to one over one nanomolar second.", false},
    {UO_count_per_molar_second, "UO:0000282", "count per molar second", "A rate unit which is equal to one over one molar second.", false},
    {UO_kilogram_per_hectare, "UO:0000283", "kilogram per hectare", "An area density unit which is equal to the mass of an object in kilograms divided by the surface area in hectares.", false},
    {UO_count_per_nanomolar, "UO:0000284", "count per nanomolar", "A rate unit which is equal to one over one nanomolar.", false},
    {UO_count_per_molar, "UO:0000285", "count per molar", "A rate unit which is equal to one over one molar.", false},
    {UO_yotta, "UO:0000286", "yotta", "A prefix in the metric system denoting a factor of ten to the power of 24.", false},
    {UO_hecto, "UO:0000287", "hecto", "A prefix in the metric system denoting a factor of one hundred.", false},
    {UO_zetta, "UO:0000288", "zetta", "A prefix in the metric system denoting a factor of ten to the power of 21.", false},
    {UO_exa, "UO:0000289", "exa", "A prefix in the metric system denoting a factor of ten to the power of 18.", false},
    {UO_peta, "UO:0000290", "peta", "A prefix in the metric system denoting a factor of ten to the power of 15.", false},
    {UO_tera, "UO:0000291", "tera", "A prefix in the metric system denoting a factor of ten to the power of 12.", false},
    {UO_giga, "UO:0000292", "giga", "A prefix in the metric system denoting a factor of ten to the power of 9.", false},
    {UO_mega, "UO:0000293", "mega", "A prefix in the metric system denoting a factor of million.", false},
    {UO_kilo, "UO:0000294", "kilo", "A prefix in the metric system denoting a factor of one thousand.", false},
    {UO_deca, "UO:0000295", "deca", "A prefix in the metric system denoting a factor of ten.", false},
    {UO_deci, "UO:0000296", "deci", "A prefix in the metric system denoting a factor of one tenth.", false},
    {UO_milli_400000297, "UO:0000297", "milli (UO:400000297)", "A prefix in the metric system denoting a factor of one thousand.", false},
    {UO_centi, "UO:0000298", "centi", "A prefix in the metric system denoting a factor of one hundred.", false},
    {UO_micro, "UO:0000299", "micro", "A prefix in the metric system denoting a factor of 10 to the power of -6.", false},
    {UO_nano, "UO:0000300", "nano", "A prefix in the metric system denoting a factor of 10 to the power of -9.", false},
    {UO_microgram_per_liter, "UO:0000301", "microgram per liter", "A mass unit density which is equal to mass of an object in micrograms divided by the volume in liters.", false},
    {UO_pico, "UO:0000302", "pico", "A prefix in the metric system denoting a factor of 10 to the power of -12.", false},
    {UO_femto, "UO:0000303", "femto", "A prefix in the metric system denoting a factor of 10 to the power of -15.", false},
    {UO_atto, "UO:0000304", "atto", "A prefix in the metric system denoting a factor of 10 to the power of -18.", false},
    {UO_zepto, "UO:0000305", "zepto", "A prefix in the metric system denoting a factor of 10 to the power of -21.", false},
    {UO_yocto, "UO:0000306", "yocto", "A prefix in the metric system denoting a factor of 10 to the power of -24.", false},
    {UO_dose_unit, "UO:0000307", "dose unit", "A concentration unit which is a standard measure of the amount of a toxic or pharmaceutical substance administered to a recipient subject, expressed in terms of the size of the subject.", false},
    {UO_milligram_per_kilogram, "UO:0000308", "milligram per kilogram", "A dose unit which is equal to 1 milligram of a toxic or pharmaceutical substance per kilogram body weight of the recipient subject.", false},
    {UO_milligram_per_square_meter, "UO:0000309", "milligram per square meter", "A dose unit which is equal to 1 milligram of a toxic or pharmaceutical substance per square meter of surface area of the recipient subject.", false},
    {UO_dosage_unit, "UO:0000310", "dosage unit", "A concentration unit which is a standard measure of the amount of a toxic or pharmaceutical substance administered over time to a recipient subject, expressed in terms of the size of the subject.", false},
    {UO_milligram_per_kilogram_per_day, "UO:0000311", "milligram per kilogram per day", "A dosage unit which is equal to 1 milligram per day of a toxic or pharmaceutical substance per kilogram body weight of the recipient subject.", false},
    {UO_relative_light_unit, "UO:0000312", "relative light unit", "A derived unit which is a measure of relative light intensity, as typically measured by a luminometer, spectrophotometer, or fluorimeter in biological research applications.", false},
    {UO_relative_luminescence_unit, "UO:0000313", "relative luminescence unit", "A relative light unit which is a measure of relative luminescence intensity.", false},
    {UO_relative_fluorescence_unit, "UO:0000314", "relative fluorescence unit", "A relative light unit which is a measure of relative fluorescence intensity.", false},
    {UO_turbidity_unit, "UO:0000315", "turbidity unit", "A unit used to indicate the clarity of water or other solutions or suspensions, as measured by the ability of the solution or suspension to scatter light of a defined wavelength range.", false},
    {UO_cells_per_microliter, "UO:0000316", "cells per microliter", "A unit of cell concentration which is equal to one cell in a volume of 1 microliter.", false},
    {UO_cells_per_well, "UO:0000317", "cells per well", "A unit of cell concentration which is equal to 1 cell in a well or discrete container of arbitrary volume.", false},
    {UO_formazin_nephelometric_unit, "UO:0000318", "formazin nephelometric unit", "1000 formazin turbidity units (FNU) on the empirical formazin turbidity scale represents reflectance of insol. reaction products of 0.0725 g hydrazine sulfate with 0.7250 g hexamethylenetetramine diluted to 1 L.", false},
    {UO_radioactivity_concentration, "UO:0000319", "radioactivity concentration", "A concentration unit which is a standard measure of the amount of radioactivity in a given volume.", false},
    {UO_curie_per_liter, "UO:0000320", "curie per liter", "A unit of radioactivity concentration which is equal to one curie in a volume of 1 liter.", false},
    {UO_microcurie_per_milliliter, "UO:0000321", "microcurie per milliliter", "A unit of radioactivity concentration which is equal to one micro curie in a volume of 1 liter.", false},
    {UO_fold_dilution, "UO:0000322", "fold dilution", "A unit that is the ratio of concentration of two solutions of interest, typically with one solution derived from the other by the addition of solvent.", false},
    {UO_ton_per_hectare, "UO:0000323", "ton per hectare", "An area density unit which is equal to the mass of an object in tons divided by the surface area in hectares.", false},
    {UO_square_angstrom, "UO:0000324", "square angstrom", "An area unit which is equal to an area enclosed by a square with sides each 1 angstrom long.", false},
    {UO_megaHertz, "UO:0000325", "megaHertz", "A frequency unit which is equal to one million hertz or 10^[6] V.", false},
    {UO_centiMorgan, "UO:0000326", "centiMorgan", "A unit used to express distances on a genetic map. In genetic mapping, distances between markers are determined by measuring the rate of meoitic recombination between them, which increases proportionately with the distance separating them. A cM is defined as the length of an interval in which there is a 1% probability of recombination. On the average, 1 cM is roughly equivalent to 1 megabase (Mb) of DNA, although this can vary widely due to hot and cold spots of recombination.", false},
    {UO_centiRay, "UO:0000327", "centiRay", "A unit of genetic map distance defined corresponding to an interval in which there is a 1% probability of X-irradiation induced breakage. To be completely specified, the unit must be qualified by the radiation in dosage in rads (e.g. cR8000), because this determines the actual breakage probability.", false},
    {UO_kilo_base_pair, "UO:0000328", "kilo base pair", "A unit equal to one thousand base pairs.", false},
    {UO_mega_base_pair, "UO:0000329", "mega base pair", "A unit equal to one million base pairs", false},
    {UO_giga_base_pair, "UO:0000330", "giga base pair", "A unit equal to one billion base pairs.", false},
    {UO_gigabyte, "UO:0000331", "gigabyte", "An information unit which is equal to 1000000000 bytes.", false},
    {UO_terabyte, "UO:0000332", "terabyte", "An information unit which is equal to 1000 gigabytes.", false},
    {UO_square_micrometer, "UO:0010001", "square micrometer", "An area unit which is equal to an area enclosed by a square with sides each 1 micrometer long.", false},
    {UO_millisiemens, "UO:0010002", "millisiemens", "An electrical conduction unit which is equal to one thousandth of a siemen or 10^[-3] siemens.", false},
    {UO_micromole_per_litre, "UO:0010003", "micromole per litre", "A specific concentration unit which is equal to 1 micromole in a given volume of one thousandth of a cubic meter.", false},
    {UO_micromole_per_kilogram, "UO:0010004", "micromole per kilogram", "A specific concentration unit which is equal to 1 micromole of a given substance per kilogram of solvent.", false},
    {UO_millimeters_per_day, "UO:0010005", "millimeters per day", "A speed/velocity unit which is equal to the speed of an object traveling 1 millimeter distance in one day.", false},
    {UO_ratio_400010006, "UO:0010006", "ratio (UO:400010006)", "A dimensionless ratio unit which, given a pair of quantities a and b, for which b is a multiple of a, denotes b by giving the multiplier (coefficient) c for a to result in b.", false},
    {UO_volt_second_per_square_centimeter, "UO:0010007", "volt-second per square centimeter", "An electrical mobility unit which is equal to one volt second per square centimeter.", false},
    {UO_kilometer_per_hour, "UO:0010008", "kilometer per hour", "A speed/velocity unit which is equal to the speed of an object traveling 1 kilometer distance in one hour.", false},
    {UO_milli_400010009, "UO:0010009", "milli (UO:400010009)", "A mass unit which is equal to 1/12 the mass of 12C", false},
    {UO_hectare, "UO:0010010", "hectare", "An area unit which is equal to an area of 10,000 square meters. Equivalent to 2.471 acres.", false},
    {UO_inch, "UO:0010011", "inch", "A length unit which is equal to 0.0254 metres.", false},
    {UO_thou, "UO:0010012", "thou", "A length unit which is equal to 0.0254 millimetres.", false},
    {UO_foot, "UO:0010013", "foot", "A length unit which is equal to 0.3048 metres, or 12 inches.", false},
    {UO_yard, "UO:0010014", "yard", "A length unit which is equal to 0.9144 metres, or 3 feet.", false},
    {UO_chain, "UO:0010015", "chain", "A length unit which is equal to 20.1168 metres, 66 feet, or 22 yards.", false},
    {UO_furlong, "UO:0010016", "furlong", "A length unit which is equal to 20,116.8 metres, 660 feet, or 10 chains.", false},
    {UO_mile, "UO:0010017", "mile", "A length unit which is equal to 1,609.344 metres, or 8 furlongs.", false},
    {UO_league, "UO:0010018", "league", "A length unit which is equal to 3 miles, or 4,828.032 metres", false},
    {UO_maritime_length_unit, "UO:0010019", "maritime length unit", "A maritime length unit is one used primarily at sea.", false},
    {UO_fathom, "UO:0010020", "fathom", "A maritime length unit which is equal to 6.08 feet, or 1.853184 metres", false},
    {UO_cable, "UO:0010021", "cable", "A maritime length unit which is equal to 608 feet, 100 fathoms, or 185.3184 metres", false},
    {UO_nautical_mile, "UO:0010022", "nautical mile", "A maritime length unit which is equal to 6,080 feet, 10 cables, or 1,853.184 metres", false},
    {UO_perch, "UO:0010023", "perch", "An area unit which is equal to an area of 25.292,852,64 square meters, or 1 square rod.", false},
    {UO_rood, "UO:0010024", "rood", "An area unit which is equivalent to 1 furlong x 1 rod. This is equal to an area of 1,011.714,1056 square meters, or 40 square rods.", false},
    {UO_acre, "UO:0010025", "acre", "An area unit which is equivalent to 1 furlong x 1 chain. This is equal to an area of 4,046.856,4224 square meters, or 43,500 square feet.", false},
    {UO_fluid_ounce, "UO:0010026", "fluid ounce", "An imperial volume unit which is equivalent to 28.413,0625 millilitres.", false},
    {UO_gill, "UO:0010027", "gill", "An imperial volume unit which is equivalent to 142.065,3125 millilitres.", false},
    {UO_pint, "UO:0010028", "pint", "An imperial volume unit which is equivalent to 568.261,25 millilitres.", false},
    {UO_quart, "UO:0010029", "quart", "An imperial volume unit which is equivalent to 1,136.5225 millilitres, or two pints.", false},
    {UO_gallon, "UO:0010030", "gallon", "An imperial volume unit which is equivalent to 4,546.09 millilitres, or 8 pints.", false},
    {UO_grain, "UO:0010031", "grain", "An imperial mass unit which is equivalent to 64.798,91 milligrams.", false},
    {UO_drachm, "UO:0010032", "drachm", "An imperial mass unit which is equivalent to 1.771,845,195,3125 grams, or 1/256 of 1 pound.", false},
    {UO_ounce, "UO:0010033", "ounce", "An imperial mass unit which is equivalent to 28.349,523,125 grams, or 1/16 of 1 pound.", false},
    {UO_pound, "UO:0010034", "pound", "An imperial mass unit which is equivalent to 453.592,37 grams.", false},
    {UO_stone, "UO:0010035", "stone", "An imperial mass unit which is equivalent to 6,350.293,18 grams, or 14 pounds.", false},
    {UO_quarter, "UO:0010036", "quarter", "An imperial mass unit which is equivalent to 12.700,586,36 kilograms, or 28 pounds.", false},
    {UO_hundredweight, "UO:0010037", "hundredweight", "An imperial mass unit which is equivalent to 50.802,345,44 kilograms, 112 pounds, or 8 stone.", false},
    {UO_ton, "UO:0010038", "ton", "An imperial mass unit which is equivalent to 1,016.046,9088 kilograms, or 2,240 pounds.", false},
    {UO_slug, "UO:0010039", "slug", "An imperial gravitational unit which is equivalent to a mass that accelerates by 1ft/s² when a force of one pound (lbf) is exerted on it.", false},
    {UO_teaspoon, "UO:0010040", "teaspoon", "A metric teaspoon is a unit of measurement of volume widely used in cooking recipes and pharmaceutic prescriptions. It equals a 5mL volume.", false},
    {UO_united_states_customary_teaspoon, "UO:0010041", "united states customary teaspoon", "A United States customary units teaspoon is a unit of measurement of volume widely used in cooking recipes and pharmaceutic prescriptions in America. It equals a 4.93 mL volume.", false},
    {UO_tablespoon, "UO:0010042", "tablespoon", "A metric tablespoon is a unit of measurement of volume widely used in cooking recipes and pharmaceutic prescriptions. It equals a 15mL volume.", false},
    {UO_australian_metric_tablespoon, "UO:0010043", "australian metric tablespoon", "An Australian metric tablespoon is a unit of measurement of volume used in Australia for cooking recipes and pharmaceutic prescriptions. It equals a 20mL volume.", false},
    {UO_united_states_customary_tablespoon, "UO:0010044", "united states customary tablespoon", "A United States customary units tablespoon is a unit of measurement of volume widely used in cooking recipes and pharmaceutic prescriptions in America. It equals a 14.79 mL volume.", false},
    {UO_metric_cup, "UO:0010045", "metric cup", "A metric cup is a unit of measurement of volume widely used in cooking recipes and pharmaceutic prescriptions. It equals a 250mL volume.", false},
    {UO_united_states_customary_cup, "UO:0010046", "united states customary cup", "A United States customary units cup is a unit of measurement of volume widely used in cooking recipes and pharmaceutic prescriptions in America. It equals a 236.59 mL volume.", false},
    {UO_united_states_fda_cup, "UO:0010047", "united states fda cup", "A United States FDA cup is a unit of measurement of volume used by the US Federal Department of Agriculture as a nutritional serving measure. It equals a 240 mL volume.", false},
    {UO_micromole_400010048, "UO:0010048", "micromole (UO:400010048)", "A substance unit which is equal to one millionth of a mole.", false},
    {UO_gram_per_square_meter, "UO:0010049", "gram per square meter", "An area density unit which is equal to the mass of an object in grams divided by the surface area in meters squared.", false},
    {UO_nanogram_per_microliter, "UO:0010050", "nanogram per microliter", "A mass unit density which is equal to mass of an object in nanograms divided by the volume in microliters.", false},
    {UO_large_calorie, "UO:0010051", "large calorie", "A unit of energy widely used in nutrition, equivalent to the amount of heat needed to cause one kilogram of water to rise in temperature by one degree Celsius.", false},
    {UO_pounds_per_square_inch, "UO:0010052", "pounds per square inch", "A pressure unit which is equal to 6894.757 pascal.", false},
    {UO_micrograms_per_wheaton_bottle, "UO:0010053", "micrograms per wheaton bottle", "A unit of mass concentration defined as the number of micrograms of a substance per 250 ml Wheaton bottle.", false},
    {UO_picoampere, "UO:0010054", "picoampere", "An electric current unit current which is equal to one trillionth of an ampere or 10^[-12] A.", false},
    {UO_centigray, "UO:0010055", "centigray", "An absorbed dose unit which is equal to 0.01 gray (Gy)", false},
    {UO_gigaelectronvolt, "UO:0010056", "gigaelectronvolt", "A unit of energy that is equal to one thousand million electronvolts.", false},
    {UO_gigaelectronvolt_per_nucleon, "UO:0010057", "gigaelectronvolt per nucleon", "Derived unit which is equal to the total kinetic energy of an atomic nucleus in GeV divided by the number of nucleons in the nucleus", false},
    {UO_megaelectronvolt_per_nucleon, "UO:0010058", "megaelectronvolt per nucleon", "Derived unit which is equal to the total kinetic energy of an atomic nucleus in MeV divided by the number of nucleons in the nucleus", false},
    {UO_kiloelectronvolt_per_micron, "UO:0010059", "kiloelectronvolt per micron", "A derived unit equal to the energy deposited by ionizing radiation per micron of path length in matter", false},
    {UO_gray_per_minute, "UO:0010060", "gray per minute", "A derived absorbed dose unit which is equal to one gray absorbed per minute.", false},
    {UO_centigray_per_minute, "UO:0010061", "centigray per minute", "A derived absorbed dose unit which is equal to one centigray absorbed per minute.", false},
    {UO_milligray_per_minute, "UO:0010062", "milligray per minute", "A derived absorbed dose unit which is equal to one milligray absorbed per minute.", false},
    {UO_milligray_per_day, "UO:0010063", "milligray per day", "A derived absorbed dose unit which is equal to one milligray absorbed per day.", false},
    {UO_milligray_per_hour, "UO:0010064", "milligray per hour", "A derived absorbed dose unit which is equal to one milligray absorbed per hour.", false},
    {UO_milligray_per_second, "UO:0010065", "milligray per second", "A derived absorbed dose unit which is equal to one milligray absorbed per second.", false},
}; // termInfos_


const size_t termInfosSize_ = sizeof(termInfos_)/sizeof(TermInfo);


struct CVIDPair
{
    CVID first;
    CVID second;
};


CVIDPair relationsIsA_[] =
{
    {PEFF_PEFF_file_header_section_term, PEFF_PEFF_CV_term},
    {PEFF_PEFF_file_sequence_entry_term, PEFF_PEFF_CV_term},
    {PEFF_DbName, PEFF_PEFF_file_header_section_term},
    {PEFF_Prefix, PEFF_PEFF_file_header_section_term},
    {PEFF_DbDescription, PEFF_PEFF_file_header_section_term},
    {PEFF_Decoy, PEFF_PEFF_file_header_section_term},
    {PEFF_DbSource, PEFF_PEFF_file_header_section_term},
    {PEFF_DbVersion, PEFF_PEFF_file_header_section_term},
    {PEFF_DbDate_OBSOLETE, PEFF_PEFF_file_header_section_term},
    {PEFF_NumberOfEntries, PEFF_PEFF_file_header_section_term},
    {PEFF_Conversion, PEFF_PEFF_file_header_section_term},
    {PEFF_SequenceType, PEFF_PEFF_file_header_section_term},
    {PEFF_SpecificKey, PEFF_PEFF_file_header_section_term},
    {PEFF_SpecificValue, PEFF_PEFF_file_header_section_term},
    {PEFF_DatabaseDescription, PEFF_PEFF_file_header_section_term},
    {PEFF_GeneralComment, PEFF_PEFF_file_header_section_term},
    {PEFF_ProteoformDb, PEFF_PEFF_file_header_section_term},
    {PEFF_OptionalTagDef, PEFF_PEFF_file_header_section_term},
    {PEFF_HasAnnotationIdentifiers, PEFF_PEFF_file_header_section_term},
    {PEFF_DbUniqueId_OBSOLETE, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_PName, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_NcbiTaxId, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_TaxName, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_GName, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Length, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_SV, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_EV, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_PE, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Processed, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Variant_OBSOLETE, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_ModResPsi, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_ModRes, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_AltAC, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_SeqStatus, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_CC, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_KW, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_GO, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_XRef, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_mature_protein, PEFF_PEFF_molecule_processing_keyword},
    {PEFF_signal_peptide, PEFF_PEFF_molecule_processing_keyword},
    {PEFF_transit_peptide, PEFF_PEFF_molecule_processing_keyword},
    {PEFF_Conflict, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Crc64, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Domain, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_ID, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_ModResUnimod, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_VariantSimple, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_VariantComplex, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Proteoform, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_DisulfideBond, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_PEFF_molecule_processing_keyword, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_Comment, PEFF_PEFF_file_sequence_entry_term},
    {PEFF_propeptide, PEFF_PEFF_molecule_processing_keyword},
    {PEFF_initiator_methionine, PEFF_PEFF_molecule_processing_keyword},
    {NCIT_Technique, NCIT_Activity},
    {NCIT_Statistical_Technique, NCIT_Technique},
    {NCIT_Temporal_Qualifier, NCIT_Qualifier},
    {NCIT_Duration, NCIT_Temporal_Qualifier},
    {NCIT_Action, NCIT_Activity},
    {NCIT_Characteristic, NCIT_Property_or_Attribute},
    {NCIT_Qualifier, NCIT_Property_or_Attribute},
    {NCIT_Density, NCIT_Characteristic},
    {NCIT_Principal_Component, NCIT_Statistical_Technique},
    {NCIT_Cover, NCIT_Action},
    {NCIT_Outlier, NCIT_Conceptual_Entity},
    {MS_sample_number, MS_sample_attribute},
    {MS_sample_name, MS_sample_attribute},
    {MS_sample_state, MS_sample_attribute},
    {MS_sample_mass, MS_sample_attribute},
    {MS_sample_volume, MS_sample_attribute},
    {MS_sample_concentration, MS_sample_attribute},
    {MS_mass_resolution, MS_scan_attribute},
    {MS_resolution_measurement_method, MS_measurement_method},
    {MS_accuracy, MS_mass_analyzer_attribute},
    {MS_scan_rate, MS_scan_attribute},
    {MS_scan_start_time, MS_scan_attribute},
    {MS_scan_start_time, MS_PSM_level_attribute},
    {MS_reflectron_state, MS_mass_analyzer_attribute},
    {MS_TOF_Total_Path_Length, MS_mass_analyzer_attribute},
    {MS_final_MS_exponent, MS_mass_analyzer_attribute},
    {MS_magnetic_field_strength, MS_mass_analyzer_attribute},
    {MS_detector_resolution, MS_detector_attribute},
    {MS_sampling_frequency, MS_detector_attribute},
    {MS_customization, MS_instrument_attribute},
    {MS_deisotoping, MS_data_processing_action},
    {MS_charge_deconvolution, MS_data_processing_action},
    {MS_peak_picking, MS_data_processing_action},
    {MS_charge_state, MS_ion_selection_attribute},
    {MS_charge_state, MS_ion_property},
    {MS_peak_intensity, MS_ion_selection_attribute},
    {MS_collision_energy, MS_precursor_activation_attribute},
    {MS_emulsion, MS_sample_state},
    {MS_gaseous_sample_state, MS_sample_state},
    {MS_liquid_sample_state, MS_sample_state},
    {MS_solid_sample_state, MS_sample_state},
    {MS_solution, MS_sample_state},
    {MS_suspension, MS_sample_state},
    {MS_sample_batch, MS_sample_attribute},
    {MS_continuous_flow_fast_atom_bombardment, MS_inlet_type},
    {MS_direct_inlet, MS_inlet_type},
    {MS_electrospray_inlet, MS_inlet_type},
    {MS_flow_injection_analysis, MS_inlet_type},
    {MS_inductively_coupled_plasma, MS_inlet_type},
    {MS_infusion, MS_inlet_type},
    {MS_jet_separator, MS_inlet_type},
    {MS_membrane_separator, MS_inlet_type},
    {MS_moving_belt, MS_inlet_type},
    {MS_moving_wire, MS_inlet_type},
    {MS_open_split, MS_inlet_type},
    {MS_particle_beam, MS_inlet_type},
    {MS_reservoir, MS_inlet_type},
    {MS_septum, MS_inlet_type},
    {MS_thermospray_inlet, MS_inlet_type},
    {MS_atmospheric_pressure_chemical_ionization, MS_atmospheric_pressure_ionization},
    {MS_chemical_ionization, MS_ionization_type},
    {MS_electrospray_ionization, MS_ionization_type},
    {MS_fast_atom_bombardment_ionization, MS_ionization_type},
    {MS_matrix_assisted_laser_desorption_ionization, MS_desorption_ionization},
    {MS_axial_ejection_linear_ion_trap, MS_linear_ion_trap},
    {MS_fourier_transform_ion_cyclotron_resonance_mass_spectrometer, MS_mass_analyzer_type},
    {MS_magnetic_sector, MS_mass_analyzer_type},
    {MS_quadrupole, MS_mass_analyzer_type},
    {MS_quadrupole_ion_trap, MS_ion_trap},
    {MS_radial_ejection_linear_ion_trap, MS_linear_ion_trap},
    {MS_time_of_flight, MS_mass_analyzer_type},
    {MS_baseline, MS_resolution_measurement_method},
    {MS_full_width_at_half_maximum, MS_resolution_measurement_method},
    {MS_ten_percent_valley, MS_resolution_measurement_method},
    {MS_decreasing_m_z_scan, MS_scan_direction},
    {MS_increasing_m_z_scan, MS_scan_direction},
    {MS_exponential, MS_scan_law},
    {MS_linear_OBSOLETE, MS_scan_law},
    {MS_quadratic, MS_scan_law},
    {MS_reflectron_off, MS_reflectron_state},
    {MS_reflectron_on, MS_reflectron_state},
    {MS_channeltron, MS_detector_type},
    {MS_conversion_dynode_electron_multiplier, MS_conversion_dynode},
    {MS_conversion_dynode_photomultiplier, MS_conversion_dynode},
    {MS_daly_detector, MS_detector_type},
    {MS_electron_multiplier_tube, MS_electron_multiplier},
    {MS_faraday_cup, MS_detector_type},
    {MS_focal_plane_array, MS_focal_plane_collector},
    {MS_microchannel_plate_detector, MS_array_detector},
    {MS_multi_collector, MS_detector_type},
    {MS_photomultiplier, MS_detector_type},
    {MS_analog_digital_converter, MS_detector_acquisition_mode},
    {MS_pulse_counting, MS_detector_acquisition_mode},
    {MS_time_digital_converter, MS_detector_acquisition_mode},
    {MS_transient_recorder, MS_detector_acquisition_mode},
    {MS_SCIEX_instrument_model, MS_instrument_model},
    {MS_Bruker_Daltonics_instrument_model, MS_instrument_model},
    {MS_IonSpec_instrument_model, MS_Varian_instrument_model},
    {MS_Shimadzu_instrument_model, MS_instrument_model},
    {MS_Thermo_Finnigan_instrument_model, MS_Thermo_Fisher_Scientific_instrument_model},
    {MS_Waters_instrument_model, MS_instrument_model},
    {MS_centroid_spectrum, MS_spectrum_representation},
    {MS_profile_spectrum, MS_spectrum_representation},
    {MS_negative_scan, MS_scan_polarity},
    {MS_negative_scan, MS_chromatogram_attribute},
    {MS_positive_scan, MS_scan_polarity},
    {MS_positive_scan, MS_chromatogram_attribute},
    {MS_number_of_detector_counts, MS_intensity_unit},
    {MS_percent_of_base_peak, MS_intensity_unit},
    {MS_collision_induced_dissociation, MS_dissociation_method},
    {MS_plasma_desorption, MS_dissociation_method},
    {MS_post_source_decay, MS_dissociation_method},
    {MS_surface_induced_dissociation, MS_dissociation_method},
    {MS_normalized_collision_energy, MS_precursor_activation_attribute},
    {MS_4000_QTRAP, MS_SCIEX_instrument_model},
    {MS_4700_Proteomics_Analyzer, MS_Applied_Biosystems_instrument_model},
    {MS_apex_IV, MS_Bruker_Daltonics_apex_series},
    {MS_apex_Q, MS_Bruker_Daltonics_apex_series},
    {MS_API_150EX, MS_SCIEX_instrument_model},
    {MS_API_150EX_Prep, MS_SCIEX_instrument_model},
    {MS_API_2000, MS_SCIEX_instrument_model},
    {MS_API_3000, MS_SCIEX_instrument_model},
    {MS_API_4000, MS_SCIEX_instrument_model},
    {MS_autoflex_II, MS_Bruker_Daltonics_flex_series},
    {MS_autoflex_TOF_TOF, MS_Bruker_Daltonics_flex_series},
    {MS_Auto_Spec_Ultima_NT, MS_Waters_instrument_model},
    {MS_BioTOF_II, MS_Bruker_Daltonics_BioTOF_series},
    {MS_BioTOF_Q, MS_Bruker_Daltonics_BioTOF_series},
    {MS_DELTA_plusAdvantage, MS_Thermo_Finnigan_instrument_model},
    {MS_DELTAplusXP, MS_Thermo_Finnigan_instrument_model},
    {MS_esquire_4000, MS_Bruker_Daltonics_esquire_series},
    {MS_esquire_6000, MS_Bruker_Daltonics_esquire_series},
    {MS_explorer, MS_IonSpec_instrument_model},
    {MS_GCT, MS_Waters_instrument_model},
    {MS_HCT, MS_Bruker_Daltonics_HCT_Series},
    {MS_HCTplus, MS_Bruker_Daltonics_HCT_Series},
    {MS_HiRes_ESI, MS_IonSpec_instrument_model},
    {MS_HiRes_MALDI, MS_IonSpec_instrument_model},
    {MS_IsoPrime, MS_Waters_instrument_model},
    {MS_IsoProbe, MS_Waters_instrument_model},
    {MS_IsoProbe_T, MS_Waters_instrument_model},
    {MS_LCQ_Advantage, MS_Thermo_Finnigan_instrument_model},
    {MS_LCQ_Classic, MS_Thermo_Finnigan_instrument_model},
    {MS_LCQ_Deca_XP_Plus, MS_Thermo_Finnigan_instrument_model},
    {MS_M_LDI_L, MS_Waters_instrument_model},
    {MS_M_LDI_LR, MS_Waters_instrument_model},
    {MS_MAT253, MS_Finnigan_MAT_instrument_model},
    {MS_MAT900XP, MS_Finnigan_MAT_instrument_model},
    {MS_MAT900XP_Trap, MS_Finnigan_MAT_instrument_model},
    {MS_MAT95XP, MS_Finnigan_MAT_instrument_model},
    {MS_MAT95XP_Trap, MS_Finnigan_MAT_instrument_model},
    {MS_microflex, MS_Bruker_Daltonics_flex_series},
    {MS_microTOF_LC, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_neptune, MS_Thermo_Finnigan_instrument_model},
    {MS_NG_5400, MS_Waters_instrument_model},
    {MS_OMEGA, MS_IonSpec_instrument_model},
    {MS_OMEGA_2001, MS_IonSpec_instrument_model},
    {MS_OmniFlex, MS_Bruker_Daltonics_flex_series},
    {MS_Platform_ICP, MS_Waters_instrument_model},
    {MS_PolarisQ, MS_Thermo_Finnigan_instrument_model},
    {MS_proteomics_solution_1, MS_SCIEX_instrument_model},
    {MS_Q_TRAP, MS_SCIEX_instrument_model},
    {MS_Q_Tof_micro, MS_Waters_instrument_model},
    {MS_Q_Tof_Ultima, MS_Waters_instrument_model},
    {MS_QSTAR, MS_SCIEX_instrument_model},
    {MS_quattro_micro, MS_Waters_instrument_model},
    {MS_Quattro_Ultima, MS_Waters_instrument_model},
    {MS_Surveyor_MSQ, MS_Thermo_Finnigan_instrument_model},
    {MS_SymBiot_I, MS_SCIEX_instrument_model},
    {MS_SymBiot_XVI, MS_SCIEX_instrument_model},
    {MS_TEMPUS_TOF, MS_Thermo_Finnigan_instrument_model},
    {MS_TRACE_DSQ, MS_Thermo_Finnigan_instrument_model},
    {MS_TRITON, MS_Thermo_Finnigan_instrument_model},
    {MS_TSQ_Quantum, MS_Thermo_Finnigan_instrument_model},
    {MS_ultima, MS_IonSpec_instrument_model},
    {MS_ultraflex, MS_Bruker_Daltonics_flex_series},
    {MS_ultraflex_TOF_TOF, MS_Bruker_Daltonics_flex_series},
    {MS_Voyager_DE_PRO, MS_Applied_Biosystems_instrument_model},
    {MS_Voyager_DE_STR, MS_Applied_Biosystems_instrument_model},
    {MS_selected_ion_monitoring, MS_data_independent_acquisition},
    {MS_selected_ion_monitoring, MS_mass_spectrometry_acquisition_method},
    {MS_selected_reaction_monitoring, MS_data_independent_acquisition},
    {MS_selected_reaction_monitoring, MS_mass_spectrometry_acquisition_method},
    {MS_base_peak, MS_peak},
    {MS_field_free_region, MS_ion_optics_attribute},
    {MS_magnetic_deflection, MS_ion_optics_type},
    {MS_molecular_mass, MS_molecular_entity_property},
    {MS_multiphoton_ionization, MS_ionization_type},
    {MS_total_ion_current_chromatogram, MS_ion_current_chromatogram},
    {MS_transmission, MS_instrument_attribute},
    {MS_atmospheric_pressure_matrix_assisted_laser_desorption_ionization, MS_atmospheric_pressure_ionization},
    {MS_atmospheric_pressure_ionization, MS_ionization_type},
    {MS_blackbody_infrared_radiative_dissociation, MS_dissociation_method},
    {MS_charge_stripping, MS_precursor_activation_attribute},
    {MS_delayed_extraction, MS_ion_optics_type},
    {MS_desorption_ionization, MS_ionization_type},
    {MS_direct_insertion_probe, MS_inlet_type},
    {MS_direct_liquid_introduction, MS_inlet_type},
    {MS_electron_capture_dissociation, MS_dissociation_method},
    {MS_electron_multiplier, MS_detector_type},
    {MS_electrostatic_energy_analyzer, MS_mass_analyzer_type},
    {MS_flowing_afterglow, MS_ionization_type},
    {MS_field_desorption, MS_desorption_ionization},
    {MS_field_ionization, MS_ionization_type},
    {MS_glow_discharge_ionization, MS_ionization_type},
    {MS_infrared_multiphoton_dissociation, MS_photodissociation},
    {MS_ion_trap, MS_mass_analyzer_type},
    {MS_Negative_Ion_chemical_ionization, MS_ionization_type},
    {MS_neutralization_reionization_mass_spectrometry, MS_ionization_type},
    {MS_photoionization, MS_ionization_type},
    {MS_pyrolysis_mass_spectrometry, MS_ionization_type},
    {MS_collision_quadrupole, MS_ion_optics_type},
    {MS_resonance_enhanced_multiphoton_ionization, MS_ionization_type},
    {MS_surface_enhanced_laser_desorption_ionization, MS_surface_ionization},
    {MS_surface_enhanced_neat_desorption, MS_surface_ionization},
    {MS_selected_ion_flow_tube, MS_ion_optics_type},
    {MS_sustained_off_resonance_irradiation, MS_dissociation_method},
    {MS_stored_waveform_inverse_fourier_transform, MS_mass_analyzer_type},
    {MS_total_ion_current, MS_spectrum_property},
    {MS_time_lag_focusing, MS_ion_optics_type},
    {MS_cyclotron, MS_mass_analyzer_type},
    {MS_linear_ion_trap, MS_ion_trap},
    {MS_mass_spectrum, MS_data_file_content},
    {MS_mass_spectrum, MS_spectrum_type},
    {MS_reflectron, MS_ion_optics_type},
    {MS_accelerating_voltage, MS_ion_optics_attribute},
    {MS_einzel_lens, MS_ion_optics_type},
    {MS_electric_field_strength, MS_ion_optics_attribute},
    {MS_first_stability_region, MS_ion_optics_type},
    {MS_fringing_field, MS_ion_optics_type},
    {MS_kinetic_energy_analyzer, MS_ion_optics_type},
    {MS_space_charge_effect, MS_ion_optics_attribute},
    {MS_static_field, MS_ion_optics_type},
    {MS_charge_inversion_mass_spectrum, MS_mass_spectrum},
    {MS_constant_neutral_gain_spectrum, MS_mass_spectrum},
    {MS_constant_neutral_loss_spectrum, MS_mass_spectrum},
    {MS_e_2_mass_spectrum, MS_mass_spectrum},
    {MS_neutral_loss, MS_modification_parameters},
    {MS_precursor_ion_spectrum, MS_mass_spectrum},
    {MS_product_ion_spectrum_OBSOLETE, MS_mass_spectrum},
    {MS_array_detector, MS_detector_type},
    {MS_conversion_dynode, MS_detector_type},
    {MS_dynode, MS_detector_type},
    {MS_focal_plane_collector, MS_detector_type},
    {MS_ion_to_photon_detector, MS_detector_type},
    {MS_point_collector, MS_detector_type},
    {MS_postacceleration_detector, MS_detector_type},
    {MS_adduct_ion, MS_adduct},
    {MS_adiabatic_ionization, MS_ionization_type},
    {MS_associative_ionization, MS_ionization_type},
    {MS_atmospheric_pressure_photoionization, MS_atmospheric_pressure_ionization},
    {MS_autodetachment, MS_ionization_type},
    {MS_autoionization, MS_ionization_type},
    {MS_charge_exchange_ionization, MS_ionization_type},
    {MS_chemi_ionization, MS_ionization_type},
    {MS_desorption_ionization_on_silicon, MS_desorption_ionization},
    {MS_dissociative_ionization, MS_ionization_type},
    {MS_electron_ionization, MS_ionization_type},
    {MS_ionization_efficiency, MS_source_attribute},
    {MS_laser_desorption_ionization, MS_desorption_ionization},
    {MS_liquid_secondary_ionization, MS_ionization_type},
    {MS_membrane_inlet, MS_inlet_type},
    {MS_microelectrospray, MS_electrospray_ionization},
    {MS_nanoelectrospray, MS_electrospray_ionization},
    {MS_penning_ionization, MS_ionization_type},
    {MS_plasma_desorption_ionization, MS_ionization_type},
    {MS_secondary_ionization, MS_ionization_type},
    {MS_soft_ionization, MS_ionization_type},
    {MS_spark_ionization, MS_ionization_type},
    {MS_surface_assisted_laser_desorption_ionization, MS_desorption_ionization},
    {MS_surface_ionization, MS_ionization_type},
    {MS_thermal_ionization, MS_ionization_type},
    {MS_vertical_ionization, MS_ionization_type},
    {MS_buffer_gas, MS_precursor_activation_attribute},
    {MS_collision_gas, MS_precursor_activation_attribute},
    {MS_beam_type_collision_induced_dissociation, MS_collision_induced_dissociation},
    {MS_low_energy_collision_induced_dissociation, MS_dissociation_method},
    {MS_photodissociation, MS_dissociation_method},
    {MS_fast_ion_bombardment, MS_ionization_type},
    {MS_LTQ, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_FT, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_Orbitrap, MS_Thermo_Scientific_instrument_model},
    {MS_LXQ, MS_Thermo_Scientific_instrument_model},
    {MS_ion_selection_attribute, MS_object_attribute},
    {MS_1200_series_LC_MSD_SL, MS_Agilent_instrument_model},
    {MS_6110_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6120A_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6130_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6140_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6210_Time_of_Flight_LC_MS, MS_Agilent_instrument_model},
    {MS_6310_Ion_Trap_LC_MS, MS_Agilent_instrument_model},
    {MS_6320_Ion_Trap_LC_MS, MS_Agilent_instrument_model},
    {MS_6330_Ion_Trap_LC_MS, MS_Agilent_instrument_model},
    {MS_6340_Ion_Trap_LC_MS, MS_Agilent_instrument_model},
    {MS_6410_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_1200_series_LC_MSD_VL, MS_Agilent_instrument_model},
    {MS_Thermo_Fisher_Scientific_instrument_model, MS_instrument_model},
    {MS_orbitrap, MS_mass_analyzer_type},
    {MS_nanospray_inlet, MS_electrospray_inlet},
    {MS_source_potential, MS_source_attribute},
    {MS_ion_optics_attribute, MS_ion_optics},
    {MS_Hitachi_instrument_model, MS_instrument_model},
    {MS_Varian_instrument_model, MS_instrument_model},
    {MS_Agilent_instrument_model, MS_instrument_model},
    {MS_Dionex_instrument_model, MS_instrument_model},
    {MS_Thermo_Electron_instrument_model, MS_Thermo_Fisher_Scientific_instrument_model},
    {MS_Finnigan_MAT_instrument_model, MS_Thermo_Fisher_Scientific_instrument_model},
    {MS_Thermo_Scientific_instrument_model, MS_Thermo_Fisher_Scientific_instrument_model},
    {MS_Applied_Biosystems_instrument_model, MS_instrument_model},
    {MS_instrument_attribute, MS_object_attribute},
    {MS_zoom_scan, MS_scan_attribute},
    {MS_scan_window_upper_limit, MS_selection_window_attribute},
    {MS_scan_window_lower_limit, MS_selection_window_attribute},
    {MS_dwell_time, MS_scan_attribute},
    {MS_scan_attribute, MS_object_attribute},
    {MS_base_peak_m_z, MS_spectrum_property},
    {MS_base_peak_intensity, MS_spectrum_property},
    {MS_activation_energy, MS_precursor_activation_attribute},
    {MS_ms_level, MS_spectrum_attribute},
    {MS_filter_string, MS_scan_attribute},
    {MS_m_z_array, MS_binary_data_array},
    {MS_intensity_array, MS_binary_data_array},
    {MS_charge_array, MS_binary_data_array},
    {MS_signal_to_noise_array, MS_binary_data_array},
    {MS_32_bit_integer, MS_binary_data_type},
    {MS_16_bit_float_OBSOLETE, MS_binary_data_type},
    {MS_32_bit_float, MS_binary_data_type},
    {MS_64_bit_integer, MS_binary_data_type},
    {MS_64_bit_float, MS_binary_data_type},
    {MS_Waters_raw_format, MS_mass_spectrometer_file_format},
    {MS_highest_observed_m_z, MS_chromatogram_attribute},
    {MS_highest_observed_m_z, MS_spectrum_property},
    {MS_lowest_observed_m_z, MS_chromatogram_attribute},
    {MS_lowest_observed_m_z, MS_spectrum_property},
    {MS_instrument_serial_number, MS_instrument_attribute},
    {MS_file_format_conversion, MS_data_transformation},
    {MS_Xcalibur, MS_Thermo_Finnigan_software},
    {MS_Xcalibur, MS_acquisition_software},
    {MS_Xcalibur, MS_analysis_software},
    {MS_Xcalibur, MS_data_processing_software},
    {MS_Bioworks, MS_Thermo_Finnigan_software},
    {MS_Bioworks, MS_analysis_software},
    {MS_Bioworks, MS_data_processing_software},
    {MS_MassLynx, MS_Waters_software},
    {MS_MassLynx, MS_acquisition_software},
    {MS_MassLynx, MS_analysis_software},
    {MS_MassLynx, MS_data_processing_software},
    {MS_FlexAnalysis, MS_Bruker_software},
    {MS_FlexAnalysis, MS_analysis_software},
    {MS_FlexAnalysis, MS_data_processing_software},
    {MS_Data_Explorer, MS_Applied_Biosystems_software},
    {MS_Data_Explorer, MS_acquisition_software},
    {MS_Data_Explorer, MS_analysis_software},
    {MS_Data_Explorer, MS_data_processing_software},
    {MS_4700_Explorer, MS_Applied_Biosystems_software},
    {MS_4700_Explorer, MS_acquisition_software},
    {MS_4700_Explorer, MS_analysis_software},
    {MS_4700_Explorer, MS_data_processing_software},
    {MS_massWolf, MS_data_processing_software},
    {MS_Voyager_Biospectrometry_Workstation_System, MS_Applied_Biosystems_software},
    {MS_Voyager_Biospectrometry_Workstation_System, MS_acquisition_software},
    {MS_Voyager_Biospectrometry_Workstation_System, MS_analysis_software},
    {MS_Voyager_Biospectrometry_Workstation_System, MS_data_processing_software},
    {MS_FlexControl, MS_Bruker_software},
    {MS_FlexControl, MS_acquisition_software},
    {MS_ReAdW, MS_data_processing_software},
    {MS_MzStar, MS_data_processing_software},
    {MS_data_processing_action, MS_data_transformation},
    {MS_Conversion_to_mzML, MS_file_format_conversion},
    {MS_Conversion_to_mzXML, MS_file_format_conversion},
    {MS_Conversion_to_mzData, MS_file_format_conversion},
    {MS_sample_attribute, MS_object_attribute},
    {MS_selection_window_attribute, MS_object_attribute},
    {MS_Analyst, MS_SCIEX_software},
    {MS_Analyst, MS_acquisition_software},
    {MS_Analyst, MS_analysis_software},
    {MS_Analyst, MS_data_processing_software},
    {MS_Trapper, MS_data_processing_software},
    {MS_LCQ_Deca, MS_Thermo_Finnigan_instrument_model},
    {MS_LTQ_Orbitrap_Discovery, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_Orbitrap_XL, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_FT_Ultra, MS_Thermo_Scientific_instrument_model},
    {MS_GC_Quantum, MS_Thermo_Finnigan_instrument_model},
    {MS_mass_spectrometer_file_format, MS_file_format},
    {MS_ABI_WIFF_format, MS_mass_spectrometer_file_format},
    {MS_Thermo_RAW_format, MS_mass_spectrometer_file_format},
    {MS_PSI_mzData_format, MS_mass_spectrometer_file_format},
    {MS_Micromass_PKL_format, MS_mass_spectrometer_file_format},
    {MS_ISB_mzXML_format, MS_mass_spectrometer_file_format},
    {MS_Bruker_Agilent_YEP_format, MS_mass_spectrometer_file_format},
    {MS_MD5, MS_data_file_checksum_type},
    {MS_SHA_1, MS_data_file_checksum_type},
    {MS_sum_of_spectra, MS_spectra_combination},
    {MS_median_of_spectra, MS_spectra_combination},
    {MS_zlib_compression, MS_binary_data_compression_type},
    {MS_mean_of_spectra, MS_spectra_combination},
    {MS_no_compression, MS_binary_data_compression_type},
    {MS_source_data_file, MS_spectrum_attribute},
    {MS_LCQ_Fleet, MS_Thermo_Finnigan_instrument_model},
    {MS_MS1_spectrum, MS_mass_spectrum},
    {MS_MSn_spectrum, MS_mass_spectrum},
    {MS_CRM_spectrum, MS_mass_spectrum},
    {MS_SIM_spectrum, MS_mass_spectrum},
    {MS_SRM_spectrum, MS_mass_spectrum},
    {MS_mzML_format, MS_mass_spectrometer_file_format},
    {MS_contact_attribute, MS_object_attribute},
    {MS_contact_name, MS_contact_attribute},
    {MS_contact_address, MS_contact_attribute},
    {MS_contact_URL, MS_contact_attribute},
    {MS_contact_email, MS_contact_attribute},
    {MS_contact_affiliation, MS_contact_attribute},
    {MS_MzWiff, MS_data_processing_software},
    {MS_smoothing, MS_data_processing_action},
    {MS_baseline_reduction, MS_data_processing_action},
    {MS_low_intensity_data_point_removal, MS_data_filtering},
    {MS_time_array, MS_binary_data_array},
    {MS_ion_optics_type, MS_ion_optics},
    {MS_electron_transfer_dissociation, MS_dissociation_method},
    {MS_pulsed_q_dissociation, MS_dissociation_method},
    {MS_Proteios, MS_analysis_software},
    {MS_Proteios, MS_data_processing_software},
    {MS_ProteinLynx_Global_Server, MS_Waters_software},
    {MS_ProteinLynx_Global_Server, MS_analysis_software},
    {MS_ProteinLynx_Global_Server, MS_data_processing_software},
    {MS_Shimadzu_MALDI_TOF_instrument_model, MS_Shimadzu_instrument_model},
    {MS_Shimadzu_Scientific_Instruments_instrument_model, MS_Shimadzu_instrument_model},
    {MS_LCMS_IT_TOF, MS_Shimadzu_Scientific_Instruments_instrument_model},
    {MS_LCMS_2010EV, MS_Shimadzu_Scientific_Instruments_instrument_model},
    {MS_LCMS_2010A, MS_Shimadzu_Scientific_Instruments_instrument_model},
    {MS_AXIMA_CFR_MALDI_TOF, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_AXIMA_QIT, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_AXIMA_CFR_plus, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_AXIMA_Performance_MALDI_TOF_TOF, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_AXIMA_Confidence_MALDI_TOF, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_AXIMA_Assurance_Linear_MALDI_TOF, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_DTA_format, MS_mass_spectrometer_file_format},
    {MS_ProteinLynx_Global_Server_mass_spectrum_XML_format, MS_mass_spectrometer_file_format},
    {MS_ProteoWizard_software, MS_analysis_software},
    {MS_ProteoWizard_software, MS_data_processing_software},
    {MS_preset_scan_configuration, MS_scan_attribute},
    {MS_wavelength_array, MS_binary_data_array},
    {MS_highest_observed_wavelength, MS_spectrum_property},
    {MS_highest_observed_wavelength, MS_chromatogram_attribute},
    {MS_lowest_observed_wavelength, MS_spectrum_property},
    {MS_lowest_observed_wavelength, MS_chromatogram_attribute},
    {MS_PDA_spectrum_OBSOLETE, MS_data_file_content},
    {MS_PDA_spectrum_OBSOLETE, MS_spectrum_type},
    {MS_photodiode_array_detector, MS_array_detector},
    {MS_Surveyor_PDA, MS_Thermo_Scientific_instrument_model},
    {MS_Accela_PDA, MS_Thermo_Scientific_instrument_model},
    {MS_inductive_detector, MS_detector_type},
    {MS_selected_ion_current_chromatogram, MS_ion_current_chromatogram},
    {MS_basepeak_chromatogram, MS_ion_current_chromatogram},
    {MS_low_intensity_threshold, MS_data_processing_parameter},
    {MS_high_intensity_threshold, MS_data_processing_parameter},
    {MS_Q_Tof_Premier, MS_Waters_instrument_model},
    {MS_possible_charge_state, MS_ion_selection_attribute},
    {MS_DSQ, MS_Thermo_Finnigan_instrument_model},
    {MS_ITQ_700, MS_Thermo_Scientific_instrument_model},
    {MS_ITQ_900, MS_Thermo_Scientific_instrument_model},
    {MS_ITQ_1100, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_XL_ETD, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_Orbitrap_XL_ETD, MS_Thermo_Scientific_instrument_model},
    {MS_DFS, MS_Thermo_Scientific_instrument_model},
    {MS_DSQ_II, MS_Thermo_Scientific_instrument_model},
    {MS_MALDI_LTQ_XL, MS_Thermo_Scientific_instrument_model},
    {MS_MALDI_LTQ_Orbitrap, MS_Thermo_Scientific_instrument_model},
    {MS_TSQ_Quantum_Access, MS_Thermo_Scientific_instrument_model},
    {MS_Element_XR, MS_Thermo_Scientific_instrument_model},
    {MS_Element_2, MS_Thermo_Scientific_instrument_model},
    {MS_Element_GD, MS_Thermo_Scientific_instrument_model},
    {MS_GC_IsoLink, MS_Thermo_Scientific_instrument_model},
    {MS_Exactive, MS_Thermo_Scientific_instrument_model},
    {MS_Proteome_Discoverer, MS_Thermo_Finnigan_software},
    {MS_Proteome_Discoverer, MS_analysis_software},
    {MS_Proteome_Discoverer, MS_data_processing_software},
    {MS_3200_QTRAP, MS_SCIEX_instrument_model},
    {MS_4800_Plus_MALDI_TOF_TOF, MS_SCIEX_instrument_model},
    {MS_API_3200, MS_SCIEX_instrument_model},
    {MS_API_5000, MS_SCIEX_instrument_model},
    {MS_QSTAR_Elite, MS_SCIEX_instrument_model},
    {MS_QSTAR_Pulsar, MS_SCIEX_instrument_model},
    {MS_QSTAR_XL, MS_SCIEX_instrument_model},
    {MS_4800_Proteomics_Analyzer, MS_Applied_Biosystems_instrument_model},
    {MS_4000_Series_Explorer_Software, MS_SCIEX_software},
    {MS_4000_Series_Explorer_Software, MS_acquisition_software},
    {MS_4000_Series_Explorer_Software, MS_analysis_software},
    {MS_4000_Series_Explorer_Software, MS_data_processing_software},
    {MS_GPS_Explorer, MS_SCIEX_software},
    {MS_GPS_Explorer, MS_acquisition_software},
    {MS_GPS_Explorer, MS_analysis_software},
    {MS_GPS_Explorer, MS_data_processing_software},
    {MS_LightSight_Software, MS_SCIEX_software},
    {MS_LightSight_Software, MS_analysis_software},
    {MS_LightSight_Software, MS_data_processing_software},
    {MS_ProteinPilot_Software, MS_SCIEX_software},
    {MS_ProteinPilot_Software, MS_analysis_software},
    {MS_ProteinPilot_Software, MS_data_processing_software},
    {MS_TissueView_Software, MS_SCIEX_software},
    {MS_TissueView_Software, MS_analysis_software},
    {MS_TissueView_Software, MS_data_processing_software},
    {MS_MarkerView_Software, MS_SCIEX_software},
    {MS_MarkerView_Software, MS_analysis_software},
    {MS_MarkerView_Software, MS_data_processing_software},
    {MS_MRMPilot_Software, MS_SCIEX_software},
    {MS_MRMPilot_Software, MS_analysis_software},
    {MS_MRMPilot_Software, MS_data_processing_software},
    {MS_BioAnalyst, MS_SCIEX_software},
    {MS_BioAnalyst, MS_analysis_software},
    {MS_BioAnalyst, MS_data_processing_software},
    {MS_Pro_ID, MS_SCIEX_software},
    {MS_Pro_ID, MS_analysis_software},
    {MS_Pro_ID, MS_data_processing_software},
    {MS_Pro_ICAT, MS_SCIEX_software},
    {MS_Pro_ICAT, MS_analysis_software},
    {MS_Pro_ICAT, MS_data_processing_software},
    {MS_Pro_Quant, MS_SCIEX_software},
    {MS_Pro_Quant, MS_analysis_software},
    {MS_Pro_Quant, MS_data_processing_software},
    {MS_Pro_BLAST, MS_SCIEX_software},
    {MS_Pro_BLAST, MS_analysis_software},
    {MS_Pro_BLAST, MS_data_processing_software},
    {MS_Cliquid, MS_SCIEX_software},
    {MS_MIDAS_Workflow_Designer, MS_SCIEX_software},
    {MS_MultiQuant, MS_SCIEX_software},
    {MS_MultiQuant, MS_analysis_software},
    {MS_MultiQuant, MS_data_processing_software},
    {MS_6220_Time_of_Flight_LC_MS, MS_Agilent_instrument_model},
    {MS_6510_Quadrupole_Time_of_Flight_LC_MS, MS_Agilent_instrument_model},
    {MS_6520A_Quadrupole_Time_of_Flight_LC_MS, MS_Agilent_instrument_model},
    {MS_MassHunter_Data_Acquisition, MS_Agilent_software},
    {MS_MassHunter_Data_Acquisition, MS_acquisition_software},
    {MS_MassHunter_Easy_Access, MS_Agilent_software},
    {MS_MassHunter_Easy_Access, MS_acquisition_software},
    {MS_MassHunter_Qualitative_Analysis, MS_Agilent_software},
    {MS_MassHunter_Qualitative_Analysis, MS_analysis_software},
    {MS_MassHunter_Qualitative_Analysis, MS_data_processing_software},
    {MS_MassHunter_Quantitative_Analysis, MS_Agilent_software},
    {MS_MassHunter_Quantitative_Analysis, MS_analysis_software},
    {MS_MassHunter_Quantitative_Analysis, MS_data_processing_software},
    {MS_MassHunter_Metabolite_ID, MS_Agilent_software},
    {MS_MassHunter_Metabolite_ID, MS_analysis_software},
    {MS_MassHunter_Metabolite_ID, MS_data_processing_software},
    {MS_MassHunter_BioConfirm, MS_Agilent_software},
    {MS_MassHunter_BioConfirm, MS_analysis_software},
    {MS_MassHunter_BioConfirm, MS_data_processing_software},
    {MS_Genespring_MS, MS_Agilent_software},
    {MS_Genespring_MS, MS_analysis_software},
    {MS_Genespring_MS, MS_data_processing_software},
    {MS_MassHunter_Mass_Profiler, MS_Agilent_software},
    {MS_MassHunter_Mass_Profiler, MS_analysis_software},
    {MS_MassHunter_Mass_Profiler, MS_data_processing_software},
    {MS_METLIN, MS_Agilent_software},
    {MS_METLIN, MS_analysis_software},
    {MS_METLIN, MS_data_processing_software},
    {MS_Spectrum_Mill_for_MassHunter_Workstation, MS_Agilent_software},
    {MS_Spectrum_Mill_for_MassHunter_Workstation, MS_analysis_software},
    {MS_Spectrum_Mill_for_MassHunter_Workstation, MS_data_processing_software},
    {MS_6300_Series_Ion_Trap_Data_Analysis_Software, MS_Agilent_software},
    {MS_6300_Series_Ion_Trap_Data_Analysis_Software, MS_acquisition_software},
    {MS_6300_Series_Ion_Trap_Data_Analysis_Software, MS_analysis_software},
    {MS_6300_Series_Ion_Trap_Data_Analysis_Software, MS_data_processing_software},
    {MS_Agilent_software, MS_software},
    {MS_SCIEX_software, MS_software},
    {MS_Applied_Biosystems_software, MS_software},
    {MS_Bruker_software, MS_software},
    {MS_Thermo_Finnigan_software, MS_software},
    {MS_Waters_software, MS_software},
    {MS_apex_ultra, MS_Bruker_Daltonics_apex_series},
    {MS_autoflex_III_smartbeam, MS_Bruker_Daltonics_flex_series},
    {MS_Bruker_Daltonics_HCT_Series, MS_Bruker_Daltonics_instrument_model},
    {MS_HCTultra, MS_Bruker_Daltonics_HCT_Series},
    {MS_HCTultra_PTM, MS_Bruker_Daltonics_HCT_Series},
    {MS_HCTultra_ETD_II, MS_Bruker_Daltonics_HCT_Series},
    {MS_microflex_LT, MS_Bruker_Daltonics_flex_series},
    {MS_micrOTOF, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_micrOTOF_Q, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_micrOTOF_Q_II, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_ultraflex_III_TOF_TOF, MS_Bruker_Daltonics_flex_series},
    {MS_apexControl, MS_Bruker_software},
    {MS_apexControl, MS_acquisition_software},
    {MS_BioTools, MS_Bruker_software},
    {MS_BioTools, MS_analysis_software},
    {MS_BioTools, MS_data_processing_software},
    {MS_CLINPROT, MS_Bruker_software},
    {MS_CLINPROT, MS_analysis_software},
    {MS_CLINPROT, MS_data_processing_software},
    {MS_CLINPROT_micro, MS_Bruker_software},
    {MS_CLINPROT_micro, MS_analysis_software},
    {MS_CLINPROT_micro, MS_data_processing_software},
    {MS_CLINPROT_robot, MS_Bruker_software},
    {MS_ClinProTools, MS_Bruker_software},
    {MS_Compass, MS_Bruker_software},
    {MS_Compass, MS_analysis_software},
    {MS_Compass, MS_data_processing_software},
    {MS_Compass_for_HCT_esquire, MS_Bruker_software},
    {MS_Compass_for_HCT_esquire, MS_analysis_software},
    {MS_Compass_for_HCT_esquire, MS_data_processing_software},
    {MS_Compass_for_micrOTOF, MS_Bruker_software},
    {MS_Compass_for_micrOTOF, MS_analysis_software},
    {MS_Compass_for_micrOTOF, MS_data_processing_software},
    {MS_Compass_OpenAccess, MS_Bruker_software},
    {MS_Compass_OpenAccess, MS_analysis_software},
    {MS_Compass_OpenAccess, MS_data_processing_software},
    {MS_Compass_Security_Pack, MS_Bruker_software},
    {MS_CompassXport, MS_Bruker_software},
    {MS_CompassXport, MS_data_processing_software},
    {MS_CompassXtract, MS_Bruker_software},
    {MS_CompassXtract, MS_data_processing_software},
    {MS_DataAnalysis, MS_Bruker_software},
    {MS_DataAnalysis, MS_analysis_software},
    {MS_DataAnalysis, MS_data_processing_software},
    {MS_dpControl, MS_Bruker_software},
    {MS_dpControl, MS_acquisition_software},
    {MS_esquireControl, MS_Bruker_software},
    {MS_esquireControl, MS_acquisition_software},
    {MS_flexImaging, MS_Bruker_software},
    {MS_flexImaging, MS_analysis_software},
    {MS_flexImaging, MS_data_processing_software},
    {MS_GENOLINK, MS_Bruker_software},
    {MS_GenoTools, MS_Bruker_software},
    {MS_HCTcontrol, MS_Bruker_software},
    {MS_HCTcontrol, MS_acquisition_software},
    {MS_micrOTOFcontrol, MS_Bruker_software},
    {MS_micrOTOFcontrol, MS_acquisition_software},
    {MS_PolyTools, MS_Bruker_software},
    {MS_ProfileAnalysis, MS_Bruker_software},
    {MS_ProfileAnalysis, MS_analysis_software},
    {MS_ProfileAnalysis, MS_data_processing_software},
    {MS_PROTEINEER, MS_Bruker_software},
    {MS_PROTEINEER_dp, MS_Bruker_software},
    {MS_PROTEINEER_fc, MS_Bruker_software},
    {MS_PROTEINEER_spII, MS_Bruker_software},
    {MS_PROTEINEER_LC, MS_Bruker_software},
    {MS_ProteinScape, MS_Bruker_software},
    {MS_ProteinScape, MS_analysis_software},
    {MS_PureDisk, MS_Bruker_software},
    {MS_QuantAnalysis, MS_Bruker_software},
    {MS_QuantAnalysis, MS_analysis_software},
    {MS_QuantAnalysis, MS_data_processing_software},
    {MS_spControl, MS_Bruker_software},
    {MS_spControl, MS_acquisition_software},
    {MS_TargetAnalysis, MS_Bruker_software},
    {MS_WARP_LC, MS_Bruker_software},
    {MS_WARP_LC, MS_quantitation_software_name},
    {MS_parameter_file, MS_mass_spectrometer_file_format},
    {MS_Conversion_to_dta, MS_file_format_conversion},
    {MS_Bioworks_SRF_format, MS_mass_spectrometer_file_format},
    {MS_Bioworks_SRF_format, MS_intermediate_analysis_format},
    {MS_TSQ_Quantum_Ultra_AM, MS_Thermo_Scientific_instrument_model},
    {MS_selected_ion_m_z, MS_ion_selection_attribute},
    {MS_retention_time_alignment, MS_data_processing_action},
    {MS_high_intensity_data_point_removal, MS_data_filtering},
    {MS_completion_time, MS_data_processing_parameter},
    {MS_SSQ_7000, MS_Finnigan_MAT_instrument_model},
    {MS_TSQ_7000, MS_Finnigan_MAT_instrument_model},
    {MS_TSQ, MS_Finnigan_MAT_instrument_model},
    {MS_TSQ_Quantum_Ultra, MS_Thermo_Scientific_instrument_model},
    {MS_TOPP_software, MS_analysis_software},
    {MS_TOPP_software, MS_data_processing_software},
    {MS_BaselineFilter, MS_TOPP_software},
    {MS_DBExporter, MS_TOPP_software},
    {MS_DBImporter, MS_TOPP_software},
    {MS_FileConverter, MS_TOPP_software},
    {MS_FileFilter, MS_TOPP_software},
    {MS_FileMerger, MS_TOPP_software},
    {MS_InternalCalibration, MS_TOPP_software},
    {MS_MapAligner_OBSOLETE, MS_TOPP_software},
    {MS_MapNormalizer, MS_TOPP_software},
    {MS_NoiseFilter_OBSOLETE, MS_TOPP_software},
    {MS_PeakPicker_OBSOLETE, MS_TOPP_software},
    {MS_Resampler, MS_TOPP_software},
    {MS_SpectraFilter_OBSOLETE, MS_TOPP_software},
    {MS_TOFCalibration, MS_TOPP_software},
    {MS_Thermo_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Waters_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_WIFF_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Bruker_Agilent_YEP_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Bruker_BAF_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Bruker_FID_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_multiple_peak_list_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_single_peak_list_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_scan_number_only_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_spectrum_identifier_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_charge_state_calculation, MS_data_processing_action},
    {MS_below_precursor_intensity_dominance_charge_state_calculation, MS_charge_state_calculation},
    {MS_precursor_recalculation, MS_data_processing_action},
    {MS_msPrefix_precursor_recalculation, MS_precursor_recalculation},
    {MS_Savitzky_Golay_smoothing, MS_smoothing},
    {MS_LOWESS_smoothing, MS_smoothing},
    {MS_Gaussian_smoothing, MS_smoothing},
    {MS_moving_average_smoothing, MS_smoothing},
    {MS_non_standard_data_array, MS_binary_data_array},
    {MS_inclusive_low_intensity_threshold, MS_data_processing_parameter},
    {MS_inclusive_high_intensity_threshold, MS_data_processing_parameter},
    {MS_enhanced_multiply_charged_spectrum, MS_MS1_spectrum},
    {MS_time_delayed_fragmentation_spectrum, MS_MSn_spectrum},
    {MS_isolation_window_attribute, MS_object_attribute},
    {MS_isolation_window_upper_limit_OBSOLETE, MS_isolation_window_attribute},
    {MS_isolation_window_lower_limit_OBSOLETE, MS_isolation_window_attribute},
    {MS_no_combination, MS_spectra_combination},
    {MS_spectrum_title, MS_spectrum_identification_result_details},
    {MS_spectrum_title, MS_spectrum_attribute},
    {MS_peak_list_scans, MS_spectrum_identification_result_details},
    {MS_peak_list_scans, MS_spectrum_property},
    {MS_peak_list_raw_scans, MS_spectrum_identification_result_details},
    {MS_peak_list_raw_scans, MS_spectrum_property},
    {MS_custom_unreleased_software_tool, MS_software},
    {MS_mass_resolving_power, MS_scan_attribute},
    {MS_area_peak_picking, MS_peak_picking},
    {MS_height_peak_picking, MS_peak_picking},
    {MS_analyzer_scan_offset, MS_scan_attribute},
    {MS_electromagnetic_radiation_spectrum, MS_data_file_content},
    {MS_electromagnetic_radiation_spectrum, MS_spectrum_type},
    {MS_emission_spectrum, MS_data_file_content},
    {MS_emission_spectrum, MS_spectrum_type},
    {MS_absorption_spectrum, MS_data_file_content},
    {MS_absorption_spectrum, MS_spectrum_type},
    {MS_chromatogram_attribute, MS_object_attribute},
    {MS_chromatogram_title, MS_chromatogram_attribute},
    {MS_ion_current_chromatogram, MS_data_file_content},
    {MS_ion_current_chromatogram, MS_chromatogram_type},
    {MS_electromagnetic_radiation_chromatogram, MS_data_file_content},
    {MS_electromagnetic_radiation_chromatogram, MS_chromatogram_type},
    {MS_absorption_chromatogram, MS_electromagnetic_radiation_chromatogram},
    {MS_emission_chromatogram, MS_electromagnetic_radiation_chromatogram},
    {MS_counts_per_second, MS_intensity_unit},
    {MS_Bruker_BAF_format, MS_mass_spectrometer_file_format},
    {MS_Bruker_U2_format, MS_mass_spectrometer_file_format},
    {MS_HyStar, MS_Bruker_software},
    {MS_Acquity_UPLC_PDA, MS_Waters_instrument_model},
    {MS_Acquity_UPLC_PDA, MS_photodiode_array_detector},
    {MS_Acquity_UPLC_FLR, MS_Waters_instrument_model},
    {MS_Acquity_UPLC_FLR, MS_fluorescence_detector},
    {MS_flow_rate_array, MS_binary_data_array},
    {MS_pressure_array, MS_binary_data_array},
    {MS_temperature_array, MS_binary_data_array},
    {MS_Bruker_U2_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_no_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Bruker_FID_format, MS_mass_spectrometer_file_format},
    {MS_elution_time, MS_scan_attribute},
    {MS_isolation_window_target_m_z, MS_isolation_window_attribute},
    {MS_isolation_window_lower_offset, MS_isolation_window_attribute},
    {MS_isolation_window_upper_offset, MS_isolation_window_attribute},
    {MS_sample_preparation, MS_object_attribute},
    {MS_matrix_solution, MS_MALDI_matrix_application},
    {MS_matrix_solution_concentration, MS_MALDI_matrix_application},
    {MS_dried_droplet_MALDI_matrix_preparation, MS_matrix_application_type},
    {MS_printed_MALDI_matrix_preparation, MS_matrix_application_type},
    {MS_sprayed_MALDI_matrix_preparation, MS_matrix_application_type},
    {MS_precoated_MALDI_sample_plate, MS_matrix_application_type},
    {MS_precoated_MALDI_sample_plate, MS_sample_plate_type},
    {MS_wavelength_OBSOLETE, MS_laser_attribute},
    {MS_focus_diameter_x, MS_laser_attribute},
    {MS_focus_diameter_y, MS_laser_attribute},
    {MS_pulse_energy, MS_laser_attribute},
    {MS_pulse_duration, MS_laser_attribute},
    {MS_attenuation, MS_laser_attribute},
    {MS_impact_angle, MS_laser_attribute},
    {MS_gas_laser, MS_laser_type},
    {MS_solid_state_laser, MS_laser_type},
    {MS_dye_laser, MS_laser_type},
    {MS_free_electron_laser, MS_laser_type},
    {MS_LTQ_XL, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_Velos, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_Velos_ETD, MS_Thermo_Scientific_instrument_model},
    {MS_run_attribute, MS_object_attribute},
    {MS_fraction_identifier, MS_run_attribute},
    {MS_molecule, MS_molecular_entity},
    {MS_peptide, MS_molecule},
    {MS_isoelectric_point, MS_molecular_entity_property},
    {MS_predicted_isoelectric_point, MS_isoelectric_point},
    {MS_chemical_formula, MS_molecular_entity_attribute},
    {MS_empirical_formula, MS_chemical_formula},
    {MS_molecular_formula, MS_chemical_formula},
    {MS_structural_formula, MS_chemical_formula},
    {MS_SMILES_formula, MS_chemical_formula},
    {MS_collision_gas_pressure, MS_precursor_activation_attribute},
    {MS_4000_QTRAP_OBSOLETE, MS_SCIEX_instrument_model},
    {MS_SRM_software, MS_software},
    {MS_MaRiMba, MS_SRM_software},
    {MS_peptide_attribute_calculation_software, MS_software},
    {MS_SSRCalc, MS_peptide_attribute_calculation_software},
    {MS_declustering_potential, MS_source_attribute},
    {MS_cone_voltage, MS_source_attribute},
    {MS_tube_lens_voltage, MS_source_attribute},
    {MS_external_reference_identifier, MS_external_reference_data},
    {MS_PubMed_identifier, MS_external_reference_identifier},
    {MS_interchannel_delay, MS_scan_attribute},
    {MS_protein, MS_molecule},
    {MS_protein_short_name, MS_protein_attribute},
    {MS_protein_attribute, MS_quantification_object_attribute},
    {MS_protein_accession, MS_protein_attribute},
    {MS_protein_accession, MS_peptide_to_protein_mapping_attribute},
    {MS_protein_name, MS_protein_attribute},
    {MS_stripped_peptide_sequence, MS_peptidoform_attribute},
    {MS_peptidoform_sequence, MS_peptidoform_attribute},
    {MS_peptidoform_labeling_state, MS_peptidoform_attribute},
    {MS_heavy_labeled_peptidoform, MS_peptidoform_labeling_state},
    {MS_unlabeled_peptidoform, MS_peptidoform_labeling_state},
    {MS_peptidoform_group_label, MS_peptidoform_attribute},
    {MS_retention_time, MS_peptidoform_attribute},
    {MS_retention_time, MS_summary_statistics_of_replicates},
    {MS_local_retention_time, MS_retention_time},
    {MS_normalized_retention_time, MS_retention_time},
    {MS_normalized_retention_time, MS_summary_statistics_of_replicates},
    {MS_predicted_retention_time, MS_retention_time},
    {MS_de_facto_standard, MS_standard},
    {MS_minimum_information_standard, MS_standard},
    {MS_retention_time_normalization_standard, MS_standard},
    {MS_H_PINS_retention_time_normalization_standard, MS_retention_time_normalization_standard},
    {MS_product_ion_series_ordinal, MS_product_ion_attribute},
    {MS_product_ion_m_z_delta, MS_product_ion_attribute},
    {MS_percent_of_base_peak_times_100, MS_intensity_unit},
    {MS_peak_intensity_rank, MS_ion_selection_attribute},
    {MS_peak_targeting_suitability_rank, MS_ion_selection_attribute},
    {MS_transition_optimized_on_specified_instrument, MS_transition_validation_method},
    {MS_transition_validated_with_an_MS_MS_spectrum_on_specified_instrument, MS_transition_validation_method},
    {MS_transition_purported_from_an_MS_MS_spectrum_on_a_different__specified_instrument, MS_transition_validation_method},
    {MS_transition_predicted_by_informatic_analysis, MS_transition_validation_method},
    {MS_tab_delimited_text_format, MS_file_format},
    {MS_tab_delimited_text_format, MS_intermediate_analysis_format},
    {MS_retention_time_window_lower_offset, MS_retention_time_window_attribute},
    {MS_retention_time_window_upper_offset, MS_retention_time_window_attribute},
    {MS_includes_supersede_excludes, MS_target_inclusion_exclusion_priority},
    {MS_excludes_supersede_includes, MS_target_inclusion_exclusion_priority},
    {MS_Skyline, MS_SRM_software},
    {MS_Skyline, MS_quantitation_software_name},
    {MS_TIQAM, MS_SRM_software},
    {MS_ATAQS, MS_SRM_software},
    {MS_product_interpretation_rank, MS_product_ion_attribute},
    {MS_ion_injection_time, MS_scan_attribute},
    {MS_calibration_spectrum, MS_spectrum_type},
    {MS_Shimadzu_Biotech_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Shimadzu_Biotech_database_entity, MS_mass_spectrometer_file_format},
    {MS_QTRAP_5500, MS_SCIEX_instrument_model},
    {MS_TripleTOF_5600, MS_SCIEX_instrument_model},
    {MS_protein_modifications, MS_protein_attribute},
    {MS_gene_name, MS_protein_attribute},
    {MS_6470A_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6470B_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6495C_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_SEQUEST_CleavesAt, MS_SEQUEST_input_parameter},
    {MS_SEQUEST_ViewCV, MS_SEQUEST_input_parameter},
    {MS_SEQUEST_OutputLines, MS_SEQUEST_input_parameter},
    {MS_SEQUEST_DescriptionLines, MS_SEQUEST_input_parameter},
    {MS_de_novo_search, MS_search_type},
    {MS_search_database_details, MS_search_input_details},
    {MS_database_source, MS_search_database_details},
    {MS_database_name, MS_search_database_details},
    {MS_database_local_file_path_OBSOLETE, MS_search_database_details},
    {MS_database_original_uri, MS_search_database_details},
    {MS_database_version, MS_search_database_details},
    {MS_release_date, MS_search_database_details},
    {MS_release_date, MS_spectral_library_attribute},
    {MS_database_type, MS_search_database_details},
    {MS_database_filtering, MS_search_database_details},
    {MS_DB_filter_taxonomy, MS_Sequence_database_filter_types},
    {MS_DB_filter_on_accession_numbers, MS_Sequence_database_filter_types},
    {MS_DB_MW_filter, MS_Sequence_database_filter_types},
    {MS_DB_PI_filter, MS_Sequence_database_filter_types},
    {MS_translation_frame, MS_search_database_details},
    {MS_translation_table, MS_search_database_details},
    {MS_SEQUEST_NormalizeXCorrValues, MS_SEQUEST_input_parameter},
    {MS_DB_filter_on_sequence_pattern, MS_Sequence_database_filter_types},
    {MS_SEQUEST_SequenceHeaderFilter, MS_SEQUEST_input_parameter},
    {MS_number_of_sequences_searched, MS_search_database_details},
    {MS_number_of_peptide_seqs_compared_to_each_spectrum, MS_search_database_details},
    {MS_number_of_peptide_seqs_compared_to_each_spectrum, MS_spectrum_identification_result_details},
    {MS_spectral_library_search, MS_search_type},
    {MS_SEQUEST_SequencePartialFilter, MS_SEQUEST_input_parameter},
    {MS_date___time_search_performed_OBSOLETE, MS_search_statistics},
    {MS_search_time_taken, MS_search_statistics},
    {MS_SEQUEST_ShowFragmentIons, MS_SEQUEST_input_parameter},
    {MS_SEQUEST_Consensus, MS_SEQUEST_ViewCV},
    {MS_intermediate_analysis_format, MS_file_format},
    {MS_SEQUEST_sortCV, MS_SEQUEST_ViewCV},
    {MS_SEQUEST_LimitTo, MS_SEQUEST_input_parameter},
    {MS_cleavage_agent_details, MS_search_input_details},
    {MS_cleavage_agent_name, MS_cleavage_agent_details},
    {MS_SEQUEST_sort_by_dCn, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_dM, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_Ions, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_MH_, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_P, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_PreviousAminoAcid, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_Ref, MS_SEQUEST_sortCV},
    {MS_modification_specificity_rule, MS_modification_parameters},
    {MS_tolerance_on_types_OBSOLETE, MS_modification_parameters},
    {MS_quality_estimation_by_manual_validation, MS_quality_estimation_method_details},
    {MS_SEQUEST_sort_by_RSp, MS_SEQUEST_sortCV},
    {MS_quality_estimation_method_details, MS_search_input_details},
    {MS_neutral_loss_OBSOLETE, MS_modification_parameters},
    {MS_Mascot_MGF_format, MS_mass_spectrometer_file_format},
    {MS_TODOscoring_model_OBSOLETE, MS_search_input_details},
    {MS_ions_series_considered_in_search, MS_search_input_details},
    {MS_SEQUEST_sort_by_Sp, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_TIC, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_Scan, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_Sequence, MS_SEQUEST_sortCV},
    {MS_SEQUEST_sort_by_Sf, MS_SEQUEST_sortCV},
    {MS_database_type_amino_acid, MS_database_type},
    {MS_database_type_nucleotide, MS_database_type},
    {MS_search_type, MS_search_input_details},
    {MS_pmf_search, MS_search_type},
    {MS_tag_search, MS_search_type},
    {MS_ms_ms_search, MS_search_type},
    {MS_database_nr, MS_database_name},
    {MS_protein_level_identification_attribute, MS_single_identification_result_attribute},
    {MS_SEQUEST_sort_by_XCorr, MS_SEQUEST_sortCV},
    {MS_SEQUEST_ProcessCV, MS_SEQUEST_input_parameter},
    {MS_protein_description, MS_protein_level_identification_attribute},
    {MS_protein_description, MS_database_sequence_details},
    {MS_molecule_taxonomy, MS_protein_level_identification_attribute},
    {MS_molecule_taxonomy, MS_database_sequence_details},
    {MS_molecule_taxonomy, MS_Sequence_database_filters},
    {MS_taxonomy_nomenclature_OBSOLETE, MS_molecule_taxonomy},
    {MS_NoEnzyme_OBSOLETE, MS_cleavage_agent_name},
    {MS_peptide_sequence_level_identification_statistic, MS_peptide_sequence_level_identification_attribute},
    {MS_sequence_coverage, MS_protein_level_identification_attribute},
    {MS_SEQUEST_sort_by_z, MS_SEQUEST_sortCV},
    {MS_SEQUEST_ProcessAll, MS_SEQUEST_ProcessCV},
    {MS_SEQUEST_TopPercentMostIntense, MS_SEQUEST_ProcessCV},
    {MS_distinct_peptide_sequences, MS_protein_level_identification_attribute},
    {MS_confident_distinct_peptide_sequences, MS_protein_level_identification_attribute},
    {MS_confident_peptide_qualification, MS_protein_level_identification_attribute},
    {MS_confident_peptide_sequence_number, MS_protein_level_identification_attribute},
    {MS_protein_group_or_subset_relationship, MS_protein_level_identification_attribute},
    {MS_SEQUEST_Chromatogram, MS_SEQUEST_ViewCV},
    {MS_SEQUEST_InfoAndLog, MS_SEQUEST_ViewCV},
    {MS_database_UniProtKB_Swiss_Prot, MS_database_UniProtKB},
    {MS_peptide_sequence_level_identification_attribute, MS_single_identification_result_attribute},
    {MS_SEQUEST_TopNumber, MS_SEQUEST_ProcessCV},
    {MS_data_stored_in_database, MS_intermediate_analysis_format},
    {MS_param__a_ion, MS_ion_series_considered_in_search},
    {MS_SEQUEST_CullTo, MS_SEQUEST_ProcessCV},
    {MS_SEQUEST_modeCV, MS_SEQUEST_input_parameter},
    {MS_SEQUEST_Full, MS_SEQUEST_modeCV},
    {MS_n_terminal_flanking_residue, MS_peptide_to_protein_mapping_attribute},
    {MS_n_terminal_flanking_residue, MS_peptide_sequence_level_identification_attribute},
    {MS_c_terminal_flanking_residue, MS_peptide_to_protein_mapping_attribute},
    {MS_c_terminal_flanking_residue, MS_peptide_sequence_level_identification_attribute},
    {MS_retention_time_s__OBSOLETE, MS_peptide_sequence_level_identification_attribute},
    {MS_single_protein_identification_statistic, MS_protein_level_identification_attribute},
    {MS_theoretical_mass, MS_peptide_sequence_level_identification_attribute},
    {MS_param__b_ion, MS_ion_series_considered_in_search},
    {MS_param__c_ion, MS_ion_series_considered_in_search},
    {MS_SEQUEST_FormatAndLinks, MS_SEQUEST_modeCV},
    {MS_number_of_matched_peaks, MS_peptide_sequence_level_identification_attribute},
    {MS_ions_series_considered, MS_peptide_sequence_level_identification_attribute},
    {MS_number_of_peaks_used, MS_peptide_sequence_level_identification_attribute},
    {MS_number_of_peaks_submitted, MS_peptide_sequence_level_identification_attribute},
    {MS_manual_validation, MS_peptide_sequence_level_identification_statistic},
    {MS_manual_validation, MS_single_protein_identification_statistic},
    {MS_SEQUEST_Fast, MS_SEQUEST_modeCV},
    {MS_peptide_sharing_details, MS_peptide_sequence_level_identification_attribute},
    {MS_SEQUEST_selectCV, MS_SEQUEST_input_parameter},
    {MS_peptide_raw_area_OBSOLETE, MS_peptide_level_quantification_datatype},
    {MS_error_on_peptide_area, MS_peptide_level_quantification_datatype},
    {MS_peptide_ratio, MS_peptide_level_quantification_datatype},
    {MS_error_on_peptide_ratio, MS_peptide_level_quantification_datatype},
    {MS_protein_ratio, MS_protein_level_quantification_datatype},
    {MS_error_on_protein_ratio, MS_protein_level_quantification_datatype},
    {MS_p_value__protein_diff_from_1_randomly__OBSOLETE, MS_protein_level_quantification_datatype},
    {MS_absolute_quantity, MS_quantification_datatype},
    {MS_error_on_absolute_quantity, MS_quantification_datatype},
    {MS_quantitation_software_name, MS_software},
    {MS_quantitation_software_name, MS_quantification_information},
    {MS_quantitation_software_version_OBSOLETE, MS_quantification_information},
    {MS_intensity_of_precursor_ion, MS_quantification_datatype},
    {MS_database_IPI_human, MS_database_name},
    {MS_PSM_level_search_engine_specific_statistic, MS_PSM_level_identification_statistic},
    {MS_SEQUEST_SelectDefault, MS_SEQUEST_selectCV},
    {MS_SEQUEST_SelectAdvancedCV, MS_SEQUEST_selectCV},
    {MS_param__a_ion_NH3_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_protein_ambiguity_group_result_details, MS_protein_level_identification_attribute},
    {MS_protein_ambiguity_group_result_details, MS_search_engine_specific_score},
    {MS_param__a_ion_H2O_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_param__b_ion_NH3_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_param__b_ion_H2O_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_param__y_ion_NH3_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_param__y_ion_H2O_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_search_engine_specific_score, MS_single_identification_result_attribute},
    {MS_SEQUEST_probability, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_xcorr, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_deltacn, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_sp, MS_search_engine_specific_score_for_proteins},
    {MS_SEQUEST_Uniq, MS_search_engine_specific_score_for_proteins},
    {MS_SEQUEST_expectation_value, MS_search_engine_specific_score},
    {MS_SEQUEST_sf, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_matched_ions, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_total_ions, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_consensus_score, MS_search_engine_specific_score},
    {MS_Paragon_unused_protscore, MS_search_engine_specific_score_for_proteins},
    {MS_Paragon_unused_protscore, MS_search_engine_specific_score_for_protein_groups},
    {MS_Paragon_total_protscore, MS_search_engine_specific_score_for_proteins},
    {MS_Paragon_total_protscore, MS_search_engine_specific_score_for_protein_groups},
    {MS_Paragon_score, MS_search_engine_specific_score_for_proteins},
    {MS_Paragon_confidence, MS_search_engine_specific_score_for_proteins},
    {MS_Paragon_expression_error_factor, MS_search_engine_specific_score_for_proteins},
    {MS_Paragon_expression_change_p_value, MS_search_engine_specific_score_for_proteins},
    {MS_Paragon_contrib, MS_search_engine_specific_score_for_proteins},
    {MS_Mascot_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_Mascot_expectation_value, MS_PSM_level_search_engine_specific_statistic},
    {MS_Mascot_matched_ions, MS_PSM_level_search_engine_specific_statistic},
    {MS_Mascot_total_ions, MS_PSM_level_search_engine_specific_statistic},
    {MS_peptide_shared_in_multiple_proteins, MS_peptide_sharing_details},
    {MS______KR_____P_, MS_Cleavage_agent_regular_expression},
    {MS_number_of_molecular_hypothesis_considered, MS_search_statistics},
    {MS_database_EST, MS_database_type_nucleotide},
    {MS_Cleavage_agent_regular_expression, MS_regular_expression},
    {MS_search_statistics, MS_spectrum_identification_result_details},
    {MS_modification_specificity_peptide_N_term, MS_modification_specificity_rule},
    {MS_modification_specificity_peptide_C_term, MS_modification_specificity_rule},
    {MS_p_value_OBSOLETE, MS_peptide_sequence_level_identification_statistic},
    {MS_p_value_OBSOLETE, MS_protein_identification_confidence_metric},
    {MS_Expect_value, MS_peptide_sequence_level_identification_statistic},
    {MS_Expect_value, MS_single_protein_identification_statistic},
    {MS_confidence_score, MS_peptide_sequence_level_identification_statistic},
    {MS_confidence_score, MS_single_protein_identification_statistic},
    {MS_quality_estimation_with_decoy_database, MS_quality_estimation_method_details},
    {MS_decoy_DB_type_reverse, MS_decoy_DB_details},
    {MS_decoy_DB_type_randomized, MS_decoy_DB_details},
    {MS_DB_composition_target_decoy, MS_decoy_DB_details},
    {MS_protein_identification_confidence_metric, MS_single_protein_identification_statistic},
    {MS_Mascot_DAT_format, MS_intermediate_analysis_format},
    {MS_SEQUEST_out_file_format, MS_intermediate_analysis_format},
    {MS_DB_MW_filter_maximum, MS_Sequence_database_filters},
    {MS_DB_MW_filter_minimum, MS_Sequence_database_filters},
    {MS_DB_PI_filter_maximum, MS_Sequence_database_filters},
    {MS_DB_PI_filter_minimum, MS_Sequence_database_filters},
    {MS_Mascot, MS_analysis_software},
    {MS_SEQUEST, MS_analysis_software},
    {MS_Phenyx, MS_analysis_software},
    {MS_mass_type_settings, MS_search_input_details},
    {MS_parent_mass_type_mono, MS_mass_type_settings},
    {MS_parent_mass_type_average, MS_mass_type_settings},
    {MS_protein_level_global_FDR, MS_protein_level_result_list_statistic},
    {MS_SEQUEST_PeptideSp, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_PeptideRankSp, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_PeptideNumber, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_PeptideIdnumber, MS_PSM_level_search_engine_specific_statistic},
    {MS_frag__y_ion, MS_fragmentation_ion_type},
    {MS_product_ion_attribute, MS_single_identification_result_attribute},
    {MS_frag__b_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__y_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__b_ion, MS_fragmentation_ion_type},
    {MS_product_ion_m_z, MS_product_ion_attribute},
    {MS_product_ion_intensity, MS_product_ion_attribute},
    {MS_product_ion_m_z_error, MS_product_ion_attribute},
    {MS_frag__x_ion, MS_fragmentation_ion_type},
    {MS_frag__a_ion, MS_fragmentation_ion_type},
    {MS_frag__z_ion, MS_fragmentation_ion_type},
    {MS_frag__c_ion, MS_fragmentation_ion_type},
    {MS_frag__b_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__y_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__a_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__a_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__d_ion, MS_fragmentation_ion_type},
    {MS_frag__v_ion, MS_fragmentation_ion_type},
    {MS_frag__w_ion, MS_fragmentation_ion_type},
    {MS_frag__immonium_ion, MS_fragmentation_ion_type},
    {MS_non_identified_ion, MS_product_ion_attribute},
    {MS_co_eluting_ion, MS_product_ion_attribute},
    {MS_SEQUEST_out_folder, MS_intermediate_analysis_format},
    {MS_SEQUEST_summary, MS_intermediate_analysis_format},
    {MS_PerSeptive_PKS_format, MS_mass_spectrometer_file_format},
    {MS_SCIEX_API_III_format, MS_mass_spectrometer_file_format},
    {MS_Bruker_XML_format, MS_mass_spectrometer_file_format},
    {MS_local_FDR, MS_peptide_sequence_level_identification_statistic},
    {MS_local_FDR, MS_single_protein_identification_statistic},
    {MS_Trypsin, MS_cleavage_agent_name},
    {MS_DB_source_EBI, MS_database_source},
    {MS_DB_source_NCBI, MS_database_source},
    {MS_DB_source_UniProt, MS_database_source},
    {MS_fragment_mass_type_average, MS_mass_type_settings},
    {MS_fragment_mass_type_mono, MS_mass_type_settings},
    {MS_param__v_ion, MS_ion_series_considered_in_search},
    {MS_param__d_ion, MS_ion_series_considered_in_search},
    {MS_param__immonium_ion, MS_ion_series_considered_in_search},
    {MS_param__w_ion, MS_ion_series_considered_in_search},
    {MS_param__x_ion, MS_ion_series_considered_in_search},
    {MS_param__y_ion, MS_ion_series_considered_in_search},
    {MS_param__z_ion, MS_ion_series_considered_in_search},
    {MS_role_type, MS_contact_attribute},
    {MS_software_vendor, MS_role_type},
    {MS_programmer, MS_role_type},
    {MS_instrument_vendor, MS_role_type},
    {MS_lab_personnel, MS_role_type},
    {MS_researcher, MS_role_type},
    {MS_____R____P_, MS_Cleavage_agent_regular_expression},
    {MS_____BD__, MS_Cleavage_agent_regular_expression},
    {MS_____DE__, MS_Cleavage_agent_regular_expression},
    {MS_ProteinScape_SearchEvent, MS_intermediate_analysis_format},
    {MS_ProteinScape_Gel, MS_intermediate_analysis_format},
    {MS_decoy_DB_accession_regexp, MS_decoy_DB_details},
    {MS_decoy_DB_derived_from_OBSOLETE, MS_decoy_DB_details},
    {MS_database_IPI_mouse, MS_database_name},
    {MS_database_IPI_rat, MS_database_name},
    {MS_database_IPI_zebrafish, MS_database_name},
    {MS_database_IPI_chicken, MS_database_name},
    {MS_database_IPI_cow, MS_database_name},
    {MS_database_IPI_arabidopsis, MS_database_name},
    {MS_protein_rank, MS_protein_level_identification_attribute},
    {MS_search_engine_specific_input_parameter, MS_search_engine_input_parameter},
    {MS_Arg_C, MS_cleavage_agent_name},
    {MS_Asp_N, MS_cleavage_agent_name},
    {MS_Asp_N_ambic, MS_cleavage_agent_name},
    {MS_Chymotrypsin, MS_cleavage_agent_name},
    {MS_CNBr, MS_cleavage_agent_name},
    {MS_Formic_acid, MS_cleavage_agent_name},
    {MS_Lys_C, MS_cleavage_agent_name},
    {MS_Lys_C_P, MS_cleavage_agent_name},
    {MS_PepsinA, MS_cleavage_agent_name},
    {MS_TrypChymo, MS_cleavage_agent_name},
    {MS_Trypsin_P, MS_cleavage_agent_name},
    {MS_V8_DE, MS_cleavage_agent_name},
    {MS_V8_E, MS_cleavage_agent_name},
    {MS_Mascot_SigThreshold, MS_Mascot_input_parameter},
    {MS_Mascot_MaxProteinHits, MS_Mascot_input_parameter},
    {MS_Mascot_ProteinScoringMethod, MS_Mascot_input_parameter},
    {MS_Mascot_MinMSMSThreshold, MS_Mascot_input_parameter},
    {MS_Mascot_ShowHomologousProteinsWithSamePeptides, MS_Mascot_input_parameter},
    {MS_Mascot_ShowHomologousProteinsWithSubsetOfPeptides, MS_Mascot_input_parameter},
    {MS_Mascot_RequireBoldRed, MS_Mascot_input_parameter},
    {MS_Mascot_UseUnigeneClustering, MS_Mascot_input_parameter},
    {MS_Mascot_IncludeErrorTolerantMatches, MS_Mascot_input_parameter},
    {MS_Mascot_ShowDecoyMatches, MS_Mascot_input_parameter},
    {MS_Spectronaut, MS_analysis_software},
    {MS_Spectronaut, MS_library_creation_software},
    {MS_OMSSA_evalue, MS_PSM_level_search_engine_specific_statistic},
    {MS_OMSSA_pvalue, MS_PSM_level_search_engine_specific_statistic},
    {MS_X_Tandem_expect, MS_PSM_level_search_engine_specific_statistic},
    {MS_X_Tandem_hyperscore, MS_PSM_level_search_engine_specific_statistic},
    {MS______FYWL_____P_, MS_Cleavage_agent_regular_expression},
    {MS_____M_, MS_Cleavage_agent_regular_expression},
    {MS______D_______D__, MS_Cleavage_agent_regular_expression},
    {MS_____K____P_, MS_Cleavage_agent_regular_expression},
    {MS_____K_, MS_Cleavage_agent_regular_expression},
    {MS______FL__, MS_Cleavage_agent_regular_expression},
    {MS______FYWLKR_____P_, MS_Cleavage_agent_regular_expression},
    {MS______KR__, MS_Cleavage_agent_regular_expression},
    {MS______BDEZ_____P_, MS_Cleavage_agent_regular_expression},
    {MS______EZ_____P_, MS_Cleavage_agent_regular_expression},
    {MS_database_sequence_details, MS_search_database_details},
    {MS_NA_sequence, MS_database_sequence_details},
    {MS_AA_sequence, MS_database_sequence_details},
    {MS_mass_table_source, MS_mass_table_options},
    {MS_AAIndex_mass_table, MS_mass_table_source},
    {MS_database_file_formats, MS_search_database_details},
    {MS_FASTA_format, MS_database_file_formats},
    {MS_ASN_1, MS_database_file_formats},
    {MS_NCBI___p_, MS_database_file_formats},
    {MS_clustal_aln, MS_database_file_formats},
    {MS_embl_em, MS_database_file_formats},
    {MS_NBRF_PIR, MS_database_file_formats},
    {MS_peptide_descriptions, MS_peptide_sequence_level_identification_attribute},
    {MS_spectrum_descriptions, MS_search_input_details},
    {MS_spectrum_quality_descriptions, MS_spectrum_descriptions},
    {MS_msmsEval_quality, MS_spectrum_quality_descriptions},
    {MS_alternate_single_letter_codes, MS_ambiguous_residues},
    {MS_alternate_mass, MS_ambiguous_residues},
    {MS_number_of_unmatched_peaks, MS_PSM_level_attribute},
    {MS_peptide_unique_to_one_protein, MS_peptide_sharing_details},
    {MS_peptide_sequence_level_global_FDR, MS_peptide_sequence_level_result_list_statistic},
    {MS_frag__internal_yb_ion, MS_fragmentation_ion_type},
    {MS_frag__internal_ya_ion, MS_fragmentation_ion_type},
    {MS_frag__z_1_ion, MS_fragmentation_ion_type},
    {MS_frag__z_2_ion, MS_fragmentation_ion_type},
    {MS_text_format, MS_mass_spectrometer_file_format},
    {MS_Mascot_homology_threshold, MS_PSM_level_search_engine_specific_statistic},
    {MS_Mascot_identity_threshold, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_Sequences, MS_search_engine_specific_score_for_proteins},
    {MS_SEQUEST_TIC, MS_search_engine_specific_score_for_proteins},
    {MS_SEQUEST_Sum, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_Instrument_Type, MS_Phenyx_input_parameter},
    {MS_Phenyx_Scoring_Model, MS_Phenyx_input_parameter},
    {MS_Phenyx_Default_Parent_Charge, MS_Phenyx_input_parameter},
    {MS_Phenyx_Trust_Parent_Charge, MS_Phenyx_input_parameter},
    {MS_Phenyx_Turbo, MS_Phenyx_input_parameter},
    {MS_Phenyx_Turbo_ErrorTol, MS_Phenyx_input_parameter},
    {MS_Phenyx_Turbo_Coverage, MS_Phenyx_input_parameter},
    {MS_Phenyx_Turbo_Series, MS_Phenyx_input_parameter},
    {MS_Phenyx_MinPepLength, MS_Phenyx_input_parameter},
    {MS_Phenyx_MinPepzscore, MS_Phenyx_input_parameter},
    {MS_Phenyx_MaxPepPvalue, MS_Phenyx_input_parameter},
    {MS_Phenyx_AC_Score, MS_Phenyx_input_parameter},
    {MS_Phenyx_Conflict_Resolution, MS_Phenyx_input_parameter},
    {MS_Phenyx_AC, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_ID, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_Score, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_Peptides1, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_Peptides2, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_Auto, MS_PSM_level_search_engine_specific_statistic},
    {MS_Phenyx_User, MS_PSM_level_search_engine_specific_statistic},
    {MS_Phenyx_User, MS_search_engine_specific_score_for_proteins},
    {MS_Phenyx_Pepzscore, MS_PSM_level_search_engine_specific_statistic},
    {MS_Phenyx_PepPvalue, MS_PSM_level_search_engine_specific_statistic},
    {MS_Phenyx_PepPvalue, MS_search_engine_specific_peptide_sequence_level_identification_statistic},
    {MS_Phenyx_NumberOfMC, MS_PSM_level_search_engine_specific_statistic},
    {MS_Phenyx_Modif, MS_PSM_level_search_engine_specific_statistic},
    {MS_Phenyx_Modif, MS_search_engine_specific_score_for_proteins},
    {MS_OMSSA_csv_format, MS_intermediate_analysis_format},
    {MS_OMSSA_xml_format, MS_intermediate_analysis_format},
    {MS_X_Tandem_xml_format, MS_intermediate_analysis_format},
    {MS_param__internal_yb_ion, MS_ion_series_considered_in_search},
    {MS_param__internal_ya_ion, MS_ion_series_considered_in_search},
    {MS_param__z_1_ion, MS_ion_series_considered_in_search},
    {MS_param__z_2_ion, MS_ion_series_considered_in_search},
    {MS_translation_start_codons, MS_search_database_details},
    {MS_search_tolerance_specification, MS_search_input_details},
    {MS_search_tolerance_plus_value, MS_search_tolerance_specification},
    {MS_search_tolerance_minus_value, MS_search_tolerance_specification},
    {MS_MGF_scans_OBSOLETE, MS_spectrum_identification_result_details},
    {MS_MGF_raw_scans_OBSOLETE, MS_spectrum_identification_result_details},
    {MS_spectrum_title_OBSOLETE, MS_spectrum_identification_result_details},
    {MS_SpectraST_dot, MS_PSM_level_search_engine_specific_statistic},
    {MS_SpectraST_dot_bias, MS_PSM_level_search_engine_specific_statistic},
    {MS_SpectraST_discriminant_score_F, MS_PSM_level_search_engine_specific_statistic},
    {MS_SpectraST_delta, MS_PSM_level_search_engine_specific_statistic},
    {MS_pepXML_format, MS_intermediate_analysis_format},
    {MS_protXML_format, MS_intermediate_analysis_format},
    {MS_translation_table_description, MS_search_database_details},
    {MS_ProteinExtractor_Methodname, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_GenerateNonRedundant, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_IncludeIdentified, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MaxNumberOfProteins, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MaxProteinMass, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MinNumberOfPeptides, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_UseMascot, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MascotPeptideScoreThreshold, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MascotUniqueScore, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MascotUseIdentityScore, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_MascotWeighting, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_UseSequest, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_SequestPeptideScoreThreshold, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_SequestUniqueScore, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_SequestWeighting, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_UseProteinSolver, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_ProteinSolverPeptideScoreThreshold, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_ProteinSolverUniqueScore, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_ProteinSolverWeighting, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_UsePhenyx, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_PhenyxPeptideScoreThreshold, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_PhenyxUniqueScore, MS_ProteinExtractor_input_parameter},
    {MS_ProteinExtractor_PhenyxWeighting, MS_ProteinExtractor_input_parameter},
    {MS_prot_FDR_threshold, MS_protein_level_statistical_threshold},
    {MS_pep_FDR_threshold, MS_peptide_level_statistical_threshold},
    {MS_OMSSA_e_value_threshold, MS_OMSSA_input_parameter},
    {MS_decoy_DB_details, MS_search_database_details},
    {MS_decoy_DB_generation_algorithm, MS_decoy_DB_details},
    {MS_decoy_DB_type_shuffle, MS_decoy_DB_details},
    {MS_DB_composition_only_decoy, MS_decoy_DB_details},
    {MS_quality_estimation_with_implicite_decoy_sequences, MS_quality_estimation_method_details},
    {MS_acquisition_software, MS_software},
    {MS_analysis_software, MS_software},
    {MS_data_processing_software, MS_software},
    {MS_unknown_modification, MS_peptide_modification_details},
    {MS_greylag, MS_analysis_software},
    {MS_PEFF_format, MS_database_file_formats},
    {MS_Phenyx_XML_format, MS_mass_spectrometer_file_format},
    {MS_Phenyx_XML_format, MS_intermediate_analysis_format},
    {MS_DTASelect_format, MS_intermediate_analysis_format},
    {MS_MS2_format, MS_mass_spectrometer_file_format},
    {MS_taxonomy__NCBI_TaxID, MS_molecule_taxonomy},
    {MS_taxonomy__common_name, MS_molecule_taxonomy},
    {MS_taxonomy__scientific_name, MS_molecule_taxonomy},
    {MS_taxonomy__Swiss_Prot_ID, MS_molecule_taxonomy},
    {MS_selected_ion_monitoring_chromatogram, MS_ion_current_chromatogram},
    {MS_selected_reaction_monitoring_chromatogram, MS_ion_current_chromatogram},
    {MS_consecutive_reaction_monitoring_chromatogram_OBSOLETE, MS_ion_current_chromatogram},
    {MS_OMSSA, MS_analysis_software},
    {MS_X_Tandem, MS_analysis_software},
    {MS_SpectraST, MS_analysis_software},
    {MS_SpectraST, MS_library_creation_software},
    {MS_Mascot_Parser, MS_analysis_software},
    {MS_null_terminated_ASCII_string, MS_binary_data_type},
    {MS_SCIEX_TOF_TOF_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_SCIEX_TOF_TOF_database, MS_mass_spectrometer_file_format},
    {MS_5800_TOF_TOF, MS_SCIEX_instrument_model},
    {MS_SCIEX_TOF_TOF_Series_Explorer_Software, MS_SCIEX_software},
    {MS_SCIEX_TOF_TOF_Series_Explorer_Software, MS_acquisition_software},
    {MS_SCIEX_TOF_TOF_Series_Explorer_Software, MS_analysis_software},
    {MS_SCIEX_TOF_TOF_Series_Explorer_Software, MS_data_processing_software},
    {MS_intensity_normalization, MS_data_processing_action},
    {MS_m_z_calibration, MS_data_processing_action},
    {MS_data_filtering, MS_data_processing_action},
    {MS_ProteinExtractor, MS_Bruker_software},
    {MS_ProteinExtractor, MS_analysis_software},
    {MS_Mascot_Distiller, MS_quantitation_software_name},
    {MS_Mascot_Distiller, MS_analysis_software},
    {MS_Mascot_Integra, MS_analysis_software},
    {MS_Percolator, MS_analysis_software},
    {MS_percolator_Q_value, MS_PSM_level_search_engine_specific_statistic},
    {MS_percolator_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_percolator_PEP, MS_PSM_level_search_engine_specific_statistic},
    {MS_no_threshold, MS_statistical_threshold},
    {MS_ProteinScape_SearchResultId, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinScape_SearchEventId, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinScape_ProfoundProbability, MS_PSM_level_search_engine_specific_statistic},
    {MS_Profound_z_value, MS_PSM_level_search_engine_specific_statistic},
    {MS_Profound_Cluster, MS_PSM_level_search_engine_specific_statistic},
    {MS_Profound_ClusterRank, MS_PSM_level_search_engine_specific_statistic},
    {MS_MSFit_Mowse_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_Sonar_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinScape_PFFSolverExp, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinScape_PFFSolverScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinScape_IntensityCoverage, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinScape_SequestMetaScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinExtractor_Score, MS_search_engine_specific_score_for_proteins},
    {MS_Agilent_MassHunter_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Agilent_MassHunter_format, MS_mass_spectrometer_file_format},
    {MS_TSQ_Vantage, MS_Thermo_Scientific_instrument_model},
    {MS_Sequence_database_filter_types, MS_database_filtering},
    {MS_Sequence_database_filters, MS_database_filtering},
    {MS_DB_sequence_filter_pattern, MS_Sequence_database_filters},
    {MS_DB_accession_filter_string, MS_Sequence_database_filters},
    {MS_frag__c_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__c_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__z_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__z_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__x_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__x_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__precursor_ion___H2O, MS_fragmentation_ion_type},
    {MS_frag__precursor_ion___NH3, MS_fragmentation_ion_type},
    {MS_frag__precursor_ion, MS_fragmentation_ion_type},
    {MS_fragment_neutral_loss, MS_peptide_modification_details},
    {MS_precursor_neutral_loss, MS_peptide_modification_details},
    {MS_spectrum_from_database_integer_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_Proteinscape_spectra, MS_mass_spectrometer_file_format},
    {MS_Mascot_query_number, MS_native_spectrum_identifier_format},
    {MS_Mascot_query_number, MS_spectrum_identification_result_details},
    {MS_spectra_data_details, MS_search_input_details},
    {MS_mzML_unique_identifier, MS_spectra_data_details},
    {MS_spectrum_from_ProteinScape_database_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_spectrum_from_ProteinScape_database_nativeID_format, MS_spectra_data_details},
    {MS_spectrum_from_database_string_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_spectrum_from_database_string_nativeID_format, MS_spectra_data_details},
    {MS_Bruker_Daltonics_esquire_series, MS_Bruker_Daltonics_instrument_model},
    {MS_Bruker_Daltonics_flex_series, MS_Bruker_Daltonics_instrument_model},
    {MS_Bruker_Daltonics_BioTOF_series, MS_Bruker_Daltonics_instrument_model},
    {MS_Bruker_Daltonics_micrOTOF_series, MS_Bruker_Daltonics_instrument_model},
    {MS_BioTOF, MS_Bruker_Daltonics_BioTOF_series},
    {MS_BioTOF_III, MS_Bruker_Daltonics_BioTOF_series},
    {MS_UltroTOF_Q, MS_Bruker_Daltonics_BioTOF_series},
    {MS_micrOTOF_II, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_maXis, MS_Bruker_Daltonics_maXis_series},
    {MS_amaZon_ETD, MS_Bruker_Daltonics_amaZon_series},
    {MS_microflex_LRF, MS_Bruker_Daltonics_flex_series},
    {MS_ultrafleXtreme, MS_Bruker_Daltonics_flex_series},
    {MS_Bruker_Daltonics_amaZon_series, MS_Bruker_Daltonics_instrument_model},
    {MS_amaZon_X, MS_Bruker_Daltonics_amaZon_series},
    {MS_Bruker_Daltonics_maXis_series, MS_Bruker_Daltonics_instrument_model},
    {MS_Bruker_Daltonics_solarix_series, MS_Bruker_Daltonics_instrument_model},
    {MS_solariX, MS_Bruker_Daltonics_solarix_series},
    {MS_microflex_II, MS_Bruker_Daltonics_flex_series},
    {MS_autoflex_II_TOF_TOF, MS_Bruker_Daltonics_flex_series},
    {MS_autoflex_III_TOF_TOF_smartbeam, MS_Bruker_Daltonics_flex_series},
    {MS_autoflex, MS_Bruker_Daltonics_flex_series},
    {MS_Bruker_Daltonics_apex_series, MS_Bruker_Daltonics_instrument_model},
    {MS_Shimadzu_Corporation_software, MS_software},
    {MS_MALDI_Solutions, MS_acquisition_software},
    {MS_MALDI_Solutions, MS_analysis_software},
    {MS_MALDI_Solutions, MS_data_processing_software},
    {MS_MALDI_Solutions, MS_Shimadzu_Corporation_software},
    {MS_SCIEX_TOF_TOF_T2D_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_SCIEX_TOF_TOF_T2D_format, MS_mass_spectrometer_file_format},
    {MS_Scaffold, MS_analysis_software},
    {MS_Scaffold_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_SEQUEST_SQT_format, MS_intermediate_analysis_format},
    {MS_Discoverer_MSF_format, MS_intermediate_analysis_format},
    {MS_IdentityE_XML_format, MS_intermediate_analysis_format},
    {MS_ProteinLynx_XML_format, MS_intermediate_analysis_format},
    {MS_SpectrumMill_directories, MS_intermediate_analysis_format},
    {MS_Scaffold_Peptide_Probability, MS_PSM_level_search_engine_specific_statistic},
    {MS_IdentityE_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinLynx_Log_Likelihood, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinLynx_Ladder_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_SpectrumMill_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_SpectrumMill_SPI, MS_PSM_level_search_engine_specific_statistic},
    {MS_report_only_spectra_assigned_to_identified_proteins, MS_quality_estimation_method_details},
    {MS_Scaffold__Minimum_Peptide_Count, MS_Scaffold_input_parameter},
    {MS_Scaffold__Minimum_Protein_Probability, MS_Scaffold_input_parameter},
    {MS_Scaffold__Minimum_Peptide_Probability, MS_Scaffold_input_parameter},
    {MS_minimum_number_of_enzymatic_termini, MS_common_search_engine_input_parameter},
    {MS_Scaffold_Protein_Probability, MS_search_engine_specific_score_for_proteins},
    {MS_SpectrumMill_Discriminant_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_FAIMS_compensation_voltage, MS_ion_mobility_attribute},
    {MS_FAIMS_compensation_voltage, MS_ion_selection_attribute},
    {MS_FAIMS_compensation_voltage, MS_peak_attribute},
    {MS_XCMS, MS_analysis_software},
    {MS_XCMS, MS_data_processing_software},
    {MS_MaxQuant, MS_quantitation_software_name},
    {MS_MaxQuant, MS_analysis_software},
    {MS_combined_pmf___ms_ms_search, MS_search_type},
    {MS_MyriMatch, MS_analysis_software},
    {MS_DirecTag, MS_analysis_software},
    {MS_TagRecon, MS_analysis_software},
    {MS_Pepitome, MS_analysis_software},
    {MS_MyriMatch_MVH, MS_PSM_level_search_engine_specific_statistic},
    {MS_MyriMatch_mzFidelity, MS_PSM_level_search_engine_specific_statistic},
    {MS_anchor_protein, MS_protein_group_or_subset_relationship},
    {MS_family_member_protein, MS_protein_group_or_subset_relationship},
    {MS_group_member_with_undefined_relationship_OR_ortholog_protein, MS_protein_group_or_subset_relationship},
    {MS_sequence_same_set_protein, MS_protein_group_or_subset_relationship},
    {MS_spectrum_same_set_protein, MS_protein_group_or_subset_relationship},
    {MS_sequence_sub_set_protein, MS_protein_group_or_subset_relationship},
    {MS_spectrum_sub_set_protein, MS_protein_group_or_subset_relationship},
    {MS_sequence_subsumable_protein, MS_protein_group_or_subset_relationship},
    {MS_spectrum_subsumable_protein, MS_protein_group_or_subset_relationship},
    {MS_protein_inference_confidence_category, MS_protein_group_or_subset_relationship},
    {MS_ProteomeDiscoverer_Spectrum_Files_Raw_File_names_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SRF_File_Selector_SRF_File_Path_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Ionization_Source_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Activation_Type_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Lower_RT_Limit, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mass_Analyzer_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Max_Precursor_Mass, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Min_Precursor_Mass, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Minimum_Peak_Count, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_MS_Order_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Polarity_Mode_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Selection, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SN_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Scan_Type_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Total_Intensity_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Activation_Type_Replacements, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Charge_Replacements, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Mass_Analyzer_Replacements, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_MS_Order_Replacements, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Polarity_Replacements, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Upper_RT_Limit, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Mass_Window_Offset, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Maximum_Neutral_Loss_Mass, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Charge_Reduced_Precursor, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Neutral_Loss_Peaks, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Only_Known_Masses, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Precursor_Overtones, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Precursor_Peak, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Allow_Mass_Analyzer_Mismatch, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Allow_MS_Order_Mismatch, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Max_RT_Difference_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Grouper_Precursor_Mass_Criterion, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Highest_Charge, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Highest_MZ_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Lowest_Charge, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Lowest_MZ_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Monoisotopic_Mass_Only, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Overlapping_Remainder, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Required_Fitting_Accuracy, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Xtract_Resolution_At_400, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Lowest_Charge_State, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Highest_Charge_State, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Score_Filter_Let_Pass_Above_Scores, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Dynamic_Modification, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Static_Modification, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Decoy_Search_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Error_tolerant_Search, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Max_MGF_File_Size, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Mascot_Server_URL, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Number_of_attempts_to_submit_the_search, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_X_Static_Modification, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_User_Name_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Time_interval_between_attempts_to_submit_a_search, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Enzyme_Name_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Fragment_Mass_Tolerance_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_Mascot_Instrument, MS_Mascot_input_parameter},
    {MS_ProteomeDiscoverer_Maximum_Missed_Cleavage_Sites, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Peptide_CutOff_Score, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Precursor_Mass_Tolerance_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Protein_CutOff_Score, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Protein_Database_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Protein_Relevance_Factor, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Target_FDR_Relaxed, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Target_FDR_Strict, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Taxonomy_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Use_Average_Precursor_Mass_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_Mascot_use_MudPIT_scoring_OBSOLETE, MS_Mascot_input_parameter},
    {MS_ProteomeDiscoverer_Absolute_XCorr_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Calculate_Probability_Score, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_CTerminal_Modification, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Fragment_Ion_Cutoff_Percentage, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Max_Identical_Modifications_Per_Peptide, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Max_Modifications_Per_Peptide, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Maximum_Peptides_Considered, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Maximum_Peptides_Output, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Maximum_Protein_References_Per_Peptide, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_NTerminal_Modification, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Peptide_CTerminus, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Peptide_NTerminus, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Peptide_Relevance_Factor, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Protein_Relevance_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Search_Against_Decoy_Database_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Use_Average_Fragment_Masses, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_a_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_b_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_y_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Use_Neutral_Loss_z_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_a_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_b_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_c_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_d_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_v_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_w_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_x_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_y_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Weight_of_z_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_ZCore_Protein_Score_Cutoff, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Integration_Method, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Integration_Window_Tolerance, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Quantitation_Method, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Exporter_Export_Format_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Exporter_File_name, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Search_Modifications_Only_For_Identified_Proteins, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge1, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge2, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge3, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge4, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge1, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge2, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge3, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge4, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge1, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge2, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge3, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge4, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge1, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge2, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge3, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge4, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_1__Dynamic_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_2__Dynamic_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_3__Dynamic_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_4__Dynamic_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Static_Modification_for_X, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Initial_minimal_peptide_probability, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Minimal_peptide_probability, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Minimal_peptide_weight, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Number_of_input1_spectra, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Number_of_input2_spectra, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Number_of_input3_spectra, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Number_of_input4_spectra, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Number_of_input5_spectra, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Number_of_predicted_correct_proteins, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Organism_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Reference_Database_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Residue_substitution_list, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Source_file_extension_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Source_Files_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Source_Files_old_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_WinCyg_reference_database, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_WinCyg_source_files, MS_ProteomeDiscoverer_input_parameter},
    {MS_LTQ_Orbitrap_Velos, MS_Thermo_Scientific_instrument_model},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_A_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_B_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_C_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_D_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_V_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_W_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_X_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_Y_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Weight_of_Z_Ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Use_New_Precursor_Reevaluation, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_SN_Threshold_FTonly, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Please_Do_not_Touch_this, MS_ProteomeDiscoverer_input_parameter},
    {MS_contact_phone_number, MS_contact_attribute},
    {MS_contact_fax_number, MS_contact_attribute},
    {MS_contact_toll_free_phone_number, MS_contact_attribute},
    {MS_Mascot_SigThresholdType, MS_Mascot_input_parameter},
    {MS_Mascot_ProteinGrouping, MS_Mascot_input_parameter},
    {MS_Percolator_features, MS_Percolator_input_parameter},
    {MS_ACQUITY_UPLC, MS_Waters_instrument_model},
    {MS_ACQUITY_UPLC_H_Class, MS_Waters_instrument_model},
    {MS_ACQUITY_UPLC_H_Class_Bio, MS_Waters_instrument_model},
    {MS_ACQUITY_UPLC_I_Class, MS_Waters_instrument_model},
    {MS_ACQUITY_UPLC_Systems_with_2D_Technology, MS_Waters_instrument_model},
    {MS_nanoACQUITY_UPLC, MS_Waters_instrument_model},
    {MS_nanoACQUITY_UPLC_System_with_1D_Technology, MS_Waters_instrument_model},
    {MS_nanoACQUITY_UPLC_with_HDX_Technology, MS_Waters_instrument_model},
    {MS_TRIZAIC_UPLC_nanoTile, MS_Waters_instrument_model},
    {MS_GCT_Premier, MS_Waters_instrument_model},
    {MS_MALDI_Synapt_G2_HDMS, MS_Waters_instrument_model},
    {MS_MALDI_Synapt_G2_MS, MS_Waters_instrument_model},
    {MS_MALDI_Synapt_G2_S_HDMS, MS_Waters_instrument_model},
    {MS_MALDI_Synapt_G2_S_MS, MS_Waters_instrument_model},
    {MS_MALDI_Synapt_HDMS, MS_Waters_instrument_model},
    {MS_MALDI_Synapt_MS, MS_Waters_instrument_model},
    {MS_Synapt_G2_HDMS, MS_Waters_instrument_model},
    {MS_Synapt_G2_MS, MS_Waters_instrument_model},
    {MS_Synapt_G2_S_HDMS, MS_Waters_instrument_model},
    {MS_Synapt_G2_S_MS, MS_Waters_instrument_model},
    {MS_Synapt_HDMS, MS_Waters_instrument_model},
    {MS_Synapt_MS, MS_Waters_instrument_model},
    {MS_Xevo_G2_Q_Tof, MS_Waters_instrument_model},
    {MS_Xevo_G2_Tof, MS_Waters_instrument_model},
    {MS_Xevo_Q_Tof, MS_Waters_instrument_model},
    {MS_3100, MS_Waters_instrument_model},
    {MS_Acquity_SQD, MS_Waters_instrument_model},
    {MS_Acquity_TQD, MS_Waters_instrument_model},
    {MS_Quattro_micro_GC, MS_Waters_instrument_model},
    {MS_Xevo_TQ_MS, MS_Waters_instrument_model},
    {MS_Xevo_TQD, MS_Waters_instrument_model},
    {MS_Xevo_TQ_S, MS_Waters_instrument_model},
    {MS_Mascot_PreferredTaxonomy, MS_Mascot_input_parameter},
    {MS_Empower, MS_Waters_software},
    {MS_Empower, MS_analysis_software},
    {MS_Empower, MS_data_processing_software},
    {MS_UNIFY, MS_Waters_software},
    {MS_UNIFY, MS_analysis_software},
    {MS_UNIFY, MS_data_processing_software},
    {MS_LECO_software, MS_software},
    {MS_ChromaTOF_software, MS_acquisition_software},
    {MS_ChromaTOF_software, MS_analysis_software},
    {MS_ChromaTOF_software, MS_data_processing_software},
    {MS_ChromaTOF_software, MS_LECO_software},
    {MS_LECO_instrument_model, MS_instrument_model},
    {MS_Pegasus_HRT, MS_LECO_instrument_model},
    {MS_Citius_HRT, MS_LECO_instrument_model},
    {MS_Pegasus, MS_LECO_instrument_model},
    {MS_TruTOF, MS_LECO_instrument_model},
    {MS_quantification_datatype, MS_quantification_information},
    {MS_quantification_object_attribute, MS_quantification_information},
    {MS_study_variable_attribute, MS_quantification_object_attribute},
    {MS_technical_replicate, MS_study_variable_attribute},
    {MS_biological_replicate, MS_study_variable_attribute},
    {MS_experimental_condition__case_, MS_study_variable_attribute},
    {MS_experimental_condition__control_, MS_study_variable_attribute},
    {MS_experimental_condition__disease_, MS_study_variable_attribute},
    {MS_experimental_condition__healthy_, MS_study_variable_attribute},
    {MS_generic_experimental_condition, MS_study_variable_attribute},
    {MS_time_series__time_point_X, MS_study_variable_attribute},
    {MS_dilution_series__concentration_X, MS_study_variable_attribute},
    {MS_raw_file_attribute, MS_quantification_object_attribute},
    {MS_one_sample_run, MS_raw_file_attribute},
    {MS_two_sample_run, MS_raw_file_attribute},
    {MS_three_sample_run, MS_raw_file_attribute},
    {MS_four_sample_run, MS_raw_file_attribute},
    {MS_eight_sample_run, MS_raw_file_attribute},
    {MS_raw_files_group_attribute, MS_quantification_object_attribute},
    {MS_merge_of_runs_of_1D_gel_bands, MS_raw_files_group_attribute},
    {MS_feature_list_attribute, MS_quantification_object_attribute},
    {MS_mass_trace_reporting__rectangles, MS_feature_list_attribute},
    {MS_mass_trace_reporting__polygons, MS_feature_list_attribute},
    {MS_feature_attribute, MS_quantification_object_attribute},
    {MS_SRM_transition_ID, MS_feature_attribute},
    {MS_Progenesis_LC_MS, MS_quantitation_software_name},
    {MS_SILACAnalyzer, MS_quantitation_software_name},
    {MS_SILACAnalyzer, MS_TOPP_software},
    {MS_quantitation_software_comment_or_customizations, MS_quantification_information},
    {MS_quantitation_analysis_summary, MS_quantification_information},
    {MS_LC_MS_label_free_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_SILAC_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_spectral_counting_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_iTRAQ_quantitation_analysis, MS_isobaric_label_quantitation_analysis},
    {MS_SRM_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_metabolic_labeling_14N___15N_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_LC_MS_feature_intensity, MS_feature_level_quantification_datatype},
    {MS_LC_MS_feature_volume, MS_feature_level_quantification_datatype},
    {MS_sequence_level_spectral_count, MS_peptide_level_quantification_datatype},
    {MS_MS1_feature_maximum_intensity, MS_feature_level_quantification_datatype},
    {MS_MS1_feature_area, MS_feature_level_quantification_datatype},
    {MS_peak_area_OBSOLETE, MS_quantification_datatype},
    {MS_isotopic_pattern_area, MS_quantification_datatype},
    {MS_reporter_ion_intensity, MS_quantification_datatype},
    {MS_simple_ratio_of_two_values, MS_ratio_calculation_method},
    {MS_sum_of_MatchedFeature_values_OBSOLETE, MS_feature_level_quantification_datatype},
    {MS_normalized_peptide_value, MS_peptide_level_quantification_datatype},
    {MS_protein_value__sum_of_peptide_values, MS_protein_level_quantification_datatype},
    {MS_normalized_protein_value, MS_protein_level_quantification_datatype},
    {MS_max_fold_change, MS_quantification_datatype},
    {MS_ANOVA_p_value, MS_p_value},
    {MS_t_test_p_value, MS_p_value},
    {MS_reporter_ion_raw_value, MS_quantification_datatype},
    {MS_reporter_ion_normalized_value, MS_quantification_datatype},
    {MS_XIC_area, MS_quantification_datatype},
    {MS_normalized_XIC_area, MS_quantification_datatype},
    {MS_protein_value__mean_of_peptide_ratios, MS_protein_level_quantification_datatype},
    {MS_normalization_to_mean_of_sum_of_all_proteins, MS_quantification_data_processing},
    {MS_quantile_normalization__proteins, MS_quantification_data_processing},
    {MS_quantile_normalization__peptides, MS_quantification_data_processing},
    {MS_Progenesis_automatic_alignment, MS_quantification_data_processing},
    {MS_Progenesis_manual_alignment, MS_quantification_data_processing},
    {MS_Progenesis_normalization, MS_quantification_data_processing},
    {MS_distinct_peptide_level_q_value, MS_peptide_level_statistical_threshold},
    {MS_protein_level_q_value, MS_single_protein_identification_statistic},
    {MS_peptide_sequence_level_p_value, MS_peptide_sequence_level_identification_statistic},
    {MS_protein_level_p_value, MS_single_protein_identification_statistic},
    {MS_peptide_sequence_level_e_value, MS_peptide_sequence_level_identification_statistic},
    {MS_protein_level_e_value, MS_single_protein_identification_statistic},
    {MS_FDRScore_OBSOLETE, MS_PSM_level_search_engine_specific_statistic},
    {MS_FDRScore_OBSOLETE, MS_search_engine_specific_score},
    {MS_modification_motif, MS_modification_specificity_rule},
    {MS_modification_probability, MS_modification_specificity_rule},
    {MS_ChromaTOF_HRT_software, MS_acquisition_software},
    {MS_ChromaTOF_HRT_software, MS_analysis_software},
    {MS_ChromaTOF_HRT_software, MS_data_processing_software},
    {MS_ChromaTOF_HRT_software, MS_LECO_software},
    {MS_MALDI_Solutions_Microbial_Identification, MS_MALDI_Solutions},
    {MS_offset_voltage, MS_source_attribute},
    {MS_in_source_collision_induced_dissociation, MS_dissociation_method},
    {MS_mz5_format, MS_mass_spectrometer_file_format},
    {MS_coefficient_of_variation, MS_transition_validation_attribute},
    {MS_signal_to_noise_ratio, MS_transition_validation_attribute},
    {MS_command_line_parameters, MS_data_processing_parameter},
    {MS_command_line_parameters, MS_library_provenance_attribute},
    {MS_SQID, MS_analysis_software},
    {MS_SQID, MS_data_processing_software},
    {MS_SQID_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_SQID_deltaScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_SQID_protein_score, MS_search_engine_specific_score_for_proteins},
    {MS_Progenesis_protein_normalised_abundance, MS_protein_level_quantification_datatype},
    {MS_Progenesis_peptide_normalised_abundance, MS_peptide_level_quantification_datatype},
    {MS_Progenesis_protein_raw_abundance, MS_protein_level_quantification_datatype},
    {MS_Progenesis_peptide_raw_abundance, MS_peptide_level_quantification_datatype},
    {MS_Progenesis_confidence_score, MS_quantification_datatype},
    {MS_Progenesis_peptide_count, MS_peptide_level_quantification_datatype},
    {MS_Progenesis_feature_intensity, MS_feature_level_quantification_datatype},
    {MS_MaxQuant_peptide_counts__unique_, MS_peptide_level_quantification_datatype},
    {MS_MaxQuant_peptide_counts__all_, MS_peptide_level_quantification_datatype},
    {MS_MaxQuant_peptide_counts__razor_unique_, MS_peptide_level_quantification_datatype},
    {MS_MaxQuant_sequence_length, MS_peptide_level_quantification_datatype},
    {MS_MaxQuant_PEP, MS_quantification_datatype},
    {MS_MaxQuant_LFQ_intensity, MS_quantification_datatype},
    {MS_MaxQuant_feature_intensity, MS_feature_level_quantification_datatype},
    {MS_MaxQuant_MS_MS_count, MS_quantification_datatype},
    {MS_emPAI_value, MS_protein_level_quantification_datatype},
    {MS_APEX_value, MS_protein_level_quantification_datatype},
    {MS_retention_time_window_width, MS_retention_time_window_attribute},
    {MS_ISQ, MS_Thermo_Scientific_instrument_model},
    {MS_Velos_Plus, MS_Thermo_Scientific_instrument_model},
    {MS_LTQ_Orbitrap_Elite, MS_Thermo_Scientific_instrument_model},
    {MS_Q_Exactive, MS_Thermo_Scientific_instrument_model},
    {MS_PinPoint, MS_Thermo_Finnigan_software},
    {MS_PinPoint, MS_analysis_software},
    {MS_PinPoint, MS_data_processing_software},
    {MS_S_lens_voltage, MS_source_attribute},
    {MS_pymzML, MS_data_processing_software},
    {MS_leukocyte_elastase, MS_cleavage_agent_name},
    {MS_proline_endopeptidase, MS_cleavage_agent_name},
    {MS_glutamyl_endopeptidase, MS_cleavage_agent_name},
    {MS_2_iodobenzoate, MS_cleavage_agent_name},
    {MS_ProteomeXchange_accession_number, MS_external_reference_identifier},
    {MS_ProteomeXchange_accession_number_version_number, MS_external_reference_identifier},
    {MS_Digital_Object_Identifier__DOI_, MS_external_reference_identifier},
    {MS_external_reference_keyword, MS_external_reference_data},
    {MS_journal_article_keyword, MS_external_reference_keyword},
    {MS_submitter_keyword, MS_external_reference_keyword},
    {MS_curator_keyword, MS_external_reference_keyword},
    {MS_Tranche_file_hash, MS_external_reference_identifier},
    {MS_Tranche_project_hash, MS_external_reference_identifier},
    {MS_PRIDE_experiment_URI, MS_external_reference_identifier},
    {MS_PRIDE_project_URI, MS_external_reference_identifier},
    {MS_stainless_steel_plate, MS_sample_plate_type},
    {MS_coated_glass_plate, MS_sample_plate_type},
    {MS_static_supply_electrospray, MS_electrospray_supply_type},
    {MS_fed_supply_electrospray, MS_electrospray_supply_type},
    {MS_Collision_cell_exit_potential, MS_precursor_activation_attribute},
    {MS_Pegasus_4D, MS_LECO_instrument_model},
    {MS_PEAKS_Studio, MS_quantitation_software_name},
    {MS_PEAKS_Studio, MS_analysis_software},
    {MS_PEAKS_Studio, MS_data_processing_software},
    {MS_PEAKS_Online, MS_quantitation_software_name},
    {MS_PEAKS_Online, MS_analysis_software},
    {MS_PEAKS_Online, MS_data_processing_software},
    {MS_PEAKS_Node, MS_quantitation_software_name},
    {MS_PEAKS_Node, MS_analysis_software},
    {MS_PEAKS_Node, MS_data_processing_software},
    {MS_BSI_software, MS_software},
    {MS_PEAKS_peptideScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_PEAKS_proteinScore, MS_search_engine_specific_score_for_proteins},
    {MS_ZCore_probScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_no_cleavage, MS_cleavage_agent_name},
    {MS_unspecific_cleavage, MS_cleavage_agent_name},
    {MS______ALIV_____P_, MS_Cleavage_agent_regular_expression},
    {MS______HKR_P____P_, MS_Cleavage_agent_regular_expression},
    {MS_______E_E_, MS_Cleavage_agent_regular_expression},
    {MS_____W_, MS_Cleavage_agent_regular_expression},
    {MS_Mascot_C13_counts, MS_Mascot_input_parameter},
    {MS_ProteinExtractor_Weighting, MS_ProteinExtractor_input_parameter},
    {MS_ProteinScape_second_round_Mascot, MS_ProteinScape_input_parameter},
    {MS_ProteinScape_second_round_Phenyx, MS_ProteinScape_input_parameter},
    {MS_product_ion_mobility, MS_product_ion_attribute},
    {MS_product_ion_drift_time_OBSOLETE, MS_SRM_transition_attribute},
    {MS_PTM_localization_PSM_level_statistic, MS_PTM_localization_single_result_statistic},
    {MS_phosphoRS_score, MS_PTM_localization_PSM_level_statistic},
    {MS_phosphoRS_sequence_probability, MS_PTM_localization_PSM_level_statistic},
    {MS_phosphoRS_site_probability, MS_PTM_localization_PSM_level_statistic},
    {MS_PTM_scoring_algorithm_version, MS_peptide_modification_details},
    {MS_DeBunker, MS_analysis_software},
    {MS_DeBunker_score, MS_PTM_localization_PSM_level_statistic},
    {MS_DeBunker_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_delta_m_z, MS_spectrum_identification_result_details},
    {MS_delta_M, MS_spectrum_identification_result_details},
    {MS_MSQuant, MS_analysis_software},
    {MS_MSQuant_PTM_score, MS_PTM_localization_PSM_level_statistic},
    {MS_MaxQuant_PTM_Score, MS_PTM_localization_PSM_level_statistic},
    {MS_MaxQuant_Phospho__STY__Probabilities, MS_PTM_localization_PSM_level_statistic},
    {MS_MaxQuant_Phospho__STY__Score_Diffs, MS_PTM_localization_PSM_level_statistic},
    {MS_MaxQuant_P_site_localization_probability, MS_PTM_localization_PSM_level_statistic},
    {MS_MaxQuant_PTM_Delta_Score, MS_PTM_localization_PSM_level_statistic},
    {MS_Ascore_software, MS_analysis_software},
    {MS_Ascore, MS_PTM_localization_PSM_level_statistic},
    {MS_H_Score, MS_PTM_localization_PSM_level_statistic},
    {MS_vacuum_drying_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_crushed_crystal_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_fast_evaporation_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_overlayer_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_sandwich_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_spin_coating_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_quick_and_dirty_MALDI_sample_preparation, MS_matrix_application_type},
    {MS_top_hat_baseline_reduction, MS_baseline_reduction},
    {MS_convex_hull_baseline_reduction, MS_baseline_reduction},
    {MS_median_baseline_reduction, MS_baseline_reduction},
    {MS_wavelet_transformation_smoothing, MS_smoothing},
    {MS_sophisticated_numerical_annotation_procedure, MS_area_peak_picking},
    {MS_area_normalization, MS_intensity_normalization},
    {MS_LIFT, MS_dissociation_method},
    {MS_MS1_label_based_raw_feature_quantitation, MS_MS1_label_based_analysis},
    {MS_MS1_label_based_peptide_level_quantitation, MS_MS1_label_based_analysis},
    {MS_MS1_label_based_protein_level_quantitation, MS_MS1_label_based_analysis},
    {MS_MS1_label_based_proteingroup_level_quantitation, MS_MS1_label_based_analysis},
    {MS_iRT_retention_time_normalization_standard, MS_retention_time_normalization_standard},
    {MS_target_SRM_transition, MS_SRM_transition_type},
    {MS_decoy_SRM_transition, MS_SRM_transition_type},
    {MS_isobaric_label_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_TMT_quantitation_analysis, MS_isobaric_label_quantitation_analysis},
    {MS_desorption_electrospray_ionization, MS_atmospheric_pressure_ionization},
    {MS_Mascot_PTM_site_assignment_confidence, MS_PTM_localization_PSM_level_statistic},
    {MS_collision_energy_ramp_start, MS_collision_energy},
    {MS_collision_energy_ramp_end, MS_collision_energy},
    {MS_spectral_count_peptide_level_quantitation, MS_spectral_counting_quantitation_analysis},
    {MS_spectral_count_protein_level_quantitation, MS_spectral_counting_quantitation_analysis},
    {MS_spectral_count_proteingroup_level_quantitation, MS_spectral_counting_quantitation_analysis},
    {MS_MS1_label_based_analysis, MS_quantitation_analysis_summary},
    {MS_label_free_raw_feature_quantitation, MS_LC_MS_label_free_quantitation_analysis},
    {MS_label_free_peptide_level_quantitation, MS_LC_MS_label_free_quantitation_analysis},
    {MS_label_free_protein_level_quantitation, MS_LC_MS_label_free_quantitation_analysis},
    {MS_label_free_proteingroup_level_quantitation, MS_LC_MS_label_free_quantitation_analysis},
    {MS_MS2_tag_based_analysis, MS_quantitation_analysis_summary},
    {MS_MS2_tag_based_feature_level_quantitation, MS_MS2_tag_based_analysis},
    {MS_MS2_tag_based_peptide_level_quantitation, MS_MS2_tag_based_analysis},
    {MS_MS2_tag_based_protein_level_quantitation, MS_MS2_tag_based_analysis},
    {MS_MS2_tag_based_proteingroup_level_quantitation, MS_MS2_tag_based_analysis},
    {MS_nucleic_acid_base_modification, MS_peptide_modification_details},
    {MS_original_nucleic_acid_sequence, MS_peptide_modification_details},
    {MS_modified_nucleic_acid_sequence, MS_peptide_modification_details},
    {MS_PASSEL_transition_group_browser_URI, MS_external_reference_identifier},
    {MS_PeptideAtlas_dataset_URI, MS_external_reference_identifier},
    {MS_contact_role, MS_contact_attribute},
    {MS_first_author, MS_contact_role},
    {MS_senior_author, MS_contact_role},
    {MS_co_author, MS_contact_role},
    {MS_dataset_submitter, MS_contact_role},
    {MS_label_free_sample, MS_sample_attribute},
    {MS_inlet_attribute, MS_object_attribute},
    {MS_inlet_temperature, MS_source_attribute},
    {MS_inlet_temperature, MS_inlet_attribute},
    {MS_source_temperature, MS_source_attribute},
    {MS_modulation_time, MS_run_attribute},
    {MS_ProteinProspector, MS_analysis_software},
    {MS_ProteinProspector_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteinProspector_expectation_value, MS_PSM_level_search_engine_specific_statistic},
    {MS_native_source_path, MS_spectrum_generation_information},
    {MS_MS_GF, MS_analysis_software},
    {MS_MS_GF_, MS_analysis_software},
    {MS_MS_GF_RawScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_GF_DeNovoScore, MS_search_engine_specific_score_for_proteins},
    {MS_MS_GF_Energy, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_GF_SpecEValue, MS_PSM_level_e_value},
    {MS_MS_GF_SpecEValue, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_GF_EValue, MS_PSM_level_e_value},
    {MS_MS_GF_EValue, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_GF_QValue, MS_PSM_level_q_value},
    {MS_MS_GF_QValue, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_GF_PepQValue, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_GF_PEP, MS_PSM_level_search_engine_specific_statistic},
    {MS_modification_specificity_protein_N_term, MS_modification_specificity_rule},
    {MS_modification_specificity_protein_C_term, MS_modification_specificity_rule},
    {MS_Microsoft_Excel, MS_quantitation_software_name},
    {MS_database_UniProtKB_TrEMBL, MS_database_UniProtKB},
    {MS_metabolic_labelling__natural_N__mainly_14N_, MS_modification_parameters},
    {MS_FindPairs, MS_quantitation_software_name},
    {MS_peptide_consensus_RT, MS_peptide_level_quantification_datatype},
    {MS_peptide_consensus_m_z, MS_peptide_level_quantification_datatype},
    {MS_ratio_calculation_method, MS_quantification_datatype},
    {MS_protein_value__median_of_peptide_ratios, MS_protein_level_quantification_datatype},
    {MS_metabolic_labelling__heavy_N__mainly_15N_, MS_modification_parameters},
    {MS_metabolic_labelling_purity, MS_modification_parameters},
    {MS_t_test, MS_quantification_data_processing},
    {MS_ANOVA_test, MS_quantification_data_processing},
    {MS_p_value, MS_quantification_datatype},
    {MS_mzIdentML_format, MS_intermediate_analysis_format},
    {MS_quantification_file_format, MS_file_format},
    {MS_mzQuantML_format, MS_quantification_file_format},
    {MS_PAnalyzer, MS_analysis_software},
    {MS_impact, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_ProteomeDiscoverer_1__Static_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_2__Static_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Clipping_Range_Before, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Clipping_Range_After, MS_ProteomeDiscoverer_input_parameter},
    {MS_first_column_elution_time, MS_scan_attribute},
    {MS_second_column_elution_time, MS_scan_attribute},
    {MS_multidimensional_chromatography_modulation_description, MS_run_attribute},
    {MS_two_dimensional_gas_chromatography_with_fixed_modulation_time, MS_multidimensional_chromatography_modulation_description},
    {MS_two_dimensional_gas_chromatography_with_discrete_modulation_time_steps, MS_multidimensional_chromatography_modulation_description},
    {MS_two_dimensional_liquid_chromatography_with_fixed_modulation_time, MS_multidimensional_chromatography_modulation_description},
    {MS_two_dimensional_liquid_chromatography_with_discrete_modulation_time_steps, MS_multidimensional_chromatography_modulation_description},
    {MS_ProteomeDiscoverer_Peptide_Without_Protein_XCorr_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_Calculate_Probability_Scores, MS_common_search_engine_input_parameter},
    {MS_ProteomeDiscoverer_Maximum_Delta_Cn, MS_ProteomeDiscoverer_input_parameter},
    {MS_Percolator_Validation_based_on, MS_Percolator_input_parameter},
    {MS_search_engine_input_parameter, MS_search_input_details},
    {MS_common_search_engine_input_parameter, MS_search_engine_input_parameter},
    {MS_Mascot_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_SEQUEST_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_Phenyx_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_ProteinExtractor_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_OMSSA_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_ProteinScape_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_ProteomeDiscoverer_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_software_input_parameter, MS_search_input_details},
    {MS_common_software_input_parameter, MS_software_input_parameter},
    {MS_software_specific_input_parameter, MS_software_input_parameter},
    {MS_Scaffold_input_parameter, MS_software_specific_input_parameter},
    {MS_Percolator_input_parameter, MS_software_specific_input_parameter},
    {MS_assay_attribute, MS_quantification_object_attribute},
    {MS_assay_label_attribute, MS_quantification_object_attribute},
    {MS_protein_group_list_attribute, MS_quantification_object_attribute},
    {MS_protein_group_attribute, MS_quantification_object_attribute},
    {MS_protein_list_attribute, MS_quantification_object_attribute},
    {MS_peptide_consensus_list_attribute, MS_quantification_object_attribute},
    {MS_peptide_consensus_attribute, MS_quantification_object_attribute},
    {MS_small_molecule_list_attribute, MS_quantification_object_attribute},
    {MS_small_molecule_attribute, MS_quantification_object_attribute},
    {MS_small_molecule_modification_attribute, MS_quantification_object_attribute},
    {MS_experiment_name, MS_quantification_object_attribute},
    {MS_spectral_count_feature, MS_feature_attribute},
    {MS_counts_reporting, MS_feature_list_attribute},
    {MS_x_Tracker, MS_quantitation_software_name},
    {MS_ProteoSuite, MS_quantitation_software_name},
    {MS_combined_FDRScore_OBSOLETE, MS_PSM_level_search_engine_specific_statistic},
    {MS_combined_FDRScore_OBSOLETE, MS_search_engine_specific_score},
    {MS_database_UniProtKB, MS_database_name},
    {MS_identification_file_attribute, MS_quantification_object_attribute},
    {MS_method_file_format, MS_file_format},
    {MS_ITRAQAnalyzer, MS_quantitation_software_name},
    {MS_ITRAQAnalyzer, MS_TOPP_software},
    {MS_identification_file_format, MS_file_format},
    {MS_TOPP_noise_filter, MS_TOPP_software},
    {MS_TOPP_NoiseFilterGaussian, MS_TOPP_noise_filter},
    {MS_TOPP_NoiseFilterSGolay, MS_TOPP_noise_filter},
    {MS_TOPP_peak_picker, MS_TOPP_software},
    {MS_TOPP_PeakPickerHiRes, MS_TOPP_peak_picker},
    {MS_TOPP_PeakPickerWavelet, MS_TOPP_peak_picker},
    {MS_TOPP_spectra_filter, MS_TOPP_software},
    {MS_TOPP_SpectraFilterBernNorm, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterMarkerMower, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterNLargest, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterNormalizer, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterParentPeakMower, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterScaler, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterSqrtMower, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterThresholdMower, MS_TOPP_spectra_filter},
    {MS_TOPP_SpectraFilterWindowMower, MS_TOPP_spectra_filter},
    {MS_TOPP_map_aligner, MS_TOPP_software},
    {MS_TOPP_MapAlignerIdentification, MS_TOPP_map_aligner},
    {MS_TOPP_MapAlignerPoseClustering, MS_TOPP_map_aligner},
    {MS_TOPP_MapAlignerSpectrum, MS_TOPP_map_aligner},
    {MS_numerator_data_type_attribute, MS_quantification_object_attribute},
    {MS_denominator_data_type_attribute, MS_quantification_object_attribute},
    {MS_protein_level_PSM_counts, MS_protein_level_quantification_datatype},
    {MS_TOPP_DTAExtractor, MS_TOPP_software},
    {MS_TOPP_IDMerger, MS_TOPP_software},
    {MS_TOPP_IDFileConverter, MS_TOPP_software},
    {MS_TOPP_SpectraMerger, MS_TOPP_software},
    {MS_TOPP_MzTabExporter, MS_TOPP_software},
    {MS_TOPP_MassTraceExtractor, MS_TOPP_software},
    {MS_TOPP_PrecursorMassCorrector, MS_TOPP_software},
    {MS_TOPP_HighResPrecursorMassCorrector, MS_TOPP_software},
    {MS_TOPP_AdditiveSeries, MS_TOPP_software},
    {MS_TOPP_Decharger, MS_TOPP_software},
    {MS_TOPP_EICExtractor, MS_TOPP_software},
    {MS_TOPP_feature_finder, MS_TOPP_software},
    {MS_TOPP_FeatureFinderCentroided, MS_TOPP_feature_finder},
    {MS_TOPP_FeatureFinderRaw, MS_TOPP_feature_finder},
    {MS_TOPP_FeatureFinderIsotopeWavelet, MS_TOPP_feature_finder},
    {MS_TOPP_FeatureFinderMetabo, MS_TOPP_feature_finder},
    {MS_TOPP_FeatureFinderMRM, MS_TOPP_feature_finder},
    {MS_TOPP_ProteinQuantifier, MS_TOPP_software},
    {MS_TOPP_ConsensusMapNormalizer, MS_TOPP_software},
    {MS_TOPP_MapRTTransformer, MS_TOPP_software},
    {MS_TOPP_feature_linker, MS_TOPP_software},
    {MS_TOPP_FeatureLinkerLabeled, MS_TOPP_feature_linker},
    {MS_TOPP_FeatureLinkerUnlabeled, MS_TOPP_feature_linker},
    {MS_TOPP_FeatureLinkerUnlabeledQT, MS_TOPP_feature_linker},
    {MS_TOPP_CompNovo, MS_TOPP_software},
    {MS_TOPP_CompNovoCID, MS_TOPP_software},
    {MS_TOPP_software_adaptor, MS_TOPP_software},
    {MS_TOPP_InspectAdapter, MS_TOPP_software_adaptor},
    {MS_TOPP_MascotAdapter, MS_TOPP_software_adaptor},
    {MS_TOPP_MascotAdapterOnline, MS_TOPP_software_adaptor},
    {MS_TOPP_OMSSAAdapter, MS_TOPP_software_adaptor},
    {MS_TOPP_PepNovoAdapter, MS_TOPP_software_adaptor},
    {MS_TOPP_XTandemAdapter, MS_TOPP_software_adaptor},
    {MS_TOPP_SpecLibSearcher, MS_TOPP_software},
    {MS_TOPP_ConsensusID, MS_TOPP_software},
    {MS_TOPP_IDConflictResolver, MS_TOPP_software},
    {MS_TOPP_IDFilter, MS_TOPP_software},
    {MS_TOPP_IDMapper, MS_TOPP_software},
    {MS_TOPP_IDPosteriorErrorProbability, MS_TOPP_software},
    {MS_TOPP_IDRTCalibration, MS_TOPP_software},
    {MS_TOPP_PeptideIndexer, MS_TOPP_software},
    {MS_TOPP_PrecursorIonSelector, MS_TOPP_software},
    {MS_TOPP_MRMMapper, MS_TOPP_software},
    {MS_TOPP_OpenSwath_component, MS_TOPP_software},
    {MS_TOPP_OpenSwathAnalyzer, MS_TOPP_OpenSwath_component},
    {MS_TOPP_OpenSwathChromatogramExtractor, MS_TOPP_OpenSwath_component},
    {MS_TOPP_OpenSwathDecoyGenerator, MS_TOPP_OpenSwath_component},
    {MS_TOPP_OpenSwathFeatureXMLToTSV, MS_TOPP_OpenSwath_component},
    {MS_TOPP_OpenSwathRTNormalizer, MS_TOPP_OpenSwath_component},
    {MS_TOPP_ProteinInference, MS_TOPP_software},
    {MS_TOPP_FalseDiscoveryRate, MS_TOPP_software},
    {MS_ProteoWizard_msconvert, MS_ProteoWizard_software},
    {MS_ProteoWizard_idconvert, MS_ProteoWizard_software},
    {MS_ProteoWizard_chainsaw, MS_ProteoWizard_software},
    {MS_ProteoWizard_msaccess, MS_ProteoWizard_software},
    {MS_ProteoWizard_SeeMS, MS_ProteoWizard_software},
    {MS_IsobariQ, MS_quantitation_software_name},
    {MS_IsobariQ, MS_analysis_software},
    {MS_Variance_stabilizing_normalization, MS_quantification_data_processing},
    {MS_IPTL_quantitation_analysis, MS_isobaric_label_quantitation_analysis},
    {MS_PAnalyzer_conclusive_protein, MS_protein_inference_confidence_category},
    {MS_PAnalyzer_indistinguishable_protein, MS_protein_inference_confidence_category},
    {MS_PAnalyzer_non_conclusive_protein, MS_protein_inference_confidence_category},
    {MS_PAnalyzer_ambiguous_group_member, MS_protein_inference_confidence_category},
    {MS_decoy_peptide, MS_peptide_sequence_level_identification_attribute},
    {MS_percent_collision_energy_ramp_start, MS_normalized_collision_energy},
    {MS_percent_collision_energy_ramp_end, MS_normalized_collision_energy},
    {MS_MRMaid, MS_SRM_software},
    {MS_MRMaid_peptide_score, MS_peptide_sequence_level_identification_attribute},
    {MS_MRMaid_peptide_score, MS_search_engine_specific_score_for_proteins},
    {MS_SRM_transition_attribute, MS_ion_selection_attribute},
    {MS_precursor_ion_detection_probability, MS_SRM_transition_attribute},
    {MS_product_ion_detection_probability, MS_SRM_transition_attribute},
    {MS_average_product_ion_intensity, MS_product_ion_intensity},
    {MS_product_ion_intensity_standard_deviation, MS_product_ion_intensity},
    {MS_number_of_product_ion_observations, MS_SRM_transition_attribute},
    {MS_number_of_precursor_ion_observations, MS_SRM_transition_attribute},
    {MS_ProteomeDiscoverer_Mascot_Significance_Middle, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Mascot_Significance_High, MS_ProteomeDiscoverer_input_parameter},
    {MS_regular_expressions_for_a_GUID, MS_regular_expression},
    {MS_ProteomeDiscoverer_Default_FDR_calculator, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_SEQUEST_Low_resolution_spectra_contained, MS_ProteomeDiscoverer_input_parameter},
    {MS_selected_precursor_m_z, MS_ion_selection_attribute},
    {MS_ProteoGrouper_PDH_score, MS_search_engine_specific_score_for_proteins},
    {MS_ProteoGrouper_PAG_score, MS_search_engine_specific_score_for_protein_groups},
    {MS_mzidLib, MS_analysis_software},
    {MS_mzidLib_Omssa2Mzid, MS_mzidLib},
    {MS_mzidLib_Tandem2Mzid, MS_mzidLib},
    {MS_mzidLib_Csv2Mzid, MS_mzidLib},
    {MS_mzidLib_ProteoGrouper, MS_mzidLib},
    {MS_mzidLib_Thresholder, MS_mzidLib},
    {MS_mzidLib_Perform_emPAI_on_mzid, MS_mzidLib},
    {MS_mzidLib_FalseDiscoveryRate, MS_mzidLib},
    {MS_mzidLib_Mzidentml2Csv, MS_mzidLib},
    {MS_mzidLib_CombineSearchEngines, MS_mzidLib},
    {MS_mzidLib_InsertMetaDataFromFasta, MS_mzidLib},
    {MS_SEQUEST_spscore, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_sprank, MS_PSM_level_search_engine_specific_statistic},
    {MS_SEQUEST_deltacnstar, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet, MS_analysis_software},
    {MS_Comet_xcorr, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet_deltacn, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet_deltacnstar, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet_spscore, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet_sprank, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet_expectation_value, MS_search_engine_specific_score},
    {MS_Comet_matched_ions, MS_PSM_level_search_engine_specific_statistic},
    {MS_Comet_total_ions, MS_PSM_level_search_engine_specific_statistic},
    {MS_PSM_FDR_threshold, MS_PSM_level_statistical_threshold},
    {MS_Byonic, MS_analysis_software},
    {MS_Byonic_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_Byonic_Delta_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_Byonic_DeltaMod_Score, MS_PSM_level_search_engine_specific_statistic},
    {MS_Byonic_PEP, MS_PSM_level_search_engine_specific_statistic},
    {MS_Byonic_Peptide_LogProb, MS_PSM_level_search_engine_specific_statistic},
    {MS_Byonic_Protein_LogProb, MS_search_engine_specific_score_for_proteins},
    {MS_Byonic_Protein_LogProb, MS_search_engine_specific_score_for_proteins},
    {MS_Byonic_Best_LogProb, MS_single_protein_identification_statistic},
    {MS_Byonic_Best_LogProb, MS_search_engine_specific_score},
    {MS_Byonic_Best_Score, MS_search_engine_specific_score_for_proteins},
    {MS_chromatography_separation, MS_run_attribute},
    {MS_liquid_chromatography_separation, MS_chromatography_separation},
    {MS_gas_chromatography_separation, MS_chromatography_separation},
    {MS_detector_potential, MS_detector_attribute},
    {MS_SQ_Detector_2, MS_Waters_instrument_model},
    {MS_Xevo_G2_S_Tof, MS_Waters_instrument_model},
    {MS_Xevo_G2_S_QTof, MS_Waters_instrument_model},
    {MS_AutoSpec_Premier, MS_Waters_instrument_model},
    {MS_Pegasus_III, MS_LECO_instrument_model},
    {MS_maXis_4G, MS_Bruker_Daltonics_maXis_series},
    {MS_compact, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_SRM_feature_level_quantitation, MS_SRM_quantitation_analysis},
    {MS_SRM_peptide_level_quantitation, MS_SRM_quantitation_analysis},
    {MS_SRM_protein_level_quantitation, MS_SRM_quantitation_analysis},
    {MS_SRM_proteingroup_level_quantitation, MS_SRM_quantitation_analysis},
    {MS_Trans_Proteomic_Pipeline, MS_analysis_software},
    {MS_Trans_Proteomic_Pipeline_software, MS_analysis_software},
    {MS_PeptideProphet, MS_Trans_Proteomic_Pipeline_software},
    {MS_iProphet, MS_Trans_Proteomic_Pipeline_software},
    {MS_ProteinProphet, MS_Trans_Proteomic_Pipeline_software},
    {MS_XPRESS, MS_Trans_Proteomic_Pipeline_software},
    {MS_Libra, MS_Trans_Proteomic_Pipeline_software},
    {MS_PTMProphet, MS_Trans_Proteomic_Pipeline_software},
    {MS_Bruker_Daltonics_SCION_series, MS_Bruker_Daltonics_instrument_model},
    {MS_Bruker_Daltonics_EVOQ_series, MS_Bruker_Daltonics_instrument_model},
    {MS_SCION_SQ, MS_Bruker_Daltonics_SCION_series},
    {MS_SCION_TQ, MS_Bruker_Daltonics_SCION_series},
    {MS_EVOQ_Elite, MS_Bruker_Daltonics_EVOQ_series},
    {MS_EVOQ_Qube, MS_Bruker_Daltonics_EVOQ_series},
    {MS_micrOTOF_Q_III, MS_Bruker_Daltonics_micrOTOF_series},
    {MS_amaZon_Speed_ETD, MS_Bruker_Daltonics_amaZon_series},
    {MS_amaZon_Speed, MS_Bruker_Daltonics_amaZon_series},
    {MS_Bruker_Container_format, MS_mass_spectrometer_file_format},
    {MS_Bruker_Container_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_value_between_0_and_1_inclusive, MS_domain_range},
    {MS_value_greater_than_zero, MS_domain_range},
    {MS_fragmentation_ion_type, MS_product_ion_attribute},
    {MS_fluorescence_detector, MS_detector_type},
    {MS_Byonic__Peptide_AbsLogProb, MS_PSM_level_search_engine_specific_statistic},
    {MS_Byonic__Protein_AbsLogProb, MS_search_engine_specific_score_for_proteins},
    {MS_Byonic__Peptide_AbsLogProb2D, MS_PSM_level_search_engine_specific_statistic},
    {MS_MS_Numpress_linear_prediction_compression, MS_binary_data_compression_type},
    {MS_MS_Numpress_positive_integer_compression, MS_binary_data_compression_type},
    {MS_MS_Numpress_short_logged_float_compression, MS_binary_data_compression_type},
    {MS_consensus_result, MS_spectrum_identification_result_details},
    {MS_ProteomeDiscoverer_Amanda_high_confidence_threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Amanda_middle_confidence_threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_automatic_workload, MS_ProteomeDiscoverer_input_parameter},
    {MS_Amanda_AmandaScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProteomeDiscoverer_max_differential_modifications, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_max_equal_modifications, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_min_peptide_length, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_max_peptide_length, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_max_number_neutral_loss, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_max_number_neutral_loss_modifications, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_use_flanking_ions, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_max_number_of_same_modifs, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_perform_deisotoping, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_ion_settings, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_3__Static_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_5__Dynamic_Modification_OBSOLETE, MS_ProteomeDiscoverer_input_parameter},
    {MS_lab_head, MS_contact_role},
    {MS_conversion_software, MS_data_processing_software},
    {MS_ProCon, MS_conversion_software},
    {MS_PRIDE_Converter2, MS_conversion_software},
    {MS_Amanda, MS_analysis_software},
    {MS_Andromeda, MS_analysis_software},
    {MS_Andromeda_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_site_global_FDR, MS_spectrum_identification_result_details},
    {MS_ProteomeXchange_project_tag, MS_external_reference_identifier},
    {MS_second_pass_peptide_identification, MS_peptide_sequence_level_identification_attribute},
    {MS_MZmine, MS_analysis_software},
    {MS_MZmine, MS_data_processing_software},
    {MS_Maltcms, MS_analysis_software},
    {MS_Maltcms, MS_data_processing_software},
    {MS_PSM_level_attribute, MS_single_identification_result_attribute},
    {MS_protein_group_level_identification_attribute, MS_single_identification_result_attribute},
    {MS_PSM_level_identification_statistic, MS_PSM_level_attribute},
    {MS_protein_group_level_identification_statistic, MS_protein_group_level_identification_attribute},
    {MS_value_greater_than_zero_but_less_than_or_equal_to_one, MS_domain_range},
    {MS_PSM_level_global_FDR, MS_PSM_level_result_list_statistic},
    {MS_PSM_level_local_FDR, MS_PSM_level_identification_statistic},
    {MS_PSM_level_p_value, MS_PSM_level_identification_statistic},
    {MS_PSM_level_e_value, MS_PSM_level_identification_statistic},
    {MS_PSM_level_q_value, MS_PSM_level_identification_statistic},
    {MS_PSM_level_FDRScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_PSM_level_FDRScore, MS_search_engine_specific_score_for_proteins},
    {MS_PSM_level_combined_FDRScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_PSM_level_combined_FDRScore, MS_search_engine_specific_score_for_proteins},
    {MS_PSM_level_probability, MS_PSM_level_identification_statistic},
    {MS_search_engine_specific_peptide_sequence_level_identification_statistic, MS_peptide_sequence_level_identification_statistic},
    {MS_peptide_sequence_level_local_FDR, MS_peptide_sequence_level_identification_statistic},
    {MS_distinct_peptide_level_FDRScore, MS_search_engine_specific_peptide_sequence_level_identification_statistic},
    {MS_distinct_peptide_level_FDRScore, MS_search_engine_specific_score_for_proteins},
    {MS_distinct_peptide_level_combined_FDRScore, MS_search_engine_specific_peptide_sequence_level_identification_statistic},
    {MS_distinct_peptide_level_combined_FDRScore, MS_search_engine_specific_score_for_proteins},
    {MS_peptide_sequence_level_probability, MS_peptide_sequence_level_identification_statistic},
    {MS_search_engine_specific_score_for_proteins, MS_single_protein_identification_statistic},
    {MS_protein_level_local_FDR, MS_single_protein_identification_statistic},
    {MS_FDRScore_for_proteins, MS_search_engine_specific_score_for_proteins},
    {MS_combined_FDRScore_for_proteins, MS_search_engine_specific_score_for_proteins},
    {MS_probability_for_proteins, MS_single_protein_identification_statistic},
    {MS_search_engine_specific_score_for_protein_groups, MS_protein_group_level_identification_statistic},
    {MS_protein_group_level_global_FDR, MS_protein_group_level_result_list_statistic},
    {MS_protein_group_level_local_FDR, MS_protein_group_level_identification_statistic},
    {MS_protein_group_level_p_value, MS_protein_group_level_identification_statistic},
    {MS_protein_group_level_e_value, MS_protein_group_level_identification_statistic},
    {MS_protein_group_level_q_value, MS_protein_group_level_identification_statistic},
    {MS_protein_group_level_FDRScore, MS_search_engine_specific_score_for_protein_groups},
    {MS_protein_group_level_combined_FDRScore, MS_search_engine_specific_score_for_protein_groups},
    {MS_protein_group_level_probability, MS_protein_group_level_identification_statistic},
    {MS_ProteomeDiscoverer_Relaxed_Score_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Strict_Score_Threshold, MS_ProteomeDiscoverer_input_parameter},
    {MS_ProteomeDiscoverer_Peptide_Without_Protein_Cut_Off_Score, MS_ProteomeDiscoverer_input_parameter},
    {MS_false_localization_rate, MS_spectrum_identification_result_details},
    {MS_MALDI_Solutions_LC_MALDI, MS_acquisition_software},
    {MS_MALDI_Solutions_LC_MALDI, MS_analysis_software},
    {MS_MALDI_Solutions_LC_MALDI, MS_data_processing_software},
    {MS_MALDI_Solutions_LC_MALDI, MS_Shimadzu_Corporation_software},
    {MS_Shimadzu_MALDI_7090, MS_Shimadzu_MALDI_TOF_instrument_model},
    {MS_SCiLS_software, MS_software},
    {MS_SCiLS_Lab, MS_SCiLS_software},
    {MS_SCiLS_Lab, MS_analysis_software},
    {MS_SCiLS_Lab, MS_data_processing_software},
    {MS_SCiLS_Lab_format, MS_mass_spectrometer_file_format},
    {MS_preprocessing_software, MS_data_processing_software},
    {MS_PIA, MS_postprocessing_software},
    {MS_PIA, MS_analysis_software},
    {MS_PIA_XML_format, MS_intermediate_analysis_format},
    {MS_PIA_workflow_parameter, MS_software_specific_input_parameter},
    {MS_PIA_workflow_parameter, MS_search_engine_specific_input_parameter},
    {MS_PIA_FDRScore_calculated, MS_PIA_workflow_parameter},
    {MS_PIA_Combined_FDRScore_calculated, MS_PIA_workflow_parameter},
    {MS_PIA_PSM_sets_created, MS_PIA_workflow_parameter},
    {MS_PIA_used_top_identifications_for_FDR, MS_PIA_workflow_parameter},
    {MS_PIA_protein_score, MS_search_engine_specific_score_for_proteins},
    {MS_PIA_protein_inference, MS_PIA_workflow_parameter},
    {MS_PIA_protein_inference_filter, MS_PIA_workflow_parameter},
    {MS_PIA_protein_inference_scoring, MS_PIA_workflow_parameter},
    {MS_PIA_protein_inference_used_score, MS_PIA_workflow_parameter},
    {MS_PIA_protein_inference_used_PSMs, MS_PIA_workflow_parameter},
    {MS_PIA_filter, MS_PIA_workflow_parameter},
    {MS_leading_protein, MS_protein_group_or_subset_relationship},
    {MS_non_leading_protein, MS_protein_group_or_subset_relationship},
    {MS_group_representative, MS_protein_group_or_subset_relationship},
    {MS_count_of_identified_proteins, MS_protein_level_result_list_attribute},
    {MS_count_of_identified_proteins, MS_single_value},
    {MS_protein_group_level_result_list_attribute, MS_result_list_attribute},
    {MS_count_of_identified_clusters, MS_protein_group_level_result_list_attribute},
    {MS_cluster_identifier, MS_protein_cluster_identification_attribute},
    {MS_number_of_distinct_protein_sequences, MS_protein_group_level_result_list_attribute},
    {MS_marginally_distinguished_protein, MS_protein_group_or_subset_relationship},
    {MS_Anubis, MS_SRM_software},
    {MS_Anubis, MS_quantitation_software_name},
    {MS_TraML_format, MS_method_file_format},
    {MS_total_XIC_area, MS_peptide_level_quantification_datatype},
    {MS_product_background, MS_quantification_datatype},
    {MS_postprocessing_software, MS_data_processing_software},
    {MS_protein_group_passes_threshold, MS_protein_group_level_identification_attribute},
    {MS_Orbitrap_Fusion, MS_Thermo_Scientific_instrument_model},
    {MS_Orbitrap_Fusion_ETD, MS_Thermo_Scientific_instrument_model},
    {MS_TSQ_Quantiva, MS_Thermo_Scientific_instrument_model},
    {MS_TSQ_Endura, MS_Thermo_Scientific_instrument_model},
    {MS_PASSEL_experiment_URI, MS_external_reference_identifier},
    {MS_Paragon_input_parameter, MS_search_engine_specific_input_parameter},
    {MS_Paragon__sample_type, MS_Paragon_input_parameter},
    {MS_Paragon__cysteine_alkylation, MS_Paragon_input_parameter},
    {MS_Paragon__instrument_setting, MS_Paragon_input_parameter},
    {MS_Paragon__search_effort, MS_Paragon_input_parameter},
    {MS_Paragon__ID_focus, MS_Paragon_input_parameter},
    {MS_Paragon__FDR_analysis, MS_Paragon_input_parameter},
    {MS_Paragon__quantitation, MS_Paragon_input_parameter},
    {MS_Paragon__background_correction, MS_Paragon_input_parameter},
    {MS_Paragon__bias_correction, MS_Paragon_input_parameter},
    {MS_Paragon__channel_to_use_as_denominator_in_ratios, MS_Paragon_input_parameter},
    {MS_search_engine_specific_input_metadata, MS_search_input_details},
    {MS_Paragon__modified_data_dictionary_or_parameter_translation, MS_search_engine_specific_input_metadata},
    {MS_number_of_spectra_searched, MS_search_input_details},
    {MS_data_processing_start_time, MS_data_processing_parameter},
    {MS_Paragon__digestion, MS_search_input_details},
    {MS_number_of_decoy_sequences, MS_search_database_details},
    {MS_final_PSM_list, MS_spectrum_identification_list_result_details},
    {MS_intermediate_PSM_list, MS_spectrum_identification_list_result_details},
    {MS_Andi_MS_format, MS_mass_spectrometer_file_format},
    {MS_chromatograph_file_format, MS_file_format},
    {MS_Andi_CHROM_format, MS_chromatograph_file_format},
    {MS_6420_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6460_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_6490_Triple_Quadrupole_LC_MS, MS_Agilent_instrument_model},
    {MS_Paragon_special_factor, MS_Paragon_input_parameter},
    {MS_PEAKS_inChorusPeptideScore, MS_PSM_level_search_engine_specific_statistic},
    {MS_PEAKS_inChorusProteinScore, MS_search_engine_specific_score_for_proteins},
    {MS_param__b_ion_H3PO4_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_param__y_ion_H3PO4_DEPRECATED, MS_ions_series_considered_in_search},
    {MS_Maui, MS_analysis_software},
    {MS_Maui, MS_data_processing_software},
    {MS_No_fixed_modifications_searched, MS_common_search_engine_input_parameter},
    {MS_No_variable_modifications_searched, MS_common_search_engine_input_parameter},
    {MS_H2O_neutral_loss_OBSOLETE, MS_neutral_loss},
    {MS_H2O_neutral_loss_OBSOLETE, MS_ion_series_considered_in_search},
    {MS_NH3_neutral_loss_OBSOLETE, MS_neutral_loss},
    {MS_NH3_neutral_loss_OBSOLETE, MS_ion_series_considered_in_search},
    {MS_H3PO4_neutral_loss_OBSOLETE, MS_neutral_loss},
    {MS_H3PO4_neutral_loss_OBSOLETE, MS_ion_series_considered_in_search},
    {MS_PeptideShaker, MS_analysis_software},
    {MS_MS_Amanda_csv_format, MS_intermediate_analysis_format},
    {MS_protein_group_level_global_FNR, MS_protein_group_level_result_list_statistic},
    {MS_protein_group_level_confidence, MS_protein_group_level_identification_statistic},
    {MS_peptide_sequence_level_global_FNR, MS_peptide_sequence_level_result_list_statistic},
    {MS_peptide_sequence_level_global_confidence, MS_peptide_sequence_level_result_list_statistic},
    {MS_PSM_level_global_FNR, MS_PSM_level_result_list_statistic},
    {MS_PSM_level_global_confidence, MS_PSM_level_result_list_statistic},
    {MS_PeptideShaker_PSM_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_PeptideShaker_PSM_confidence, MS_PSM_level_search_engine_specific_statistic},
    {MS_PeptideShaker_peptide_score, MS_search_engine_specific_peptide_sequence_level_identification_statistic},
    {MS_PeptideShaker_peptide_score, MS_search_engine_specific_score_for_proteins},
    {MS_PeptideShaker_peptide_confidence, MS_search_engine_specific_score_for_proteins},
    {MS_PeptideShaker_protein_group_score, MS_search_engine_specific_score_for_proteins},
    {MS_PeptideShaker_protein_group_score, MS_search_engine_specific_score_for_protein_groups},
    {MS_PeptideShaker_protein_group_confidence, MS_search_engine_specific_score_for_proteins},
    {MS_trap_type_collision_induced_dissociation, MS_collision_induced_dissociation},
    {MS_ion_series_considered_in_search, MS_search_input_details},
    {MS_ProteoAnnotator_non_canonical_gene_model_score, MS_search_engine_specific_score_for_protein_groups},
    {MS_ProteoAnnotator_count_alternative_peptides, MS_search_engine_specific_score_for_protein_groups},
    {MS_ion_mobility_drift_time, MS_ion_selection_attribute},
    {MS_ion_mobility_drift_time, MS_ion_mobility_attribute},
    {MS_ion_mobility_drift_time, MS_peak_attribute},
    {MS_mean_ion_mobility_drift_time_array, MS_ion_mobility_array},
    {MS_mean_charge_array, MS_binary_data_array},
    {MS_regular_expression_for_a_digital_object_identifier__DOI_, MS_regular_expression},
    {MS_higher_energy_beam_type_collision_induced_dissociation, MS_beam_type_collision_induced_dissociation},
    {MS_statistical_threshold, MS_quality_estimation_method_details},
    {MS_PSM_level_statistical_threshold, MS_spectrum_identification_statistical_threshold},
    {MS_peptide_level_statistical_threshold, MS_spectrum_identification_statistical_threshold},
    {MS_protein_level_statistical_threshold, MS_protein_detection_statistical_threshold},
    {MS_protein_group_level_statistical_threshold, MS_protein_detection_statistical_threshold},
    {MS_MassIVE_dataset_identifier, MS_external_reference_identifier},
    {MS_MassIVE_dataset_URI, MS_external_reference_identifier},
    {MS_special_processing, MS_search_type},
    {MS_peptide_level_scoring, MS_special_processing},
    {MS_modification_localization_scoring, MS_special_processing},
    {MS_consensus_scoring, MS_special_processing},
    {MS_sample_pre_fractionation, MS_special_processing},
    {MS_crosslinking_search, MS_special_processing},
    {MS_no_special_processing, MS_special_processing},
    {MS_group_PSMs_by_sequence, MS_identification_parameter},
    {MS_group_PSMs_by_sequence_with_modifications, MS_identification_parameter},
    {MS_group_PSMs_by_sequence_with_modifications_and_charge, MS_identification_parameter},
    {MS_peptide_level_score_OBSOLETE, MS_search_engine_specific_peptide_sequence_level_identification_statistic},
    {MS_peptide_passes_threshold, MS_peptide_sequence_level_identification_attribute},
    {MS_no_PSM_threshold, MS_PSM_level_result_list_statistic},
    {MS_no_peptide_level_threshold, MS_peptide_sequence_level_identification_attribute},
    {MS_PSM_is_used_for_peptide_level_scoring, MS_peptide_sequence_level_identification_attribute},
    {MS_modification_index, MS_modification_parameters},
    {MS_regular_expression_for_modification_localization_scoring, MS_regular_expression},
    {MS_modification_position_score, MS_modification_parameters},
    {MS_modification_rescoring_false_localization_rate, MS_modification_position_score},
    {MS_crosslinking_attribute, MS_single_identification_result_attribute},
    {MS_crosslink_donor, MS_crosslinking_attribute},
    {MS_crosslink_acceptor, MS_crosslinking_attribute},
    {MS_crosslink_spectrum_identification_item, MS_crosslinking_attribute},
    {MS_crosslinking_score, MS_search_engine_specific_score_for_proteins},
    {MS_molecules_per_cell, MS_quantification_datatype},
    {MS_absolute_quantitation_analysis, MS_quantitation_analysis_summary},
    {MS_internal_peptide_reference_used, MS_quantitation_software_comment_or_customizations},
    {MS_internal_protein_reference_used, MS_quantitation_software_comment_or_customizations},
    {MS_internal_reference_abundance, MS_quantification_datatype},
    {MS_Progenesis_protein_group_normalised_abundance, MS_protein_group_level_quantification_datatype},
    {MS_Progenesis_protein_group_raw_abundance, MS_protein_group_level_quantification_datatype},
    {MS_peptide_group_ID, MS_peptide_sequence_level_identification_attribute},
    {MS_mass_spectrometry_imaging, MS_run_attribute},
    {MS_ProteomeDiscoverer_1__Static_Terminal_Modification, MS_ProteomeDiscoverer_input_parameter},
    {MS_Q_Exactive_HF, MS_Thermo_Scientific_instrument_model},
    {MS_PepFinder, MS_data_processing_software},
    {MS_TSQ_8000_Evo, MS_Thermo_Scientific_instrument_model},
    {MS_Exactive_Plus, MS_Thermo_Scientific_instrument_model},
    {MS_instrument_specific_scan_attribute, MS_scan_attribute},
    {MS_synchronous_prefilter_selection, MS_instrument_specific_scan_attribute},
    {MS_resolution_array, MS_binary_data_array},
    {MS_baseline_array, MS_binary_data_array},
    {MS_UIMF_format, MS_mass_spectrometer_file_format},
    {MS_UIMF_nativeID_format, MS_native_spectrum_identifier_format},
    {MS_TripleTOF_6600, MS_SCIEX_instrument_model},
    {MS_ProLuCID_xcorr, MS_PSM_level_search_engine_specific_statistic},
    {MS_ProLuCID_deltacn, MS_PSM_level_search_engine_specific_statistic},
    {MS_D_Score, MS_PTM_localization_PSM_level_statistic},
    {MS_MD_Score, MS_PTM_localization_PSM_level_statistic},
    {MS_PTM_localization_confidence_metric, MS_spectrum_identification_result_details},
    {MS_PeptideShaker_PTM_confidence_type, MS_PTM_localization_confidence_metric},
    {MS_PeptideShaker_PSM_confidence_type, MS_PSM_level_identification_statistic},
    {MS_PeptideShaker_peptide_confidence_type, MS_search_engine_specific_peptide_sequence_level_identification_statistic},
    {MS_PeptideShaker_protein_confidence_type, MS_single_protein_identification_statistic},
    {MS_xiFDR, MS_analysis_software},
    {MS_xi, MS_analysis_software},
    {MS_xi_score, MS_PSM_level_search_engine_specific_statistic},
    {MS_Skyline_mzQuantML_converter, MS_quantitation_software_name},
    {MS_Skyline_mzQuantML_converter, MS_analysis_software},
    {MS_normalized_spectral_abundance_factor, MS_quantification_datatype},
    {MS_distributed_normalized_spectral_abundance_factor, MS_quantification_datatype},
    {MS_PTM_localization_distinct_peptide_level_statistic, MS_PTM_localization_single_result_statistic},
    {MS_peptide_phosphoRS_score, MS_PTM_localization_distinct_peptide_level_statistic},
    {MS_peptide_Ascore, MS_PTM_localization_distinct_peptide_level_statistic},
    {MS_peptide_H_Score, MS_PTM_localization_distinct_peptide_level_statistic},
    {MS_peptide_D_Score, MS_PTM_localization_distinct_peptide_level_statistic},
    {MS_peptide_MD_Score, MS_PTM_localization_distinct_peptide_level_statistic},
    {MS_PTM_localization_sc