#
# @file    TestSpeciesReference.py
# @brief   SpeciesReference unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSpeciesReference.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestSpeciesReference(unittest.TestCase):

  global SR
  SR = None

  def setUp(self):
    self.SR = libsbml.SpeciesReference(2,4)
    if (self.SR == None):
      pass    
    pass  

  def tearDown(self):
    _dummyList = [ self.SR ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SpeciesReference_create(self):
    self.assertTrue( self.SR.getTypeCode() == libsbml.SBML_SPECIES_REFERENCE )
    self.assertTrue( self.SR.getMetaId() == "" )
    self.assertTrue( self.SR.getNotes() == None )
    self.assertTrue( self.SR.getAnnotation() == None )
    self.assertTrue( self.SR.getSpecies() == "" )
    self.assertTrue( self.SR.getStoichiometry() == 1 )
    self.assertTrue( self.SR.getStoichiometryMath() == None )
    self.assertTrue( self.SR.getDenominator() == 1 )
    self.assertEqual( False, self.SR.isSetSpecies() )
    self.assertEqual( False, self.SR.isSetStoichiometryMath() )
    pass  

  def test_SpeciesReference_createWithNS(self):
    xmlns = libsbml.XMLNamespaces()
    xmlns.add( "http://www.sbml.org", "testsbml")
    sbmlns = libsbml.SBMLNamespaces(2,1)
    sbmlns.addNamespaces(xmlns)
    object = libsbml.SpeciesReference(sbmlns)
    self.assertTrue( object.getTypeCode() == libsbml.SBML_SPECIES_REFERENCE )
    self.assertTrue( object.getMetaId() == "" )
    self.assertTrue( object.getNotes() == None )
    self.assertTrue( object.getAnnotation() == None )
    self.assertTrue( object.getLevel() == 2 )
    self.assertTrue( object.getVersion() == 1 )
    self.assertTrue( object.getNamespaces() != None )
    self.assertTrue( object.getNamespaces().getLength() == 2 )
    _dummyList = [ object ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SpeciesReference_free_NULL(self):
    _dummyList = [ None ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SpeciesReference_setId(self):
    species =  "X0";
    self.SR.setId(species)
    self.assertTrue(( species == self.SR.getId() ))
    self.assertEqual( True, self.SR.isSetId() )
    if (self.SR.getId() == species):
      pass    
    self.SR.setId(self.SR.getId())
    self.assertTrue(( species == self.SR.getId() ))
    self.SR.setId("")
    self.assertEqual( False, self.SR.isSetId() )
    if (self.SR.getId() != None):
      pass    
    pass  

  def test_SpeciesReference_setSpecies(self):
    species =  "X0";
    self.SR.setSpecies(species)
    self.assertTrue(( species == self.SR.getSpecies() ))
    self.assertEqual( True, self.SR.isSetSpecies() )
    if (self.SR.getSpecies() == species):
      pass    
    self.SR.setSpecies(self.SR.getSpecies())
    self.assertTrue(( species == self.SR.getSpecies() ))
    self.SR.setSpecies("")
    self.assertEqual( False, self.SR.isSetSpecies() )
    if (self.SR.getSpecies() != None):
      pass    
    pass  

  def test_SpeciesReference_setStoichiometryMath(self):
    math = libsbml.parseFormula("k3 / k2")
    stoich = libsbml.StoichiometryMath(2,4)
    stoich.setMath(math)
    self.SR.setStoichiometryMath(stoich)
    math1 = self.SR.getStoichiometryMath()
    self.assertTrue( math1 != None )
    formula = libsbml.formulaToString(math1.getMath())
    self.assertTrue( formula != None )
    self.assertTrue((  "k3 / k2" == formula ))
    self.assertEqual( True, self.SR.isSetStoichiometryMath() )
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestSpeciesReference))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
