// Geometric Tools, LLC
// Copyright (c) 1998-2014
// Distributed under the Boost Software License, Version 1.0.
// http://www.boost.org/LICENSE_1_0.txt
// http://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
//
// File Version: 5.0.2 (2013/07/28)

#ifndef WM5DISTPOINT3CIRCLE3_H
#define WM5DISTPOINT3CIRCLE3_H

#include "Wm5MathematicsLIB.h"
#include "Wm5Distance.h"
#include "Wm5Circle3.h"

namespace Wm5
{

template <typename Real>
class WM5_MATHEMATICS_ITEM DistPoint3Circle3
    : public Distance<Real,Vector3<Real> >
{
public:
    DistPoint3Circle3 (const Vector3<Real>& point,
        const Circle3<Real>& circle);

    // Object access.
    const Vector3<Real>& GetPoint () const;
    const Circle3<Real>& GetCircle () const;

    // Static distance queries.  Compute the distance from the point P to the
    // circle.  When P is on the normal line C+t*N where C is the circle
    // center and N is the normal to the plane containing the circle, then
    // all circle points are equidistant from P.  In this case the returned
    // point is C+r*U, where U is a vector perpendicular to N.
    virtual Real Get ();
    virtual Real GetSquared ();

    // Function calculations for dynamic distance queries.
    virtual Real Get (Real t, const Vector3<Real>& velocity0,
        const Vector3<Real>& velocity1);
    virtual Real GetSquared (Real t, const Vector3<Real>& velocity0,
        const Vector3<Real>& velocity1);

private:
    using Distance<Real,Vector3<Real> >::mClosestPoint0;
    using Distance<Real,Vector3<Real> >::mClosestPoint1;
    using Distance<Real,Vector3<Real> >::mHasMultipleClosestPoints0;
    using Distance<Real,Vector3<Real> >::mHasMultipleClosestPoints1;

    const Vector3<Real>* mPoint;
    const Circle3<Real>* mCircle;
};

typedef DistPoint3Circle3<float> DistPoint3Circle3f;
typedef DistPoint3Circle3<double> DistPoint3Circle3d;

}

#endif
