.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbAllocKeyboard __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocKeyboard \-  Creates a keyboard description from scratch
.SH SYNOPSIS
.HP
.B XkbDescRec XkbAllocKeyboard
.BI "(\^void\^);"
.if n .ti +5n
.if t .ti +.5i
.SH DESCRIPTION
.LP
Applications seldom need to directly allocate a keyboard description; calling
.I XkbGetKeyboard
usually suffices. In the event you need to create a keyboard description from
scratch, however, use
.I XkbAllocKeyboard
rather than directly calling
.I malloc.

If
.I XkbAllocKeyboard
fails to allocate the keyboard description, it returns NULL.
Otherwise, it returns a pointer to an empty keyboard description structure. The
.I device_spec
field will have been initialized to XkbUseCoreKbd. You may then
either fill in the structure components or use Xkb functions to obtain values
for the structure components from a keyboard device.
.SH "SEE ALSO"
.BR malloc (3F),
.BR XkbUseCoreKbd (__libmansuffix__),
.BR XkbGetKeyboard (__libmansuffix__)


