// EShellProcess.h
#ifndef ESHELLPROCESS_H_INCLUDED
#define ESHELLPROCESS_H_INCLUDED
#include <string>
#include <iostream>

using std::string;
/**
   License: See LICENSE file in this directory.
   Author: stephan@wanderinghorse.net
*/
class EShellProcess 
{
public:
        /**
           For running shell processes. Note that the
           functions DO NOT follow the conventions set forth
           by EArgsProcessor: they do not treat argument 0
           specially.
        */
        EShellProcess(){};
        ~EShellProcess() {};

        /**
           Runs the given command line using popen() and
           returns 0 on success, or non-zero on failure.  All
           output generated by the process (to stdout or
           stderr) will be sent, character by character, to
           the given outstream.
        */
        int pipe( const std::string &, std::ostream & os );
        /**
           calls fork()/exec().
           Largely untested.

           A serious limitation: input string may have no more
           than some arbitrary number of tokens (as counted by
           EStdStringTokenizer::tokenize()).
        */
        int fork( const std::string &, std::ostream & os );
        /**
           calls ::system(). Note that os is ignored, but
           provided for API compatibility. It may be used in
           some way in the future.
        */
        int system( const std::string &, std::ostream & os = std::cout );

private:
        EShellProcess( const EShellProcess & );
        EShellProcess & operator=( const EShellProcess & );
        void init(){};
};
#endif // ESHELLPROCESS_H_INCLUDED
