/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Comparator;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class KeySearch {
    private static final int POSITION_MASK = 0x3FFFFFFF;
    private static final int HIT_FLAG = Integer.MIN_VALUE;
    private static final int NO_HIT_FLAG = 0;
    private static final int HIT_MASK = Integer.MIN_VALUE;
    private static final int SUCCESS_FLAG = 0;
    private static final int NO_SUCCESS_FLAG = 0x40000000;
    private static final int SUCCESS_MASK = 0x40000000;

    private KeySearch() {
    }

    static <KEY, VALUE> int search(PageCursor cursor, TreeNode<KEY, VALUE> bTreeNode, TreeNode.Type type, KEY key, KEY readKey, int keyCount, CursorContext cursorContext) {
        int pos;
        if (keyCount == 0) {
            return KeySearch.searchResult(0, false);
        }
        int lower = 0;
        int higher = keyCount - 1;
        boolean hit = false;
        Comparator<KEY> comparator = bTreeNode.keyComparator();
        if (comparator.compare(key, bTreeNode.keyAt(cursor, readKey, higher, type, cursorContext)) > 0) {
            pos = keyCount;
        } else {
            int comparison = comparator.compare(key, bTreeNode.keyAt(cursor, readKey, lower, type, cursorContext));
            if (comparison <= 0) {
                if (comparison == 0) {
                    hit = true;
                }
                pos = 0;
            } else {
                while (lower < higher) {
                    pos = (lower + higher) / 2;
                    comparison = comparator.compare(key, bTreeNode.keyAt(cursor, readKey, pos, type, cursorContext));
                    if (comparison <= 0) {
                        higher = pos;
                        continue;
                    }
                    lower = pos + 1;
                }
                if (lower != higher) {
                    return 0x40000000;
                }
                pos = lower;
                hit = comparator.compare(key, bTreeNode.keyAt(cursor, readKey, pos, type, cursorContext)) == 0;
            }
        }
        return KeySearch.searchResult(pos, hit);
    }

    private static int searchResult(int pos, boolean hit) {
        return pos & 0x3FFFFFFF | (hit ? Integer.MIN_VALUE : 0);
    }

    static int positionOf(int searchResult) {
        return searchResult & 0x3FFFFFFF;
    }

    static int childPositionOf(int searchResult) {
        int pos = KeySearch.positionOf(searchResult);
        if (KeySearch.isHit(searchResult)) {
            return pos + 1;
        }
        return pos;
    }

    static boolean isHit(int searchResult) {
        return (searchResult & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    static boolean isSuccess(int searchResult) {
        return (searchResult & 0x40000000) == 0;
    }

    static void assertSuccess(int searchResult) {
        if (!KeySearch.isSuccess(searchResult)) {
            throw new TreeInconsistencyException("Search terminated in unexpected way", new Object[0]);
        }
    }
}

