/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.common.ProgressReporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.counts.GBPTreeRelationshipGroupDegreesStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.io.IOUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.monitoring.LogProgressReporter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipDirection;

public class DegreesRebuildFromStore
implements GBPTreeRelationshipGroupDegreesStore.DegreesRebuilder {
    private final PageCache pageCache;
    private final NeoStores neoStores;
    private final DatabaseLayout databaseLayout;
    private final PageCacheTracer pageCacheTracer;
    private final Log log;
    private final Configuration processingConfig;

    public DegreesRebuildFromStore(PageCache pageCache, NeoStores neoStores, DatabaseLayout databaseLayout, PageCacheTracer pageCacheTracer, LogProvider logProvider, Configuration processingConfig) {
        this.pageCache = pageCache;
        this.neoStores = neoStores;
        this.databaseLayout = databaseLayout;
        this.pageCacheTracer = pageCacheTracer;
        this.log = logProvider.getLog(DegreesRebuildFromStore.class);
        this.processingConfig = processingConfig;
    }

    @Override
    public long lastCommittedTxId() {
        return this.neoStores.getMetaDataStore().getLastCommittedTransactionId();
    }

    @Override
    public void rebuild(RelationshipGroupDegreesStore.Updater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
        this.log.warn("Missing relationship degrees store, rebuilding it.");
        NumberArrayFactory numberArrayFactory = NumberArrayFactories.auto((PageCache)this.pageCache, (PageCacheTracer)this.pageCacheTracer, (Path)this.databaseLayout.databaseDirectory(), (boolean)true, (NumberArrayFactory.Monitor)NumberArrayFactories.NO_MONITOR, (Log)NullLog.getInstance(), (String)this.databaseLayout.getDatabaseName());
        try (GroupDegreesCache cache = new GroupDegreesCache(numberArrayFactory, this.neoStores.getNodeStore().getHighId(), memoryTracker);){
            LogProgressReporter progress = new LogProgressReporter(this.log);
            progress.start(this.neoStores.getRelationshipGroupStore().getHighId() + this.neoStores.getRelationshipStore().getHighId());
            ExecutionSupervisors.superviseDynamicExecution((Stage)new PrepareCacheStage(this.processingConfig, this.neoStores.getRelationshipGroupStore(), cache, this.pageCacheTracer, progress));
            if (cache.hasAnyGroup()) {
                ExecutionSupervisors.superviseDynamicExecution((Stage)new CalculateDegreesStage(this.processingConfig, this.neoStores.getRelationshipStore(), cache, this.pageCacheTracer, progress));
            }
            cache.writeTo(updater);
        }
        this.log.warn("Relationship degrees store rebuild completed.");
    }

    private static class LatchResource
    implements AutoCloseable {
        private final Lock lock = new ReentrantLock();

        private LatchResource() {
        }

        LatchResource acquire() {
            this.lock.lock();
            return this;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    private static class StripedLatches {
        private static final int NUM_LATCHES = 1024;
        private static final int LATCH_STRIPE_MASK = Integer.highestOneBit(1024) - 1;
        private final LatchResource[] latches = new LatchResource[1024];

        StripedLatches() {
            for (int i = 0; i < this.latches.length; ++i) {
                this.latches[i] = new LatchResource();
            }
        }

        LatchResource acquire(long id) {
            int index = (int)(id & (long)LATCH_STRIPE_MASK);
            return this.latches[index].acquire();
        }
    }

    private static class CalculateDegreesStep
    extends ProcessorStep<RelationshipRecord[]> {
        private final StripedLatches latches = new StripedLatches();
        private final GroupDegreesCache cache;

        CalculateDegreesStep(StageControl control, Configuration config, GroupDegreesCache cache) {
            super(control, "CALCULATE", config, config.maxNumberOfProcessors(), PageCacheTracer.NULL, new StatsProvider[0]);
            this.cache = cache;
        }

        protected void process(RelationshipRecord[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
            for (RelationshipRecord record : batch) {
                if (!record.inUse()) continue;
                if (record.getFirstNode() == record.getSecondNode()) {
                    this.process(record.getFirstNode(), record.getType(), 2);
                    continue;
                }
                this.process(record.getFirstNode(), record.getType(), 0);
                this.process(record.getSecondNode(), record.getType(), 1);
            }
        }

        private void process(long node, int type, int directionBit) {
            this.cache.include(node, type, directionBit, this.latches);
        }
    }

    private static class CalculateDegreesStage
    extends Stage {
        CalculateDegreesStage(Configuration config, RelationshipStore store, GroupDegreesCache cache, PageCacheTracer pageCacheTracer, LogProgressReporter progress) {
            super("Calculate degrees", null, config, 2);
            this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterator.withProgress((RecordIdIterator)RecordIdIterator.forwards((long)0L, (long)store.getHighId(), (Configuration)config), (ProgressReporter)progress), store.getRecordSize()));
            this.add((Step)new ReadRecordsStep<RelationshipRecord>(this.control(), config, false, store, pageCacheTracer));
            this.add((Step)new CalculateDegreesStep(this.control(), config, cache));
        }
    }

    private static class PrepareCacheStep
    extends ProcessorStep<RelationshipGroupRecord[]> {
        private final StripedLatches latches = new StripedLatches();
        private final GroupDegreesCache cache;

        PrepareCacheStep(StageControl control, Configuration config, GroupDegreesCache cache) {
            super(control, "PREPARE", config, config.maxNumberOfProcessors(), PageCacheTracer.NULL, new StatsProvider[0]);
            this.cache = cache;
        }

        protected void process(RelationshipGroupRecord[] batch, BatchSender sender, CursorContext cursorContext) throws Throwable {
            for (RelationshipGroupRecord record : batch) {
                if (!record.inUse() || !record.hasExternalDegreesOut() && !record.hasExternalDegreesIn() && !record.hasExternalDegreesLoop()) continue;
                this.cache.addGroup(record, this.latches);
            }
        }
    }

    private static class PrepareCacheStage
    extends Stage {
        PrepareCacheStage(Configuration config, RelationshipGroupStore store, GroupDegreesCache cache, PageCacheTracer pageCacheTracer, LogProgressReporter progress) {
            super("Prepare cache", null, config, 2);
            this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterator.withProgress((RecordIdIterator)RecordIdIterator.forwards((long)store.getNumberOfReservedLowIds(), (long)store.getHighId(), (Configuration)config), (ProgressReporter)progress), store.getRecordSize()));
            this.add((Step)new ReadRecordsStep<RelationshipGroupRecord>(this.control(), config, false, store, pageCacheTracer));
            this.add((Step)new PrepareCacheStep(this.control(), config, cache));
        }
    }

    private static class GroupDegreesCache
    implements AutoCloseable {
        private static final int SHIFT_DIRECTION_BITS = 32;
        private static final int NUM_GROUP_DATA_FIELDS = 3;
        private static final int DIRECTION_OUTGOING = 0;
        private static final int DIRECTION_INCOMING = 1;
        private static final int DIRECTION_LOOP = 2;
        private final LongArray nodeCache;
        private final LongArray groupCache;
        private final AtomicLong nextGroupLocation = new AtomicLong();
        private final long highNodeId;

        GroupDegreesCache(NumberArrayFactory numberArrayFactory, long highNodeId, MemoryTracker memoryTracker) {
            this.highNodeId = highNodeId;
            this.nodeCache = numberArrayFactory.newLongArray(highNodeId, -1L, memoryTracker);
            this.groupCache = numberArrayFactory.newDynamicLongArray(Long.max(1000000L, highNodeId / 10L), 0L, memoryTracker);
        }

        @Override
        public void close() {
            IOUtils.closeAllUnchecked((AutoCloseable[])new LongArray[]{this.nodeCache, this.groupCache});
        }

        void addGroup(RelationshipGroupRecord groupRecord, StripedLatches latches) {
            long existingGroupIndex;
            int slotsForCounts = this.slotsForDegrees(groupRecord);
            long groupIndex = this.nextGroupLocation.getAndAdd(3 + slotsForCounts);
            this.groupCache.set(groupIndex, this.buildGroup(groupRecord));
            this.groupCache.set(groupIndex + 2L, groupRecord.getId());
            long owningNode = groupRecord.getOwningNode();
            try (LatchResource latch = latches.acquire(owningNode);){
                existingGroupIndex = this.nodeCache.get(owningNode);
                this.nodeCache.set(owningNode, groupIndex);
            }
            this.groupCache.set(groupIndex + 1L, existingGroupIndex);
        }

        private long buildGroup(RelationshipGroupRecord groupRecord) {
            long group = groupRecord.getType();
            group |= groupRecord.hasExternalDegreesOut() ? this.directionBitMask(0) : 0L;
            group |= groupRecord.hasExternalDegreesIn() ? this.directionBitMask(1) : 0L;
            return group |= groupRecord.hasExternalDegreesLoop() ? this.directionBitMask(2) : 0L;
        }

        private int slotsForDegrees(RelationshipGroupRecord groupRecord) {
            int slots = 0;
            slots += groupRecord.hasExternalDegreesOut() ? 1 : 0;
            slots += groupRecord.hasExternalDegreesIn() ? 1 : 0;
            return slots += groupRecord.hasExternalDegreesLoop() ? 1 : 0;
        }

        private void include(long node, int type, int directionBit, StripedLatches latches) {
            long groupIndex = this.nodeCache.get(node);
            while (groupIndex != -1L) {
                long group = this.groupCache.get(groupIndex);
                if (this.typeOf(group) == type) {
                    long directionSlot = this.slotForDirection(group, directionBit);
                    if (directionSlot == -1L) {
                        return;
                    }
                    try (LatchResource latch = latches.acquire(groupIndex);){
                        long prevCount = this.groupCache.get(groupIndex + directionSlot);
                        this.groupCache.set(groupIndex + directionSlot, prevCount + 1L);
                        break;
                    }
                }
                groupIndex = this.groupCache.get(groupIndex + 1L);
            }
        }

        private int slotForDirection(long group, int directionBit) {
            if (!this.hasDirectionBit(group, directionBit)) {
                return -1;
            }
            int slot = 0;
            for (int i = 0; i < directionBit; ++i) {
                if (!this.hasDirectionBit(group, i)) continue;
                ++slot;
            }
            return 3 + slot;
        }

        private boolean hasDirectionBit(long group, int directionBit) {
            return (group & this.directionBitMask(directionBit)) != 0L;
        }

        private long directionBitMask(int directionBit) {
            return 1L << 32 + directionBit;
        }

        private int typeOf(long group) {
            return (int)group;
        }

        void writeTo(RelationshipGroupDegreesStore.Updater updater) {
            for (long node = 0L; node < this.highNodeId; ++node) {
                long groupIndex = this.nodeCache.get(node);
                while (groupIndex != -1L) {
                    long group = this.groupCache.get(groupIndex);
                    long groupId = this.groupCache.get(groupIndex + 2L);
                    long slot = groupIndex + 3L;
                    if (this.hasDirectionBit(group, 0)) {
                        updater.increment(groupId, RelationshipDirection.OUTGOING, this.groupCache.get(slot));
                        ++slot;
                    }
                    if (this.hasDirectionBit(group, 1)) {
                        updater.increment(groupId, RelationshipDirection.INCOMING, this.groupCache.get(slot));
                        ++slot;
                    }
                    if (this.hasDirectionBit(group, 2)) {
                        updater.increment(groupId, RelationshipDirection.LOOP, this.groupCache.get(slot));
                    }
                    groupIndex = this.groupCache.get(groupIndex + 1L);
                }
            }
        }

        boolean hasAnyGroup() {
            return this.nextGroupLocation.get() > 0L;
        }
    }
}

