/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.CacheAccessBackDoor;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.api.NamedToken;

public class CacheInvalidationTransactionApplier
extends TransactionApplier.Adapter {
    private final CacheAccessBackDoor cacheAccess;
    private final RelationshipTypeTokenStore relationshipTypeTokenStore;
    private final LabelTokenStore labelTokenStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final StoreCursors storeCursors;

    public CacheInvalidationTransactionApplier(NeoStores neoStores, CacheAccessBackDoor cacheAccess, StoreCursors storeCursors) {
        this.cacheAccess = cacheAccess;
        this.relationshipTypeTokenStore = neoStores.getRelationshipTypeTokenStore();
        this.labelTokenStore = neoStores.getLabelTokenStore();
        this.propertyKeyTokenStore = neoStores.getPropertyKeyTokenStore();
        this.storeCursors = storeCursors;
    }

    @Override
    public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) {
        NamedToken type = this.relationshipTypeTokenStore.getToken(command.tokenId(), this.storeCursors);
        this.cacheAccess.addRelationshipTypeToken(type);
        return false;
    }

    @Override
    public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) {
        NamedToken labelId = this.labelTokenStore.getToken(command.tokenId(), this.storeCursors);
        this.cacheAccess.addLabelToken(labelId);
        return false;
    }

    @Override
    public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) {
        NamedToken index = this.propertyKeyTokenStore.getToken(command.tokenId(), this.storeCursors);
        this.cacheAccess.addPropertyKeyToken(index);
        return false;
    }

    @Override
    public void close() {
    }
}

