/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.id.EmptyIdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.standard.MetaDataRecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.StoreFileClosedException;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.HighestTransactionId;
import org.neo4j.util.Bits;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class MetaDataStore
extends CommonAbstractStore<MetaDataRecord, NoStoreHeader>
implements MetadataProvider {
    private static final String TYPE_DESCRIPTOR = "NeoStore";
    static final long FIELD_NOT_INITIALIZED = Long.MIN_VALUE;
    private static final String METADATA_REFRESH_TAG = "metadataRefresh";
    static final UUID NOT_INITIALIZED_UUID = new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
    private volatile long creationTimeField = Long.MIN_VALUE;
    private volatile long randomNumberField = Long.MIN_VALUE;
    private volatile long versionField = Long.MIN_VALUE;
    private volatile long checkpointLogVersionField = Long.MIN_VALUE;
    private final AtomicLong lastCommittingTxField = new AtomicLong(Long.MIN_VALUE);
    private volatile long storeVersionField = Long.MIN_VALUE;
    private volatile long latestConstraintIntroducingTxField = Long.MIN_VALUE;
    private volatile long upgradeTxIdField = Long.MIN_VALUE;
    private volatile int upgradeTxChecksumField = 0;
    private volatile long upgradeTimeField = Long.MIN_VALUE;
    private volatile long upgradeCommitTimestampField = Long.MIN_VALUE;
    private volatile UUID externalStoreUUID;
    private volatile UUID databaseUUID;
    private volatile long kernelVersion = Long.MIN_VALUE;
    private final PageCacheTracer pageCacheTracer;
    private volatile TransactionId upgradeTransaction = new TransactionId(Long.MIN_VALUE, 0, Long.MIN_VALUE);
    private final HighestTransactionId highestCommittedTransaction = new HighestTransactionId(Long.MIN_VALUE, 0, Long.MIN_VALUE);
    private final OutOfOrderSequence lastClosedTx = new ArrayQueueOutOfOrderSequence(-1L, 200, new long[2]);
    private final Object upgradeTimeLock = new Object();
    private final Object creationTimeLock = new Object();
    private final Object randomNumberLock = new Object();
    private final Object upgradeTransactionLock = new Object();
    private final Object logVersionLock = new Object();
    private final Object checkpointLogVersionLock = new Object();
    private final Object storeVersionLock = new Object();
    private final Object lastConstraintIntroducingTxLock = new Object();
    private final Object transactionCommittedLock = new Object();
    private final Object transactionClosedLock = new Object();
    private volatile boolean closed;

    MetaDataStore(Path file, Config conf, PageCache pageCache, LogProvider logProvider, RecordFormat<MetaDataRecord> recordFormat, String storeVersion, PageCacheTracer pageCacheTracer, DatabaseReadOnlyChecker readOnlyChecker, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(file, null, conf, null, EmptyIdGeneratorFactory.EMPTY_ID_GENERATOR_FACTORY, pageCache, logProvider, TYPE_DESCRIPTOR, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, storeVersion, readOnlyChecker, databaseName, openOptions);
        this.pageCacheTracer = pageCacheTracer;
    }

    @Override
    protected void initialiseNewStoreFile(CursorContext cursorContext) throws IOException {
        super.initialiseNewStoreFile(cursorContext);
        long storeVersionAsLong = MetaDataStore.versionStringToLong(this.storeVersion);
        StoreId storeId = new StoreId(storeVersionAsLong);
        this.setCreationTime(storeId.getCreationTime(), cursorContext);
        this.setRandomNumber(storeId.getRandomId(), cursorContext);
        this.setUpgradeTime(storeId.getCreationTime(), cursorContext);
        this.setUpgradeTransaction(1L, -559063315, 0L, cursorContext);
        this.setCurrentLogVersion(0L, cursorContext);
        this.setLastCommittedAndClosedTransactionId(1L, -559063315, 0L, 64L, 0L, cursorContext);
        this.setStoreVersion(storeVersionAsLong, cursorContext);
        this.setLatestConstraintIntroducingTx(0L, cursorContext);
        this.setExternalStoreUUID(UUID.randomUUID(), cursorContext);
        this.setCheckpointLogVersion(0L, cursorContext);
        this.setKernelVersion(KernelVersion.LATEST, cursorContext);
        this.setDatabaseIdUuid(NOT_INITIALIZED_UUID, cursorContext);
        this.flush(cursorContext);
    }

    @Override
    protected void initialise(boolean createIfNotExists, CursorContext cursorContext) {
        super.initialise(createIfNotExists, cursorContext);
        this.refreshFields();
    }

    @Override
    public long getHighId() {
        Position[] values = Position.values();
        return values[values.length - 1].id + 1;
    }

    public void setKernelVersion(KernelVersion kernelVersion, CursorContext cursorContext) {
        this.assertNotClosed();
        byte version = kernelVersion.version();
        try (PageCursor cursor = this.openPageCursorForWriting(Position.KERNEL_VERSION.id, cursorContext);){
            this.setRecord(Position.KERNEL_VERSION, version, cursor, cursorContext);
        }
        this.kernelVersion = version;
    }

    public KernelVersion kernelVersion() {
        this.assertNotClosed();
        if (this.kernelVersion == -1L) {
            throw new IllegalStateException("KernelVersion unavailable. KernelVersion is not present in pre-4.3 stores");
        }
        return KernelVersion.getForVersion((byte)Numbers.safeCastLongToByte((long)this.kernelVersion));
    }

    public long getCheckpointLogVersion() {
        this.assertNotClosed();
        return this.checkpointLogVersionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckpointLogVersion(long version, CursorContext cursorContext) {
        Object object = this.checkpointLogVersionLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.CHECKPOINT_LOG_VERSION.id, cursorContext);){
                this.setRecord(Position.CHECKPOINT_LOG_VERSION, version, cursor, cursorContext);
            }
            this.checkpointLogVersionField = version;
        }
    }

    public long incrementAndGetCheckpointLogVersion(CursorContext cursorContext) {
        long checkPointVersion;
        this.checkpointLogVersionField = checkPointVersion = this.incrementAndGetVersion(cursorContext, this.checkpointLogVersionLock, Position.CHECKPOINT_LOG_VERSION);
        return checkPointVersion;
    }

    private void setExternalStoreUUID(UUID uuid, CursorContext cursorContext) {
        this.assertNotClosed();
        try (PageCursor cursor = this.openPageCursorForWriting(Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS.id, cursorContext);){
            this.setRecord(Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS, uuid.getMostSignificantBits(), cursor, cursorContext);
            this.setRecord(Position.EXTERNAL_STORE_UUID_LEAST_SIGN_BITS, uuid.getLeastSignificantBits(), cursor, cursorContext);
            this.externalStoreUUID = uuid;
        }
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long byteOffset, long logVersion, CursorContext cursorContext) {
        this.assertNotClosed();
        try (PageCursor cursor = this.openPageCursorForWriting(Position.LAST_TRANSACTION_ID.id, cursorContext);){
            this.setRecord(Position.LAST_TRANSACTION_ID, transactionId, cursor, cursorContext);
            this.setRecord(Position.LAST_TRANSACTION_CHECKSUM, checksum, cursor, cursorContext);
            this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logVersion, cursor, cursorContext);
            this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, byteOffset, cursor, cursorContext);
            this.setRecord(Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, commitTimestamp, cursor, cursorContext);
        }
        this.lastCommittingTxField.set(transactionId);
        this.lastClosedTx.set(transactionId, new long[]{logVersion, byteOffset});
        this.highestCommittedTransaction.set(transactionId, checksum, commitTimestamp);
    }

    public static long setRecord(PageCache pageCache, Path neoStore, Position position, long value, String databaseName, CursorContext cursorContext) throws IOException {
        long previousValue = Long.MIN_VALUE;
        int pageSize = pageCache.pageSize();
        int pageReservedBytes = pageCache.pageReservedBytes();
        try (PagedFile pagedFile = pageCache.map(neoStore, pageSize, databaseName, Sets.immutable.empty());){
            int offset = MetaDataStore.offset(position, pageReservedBytes);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                if (cursor.next()) {
                    cursor.setOffset(offset);
                    byte inUse = cursor.getByte();
                    long record = cursor.getLong();
                    if (inUse == Record.IN_USE.byteValue()) {
                        previousValue = record;
                    }
                    cursor.setOffset(offset);
                    cursor.putByte(Record.IN_USE.byteValue());
                    cursor.putLong(value);
                    if (cursor.checkAndClearBoundsFlag()) {
                        MetaDataRecord neoStoreRecord = new MetaDataRecord();
                        neoStoreRecord.setId(position.id);
                        throw new UnderlyingStorageException(MetaDataStore.buildOutOfBoundsExceptionMessage(neoStoreRecord, 0L, offset, 9, pageSize, neoStore.toAbsolutePath().toString()));
                    }
                }
            }
        }
        return previousValue;
    }

    private static int offset(Position position, int reservedBytes) {
        return reservedBytes + 9 * position.id;
    }

    public static long getRecord(PageCache pageCache, Path neoStore, Position position, String databaseName, CursorContext cursorContext) throws IOException {
        long value;
        block15: {
            int reservedBytes = pageCache.pageReservedBytes();
            MetaDataRecordFormat recordFormat = new MetaDataRecordFormat(reservedBytes);
            int pageSize = pageCache.pageSize();
            value = -1L;
            try (PagedFile pagedFile = pageCache.map(neoStore, pageSize, databaseName, Sets.immutable.empty(), IOController.DISABLED);){
                if (pagedFile.getLastPageId() < 0L) break block15;
                try (PageCursor cursor = pagedFile.io(0L, 1, cursorContext);){
                    if (cursor.next()) {
                        MetaDataRecord record = new MetaDataRecord();
                        record.setId(position.id);
                        do {
                            recordFormat.read(record, cursor, RecordLoad.CHECK, 9, pageSize / 9);
                            value = record.inUse() ? record.getValue() : -1L;
                        } while (cursor.shouldRetry());
                        if (cursor.checkAndClearBoundsFlag()) {
                            int offset = MetaDataStore.offset(position, reservedBytes);
                            throw new UnderlyingStorageException(MetaDataStore.buildOutOfBoundsExceptionMessage(record, 0L, offset, 9, pageSize, neoStore.toAbsolutePath().toString()));
                        }
                    }
                }
            }
        }
        return value;
    }

    public static void setStoreId(PageCache pageCache, Path neoStore, StoreId storeId, long upgradeTxChecksum, long upgradeTxCommitTimestamp, String databaseName, CursorContext cursorContext) throws IOException {
        MetaDataStore.setRecord(pageCache, neoStore, Position.TIME, storeId.getCreationTime(), databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.RANDOM_NUMBER, storeId.getRandomId(), databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.STORE_VERSION, storeId.getStoreVersion(), databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TIME, storeId.getUpgradeTime(), databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_ID, storeId.getUpgradeTxId(), databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_CHECKSUM, upgradeTxChecksum, databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, upgradeTxCommitTimestamp, databaseName, cursorContext);
    }

    public static void setExternalStoreUUID(PageCache pageCache, Path neoStore, UUID externalStoreId, String databaseName, CursorContext cursorContext) throws IOException {
        MetaDataStore.setRecord(pageCache, neoStore, Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS, externalStoreId.getMostSignificantBits(), databaseName, cursorContext);
        MetaDataStore.setRecord(pageCache, neoStore, Position.EXTERNAL_STORE_UUID_LEAST_SIGN_BITS, externalStoreId.getLeastSignificantBits(), databaseName, cursorContext);
    }

    public void setDatabaseIdUuid(UUID uuid, CursorContext cursorContext) {
        this.assertNotClosed();
        try (PageCursor cursor = this.openPageCursorForWriting(Position.DATABASE_ID_MOST_SIGN_BITS.id, cursorContext);){
            this.setRecord(Position.DATABASE_ID_MOST_SIGN_BITS, uuid.getMostSignificantBits(), cursor, cursorContext);
            this.setRecord(Position.DATABASE_ID_LEAST_SIGN_BITS, uuid.getLeastSignificantBits(), cursor, cursorContext);
            this.databaseUUID = uuid;
        }
    }

    public static Optional<UUID> getDatabaseIdUuid(PageCache pageCache, Path neoStore, String databaseName, CursorContext cursorContext) {
        try {
            long msb = MetaDataStore.getRecord(pageCache, neoStore, Position.DATABASE_ID_MOST_SIGN_BITS, databaseName, cursorContext);
            long lsb = MetaDataStore.getRecord(pageCache, neoStore, Position.DATABASE_ID_LEAST_SIGN_BITS, databaseName, cursorContext);
            return MetaDataStore.instantiateDatabaseIdUuid(msb, lsb);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Optional<UUID> getDatabaseIdUuid(CursorContext cursorContext) {
        this.assertNotClosed();
        UUID databaseUUID = this.databaseUUID;
        return MetaDataStore.isNotInitializedUUID(databaseUUID) ? Optional.empty() : Optional.of(databaseUUID);
    }

    private static Optional<UUID> instantiateDatabaseIdUuid(long msb, long lsb) {
        UUID uuid = new UUID(msb, lsb);
        if (MetaDataStore.isNotInitializedUUID(uuid) || msb == -1L && lsb == -1L) {
            return Optional.empty();
        }
        return Optional.of(uuid);
    }

    public StoreId getStoreId() {
        return new StoreId(this.getCreationTime(), this.getRandomNumber(), this.getStoreVersion(), this.getUpgradeTime(), this.upgradeTxIdField);
    }

    public Optional<ExternalStoreId> getExternalStoreId() {
        this.assertNotClosed();
        UUID externalStoreUUID = this.externalStoreUUID;
        return MetaDataStore.isNotInitializedUUID(externalStoreUUID) ? Optional.empty() : Optional.of(new ExternalStoreId(externalStoreUUID));
    }

    public static StoreId getStoreId(PageCache pageCache, Path neoStore, String databaseName, CursorContext cursorContext) throws IOException {
        return new StoreId(MetaDataStore.getRecord(pageCache, neoStore, Position.TIME, databaseName, cursorContext), MetaDataStore.getRecord(pageCache, neoStore, Position.RANDOM_NUMBER, databaseName, cursorContext), MetaDataStore.getRecord(pageCache, neoStore, Position.STORE_VERSION, databaseName, cursorContext), MetaDataStore.getRecord(pageCache, neoStore, Position.UPGRADE_TIME, databaseName, cursorContext), MetaDataStore.getRecord(pageCache, neoStore, Position.UPGRADE_TRANSACTION_ID, databaseName, cursorContext));
    }

    public long getUpgradeTime() {
        this.assertNotClosed();
        return this.upgradeTimeField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeTime(long time, CursorContext cursorContext) {
        Object object = this.upgradeTimeLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.UPGRADE_TIME.id, cursorContext);){
                this.setRecord(Position.UPGRADE_TIME, time, cursor, cursorContext);
            }
            this.upgradeTimeField = time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgradeTransaction(long id, int checksum, long timestamp, CursorContext cursorContext) {
        long pageId = this.pageIdForRecord(Position.UPGRADE_TRANSACTION_ID.id);
        assert (pageId == this.pageIdForRecord(Position.UPGRADE_TRANSACTION_CHECKSUM.id));
        Object object = this.upgradeTransactionLock;
        synchronized (object) {
            try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorContext);){
                if (!cursor.next()) {
                    throw new UnderlyingStorageException("Could not access MetaDataStore page " + pageId);
                }
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_ID, id);
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM, checksum);
                this.setRecord(cursor, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, timestamp);
                this.upgradeTxIdField = id;
                this.upgradeTxChecksumField = checksum;
                this.upgradeCommitTimestampField = timestamp;
                this.upgradeTransaction = new TransactionId(id, checksum, timestamp);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException((Throwable)e);
            }
        }
    }

    private static boolean isNotInitializedUUID(UUID uuid) {
        return NOT_INITIALIZED_UUID.equals(uuid);
    }

    public long getCreationTime() {
        this.assertNotClosed();
        return this.creationTimeField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCreationTime(long time, CursorContext cursorContext) {
        Object object = this.creationTimeLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.TIME.id, cursorContext);){
                this.setRecord(Position.TIME, time, cursor, cursorContext);
            }
            this.creationTimeField = time;
        }
    }

    public long getRandomNumber() {
        this.assertNotClosed();
        return this.randomNumberField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRandomNumber(long random, CursorContext cursorContext) {
        Object object = this.randomNumberLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.RANDOM_NUMBER.id, cursorContext);){
                this.setRecord(Position.RANDOM_NUMBER, random, cursor, cursorContext);
            }
            this.randomNumberField = random;
        }
    }

    public long getCurrentLogVersion() {
        this.assertNotClosed();
        return this.versionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentLogVersion(long version, CursorContext cursorContext) {
        Object object = this.logVersionLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.LOG_VERSION.id, cursorContext);){
                this.setRecord(Position.LOG_VERSION, version, cursor, cursorContext);
            }
            this.versionField = version;
        }
    }

    public long incrementAndGetVersion(CursorContext cursorContext) {
        long version;
        this.versionField = version = this.incrementAndGetVersion(cursorContext, this.logVersionLock, Position.LOG_VERSION);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long incrementAndGetVersion(CursorContext cursorContext, Object lock, Position position) {
        long version;
        long pageId = this.pageIdForRecord(position.id);
        Object object = lock;
        synchronized (object) {
            block12: {
                try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorContext);){
                    if (cursor.next()) {
                        version = this.incrementVersion(cursor, position);
                        break block12;
                    }
                    throw new IllegalStateException("Filed " + position + "missing in metadata store. Page " + pageId + "not found.");
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException((Throwable)e);
                }
            }
        }
        this.flush(cursorContext);
        return version;
    }

    private long incrementVersion(PageCursor cursor, Position position) {
        if (!cursor.isWriteLocked()) {
            throw new IllegalArgumentException("Cannot increment log version on page cursor that is not write-locked");
        }
        int offset = this.offsetForId(position.id) + 1;
        long value = cursor.getLong(offset) + 1L;
        cursor.putLong(offset, value);
        this.checkForDecodingErrors(cursor, position.id, RecordLoad.NORMAL);
        return value;
    }

    public long getStoreVersion() {
        this.assertNotClosed();
        return this.storeVersionField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoreVersion(long version, CursorContext cursorContext) {
        Object object = this.storeVersionLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.STORE_VERSION.id, cursorContext);){
                this.setRecord(Position.STORE_VERSION, version, cursor, cursorContext);
            }
            this.storeVersionField = version;
        }
    }

    public long getLatestConstraintIntroducingTx() {
        this.assertNotClosed();
        return this.latestConstraintIntroducingTxField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLatestConstraintIntroducingTx(long latestConstraintIntroducingTx, CursorContext cursorContext) {
        Object object = this.lastConstraintIntroducingTxLock;
        synchronized (object) {
            try (PageCursor cursor = this.openPageCursorForWriting(Position.LAST_CONSTRAINT_TRANSACTION.id, cursorContext);){
                this.setRecord(Position.LAST_CONSTRAINT_TRANSACTION, latestConstraintIntroducingTx, cursor, cursorContext);
            }
            this.latestConstraintIntroducingTxField = latestConstraintIntroducingTx;
        }
    }

    private void readAllFields(PageCursor cursor) throws IOException {
        do {
            this.creationTimeField = this.getRecordValue(cursor, Position.TIME);
            this.randomNumberField = this.getRecordValue(cursor, Position.RANDOM_NUMBER);
            this.versionField = this.getRecordValue(cursor, Position.LOG_VERSION);
            long lastCommittedTxId = this.getRecordValue(cursor, Position.LAST_TRANSACTION_ID);
            this.lastCommittingTxField.set(lastCommittedTxId);
            this.storeVersionField = this.getRecordValue(cursor, Position.STORE_VERSION);
            this.getRecordValue(cursor, Position.FIRST_GRAPH_PROPERTY);
            this.latestConstraintIntroducingTxField = this.getRecordValue(cursor, Position.LAST_CONSTRAINT_TRANSACTION);
            this.upgradeTxIdField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_ID);
            this.upgradeTxChecksumField = (int)this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_CHECKSUM);
            this.upgradeTimeField = this.getRecordValue(cursor, Position.UPGRADE_TIME);
            long lastClosedTransactionLogVersion = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
            long lastClosedTransactionLogByteOffset = this.getRecordValue(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
            this.lastClosedTx.set(lastCommittedTxId, new long[]{lastClosedTransactionLogVersion, lastClosedTransactionLogByteOffset});
            this.highestCommittedTransaction.set(lastCommittedTxId, (int)this.getRecordValue(cursor, Position.LAST_TRANSACTION_CHECKSUM), this.getRecordValue(cursor, Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, 1L));
            this.upgradeCommitTimestampField = this.getRecordValue(cursor, Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, 0L);
            this.externalStoreUUID = this.readExternalStoreUUID(cursor);
            this.databaseUUID = this.readDatabaseUUID(cursor);
            this.upgradeTransaction = new TransactionId(this.upgradeTxIdField, this.upgradeTxChecksumField, this.upgradeCommitTimestampField);
            this.checkpointLogVersionField = this.getRecordValue(cursor, Position.CHECKPOINT_LOG_VERSION, 0L);
            this.kernelVersion = this.getRecordValue(cursor, Position.KERNEL_VERSION);
        } while (cursor.shouldRetry());
        if (cursor.checkAndClearBoundsFlag()) {
            throw new UnderlyingStorageException("Out of page bounds when reading all meta-data fields. The page in question is page " + cursor.getCurrentPageId() + " of file " + this.storageFile.toAbsolutePath() + ", which is " + cursor.getCurrentPageSize() + " bytes in size");
        }
    }

    private UUID readExternalStoreUUID(PageCursor cursor) {
        long mostSignificantBits = this.getRecordValue(cursor, Position.EXTERNAL_STORE_UUID_MOST_SIGN_BITS, Long.MIN_VALUE);
        long leastSignificantBits = this.getRecordValue(cursor, Position.EXTERNAL_STORE_UUID_LEAST_SIGN_BITS, Long.MIN_VALUE);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    private UUID readDatabaseUUID(PageCursor cursor) {
        long mostSignificantBits = this.getRecordValue(cursor, Position.DATABASE_ID_MOST_SIGN_BITS, Long.MIN_VALUE);
        long leastSignificantBits = this.getRecordValue(cursor, Position.DATABASE_ID_LEAST_SIGN_BITS, Long.MIN_VALUE);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    long getRecordValue(PageCursor cursor, Position position) {
        return this.getRecordValue(cursor, position, -1L);
    }

    private long getRecordValue(PageCursor cursor, Position position, long defaultValue) {
        MetaDataRecord record = this.newRecord();
        try {
            record.setId(position.id);
            this.recordFormat.read(record, cursor, RecordLoad.ALWAYS, 9, this.getRecordsPerPage());
            if (record.inUse()) {
                return record.getValue();
            }
            return defaultValue;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void refreshFields() {
        this.scanAllFields(1, (Visitor<PageCursor, IOException>)((Visitor)element -> {
            this.readAllFields((PageCursor)element);
            return false;
        }));
    }

    private void scanAllFields(int pf_flags, Visitor<PageCursor, IOException> visitor) {
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(METADATA_REFRESH_TAG));
             PageCursor cursor = this.pagedFile.io(0L, pf_flags, cursorContext);){
            if (cursor.next()) {
                visitor.visit((Object)cursor);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    private void setRecord(Position position, long value, PageCursor pageCursor, CursorContext cursorContext) {
        MetaDataRecord record = new MetaDataRecord();
        record.initialize(true, value);
        record.setId(position.id);
        this.updateRecord(record, pageCursor, cursorContext, StoreCursors.NULL);
    }

    private void setRecord(PageCursor cursor, Position position, long value) {
        if (!cursor.isWriteLocked()) {
            throw new IllegalArgumentException("Cannot write record without a page cursor that is write-locked");
        }
        int offset = this.offsetForId(position.id);
        cursor.setOffset(offset);
        cursor.putByte(Record.IN_USE.byteValue());
        cursor.putLong(value);
        this.checkForDecodingErrors(cursor, position.id, RecordLoad.NORMAL);
    }

    public static long versionStringToLong(String storeVersion) {
        if ("Unknown".equals(storeVersion)) {
            return -1L;
        }
        Bits bits = Bits.bits((int)8);
        int length = storeVersion.length();
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The given string %s is not of proper size for a store version string", storeVersion));
        }
        bits.put(length, 8);
        for (int i = 0; i < length; ++i) {
            char c = storeVersion.charAt(i);
            if (c >= '\u0100') {
                throw new IllegalArgumentException(String.format("Store version strings should be encode-able as Latin1 - %s is not", storeVersion));
            }
            bits.put((int)c, 8);
        }
        return bits.getLong();
    }

    public static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return "Unknown";
        }
        Bits bits = Bits.bitsFromLongs((long[])new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    public long nextCommittingTransactionId() {
        this.assertNotClosed();
        return this.lastCommittingTxField.incrementAndGet();
    }

    public long committingTransactionId() {
        this.assertNotClosed();
        return this.lastCommittingTxField.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, CursorContext cursorContext) {
        this.assertNotClosed();
        if (this.highestCommittedTransaction.offer(transactionId, checksum, commitTimestamp)) {
            Object object = this.transactionCommittedLock;
            synchronized (object) {
                if (this.highestCommittedTransaction.get().transactionId() == transactionId) {
                    long pageId = this.pageIdForRecord(Position.LAST_TRANSACTION_ID.id);
                    assert (pageId == this.pageIdForRecord(Position.LAST_TRANSACTION_CHECKSUM.id));
                    try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorContext);){
                        if (cursor.next()) {
                            this.setRecord(cursor, Position.LAST_TRANSACTION_ID, transactionId);
                            this.setRecord(cursor, Position.LAST_TRANSACTION_CHECKSUM, checksum);
                            this.setRecord(cursor, Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, commitTimestamp);
                        }
                    }
                    catch (IOException e) {
                        throw new UnderlyingStorageException((Throwable)e);
                    }
                }
            }
        }
    }

    public long getLastCommittedTransactionId() {
        this.assertNotClosed();
        return this.highestCommittedTransaction.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        this.assertNotClosed();
        return this.highestCommittedTransaction.get();
    }

    public TransactionId getUpgradeTransaction() {
        this.assertNotClosed();
        return this.upgradeTransaction;
    }

    public long getLastClosedTransactionId() {
        this.assertNotClosed();
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        this.assertNotClosed();
        long[] longs = this.lastClosedTx.get();
        return new ClosedTransactionMetadata(longs[0], new LogPosition(longs[1], longs[2]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionClosed(long transactionId, long logVersion, long byteOffset, CursorContext cursorContext) {
        if (this.lastClosedTx.offer(transactionId, new long[]{logVersion, byteOffset})) {
            long pageId = this.pageIdForRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION.id);
            assert (pageId == this.pageIdForRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET.id));
            Object object = this.transactionClosedLock;
            synchronized (object) {
                try (PageCursor cursor = this.pagedFile.io(pageId, 2, cursorContext);){
                    if (cursor.next()) {
                        long[] lastClosedTransactionData = this.lastClosedTx.get();
                        this.setRecord(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTransactionData[1]);
                        this.setRecord(cursor, Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTransactionData[2]);
                    }
                }
                catch (IOException e) {
                    throw new UnderlyingStorageException((Throwable)e);
                }
            }
        }
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, boolean missingLogs, CursorContext cursorContext) {
        this.assertNotClosed();
        try (PageCursor cursor = this.openPageCursorForWriting(Position.LAST_TRANSACTION_ID.id, cursorContext);){
            this.setRecord(Position.LAST_TRANSACTION_ID, transactionId, cursor, cursorContext);
            this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, logVersion, cursor, cursorContext);
            this.setRecord(Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, byteOffset, cursor, cursorContext);
            if (missingLogs) {
                this.setRecord(Position.LAST_MISSING_STORE_FILES_RECOVERY_TIMESTAMP, System.currentTimeMillis(), cursor, cursorContext);
            }
        }
        this.lastClosedTx.set(transactionId, new long[]{logVersion, byteOffset});
    }

    public void logRecords(DiagnosticsLogger logger) {
        this.scanAllFields(1, (Visitor<PageCursor, IOException>)((Visitor)cursor -> {
            for (Position position : Position.values()) {
                long value;
                do {
                    value = this.getRecordValue((PageCursor)cursor, position);
                } while (cursor.shouldRetry());
                Object additionalDescription = "";
                try {
                    if (position == Position.STORE_VERSION) {
                        additionalDescription = " (" + MetaDataStore.versionLongToString(value) + ")";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bounds = cursor.checkAndClearBoundsFlag();
                logger.log(position.name() + " (" + position.description() + "): " + value + (String)additionalDescription + (bounds ? " (out-of-bounds detected; value cannot be trusted)" : ""));
            }
            return false;
        }));
    }

    @Override
    public MetaDataRecord newRecord() {
        return new MetaDataRecord();
    }

    @Override
    public void prepareForCommit(MetaDataRecord record, CursorContext cursorContext) {
    }

    @Override
    public void prepareForCommit(MetaDataRecord record, IdSequence idSequence, CursorContext cursorContext) {
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new StoreFileClosedException(this.storageFile);
        }
    }

    public static enum Position {
        TIME(0, "Creation time"),
        RANDOM_NUMBER(1, "Random number for store id"),
        LOG_VERSION(2, "Current log version"),
        LAST_TRANSACTION_ID(3, "Last committed transaction"),
        STORE_VERSION(4, "Store format version"),
        FIRST_GRAPH_PROPERTY(5, "First property record containing graph properties"),
        LAST_CONSTRAINT_TRANSACTION(6, "Last committed transaction containing constraint changes"),
        UPGRADE_TRANSACTION_ID(7, "Transaction id most recent upgrade was performed at"),
        UPGRADE_TIME(8, "Time of last upgrade"),
        LAST_TRANSACTION_CHECKSUM(9, "Checksum of last committed transaction"),
        UPGRADE_TRANSACTION_CHECKSUM(10, "Checksum of transaction id the most recent upgrade was performed at"),
        LAST_CLOSED_TRANSACTION_LOG_VERSION(11, "Log version where the last transaction commit entry has been written into"),
        LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET(12, "Byte offset in the log file where the last transaction commit entry has been written into"),
        LAST_TRANSACTION_COMMIT_TIMESTAMP(13, "Commit time timestamp for last committed transaction"),
        UPGRADE_TRANSACTION_COMMIT_TIMESTAMP(14, "Commit timestamp of transaction the most recent upgrade was performed at"),
        LAST_MISSING_STORE_FILES_RECOVERY_TIMESTAMP(15, "Timestamp of last attempt to perform a recovery on the store with missing files."),
        EXTERNAL_STORE_UUID_MOST_SIGN_BITS(16, "Database identifier exposed as external store identity. Generated on creation and never updated. Most significant bits."),
        EXTERNAL_STORE_UUID_LEAST_SIGN_BITS(17, "Database identifier exposed as external store identity. Generated on creation and never updated. Least significant bits"),
        CHECKPOINT_LOG_VERSION(18, "Current checkpoint log version"),
        KERNEL_VERSION(19, "The kernel version (also transaction log version) that is currently being used when writing new transactions"),
        DATABASE_ID_MOST_SIGN_BITS(20, "The last used DatabaseId for this database. Most significant bits"),
        DATABASE_ID_LEAST_SIGN_BITS(21, "The last used DatabaseId for this database. Least significant bits");

        private final int id;
        private final String description;

        private Position(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public int id() {
            return this.id;
        }

        public String description() {
            return this.description;
        }
    }
}

