/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.layout.CommonDatabaseFile;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;

public enum StoreType {
    NODE_LABEL((DatabaseFile)RecordDatabaseFile.NODE_LABEL_STORE, RecordIdType.NODE_LABELS){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createNodeLabelStore(cursorContext);
        }
    }
    ,
    NODE((DatabaseFile)RecordDatabaseFile.NODE_STORE, RecordIdType.NODE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createNodeStore(cursorContext);
        }
    }
    ,
    PROPERTY_KEY_TOKEN_NAME((DatabaseFile)RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordIdType.PROPERTY_KEY_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createPropertyKeyTokenNamesStore(cursorContext);
        }
    }
    ,
    PROPERTY_KEY_TOKEN((DatabaseFile)RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, (IdType)SchemaIdType.PROPERTY_KEY_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createPropertyKeyTokenStore(cursorContext);
        }
    }
    ,
    PROPERTY_STRING((DatabaseFile)RecordDatabaseFile.PROPERTY_STRING_STORE, RecordIdType.STRING_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createPropertyStringStore(cursorContext);
        }
    }
    ,
    PROPERTY_ARRAY((DatabaseFile)RecordDatabaseFile.PROPERTY_ARRAY_STORE, RecordIdType.ARRAY_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createPropertyArrayStore(cursorContext);
        }
    }
    ,
    PROPERTY((DatabaseFile)RecordDatabaseFile.PROPERTY_STORE, RecordIdType.PROPERTY){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createPropertyStore(cursorContext);
        }
    }
    ,
    RELATIONSHIP((DatabaseFile)RecordDatabaseFile.RELATIONSHIP_STORE, RecordIdType.RELATIONSHIP){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createRelationshipStore(cursorContext);
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN_NAME((DatabaseFile)RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, RecordIdType.RELATIONSHIP_TYPE_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createRelationshipTypeTokenNamesStore(cursorContext);
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN((DatabaseFile)RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, (IdType)SchemaIdType.RELATIONSHIP_TYPE_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createRelationshipTypeTokenStore(cursorContext);
        }
    }
    ,
    LABEL_TOKEN_NAME((DatabaseFile)RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordIdType.LABEL_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createLabelTokenNamesStore(cursorContext);
        }
    }
    ,
    LABEL_TOKEN((DatabaseFile)RecordDatabaseFile.LABEL_TOKEN_STORE, (IdType)SchemaIdType.LABEL_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createLabelTokenStore(cursorContext);
        }
    }
    ,
    SCHEMA((DatabaseFile)RecordDatabaseFile.SCHEMA_STORE, (IdType)SchemaIdType.SCHEMA){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createSchemaStore(cursorContext);
        }
    }
    ,
    RELATIONSHIP_GROUP((DatabaseFile)RecordDatabaseFile.RELATIONSHIP_GROUP_STORE, RecordIdType.RELATIONSHIP_GROUP){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createRelationshipGroupStore(cursorContext);
        }
    }
    ,
    META_DATA((DatabaseFile)CommonDatabaseFile.METADATA_STORE, RecordIdType.NODE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores, CursorContext cursorContext) {
            return neoStores.createMetadataStore(cursorContext);
        }
    };

    private final DatabaseFile databaseFile;
    private final IdType idType;

    private StoreType(DatabaseFile databaseFile, IdType idType) {
        this.databaseFile = databaseFile;
        this.idType = idType;
    }

    abstract CommonAbstractStore open(NeoStores var1, CursorContext var2);

    public DatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public static Optional<StoreType> typeOf(DatabaseFile databaseFile) {
        StoreType[] values;
        Objects.requireNonNull(databaseFile);
        for (StoreType value : values = StoreType.values()) {
            if (!value.getDatabaseFile().equals(databaseFile)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

