/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.HeapEstimator;

public class NodeRecord
extends PrimitiveRecord {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NodeRecord.class);
    private long nextRel;
    private long labels;
    private List<DynamicRecord> dynamicLabelRecords;
    private boolean isLight;
    private boolean dense;

    public NodeRecord(long id) {
        super(id);
    }

    public NodeRecord(NodeRecord other) {
        super(other);
        this.nextRel = other.nextRel;
        this.labels = other.labels;
        if (other.dynamicLabelRecords.isEmpty()) {
            this.dynamicLabelRecords = Collections.emptyList();
        } else {
            this.dynamicLabelRecords = new ArrayList<DynamicRecord>(other.dynamicLabelRecords.size());
            for (DynamicRecord labelRecord : other.dynamicLabelRecords) {
                this.dynamicLabelRecords.add(new DynamicRecord(labelRecord));
            }
        }
        this.isLight = other.isLight;
        this.dense = other.dense;
    }

    public NodeRecord initialize(boolean inUse, long nextProp, boolean dense, long nextRel, long labels) {
        super.initialize(inUse, nextProp);
        this.nextRel = nextRel;
        this.dense = dense;
        this.labels = labels;
        this.dynamicLabelRecords = Collections.emptyList();
        this.isLight = true;
        return this;
    }

    @Override
    public void clear() {
        this.initialize(false, Record.NO_NEXT_PROPERTY.intValue(), false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_LABELS_FIELD.intValue());
    }

    public long getNextRel() {
        return this.nextRel;
    }

    public void setNextRel(long nextRel) {
        this.nextRel = nextRel;
    }

    public void setLabelField(long labels, List<DynamicRecord> dynamicRecords) {
        this.labels = labels;
        this.dynamicLabelRecords = dynamicRecords;
        this.isLight = dynamicRecords.isEmpty();
    }

    public long getLabelField() {
        return this.labels;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public List<DynamicRecord> getDynamicLabelRecords() {
        return this.dynamicLabelRecords;
    }

    public Iterable<DynamicRecord> getUsedDynamicLabelRecords() {
        return Iterables.filter(AbstractBaseRecord::inUse, this.dynamicLabelRecords);
    }

    public boolean isDense() {
        return this.dense;
    }

    public void setDense(boolean dense) {
        this.dense = dense;
    }

    public String toString() {
        String denseInfo = (this.dense ? "group" : "rel") + "=" + this.nextRel;
        String lightHeavyInfo = this.isLight ? "light" : (this.dynamicLabelRecords.isEmpty() ? "heavy" : "heavy,dynlabels=" + this.dynamicLabelRecords);
        return "Node[" + this.getId() + ",used=" + this.inUse() + ",created=" + this.isCreated() + "," + denseInfo + ",prop=" + this.getNextProp() + ",labels=" + NodeLabelsField.parseLabelsField(this) + "," + lightHeavyInfo + this.secondaryUnitToString() + "]";
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setNodeId(this.getId());
    }

    @Override
    public NodeRecord copy() {
        return new NodeRecord(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.nextRel, this.labels, this.dense);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        NodeRecord other = (NodeRecord)obj;
        return this.nextRel == other.nextRel && this.labels == other.labels && this.dense == other.dense;
    }
}

