/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class CompilationFailureException
extends Exception {
    private final List<? extends Diagnostic<?>> diagnostics;

    public CompilationFailureException(List<? extends Diagnostic<?>> diagnostics) {
        super(String.format("Compilation failed with %d reported issues.%s", diagnostics.size(), CompilationFailureException.source(diagnostics)));
        this.diagnostics = diagnostics;
    }

    @Override
    public String toString() {
        StringWriter result = new StringWriter().append(super.toString());
        for (Diagnostic<?> diagnostic : this.diagnostics) {
            CompilationFailureException.format(result.append("\n\t\t"), diagnostic);
        }
        return result.toString();
    }

    private static String source(List<? extends Diagnostic<?>> diagnostics) {
        Set<?> sources = null;
        for (Diagnostic<?> diagnostic : diagnostics) {
            JavaFileObject file;
            Object source = diagnostic.getSource();
            if (!(source instanceof JavaFileObject) || (file = (JavaFileObject)source).getKind() != JavaFileObject.Kind.SOURCE) continue;
            if (sources == null) {
                sources = Collections.newSetFromMap(new IdentityHashMap());
            }
            sources.add(file);
        }
        if (sources == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Object source : sources) {
            int pos = result.length();
            result.append("\nSource file ").append(source.getName()).append(":\n");
            try {
                CharSequence content = source.getCharContent(true);
                result.append(String.format("%4d: ", 1));
                int line = 1;
                for (int i = 0; i < content.length(); ++i) {
                    char c = content.charAt(i);
                    result.append(c);
                    if (c != '\n') continue;
                    result.append(String.format("%4d: ", ++line));
                }
            }
            catch (IOException e) {
                result.setLength(pos);
            }
        }
        return result.toString();
    }

    public static void format(Appendable result, Diagnostic<?> diagnostic) {
        try {
            Object source = diagnostic.getSource();
            if (source != null) {
                result.append(diagnostic.getKind().name()).append(" on line ").append(Long.toString(diagnostic.getLineNumber())).append(" in ").append(source.toString()).append(": ").append(diagnostic.getMessage(null));
            } else {
                result.append(diagnostic.getMessage(null));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to append.", e);
        }
    }

    public List<Diagnostic<?>> getDiagnostics() {
        return Collections.unmodifiableList(this.diagnostics);
    }
}

