/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Objects;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

class TokenState {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TokenState.class);
    public final String name;
    public final boolean internal;

    static TokenState createTokenState(String name, boolean internal, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.sizeOf((String)name));
        return new TokenState(name, internal);
    }

    private TokenState(String name, boolean internal) {
        this.name = name;
        this.internal = internal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenState that = (TokenState)o;
        return this.internal == that.internal && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.internal);
    }
}

