/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.util.Preconditions;

public class TokenIndexPopulator
extends TokenIndex
implements IndexPopulator {
    private final EntityType entityType;
    private final DatabaseLayout directoryStructure;
    private final Config config;
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    TokenIndexPopulator(DatabaseIndexContext databaseIndexContext, DatabaseLayout directoryStructure, IndexFiles indexFiles, Config config, IndexDescriptor descriptor) {
        super(databaseIndexContext, indexFiles, descriptor);
        this.directoryStructure = directoryStructure;
        this.config = config;
        this.entityType = descriptor.schema().entityType();
    }

    public synchronized void create() {
        this.assertNotDropped();
        this.assertNotClosed();
        this.indexFiles.clear();
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate(), new NativeIndexHeaderWriter(1));
        this.instantiateUpdater(this.config, this.directoryStructure, this.entityType);
    }

    public synchronized void drop() {
        try {
            if (this.index != null) {
                this.index.setDeleteOnClose(true);
            }
            this.closeResources();
            this.indexFiles.clear();
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        try (TokenIndexUpdater updater = this.singleUpdater.initialize((Writer<TokenScanKey, TokenScanValue>)this.index.writer(cursorContext));){
            for (IndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
    }

    public IndexUpdater newPopulatingUpdater(NodePropertyAccessor accessor, CursorContext cursorContext) {
        try {
            return this.singleUpdater.initialize((Writer<TokenScanKey, TokenScanValue>)this.index.writer(cursorContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public synchronized void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        Preconditions.checkState((!populationCompletedSuccessfully || this.failureBytes == null ? 1 : 0) != 0, (String)"Can't mark index as online after it has been marked as failure");
        try {
            this.assertNotDropped();
            if (populationCompletedSuccessfully) {
                this.assertTreeOpen();
                this.flushTreeAndMarkAs((byte)0, cursorContext);
            } else if (this.failureBytes != null) {
                this.ensureTreeInstantiated();
                this.markTreeAsFailed(cursorContext);
            }
        }
        finally {
            this.closeResources();
            this.closed = true;
        }
    }

    private void flushTreeAndMarkAs(byte state, CursorContext cursorContext) {
        this.index.checkpoint(pageCursor -> pageCursor.putByte(state), cursorContext);
    }

    private void markTreeAsFailed(CursorContext cursorContext) {
        Preconditions.checkState((this.failureBytes != null ? 1 : 0) != 0, (String)"markAsFailed hasn't been called, populator not actually failed?");
        this.index.checkpoint((Consumer)new FailureHeaderWriter(this.failureBytes, 2), cursorContext);
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    public void includeSample(IndexEntryUpdate<?> update) {
    }

    public IndexSample sample(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Token indexes does not support index sampling");
    }

    private void assertNotDropped() {
        Preconditions.checkState((!this.dropped ? 1 : 0) != 0, (String)"Populator has already been dropped.");
    }

    private void assertNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Populator has already been closed.");
    }

    private void ensureTreeInstantiated() {
        if (this.index == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore(), GBPTree.NO_HEADER_WRITER);
        }
    }
}

