/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultEntityTokenIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;

class DefaultNodeLabelIndexCursor
extends DefaultEntityTokenIndexCursor<DefaultNodeLabelIndexCursor>
implements NodeLabelIndexCursor {
    private final DefaultNodeCursor securityNodeCursor;

    DefaultNodeLabelIndexCursor(CursorPool<DefaultNodeLabelIndexCursor> pool, DefaultNodeCursor securityNodeCursor) {
        super(pool);
        this.securityNodeCursor = securityNodeCursor;
    }

    @Override
    LongSet createAddedInTxState(TransactionState txState, int token) {
        return txState.nodesWithLabelChanged(token).getAdded().freeze();
    }

    @Override
    LongSet createDeletedInTxState(TransactionState txState, int token) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)txState.nodesWithLabelChanged(token).getRemoved());
    }

    @Override
    void traceScan(KernelReadTracer tracer, int token) {
        tracer.onLabelScan(token);
    }

    @Override
    void traceNext(KernelReadTracer tracer, long entity) {
        tracer.onNode(entity);
    }

    @Override
    boolean allowedToSeeAllEntitiesWithToken(AccessMode accessMode, int token) {
        return accessMode.allowsTraverseAllNodesWithLabel((long)token);
    }

    @Override
    boolean allowedToSeeEntity(AccessMode accessMode, long entityReference, TokenSet tokens) {
        if (tokens == null) {
            this.readEntity(read -> read.singleNode(entityReference, this.securityNodeCursor));
            return this.securityNodeCursor.next();
        }
        return accessMode.allowsTraverseNode(tokens.all());
    }

    public void node(NodeCursor cursor) {
        this.readEntity(read -> read.singleNode(this.entityReference(), cursor));
    }

    public long nodeReference() {
        return this.entityReference();
    }

    public float score() {
        return Float.NaN;
    }

    public TokenSet labels() {
        return this.tokens();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeLabelIndexCursor[closed state]";
        }
        return "NodeLabelIndexCursor[node=" + this.entityReference() + ", labels= " + this.tokens() + "]";
    }

    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
        }
    }
}

