/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.util.VisibleForTesting;

@VisibleForTesting
public abstract class TraceableCursor<CURSOR>
extends DefaultCloseListenable
implements Cursor {
    private final CursorPool<CURSOR> pool;
    protected KernelReadTracer tracer;
    private boolean returnedToPool;

    TraceableCursor(CursorPool<CURSOR> pool) {
        this.pool = pool;
    }

    public void setTracer(KernelReadTracer tracer) {
        this.tracer = tracer;
    }

    public void removeTracer() {
        this.tracer = null;
    }

    void acquire() {
        if (!this.returnedToPool) {
            throw new IllegalStateException(this + " hasn't been returned to pool yet");
        }
        this.returnedToPool = false;
    }

    public void closeInternal() {
        if (!this.returnedToPool) {
            this.pool.accept((CURSOR)((Object)this));
            this.returnedToPool = true;
        }
    }

    @VisibleForTesting
    public boolean returnedToPool() {
        return this.returnedToPool;
    }
}

