/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.util.Version;
import org.neo4j.shell.util.Versions;

public class UserMessagesHandler {
    private ConnectionConfig connectionConfig;
    private String protocolVersion;

    public UserMessagesHandler(ConnectionConfig connectionConfig, String protocolVersion) {
        this.connectionConfig = connectionConfig;
        this.protocolVersion = protocolVersion;
    }

    public String getWelcomeMessage() {
        Object neo4j = "Neo4j";
        if (!this.protocolVersion.isEmpty()) {
            Version version = Versions.version(this.protocolVersion);
            neo4j = (String)neo4j + " using Bolt protocol version " + version.major() + "." + version.minor();
        }
        AnsiFormattedText welcomeMessage = AnsiFormattedText.from("Connected to " + (String)neo4j + " at ").bold(this.connectionConfig.driverUrl());
        if (!this.connectionConfig.username().isEmpty()) {
            welcomeMessage = welcomeMessage.append(" as user ").bold(this.connectionConfig.username());
        }
        return welcomeMessage.append(".\nType ").bold(":help").append(" for a list of available commands or ").bold(":exit").append(" to exit the shell.").append("\nNote that Cypher queries must end with a ").bold("semicolon.").formattedString();
    }

    public static String getExitMessage() {
        return AnsiFormattedText.s().append("\nBye!").formattedString();
    }
}

