/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.Collections;
import java.util.List;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;

public class Use
implements Command {
    private static final String COMMAND_NAME = ":use";
    private final DatabaseManager databaseManager;

    public Use(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDescription() {
        return "Set the active database";
    }

    @Override
    public String getUsage() {
        return "database";
    }

    @Override
    public String getHelp() {
        return "Set the active database that transactions are executed on";
    }

    @Override
    public List<String> getAliases() {
        return Collections.emptyList();
    }

    @Override
    public void execute(String argString) throws ExitException, CommandException {
        String[] args = CommandHelper.simpleArgParse(argString, 0, 1, COMMAND_NAME, this.getUsage());
        String databaseName = args.length == 0 ? "" : args[0];
        this.databaseManager.setActiveDatabase(CommandHelper.stripEnclosingBackTicks(databaseName));
    }
}

