/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.primitive;

import java.util.EmptyStackException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.ObjectCharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.stack.primitive.CharStack;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

public abstract class AbstractCharStack
implements CharStack {
    protected abstract CharArrayList getDelegate();

    protected void checkEmptyStack() {
        if (this.getDelegate().isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public char peek() {
        this.checkEmptyStack();
        return this.getDelegate().getLast();
    }

    public CharList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new CharArrayList(0);
        }
        CharArrayList subList = new CharArrayList(count);
        int index = this.getDelegate().size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.getDelegate().get(index - i));
        }
        return subList;
    }

    public char peekAt(int index) {
        this.rangeCheck(index);
        return this.getDelegate().get(this.getDelegate().size() - 1 - index);
    }

    protected void rangeCheck(int index) {
        if (index < 0 || index > this.getDelegate().size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.getDelegate().size() - 1));
        }
    }

    protected void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    protected void checkSizeLessThanCount(int count) {
        if (this.getDelegate().size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.getDelegate().size());
        }
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.getDelegate().asReversed().charIterator());
    }

    public void each(CharProcedure procedure) {
        this.getDelegate().asReversed().forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.getDelegate().asReversed().count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.getDelegate().asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.getDelegate().asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.getDelegate().asReversed().noneSatisfy(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.getDelegate().asReversed().detectIfNone(predicate, ifNone);
    }

    public char[] toArray() {
        return this.getDelegate().asReversed().toArray();
    }

    public char[] toArray(char[] target) {
        return this.getDelegate().asReversed().toArray(target);
    }

    public boolean contains(char value) {
        return this.getDelegate().asReversed().contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public MutableCharList toList() {
        return CharArrayList.newList((CharIterable)this);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSet((CharIterable)this);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBag((CharIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectCharToObjectFunction<? super V, ? extends V> function) {
        return this.getDelegate().toReversed().injectInto(injectedValue, function);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public int size() {
        return this.getDelegate().size();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof CharStack)) {
            return false;
        }
        CharStack stack = (CharStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyCharIterable iterable = this.getDelegate().asReversed();
        CharIterator iterator = iterable.charIterator();
        while (iterator.hasNext()) {
            char item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.getDelegate().asReversed().toString();
    }

    public String makeString() {
        return this.getDelegate().asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.getDelegate().asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.getDelegate().asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.getDelegate().asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.getDelegate().asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.getDelegate().asReversed().appendString(appendable, start, separator, end);
    }

    public char getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(char value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectCharIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(CharIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public RichIterable<CharIterable> chunk(int size) {
        return this.getDelegate().asReversed().chunk(size);
    }

    public long sum() {
        return this.getDelegate().sum();
    }

    public char max() {
        return this.getDelegate().max();
    }

    public char min() {
        return this.getDelegate().min();
    }

    public char minIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public char maxIfEmpty(char defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        return this.getDelegate().average();
    }

    public double median() {
        return this.getDelegate().median();
    }

    public char[] toSortedArray() {
        return this.getDelegate().toSortedArray();
    }
}

