/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import inet.ipaddr.IPAddressString;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap$;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.LoadExternalResourceException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%h!\u0002\u0015*\u0003\u0003A\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u0005\u0003!\u0011!Q\u0001\n\tC\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005%\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015!\bA\"\u0005v\u0011\u001d\tY\u0002\u0001C\t\u0003;1a!!\u0010\u0001\t\u0005}\u0002BCA$\u0015\t\u0005\t\u0015!\u0003\u0002J!I\u0011\u0011\u0002\u0006\u0003\u0002\u0003\u0006IA\u001e\u0005\tw*\u0011\t\u0011)A\u00051\"Q\u0011q\r\u0006\u0003\u0002\u0003\u0006I!!\u001b\t\r-TA\u0011AA8\u0011%\tiH\u0003b\u0001\n\u0013\ty\b\u0003\u0005\u0002\b*\u0001\u000b\u0011BAA\u0011%\tII\u0003b\u0001\n\u0013\tY\tC\u0004\u0002\u000e*\u0001\u000b\u0011\u0002@\t\u0017\u0005=%\u00021AA\u0002\u0013%\u0011\u0011\u0013\u0005\f\u0003'S\u0001\u0019!a\u0001\n\u0013\t)\n\u0003\u0006\u0002\"*\u0001\r\u0011!Q!\nYD\u0011\"a)\u000b\u0001\u0004%I!!*\t\u0013\u0005\u001d&\u00021A\u0005\n\u0005%\u0006bBAW\u0015\u0001\u0006K\u0001\u001a\u0005\t\u0003_S\u0001\u0015\"\u0015\u00022\"9\u00111\u0017\u0006\u0005B\u0005\u0015\u0006bBA[\u0015\u0011\u0005\u0013q\u0017\u0005\b\u0003sSA\u0011BA\\\r\u0019\tY\f\u0001\u0003\u0002>\"I\u0011\u0011\u0002\u0010\u0003\u0002\u0003\u0006IA\u001e\u0005\twz\u0011\t\u0011)A\u00051\"Q\u0011q\r\u0010\u0003\u0002\u0003\u0006I!!\u001b\t\r-tB\u0011AA`\u0011!\tyK\bQ\u0005R\u0005E\u0006bBAZ=\u0011\u0005\u0013Q\u0015\u0005\b\u0003ksB\u0011IA\\\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a8\u0001\t#\n\tOA\nBEN$(/Y2u\u0019>\fGmQ*W!&\u0004XM\u0003\u0002+W\u0005)\u0001/\u001b9fg*\u0011A&L\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002/_\u00059!/\u001e8uS6,'B\u0001\u00192\u0003!Ig\u000e^3s]\u0006d'B\u0001\u001a4\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011A'N\u0001\u0006]\u0016|GG\u001b\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000f\t\u0003umj\u0011!K\u0005\u0003y%\u0012a\u0002U5qK^KG\u000f[*pkJ\u001cW-\u0001\u0004t_V\u00148-\u001a\t\u0003u}J!\u0001Q\u0015\u0003\tAK\u0007/Z\u0001\u0007M>\u0014X.\u0019;\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015{\u0013AA5s\u0013\t9EIA\u0005D'Z3uN]7bi\u0006iQO\u001d7FqB\u0014Xm]:j_:\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u001d.\n\u0001bY8n[\u0006tGm]\u0005\u0003!.\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003=1\u0017.\u001a7e)\u0016\u0014X.\u001b8bi>\u0014\bcA*W16\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0004PaRLwN\u001c\t\u00033\u0002t!A\u00170\u0011\u0005m#V\"\u0001/\u000b\u0005u;\u0014A\u0002\u001fs_>$h(\u0003\u0002`)\u00061\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF+\u0001\fmK\u001e\f7-_\"tmF+x\u000e^3Fg\u000e\f\u0007/\u001b8h!\t\u0019V-\u0003\u0002g)\n9!i\\8mK\u0006t\u0017A\u00032vM\u001a,'oU5{KB\u00111+[\u0005\u0003UR\u00131!\u00138u\u0003\u0019a\u0014N\\5u}Q9QN\\8qcJ\u001c\bC\u0001\u001e\u0001\u0011\u0015it\u00011\u0001?\u0011\u0015\tu\u00011\u0001C\u0011\u0015Au\u00011\u0001J\u0011\u0015\tv\u00011\u0001S\u0011\u0015\u0019w\u00011\u0001e\u0011\u00159w\u00011\u0001i\u0003!9(/\u001b;f%><H#\u0003<{y\u0006\r\u0011qAA\u0006!\t9\b0D\u0001.\u0013\tIXFA\u0005DsBDWM\u001d*po\")1\u0010\u0003a\u00011\u0006Aa-\u001b7f]\u0006lW\rC\u0003~\u0011\u0001\u0007a0\u0001\u0006mS:,g.^7cKJ\u0004\"aU@\n\u0007\u0005\u0005AK\u0001\u0003M_:<\u0007BBA\u0003\u0011\u0001\u0007A-\u0001\u0003mCN$\bBBA\u0005\u0011\u0001\u0007a/A\u0006be\u001e,X.\u001a8u%><\bbBA\u0007\u0011\u0001\u0007\u0011qB\u0001\u0006m\u0006dW/\u001a\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u001a\u0002\rY\fG.^3t\u0013\u0011\tI\"a\u0005\u0003\u0011\u0005s\u0017PV1mk\u0016\fAbZ3u\u00136\u0004xN\u001d;V%2#b!a\b\u00020\u0005M\u0002\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0004]\u0016$(BAA\u0015\u0003\u0011Q\u0017M^1\n\t\u00055\u00121\u0005\u0002\u0004+Jc\u0005BBA\u0019\u0013\u0001\u0007\u0001,A\u0005ve2\u001cFO]5oO\"9\u0011QG\u0005A\u0002\u0005]\u0012aB2p]R,\u0007\u0010\u001e\t\u0004o\u0006e\u0012bAA\u001e[\ta\u0011+^3ss\u000e{g\u000e^3yi\n\u0019\u0012\n^3sCR|'oV5uQ\"+\u0017\rZ3sgN\u0019!\"!\u0011\u0011\t]\f\u0019E^\u0005\u0004\u0003\u000bj#aD\"m_NLgnZ%uKJ\fGo\u001c:\u0002\u000f!,\u0017\rZ3sgB1\u00111JA+\u00037rA!!\u0014\u0002R9\u00191,a\u0014\n\u0003UK1!a\u0015U\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0016\u0002Z\t\u00191+Z9\u000b\u0007\u0005MC\u000b\u0005\u0003\u0002^\u0005\rTBAA0\u0015\u0011\t\t'a\u0005\u0002\u0011M$xN]1cY\u0016LA!!\u001a\u0002`\t)a+\u00197vK\u0006)\u0011N\u001c8feB\u0019!(a\u001b\n\u0007\u00055\u0014FA\bM_\u0006$7i\u001d<Ji\u0016\u0014\u0018\r^8s))\t\t(!\u001e\u0002x\u0005e\u00141\u0010\t\u0004\u0003gRQ\"\u0001\u0001\t\u000f\u0005\u001ds\u00021\u0001\u0002J!1\u0011\u0011B\bA\u0002YDQa_\bA\u0002aCq!a\u001a\u0010\u0001\u0004\tI'A\u0006j]R,'O\\1m\u001b\u0006\u0004XCAAA!\u00199\u00181\u0011-\u0002\u0010%\u0019\u0011QQ\u0017\u0003\u001d\u0005\u0013(/Y=CC\u000e\\W\rZ'ba\u0006a\u0011N\u001c;fe:\fG.T1qA\u0005y\u0011N\u001c;fe:\fG.T1q'&TX-F\u0001\u007f\u0003AIg\u000e^3s]\u0006dW*\u00199TSj,\u0007%\u0001\u0004oK^\u0014vn^\u000b\u0002m\u0006Qa.Z<S_^|F%Z9\u0015\t\u0005]\u0015Q\u0014\t\u0004'\u0006e\u0015bAAN)\n!QK\\5u\u0011!\ty*FA\u0001\u0002\u00041\u0018a\u0001=%c\u00059a.Z<S_^\u0004\u0013a\u00038fK\u0012\u001cX\u000b\u001d3bi\u0016,\u0012\u0001Z\u0001\u0010]\u0016,Gm]+qI\u0006$Xm\u0018\u0013fcR!\u0011qSAV\u0011!\ty\nGA\u0001\u0002\u0004!\u0017\u0001\u00048fK\u0012\u001cX\u000b\u001d3bi\u0016\u0004\u0013!C2m_N,Wj\u001c:f)\t\t9*\u0001\u0007j]:,'\u000fS1t\u001d\u0016DH/\u0001\u0003oKb$H#\u0001<\u0002\u001d\r|W\u000e];uK:+\u0007\u0010\u001e*po\n1\u0012\n^3sCR|'oV5uQ>,H\u000fS3bI\u0016\u00148oE\u0002\u001f\u0003\u0003\"\u0002\"!1\u0002D\u0006\u0015\u0017q\u0019\t\u0004\u0003gr\u0002BBA\u0005E\u0001\u0007a\u000fC\u0003|E\u0001\u0007\u0001\fC\u0004\u0002h\t\u0002\r!!\u001b\u0002%\u001d,G\u000fT8bI\u000e\u001bf+\u0013;fe\u0006$xN\u001d\u000b\t\u0003S\ni-a6\u0002\\\"9\u0011q\u001a\u0014A\u0002\u0005E\u0017!B:uCR,\u0007c\u0001\u001e\u0002T&\u0019\u0011Q[\u0015\u0003\u0015E+XM]=Ti\u0006$X\rC\u0004\u0002Z\u001a\u0002\r!a\b\u0002\u0007U\u0014H\u000e\u0003\u0004\u0002^\u001a\u0002\r\u0001Z\u0001\u000bkN,\u0007*Z1eKJ\u001c\u0018!F5oi\u0016\u0014h.\u00197De\u0016\fG/\u001a*fgVdGo\u001d\u000b\u0007\u0003\u0003\n\u0019/a:\t\u000f\u0005\u0015x\u00051\u0001\u0002B\u0005)\u0011N\u001c9vi\"9\u0011qZ\u0014A\u0002\u0005E\u0007")
public abstract class AbstractLoadCSVPipe
extends PipeWithSource {
    private final CSVFormat format;
    private final Expression urlExpression;
    private final Option<String> fieldTerminator;
    private final boolean legacyCsvQuoteEscaping;
    private final int bufferSize;

    public abstract CypherRow writeRow(String var1, long var2, boolean var4, CypherRow var5, AnyValue var6);

    public URL getImportURL(String urlString, QueryContext context) {
        URL urlToLoad;
        URL uRL;
        try {
            uRL = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new LoadExternalResourceException(new StringBuilder(16).append("Invalid URL '").append(urlString).append("': ").append(e.getMessage()).toString(), (Throwable)e);
        }
        URL url = uRL;
        Either either = context.getImportURL(url);
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            throw new LoadExternalResourceException(new StringBuilder(25).append("Cannot load from URL '").append(urlString).append("': ").append(error).toString());
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        URL uRL2 = urlToLoad = (URL)right.value();
        return uRL2;
    }

    private LoadCsvIterator getLoadCSVIterator(QueryState state, URL url, boolean useHeaders) {
        java.util.List ipBlocklist = (java.util.List)state.query().getConfig().get(GraphDatabaseInternalSettings.cypher_ip_blocklist);
        List ipBlocklistAsScala = ipBlocklist != null ? ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)ipBlocklist).asScala()).toList() : List$.MODULE$.empty();
        return state.resources().getCsvIterator(url, (List<IPAddressString>)ipBlocklistAsScala, this.fieldTerminator, this.legacyCsvQuoteEscaping, this.bufferSize, useHeaders);
    }

    @Override
    public ClosingIterator<CypherRow> internalCreateResults(ClosingIterator<CypherRow> input, QueryState state) {
        return input.flatMap((Function1 & Serializable & scala.Serializable)row -> {
            ClosingIterator closingIterator;
            TextValue urlString = (TextValue)$this.urlExpression.apply((ReadableRow)row, state);
            URL url = this.getImportURL(urlString.stringValue(), state.query());
            CSVFormat cSVFormat = $this.format;
            if (HasHeaders$.MODULE$.equals(cSVFormat)) {
                LoadCsvIterator iterator = this.getLoadCSVIterator(state, url, true);
                IndexedSeq headers = ((TraversableOnce)iterator).nonEmpty() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Iterator)iterator).next())).toIndexedSeq() : (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
                closingIterator = new IteratorWithHeaders(this, (Seq<Value>)headers, (CypherRow)row, url.getFile(), iterator);
            } else if (NoHeaders$.MODULE$.equals(cSVFormat)) {
                closingIterator = new IteratorWithoutHeaders(this, (CypherRow)row, url.getFile(), this.getLoadCSVIterator(state, url, false));
            } else {
                throw new MatchError((Object)cSVFormat);
            }
            return closingIterator;
        });
    }

    public AbstractLoadCSVPipe(Pipe source, CSVFormat format, Expression urlExpression, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize) {
        this.format = format;
        this.urlExpression = urlExpression;
        this.fieldTerminator = fieldTerminator;
        this.legacyCsvQuoteEscaping = legacyCsvQuoteEscaping;
        this.bufferSize = bufferSize;
        super(source);
    }

    private class IteratorWithHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        private final ArrayBackedMap<String, AnyValue> internalMap;
        private final long internalMapSize;
        private CypherRow newRow;
        private boolean needsUpdate;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        private ArrayBackedMap<String, AnyValue> internalMap() {
            return this.internalMap;
        }

        private long internalMapSize() {
            return this.internalMapSize;
        }

        private CypherRow newRow() {
            return this.newRow;
        }

        private void newRow_$eq(CypherRow x$1) {
            this.newRow = x$1;
        }

        private boolean needsUpdate() {
            return this.needsUpdate;
        }

        private void needsUpdate_$eq(boolean x$1) {
            this.needsUpdate = x$1;
        }

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            if (this.needsUpdate()) {
                this.newRow_$eq(this.computeNextRow());
                this.needsUpdate_$eq(false);
            }
            return this.newRow() != null;
        }

        public CypherRow next() {
            Object object = !this.hasNext() ? package$.MODULE$.Iterator().empty().next() : BoxedUnit.UNIT;
            this.needsUpdate_$eq(true);
            return this.newRow();
        }

        private CypherRow computeNextRow() {
            CypherRow cypherRow;
            if (((ClosingIterator)this.inner).hasNext()) {
                Value[] row = (Value[])((Iterator)this.inner).next();
                this.internalMap().putValues((Object)((AnyValue[])row));
                java.util.Map internalMapCopy = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.internalMap().copy()).asJava();
                long payloadSize = 0L;
                for (int i = 0; i < row.length; ++i) {
                    payloadSize += row[i].estimatedHeapUsage();
                }
                MapValue mapValue = VirtualValues.fromMap((java.util.Map)internalMapCopy, (long)this.internalMapSize(), (long)payloadSize);
                cypherRow = this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)mapValue);
            } else {
                cypherRow = null;
            }
            return cypherRow;
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithHeaders(AbstractLoadCSVPipe $outer, Seq<Value> headers, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.internalMap = new ArrayBackedMap(((TraversableOnce)((IterableLike)headers.map((Function1 & Serializable & scala.Serializable)a -> a == Values.NO_VALUE ? null : ((TextValue)a).stringValue(), Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (Object)Values.NO_VALUE, ClassTag$.MODULE$.apply(AnyValue.class));
            this.internalMapSize = ArrayBackedMap$.MODULE$.SHALLOW_SIZE() + HeapEstimator.shallowSizeOfObjectArray((int)headers.size());
            this.needsUpdate = true;
        }
    }

    private class IteratorWithoutHeaders
    extends ClosingIterator<CypherRow> {
        private final CypherRow argumentRow;
        private final String filename;
        private final LoadCsvIterator inner;
        public final /* synthetic */ AbstractLoadCSVPipe $outer;

        public void closeMore() {
            ((ClosingIterator)this.inner).close();
        }

        public boolean innerHasNext() {
            return ((ClosingIterator)this.inner).hasNext();
        }

        public CypherRow next() {
            ListValue value = VirtualValues.list((AnyValue[])((AnyValue[])((Iterator)this.inner).next()));
            return this.org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer().writeRow(this.filename, this.inner.lastProcessed(), this.inner.readAll(), this.argumentRow, (AnyValue)value);
        }

        public /* synthetic */ AbstractLoadCSVPipe org$neo4j$cypher$internal$runtime$interpreted$pipes$AbstractLoadCSVPipe$IteratorWithoutHeaders$$$outer() {
            return this.$outer;
        }

        public IteratorWithoutHeaders(AbstractLoadCSVPipe $outer, CypherRow argumentRow, String filename, LoadCsvIterator inner) {
            this.argumentRow = argumentRow;
            this.filename = filename;
            this.inner = inner;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

