/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import java.util.Objects;
import org.neo4j.util.Preconditions;

public interface IdSlotDistribution {
    public static final IdSlotDistribution SINGLE_IDS;

    public static IdSlotDistribution evenSlotDistribution(int ... slotSizes) {
        return IdSlotDistribution.evenSlotDistribution(128, slotSizes);
    }

    public static IdSlotDistribution evenSlotDistribution(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                int capacityPerSlot = this.nearestHigherPowerOfTwo(capacity / slotSizes.length);
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacityPerSlot, slotSizes[i]);
                }
                return slots;
            }

            private int nearestHigherPowerOfTwo(int value) {
                return Integer.bitCount(value) == 1 ? value : Integer.highestOneBit(value) << 1;
            }
        };
    }

    public static IdSlotDistribution diminishingSlotDistribution(int ... slotSizes) {
        return IdSlotDistribution.diminishingSlotDistribution(128, slotSizes);
    }

    public static IdSlotDistribution diminishingSlotDistribution(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacity / (1 << i + 1), slotSizes[i]);
                }
                return slots;
            }
        };
    }

    public static IdSlotDistribution allWithSameCapacity(int ... slotSizes) {
        return IdSlotDistribution.allWithSameCapacity(128, slotSizes);
    }

    public static IdSlotDistribution allWithSameCapacity(int idsPerEntry, final int ... slotSizes) {
        return new BaseIdSlotDistribution(idsPerEntry){

            @Override
            public Slot[] slots(int capacity) {
                Slot[] slots = new Slot[slotSizes.length];
                for (int i = 0; i < slotSizes.length; ++i) {
                    slots[i] = new Slot(capacity, slotSizes[i]);
                }
                return slots;
            }
        };
    }

    public static int[] powerTwoSlotSizesDownwards(int highSlotSize) {
        Preconditions.checkArgument((Integer.bitCount(highSlotSize) == 1 ? 1 : 0) != 0, (String)"Requires a power of two");
        int[] slots = new int[Integer.numberOfTrailingZeros(highSlotSize) + 1];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = 1 << i;
        }
        return slots;
    }

    public Slot[] slots(int var1);

    default public int idsPerEntry() {
        return 128;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static abstract class BaseIdSlotDistribution
    implements IdSlotDistribution {
        private final int idsPerEntry;

        BaseIdSlotDistribution(int idsPerEntry) {
            this.idsPerEntry = idsPerEntry;
        }

        @Override
        public int idsPerEntry() {
            return this.idsPerEntry;
        }
    }

    public static class Slot {
        private final int capacity;
        private final int slotSize;

        public Slot(int capacity, int slotSize) {
            this.capacity = capacity;
            this.slotSize = slotSize;
        }

        public int capacity() {
            return this.capacity;
        }

        public int slotSize() {
            return this.slotSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Slot slot = (Slot)o;
            return this.capacity == slot.capacity && this.slotSize == slot.slotSize;
        }

        public int hashCode() {
            return Objects.hash(this.capacity, this.slotSize);
        }

        public String toString() {
            return "Slot{capacity=" + this.capacity + ", slotSize=" + this.slotSize + "}";
        }
    }
}

