/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.DatabaseManagementServiceImpl;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.DefaultDatabaseInitializer;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.UnableToStartDatabaseException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.collector.DataCollector;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.database.DatabaseSizeServiceImpl;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.StatusDetailsAccessor;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.builtin.BuiltInDbmsProcedures;
import org.neo4j.procedure.builtin.SpecialBuiltInProcedures;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.ProcedureLoginContextTransformer;
import org.neo4j.procedure.impl.ProcedureTransactionProvider;
import org.neo4j.procedure.impl.TerminationGuardProvider;
import org.neo4j.procedure.impl.TransactionStatusDetailsProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.web.DisabledNeoWebServer;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

public class DatabaseManagementServiceFactory {
    protected final DbmsInfo dbmsInfo;
    private final Function<GlobalModule, AbstractEditionModule> editionFactory;

    public DatabaseManagementServiceFactory(DbmsInfo dbmsInfo, Function<GlobalModule, AbstractEditionModule> editionFactory) {
        this.dbmsInfo = dbmsInfo;
        this.editionFactory = editionFactory;
    }

    public DatabaseManagementService build(Config config, ExternalDependencies dependencies) {
        GlobalModule globalModule = this.createGlobalModule(config, dependencies);
        AbstractEditionModule edition = this.editionFactory.apply(globalModule);
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        LifeSupport globalLife = globalModule.getGlobalLife();
        LogService logService = globalModule.getLogService();
        Log internalLog = logService.getInternalLog(this.getClass());
        DatabaseManager databaseManager = edition.createDatabaseManager(globalModule);
        DatabaseManagementService managementService = this.createManagementService(globalModule, globalLife, internalLog, databaseManager);
        globalDependencies.satisfyDependencies(new Object[]{managementService});
        globalDependencies.satisfyDependency((Object)new DatabaseSizeServiceImpl(databaseManager));
        DatabaseInfoService databaseInfoService = edition.createDatabaseInfoService(databaseManager);
        globalDependencies.satisfyDependencies(new Object[]{databaseInfoService});
        edition.bootstrapFabricServices();
        edition.createDefaultDatabaseResolver(globalModule);
        globalDependencies.satisfyDependency((Object)edition.getDefaultDatabaseResolver());
        DatabaseManagementServiceFactory.setupProcedures(globalModule, edition, databaseManager);
        edition.registerSystemGraphComponents(globalModule.getSystemGraphComponents(), globalModule);
        globalLife.add((Lifecycle)edition.createSystemGraphInitializer(globalModule));
        DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(globalModule.getGlobalConfig());
        globalModule.getSystemGraphComponents().register((SystemGraphComponent)dbmsRuntimeSystemGraphComponent);
        edition.createSecurityModule(globalModule);
        SecurityProvider securityProvider = edition.getSecurityProvider();
        globalDependencies.satisfyDependencies(new Object[]{securityProvider.authManager()});
        DbmsRuntimeRepository dbmsRuntimeRepository = edition.createAndRegisterDbmsRuntimeRepository(globalModule, databaseManager, globalDependencies, dbmsRuntimeSystemGraphComponent);
        globalDependencies.satisfyDependency((Object)dbmsRuntimeRepository);
        globalLife.add((Lifecycle)new DefaultDatabaseInitializer(databaseManager));
        globalLife.add((Lifecycle)globalModule.getGlobalExtensions());
        BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI = edition.createBoltDatabaseManagementServiceProvider(globalDependencies, managementService, globalModule.getGlobalMonitors(), globalModule.getGlobalClock(), logService);
        globalLife.add((Lifecycle)DatabaseManagementServiceFactory.createBoltServer(globalModule, edition, boltGraphDatabaseManagementServiceSPI, (DatabaseIdRepository)databaseManager.databaseIdRepository()));
        Lifecycle webServer = this.createWebServer(edition, managementService, globalDependencies, config, globalModule.getLogService().getUserLogProvider());
        globalDependencies.satisfyDependency((Object)webServer);
        globalLife.add(webServer);
        globalLife.add((Lifecycle)globalModule.getCapabilitiesService());
        DatabaseManagementServiceFactory.startDatabaseServer(globalModule, globalLife, internalLog, databaseManager, managementService);
        DatabaseManagementServiceFactory.dumpDbmsInfo(logService.getUserLog(this.getClass()), (GraphDatabaseAPI)((DatabaseContext)databaseManager.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).get()).databaseFacade());
        return managementService;
    }

    protected DatabaseManagementService createManagementService(GlobalModule globalModule, LifeSupport globalLife, Log internalLog, DatabaseManager<?> databaseManager) {
        return new DatabaseManagementServiceImpl(databaseManager, (Lifecycle)globalLife, globalModule.getDatabaseEventListeners(), globalModule.getTransactionEventListeners(), internalLog, globalModule.getGlobalConfig());
    }

    private Lifecycle createWebServer(AbstractEditionModule edition, DatabaseManagementService managementService, Dependencies globalDependencies, Config config, LogProvider userLogProvider) {
        if (DatabaseManagementServiceFactory.shouldEnableWebServer(config)) {
            return edition.createWebServer(managementService, globalDependencies, config, userLogProvider, this.dbmsInfo);
        }
        return new DisabledNeoWebServer();
    }

    private static boolean shouldEnableWebServer(Config config) {
        return ((Boolean)config.get(HttpConnector.enabled) != false || (Boolean)config.get(HttpsConnector.enabled) != false) && !((Set)config.get(ServerSettings.http_enabled_modules)).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startDatabaseServer(GlobalModule globalModule, LifeSupport globalLife, Log internalLog, DatabaseManager<?> databaseManager, DatabaseManagementService managementService) {
        Throwable startupException = null;
        try {
            databaseManager.initialiseSystemDatabase();
            globalLife.start();
            DatabaseStateService databaseStateService = (DatabaseStateService)globalModule.getGlobalDependencies().resolveDependency(DatabaseStateService.class);
            DatabaseManagementServiceFactory.verifySystemDatabaseStart(databaseManager, databaseStateService);
        }
        catch (Throwable throwable) {
            String message = "Error starting Neo4j database server at " + globalModule.getNeo4jLayout().databasesDirectory();
            startupException = new RuntimeException(message, throwable);
            internalLog.error(message, throwable);
        }
        finally {
            if (startupException != null) {
                try {
                    managementService.shutdown();
                }
                catch (Throwable shutdownError) {
                    startupException.addSuppressed(shutdownError);
                }
            }
        }
        if (startupException != null) {
            internalLog.error("Failed to start database server.", startupException);
            throw startupException;
        }
    }

    private static void verifySystemDatabaseStart(DatabaseManager<?> databaseManager, DatabaseStateService dbStateService) {
        Optional databaseContext = databaseManager.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        if (databaseContext.isEmpty()) {
            throw new UnableToStartDatabaseException("system not found.");
        }
        Optional failure = dbStateService.causeOfFailure(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        if (failure.isPresent()) {
            throw new UnableToStartDatabaseException("system failed to start.", (Throwable)failure.get());
        }
    }

    protected GlobalModule createGlobalModule(Config config, ExternalDependencies dependencies) {
        return new GlobalModule(config, this.dbmsInfo, dependencies);
    }

    private static void setupProcedures(GlobalModule globalModule, AbstractEditionModule editionModule, DatabaseManager<?> databaseManager) {
        CommunityEditionModule.tryResolveOrCreate(ClientRoutingDomainChecker.class, (DependencyResolver)globalModule.getGlobalDependencies(), () -> editionModule.createClientRoutingDomainChecker(globalModule));
        Supplier<GlobalProcedures> procedureInitializer = () -> {
            Config globalConfig = globalModule.getGlobalConfig();
            java.nio.file.Path proceduresDirectory = (java.nio.file.Path)globalConfig.get(GraphDatabaseSettings.plugin_dir);
            LogService logService = globalModule.getLogService();
            Log internalLog = logService.getInternalLog(GlobalProcedures.class);
            Log proceduresLog = logService.getUserLog(GlobalProcedures.class);
            ProcedureConfig procedureConfig = new ProcedureConfig(globalConfig);
            Edition neo4jEdition = globalModule.getDbmsInfo().edition;
            SpecialBuiltInProcedures builtInProcedures = new SpecialBuiltInProcedures(Version.getNeo4jVersion(), neo4jEdition.toString());
            GlobalProceduresRegistry globalProcedures = new GlobalProceduresRegistry((ThrowingConsumer)builtInProcedures, proceduresDirectory, internalLog, procedureConfig);
            globalProcedures.registerType(Node.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
            globalProcedures.registerType(NodeValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTNode);
            globalProcedures.registerType(Relationship.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
            globalProcedures.registerType(RelationshipValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTRelationship);
            globalProcedures.registerType(Path.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
            globalProcedures.registerType(PathValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPath);
            globalProcedures.registerType(Geometry.class, (Neo4jTypes.AnyType)Neo4jTypes.NTGeometry);
            globalProcedures.registerType(Point.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPoint);
            globalProcedures.registerType(PointValue.class, (Neo4jTypes.AnyType)Neo4jTypes.NTPoint);
            globalProcedures.registerComponent(DependencyResolver.class, Context::dependencyResolver, false);
            globalProcedures.registerComponent(KernelTransaction.class, ctx -> ctx.internalTransaction().kernelTransaction(), false);
            globalProcedures.registerComponent(GraphDatabaseAPI.class, Context::graphDatabaseAPI, false);
            globalProcedures.registerComponent(SystemGraphComponents.class, ctx -> globalModule.getSystemGraphComponents(), false);
            globalProcedures.registerComponent(DataCollector.class, ctx -> (DataCollector)ctx.dependencyResolver().resolveDependency(DataCollector.class), false);
            globalProcedures.registerComponent(Log.class, ctx -> proceduresLog, true);
            globalProcedures.registerComponent(Transaction.class, (ThrowingFunction)new ProcedureTransactionProvider(), true);
            globalProcedures.registerComponent(TerminationGuard.class, (ThrowingFunction)new TerminationGuardProvider(), true);
            globalProcedures.registerComponent(StatusDetailsAccessor.class, (ThrowingFunction)new TransactionStatusDetailsProvider(), true);
            globalProcedures.registerComponent(SecurityContext.class, Context::securityContext, true);
            globalProcedures.registerComponent(ProcedureCallContext.class, Context::procedureCallContext, true);
            globalProcedures.registerComponent(FulltextAdapter.class, ctx -> (FulltextAdapter)ctx.dependencyResolver().resolveDependency(FulltextAdapter.class), true);
            globalProcedures.registerComponent(GraphDatabaseService.class, ctx -> new GraphDatabaseFacade((GraphDatabaseFacade)ctx.graphDatabaseAPI(), (Function)new ProcedureLoginContextTransformer(ctx)), true);
            globalProcedures.registerComponent(ValueMapper.class, Context::valueMapper, true);
            try {
                editionModule.registerProcedures((GlobalProcedures)globalProcedures, procedureConfig, globalModule, databaseManager);
            }
            catch (KernelException e) {
                internalLog.error("Failed to register built-in edition procedures at start up: " + e.getMessage());
            }
            globalModule.getGlobalLife().add((Lifecycle)globalProcedures);
            return globalProcedures;
        };
        GlobalProcedures procedures = CommunityEditionModule.tryResolveOrCreate(GlobalProcedures.class, globalModule.getExternalDependencyResolver(), procedureInitializer);
        if (procedures instanceof Consumer) {
            ((Consumer)procedures).accept(procedureInitializer);
        }
        globalModule.getGlobalDependencies().satisfyDependency((Object)procedures);
    }

    private static BoltServer createBoltServer(GlobalModule globalModule, AbstractEditionModule edition, BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, DatabaseIdRepository databaseIdRepository) {
        return new BoltServer(boltGraphDatabaseManagementServiceSPI, globalModule.getJobScheduler(), globalModule.getConnectorPortRegister(), edition.getConnectionTracker(), databaseIdRepository, globalModule.getGlobalConfig(), globalModule.getGlobalClock(), globalModule.getGlobalMonitors(), globalModule.getLogService(), (DependencyResolver)globalModule.getGlobalDependencies(), edition.getBoltAuthManager((DependencyResolver)globalModule.getGlobalDependencies()), edition.getBoltInClusterAuthManager(), edition.getBoltLoopbackAuthManager(), globalModule.getMemoryPools(), edition.getDefaultDatabaseResolver(), globalModule.getCentralBufferMangerHolder(), globalModule.getTransactionManager());
    }

    private static void dumpDbmsInfo(Log log, GraphDatabaseAPI system) {
        try {
            Class<BuiltInDbmsProcedures.SystemInfo> systemInfoClass = BuiltInDbmsProcedures.SystemInfo.class;
            Field[] fields = systemInfoClass.getFields();
            for (BuiltInDbmsProcedures.SystemInfo info : BuiltInDbmsProcedures.dbmsInfo((GraphDatabaseAPI)system).collect(Collectors.toList())) {
                for (Field field : fields) {
                    log.info(field.getName() + ": " + field.get(info));
                }
            }
        }
        catch (Exception e) {
            log.info("Unable to dump DBMS information", (Throwable)e);
        }
    }
}

