/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import org.eclipse.jetty.util.StringUtil;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.LocksFactory;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.service.Services;
import org.neo4j.time.SystemNanoClock;

public final class EditionLocksFactories {
    private static final String OLD_COMMUNITY_LOCK_MANAGER_NAME = "community";

    private EditionLocksFactories() {
    }

    public static Locks createLockManager(LocksFactory locksFactory, Config config, SystemNanoClock clock) {
        return locksFactory.newInstance(config, clock);
    }

    public static LocksFactory createLockFactory(Config config, LogService logService) {
        Log lockFactoriesLog = logService.getInternalLog(EditionLocksFactories.class);
        LocksFactory locksFactory = EditionLocksFactories.getLocksFactory((String)config.get(GraphDatabaseInternalSettings.lock_manager), lockFactoriesLog);
        lockFactoriesLog.info("Locking implementation '" + locksFactory.getName() + "' selected.");
        return locksFactory;
    }

    private static LocksFactory getLocksFactory(String key, Log lockFactoriesLog) {
        String factoryKey = EditionLocksFactories.checkForOldCommunityValue(lockFactoriesLog, key);
        if (StringUtil.isEmpty((String)factoryKey)) {
            return (LocksFactory)Services.loadByPriority(LocksFactory.class).orElseThrow(() -> new IllegalArgumentException("No lock manager found"));
        }
        return (LocksFactory)Services.load(LocksFactory.class, (String)factoryKey).orElseThrow(() -> new IllegalArgumentException("No lock manager found with the name '" + key + "'."));
    }

    private static String checkForOldCommunityValue(Log lockFactoriesLog, String factoryKey) {
        if (OLD_COMMUNITY_LOCK_MANAGER_NAME.equals(factoryKey)) {
            lockFactoriesLog.warn("Old community lock manager is configured to be used. Ignoring and fallback to default lock manager.");
            return "forseti";
        }
        return factoryKey;
    }
}

