/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.eclipse.collections.api.block.procedure.primitive.LongFloatProcedure;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;

class FulltextResultCollector
implements Collector {
    private static final int NO_LIMIT = -1;
    private final long limit;
    private final EntityScorePriorityQueue pq;
    private final LongPredicate exclusionFilter;

    FulltextResultCollector(IndexQueryConstraints constraints, LongPredicate exclusionFilter) {
        this.exclusionFilter = exclusionFilter;
        this.limit = FulltextResultCollector.getLimit(constraints);
        this.pq = this.limit == -1L ? new EntityScorePriorityQueue() : new EntityScorePriorityQueue(false);
    }

    public ValuesIterator iterator() {
        if (this.pq.isEmpty()) {
            return ValuesIterator.EMPTY;
        }
        if (this.limit == -1L) {
            return new EntityResultsMaxQueueIterator(this.pq);
        }
        return new EntityResultsMinQueueIterator(this.pq);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new ScoredEntityLeafCollector(context, this.pq, this.limit, this.exclusionFilter);
    }

    public ScoreMode scoreMode() {
        return this.limit == -1L ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
    }

    private static long getLimit(IndexQueryConstraints constraints) {
        if (constraints.limit().isPresent()) {
            long limit = constraints.limit().getAsLong() + constraints.skip().orElse(0L);
            if (limit < Integer.MAX_VALUE) {
                return limit;
            }
            return -1L;
        }
        return -1L;
    }

    static class EntityResultsMinQueueIterator
    implements ValuesIterator,
    LongFloatProcedure {
        private final long[] entityIds;
        private final float[] scores;
        private int index;

        EntityResultsMinQueueIterator(EntityScorePriorityQueue pq) {
            int size = pq.size();
            this.entityIds = new long[size];
            this.scores = new float[size];
            this.index = size - 1;
            while (!pq.isEmpty()) {
                pq.removeTop(this);
            }
        }

        public int remaining() {
            return 0;
        }

        public long next() {
            if (this.hasNext()) {
                ++this.index;
                return this.current();
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.index < this.entityIds.length - 1;
        }

        public long current() {
            return this.entityIds[this.index];
        }

        public float currentScore() {
            return this.scores[this.index];
        }

        public void value(long entityId, float score) {
            this.entityIds[this.index] = entityId;
            this.scores[this.index] = score;
            --this.index;
        }
    }

    static class EntityResultsMaxQueueIterator
    implements ValuesIterator,
    LongFloatProcedure {
        private final EntityScorePriorityQueue pq;
        private long currentEntity;
        private float currentScore;

        EntityResultsMaxQueueIterator(EntityScorePriorityQueue pq) {
            this.pq = pq;
        }

        public int remaining() {
            return 0;
        }

        public float currentScore() {
            return this.currentScore;
        }

        public long next() {
            if (this.hasNext()) {
                this.pq.removeTop(this);
                return this.currentEntity;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return !this.pq.isEmpty();
        }

        public long current() {
            return this.currentEntity;
        }

        public void value(long entityId, float score) {
            this.currentEntity = entityId;
            this.currentScore = score;
        }
    }

    static class EntityScorePriorityQueue {
        private static final int ROOT = 1;
        private static final int INITIAL_CAPACITY = 33;
        private final boolean maxQueue;
        private long[] entities;
        private float[] scores;
        private int size;

        EntityScorePriorityQueue() {
            this(true);
        }

        EntityScorePriorityQueue(boolean maxQueue) {
            this.maxQueue = maxQueue;
            this.entities = new long[33];
            this.scores = new float[33];
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void insert(long entityId, float score) {
            ++this.size;
            if (this.size == this.entities.length) {
                this.growCapacity();
            }
            this.entities[this.size] = entityId;
            this.scores[this.size] = score;
            this.liftTowardsRoot(this.size);
        }

        public float peekTopScore() {
            return this.scores[1];
        }

        public void removeTop(LongFloatProcedure receiver) {
            receiver.value(this.entities[1], this.scores[1]);
            this.removeTop();
        }

        public void removeTop() {
            this.swap(1, this.size);
            --this.size;
            this.pushTowardsBottom();
        }

        private void growCapacity() {
            this.entities = Arrays.copyOf(this.entities, this.entities.length * 2);
            this.scores = Arrays.copyOf(this.scores, this.scores.length * 2);
        }

        private void liftTowardsRoot(int index) {
            int parentIndex;
            while (index > 1 && this.subordinate(parentIndex = index >> 1, index)) {
                this.swap(index, parentIndex);
                index = parentIndex;
            }
        }

        private void pushTowardsBottom() {
            int child;
            int index = 1;
            while ((child = index << 1) <= this.size) {
                if (child < this.size && this.subordinate(child, child + 1)) {
                    ++child;
                }
                if (!this.subordinate(index, child)) break;
                this.swap(index, child);
                index = child;
            }
        }

        private boolean subordinate(int indexA, int indexB) {
            float scoreA = this.scores[indexA];
            float scoreB = this.scores[indexB];
            return this.maxQueue ? scoreA < scoreB : scoreA > scoreB;
        }

        private void swap(int indexA, int indexB) {
            long entity = this.entities[indexA];
            float score = this.scores[indexA];
            this.entities[indexA] = this.entities[indexB];
            this.scores[indexA] = this.scores[indexB];
            this.entities[indexB] = entity;
            this.scores[indexB] = score;
        }
    }

    private static class ScoredEntityLeafCollector
    implements LeafCollector {
        private final EntityScorePriorityQueue pq;
        private final long limit;
        private final LongPredicate exclusionFilter;
        private final NumericDocValues values;
        private Scorable scorer;
        private float minCompetitiveScore;

        ScoredEntityLeafCollector(LeafReaderContext context, EntityScorePriorityQueue pq, long limit, LongPredicate exclusionFilter) throws IOException {
            this.pq = pq;
            this.limit = limit;
            this.exclusionFilter = exclusionFilter;
            LeafReader reader = context.reader();
            this.values = reader.getNumericDocValues("__neo4j__lucene__fulltext__index__internal__id__");
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
            this.minCompetitiveScore = 0.0f;
            this.updateMinCompetitiveScore(scorer);
        }

        public void collect(int doc) throws IOException {
            assert (this.scorer.docID() == doc);
            if (this.values.advanceExact(doc)) {
                long entityId = this.values.longValue();
                float score = this.scorer.score();
                if (this.exclusionFilter.test(entityId)) {
                    return;
                }
                if (this.limit == -1L) {
                    this.pq.insert(entityId, score);
                } else if ((long)this.pq.size() < this.limit) {
                    this.pq.insert(entityId, score);
                    this.updateMinCompetitiveScore(this.scorer);
                } else if (this.pq.peekTopScore() < score) {
                    this.pq.removeTop();
                    this.pq.insert(entityId, score);
                    this.updateMinCompetitiveScore(this.scorer);
                }
            } else {
                throw new RuntimeException("No document value for document id " + doc + ".");
            }
        }

        private void updateMinCompetitiveScore(Scorable scorer) throws IOException {
            float localMinScore;
            if (this.limit != -1L && (long)this.pq.size() >= this.limit && (localMinScore = Math.nextUp(this.pq.peekTopScore())) > this.minCompetitiveScore) {
                scorer.setMinCompetitiveScore(localMinScore);
                this.minCompetitiveScore = localMinScore;
            }
        }
    }
}

