/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.cache;

import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.DynamicByteArray;
import org.neo4j.internal.batchimport.cache.DynamicIntArray;
import org.neo4j.internal.batchimport.cache.DynamicLongArray;
import org.neo4j.internal.batchimport.cache.IntArray;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.memory.MemoryTracker;

public interface NumberArrayFactory {
    default public IntArray newIntArray(long length, int defaultValue, MemoryTracker memoryTracker) {
        return this.newIntArray(length, defaultValue, 0L, memoryTracker);
    }

    public IntArray newIntArray(long var1, int var3, long var4, MemoryTracker var6);

    public IntArray newDynamicIntArray(long var1, int var3, MemoryTracker var4);

    default public LongArray newLongArray(long length, long defaultValue, MemoryTracker memoryTracker) {
        return this.newLongArray(length, defaultValue, 0L, memoryTracker);
    }

    public LongArray newLongArray(long var1, long var3, long var5, MemoryTracker var7);

    public LongArray newDynamicLongArray(long var1, long var3, MemoryTracker var5);

    default public ByteArray newByteArray(long length, byte[] defaultValue, MemoryTracker memoryTracker) {
        return this.newByteArray(length, defaultValue, 0L, memoryTracker);
    }

    public ByteArray newByteArray(long var1, byte[] var3, long var4, MemoryTracker var6);

    public ByteArray newDynamicByteArray(long var1, byte[] var3, MemoryTracker var4);

    public static abstract class Adapter
    implements NumberArrayFactory {
        @Override
        public IntArray newDynamicIntArray(long chunkSize, int defaultValue, MemoryTracker memoryTracker) {
            return new DynamicIntArray(this, chunkSize, defaultValue, memoryTracker);
        }

        @Override
        public LongArray newDynamicLongArray(long chunkSize, long defaultValue, MemoryTracker memoryTracker) {
            return new DynamicLongArray(this, chunkSize, defaultValue, memoryTracker);
        }

        @Override
        public ByteArray newDynamicByteArray(long chunkSize, byte[] defaultValue, MemoryTracker memoryTracker) {
            return new DynamicByteArray(this, chunkSize, defaultValue, memoryTracker);
        }
    }

    public static class AllocationFailure {
        private final Throwable failure;
        private final NumberArrayFactory factory;

        AllocationFailure(Throwable failure, NumberArrayFactory factory) {
            this.failure = failure;
            this.factory = factory;
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public NumberArrayFactory getFactory() {
            return this.factory;
        }
    }

    public static interface Monitor {
        public void allocationSuccessful(long var1, NumberArrayFactory var3, Iterable<AllocationFailure> var4);
    }
}

