/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.statistics;

import java.util.Arrays;
import org.neo4j.consistency.statistics.Counts;

public class DefaultCounts
implements Counts {
    private final long[][] counts;

    public DefaultCounts(int threads) {
        this.counts = new long[Counts.Type.values().length][threads];
    }

    private long[] counts(Counts.Type type) {
        return this.counts[type.ordinal()];
    }

    @Override
    public long sum(Counts.Type type) {
        long[] all = this.counts[type.ordinal()];
        long total = 0L;
        for (long one : all) {
            total += one;
        }
        return total;
    }

    @Override
    public void incAndGet(Counts.Type type, int threadIndex) {
        long[] lArray = this.counts(type);
        int n = threadIndex;
        lArray[n] = lArray[n] + 1L;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Counts:");
        for (Counts.Type type : Counts.Type.values()) {
            long sum = this.sum(type);
            if (sum <= 0L) continue;
            builder.append(String.format("%n  %d %s", sum, type.name()));
        }
        return builder.toString();
    }

    @Override
    public void reset() {
        for (long[] c : this.counts) {
            Arrays.fill(c, 0L);
        }
    }
}

