/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.io.Serializable;
import java.util.UUID;
import org.neo4j.configuration.helpers.NormalizedGraphName;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.Catalog$;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.eval.DatabaseLookup;
import org.neo4j.fabric.executor.Location;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.SortedSet$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001\u0002\f\u0018\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)!\b\u0001C\u0001w!9q\b\u0001b\u0001\n\u0013\u0001\u0005BB%\u0001A\u0003%\u0011\tC\u0005K\u0001\u0001\u0007\t\u0019!C\u0005\u0017\"Iq\n\u0001a\u0001\u0002\u0004%I\u0001\u0015\u0005\n-\u0002\u0001\r\u0011!Q!\n1C\u0011b\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002!\t\u0013q\u0003\u0001\u0019!a\u0001\n\u0013i\u0006\"C0\u0001\u0001\u0004\u0005\t\u0015)\u0003B\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015\u0019\u0007\u0001\"\u0012e\u0011\u0015)\u0007\u0001\"\u0002c\u0011\u00151\u0007\u0001\"\u0005e\u0011\u00159\u0007\u0001\"\u0005i\u0011%\ti\u0001AI\u0001\n#\ty\u0001C\u0004\u0002&\u0001!\t\"a\n\t\u000f\u0005m\u0002\u0001\"\u0005\u0002>!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0002\u0018\u0007>lW.\u001e8jif\u001c\u0015\r^1m_\u001el\u0015M\\1hKJT!\u0001G\r\u0002\t\u00154\u0018\r\u001c\u0006\u00035m\taAZ1ce&\u001c'B\u0001\u000f\u001e\u0003\u0015qWm\u001c\u001bk\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0015\u000e\u0003]I!AK\f\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe\u0006qA-\u0019;bE\u0006\u001cX\rT8pWV\u0004\bC\u0001\u0015.\u0013\tqsC\u0001\bECR\f'-Y:f\u0019>|7.\u001e9\u0002\u0017QDH*[:uK:,'o\u001d\t\u0003caj\u0011A\r\u0006\u0003gQ\nQ!\u001a<f]RT!!\u000e\u001c\u0002\u0011%tG/\u001a:oC2T!aN\u000e\u0002\r-,'O\\3m\u0013\tI$GA\u0010HY>\u0014\u0017\r\u001c+sC:\u001c\u0018m\u0019;j_:,e/\u001a8u\u0019&\u001cH/\u001a8feN\fa\u0001P5oSRtDc\u0001\u001f>}A\u0011\u0001\u0006\u0001\u0005\u0006W\r\u0001\r\u0001\f\u0005\u0006_\r\u0001\r\u0001M\u0001\u0011S:4\u0018\r\\5eCRLwN\u001c'pG.,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019y%M[3di\u0006\t\u0012N\u001c<bY&$\u0017\r^5p]2{7m\u001b\u0011\u0002\u001b\r\f7\r[3e\u0007\u0006$\u0018\r\\8h+\u0005a\u0005C\u0001\u0015N\u0013\tquCA\u0004DCR\fGn\\4\u0002#\r\f7\r[3e\u0007\u0006$\u0018\r\\8h?\u0012*\u0017\u000f\u0006\u0002R)B\u0011!EU\u0005\u0003'\u000e\u0012A!\u00168ji\"9QkBA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005q1-Y2iK\u0012\u001c\u0015\r^1m_\u001e\u0004\u0003F\u0001\u0005Y!\t\u0011\u0013,\u0003\u0002[G\tAao\u001c7bi&dW-A\tj]Z\fG.\u001b3bi&|g\u000eV8lK:\fQ#\u001b8wC2LG-\u0019;j_:$vn[3o?\u0012*\u0017\u000f\u0006\u0002R=\"9QKCA\u0001\u0002\u0004\t\u0015AE5om\u0006d\u0017\u000eZ1uS>tGk\\6f]\u0002B#a\u0003-\u0002EI,w-[:uKJ\u001c\u0015\r^1m_\u001eLeN^1mS\u0012\fG/\u001a'jgR,g.\u001a:t)\u0005\t\u0016AD2veJ,g\u000e^\"bi\u0006dwn\u001a\u000b\u0002\u0019\u0006\t\u0012N\u001c<bY&$\u0017\r^3DCR\fGn\\4\u0002\u001b\r\u0014X-\u0019;f\u0007\u0006$\u0018\r\\8h\u000319W\r^%oi\u0016\u0014h.\u00197t)\rI\u00171\u0001\t\u0004U6|W\"A6\u000b\u00051\u001c\u0013AC2pY2,7\r^5p]&\u0011an\u001b\u0002\u0004'\u0016$\bC\u00019\u007f\u001d\t\tHP\u0004\u0002sw:\u00111O\u001f\b\u0003ift!!\u001e=\u000e\u0003YT!a^\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002\u00193%\u0011QpF\u0001\b\u0007\u0006$\u0018\r\\8h\u0013\ry\u0018\u0011\u0001\u0002\u000e\u0013:$XM\u001d8bY\u001e\u0013\u0018\r\u001d5\u000b\u0005u<\u0002\"CA\u0003!A\u0005\t\u0019AA\u0004\u0003\u001d1\u0017N]:u\u0013\u0012\u00042AIA\u0005\u0013\r\tYa\t\u0002\u0005\u0019>tw-\u0001\fhKRLe\u000e^3s]\u0006d7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tB\u000b\u0003\u0002\b\u0005M1FAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}1%\u0001\u0006b]:|G/\u0019;j_:LA!a\t\u0002\u001a\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0015\u001d,G/\u00117jCN,7\u000f\u0006\u0003\u0002*\u0005e\u0002CBA\u0016\u0003c\t\u0019$\u0004\u0002\u0002.)\u0019\u0011qF6\u0002\u0013%lW.\u001e;bE2,\u0017b\u00018\u0002.A\u0019\u0001/!\u000e\n\t\u0005]\u0012\u0011\u0001\u0002\u0006\u00032L\u0017m\u001d\u0005\b\u0003\u000b\u0011\u0002\u0019AA\u0004\u00031\tG.[1t\r\u0006\u001cGo\u001c:z)\u0019\ty$!\u0012\u0002VA)!%!\u0011\u00024%\u0019\u00111I\u0012\u0003\r=\u0003H/[8o\u0011\u001d\t9e\u0005a\u0001\u0003\u0013\n1A]3g!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(m\u0005AA-\u0019;bE\u0006\u001cX-\u0003\u0003\u0002T\u00055#!\u0005#bi\u0006\u0014\u0017m]3SK\u001a,'/\u001a8dK\"9\u0011qK\nA\u0002\u0005\u001d\u0011aA5eq\u0006Y\u0011N\u001c3jG\u0016\u001chI]8n)\u0011\ti&a\u0019\u0011\r\u0005-\u0012qLA\u0004\u0013\u0011\t\t'!\f\u0003\rM#(/Z1n\u0011\u001d\t)\u0001\u0006a\u0001\u0003\u000f\t!\u0002\\8dCRLwN\\(g))\tI'!\u001e\u0002z\u0005\u0015\u0015q\u0012\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN\r\u0002\u0011\u0015DXmY;u_JLA!a\u001d\u0002n\tAAj\\2bi&|g\u000eC\u0004\u0002xU\u0001\r!!\u0013\u0002\u001fM,7o]5p]\u0012\u000bG/\u00192bg\u0016Dq!a\u001f\u0016\u0001\u0004\ti(A\u0003he\u0006\u0004\b\u000e\u0005\u0003\u0002\u0000\u0005\u0005eB\u0001\u0015}\u0013\u0011\t\u0019)!\u0001\u0003\u000b\u001d\u0013\u0018\r\u001d5\t\u000f\u0005\u001dU\u00031\u0001\u0002\n\u0006y!/Z9vSJ,wK]5uC\ndW\rE\u0002#\u0003\u0017K1!!$$\u0005\u001d\u0011un\u001c7fC:Dq!!%\u0016\u0001\u0004\tI)\u0001\u0005dC:\u0014v.\u001e;f\u0001")
public class CommunityCatalogManager
implements CatalogManager {
    private final DatabaseLookup databaseLookup;
    private final GlobalTransactionEventListeners txListeners;
    private final Object invalidationLock;
    private volatile Catalog cachedCatalog;
    private volatile Object invalidationToken;

    private Object invalidationLock() {
        return this.invalidationLock;
    }

    private Catalog cachedCatalog() {
        return this.cachedCatalog;
    }

    private void cachedCatalog_$eq(Catalog x$1) {
        this.cachedCatalog = x$1;
    }

    private Object invalidationToken() {
        return this.invalidationToken;
    }

    private void invalidationToken_$eq(Object x$1) {
        this.invalidationToken = x$1;
    }

    @Override
    public void registerCatalogInvalidateListeners() {
        this.txListeners.registerTransactionEventListener(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.name(), (TransactionEventListener)new TransactionEventListenerAdapter<Object>(this){
            private final /* synthetic */ CommunityCatalogManager $outer;

            public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
                this.$outer.invalidateCatalog();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Catalog currentCatalog() {
        void var3_3;
        Catalog existingCatalog = this.cachedCatalog();
        if (existingCatalog != null) {
            return existingCatalog;
        }
        Object invalidationTokenAtConstructionStart = this.invalidationToken();
        Catalog newCatalog = this.createCatalog();
        if (BoxesRunTime.equals((Object)this.invalidationToken(), (Object)invalidationTokenAtConstructionStart)) {
            Object object = this.invalidationLock();
            synchronized (object) {
                if (BoxesRunTime.equals((Object)this.invalidationToken(), (Object)invalidationTokenAtConstructionStart)) {
                    this.cachedCatalog_$eq(newCatalog);
                }
            }
        }
        return var3_3;
    }

    public final void invalidateCatalog() {
        Object object = this.invalidationLock();
        synchronized (object) {
            this.invalidationToken_$eq(new Object());
            this.cachedCatalog_$eq(null);
        }
    }

    public Catalog createCatalog() {
        Set<Catalog.InternalGraph> internals = this.getInternals(this.getInternals$default$1());
        long maxId = BoxesRunTime.unboxToLong((Object)((TraversableOnce)internals.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.id()), Set$.MODULE$.canBuildFrom())).reduceOption((Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$2, x$3) -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(x$2), x$3)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        scala.collection.immutable.Set<Catalog.Alias> aliases = this.getAliases(maxId + 1L);
        return Catalog$.MODULE$.create((Seq<Catalog.Graph>)internals.toSeq(), (Seq<Catalog.Graph>)((Seq)Nil$.MODULE$), (Seq<Catalog.Graph>)aliases.toSeq(), (Option<String>)None$.MODULE$);
    }

    public Set<Catalog.InternalGraph> getInternals(long firstId) {
        return (Set)((SetLike)((TraversableLike)this.databaseLookup.databaseIds().zip(this.indicesFrom(firstId), SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), (Ordering)Ordering.Long$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CommunityCatalogManager.$anonfun$getInternals$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NamedDatabaseId databaseId2 = (NamedDatabaseId)tuple2._1();
            NormalizedGraphName graphName = new NormalizedGraphName(databaseId2.name());
            NormalizedDatabaseName databaseName = new NormalizedDatabaseName(databaseId2.name());
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)graphName, (Object)databaseName);
            return tuple3;
        }, Set$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            NormalizedDatabaseName databaseName;
            NormalizedGraphName graphName;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$6;
                    if (tuple3 == null) break block2;
                    tuple2 = (Tuple2)tuple3._1();
                    graphName = (NormalizedGraphName)tuple3._2();
                    databaseName = (NormalizedDatabaseName)tuple3._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            NamedDatabaseId databaseId2 = (NamedDatabaseId)tuple2._1();
            long idx = tuple2._2$mcJ$sp();
            Catalog.InternalGraph internalGraph = new Catalog.InternalGraph(idx, databaseId2.databaseId().uuid(), graphName, databaseName);
            return internalGraph;
        }, Set$.MODULE$.canBuildFrom());
    }

    public long getInternals$default$1() {
        return 0L;
    }

    public scala.collection.immutable.Set<Catalog.Alias> getAliases(long firstId) {
        Stream nonPrimaryRefs = (Stream)this.databaseLookup.databaseReferences().toStream().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)CommunityCatalogManager.$anonfun$getAliases$1(x$7)));
        Stream aliases = (Stream)((Stream)nonPrimaryRefs.zip(this.indicesFrom(firstId), Stream$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)CommunityCatalogManager.$anonfun$getAliases$2(check$ifrefutable$2))).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple2 tuple2 = x$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DatabaseReference ref = (DatabaseReference)tuple2._1();
            long idx = tuple2._2$mcJ$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(this.aliasFactory(ref, idx).map((Function1 & Serializable & scala.Serializable)alias -> alias));
            return iterable;
        }, Stream$.MODULE$.canBuildFrom());
        return aliases.toSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Catalog.Alias> aliasFactory(DatabaseReference ref, long idx) {
        boolean bl = false;
        DatabaseReference.Internal internal = null;
        DatabaseReference databaseReference = ref;
        if (databaseReference instanceof DatabaseReference.Internal) {
            bl = true;
            internal = (DatabaseReference.Internal)databaseReference;
            if (internal.isPrimary()) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            return new Some((Object)new Catalog.InternalAlias(idx, internal.databaseId().databaseId().uuid(), new NormalizedGraphName(internal.alias().name()), internal.alias()));
        }
        if (!(databaseReference instanceof DatabaseReference.External)) return None$.MODULE$;
        DatabaseReference.External external = (DatabaseReference.External)databaseReference;
        return new Some((Object)new Catalog.ExternalAlias(idx, external.id(), new NormalizedGraphName(external.alias().name()), external.alias(), external.remoteName(), external.remoteUri()));
    }

    private Stream<Object> indicesFrom(long firstId) {
        return package$.MODULE$.Stream().iterate((Object)BoxesRunTime.boxToLong((long)firstId), (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$9 -> x$9 + 1L);
    }

    @Override
    public Location locationOf(DatabaseReference sessionDatabase, Catalog.Graph graph, boolean requireWritable, boolean canRoute) {
        Location.Local local;
        Catalog.Graph graph2 = graph;
        if (graph2 instanceof Catalog.InternalGraph) {
            Catalog.InternalGraph internalGraph = (Catalog.InternalGraph)graph2;
            long id = internalGraph.id();
            UUID uuid = internalGraph.uuid();
            NormalizedDatabaseName databaseName = internalGraph.databaseName();
            local = new Location.Local(id, uuid, databaseName.name());
        } else if (graph2 instanceof Catalog.InternalAlias) {
            Catalog.InternalAlias internalAlias = (Catalog.InternalAlias)graph2;
            long id = internalAlias.id();
            UUID uuid = internalAlias.uuid();
            NormalizedDatabaseName databaseName = internalAlias.databaseName();
            local = new Location.Local(id, uuid, databaseName.name());
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected graph type ").append(graph).toString());
        }
        return local;
    }

    public static final /* synthetic */ boolean $anonfun$getInternals$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getAliases$1(DatabaseReference x$7) {
        return !x$7.isPrimary();
    }

    public static final /* synthetic */ boolean $anonfun$getAliases$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public CommunityCatalogManager(DatabaseLookup databaseLookup, GlobalTransactionEventListeners txListeners) {
        this.databaseLookup = databaseLookup;
        this.txListeners = txListeners;
        this.invalidationLock = new Object();
        this.registerCatalogInvalidateListeners();
    }
}

