#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include "stations.h"

/* The list of cell towers is ripped from BSA61 phone's firmware */

static struct cnetz_stations {
	char		long_name[32], name[8];
	uint8_t		nat, fuvst, rest;
} cnetz_stations[] = {
/*	  Langer-Name				Kurzer Name,	Nat	FuVST	Rest	*/
	{ "Oberhausen 32",			"OB32",		1,	2,	1,	},
	{ "Oberhausen 0 <prov.>",		"OB0",		1,	2,	5,	},
	{ "Wuppertal 18",			"WUP18",	1,	2,	6,	},
	{ "Oberhausen 21",			"OB21",		1,	2,	7,	},
	{ "Duisburg 21",			"DUI21",	1,	2,	8,	},
	{ "Heiligenhaus 0",			"HEIL0",	1,	2,	9,	},
	{ "Essen 1 <Fernmeldeamt>",		"ES1",		1,	2,	10,	},
	{ "Velbert-Langenberg 2",		"VELL2",	1,	2,	11,	},
	{ "Duisburg 40 <Ers.f.OB16>",		"DUI40",	1,	2,	12,	},
	{ "Bottrop 0",				"BOT0",		1,	2,	13,	},
	{ "Gelsenkirchen 1",			"GSK1",		1,	2,	14,	},
	{ "Essen 35",				"ES35X",	1,	2,	15,	},
	{ "Duisburg 25",			"DUI25",	1,	2,	16,	},
	{ "Velbert-Neviges",			"VELN",		1,	2,	17,	},
	{ "Wuppertal 30",			"WUP30",	1,	2,	18,	},
	{ "Essen 28 (Borbeck)",			"ESBCK",	1,	2,	19,	},
	{ "Kirchhellen 4",			"KIRCH",	1,	2,	20,	},
	{ "Gelsenkirchen 7",			"GSK7",		1,	2,	21,	},
	{ "Wuppertal 34",			"WUP34",	1,	2,	22,	},
	{ "Wuppertal 35 <Rheinshagen>",		"WUPE11",	1,	2,	23,	},
	{ "Oberhausen 23",			"OB23",		1,	2,	24,	},
	{ "Velbert-Neviges 4",			"WFRTH3",	1,	2,	25,	},
	{ "Duisburg 42 <Ers.f.DUI39>",		"DUI42",	1,	2,	26,	},
	{ "Rheinhausen 0",			"RHSN0",	1,	2,	27,	},
	{ "Essen 12",				"ES12",		1,	2,	28,	},
	{ "Homberg 1",				"HOMB1",	1,	2,	29,	},
	{ "Rees-Mehr 0",			"REME0",	1,	2,	30,	},
	{ "Essen 13",				"ES13",		1,	2,	31,	},
	{ "Essen 15",				"ES15",		1,	2,	32,	},
	{ "Heiden 1",				"HEID0",	1,	2,	33,	},
	{ "Voerde 2",				"VOER2",	1,	2,	34,	},
	{ "Duisburg 0",				"DUI0",		1,	2,	35,	},
	{ "Velbert 1 <20 Grad geneigt>",	"VEL1",		1,	2,	36,	},
	{ "Oberhausen 26",			"OB26",		1,	2,	37,	},
	{ "Gelsenkirchen 58",			"GSK58",	1,	2,	38,	},
	{ "Essen 8",				"ES8",		1,	2,	39,	},
	{ "Wuppertal 8 (Hahnerberg)",		"WUP8",		1,	2,	40,	},
	{ "Oberhausen 18 (Heimaterde)",		"OB18",		1,	2,	41,	},
	{ "Oberhausen 30 (Osterfeld)",		"OB30",		1,	2,	43,	},
	{ "Wesel 0 <Mischbake>",		"WSL",		1,	2,	44,	},
	{ "Borken 0",				"BOR0",		1,	2,	45,	},
	{ "Velen 20",				"RSDF",		1,	2,	46,	},
	{ "Bocholt 0",				"BOH0",		1,	2,	47,	},
	{ "Huenxe 1",				"HXE0",		1,	2,	48,	},
	{ "Isselburg 1",			"ISSB99",	1,	2,	49,	},
	{ "Emmerich-Elten 1",			"ELT1X",	1,	2,	50,	},
	{ "Bochum-Wattenscheid 3",		"BOC3",		1,	2,	51,	},
	{ "Dorsten 0",				"DSTN0",	1,	2,	52,	},
	{ "Schermbeck 2",			"SBCK",		1,	2,	53,	},
	{ "Raesfeld 2 (Erle)",			"RAEF0",	1,	2,	54,	},
	{ "Wuppertal 4 (Beyenburg)",		"WUP4",		1,	2,	55,	},
	{ "Hueckeswagen 2",			"HUECK1",	1,	2,	57,	},
	{ "Herne 1",				"HER",		1,	2,	58,	},
	{ "Bochum 47",				"BOC47",	1,	2,	59,	},
	{ "Hattingen 9 (Holthausen)",		"HATT",		1,	2,	60,	},
	{ "Sprockhoevel 71 (12Grad gen.)",	"HATT71",	1,	2,	61,	},
	{ "Gladbeck 20",			"GLAD20",	1,	2,	62,	},
	{ "Ahaus 0",				"AH0",		1,	2,	63,	},
	{ "Bochum 1 <Ant. 20 grad gen.>",	"BOC1",		1,	2,	64,	},
	{ "Herten 0.80D1 <Zeche Ewald>",	"HERT",		1,	2,	66,	},
	{ "Oberhausen 1",			"OB1",		1,	2,	68,	},
	{ "Dorsten-Wulfen 0",			"DORS0",	1,	2,	70,	},
	{ "Essen 0 (Kettwig)",			"ESKTW",	1,	2,	76,	},
	{ "Vreden 0",				"VRDN0",	1,	2,	79,	},
	{ "Gronau 0",				"GRON0",	1,	2,	81,	},
	{ "Dinslaken 2",			"DIN2",		1,	2,	82,	},
	{ "Bochum 78 (Stiepel)<neu>",		"BOC78",	1,	2,	84,	},
	{ "Bochum 0",				"BOC0",		1,	2,	88,	},
	{ "Oberhausen 9 (Bake)",		"OB9",		1,	2,	89,	},
	{ "Coesfeld 0",				"COE0",		1,	2,	92,	},
	{ "Schoeppingen 1",			"SPP12",	1,	2,	93,	},
	{ "Stadtlohn 1",			"STLN1",	1,	2,	98,	},
	{ "Wuppertal 2 (Bake)",			"WUP2",		1,	2,	99,	},
	{ "Raegelin 1",				"DKOW",		1,	3,	1,	},
	{ "Fuerstenberg 1",			"FTBG",		1,	3,	3,	},
	{ "Maerkisch-Buchholz 3",		"MAS",		1,	3,	4,	},
	{ "Beeskow 0",				"BEES",		1,	3,	5,	},
	{ "Finowfurt 1",			"EBSW",		1,	3,	6,	},
	{ "Blnklz 503 Bernau 6 (B-Aue)",	"BKLZ37",	1,	3,	7,	},
	{ "Ziesar 0 <Ers.f.TRANS3>",		"ZIES0",	1,	3,	8,	},
	{ "Wittenberge 4",			"WIBG",		1,	3,	9,	},
	{ "Blnklz 505(Werder Havel 1)",		"TRANS5",	1,	3,	10,	},
	{ "Seelow 4",				"SEEL",		1,	3,	11,	},
	{ "Blnklz 313(Treseburger Str)",	"BKLZ47",	1,	3,	12,	},
	{ "Briesen 0",				"BRIE",		1,	3,	13,	},
	{ "Perleberg 4",			"PLBG",		1,	3,	14,	},
	{ "Muencheberg 4",			"MUEN4",	1,	3,	15,	},
	{ "Herzfelde 3",			"HF3",		1,	3,	16,	},
	{ "Storkow 4 <Ers.f.STOR>",		"STORK",	1,	3,	17,	},
	{ "Neubrandenburg 14",			"NBBG",		1,	3,	18,	},
	{ "Treuenbrietzen 0",			"TREUB",	1,	3,	19,	},
	{ "Prenzlau 3",				"PZL",		1,	3,	20,	},
	{ "Pasewalk 2",				"PAWA2",	1,	3,	22,	},
	{ "NaumbgRi ???",			"???",		1,	3,	23,	},
	{ "Rathenow 4",				"RATH4",	1,	3,	24,	},
	{ "Blnklz 414(B.-Apitz-Str7)",		"BKLZ54",	1,	3,	26,	},
	{ "Blnklz 406(Jaegerstieg)",		"B25",		1,	3,	27,	},
	{ "Templin 2",				"TPL",		1,	3,	28,	},
	{ "Luckenwalde 2",			"LCKW",		1,	3,	29,	},
	{ "Lehnin 0",				"LEHN0",	1,	3,	30,	},
	{ "Frankfurt/Oder 10",			"FFO",		1,	3,	31,	},
	{ "Blnklz 604 (Michendorf)",		"MICHD",	1,	3,	32,	},
	{ "Trebbin 2",				"LWD",		1,	3,	33,	},
	{ "Gramzow 2",				"GRAM0",	1,	3,	35,	},
	{ "Bad Freienwalde 0",			"PLF",		1,	3,	36,	},
	{ "Falkenhage 4",			"PRD",		1,	3,	37,	},
	{ "Fuerstenwalde 7",			"RBG",		1,	3,	38,	},
	{ "Angermuende 7",			"TLF",		1,	3,	39,	},
	{ "Wittstock 5",			"WTT",		1,	3,	40,	},
	{ "Dambeck 2",				"WOZ",		1,	3,	41,	},
	{ "Neuzelle 3",				"EIHS",		1,	3,	42,	},
	{ "Raben 1",				"RAB",		1,	3,	43,	},
	{ "Toepchin 3",				"TOEP3",	1,	3,	44,	},
	{ "Brandenburg 16",			"BDB",		1,	3,	45,	},
	{ "Jueterbog 4",			"JTB",		1,	3,	46,	},
	{ "Brandenburg 2<Ers.f.TRANS4>",	"KRAN",		1,	3,	47,	},
	{ "Lieberose 1",			"LIEB99",	1,	3,	48,	},
	{ "Wiesenburg Mark 0",			"WIESB",	1,	3,	49,	},
	{ "Mirow 1",				"MIROW",	1,	3,	50,	},
	{ "Rhinow 1",				"RNOW",		1,	3,	51,	},
	{ "Rheinsberg 3",			"ZHLN",		1,	3,	52,	},
	{ "Petkus 3",				"PETK",		1,	3,	53,	},
	{ "Blankensee 1",			"KEUL",		1,	3,	54,	},
	{ "Neustrelitz 6",			"NEUST6",	1,	3,	55,	},
	{ "Greifenberg 1",			"GREI1",	1,	3,	57,	},
	{ "Pritzwalk 6",			"PTZW",		1,	3,	58,	},
	{ "Schwedt 6",				"SCHDT",	1,	3,	59,	},
	{ "Schmoelln 1",			"SMLL",		1,	3,	62,	},
	{ "Woldegk 4",				"WOCK",		1,	3,	65,	},
	{ "Neuruppin 6",			"NRP",		1,	3,	66,	},
	{ "Belzig 2",				"BELZ",		1,	3,	67,	},
	{ "Gransee 1",				"GRAS",		1,	3,	69,	},
	{ "Kyritz 4",				"KYRZ",		1,	3,	70,	},
	{ "Gross Doelln 0",			"GDOE",		1,	3,	71,	},
	{ "Premnitz 0",				"RATH",		1,	3,	72,	},
	{ "Gloewen 2",				"GLOE2",	1,	3,	73,	},
	{ "Luebben 2",				"LBN",		1,	3,	74,	},
	{ "Blnklz 502(Bestensee 3)",		"BKLZ38",	1,	3,	76,	},
	{ "Blnklz 504(Pausin 1)",		"BKLZ39",	1,	3,	77,	},
	{ "Golssen 0",				"GOLN0",	1,	3,	78,	},
	{ "Luebbenau 2",			"LUEB2",	1,	3,	79,	},
	{ "Blnklz 410(Alt-Mahlsdorf)",		"BKLZ51",	1,	3,	80,	},
	{ "Blnklz 412(Eichhorster S.)",		"BKLZ53",	1,	3,	81,	},
	{ "Blnklz 416(Muehlenbeck 2)",		"BKLZ55",	1,	3,	83,	},
	{ "Blnklz 417(Hennigsdorf 0)",		"BKLZ63",	1,	3,	84,	},
	{ "Blnklz 506(Ludwigsfelde 3)",		"BKLZ57",	1,	3,	86,	},
	{ "Blnklz 507(Ruedersdorf 1)",		"BKLZ58",	1,	3,	87,	},
	{ "Blnklz 508(Strausberg 1)",		"BKLZ59",	1,	3,	88,	},
	{ "Blnklz 509(Zossen 5)",		"BKLZ60",	1,	3,	89,	},
	{ "Blnklz 510(Mahlow 4)",		"BKLZ72",	1,	3,	90,	},
	{ "Blnklz 511(Bernau 3)",		"BKLZ64",	1,	3,	91,	},
	{ "Blnklz 513(Oranienburg 3)",		"BKLZ65",	1,	3,	92,	},
	{ "Blnklz 514(Falkensee 1)",		"BKLZ66",	1,	3,	93,	},
	{ "Liebenwalde 2",			"LIEBW2",	1,	3,	94,	},
	{ "Eberswalde 8",			"EBSW8",	1,	3,	96,	},
	{ "Blnklz 512(Erkner 8)",		"BKLZ81",	1,	3,	97,	},
	{ "Blnklz 515(KWH 2)",			"BKLZ74",	1,	3,	98,	},
	{ "Blnklz 605(Fichtenwalde 1)",		"BKLZ70",	1,	3,	99,	},
	{ "Reinfeld 10",			"REIF10",	1,	4,	3,	},
	{ "Gudow 10",				"GUD0",		1,	4,	9,	},
	{ "Travemuende 7",			"TRV7",		1,	4,	10,	},
	{ "Kiel 2",				"KIL2",		1,	4,	11,	},
	{ "Rendsburg 2 (Preus.Elekt)",		"RDB",		1,	4,	17,	},
	{ "Nortorf 4",				"NORTO4",	1,	4,	18,	},
	{ "Freienwill 4",			"FRW4",		1,	4,	19,	},
	{ "Westerland 0",			"WLD0",		1,	4,	20,	},
	{ "Heide Holst 2",			"HEI2",		1,	4,	22,	},
	{ "Hennstedt b Itzehoe 1",		"HNI1",		1,	4,	23,	},
	{ "Bredstedt 3",			"BST3",		1,	4,	24,	},
	{ "Brunsbuettel 1",			"BRB1",		1,	4,	30,	},
	{ "Luebeck 2",				"LCK2",		1,	4,	31,	},
	{ "Luebeck 4",				"LCK4",		1,	4,	32,	},
	{ "Itzehoe 2 (Polizei)",		"ITZH",		1,	4,	36,	},
	{ "Glueckstadt 1",			"GLS1",		1,	4,	40,	},
	{ "Ploen 1",				"PLN2",		1,	4,	44,	},
	{ "Burg/Fehmarn 1",			"FEHM1",	1,	4,	46,	},
	{ "Hartenholm 0",			"HHLM0",	1,	4,	50,	},
	{ "Daenischenhagen 1",			"DAEN1",	1,	4,	52,	},
	{ "Luebeck 9",				"LCK9",		1,	4,	53,	},
	{ "Henstedt-Ulzburg 4",			"HNU4",		1,	4,	55,	},
	{ "Luebeck 23",				"LCK23",	1,	4,	56,	},
	{ "Schoenwalde 1",			"SCE1",		1,	4,	57,	},
	{ "Ratzeburg 1",			"RATZ1",	1,	4,	58,	},
	{ "Schwarzenbek 1",			"SWB1",		1,	4,	59,	},
	{ "Elmshorn 10",			"EHN10",	1,	4,	61,	},
	{ "Eckernfoerde 5",			"ECKF5",	1,	4,	62,	},
	{ "Husum 0",				"HUS0",		1,	4,	66,	},
	{ "Marne 0",				"MARN0",	1,	4,	72,	},
	{ "Neumuenster 10",			"NEUM10",	1,	4,	73,	},
	{ "Suederluegum 1",			"SUED1",	1,	4,	76,	},
	{ "Garding 1",				"GARD1",	1,	4,	81,	},
	{ "Hohenfelde 0",			"HFLD0",	1,	4,	82,	},
	{ "Ahrensboek 1",			"ABK0",		1,	4,	83,	},
	{ "Schleswig 4",			"SLWG4",	1,	4,	86,	},
	{ "Wankendorf",				"WAN",		1,	4,	90,	},
	{ "Wyk/Foehr 0",			"WYK",		1,	4,	94,	},
	{ "Bad Segeberg 0",			"BSE0",		1,	4,	95,	},
	{ "Kappeln 1",				"KPN1",		1,	4,	96,	},
	{ "Suelfeld 1",				"SFD1",		1,	4,	99,	},
	{ "Hamburg 22 (Lagerstr.2)",		"H22",		2,	4,	1,	},
	{ "Buxtehude 0",			"BUX0",		2,	4,	2,	},
	{ "Buchholz 0 (Nordheide)",		"BUCH0",	2,	4,	3,	},
	{ "Egestorf 1",				"EGT1",		2,	4,	4,	},
	{ "Lueneburg 3",			"LUE3",		2,	4,	5,	},
	{ "Marxen 2 (Ramelsloh)",		"MARX2",	2,	4,	6,	},
	{ "Wulfsen 10",				"WULF10",	2,	4,	8,	},
	{ "Pinneberg 7 (Z 31)",			"HHKL31",	2,	4,	9,	},
	{ "Hamburg 291 (Barsbuet. Z 43)",	"HHKL43",	2,	4,	10,	},
	{ "Hamburg 141 (Poppenbue.Z 41)",	"PBTL",		2,	4,	11,	},
	{ "Hamburg 184 (Allerm. Z 42)",		"H159",		2,	4,	12,	},
	{ "Hamburg 282 (PA90 Harb.Z44)",	"HRBG",		2,	4,	13,	},
	{ "Sauensiek 0",			"SAUS0",	2,	4,	14,	},
	{ "Betzendorf 1",			"BETZ1",	2,	4,	15,	},
	{ "Tostedt 0",				"TOST0",	2,	4,	17,	},
	{ "Hamburg 256 (Philips Z 38)",		"HHKL38",	2,	4,	18,	},
	{ "Hamburg 316 (Klockm. Z 56)",		"HHKL56",	2,	4,	24,	},
	{ "Hamburg 650 (Bauerbgwg Z66)",	"HHKL66",	2,	4,	25,	},
	{ "Trittau 10",				"TTAU10",	2,	4,	26,	},
	{ "Hamburg 104 (PA2 Z 0)",		"HHKL0",	2,	4,	27,	},
	{ "Hamburg PA701(Wandsb. Z 67)",	"HHKL67",	2,	4,	28,	},
	{ "Hamburg 105 (Schulgwg.Z 12)",	"HHKL12",	2,	4,	30,	},
	{ "Hamburg 261 (Altona Z 13)",		"HHKL13",	2,	4,	31,	},
	{ "Hamburg 257 (Fachhsch.Z 14)",	"HHKL14",	2,	4,	32,	},
	{ "Hamburg 1 (FVSt Z 15)",		"HHKL15",	2,	4,	33,	},
	{ "Hamburg 12 (FVSt 42 Z 16)",		"HHKL16",	2,	4,	34,	},
	{ "Hamburg 133 (Modezent.Z 21)",	"HHKL21",	2,	4,	35,	},
	{ "Hamburg 531 (Langenh. Z 69)",	"LANGH",	2,	4,	36,	},
	{ "Hamburg 259 (Acht.Born Z23)",	"HHKL23",	2,	4,	37,	},
	{ "Hamburg 77 (Finkenw. Z 24)",		"HHKL24",	2,	4,	38,	},
	{ "Hamburg 76 (Waltersh.Z 25)",		"HHKL25",	2,	4,	39,	},
	{ "Hamburg 5891B (Wilhelmsb.)",		"WILHB",	2,	4,	40,	},
	{ "Hamburg 60 (Rothenb. Z 27)",		"HHKL27",	2,	4,	41,	},
	{ "Hamburg 6 (Hamm Z 28)",		"HHKL28",	2,	4,	42,	},
	{ "Hamburg 46 (Steilsh. Z 29)",		"HHKL29",	2,	4,	43,	},
	{ "Hamburg 326 (Ammersbk.Z 70)",	"OHLS",		2,	4,	44,	},
	{ "Hamburg 263 (NeuWulmst.Z34)",	"HHKL34",	2,	4,	47,	},
	{ "Seevetal 3 (Z 35)",			"HHKL35",	2,	4,	48,	},
	{ "Rosengarten 1 (Z 36)",		"HHKL36",	2,	4,	49,	},
	{ "Hamburg 24 (R.LindeWg.Z37)",		"HHKL37",	2,	4,	50,	},
	{ "Hamburg 65 (Norderst.Z 39)",		"HHKL39",	2,	4,	52,	},
	{ "Hamburg 260 (FA 4 Z 11)",		"HHKL11",	2,	4,	53,	},
	{ "Hamburg 258 (Randowstr.Z22)",	"HHKL22",	2,	4,	54,	},
	{ "Marschacht 10",			"MSCH0",	2,	4,	56,	},
	{ "Winsen/Luhe 0",			"WINS0",	2,	4,	58,	},
	{ "Ahrensburg 11 (Z 46)",		"SIK1",		2,	4,	60,	},
	{ "Wedel 11",				"WDL11",	2,	4,	64,	},
	{ "Hamburg 306 (Marmstorf Z47)",	"HHKL70",	2,	4,	68,	},
	{ "Hollenstedt 10",			"HSTD1",	2,	4,	69,	},
	{ "Uetersen 2",				"UETS2",	2,	4,	70,	},
	{ "Bad Oeynhausen",			"BOEY0",	1,	5,	2,	},
	{ "Bad Salzuflen 5",			"SUFL",		1,	5,	3,	},
	{ "Bohmte 0",				"BOTE0",	1,	5,	4,	},
	{ "Buende 2",				"BUEN2",	1,	5,	5,	},
	{ "Delbrueck 1",			"DELB",		1,	5,	6,	},
	{ "Extertal 2",				"EXT2",		1,	5,	7,	},
	{ "Bad Pyrmont 1",			"PYR1",		1,	5,	9,	},
	{ "Luegde-Rischenau 1",			"LGR1",		1,	5,	10,	},
	{ "Ibbenbueren 4",			"IBB",		1,	5,	11,	},
	{ "Bramsche-Engter 1",			"BME1",		1,	5,	12,	},
	{ "Barnstorf 0",			"BARN0",	1,	5,	13,	},
	{ "Herford 4",				"HFS",		1,	5,	14,	},
	{ "Luebbecke 1",			"LBBK1",	1,	5,	16,	},
	{ "Lingen 0",				"LIN",		1,	5,	17,	},
	{ "Bielefeld 0",			"BFD0",		1,	5,	18,	},
	{ "Lindern 1",				"LRN1",		1,	5,	19,	},
	{ "Oerlinghausen 2",			"OERL2",	1,	5,	20,	},
	{ "Guetersloh-Friedrichsdorf 0",	"GTL99",	1,	5,	22,	},
	{ "Paderborn 0",			"PB0",		1,	5,	23,	},
	{ "Hoevelhof 0",			"HOEVH",	1,	5,	24,	},
	{ "Lemgo 2",				"LEMG2",	1,	5,	25,	},
	{ "Bad Iburg 2",			"BIB2",		1,	5,	26,	},
	{ "Dissen 1",				"DIS1",		1,	5,	27,	},
	{ "Melle-Buer 1",			"MLB1",		1,	5,	28,	},
	{ "Fuerstenau 0",			"FUE0",		1,	5,	29,	},
	{ "Bad Bentheim 2",			"BBM2",		1,	5,	30,	},
	{ "Uchte 0",				"UCH0",		1,	5,	32,	},
	{ "Bielefeld-Joellenbeck 0",		"BFDJ",		1,	5,	33,	},
	{ "Bad Lippspringe 0",			"BLPS0",	1,	5,	34,	},
	{ "Steinhagen 0",			"STHG0",	1,	5,	35,	},
	{ "Spenge 0",				"SPENG0",	1,	5,	37,	},
	{ "Berge 0",				"BERGE",	1,	5,	38,	},
	{ "Minden 0",				"MIN0",		1,	5,	40,	},
	{ "Osnabrueck 8",			"OS8",		1,	5,	41,	},
	{ "Osnabrueck 0",			"OS0",		1,	5,	42,	},
	{ "Rahden 0",				"RAHD0",	1,	5,	44,	},
	{ "Rheda-Wiedenbrueck 7",		"RHDA4",	1,	5,	45,	},
	{ "Emlichheim 0",			"WILS1",	1,	5,	48,	},
	{ "Tecklenburg 1",			"TE1",		1,	5,	50,	},
	{ "Blomberg 99 (Nassengrund)",		"BGNG99",	1,	5,	52,	},
	{ "Bad Driburg 99",			"BDBG99",	1,	5,	54,	},
	{ "Harsewinkel 97",			"HARS99",	1,	5,	55,	},
	{ "Horn Bad Meinberg 1",		"BMBG1",	1,	5,	56,	},
	{ "Nordhorn 0",				"NDHN0",	1,	5,	59,	},
	{ "Guetersloh 0",			"GTLH0",	1,	5,	60,	},
	{ "Damme 1",				"DAM1",		1,	5,	61,	},
	{ "Meppen 0",				"MEP0",		1,	5,	62,	},
	{ "Rheine 0",				"RHE0",		1,	5,	63,	},
	{ "Bielefeld 1",			"BFD1",		1,	5,	92,	},
	{ "Minden 2",				"MIN2",		1,	5,	95,	},
	{ "Worms 7 (Autobahn)",			"FKLZ52",	1,	6,	1,	},
	{ "Westhofen Rheinhess 1",		"FKLZ54",	1,	6,	2,	},
	{ "Bensheim 0",				"FKLZ56",	1,	6,	3,	},
	{ "Seeheim 2",				"FKLZ57",	1,	6,	5,	},
	{ "Mosbach Baden 6",			"HNKL21",	1,	6,	6,	},
	{ "Eberbach 1",				"HNKL22",	1,	6,	7,	},
	{ "Lambrecht Pfalz 1",			"LAMB1",	1,	6,	8,	},
	{ "Weidenthal Pfalz 3",			"WDTL3",	1,	6,	9,	},
	{ "Bad Kreuznach 5<wird opt>",		"BKZ5",		1,	6,	10,	},
	{ "Annweiler a Trifels 1",		"ANNW",		1,	6,	11,	},
	{ "Wilhelmsfeld 2",			"WHF2",		1,	6,	12,	},
	{ "Alzey 1",				"FKLZ51",	1,	6,	13,	},
	{ "Mudau 1",				"MUD1",		1,	6,	14,	},
	{ "Kaiserslautern 2",			"KL2",		1,	6,	15,	},
	{ "Bad Bergzabern 5",			"BBZN2",	1,	6,	22,	},
	{ "Wiesloch 3",				"KAKL35",	1,	6,	24,	},
	{ "Hockenheim 2",			"HOCK2",	1,	6,	25,	},
	{ "Beerfelden 1",			"AISCH",	1,	6,	26,	},
	{ "Hartberg 5 (HR)",			"HARTB5",	1,	6,	27,	},
	{ "Ahorn Baden 1",			"EUB1",		1,	6,	28,	},
	{ "Schefflenz 2 (Rittersb.)",		"SFL2",		1,	6,	29,	},
	{ "Michelstadt 7",			"MICH1",	1,	6,	30,	},
	{ "Mannheim 12(Friedrichsfeld)",	"KAKL55",	1,	6,	31,	},
	{ "Lindenfels 1",			"FKLZ55",	1,	6,	32,	},
	{ "Moeckmuehl 1",			"HNKL01",	1,	6,	34,	},
	{ "Meisenheim 6",			"MEIS6",	1,	6,	35,	},
	{ "Odernheim 2",			"ODH2",		1,	6,	36,	},
	{ "Guntersblum 3",			"GUN3",		1,	6,	37,	},
	{ "Flonheim 1",				"FLON1",	1,	6,	38,	},
	{ "Neutsch (Ruhrgas)",			"NEUT",		1,	6,	40,	},
	{ "Schoenau 3 (Hl.Kreuz.)",		"WHF1",		1,	6,	42,	},
	{ "Neckargemuend 1",			"NEG",		1,	6,	43,	},
	{ "Neckargemuend 2",			"NEG2",		1,	6,	44,	},
	{ "Meckesheim 2",			"MEH2",		1,	6,	45,	},
	{ "Mannheim 178 (Schoenau)",		"MA178",	1,	6,	46,	},
	{ "Hardheim 1",				"HAD",		1,	6,	51,	},
	{ "Buchen Odenw 0",			"BUC",		1,	6,	52,	},
	{ "Maxdorf 0",				"KAKL44",	1,	6,	53,	},
	{ "Guntersblum 1",			"GUN1",		1,	6,	54,	},
	{ "Bensheim 13",			"FKLZ74",	1,	6,	55,	},
	{ "Weinheim 2",				"KAKL52",	1,	6,	56,	},
	{ "Winnweiler 2 (Imsbach)(KL2)",	"IMB1",		1,	6,	57,	},
	{ "Winnweiler 8 (KL2)",			"WIW8",		1,	6,	58,	},
	{ "Neustadt a d Weinstrasse 0",		"KAKL06",	1,	6,	60,	},
	{ "Ludwigshafen a Rhein 505",		"KAKL01",	1,	6,	61,	},
	{ "Speyer 5",				"KAKL07",	1,	6,	62,	},
	{ "Landau i d Pfalz 8",			"KAKL10",	1,	6,	63,	},
	{ "Heidelberg 0",			"KAKL26",	1,	6,	64,	},
	{ "Dahn 3",				"DAHN3",	1,	6,	65,	},
	{ "Schwetzingen 0",			"KAKL36",	1,	6,	66,	},
	{ "Ladenburg 6",			"KAKL37",	1,	6,	67,	},
	{ "Lampertheim 0",			"KAKL38",	1,	6,	68,	},
	{ "Mannheim 52 (Pfeiffersw.)",		"KAKL41",	1,	6,	69,	},
	{ "Neuhofen Pfalz 0",			"KAKL43",	1,	6,	70,	},
	{ "Mannheim 149 (Ilvesheim)",		"KAKL29",	1,	6,	71,	},
	{ "Mannheim 198 (Diak.-Kkh.)",		"KAKL32",	1,	6,	72,	},
	{ "Mannheim 199 (Grosskraftw.)",	"KAKL31",	1,	6,	73,	},
	{ "Mannheim 201 (Maimarktg.)",		"KAKL30",	1,	6,	75,	},
	{ "Mannheim 202 (VDOe)",		"KAKL33",	1,	6,	76,	},
	{ "Mannheim 173 (Kaefertal)",		"KAKL28",	1,	6,	77,	},
	{ "Viernheim 2",			"KAKL39",	1,	6,	78,	},
	{ "Adelsheim 4 <ers. Seckach1>",	"ADH1",		1,	6,	83,	},
	{ "Gernsheim Rhein 4",			"FKLZ75",	1,	6,	84,	},
	{ "Alsenz 7",				"ALE",		1,	6,	85,	},
	{ "Frankenthal 0",			"KAKL02",	1,	6,	86,	},
	{ "Gruenstadt 0",			"KAKL03",	1,	6,	87,	},
	{ "Bad Duerkheim 2",			"KAKL04",	1,	6,	88,	},
	{ "Bad Duerkheim 0",			"KAKL45",	1,	6,	89,	},
	{ "Kirchheimbolanden 5",		"KIB",		1,	6,	90,	},
	{ "Hassmersheim 1 (Gundelsheim)",	"HAH1",		1,	6,	91,	},
	{ "Enkenbach-Alsenborn 4",		"ENK4",		1,	6,	93,	},
	{ "Miltenberg 2",			"MIL2",		1,	6,	94,	},
	{ "Miltenberg 4",			"MIL4",		1,	6,	95,	},
	{ "Rockenhausen 6 (KL2)",		"ROK6",		1,	6,	96,	},
	{ "Mannheim 499 (Pfingstb. No)",	"BAHN01",	1,	6,	97,	},
	{ "Mannheim 4",				"MA4",		1,	6,	99,	},
	{ "Beuron 1",				"BEU1",		1,	7,	1,	},
	{ "Albstadt-Laufen 1",			"ALB1",		1,	7,	2,	},
	{ "Oberndorf 3",			"OBD1",		1,	7,	3,	},
	{ "Schwenningen P01",			"SWE1",		1,	7,	4,	},
	{ "Rottweil 0",				"RW0",		1,	7,	5,	},
	{ "Albstadt-Ebingen 2",			"ALB3",		1,	7,	6,	},
	{ "Baiersbronn 1",			"BAI1",		1,	7,	7,	},
	{ "Balingen 1",				"BAL1",		1,	7,	8,	},
	{ "Gosheim 1",				"GOSM1",	1,	7,	9,	},
	{ "Tuttlingen 2",			"TUT2",		1,	7,	10,	},
	{ "Konstanz 0",				"KON0",		1,	7,	11,	},
	{ "Waldburg 2",				"WAB2",		1,	7,	12,	},
	{ "Deggenhausertal 3",			"DHT3",		1,	7,	13,	},
	{ "Sigmaringen 4",			"SIGM4",	1,	7,	14,	},
	{ "Donaueschingen 5",			"DOE5",		1,	7,	15,	},
	{ "Singen 0",				"SIN0",		1,	7,	16,	},
	{ "Klettgau 6",				"KLG6",		1,	7,	17,	},
	{ "Rickenbach 1",			"RIK1",		1,	7,	18,	},
	{ "Bodman-Ludwigshafen 3",		"BOD3X",	1,	7,	19,	},
	{ "Sauldorf 1",				"SAU1",		1,	7,	20,	},
	{ "Hilzingen 1",			"HILZ1",	1,	7,	21,	},
	{ "Stockach 6",				"STO2",		1,	7,	22,	},
	{ "Aichstetten 2",			"AIST2",	1,	7,	23,	},
	{ "Voehrenbach 4",			"VOEH4",	1,	7,	24,	},
	{ "Radolfzell 1",			"RAD1",		1,	7,	25,	},
	{ "Schoemberg-Balingen 2",		"SBA2",		1,	7,	26,	},
	{ "Nagold-Hochdorf 0",			"NAH",		1,	7,	27,	},
	{ "Rottenburg 3",			"ROTT3",	1,	7,	28,	},
	{ "Hechingen 6",			"HECH6",	1,	7,	29,	},
	{ "Ammerbuch 2",			"SKLZ03",	1,	7,	30,	},
	{ "Allensbach 1",			"ALLB",		1,	7,	31,	},
	{ "Villingen 10",			"VILL10",	1,	7,	32,	},
	{ "Tiengen 0",				"TIEN0",	1,	7,	33,	},
	{ "Mengen 1",				"MENG1",	1,	7,	34,	},
	{ "Bad Schussenried 1",			"BSCH1",	1,	7,	35,	},
	{ "Ravensburg 0",			"RAV0",		1,	7,	36,	},
	{ "Friedrichshafen 0",			"TET2",		1,	7,	37,	},
	{ "Nagold 1",				"NAG1",		1,	7,	38,	},
	{ "Baiersbronn 3",			"BAI3",		1,	7,	39,	},
	{ "Grafenhausen 1",			"GRAF",		1,	7,	40,	},
	{ "Bad Saeckingen 0",			"BSK0",		1,	7,	41,	},
	{ "Immenstaad 0",			"IMM",		1,	7,	42,	},
	{ "Altensteig 2",			"ALTST2",	1,	7,	43,	},
	{ "St. Georgen 1",			"STG1",		1,	7,	44,	},
	{ "Sulz 3",				"SU3",		1,	7,	45,	},
	{ "Murg 2",				"MURG2",	1,	7,	46,	},
	{ "Tengen 2",				"TEN2",		1,	7,	47,	},
	{ "Waldshut 4",				"WAL4",		1,	7,	48,	},
	{ "Leutkirch 0",			"LEUT0",	1,	7,	49,	},
	{ "Triberg 2",				"TRI2",		1,	7,	50,	},
	{ "Furtwangen 2",			"FURT2",	1,	7,	51,	},
	{ "Tettnang 4",				"TET4",		1,	7,	52,	},
	{ "Ostrach 2",				"OST2",		1,	7,	53,	},
	{ "Haigerloch 0",			"HAIG0",	1,	7,	54,	},
	{ "Alpirsbach 4",			"ALPI1",	1,	7,	56,	},
	{ "Pfullendorf 1 <Prov.>",		"PFUL3",	1,	7,	57,	},
	{ "Rottweil 7",				"RW7",		1,	7,	58,	},
	{ "Baiersbronn 2",			"BAI2",		1,	7,	60,	},
	{ "Bad Wurzach 1",			"BWU1",		1,	7,	61,	},
	{ "Wangen 1",				"WANG1",	1,	7,	62,	},
	{ "Markdorf 1",				"MARK1",	1,	7,	63,	},
	{ "Burladingen 1",			"BURL1",	1,	7,	64,	},
	{ "Gammertingen 3",			"GAMT3",	1,	7,	65,	},
	{ "Kisslegg 2",				"KISS2",	1,	7,	66,	},
	{ "Kressbronn 3",			"KRES3",	1,	7,	67,	},
	{ "Freudenstadt 0",			"DORN4",	1,	7,	69,	},
	{ "Geisingen 1",			"GEIS1",	1,	7,	70,	},
	{ "Isny 0",				"ISNY0",	1,	7,	71,	},
	{ "Schramberg 1",			"SBG1",		1,	7,	79,	},
	{ "Eigeltingen 2",			"EIG2",		1,	7,	87,	},
	{ "Talheim 4",				"TAL4",		1,	7,	93,	},
	{ "Heiligenberg 0",			"HEILB0",	1,	7,	94,	},
	{ "Spaichingen 3",			"SPAI3",	1,	7,	95,	},
	{ "Blumberg 5",				"BLUM5",	1,	7,	96,	},
	{ "Baiersbronn-Obertal 2",		"VOK",		1,	7,	98,	},
	{ "Engen 4",				"BARG",		1,	7,	99,	},
	{ "Oberammergau 1",			"OAG1",		1,	8,	1,	},
	{ "Schwindegg 1",			"SCHW1",	1,	8,	2,	},
	{ "Bad Aibling 0",			"BAIB0",	1,	8,	3,	},
	{ "Teisendorf 3",			"TEIS3",	1,	8,	4,	},
	{ "Miesbach 4 (Ers.f.Bruckmuehl)",	"BRU2",		1,	8,	5,	},
	{ "Oberaudorf 2",			"OADO2",	1,	8,	6,	},
	{ "Ramsau 1",				"RAMS1",	1,	8,	7,	},
	{ "Reit im Winkl 0",			"RIW0",		1,	8,	8,	},
	{ "Bad Reichenhall 2",			"BREI2",	1,	8,	9,	},
	{ "Landau/Isar 3",			"EAUF1",	1,	8,	10,	},
	{ "Tann 2",				"TANN2",	1,	8,	11,	},
	{ "Neufahrn 81",			"ALHN99",	1,	8,	12,	},
	{ "Attenkirchen 1",			"ATK99",	1,	8,	13,	},
	{ "Olching 0 (Wolfstrasse)",		"MKLZ28",	1,	8,	14,	},
	{ "Seeshaupt 1",			"SH99",		1,	8,	15,	},
	{ "Wolfratshausen 2",			"MKLZ32",	1,	8,	16,	},
	{ "Starnberg 5 (Wangen)",		"MKLZ31",	1,	8,	17,	},
	{ "Tittmoning 1 (Froschham)",		"TITT1",	1,	8,	18,	},
	{ "Herrsching 1 (Widdersberg)",		"HSG1",		1,	8,	19,	},
	{ "Wolfratshausen 1",			"ICKI99",	1,	8,	20,	},
	{ "Bad Reichenhall 1 <Prov.>",		"BREI",		1,	8,	21,	},
	{ "Passau 11 (Dommelstadl)",		"DST1",		1,	8,	22,	},
	{ "Pfarrkirchen Niederbay 1",		"PFI1",		1,	8,	23,	},
	{ "Anger 1",				"AN1",		1,	8,	24,	},
	{ "Obernzell",				"OZEL",		1,	8,	25,	},
	{ "Hohenpeissenberg 2",			"HHP2",		1,	8,	26,	},
	{ "Garmisch-Partenkirchen 4",		"GAR4X",	1,	8,	27,	},
	{ "Grainet 1",				"GRN1",		1,	8,	28,	},
	{ "Glonn 1",				"GLN1",		1,	8,	29,	},
	{ "Taufkirchen/Vils 2",			"TKI99",	1,	8,	30,	},
	{ "Freyung 1",				"FYG1",		1,	8,	31,	},
	{ "Mainburg 1",				"MNBG1",	1,	8,	32,	},
	{ "Diessen 2",				"DSN2",		1,	8,	33,	},
	{ "Berchtesgaden 15",			"BGN15",	1,	8,	34,	},
	{ "Fuerstenfeldbruck 2",		"MKLZ30",	1,	8,	35,	},
	{ "Markt Schwaben 1(Neufinsing)",	"MKLZ22",	1,	8,	36,	},
	{ "Murnau 70 (Ohlstadt)",		"MUR70",	1,	8,	37,	},
	{ "Landsberg 3 (Poessing)",		"LBG99",	1,	8,	38,	},
	{ "Dingolfing 2 (Brunn)",		"DGF2",		1,	8,	39,	},
	{ "Grafing 21 (Ebersberg)",		"GRAF21",	1,	8,	40,	},
	{ "Muehldorf 0",			"MDF0",		1,	8,	41,	},
	{ "Grassau 2",				"GSU2",		1,	8,	42,	},
	{ "Ergoldsbach 2",			"EGB2",		1,	8,	43,	},
	{ "Weyarn 3",				"WYN3",		1,	8,	44,	},
	{ "Hausham 99 (Schliersbergalm)",	"HHM99",	1,	8,	45,	},
	{ "Freising 3 (Schiesspl.)",		"FRS99",	1,	8,	46,	},
	{ "Kochel am See 4 (Kreutalm)",		"KAS98",	1,	8,	47,	},
	{ "Woerth 1 <Ers. f. Adlk. 1>",		"WTH1",		1,	8,	48,	},
	{ "Holzkirchen 62",			"HKI62",	1,	8,	49,	},
	{ "Dachau 91(Bayernw.i.Karlsf.)",	"DACH99",	1,	8,	50,	},
	{ "Hallbergmoos 2 (FMG)",		"HBGM99",	1,	8,	51,	},
	{ "Petershausen 1",			"PHSN1",	1,	8,	52,	},
	{ "Roehrmoos 2",			"RMS2",		1,	8,	53,	},
	{ "Ruhpolding 1 (Rauschberg)",		"RPD1",		1,	8,	54,	},
	{ "Geltendorf 1 (Wasserbeh.)",		"GDF99",	1,	8,	55,	},
	{ "Trostberg 3",			"TBG1",		1,	8,	56,	},
	{ "Dorfen 1",				"DORF1",	1,	8,	57,	},
	{ "Dachau 3 (Krankenhaus)",		"MKLZ25",	1,	8,	59,	},
	{ "Vilsbiburg 2",			"VILS2",	1,	8,	60,	},
	{ "Mallersdorf 2",			"MALL2",	1,	8,	61,	},
	{ "Mammendorf 1 (Hattenhofen)",		"MAMM99",	1,	8,	62,	},
	{ "Traunstein 2",			"TS2",		1,	8,	63,	},
	{ "Markt Schwaben 0",			"MSBN0",	1,	8,	64,	},
	{ "Bernbeuren 1",			"BBN1",		1,	8,	65,	},
	{ "Landshut 1",				"LA1",		1,	8,	66,	},
	{ "Holzkirchen 3",			"HKI3",		1,	8,	67,	},
	{ "Rosenheim Oberbay 0",		"RO0",		1,	8,	68,	},
	{ "Schnaitsee 1",			"SNE1",		1,	8,	69,	},
	{ "Waakirchen 0",			"WAA",		1,	8,	70,	},
	{ "Wasserburg 1",			"WSBG1",	1,	8,	71,	},
	{ "Prien 1",				"PRI1",		1,	8,	72,	},
	{ "Waldkraiburg 0",			"MHLD0",	1,	8,	73,	},
	{ "Burghausen 5",			"BHS99",	1,	8,	74,	},
	{ "Kirchseeon 0",			"KISE0",	1,	8,	75,	},
	{ "Fuerstenfeldbruck 0",		"FFB0",		1,	8,	76,	},
	{ "Moosinning 1",			"MOSI1",	1,	8,	77,	},
	{ "Sulzemoos 1 (BAB-P.)",		"SULZ98",	1,	8,	78,	},
	{ "Vilshofen 1",			"VIH1",		1,	8,	79,	},
	{ "Bayrischzell",			"BAYZ",		1,	8,	80,	},
	{ "Reischach 1",			"REI",		1,	8,	81,	},
	{ "Simbach/Inn 2",			"SIM2",		1,	8,	84,	},
	{ "Hauzenberg 2",			"HAUZ2",	1,	8,	85,	},
	{ "Sindelsdorf 10",			"SIDO10",	1,	8,	86,	},
	{ "Zolling 1 (Grossenviecht)",		"ZOLL99",	1,	8,	90,	},
	{ "Griesbach 1 (OBAG)",			"GRIB1",	1,	8,	91,	},
	{ "Kochel am See 1",			"KAS1",		1,	8,	92,	},
	{ "Isen 1",				"IS1",		1,	8,	93,	},
	{ "Tegernsee 1 (Ringberg)",		"RING",		1,	8,	94,	},
	{ "Gangkofen-Kollbach 1",		"GKKB1",	1,	8,	95,	},
	{ "Lenggries 0",			"LGS0",		1,	8,	96,	},
	{ "Pfeffenhausen 1",			"PFE1",		1,	8,	99,	},
	{ "Arnstein 2",				"ARN",		1,	9,	1,	},
	{ "Bad Steben 1",			"SCHNB",	1,	9,	2,	},
	{ "Bayerisch Eisenstein 1",		"BYS1X",	1,	9,	3,	},
	{ "Berg 2",				"EISE",		1,	9,	4,	},
	{ "Rottendorf 3",			"BIEB",		1,	9,	5,	},
	{ "Werneck 2",				"WNECK2",	1,	9,	6,	},
	{ "Bayreuth-Oschenberg 1",		"BYR1",		1,	9,	7,	},
	{ "Kulmbach 4",				"KULM",		1,	9,	8,	},
	{ "Pressig 1",				"PRES",		1,	9,	10,	},
	{ "Bischofsgruen 2",			"BIGR2",	1,	9,	11,	},
	{ "Hof-Labyrinth 2",			"HOF2",		1,	9,	12,	},
	{ "Kist 1",				"KIST",		1,	9,	13,	},
	{ "Bodenwoehr 1",			"BDWR1",	1,	9,	14,	},
	{ "Burglengenfeld 3",			"BLF3",		1,	9,	15,	},
	{ "Burgwindheim 1",			"BUW1",		1,	9,	16,	},
	{ "Buttenheim 1",			"BUT1",		1,	9,	17,	},
	{ "Iphofen 2",				"IPHN2",	1,	9,	18,	},
	{ "Cham 1",				"CHA1",		1,	9,	19,	},
	{ "Tauberbischofsheim 4",		"TBIO4",	1,	9,	20,	},
	{ "Unterpleichfeld 2",			"UPLF2",	1,	9,	21,	},
	{ "Uettingen 4",			"UETT4",	1,	9,	22,	},
	{ "Erbendorf 1",			"ERBN1",	1,	9,	23,	},
	{ "Deggendorf 1",			"DGD1",		1,	9,	24,	},
	{ "Oberthulba 3",			"KN51",		1,	9,	25,	},
	{ "Laaber 5",				"LAAB5",	1,	9,	26,	},
	{ "Seubersdorf 2",			"SEUB2",	1,	9,	27,	},
	{ "Riedenburg 2",			"RIED2",	1,	9,	28,	},
	{ "Oberwerrn 51",			"OBW51",	1,	9,	29,	},
	{ "Abensberg 1",			"ABBG1",	1,	9,	31,	},
	{ "Hemau 3",				"HEM3",		1,	9,	32,	},
	{ "Hirschau 1",				"HIR1",		1,	9,	33,	},
	{ "Hofheim 1",				"HFH1X",	1,	9,	34,	},
	{ "Karlstadt 3",			"KARL",		1,	9,	35,	},
	{ "Kelheim 2",				"KLH2",		1,	9,	36,	},
	{ "Bamberg 6",				"BAMB",		1,	9,	37,	},
	{ "Oberaurach 1",			"ZEIL1",	1,	9,	38,	},
	{ "Pfarrweisach 1",			"PFWA1",	1,	9,	39,	},
	{ "Kirchlauter 1",			"KLTR1",	1,	9,	40,	},
	{ "Schesslitz 2",			"SCHZ2",	1,	9,	41,	},
	{ "Zapfendorf 2",			"ZAPF1",	1,	9,	42,	},
	{ "Beratzhausen 1",			"BZHS1",	1,	9,	43,	},
	{ "Rehau 1",				"REHA1",	1,	9,	44,	},
	{ "Neustadt/Coburg 1",			"NEUST1",	1,	9,	45,	},
	{ "Kronach 1",				"KRN1",		1,	9,	46,	},
	{ "Langquaid 1",			"LANG1",	1,	9,	47,	},
	{ "Amberg 0",				"AMB0",		1,	9,	48,	},
	{ "Pleystein 1",			"PLEY1",	1,	9,	49,	},
	{ "Lauda-Koenigshofen 3",		"LDK3",		1,	9,	50,	},
	{ "Lichtenfels 2",			"LIFS99",	1,	9,	51,	},
	{ "Muennerstadt 1",			"MUENR1",	1,	9,	53,	},
	{ "Meeder 1",				"MED1",		1,	9,	54,	},
	{ "Bad Kissingen 1",			"BKG1",		1,	9,	55,	},
	{ "Hammelburg 8",			"HMBG8",	1,	9,	56,	},
	{ "Marktheidenfeld 2",			"MHF2",		1,	9,	59,	},
	{ "Straubing 0",			"STBG0",	1,	9,	60,	},
	{ "Schoefweg 1",			"SCHOE1",	1,	9,	61,	},
	{ "Koetzting 1",			"KOETZ1",	1,	9,	62,	},
	{ "Illschwang 3",			"ILLS3",	1,	9,	64,	},
	{ "Oberbach 1",				"OBB1X",	1,	9,	66,	},
	{ "Oberviechtach 2",			"OVT2",		1,	9,	67,	},
	{ "Ochsenfurt 3",			"OCHS3",	1,	9,	68,	},
	{ "Pfatter 0",				"PFAT0",	1,	9,	69,	},
	{ "Regensburg 1",			"R1",		1,	9,	70,	},
	{ "Regensburg 4",			"RBG42",	1,	9,	71,	},
	{ "Schweinfurt 30",			"SW30",		1,	9,	72,	},
	{ "Selb 1",				"SELB1",	1,	9,	73,	},
	{ "Stallwang 2",			"STALL2",	1,	9,	74,	},
	{ "Bad Koenigshofen 1",			"KHF1",		1,	9,	75,	},
	{ "Alladorf 1",				"AL1",		1,	9,	76,	},
	{ "Tirschenreuth 0",			"TIR0",		1,	9,	77,	},
	{ "Waldmuenchen 1",			"WMCHN1",	1,	9,	78,	},
	{ "Weiden 1",				"WDN1",		1,	9,	79,	},
	{ "Werbach-Gamburg 2 <pr GAM3>",	"WERBG2",	1,	9,	80,	},
	{ "Wiesentheid 1",			"WSD1X",	1,	9,	81,	},
	{ "Wuerzburg 2",			"WUE2",		1,	9,	82,	},
	{ "Wunsiedel-Koesseine 2",		"WUNS2",	1,	9,	83,	},
	{ "Zell-Waldstein 2",			"ZLL2",		1,	9,	84,	},
	{ "Trockau 1",				"TROK1",	1,	9,	85,	},
	{ "Mitterfels 1",			"MITF1",	1,	9,	87,	},
	{ "Nabburg 2",				"NABB2",	1,	9,	88,	},
	{ "Obernsees 1",			"OBS1",		1,	9,	90,	},
	{ "Roding 1",				"ROD1",		1,	9,	91,	},
	{ "Gerchsheim 1",			"GERH1",	1,	9,	93,	},
	{ "Coburg 5",				"ECKBG",	1,	9,	94,	},
	{ "Karlstadt-Wiesenfeld 1",		"BAHN12",	1,	9,	96,	},
	{ "Wuerzburg 74",			"BAHN13",	1,	9,	97,	},
	{ "Waldsassen 1",			"WASA1",	1,	9,	98,	},
	{ "Zell/Opf. 1",			"ZELL1",	1,	9,	99,	},
	{ "Neuss 10",				"NEU10",	2,	2,	1,	},
	{ "Duesseldorf 57 (Messe)",		"D98",		2,	2,	2,	},
	{ "Neuss 7",				"NEU7",		2,	2,	4,	},
	{ "Ratingen 5",				"RAT5",		2,	2,	6,	},
	{ "Solingen 2",				"SOL2",		2,	2,	7,	},
	{ "Duesseldorf 18",			"D18",		2,	2,	8,	},
	{ "Duesseldorf 58",			"D99",		2,	2,	9,	},
	{ "Neuss 14",				"NEU14",	2,	2,	10,	},
	{ "Neuss-Norf 1",			"NEUNO1",	2,	2,	11,	},
	{ "Duesseldorf 30",			"D30",		2,	2,	12,	},
	{ "Langenfeld 3",			"LANF3",	2,	2,	13,	},
	{ "Duesseldorf 75",			"D75",		2,	2,	14,	},
	{ "Mettmann 7",				"MTM4",		2,	2,	15,	},
	{ "Duesseldorf 19",			"D19",		2,	2,	17,	},
	{ "Grevenbroich 3",			"GVB3",		2,	2,	18,	},
	{ "Grevenbroich-Kapellen 2",		"GVBK",		2,	2,	19,	},
	{ "Ratingen 1",				"RAT1",		2,	2,	20,	},
	{ "Duesseldorf 40",			"D97",		2,	2,	22,	},
	{ "Neuss 8",				"NEU8",		2,	2,	23,	},
	{ "Duesseldorf 4",			"D4",		2,	2,	24,	},
	{ "Hilden 6",				"HDN6",		2,	2,	26,	},
	{ "Duesseldorf 12",			"D12",		2,	2,	27,	},
	{ "Ratingen 3",				"RAT3",		2,	2,	29,	},
	{ "Remscheid 4 <geneigt>",		"REM4",		2,	2,	30,	},
	{ "Krefeld 4",				"KRF4",		2,	2,	31,	},
	{ "Lank 0",				"LANK",		2,	2,	33,	},
	{ "Osterath 0",				"OSTER0",	2,	2,	35,	},
	{ "Krefeld 5",				"KRF5",		2,	2,	36,	},
	{ "Meerbusch-Buederich 1",		"MEEB1",	2,	2,	37,	},
	{ "Duesseldorf 27",			"D27",		2,	2,	38,	},
	{ "Duesseldorf 53",			"D53",		2,	2,	39,	},
	{ "Willich 1",				"WIL1",		2,	2,	42,	},
	{ "Solingen 1 <Ant.geneigt>",		"SOL1",		2,	2,	43,	},
	{ "Moenchengladbach 18",		"MGL18",	2,	2,	44,	},
	{ "Haan 0",				"HAAN",		2,	2,	45,	},
	{ "Krefeld 7",				"FISCH",	2,	2,	46,	},
	{ "Duesseldorf 9 (Rheintunnel)",	"D9",		2,	2,	47,	},
	{ "Duesseldorf 2.8046",			"D2",		2,	2,	49,	},
	{ "Langenfeld 89",			"LANF",		2,	2,	52,	},
	{ "Mettmann 2",				"MTM2X",	2,	2,	66,	},
	{ "Wuppertal 23",			"WUP23",	2,	2,	78,	},
	{ "Duesseldorf 10 <Bake>",		"D10",		2,	2,	88,	},
	{ "Aachen 9",				"AA99",		3,	2,	1,	},
	{ "Krefeld 19",				"KRF19",	3,	2,	2,	},
	{ "Moenchengladbach 60",		"MGL60",	3,	2,	3,	},
	{ "Moenchengladbach 3",			"MGL3",		3,	2,	4,	},
	{ "Viersen 4",				"VIE4",		3,	2,	5,	},
	{ "Bedburg 0",				"BEDB",		3,	2,	8,	},
	{ "Moenchengladbach-Rheydt 8",		"MGL8",		3,	2,	13,	},
	{ "Selfkant 0",				"SELF",		3,	2,	15,	},
	{ "Anrath 0",				"ANR99",	3,	2,	17,	},
	{ "Wuerselen 2",			"WUERS2",	3,	2,	19,	},
	{ "Moenchengladbach 8",			"MGLB8",	3,	2,	22,	},
	{ "Langerwehe 1",			"LUCH",		3,	2,	26,	},
	{ "Xanten 1",				"XAN1",		3,	2,	27,	},
	{ "Kleve 7",				"KLV7",		3,	2,	29,	},
	{ "Geldern 0",				"GEL0",		3,	2,	31,	},
	{ "Moers 0",				"MOER0",	3,	2,	32,	},
	{ "Viersen 0",				"VIER0",	3,	2,	33,	},
	{ "Juechen 1",				"JUECH1",	3,	2,	36,	},
	{ "Nettetal-Kaldenkirchen 1",		"NETT1",	3,	2,	40,	},
	{ "Viersen 1",				"VIE1",		3,	2,	42,	},
	{ "Schwalmtal 9",			"SCHWA",	3,	2,	43,	},
	{ "Juechen-Otzenrath 4",		"JUECH4",	3,	2,	44,	},
	{ "Moenchengladbach-Rheydt 7",		"MGLR7",	3,	2,	45,	},
	{ "Stolberg 4",				"STOL4",	3,	2,	46,	},
	{ "Eschweiler 2",			"EWLR2",	3,	2,	48,	},
	{ "Alsdorf 3",				"ALSD3",	3,	2,	49,	},
	{ "Aachen-Kornelimuenster 0",		"AAK",		3,	2,	50,	},
	{ "Aachen 700",				"AA7",		3,	2,	51,	},
	{ "Aachen 120",				"AA120",	3,	2,	52,	},
	{ "Aachen 500 <Ers. f. AA57>",		"AA500",	3,	2,	53,	},
	{ "Erkelenz 0",				"ERKL0",	3,	2,	54,	},
	{ "Geilenkirchen 0",			"GEIL0",	3,	2,	57,	},
	{ "Heinsberg 0",			"HEIN0",	3,	2,	58,	},
	{ "Juelich 3",				"JUEL3",	3,	2,	59,	},
	{ "Kevelaer 98",			"KEVL98",	3,	2,	63,	},
	{ "Straelen 1",				"STRAE1",	3,	2,	64,	},
	{ "Neukirchen-Vluyn 6",			"NEUK6",	3,	2,	65,	},
	{ "Kalkar 7",				"KKAR99",	3,	2,	67,	},
	{ "Wegberg 89 <f. MGL7>",		"WEGB89",	3,	2,	77,	},
	{ "Herzogenrath 2",			"HERA2",	3,	2,	80,	},
	{ "Kevelaer 10",			"GOCH89",	3,	2,	81,	},
	{ "Sonsbeck 0.47B1",			"SONS0",	3,	2,	82,	},
	{ "Moenchengladbach 401",		"MGL40",	3,	2,	84,	},
	{ "Aachen 1 <Mischbake>",		"AA1",		3,	2,	86,	},
	{ "Kempen 4",				"KEMP",		3,	2,	87,	},
	{ "Linnich 1",				"LINN",		3,	2,	88,	},
	{ "Goch 0",				"GOCH0",	3,	2,	90,	},
	{ "Rheinberg 2",			"RHBG2",	3,	2,	98,	},
	{ "Aldenhoven 0",			"AHVN",		3,	2,	99,	},
	{ "Berlin (West) 23 PGiroA",		"B23",		2,	3,	1,	},
	{ "Blnklz 210 GBhf Schoenholz",		"BKLZ78",	2,	3,	2,	},
	{ "Blnklz 101(Ruegenerstr.)",		"BKLZ01",	2,	3,	3,	},
	{ "Blnklz 102(Habersaathstr)",		"BKLZ2",	2,	3,	4,	},
	{ "Blnklz 103(Stresemannstr.)",		"BKLZ03",	2,	3,	5,	},
	{ "Blnklz 407(Wilkestr.15)",		"BKLZ24",	2,	3,	6,	},
	{ "Blnklz 105(Skalitzer Str.)",		"BKLZ05",	2,	3,	7,	},
	{ "Blnklz 201(Luederitzstr.)",		"BKLZ06",	2,	3,	8,	},
	{ "Blnklz 202(Erasmusstr20-24)",	"BKLZ07",	2,	3,	9,	},
	{ "Blnklz 203(Winterfeldstr.)",		"BKLZ08",	2,	3,	10,	},
	{ "Blnklz 307(Wernerwerkdamm)",		"BKLZ25",	2,	3,	11,	},
	{ "Blnklz 205(Karl-Marx-Str.)",		"BKLZ10",	2,	3,	12,	},
	{ "Blnklz 301(Oranienb. Str.)",		"BKLZ11",	2,	3,	13,	},
	{ "Blnklz 302(Auguste V.Allee)",	"BKLZ12",	2,	3,	14,	},
	{ "Blnklz 305(Rathausstr)",		"BKLZ15",	2,	3,	15,	},
	{ "Blnklz 304(Schmargend. Str)",	"BKLZ14",	2,	3,	16,	},
	{ "Blnklz 204(Tempelhofer D.6)",	"BKLZ09",	2,	3,	17,	},
	{ "Blnklz 306(Hannemannstr)",		"BKLZ16",	2,	3,	18,	},
	{ "Blnklz 401(Streitstr)",		"BKLZ17",	2,	3,	19,	},
	{ "Blnklz 405(Kettinger Str.)",		"BKLZ22",	2,	3,	20,	},
	{ "Blnklz 403(Forststr)",		"BKLZ19",	2,	3,	21,	},
	{ "Blnklz 404(Hindenb. Damm)",		"BKLZ20",	2,	3,	22,	},
	{ "Blnklz 104(Lobecks)<gen.Ant>",	"BKLZ04",	2,	3,	23,	},
	{ "Blnklz 211(Alt-Stralau)",		"BKLZ40",	2,	3,	24,	},
	{ "Blnklz 501(Schaeferberg)",		"B3",		2,	3,	25,	},
	{ "Blnklz 212(Elsastrasse 26)",		"BKLZ41",	2,	3,	28,	},
	{ "Blnklz 106(Franz-J)<gen.Ant>",	"BKLZ31",	2,	3,	29,	},
	{ "Blnklz 308(Schnellerstr.)",		"BKLZ42",	2,	3,	30,	},
	{ "Blnklz 309(Koepenicker A.)",		"BKLZ43",	2,	3,	31,	},
	{ "Blnklz 310(Amanlisweg 10)",		"BKLZ44",	2,	3,	32,	},
	{ "Blnklz 311(Bitterfelder Str)",	"BKLZ45",	2,	3,	33,	},
	{ "Blnklz 312(E.-Barlach-Str.)",	"BKLZ46",	2,	3,	34,	},
	{ "Blnklz 420(Flankenschanze)",		"BKLZ23",	2,	3,	35,	},
	{ "Blnklz 107(Lilli-Henoch-Str)",	"BKLZ32",	2,	3,	36,	},
	{ "Blnklz 314(Buchholzer Str)",		"BKLZ48",	2,	3,	37,	},
	{ "Blnklz 408(Rudower Chaus.)",		"BKLZ49",	2,	3,	38,	},
	{ "Blnklz 409(O.-Geschke-Str)",		"BKLZ50",	2,	3,	39,	},
	{ "Blnklz 001(Rochstr)<gen.Ant>",	"BKLZ30",	2,	3,	40,	},
	{ "Blnklz 213(E.-Reuter-Platz)",	"BKLZ79",	2,	3,	41,	},
	{ "Blnklz 418(Schoenefeld)",		"BKLZ56",	2,	3,	48,	},
	{ "Blnklz 206(Coppist)<gen.Ant>",	"BKLZ33",	2,	3,	49,	},
	{ "Blnklz 209(Prenzlauer Pr)",		"BKLZ36",	2,	3,	57,	},
	{ "Blnklz 208(Liebermann.75)",		"BKLZ35",	2,	3,	58,	},
	{ "Blnklz 207(Herzberg.105)",		"BKLZ34",	2,	3,	59,	},
	{ "Blnklz 303(Masurenallee)",		"BKLZ13",	2,	3,	60,	},
	{ "Blnklz 402(Scholzplatz)",		"BKLZ18",	2,	3,	61,	},
	{ "Blnklz 601(Flotowstr.)",		"BKLZ75",	2,	3,	64,	},
	{ "Blnklz 602(Breitestr.)",		"BKLZ68",	2,	3,	65,	},
	{ "Blnklz 002(Karl-Marx-Allee)",	"BKLZ71",	2,	3,	70,	},
	{ "Blnklz 516 (Avus)",			"BKLZ77",	2,	3,	95,	},
	{ "Hamburg 282 (PA90 Harb.Z44)",	"HRBG",		2,	4,	13,	},
	{ "Hannover 790",			"HAN790",	2,	5,	1,	},
	{ "Barsinghausen 2",			"BAR2",		2,	5,	2,	},
	{ "Bergen 1",				"BERG1",	2,	5,	3,	},
	{ "Celle 0",				"CE0",		2,	5,	4,	},
	{ "Salzhemmendorf 1",			"SZH1",		2,	5,	5,	},
	{ "Peine 1",				"PEI1",		2,	5,	6,	},
	{ "Sibbesse 1",				"SIB1",		2,	5,	7,	},
	{ "Braunschweig 3",			"BS3",		2,	5,	9,	},
	{ "Wietze 2",				"WIET2",	2,	5,	10,	},
	{ "Wolfsburg 1",			"WOB1",		2,	5,	11,	},
	{ "Sprakensehl 1",			"SPR1",		2,	5,	12,	},
	{ "Wesendorf 1",			"WEDF",		2,	5,	13,	},
	{ "Alfeld 40",				"ALF40",	2,	5,	14,	},
	{ "Semmenstedt 99",			"SEM99",	2,	5,	17,	},
	{ "Hildesheimer Boerde 99",		"HIBO",		2,	5,	18,	},
	{ "Eschede 1",				"ED1",		2,	5,	19,	},
	{ "Loccum 0",				"LOCC0",	2,	5,	21,	},
	{ "Zernien 1",				"ZNN1",		2,	5,	22,	},
	{ "Gartow 2",				"GTO1",		2,	5,	23,	},
	{ "Bispingen 41",			"BISP98",	2,	5,	24,	},
	{ "Hannover 4 (Hamburger Al)",		"HAN4",		2,	5,	26,	},
	{ "Hannover 951 (Gradestr. 22)",	"HAKL10",	2,	5,	27,	},
	{ "Hannover 2 (Neue Landstr)",		"HAKL21",	2,	5,	28,	},
	{ "Hannover 953 (Bischofshofer)",	"HAKL33",	2,	5,	29,	},
	{ "Hannover 954 (HildesheimerS)",	"HAKL41",	2,	5,	30,	},
	{ "Hannover 210 (Goettinger Str)",	"HAKL52",	2,	5,	31,	},
	{ "Uetze 99",				"UETZ99",	2,	5,	32,	},
	{ "Garbsen 10",				"GRB10",	2,	5,	33,	},
	{ "Wedemark 1",				"WED1",		2,	5,	34,	},
	{ "Burgwedel 0",			"BGW1",		2,	5,	35,	},
	{ "Schwarmstedt 0",			"SWST0",	2,	5,	36,	},
	{ "Lehrte 2",				"LEH2",		2,	5,	37,	},
	{ "Sarstedt 1",				"SST1",		2,	5,	38,	},
	{ "Ronnenberg 9",			"RON9",		2,	5,	39,	},
	{ "Walsrode 1",				"WSR1",		2,	5,	40,	},
	{ "Gifhorn 0",				"GIF0",		2,	5,	41,	},
	{ "Hitzacker 1",			"HITZ1",	2,	5,	42,	},
	{ "Hildesheim 1",			"HILD1",	2,	5,	43,	},
	{ "Bleckede/Barsk.1",			"BBK1",		2,	5,	44,	},
	{ "Einbeck 2",				"EINB2",	2,	5,	46,	},
	{ "Braunschweig 701",			"BS4",		2,	5,	48,	},
	{ "Hameln 10",				"HM10",		2,	5,	49,	},
	{ "Schneverdingen 0",			"SVG",		2,	5,	50,	},
	{ "Helmstedt 2",			"HE2",		2,	5,	51,	},
	{ "Hannover 610",			"AWB61",	2,	5,	52,	},
	{ "Braunschweig 360",			"BS36",		2,	5,	54,	},
	{ "Stadthagen 0",			"STDH0",	2,	5,	55,	},
	{ "Nienburg 0",				"NIEN",		2,	5,	58,	},
	{ "Linsburg 1",				"LSB1",		2,	5,	60,	},
	{ "Springe 3",				"SPRG3",	2,	5,	61,	},
	{ "Hannover 860",			"HAN860",	2,	5,	62,	},
	{ "Eschershausen 40",			"EHSN40",	2,	5,	63,	},
	{ "Holle 40",				"HOLL40",	2,	5,	64,	},
	{ "Munster 1",				"MUN1",		2,	5,	65,	},
	{ "Burgdorf-Ehlershausen 0",		"BGDEH0",	2,	5,	66,	},
	{ "Salzgitter 40",			"SZGB",		2,	5,	67,	},
	{ "Burgdorf 0",				"BGD0",		2,	5,	68,	},
	{ "Seesen 1",				"SES1",		2,	5,	69,	},
	{ "Kreiensen 1 (Orxhausen)",		"BAHN05",	2,	5,	70,	},
	{ "Obernkirchen 2",			"OBKN2",	2,	5,	74,	},
	{ "Uelzen 3",				"ULZ3",		2,	5,	76,	},
	{ "Jerxheim 1",				"JH0",		2,	5,	78,	},
	{ "Wunstorf 2",				"WUNT2",	2,	5,	80,	},
	{ "Brome 0",				"BRO0",		2,	5,	82,	},
	{ "Salzgitter 0",			"SZG0",		2,	5,	84,	},
	{ "Wendeburg 99",			"WEN99",	2,	5,	85,	},
	{ "Hannover 730 (Langenhagen)",		"HAN730",	2,	5,	86,	},
	{ "Soltau 2",				"SOLT",		2,	5,	87,	},
	{ "Clausthal-Zellerfeld 41",		"CLT41",	2,	5,	90,	},
	{ "Goslar 41",				"GOS41",	2,	5,	91,	},
	{ "Koenigslutter 54",			"KLUT51",	2,	5,	92,	},
	{ "Torfhaus 0",				"TFH0",		2,	5,	93,	},
	{ "Sibbesse 2 (Almstedt)",		"BAHN04",	2,	5,	95,	},
	{ "Hannover Messe",			"HANMES",	2,	5,	97,	},
	{ "Hoever 99",				"HAN99",	2,	5,	98,	},
	{ "Dieburg 2",				"DBG2",		2,	6,	2,	},
	{ "Gross-Umstadt 5<Ers FKLZ58>",	"GRUM",		2,	6,	3,	},
	{ "Brensbach 1",			"FKLZ59",	2,	6,	4,	},
	{ "Heusenstamm 4",			"FKLZ81",	2,	6,	5,	},
	{ "Floersheim 1",			"FKLZ38",	2,	6,	6,	},
	{ "Gross-Gerau 6",			"FKLZ69",	2,	6,	7,	},
	{ "Langen i Hess 0",			"FKLZ24",	2,	6,	8,	},
	{ "Moerfelden-Walldorf 5",		"FKLZ26",	2,	6,	9,	},
	{ "Rodgau 3",				"FKLZ17",	2,	6,	10,	},
	{ "Darmstadt 21",			"FKLZ63",	2,	6,	11,	},
	{ "Darmstadt 2",			"DA2",		2,	6,	12,	},
	{ "Ruesselsheim 3",			"FKLZ70",	2,	6,	13,	},
	{ "Hofheim-Wallau 1",			"FKLZ37",	2,	6,	15,	},
	{ "Eppstein 2",				"FKLZ18",	2,	6,	16,	},
	{ "Wiesbaden 1",			"WI1",		2,	6,	17,	},
	{ "Wiesbaden 33",			"FKLZ34",	2,	6,	18,	},
	{ "Wiesbaden 34",			"FKLZ32",	2,	6,	19,	},
	{ "Wiesbaden 35 (Igstadt)",		"FKLZ35",	2,	6,	20,	},
	{ "Kelsterbach 0.9U",			"MDR",		2,	6,	21,	},
	{ "Mainz-Kastel 2",			"FKLZ33",	2,	6,	22,	},
	{ "Mainz 3",				"FKLZ29",	2,	6,	23,	},
	{ "Mainz 4",				"FKLZ27",	2,	6,	24,	},
	{ "Mainz 5",				"FKLZ30",	2,	6,	25,	},
	{ "Mainz 26",				"FKLZ28",	2,	6,	26,	},
	{ "Niedernhausen 4",			"FKLZ80",	2,	6,	27,	},
	{ "Eppstein 1",				"EPP1",		2,	6,	28,	},
	{ "Roedermark 7",			"ROEM7",	2,	6,	30,	},
	{ "Kastellaun 2",			"KAST",		2,	6,	31,	},
	{ "Lorch Rheingau 3",			"FKLZ45",	2,	6,	32,	},
	{ "Oppenheim 1",			"FKLZ53",	2,	6,	34,	},
	{ "Pfungstadt 1",			"FKLZ40",	2,	6,	35,	},
	{ "Bad Soden 3",			"FKLZ76",	2,	6,	36,	},
	{ "Kronberg i Taunus 3",		"FKLZ21",	2,	6,	37,	},
	{ "Frankfurt 000 (Zeil)",		"FKLZ01",	2,	6,	38,	},
	{ "Frankfurt 085 (Rohm)",		"FKLZ04",	2,	6,	39,	},
	{ "Frankfurt 001 (Raim)",		"FKLZ03",	2,	6,	40,	},
	{ "Frankfurt 118 (Giess)",		"FKLZ05",	2,	6,	41,	},
	{ "Koenigstein i Taunus 3",		"FKLZ20",	2,	6,	42,	},
	{ "Frankfurt 111 (D.Pl)",		"FKLZ06",	2,	6,	43,	},
	{ "Neu-Isenburg 0.8Q",			"FNI82",	2,	6,	44,	},
	{ "Frankfurt 120 (St.H)",		"FKLZ12",	2,	6,	45,	},
	{ "Kriftel 0.8V",			"HATH",		2,	6,	46,	},
	{ "Kelkheim Taunus 1",			"FKLZ19",	2,	6,	47,	},
	{ "Oberursel Taunus 2",			"FKLZ23",	2,	6,	48,	},
	{ "Frankfurt 123 (Berk)",		"FKLZ13",	2,	6,	49,	},
	{ "Frankfurt 046 (Diest)",		"FKLZ08",	2,	6,	50,	},
	{ "Frankfurt 88.9L(TGrVSt7/73)",	"FKLZ02",	2,	6,	51,	},
	{ "Frankfurt 121 (Lyon)",		"FKLZ10",	2,	6,	52,	},
	{ "Frankfurt 021 (Oeser)",		"FKLZ11",	2,	6,	53,	},
	{ "Bad Vilbel 4 <ers. B. Vil5>",	"FKLZ14",	2,	6,	54,	},
	{ "Frankfurt 82.8F (Orb)",		"FKLZ07",	2,	6,	55,	},
	{ "Frankfurt 098 (Flugh)",		"FKLZ64",	2,	6,	56,	},
	{ "Lorch Rheingau 4",			"FKLZ43",	2,	6,	58,	},
	{ "Frankfurt 062 (O.Jah)",		"FKLZ15",	2,	6,	61,	},
	{ "Nastaetten 1",			"NAST1",	2,	6,	62,	},
	{ "Babenhausen 3",			"FKLZ60",	2,	6,	63,	},
	{ "Ober-Ramstadt 5",			"FKLZ41",	2,	6,	65,	},
	{ "Breuberg 1",				"FKLZ67",	2,	6,	66,	},
	{ "Oberwesel 1",			"OBWS1",	2,	6,	72,	},
	{ "Pfalzfeld 1",			"PFLZ",		2,	6,	73,	},
	{ "Rheinboellen 2",			"RHBO2",	2,	6,	74,	},
	{ "Ruedesheim a Rhein 2",		"RUE2X",	2,	6,	75,	},
	{ "Eltville 2",				"ELTV2",	2,	6,	76,	},
	{ "Winterbach 1",			"ECK1",		2,	6,	77,	},
	{ "Boppard 1",				"BOP1",		2,	6,	78,	},
	{ "Frankfurt 122 (O.Kr)",		"FKLZ16",	2,	6,	79,	},
	{ "Stromberg 2 (Eckenroder F.)",	"STRB2",	2,	6,	80,	},
	{ "Trebur 1 (SWF SGM)",			"TRE1",		2,	6,	81,	},
	{ "Frankfurt 26.817",			"FRSD",		2,	6,	83,	},
	{ "Main-Taunus-Zentrum",		"MTZ",		2,	6,	84,	},
	{ "Besigheim 71",			"HNKL25",	2,	7,	1,	},
	{ "Adelberg 0",				"ADB0",		2,	7,	2,	},
	{ "Wildberg 71",			"WILD",		2,	7,	3,	},
	{ "Tuebingen 7",			"TBN7",		2,	7,	4,	},
	{ "Backnang 0",				"BA0",		2,	7,	5,	},
	{ "Goeppingen 0",			"GOEP41",	2,	7,	6,	},
	{ "Weilheim 1",				"BOLL",		2,	7,	7,	},
	{ "Tuebingen 6",			"TBN6X",	2,	7,	8,	},
	{ "Reutlingen 0",			"REU0",		2,	7,	10,	},
	{ "Metzingen 4",			"ULKL24",	2,	7,	12,	},
	{ "Trochtelfingen 2",			"TCF2",		2,	7,	13,	},
	{ "Ebersbach 1",			"EBRB41",	2,	7,	14,	},
	{ "Marbach 41",				"SKLZ35",	2,	7,	15,	},
	{ "Bad Liebenzell 2",			"BLIEB2",	2,	7,	16,	},
	{ "Bad Urach 2",			"ULKL26",	2,	7,	17,	},
	{ "Lichtenstein 2",			"ULKL25",	2,	7,	18,	},
	{ "Muensingen 1",			"ULKL05",	2,	7,	19,	},
	{ "Suessen 0",				"SUES0",	2,	7,	20,	},
	{ "Weinsberg 0",			"HNKL23",	2,	7,	21,	},
	{ "Wendlingen 18",			"WEND8",	2,	7,	22,	},
	{ "Gomadingen 1",			"GOM1",		2,	7,	23,	},
	{ "Backnang 43",			"BA43X",	2,	7,	24,	},
	{ "Maulbronn 42",			"HNKL14",	2,	7,	25,	},
	{ "Ditzingen 5 (Siemens)",		"DITZ99",	2,	7,	26,	},
	{ "Neuenstadt 41",			"HNKL04",	2,	7,	27,	},
	{ "Neckarsulm 72",			"HNKL07",	2,	7,	28,	},
	{ "Heilbronn 41",			"HNKL08",	2,	7,	29,	},
	{ "Stuttgart 41 (Mitte)",		"SKLZ06",	2,	7,	30,	},
	{ "Schwaigern 42",			"HNKL10",	2,	7,	31,	},
	{ "Stuttgart 31 (Bahnpost.)",		"SKLZ08",	2,	7,	32,	},
	{ "Heilbronn 1 (MB)",			"HNKL11",	2,	7,	33,	},
	{ "Besigheim 42",			"HNKL12",	2,	7,	34,	},
	{ "Stuttgart 580 (Daimler)",		"SKLZ14",	2,	7,	35,	},
	{ "Waiblingen 3 (Wasserturm)",		"SKLZ09",	2,	7,	36,	},
	{ "Winnenden 0",			"SKLZ10",	2,	7,	37,	},
	{ "Brackenheim 1",			"HNKL13",	2,	7,	38,	},
	{ "Waiblingen 4 (Remsh.-G.)",		"SKLZ11",	2,	7,	39,	},
	{ "Leonberg 41",			"LEO41",	2,	7,	40,	},
	{ "Stuttgart 582 (Th.-H.-K.)",		"SKLZ13",	2,	7,	41,	},
	{ "Bad Wimpfen 41",			"HNKL16",	2,	7,	42,	},
	{ "Stuttgart 45 (Esslingen)",		"SKLZ15",	2,	7,	43,	},
	{ "Calw 3",				"CLW3",		2,	7,	44,	},
	{ "Loewenstein 41",			"HNKL17",	2,	7,	45,	},
	{ "Boeblingen 4 (Sindelf.)",		"SKLZ20",	2,	7,	46,	},
	{ "Stuttgart 26 (Moehringen)",		"SKLZ21",	2,	7,	47,	},
	{ "Stuttgart 62 (Vaihingen)",		"SKLZ22",	2,	7,	48,	},
	{ "Weil der Stadt 41",			"SKLZ23",	2,	7,	49,	},
	{ "Leonberg 5 (Rutesheim)",		"SKLZ24",	2,	7,	50,	},
	{ "Schwaebisch Gmuend 2",		"SGMD2",	2,	7,	51,	},
	{ "Stuttgart 10",			"S10",		2,	7,	52,	},
	{ "Schorndorf 0",			"SKLZ12",	2,	7,	53,	},
	{ "Muenchingen 51",			"SKLZ27",	2,	7,	54,	},
	{ "Vaihingen 1",			"SKLZ28",	2,	7,	55,	},
	{ "Stuttgart 589 (Flughafen)",		"SKLZ18",	2,	7,	56,	},
	{ "Waldenbuch 3",			"WBU3",		2,	7,	57,	},
	{ "Ludwigsburg 2",			"SKLZ29",	2,	7,	58,	},
	{ "Stuttgart 7",			"S7",		2,	7,	59,	},
	{ "Plochingen 1 (Krankenhaus)",		"SKLZ16",	2,	7,	60,	},
	{ "Stuttgart 49 (Muenster)",		"SKLZ04",	2,	7,	61,	},
	{ "Stuttgart 0 (FA 1)",			"SKLZ07",	2,	7,	62,	},
	{ "Stuttgart 344 (Denkendorf)",		"SKLZ31",	2,	7,	63,	},
	{ "Ludwigsburg 3",			"SKLZ32",	2,	7,	64,	},
	{ "Sachsenheim 42",			"SKLZ26",	2,	7,	65,	},
	{ "Stuttgart 361 (Schanbach)",		"SKLZ30",	2,	7,	66,	},
	{ "Vaihingen 45",			"HNKL18",	2,	7,	67,	},
	{ "Moensheim 43",			"HNKL15",	2,	7,	68,	},
	{ "Neckartenzlingen 6",			"SKLZ33",	2,	7,	69,	},
	{ "Stuttgart 179 (Echterd.)",		"S179",		2,	7,	70,	},
	{ "Gomaringen 0",			"GORI0",	2,	7,	71,	},
	{ "Beilstein 1",			"BEIL1",	2,	7,	72,	},
	{ "Spraitbach 0",			"SPRT0",	2,	7,	74,	},
	{ "Sulzbach 41",			"SKLZ34",	2,	7,	75,	},
	{ "Lenningen 74 (Schopfloch)",		"LNNG74",	2,	7,	76,	},
	{ "Bad Boll 0",				"BOLL0",	2,	7,	77,	},
	{ "Heilbronn 18",			"HB18",		2,	7,	79,	},
	{ "Weinsberg 42",			"WEIN42",	2,	7,	80,	},
	{ "Lorch 1",				"LRCH1",	2,	7,	82,	},
	{ "Nuertingen 41",			"SKLZ02",	2,	7,	87,	},
	{ "Marbach 71",				"SKLZ05",	2,	7,	89,	},
	{ "Kirchheim 0",			"SKLZ17",	2,	7,	90,	},
	{ "Remseck 1",				"NECK",		2,	7,	91,	},
	{ "Ehningen 4",				"SKLZ19",	2,	7,	92,	},
	{ "Kaisersbach 1",			"KABA1",	2,	7,	93,	},
	{ "Neuffen 0",				"NFF0",		2,	7,	94,	},
	{ "Oberderdingen-Flehingen 3",		"BAHN02",	2,	7,	96,	},
	{ "Markgroeningen 4 (Glemstal)",	"BAHN03",	2,	7,	97,	},
	{ "Muenchen 852 (Planegg)",		"M852",		2,	8,	2,	},
	{ "Muenchen 173 (Studentenstadt)",	"M173",		2,	8,	3,	},
	{ "Muenchen 44 (Ufg Ahornstr)",		"MKLZ34",	2,	8,	4,	},
	{ "Muenchen 614 (Oberhaching)",		"M613",		2,	8,	5,	},
	{ "Sauerlach 2",			"MKLZ29",	2,	8,	6,	},
	{ "Vaterstetten 1",			"VATS1",	2,	8,	10,	},
	{ "Muenchen 18",			"M18",		2,	8,	29,	},
	{ "Muenchen 108 (Blumenstrasse)",	"MKLZ01",	2,	8,	30,	},
	{ "Muenchen 270 (Isabellastrasse)",	"MKLZ02",	2,	8,	31,	},
	{ "Muenchen 103 (Arabellastrasse)",	"MKLZ03",	2,	8,	32,	},
	{ "Muenchen 104 (Kirchenstrasse)",	"MKLZ04",	2,	8,	33,	},
	{ "Muenchen 113 (Siemens Werinh)",	"MKLZ05",	2,	8,	34,	},
	{ "Muenchen 0 (Blutenburgstrasse)",	"MKLZ08",	2,	8,	37,	},
	{ "Muenchen 109 (Neuherbergstr.)",	"MKLZ09",	2,	8,	38,	},
	{ "Muenchen 430 (Am Luessl 15)",	"MKLZ12",	2,	8,	39,	},
	{ "Muenchen 106 (Rennb.Daglfing)",	"MKLZ11",	2,	8,	40,	},
	{ "Muenchen 670 (Heinrich-Luebke)",	"MKLZ13",	2,	8,	41,	},
	{ "Muenchen 107 (Harlaching KH)",	"MKLZ14",	2,	8,	42,	},
	{ "Muenchen 112 (Baierbr.Str.)",	"MKLZ15",	2,	8,	43,	},
	{ "Muenchen 110 (Winfrieds.Laim)",	"MKLZ17",	2,	8,	45,	},
	{ "Muenchen 105 (Grossm.Thalk.S.)",	"MKLZ06",	2,	8,	48,	},
	{ "Muenchen 111 (Philips Ridler)",	"MKLZ07",	2,	8,	49,	},
	{ "Muenchen 117 (Garching)",		"MKLZ20",	2,	8,	52,	},
	{ "Gilching 4 <Ers. f. M410>",		"GIL98",	2,	8,	54,	},
	{ "Muenchen 114 (Germering)",		"MKLZ21",	2,	8,	55,	},
	{ "Muenchen 22 (Unterschleissh.)",	"MKLZ23",	2,	8,	57,	},
	{ "Hoehenkirchen 2 <ers. MKLZ24>",	"HK99",		2,	8,	58,	},
	{ "Muenchen 115 (Baierbrunn)",		"MKLZ27",	2,	8,	61,	},
	{ "Muenchen 65 (Stiftsbogen)",		"MKLZ35",	2,	8,	84,	},
	{ "Muenchen 51 (Alzeyerstr.)",		"MKLZ36",	2,	8,	85,	},
	{ "Nuernberg 0",			"N0",		2,	9,	1,	},
	{ "Nuernberg 5",			"N5",		2,	9,	4,	},
	{ "Nennslingen 1",			"NNL1",		2,	9,	5,	},
	{ "Betzenstein 1",			"BTZ1",		2,	9,	6,	},
	{ "Schnaittach 2",			"SCHNA",	2,	9,	9,	},
	{ "Rothenburg 1",			"RBRG1",	2,	9,	14,	},
	{ "Roth 0",				"ROHT0",	2,	9,	19,	},
	{ "Altdorf-Autobahnkreuz 52",		"ALTD51",	2,	9,	20,	},
	{ "Feucht 0",				"FEU0",		2,	9,	21,	},
	{ "Ansbach 1",				"ANSB",		2,	9,	23,	},
	{ "Nuernberg-OPD 9",			"N1",		2,	9,	27,	},
	{ "Nuernberg-Marienberg 92",		"N11",		2,	9,	28,	},
	{ "Nuernberg-Bundesanstalt 89",		"N13",		2,	9,	30,	},
	{ "Nuernberg-Heizkraftwerk 91",		"N14",		2,	9,	31,	},
	{ "Eschenbach 1",			"EBA1",		2,	9,	32,	},
	{ "Nuernberg-Mueller Verlag 94",	"N16",		2,	9,	33,	},
	{ "Lauf 1",				"N21",		2,	9,	34,	},
	{ "Postbauer-Heng 1",			"N22",		2,	9,	35,	},
	{ "Schwabach 5",			"N23",		2,	9,	36,	},
	{ "Herzogenaurach 0",			"N29",		2,	9,	37,	},
	{ "Langenzenn 1",			"N25",		2,	9,	38,	},
	{ "Erlangen 1",				"N26",		2,	9,	39,	},
	{ "Fuerth-Sparkasse 902",		"N37",		2,	9,	41,	},
	{ "Fuerth-Stadeln 904",			"N35",		2,	9,	42,	},
	{ "Nuernberg-Triumph Adler 93",		"N15",		2,	9,	43,	},
	{ "Veitsbronn 3",			"N27",		2,	9,	44,	},
	{ "Rosstal 4",				"N28",		2,	9,	45,	},
	{ "Erlangen 98",			"ERL99",	2,	9,	46,	},
	{ "Sulzbach-Rosenberg 0",		"SUBA0",	2,	9,	49,	},
	{ "Eckental 1",				"ECKT1",	2,	9,	51,	},
	{ "Nuernberg-Suedpumpwerk 905",		"N31",		2,	9,	53,	},
	{ "Wendelstein 2",			"N33",		2,	9,	54,	},
	{ "Erlangen 60",			"N30",		2,	9,	56,	},
	{ "Nuernberg-BePo 907",			"N32",		2,	9,	58,	},
	{ "Hessdorf 0",				"HESS0",	2,	9,	60,	},
	{ "Treuchtlingen 1",			"TREU1",	2,	9,	61,	},
	{ "Solnhofen 3",			"MOHM",		2,	9,	62,	},
	{ "Pommelsbrunn 1",			"PMBN1",	2,	9,	63,	},
	{ "Neustadt 3",				"NSDA2",	2,	9,	64,	},
	{ "Langenfeld 1",			"LFD1",		2,	9,	65,	},
	{ "Stein 901",				"N34",		2,	9,	66,	},
	{ "Graefenberg 2",			"GRBG2",	2,	9,	67,	},
	{ "Hoechstadt 4",			"HCH4",		2,	9,	68,	},
	{ "Ebermannstadt 1",			"EBMN1",	2,	9,	69,	},
	{ "Schwabach 0",			"SBA99",	2,	9,	70,	},
	{ "Uffenheim 4",			"UFF2",		2,	9,	71,	},
	{ "Wilhermsdorf 1",			"WILH1",	2,	9,	72,	},
	{ "Thalmaessing 2",			"THMA2",	2,	9,	73,	},
	{ "Wittelshofen 1",			"WITH1",	2,	9,	74,	},
	{ "Windsbach 2",			"WNDB2",	2,	9,	76,	},
	{ "Gunzenhausen 1",			"GZHS0",	2,	9,	78,	},
	{ "Allersberg 1",			"ALBG1",	2,	9,	79,	},
	{ "Wiesenttal 1",			"WTAL1",	2,	9,	80,	},
	{ "Forchheim 2",			"PBG99",	2,	9,	82,	},
	{ "Heilsbronn 1",			"HBRO1",	2,	9,	85,	},
	{ "Oberasbach 690.47",			"N36",		2,	9,	86,	},
	{ "Muehlhausen 3",			"MH2",		2,	9,	88,	},
	{ "Kipfenberg 3",			"KIBG3",	2,	9,	93,	},
	{ "Burgbernheim 2",			"BBH2",		2,	9,	94,	},
	{ "Greding 3",				"GDN3",		2,	9,	99,	},
	{ "Moenchengladbach-Rheydt 8",		"MGL8",		3,	2,	13,	},
	{ "Teicha 2",				"PHA",		3,	3,	1,	},
	{ "Greifenhagen 1",			"SSN",		3,	3,	2,	},
	{ "Markransteadt 2",			"MARKR2",	3,	3,	4,	},
	{ "Groitsch 6",				"LPZGRO",	3,	3,	6,	},
	{ "Graefenhainichen 4",			"OSK",		3,	3,	7,	},
	{ "Liebertwolkwitz",			"LIEW",		3,	3,	8,	},
	{ "Torgau 4",				"TORG",		3,	3,	9,	},
	{ "Bitterfeld 1",			"BTTF",		3,	3,	10,	},
	{ "Oschatz 3",				"COL",		3,	3,	11,	},
	{ "Leipzig 8 (Stoetteritz)",		"STTZ",		3,	3,	12,	},
	{ "Halle 15",				"HALL",		3,	3,	13,	},
	{ "Grimma end",				"GRI0",		3,	3,	14,	},
	{ "Weissenfels 7",			"PTT",		3,	3,	15,	},
	{ "Leipzig 0 (Universitaet HH)",	"LPZ",		3,	3,	16,	},
	{ "Markranstaedt 3 (Doelzig)",		"LPZDLZ",	3,	3,	17,	},
	{ "Gaschwitz 0",			"LPZGAS",	3,	3,	18,	},
	{ "Leipzig 26 (Lausen)",		"LPZLAU",	3,	3,	19,	},
	{ "Leipzig 70 (Seehausen)",		"LPZMOC",	3,	3,	20,	},
	{ "Schkeuditz 2 (end)",			"LPZSCH",	3,	3,	21,	},
	{ "Koethen 8",				"KOET",		3,	3,	22,	},
	{ "Brandis 2 (Machern)",		"MAC",		3,	3,	23,	},
	{ "Delitzsch 1",			"DELI",		3,	3,	24,	},
	{ "Leipzig 3 (Holzhausen)",		"LPZHOL",	3,	3,	25,	},
	{ "Nebra 3",				"WGN",		3,	3,	26,	},
	{ "Zeitz 9",				"ZEITZ",	3,	3,	27,	},
	{ "Querfurt 2",				"QUERF",	3,	3,	28,	},
	{ "Cobbelsdorf 4",			"COBB4",	3,	3,	36,	},
	{ "Leipzig 49 (Stahmeln)",		"LPZSTA",	3,	3,	37,	},
	{ "Altenburg 2",			"ALBG",		3,	3,	38,	},
	{ "Leipzig 10 (Connewitz)",		"LPZTV3",	3,	3,	40,	},
	{ "Taucha 2",				"LPZTAU",	3,	3,	41,	},
	{ "Leipzig 31 (Eutritzsch)",		"LPZEUT",	3,	3,	42,	},
	{ "Leipzig 69 (Schoenefeld)",		"LPZSFE",	3,	3,	43,	},
	{ "Dommitzsch 1 (Roitzsch)",		"ROI",		3,	3,	44,	},
	{ "Leipzig 62 (Adler)",			"LPZPLA",	3,	3,	45,	},
	{ "Naumburg 0",				"NAUM",		3,	3,	46,	},
	{ "Leipzig 73 (Gohlis)",		"LPZGOH",	3,	3,	47,	},
	{ "Halle 2 (Seeben)",			"HZ04",		3,	3,	48,	},
	{ "Sangerhausen 2",			"LENG",		3,	3,	49,	},
	{ "Halle 21 (Bruckdorf)",		"HZ01",		3,	3,	50,	},
	{ "Colditz 1",				"COLD1",	3,	3,	52,	},
	{ "Hartha 1",				"HTA",		3,	3,	56,	},
	{ "Dessau 12.97B1 (Sued)",		"DESS12",	3,	3,	58,	},
	{ "Eisleben 5",				"ORIDF",	3,	3,	59,	},
	{ "Teutschenthal",			"TEUTS",	3,	3,	60,	},
	{ "Halle 33 (Silberhoehe)",		"HZ05",		3,	3,	61,	},
	{ "Halle 39 (Neustadt)",		"HZ02",		3,	3,	62,	},
	{ "Merseburg 0",			"MRSB",		3,	3,	63,	},
	{ "Schmoelln 1",			"SMLL1",	3,	3,	70,	},
	{ "Eilenburg 7",			"EBG",		3,	3,	71,	},
	{ "Hayn 2",				"HAY",		3,	3,	72,	},
	{ "Dessau 1 (Mildensee prov)",		"DESS",		3,	3,	73,	},
	{ "Borna 0",				"BORNA",	3,	3,	74,	},
	{ "Belgern 2",				"BELPU",	3,	3,	75,	},
	{ "Hettstedt 3",			"HSDT",		3,	3,	76,	},
	{ "Bad Dueben 5 (Wellaune)",		"BDUEB",	3,	3,	77,	},
	{ "Halle 37 (Peissen)",			"HZ03",		3,	3,	78,	},
	{ "Halle 14 (Heide-Nord)",		"HZ06",		3,	3,	79,	},
	{ "Oelzschau 1",			"BGHN",		3,	3,	80,	},
	{ "Doebeln 5",				"DOEB",		3,	3,	81,	},
	{ "Coswig-Anhalt 6 (end)",		"COSA6",	3,	3,	82,	},
	{ "Mockrehna 1",			"MOCK",		3,	3,	83,	},
	{ "Leipzig 19 (Leutzsch)",		"LPZLEU",	3,	3,	84,	},
	{ "Hohenmoelsen",			"HOML1",	3,	3,	85,	},
	{ "Wittenberg 0 (end)",			"WITTB0",	3,	3,	86,	},
	{ "Bad Duerrenberg 4.97B1",		"BDUE",		3,	3,	87,	},
	{ "Kropstaedt 1000",			"KROP10",	3,	3,	88,	},
	{ "Leipzig 32 (Markleeberg)",		"LPZMMA",	3,	3,	89,	},
	{ "Schiffdorf 2",			"SCHFD2",	3,	4,	1,	},
	{ "Emden 0",				"EM0",		3,	4,	2,	},
	{ "Bad Zwischenahn 0",			"BZW0",		3,	4,	4,	},
	{ "Wardenburg 0",			"WARD0",	3,	4,	5,	},
	{ "Bremen 38 (Utbremer Str.)",		"BRM38",	3,	4,	6,	},
	{ "Verden-Walle 1",			"VWA1",		3,	4,	7,	},
	{ "Hoya 1",				"HOY1",		3,	4,	8,	},
	{ "Heeslingen-Boitzen 1",		"HSL1",		3,	4,	9,	},
	{ "Aurich",				"AURI",		3,	4,	10,	},
	{ "Borkum 0",				"BORK0",	3,	4,	11,	},
	{ "Doerpen 0",				"DOER0",	3,	4,	12,	},
	{ "Vechta-Langfoerden 1",		"VLF1",		3,	4,	14,	},
	{ "Jever 0",				"JEV",		3,	4,	15,	},
	{ "Rotenburg 0",			"ROTB0",	3,	4,	16,	},
	{ "Wilhelmshaven 0",			"WHV0",		3,	4,	18,	},
	{ "Cuxhaven 10",			"CUX10",	3,	4,	23,	},
	{ "Harsefeld 1",			"HSFD1",	3,	4,	24,	},
	{ "Leer 1",				"LEE1",		3,	4,	25,	},
	{ "Helgoland 0",			"HGL0",		3,	4,	26,	},
	{ "Hemmoor 1/2",			"HMO1",		3,	4,	27,	},
	{ "Hambergen 1",			"HMB1",		3,	4,	28,	},
	{ "Bassum 3",				"BAS3",		3,	4,	29,	},
	{ "Stade 1",				"STD1",		3,	4,	30,	},
	{ "Bremen 0 (Neuenstr.76)",		"BRM0",		3,	4,	31,	},
	{ "Ottersberg 2",			"OTT2",		3,	4,	33,	},
	{ "Visselhoevede 0",			"VISS0",	3,	4,	34,	},
	{ "Westerstede 9",			"WSST9",	3,	4,	35,	},
	{ "Bremen 135 (Findorf)",		"BRM135",	3,	4,	37,	},
	{ "Ritterhude 0",			"RTH0",		3,	4,	38,	},
	{ "Delmenhorst 0",			"DLH0",		3,	4,	39,	},
	{ "Bremen 80 (Stuhr/Seckenh.)",		"BRM80",	3,	4,	40,	},
	{ "Weyhe 0",				"WYH0",		3,	4,	41,	},
	{ "Bremen 136 (Tenever Hochhs)",	"BRM136",	3,	4,	42,	},
	{ "Lilienthal 3",			"LLT3",		3,	4,	43,	},
	{ "Hude Oldb 0",			"HUD0",		3,	4,	45,	},
	{ "Oldenburg 1 (MB)",			"OD1",		3,	4,	47,	},
	{ "Oldenburg 0",			"OD0",		3,	4,	48,	},
	{ "Norden 0",				"NDN0",		3,	4,	65,	},
	{ "Bremen 130 (Walle Hochhaus)",	"BRM130",	3,	4,	67,	},
	{ "Bremen 131 (Woltmershausen)",	"BRM131",	3,	4,	68,	},
	{ "Bremen 51 (Grolland)",		"BRM132",	3,	4,	69,	},
	{ "Bremen 133 (Huckelriede)",		"BRM133",	3,	4,	70,	},
	{ "Bremen 134 (In der Wisch)",		"BRM134",	3,	4,	71,	},
	{ "Bremen 137 (Kloeckner)",		"BRM137",	3,	4,	74,	},
	{ "Bremen 138 (Grohner Duene)",		"BRM138",	3,	4,	75,	},
	{ "Gross Ippener 0",			"GIP0",		3,	4,	77,	},
	{ "Sulingen 0",				"SLG0",		3,	4,	78,	},
	{ "Hatten 10",				"HAT0",		3,	4,	79,	},
	{ "Zeven 2",				"ZEV2",		3,	4,	80,	},
	{ "Berne 0",				"BERN0",	3,	4,	85,	},
	{ "Bremervoerde 0",			"BRV0",		3,	4,	87,	},
	{ "Osterh.-Scharmb.-Garlst.0",		"OHZG0",	3,	4,	88,	},
	{ "Wangerland-Horumersiel 0",		"HMS0",		3,	4,	89,	},
	{ "Wildeshausen 11",			"WHS11",	3,	4,	90,	},
	{ "Langeoog 1",				"LOG0",		3,	4,	91,	},
	{ "Varel 1",				"VRL1",		3,	4,	92,	},
	{ "Friesoythe 0",			"FRY0",		3,	4,	93,	},
	{ "Kirchlinteln 1",			"KIRL1",	3,	4,	94,	},
	{ "Papenburg 0",			"PAP0",		3,	4,	95,	},
	{ "Cloppenburg 0",			"CLP0",		3,	4,	96,	},
	{ "Wittmund-Burhafe 1",			"WITB1",	3,	4,	98,	},
	{ "Homberg 1",				"HRE1",		3,	5,	1,	},
	{ "Morschen 2",				"BEIS",		3,	5,	2,	},
	{ "Spangenberg 1",			"SPBG",		3,	5,	3,	},
	{ "Kassel Baunatal",			"KSBT",		3,	5,	5,	},
	{ "Korbach 0",				"KOR0",		3,	5,	8,	},
	{ "Arolsen 0",				"AROL1",	3,	5,	9,	},
	{ "Zierenberg 3",			"ZIE3",		3,	5,	10,	},
	{ "Hofgeismar 2",			"HFGM2",	3,	5,	11,	},
	{ "Bad Karlshafen 1",			"BKFN1",	3,	5,	12,	},
	{ "Fritzlar 2",				"FRITZ2",	3,	5,	13,	},
	{ "Warburg 2",				"WAR2",		3,	5,	14,	},
	{ "Willebadessen 1",			"WBE1",		3,	5,	15,	},
	{ "Goettingen 2",			"GOE2",		3,	5,	17,	},
	{ "Moringen-Fredelsloh 1",		"MOF1",		3,	5,	18,	},
	{ "Zierenberg 1",			"ZIE1",		3,	5,	19,	},
	{ "Grossalmerode 1",			"GRA1X",	3,	5,	21,	},
	{ "Kassel 1",				"KS1",		3,	5,	22,	},
	{ "Herzberg 0",				"HERZ0",	3,	5,	25,	},
	{ "Holzminden-Neuhaus 2",		"HZH2",		3,	5,	26,	},
	{ "Rosdorf 40",				"ROSD40",	3,	5,	27,	},
	{ "Osterode 40",			"OSRR40",	3,	5,	28,	},
	{ "Eschwege 5",				"ESW5",		3,	5,	30,	},
	{ "Sontra 2",				"SONT2",	3,	5,	31,	},
	{ "Melsungen 5",			"MELS5",	3,	5,	32,	},
	{ "Hann Muenden 2",			"HMUE2",	3,	5,	33,	},
	{ "Reinhardshagen 40",			"RAHG40",	3,	5,	34,	},
	{ "Bad Sachsa 1",			"BSA1",		3,	5,	35,	},
	{ "Hann Muenden 3",			"BAHN06",	3,	5,	38,	},
	{ "Northeim 4",				"NORT4",	3,	5,	39,	},
	{ "Kassel Vellmar",			"KSVM",		3,	5,	41,	},
	{ "Braunlage 40",			"BRL40",	3,	5,	43,	},
	{ "Waldkappel 99",			"WALD99",	3,	5,	44,	},
	{ "Edertal 99",				"EDT99",	3,	5,	45,	},
	{ "Brakel 2",				"BRAK2",	3,	5,	46,	},
	{ "Hessisch Lichtenau 97",		"HELI97",	3,	5,	47,	},
	{ "Duderstadt Wasserwerk",		"DUDW",		3,	5,	48,	},
	{ "Bad Sooden Allendorf 1",		"BSAD1",	3,	5,	49,	},
	{ "Bad Wildungen 1",			"BWN1",		3,	5,	51,	},
	{ "Woelfterode 99",			"WROD99",	3,	5,	54,	},
	{ "Kalefeld 40",			"KD40",		3,	5,	55,	},
	{ "Kassel 4",				"KS4",		3,	5,	56,	},
	{ "Buchenberg 99",			"BUBG99",	3,	5,	58,	},
	{ "Frankfurt 016",			"F16",		2,	6,	1,	},
	{ "Bad Homburg 0 <FDG>",		"BHBG0",	3,	6,	1,	},
	{ "Friedberg 1",			"FB1",		3,	6,	2,	},
	{ "Schotten Hess 1",			"STT1",		3,	6,	3,	},
	{ "Gelnhausen 7",			"GN7",		3,	6,	4,	},
	{ "Bad Schwalbach 3",			"FKLZ83",	3,	6,	5,	},
	{ "Friedberg 0",			"FB0",		3,	6,	6,	},
	{ "Biedenkopf 2 <prov>",		"BID2",		3,	6,	7,	},
	{ "Biedenkopf 3",			"BID3",		3,	6,	10,	},
	{ "Birstein 3",				"BIR3",		3,	6,	11,	},
	{ "Weibersbrunn 2",			"WBBR2",	3,	6,	12,	},
	{ "Kalbach 1",				"KALB1",	3,	6,	13,	},
	{ "Driedorf 2",				"DRIE2",	3,	6,	14,	},
	{ "Lich 2 <Steinbach Bw-Mast>",		"LICH0",	3,	6,	15,	},
	{ "Hilders 2",				"HIL2",		3,	6,	17,	},
	{ "Frankenberg 0",			"FRANK0",	3,	6,	18,	},
	{ "Friedewald 1",			"FDWD1",	3,	6,	19,	},
	{ "Hanau 1",				"FKLZ50",	3,	6,	21,	},
	{ "Gemuenden/Felda 1",			"GMF1",		3,	6,	22,	},
	{ "Gruenberg 0",			"GRNB0",	3,	6,	23,	},
	{ "Hanau 7",				"HU7",		3,	6,	24,	},
	{ "Hungen 2",				"HUNG2",	3,	6,	25,	},
	{ "Gemuenden 1",			"GMU1",		3,	6,	26,	},
	{ "Biebertal 1",			"BIT1",		3,	6,	27,	},
	{ "Marburg 2",				"MAR2",		3,	6,	28,	},
	{ "Haina Kloster 1 <n. Turm>",		"HKL1",		3,	6,	29,	},
	{ "Weilburg 6",				"WBG6",		3,	6,	30,	},
	{ "Fulda 3",				"FD3",		3,	6,	31,	},
	{ "Bad Hersfeld 2",			"BHEF2",	3,	6,	32,	},
	{ "Schluechtern 3",			"SLN3",		3,	6,	33,	},
	{ "Neuenstein Hess 1",			"NST1",		3,	6,	34,	},
	{ "Ebersburg 2",			"EBER2",	3,	6,	35,	},
	{ "Lauterbach 1",			"LAT1",		3,	6,	36,	},
	{ "Gruenberg 1",			"GRUEN1",	3,	6,	37,	},
	{ "Ortenberg 1",			"ORT1",		3,	6,	38,	},
	{ "Alsfeld 1",				"ALS1",		3,	6,	39,	},
	{ "Katzenelnbogen 1",			"KATZ1",	3,	6,	41,	},
	{ "Aarbergen 1",			"FKLZ47",	3,	6,	43,	},
	{ "Bad Schwalbach 2",			"FKLZ48",	3,	6,	45,	},
	{ "Schlangenbad 1",			"FKLZ49",	3,	6,	46,	},
	{ "Lich Hess. Eberstadt 1",		"EBST1",	3,	6,	47,	},
	{ "Aschaffenburg 14",			"AB14",		3,	6,	48,	},
	{ "Schwalmstadt 1",			"SSDT1",	3,	6,	50,	},
	{ "Nentershausen",			"NENT",		3,	6,	51,	},
	{ "Reichelsheim 2",			"FKLZ62",	3,	6,	52,	},
	{ "Woelfersheim 2 <Wbh>",		"FKLZ68",	3,	6,	53,	},
	{ "Limburg 1",				"LM1",		3,	6,	54,	},
	{ "Rotenburg 1 (TVU)",			"ROF3",		3,	6,	55,	},
	{ "Burgsinn 8",				"BAHN11",	3,	6,	56,	},
	{ "Schlitz 3",				"SLTZ",		3,	6,	57,	},
	{ "Wildeck 1",				"WECK1",	3,	6,	58,	},
	{ "Friedrichsdorf 0.8I",		"KPTL",		3,	6,	59,	},
	{ "Taunusstein 2",			"FKLZ46",	3,	6,	60,	},
	{ "Giessen 0",				"GI0",		3,	6,	61,	},
	{ "Linden 5",				"GI3",		3,	6,	62,	},
	{ "Breitenbach 3",			"BHERZ",	3,	6,	63,	},
	{ "Bad Brueckenau 1",			"BADBR1",	3,	6,	64,	},
	{ "Buseck 6.8Q",			"BUS6",		3,	6,	65,	},
	{ "Eckartshausen 2 endg.",		"FKLZ72",	3,	6,	66,	},
	{ "Steinau 1 (Fa ODW)",			"STEI1",	3,	6,	68,	},
	{ "Nidda 3",				"NID3",		3,	6,	69,	},
	{ "Braunfels 5",			"BRAU5",	3,	6,	70,	},
	{ "Langenselbold 0",			"LSBD0",	3,	6,	71,	},
	{ "Usingen 2",				"USI2",		3,	6,	72,	},
	{ "Ehringshausen 1",			"EHR1",		3,	6,	74,	},
	{ "Seligenstadt 2",			"FKLZ25",	3,	6,	75,	},
	{ "Bad Nauheim 2",			"BNAU2",	3,	6,	77,	},
	{ "Aschaffenburg 11",			"AB11",		3,	6,	78,	},
	{ "Aschaffenburg 13",			"AB13",		3,	6,	79,	},
	{ "Hanau-Grossauheim 5",		"HUAU",		3,	6,	80,	},
	{ "Dillenburg 1",			"DILB1",	3,	6,	81,	},
	{ "Eschenburg 1",			"ESCH1",	3,	6,	82,	},
	{ "Herleshausen 1",			"HERL1",	3,	6,	83,	},
	{ "Idstein 2",				"FKLZ36",	3,	6,	84,	},
	{ "Herborn Hess. 3",			"HRBN3",	3,	6,	85,	},
	{ "Selters 3",				"SELT3",	3,	6,	86,	},
	{ "Bad Camberg 3",			"BCA3",		3,	6,	87,	},
	{ "Karben 1",				"FKLZ65",	3,	6,	88,	},
	{ "Lohr 2",				"LOHR2",	3,	6,	89,	},
	{ "Neuhof-Fulda 3(Landruecken)",	"BAHN10",	3,	6,	90,	},
	{ "Esselbach 2",			"ESB2",		3,	6,	91,	},
	{ "Moembris 4",				"MOEM4",	3,	6,	92,	},
	{ "Obernburg 1",			"OBG99",	3,	6,	93,	},
	{ "Wetzlar 3",				"WZ3",		3,	6,	94,	},
	{ "Guxhagen 1 (Koerle)",		"BAHN07",	3,	6,	95,	},
	{ "Niederaula 3 (Kirchheim)",		"BAHN08",	3,	6,	96,	},
	{ "Huenfeld 2 (Dietershan)",		"BAHN09",	3,	6,	97,	},
	{ "Wiesen 1",				"WIES1",	3,	6,	98,	},
	{ "Faulbach 2",				"FAUL2",	3,	6,	99,	},
	{ "Baden-Baden 5",			"BAD5",		3,	7,	1,	},
	{ "Pforzheim 7",			"PFO7",		3,	7,	2,	},
	{ "Loerrach 4",				"LOR4X",	3,	7,	3,	},
	{ "Badenweiler 1",			"BAW1",		3,	7,	4,	},
	{ "Titisee-Neustadt 4",			"TITI4",	3,	7,	5,	},
	{ "Vogtsburg 1",			"VO1",		3,	7,	6,	},
	{ "Grenzach-Whylen 1",			"GRWY1",	3,	7,	7,	},
	{ "Hausach 1",				"HAU1",		3,	7,	8,	},
	{ "Willstaett 1",			"WST1",		3,	7,	9,	},
	{ "Bad Herrenalb 3",			"BHA3",		3,	7,	10,	},
	{ "Karlsruhe 7 (Hagsfeld)",		"KA7",		3,	7,	11,	},
	{ "Rastatt 6",				"RAST6",	3,	7,	12,	},
	{ "Freiburg-Tiengen P01",		"FRT3",		3,	7,	13,	},
	{ "Gaggenau 0",				"GAG",		3,	7,	14,	},
	{ "Efringen-Kirchen 4",			"EFI4",		3,	7,	15,	},
	{ "Lichtenau 0",			"LICHT",	3,	7,	16,	},
	{ "Eppingen 2",				"HNKL09",	3,	7,	17,	},
	{ "Bad Rappenau 0",			"HNKL03",	3,	7,	18,	},
	{ "Kirchhardt 2",			"HNKL05",	3,	7,	19,	},
	{ "Oberkirch 3",			"OBK3",		3,	7,	20,	},
	{ "Oppenau 2",				"OPP2",		3,	7,	21,	},
	{ "Offenburg 0",			"OG",		3,	7,	22,	},
	{ "Lahr 0",				"LAHR",		3,	7,	23,	},
	{ "Ettenheim 3",			"ETT3",		3,	7,	24,	},
	{ "Achern 2",				"ACH2",		3,	7,	25,	},
	{ "Schwanau 0",				"SCNA",		3,	7,	26,	},
	{ "Oberderdingen-Flehingen 1",		"ODF1",		3,	7,	27,	},
	{ "Pforzheim 2",			"PFO2",		3,	7,	28,	},
	{ "Freiburg 51",			"FR51",		3,	7,	29,	},
	{ "Denzlingen 0",			"DENZ0",	3,	7,	30,	},
	{ "Schopfheim 2",			"SPFH2",	3,	7,	31,	},
	{ "Gengenbach 2",			"GEN2",		3,	7,	32,	},
	{ "Kirchzarten 4",			"KIZN4",	3,	7,	33,	},
	{ "Waldkirch 0",			"WAK0",		3,	7,	35,	},
	{ "Emmendingen 0",			"EMMD0",	3,	7,	36,	},
	{ "Pforzheim 71 (Sonnenhof)",		"PFO71",	3,	7,	37,	},
	{ "Rheinfelden 0",			"RF0",		3,	7,	38,	},
	{ "Bruchsal-Untergrombach 2",		"BRUG2",	3,	7,	39,	},
	{ "Loerrach 5",				"LOR5",		3,	7,	40,	},
	{ "Walzbachtal 1",			"KAKL21",	3,	7,	41,	},
	{ "Karlsruhe 0 (Haupt-PA)",		"KAKL12",	3,	7,	42,	},
	{ "Oestringen 1",			"KAKL48",	3,	7,	43,	},
	{ "Karlsruhe 1 (MB)",			"KAKL40",	3,	7,	44,	},
	{ "Karlsruhe 170 (Neureut)",		"KAKL14",	3,	7,	45,	},
	{ "Karlsruhe 83 (Siemens)",		"KAKL15",	3,	7,	46,	},
	{ "Eichstetten 1",			"EICHN1",	3,	7,	47,	},
	{ "Karlsruhe 88 (Th.-M.-Str.)",		"KAKL16",	3,	7,	48,	},
	{ "Schliengen 3",			"SCHLI3",	3,	7,	49,	},
	{ "Durmersheim 0",			"KAKL42",	3,	7,	51,	},
	{ "Malsch 2",				"KAKL19",	3,	7,	52,	},
	{ "Bruchsal 6",				"KAKL22",	3,	7,	53,	},
	{ "Soellingen P01",			"SOEL",		3,	7,	54,	},
	{ "Freiburg 58",			"FR58",		3,	7,	55,	},
	{ "Freiburg-Industr. Nord P11",		"FR11",		3,	7,	56,	},
	{ "Sinsheim 7",				"KAKL23",	3,	7,	57,	},
	{ "Schluchsee 1",			"SLSE1",	3,	7,	58,	},
	{ "Baden-Baden 0",			"BAD0",		3,	7,	59,	},
	{ "Bad Schoenborn 5",			"BSCHB5",	3,	7,	60,	},
	{ "Linkenheim-Hochstetten 3",		"LIHO3",	3,	7,	61,	},
	{ "Baden-Baden 4",			"BAD4",		3,	7,	62,	},
	{ "St. Blasien 1",			"STB1",		3,	7,	63,	},
	{ "Kehl 0",				"KEHL0",	3,	7,	66,	},
	{ "Marxzell 1",				"MARXZ1",	3,	7,	67,	},
	{ "Bretten 3",				"KAKL51",	3,	7,	68,	},
	{ "Muellheim 7",			"MULL7",	3,	7,	70,	},
	{ "Sulzburg 4",				"SULBG4",	3,	7,	75,	},
	{ "Neuenbuerg 1",			"NEUBG1",	3,	7,	76,	},
	{ "Landau 2",				"LAN2",		3,	7,	77,	},
	{ "Forbach 4",				"FOR3",		3,	7,	79,	},
	{ "Germersheim 2",			"KAKL53",	3,	7,	80,	},
	{ "Waghaeusel 2",			"KAKL24",	3,	7,	81,	},
	{ "Rheinstetten 3",			"RHEI3",	3,	7,	82,	},
	{ "Woerth a Rhein 0",			"KAKL11",	3,	7,	83,	},
	{ "Ruelzheim 3",			"KAKL09",	3,	7,	84,	},
	{ "Zell i.W. 1",			"ZLIW1",	3,	7,	85,	},
	{ "Todtnau 3",				"TODT3",	3,	7,	86,	},
	{ "Maulbronn 41",			"MAUL",		3,	7,	87,	},
	{ "Koenigsbach-Stein 2",		"KLSTB",	3,	7,	88,	},
	{ "Buehl 0",				"BUE2",		3,	7,	90,	},
	{ "Schoenau 2",				"SNAU2",	3,	7,	91,	},
	{ "Karlsbad 2 (Noettingen)",		"NOETT",	3,	7,	92,	},
	{ "Kenzingen 3",			"KEN3",		3,	7,	93,	},
	{ "Schoemberg-Calw 1",			"SCA1",		3,	7,	95,	},
	{ "Wildbad 3 <Prov.>",			"WILB1",	3,	7,	96,	},
	{ "Enzkloesterle 1",			"ENZ1",		3,	7,	97,	},
	{ "Augsburg 1",				"AU1",		3,	8,	1,	},
	{ "Augsburg 3 (Haunstetten)",		"AU97",		3,	8,	2,	},
	{ "Augsburg 10",			"AU10X",	3,	8,	3,	},
	{ "Pfronten 2",				"PFN2",		3,	8,	4,	},
	{ "Dillingen 0",			"DLGN0",	3,	8,	5,	},
	{ "Affing 2",				"AFF2",		3,	8,	6,	},
	{ "Aichach 1",				"AIC1",		3,	8,	7,	},
	{ "Eichstaett 1",			"EICH1",	3,	8,	8,	},
	{ "Dirlewang 3",			"DLW92",	3,	8,	9,	},
	{ "Eurasburg 1",			"ERB1",		3,	8,	10,	},
	{ "Buchloe 1 <Prov. Buchloe 0>",	"BULO1",	3,	8,	11,	},
	{ "Krumbach 2",				"KRUM2",	3,	8,	12,	},
	{ "Meitingen 0",			"MTN0",		3,	8,	13,	},
	{ "Mittelneufnach 1",			"MNFN1",	3,	8,	14,	},
	{ "Schrobenhausen 4",			"SBH4",		3,	8,	15,	},
	{ "Schwabmuenchen 0",			"SWM0",		3,	8,	16,	},
	{ "Thannhausen 2",			"THS2",		3,	8,	17,	},
	{ "Welden 3",				"WE3",		3,	8,	18,	},
	{ "Ziemetshausen 2",			"ZMH97",	3,	8,	19,	},
	{ "Guenzburg 70",			"ULKL11",	3,	8,	20,	},
	{ "Oberstdorf 0",			"OBDO0",	3,	8,	21,	},
	{ "Nesselwang 1",			"NSW1",		3,	8,	22,	},
	{ "Neuburg 1 (IVK)",			"NEUB99",	3,	8,	23,	},
	{ "Oberstaufen 4 (Stiesberg)",		"OBST4",	3,	8,	24,	},
	{ "Groenenbach 1",			"GROE1",	3,	8,	25,	},
	{ "Zusmarshausen 2",			"ZUSM2",	3,	8,	26,	},
	{ "Fuessen 2",				"FSN2",		3,	8,	27,	},
	{ "Lindau 1",				"LIND1",	3,	8,	28,	},
	{ "Augsburg 4 (NCR)",			"AU4",		3,	8,	29,	},
	{ "Augsburg 907",			"AU907",	3,	8,	30,	},
	{ "Stammham 2",				"STHA99",	3,	8,	33,	},
	{ "Ottobeuren 3",			"OTTB2",	3,	8,	34,	},
	{ "Pfaffenhofen a d Ilm 5",		"PFA5",		3,	8,	35,	},
	{ "Pfaffenhofen a d Ilm 0",		"PFA0",		3,	8,	36,	},
	{ "Burgau 0",				"BGU0",		3,	8,	37,	},
	{ "Schweitenkirchen 2",			"SKI99",	3,	8,	38,	},
	{ "Ingolstadt-Zuchering 0",		"IGZ",		3,	8,	39,	},
	{ "Vohburg 1",				"VBG1",		3,	8,	40,	},
	{ "Wolnzach 1",				"WOZ1",		3,	8,	41,	},
	{ "Tapfheim 1",				"TAPF1",	3,	8,	42,	},
	{ "Unterringingen 1",			"URR1",		3,	8,	43,	},
	{ "Kaisheim 3",				"KSH98",	3,	8,	44,	},
	{ "Altenstadt 0 (Iller)",		"ULKL04",	3,	8,	51,	},
	{ "Aitrang 2 (Bergbauer)",		"AIT2",		3,	8,	52,	},
	{ "Babenhausen 1",			"BBHN1",	3,	8,	54,	},
	{ "Gruenenbach 1",			"GRB1",		3,	8,	55,	},
	{ "Immenstadt 1 (Alpe Hochried)",	"IMST1",	3,	8,	57,	},
	{ "Kaufbeuren 7 (Mauerstetten)",	"KFN7",		3,	8,	58,	},
	{ "Memmingen 0",			"MEMM0",	3,	8,	59,	},
	{ "Oberguenzburg 1",			"OGB1",		3,	8,	61,	},
	{ "Sonthofen 1",			"SOHO1",	3,	8,	67,	},
	{ "Weiler 1",				"WEIL1",	3,	8,	68,	},
	{ "Wiggensbach 2",			"WIG2",		3,	8,	70,	},
	{ "Neuburg 2",				"NEUB2",	3,	8,	78,	},
	{ "Poernbach 2",			"PNB99",	3,	8,	81,	},
	{ "Dortmund 85 (Eving)",		"DO85",		4,	2,	8,	},
	{ "Dresden 7 (Gompitz)",		"GPZ",		4,	3,	1,	},
	{ "Crinitz 1",				"BBB",		4,	3,	2,	},
	{ "Dresden 12 (Dachsenberg)",		"DACHS",	4,	3,	3,	},
	{ "Weisswasser 0.47B1",			"WSWS",		4,	3,	4,	},
	{ "Drebkau 1",				"KLO",		4,	3,	5,	},
	{ "Senftenberg 6",			"SENF6",	4,	3,	7,	},
	{ "Radeburg 1",				"FRTL",		4,	3,	8,	},
	{ "Meissen 5 (end)",			"MSSN",		4,	3,	9,	},
	{ "Pirna 7",				"PIRN",		4,	3,	10,	},
	{ "Koenigswartha 1",			"KWTA",		4,	3,	11,	},
	{ "Dresden 3 (Radebeul)",		"DRES3",	4,	3,	12,	},
	{ "Dresden 1 (Postplatz)",		"DRES1",	4,	3,	13,	},
	{ "Pulsnitz 4",				"KEU",		4,	3,	14,	},
	{ "Loebau 5",				"LBAU",		4,	3,	15,	},
	{ "Neukirch 5 (Picho)",			"PICHO",	4,	3,	16,	},
	{ "Neustadt 1 (Unger)",			"NEUDT1",	4,	3,	17,	},
	{ "Goerlitz 7",				"GRLZ",		4,	3,	18,	},
	{ "Zittau 5",				"ZTT",		4,	3,	19,	},
	{ "Altenberg 1 (Lugstein)",		"LUGS",		4,	3,	20,	},
	{ "Riesa 4",				"RIESA",	4,	3,	21,	},
	{ "Burkau 2",				"BURK2",	4,	3,	22,	},
	{ "Dresden 79 (Goennsdorf)",		"DRESBU",	4,	3,	23,	},
	{ "Jessen 2",				"JESS",		4,	3,	24,	},
	{ "Dippoldiswalde 3",			"DIPP",		4,	3,	25,	},
	{ "Heidenau 1",				"DRESHE",	4,	3,	26,	},
	{ "Hoyerswerda 2",			"HYWD",		4,	3,	27,	},
	{ "Dresden 27 ()",			"DRESDS",	4,	3,	28,	},
	{ "Dresden 40 (Dorfhainer Str)",	"DRES40",	4,	3,	29,	},
	{ "Dresden 75 (Striesen)",		"DRES24",	4,	3,	30,	},
	{ "Elsterwerda 5",			"HLP",		4,	3,	31,	},
	{ "Spremberg 5",			"SPRE",		4,	3,	33,	},
	{ "D-Klotzs ???",			"???",		4,	3,	34,	},
	{ "Herzberg 1",				"HERZ",		4,	3,	35,	},
	{ "Dresden 77 (Prohlis)",		"DRESNI",	4,	3,	36,	},
	{ "Niesky 5",				"NSKY",		4,	3,	37,	},
	{ "Dresden 63 (Neustadt)",		"DRESNS",	4,	3,	39,	},
	{ "Burkhardswalde 1",			"BUHW",		4,	3,	40,	},
	{ "Guben 3 <Ers. f. GUBK>",		"GUBEN2",	4,	3,	41,	},
	{ "Bautzen 1",				"BZN",		4,	3,	42,	},
	{ "Bad Schandau 1",			"BSD",		4,	3,	43,	},
	{ "Forst 2",				"FORST",	4,	3,	44,	},
	{ "Bischofswerda 3",			"BHW",		4,	3,	45,	},
	{ "Cottbus 8",				"COTT8",	4,	3,	46,	},
	{ "Ortrand 0",				"ORA",		4,	3,	47,	},
	{ "Tharandt 2",				"THAR2",	4,	3,	48,	},
	{ "Drachhausen 1",			"DH",		4,	3,	49,	},
	{ "Kamenz 5",				"KAMZ5",	4,	3,	51,	},
	{ "Grossenhain 5",			"GROS5",	4,	3,	52,	},
	{ "Lommatzsch 3",			"LOMM3",	4,	3,	54,	},
	{ "Pirna 5",				"PIRN5",	4,	3,	55,	},
	{ "Glashuette 1",			"GLAS1",	4,	3,	56,	},
	{ "Coswig-Sachsen 4",			"COSW4",	4,	3,	57,	},
	{ "Wilsdruff 2",			"WILSD2",	4,	3,	59,	},
	{ "Finsterwalde 3",			"FW",		4,	3,	60,	},
	{ "Neugersdorf 7",			"NEUG7",	4,	3,	61,	},
	{ "Uhyst 1",				"UHYS1",	4,	3,	64,	},
	{ "Pulsnitz 6",				"PULS6",	4,	3,	66,	},
	{ "Doberlug-Kirchhain 2",		"DOB2",		4,	3,	88,	},
	{ "Bad Doberan 5",			"BDBN5",	4,	4,	1,	},
	{ "Crivitz 3",				"CRIV",		4,	4,	2,	},
	{ "Wolgast 3",				"WOLG",		4,	4,	3,	},
	{ "Schwaan 3",				"SCHWAN",	4,	4,	4,	},
	{ "Rostock 26",				"LTTK",		4,	4,	5,	},
	{ "Tessin 3",				"TESS",		4,	4,	6,	},
	{ "Broderstorf 4 <Ers.f.BDD1>",		"BDD4",		4,	4,	7,	},
	{ "Grimmen 2",				"GRIM",		4,	4,	8,	},
	{ "Sassnitz 9 <Ers.f.SASS>",		"SASS9",	4,	4,	9,	},
	{ "Rostock 10",				"ROST10",	4,	4,	10,	},
	{ "Tribsees 3",				"TRIB",		4,	4,	11,	},
	{ "Barth 3",				"BART",		4,	4,	12,	},
	{ "Stralsund 0",			"STS",		4,	4,	13,	},
	{ "Rostock 11",				"RWEI",		4,	4,	14,	},
	{ "Ribnitz-Damgarten 8<Erf.DAS>",	"RIBD",		4,	4,	15,	},
	{ "Kroepelin 2",			"KROEP2",	4,	4,	16,	},
	{ "Greifswald 4",			"GRW",		4,	4,	17,	},
	{ "Bergen 0",				"BRN",		4,	4,	18,	},
	{ "Guestrow 20 <Ers.f.GSW>",		"GSW20",	4,	4,	19,	},
	{ "Schwerin 20",			"SRN",		4,	4,	20,	},
	{ "Bennin 1",				"GRAH",		4,	4,	21,	},
	{ "Ludwigslust 2 <Ers.f.LUDWL>",	"LUDWL2",	4,	4,	24,	},
	{ "Parchim 5",				"PARC",		4,	4,	25,	},
	{ "Bernitt 1",				"BZ4",		4,	4,	26,	},
	{ "Wittenburg 2",			"ZIGM",		4,	4,	27,	},
	{ "Wismar 6",				"WISM",		4,	4,	28,	},
	{ "Gross Godems 1",			"STPE",		4,	4,	29,	},
	{ "Sternberg 2",			"STERN",	4,	4,	30,	},
	{ "Cambs 6",				"RMP",		4,	4,	31,	},
	{ "Schwerin 4",				"SRS",		4,	4,	32,	},
	{ "Rastow 2",				"RASW",		4,	4,	33,	},
	{ "Marnitz 1",				"RUBG",		4,	4,	34,	},
	{ "Goldberg 4 <Ers.f.KKW>",		"GOLD4",	4,	4,	35,	},
	{ "Grevesmuehlen 5",			"HBGE",		4,	4,	36,	},
	{ "Gammelin 1",				"BAND",		4,	4,	37,	},
	{ "Redefin 2",				"REDEL",	4,	4,	38,	},
	{ "Roggendorf 1",			"RGND1",	4,	4,	39,	},
	{ "Heringsdorf 4",			"HID4",		4,	4,	40,	},
	{ "Torgelow 3",				"TOR3",		4,	4,	42,	},
	{ "Zuessow 4",				"ZUES4",	4,	4,	43,	},
	{ "Lalendorf 4",			"HOPE2",	4,	4,	44,	},
	{ "Krakow 4",				"KKW4",		4,	4,	45,	},
	{ "Goehren 2",				"GOER2",	4,	4,	46,	},
	{ "Anklam 2",				"ANK",		4,	4,	47,	},
	{ "Burow 1",				"GOL",		4,	4,	48,	},
	{ "Waren 5",				"WAREN",	4,	4,	49,	},
	{ "Jarmen 7",				"JARM",		4,	4,	52,	},
	{ "Malchin 5",				"RZW",		4,	4,	53,	},
	{ "Friedland 3",			"FRIL",		4,	4,	56,	},
	{ "Stavenhagen 0",			"STVH",		4,	4,	57,	},
	{ "Ueckermuende 3",			"UECK",		4,	4,	58,	},
	{ "Schoenberg 5 <Ers.f.Repeat>",	"SCHOEB",	4,	4,	65,	},
	{ "Demmin 0",				"DEMM",		4,	4,	66,	},
	{ "Altenkirchen 7",			"ALTK7",	4,	4,	99,	},
	{ "Saarbruecken 2 <Winterberg>",	"SBW",		4,	6,	1,	},
	{ "Welschbillig 3",			"WBIL3",	4,	6,	2,	},
	{ "Hallschlag 3",			"HASC3",	4,	6,	3,	},
	{ "Marpingen 1 (Tholey)",		"MAPI1",	4,	6,	4,	},
	{ "Konz 5",				"KONZ5",	4,	6,	5,	},
	{ "Simmern 3",				"SIMME3",	4,	6,	7,	},
	{ "Saarlouis 0",			"SLO0",		4,	6,	8,	},
	{ "Saarbruecken 5 (OPD)",		"SB5",		4,	6,	9,	},
	{ "Perl 1",				"PERL",		4,	6,	11,	},
	{ "Gemuenden 3",			"GMU3",		4,	6,	13,	},
	{ "Pirmasens 2",			"PIR2",		4,	6,	16,	},
	{ "Konken 3",				"KKN3",		4,	6,	17,	},
	{ "Glan-Muenchweiler 3 (KL2)",		"GMW4",		4,	6,	18,	},
	{ "Reichenbach-Steegen 6",		"RST6",		4,	6,	19,	},
	{ "Landstuhl 14",			"LST14",	4,	6,	20,	},
	{ "Weilerbach 4 (KL2)",			"WLB4",		4,	6,	21,	},
	{ "Trier 1",				"TR1",		4,	6,	22,	},
	{ "Kell 1",				"KLL1",		4,	6,	23,	},
	{ "Blieskastel 2",			"BLIES2",	4,	6,	24,	},
	{ "Bernkastel-Kues 1",			"BNK1",		4,	6,	25,	},
	{ "Pruem 2",				"PRM2",		4,	6,	26,	},
	{ "Idar-Oberstein 1",			"IDO1",		4,	6,	27,	},
	{ "Bruchmuehlbach 4",			"BMLB4",	4,	6,	28,	},
	{ "Dellfeld 1",				"DELL1",	4,	6,	30,	},
	{ "Homburg 0",				"HBG0",		4,	6,	31,	},
	{ "Kastellaun 3",			"KAST3",	4,	6,	32,	},
	{ "Schoeneberg - Kuebelberg 0",		"KUEB0",	4,	6,	33,	},
	{ "St. Wendel 4",			"STWL4",	4,	6,	34,	},
	{ "Heusweiler 2",			"HSW2",		4,	6,	35,	},
	{ "Saarbruecken 1 (Klzsbr)",		"SB1",		4,	6,	36,	},
	{ "Neumagen-Dhron 7",			"HETZ2",	4,	6,	37,	},
	{ "Bitburg 0",				"BTB0",		4,	6,	38,	},
	{ "Wolfstein Pfalz 1 (KL2)",		"WOS",		4,	6,	39,	},
	{ "Saarburg 4",				"SAA4",		4,	6,	40,	},
	{ "Gerolstein 1",			"GRST",		4,	6,	41,	},
	{ "Kirn 7",				"KIRN7",	4,	6,	44,	},
	{ "Merzig 3",				"MERZ3",	4,	6,	46,	},
	{ "Lebach 3",				"LEB3",		4,	6,	47,	},
	{ "Sulzbach Saar 10",			"SUL10",	4,	6,	48,	},
	{ "Voelklingen 1",			"VKL1",		4,	6,	49,	},
	{ "Zweibruecken 2",			"ZW",		4,	6,	50,	},
	{ "Buedlich 2",				"BUEDL2",	4,	6,	54,	},
	{ "Klein-Blittersdorf 4",		"BLIES",	4,	6,	56,	},
	{ "Meisenheim 7",			"MEIS7",	4,	6,	59,	},
	{ "Hinterweidenthal 1",			"HINT1",	4,	6,	60,	},
	{ "Dillingen Wasserturm",		"DILL",		4,	6,	61,	},
	{ "Thaleischweiler 1",			"THALE1",	4,	6,	62,	},
	{ "Trulben 2",				"TRUL2",	4,	6,	64,	},
	{ "Kirchberg 1",			"KIRB1",	4,	6,	78,	},
	{ "Neunkirchen Saar 1",			"NK",		4,	6,	79,	},
	{ "Mettlach-Orscholz 1",		"METTL1",	4,	6,	80,	},
	{ "Abtsgmuend 41",			"ABT41",	4,	7,	1,	},
	{ "Bopfingen 41",			"BOPF41",	4,	7,	2,	},
	{ "Weikersheim 41",			"WEIK41",	4,	7,	3,	},
	{ "Heidenheim 2",			"HDH2",		4,	7,	4,	},
	{ "Lauterstein 1",			"LAU1",		4,	7,	5,	},
	{ "Niederstetten 41",			"NDST41",	4,	7,	6,	},
	{ "Schwaebisch Hall 71",		"SHALL7",	4,	7,	7,	},
	{ "Gaildorf 42",			"GADF",		4,	7,	8,	},
	{ "Mainhardt 1",			"SKLZ01",	4,	7,	9,	},
	{ "Schoental 41 (Widdern)",		"SCHT41",	4,	7,	10,	},
	{ "Schwaebisch Hall 0",			"SHALL0",	4,	7,	11,	},
	{ "Bad Mergentheim 2",			"DZB2",		4,	7,	12,	},
	{ "Forchtenberg 1",			"HNKL20",	4,	7,	14,	},
	{ "Oehringen-Ohrnberg 41",		"HNKL02",	4,	7,	15,	},
	{ "Bad Mergentheim 41",			"MERG41",	4,	7,	16,	},
	{ "Creglingen 41",			"CREG41",	4,	7,	17,	},
	{ "Braunsbach 2",			"BBCH2",	4,	7,	18,	},
	{ "Schopfloch 0",			"SPFL0",	4,	7,	19,	},
	{ "Kuenzelsau 41",			"KSAU41",	4,	7,	20,	},
	{ "Lonsee 41",				"LONS41",	4,	7,	21,	},
	{ "Laichingen 75",			"LAI75",	4,	7,	22,	},
	{ "Fichtenau 1",			"FICH1",	4,	7,	24,	},
	{ "Crailsheim 2",			"KBG2",		4,	7,	25,	},
	{ "Untergroeningen 1",			"UGRN1",	4,	7,	26,	},
	{ "Wiesensteig/Nato 1",			"WIE1",		4,	7,	27,	},
	{ "Geislingen 0",			"GSLN41",	4,	7,	32,	},
	{ "Riedlingen 2",			"RIE2X",	4,	7,	33,	},
	{ "Aichstetten 3",			"AIST3",	4,	7,	37,	},
	{ "Aalen 41",				"AAL41",	4,	7,	38,	},
	{ "Ellwangen 1",			"ELLW",		4,	7,	40,	},
	{ "Gerstetten 71",			"GERS71",	4,	7,	41,	},
	{ "Heubach 1",				"HEU1",		4,	7,	45,	},
	{ "Lonsee 1 (Scharenstetten)",		"LONS1",	4,	7,	46,	},
	{ "Neresheim 1",			"NER1",		4,	7,	47,	},
	{ "Lauchheim 1",			"LCHM79",	4,	7,	48,	},
	{ "Nersingen(DASA) 0.47",		"NERS",		4,	7,	49,	},
	{ "Schnelldorf 1",			"SNDF1",	4,	7,	50,	},
	{ "Aalen-Ebnat 41",			"EBNT41",	4,	7,	51,	},
	{ "Ulm 51 (Jungingen)",			"ULKL27",	4,	7,	53,	},
	{ "Laichingen 41",			"ULKL03",	4,	7,	55,	},
	{ "Aalen 42",				"AAL42",	4,	7,	57,	},
	{ "Herbrechtingen 41",			"HERB41",	4,	7,	68,	},
	{ "Ulm 1",				"UL1",		4,	7,	70,	},
	{ "Schoental 43 (Oberkessach)",		"SCHT43",	4,	7,	71,	},
	{ "Schelklingen 1",			"ULKL06",	4,	7,	72,	},
	{ "Deggingen 71",			"ULKL07",	4,	7,	73,	},
	{ "Ochsenhausen 1",			"ULKL08",	4,	7,	74,	},
	{ "Giengen 42",				"GIEN42",	4,	7,	75,	},
	{ "Ulm 2 (Rasth. Seligw.)",		"ULKL09",	4,	7,	76,	},
	{ "Ulm 126",				"ULKL10",	4,	7,	77,	},
	{ "Langenau 1",				"ULKL01",	4,	7,	78,	},
	{ "Oehringen 3",			"HNKL06",	4,	7,	79,	},
	{ "Blaustein 41",			"ULKL12",	4,	7,	80,	},
	{ "Ulm 151",				"ULKL14",	4,	7,	82,	},
	{ "Blaubeuren 41",			"ULKL15",	4,	7,	83,	},
	{ "Ulm 172 (Neu-Ulm)",			"ULKL16",	4,	7,	84,	},
	{ "Ulm 141",				"ULKL17",	4,	7,	85,	},
	{ "Erbach 41",				"ULKL18",	4,	7,	86,	},
	{ "Senden 0",				"ULKL19",	4,	7,	87,	},
	{ "Weissenhorn 0",			"ULKL02",	4,	7,	88,	},
	{ "Laupheim 0",				"ULKL21",	4,	7,	90,	},
	{ "Illertissen 0",			"ULKL22",	4,	7,	91,	},
	{ "Biberach 6",				"ULKL23",	4,	7,	92,	},
	{ "Ehingen 0",				"EHI0",		4,	7,	93,	},
	{ "Langenburg 1",			"LGB1",		4,	7,	95,	},
	{ "Dortmund 3 (Bake)",			"DO3",		4,	2,	1,	},
	{ "Altenberge 0",			"ALTB0",	5,	2,	1,	},
	{ "Lennestadt 1",			"LENNE1",	5,	2,	2,	},
	{ "Attendorn 7",			"ATT7",		5,	2,	3,	},
	{ "Arnsberg-Neheim-Huesten 7",		"NHH7",		5,	2,	5,	},
	{ "Muenster 42 <geneigt>",		"MST42",	5,	2,	6,	},
	{ "Marsberg-Westheim 1",		"MARS1",	5,	2,	7,	},
	{ "Lippstadt 0",			"LIPP1",	5,	2,	8,	},
	{ "Schalksmuehle 10 (Roelvede)",	"HGND",		5,	2,	9,	},
	{ "Meschede-Freienohl 7",		"MEF",		5,	2,	10,	},
	{ "Hallenberg 7",			"HLBG7",	5,	2,	11,	},
	{ "Soest 10 <Pauli Kaserne>",		"SOEST",	5,	2,	12,	},
	{ "Schalksmuehle 7",			"SCHLK7",	5,	2,	13,	},
	{ "Olsberg 7",				"OLSB7",	5,	2,	14,	},
	{ "Ostbevern 10",			"OST",		5,	2,	15,	},
	{ "Arnsberg 0",				"ARNS0",	5,	2,	16,	},
	{ "Beckum 3",				"BECK3",	5,	2,	17,	},
	{ "Sendenhorst 2",			"SEN2",		5,	2,	18,	},
	{ "Altena 8 <Ers.f.ALTN1>",		"ALTN8",	5,	2,	19,	},
	{ "Ahlen 0",				"AHL0",		5,	2,	20,	},
	{ "Luedinghausen 2",			"LDH2",		5,	2,	21,	},
	{ "Meschede 1",				"ME1",		5,	2,	22,	},
	{ "Werl 0",				"WERL",		5,	2,	23,	},
	{ "Moehnesee 5 <5:5:1>",		"MOE5",		5,	2,	24,	},
	{ "Schmallenberg-Boedefeld 1",		"SBF1",		5,	2,	25,	},
	{ "Winterberg 8",			"HLB",		5,	2,	26,	},
	{ "Castrop-Rauxel 3",			"CRX3",		5,	2,	27,	},
	{ "Muenster-Nienberge 0",		"MSTN0",	5,	2,	28,	},
	{ "Vreden 0",				"VRDN0",	5,	2,	29,	},
	{ "Luedenscheid 2",			"LS2",		5,	2,	30,	},
	{ "Gronau 0",				"GRON0",	5,	2,	31,	},
	{ "Meinerzhagen 7",			"MZHG7",	5,	2,	32,	},
	{ "Luenen 0",				"LUEN0",	5,	2,	33,	},
	{ "Plettenberg 10",			"PLET10",	5,	2,	34,	},
	{ "Werdohl 7",				"WDHL7",	5,	2,	35,	},
	{ "Nottuln 2 <20 Grad geneigt>",	"NOTT2",	5,	2,	36,	},
	{ "Telgte 0",				"TELG0",	5,	2,	37,	},
	{ "Ruethen 0",				"RUET0",	5,	2,	38,	},
	{ "Emsdetten 0",			"EMS0",		5,	2,	39,	},
	{ "Oelde 2 (Stromberg)",		"OELST2",	5,	2,	40,	},
	{ "Muenster-Albachten 0",		"MST0",		5,	2,	41,	},
	{ "Greven 0",				"GRVN0",	5,	2,	43,	},
	{ "Brechten 80",			"BRE",		5,	2,	44,	},
	{ "Schmallenberg-Dorlar 1",		"DORL1",	5,	2,	45,	},
	{ "Halver 6 (Rothenbruch)",		"HALV",		5,	2,	46,	},
	{ "Herscheid 3 (Gasmert)",		"LSG",		5,	2,	47,	},
	{ "Dortmund 230",			"DO230",	5,	2,	49,	},
	{ "Ascheberg 2",			"ASCHB2",	5,	2,	50,	},
	{ "Warendorf 0",			"WAF0",		5,	2,	51,	},
	{ "Gevelsberg 7",			"GEV7",		5,	2,	52,	},
	{ "Duelmen 0",				"DUEL0",	5,	2,	54,	},
	{ "Sundern 1",				"SUND1",	5,	2,	55,	},
	{ "Bueren 1",				"BUER1",	5,	2,	56,	},
	{ "Brilon-Messinghausen 1",		"BRIM1",	5,	2,	57,	},
	{ "Dortmund 10",			"DO10",		5,	2,	58,	},
	{ "Witten 91 (Gedern)",			"WITTW",	5,	2,	59,	},
	{ "Unna 3",				"UN",		5,	2,	60,	},
	{ "Hagen-Dahl 9 (Priorei)",		"HGNDA9",	5,	2,	61,	},
	{ "Haltern 7",				"HAL7",		5,	2,	62,	},
	{ "Herdecke 7",				"HERD7",	5,	2,	63,	},
	{ "Boenen 0",				"BOE0",		5,	2,	64,	},
	{ "Holzwickede 1",			"HOLZW",	5,	2,	65,	},
	{ "Hamm 1",				"HAMM1",	5,	2,	66,	},
	{ "Menden 11 (Lahrberg)",		"MEN11",	5,	2,	67,	},
	{ "Kamen 0",				"KAM0",		5,	2,	68,	},
	{ "Werne 0",				"WERN0",	5,	2,	69,	},
	{ "Waltrop 1",				"WTRP",		5,	2,	70,	},
	{ "Hamm 10 (Uentrop)",			"HAMM",		5,	2,	71,	},
	{ "Hagen 2",				"HGN2",		5,	2,	72,	},
	{ "Schwerte 4",				"SWT4",		5,	2,	73,	},
	{ "Recklinghausen 1",			"RECK1",	5,	2,	74,	},
	{ "Breckerfeld 6",			"BRCK",		5,	2,	75,	},
	{ "Balve 7",				"BALV7",	5,	2,	76,	},
	{ "Gevelsberg 5 (Silschede)",		"GEVS",		5,	2,	77,	},
	{ "Dortmund 85 (Eving)",		"DO85",		5,	2,	78,	},
	{ "Iserlohn 13 (Seilerberg)",		"ISN13",	5,	2,	79,	},
	{ "Datteln 3",				"DAT3",		5,	2,	80,	},
	{ "Haltern 2",				"HAL2",		5,	2,	84,	},
	{ "Hagen 9 (TVU Wetter)",		"HGN9",		5,	2,	85,	},
	{ "Witten 12",				"WITT12",	5,	2,	87,	},
	{ "Herscheid 1",			"HED1",		5,	2,	94,	},
	{ "Marl 0",				"MARL0",	5,	2,	96,	},
	{ "Klettbach 1",			"HAYN",		5,	3,	1,	},
	{ "Grossfahner 1",			"BIEN",		5,	3,	2,	},
	{ "Zella-Mehlis 1",			"ZEME",		5,	3,	3,	},
	{ "Juechsen 1",				"WNBRN",	5,	3,	4,	},
	{ "Grossbreitenbach 7",			"GBB",		5,	3,	5,	},
	{ "Eisenberg 6 (Serba)",		"ESBG6",	5,	3,	6,	},
	{ "Schleusingen 4",			"SLSN",		5,	3,	7,	},
	{ "Eisenberg 4",			"ESBG",		5,	3,	8,	},
	{ "Gera 11 (Roschuetz)",		"GRO",		5,	3,	9,	},
	{ "Muenchenbernsdorf1(H.Reuth)",	"HRTH",		5,	3,	10,	},
	{ "Jena 5",				"LDGF",		5,	3,	11,	},
	{ "Neustadt 3 (Kleina)",		"KLA",		5,	3,	12,	},
	{ "Saalburg 2",				"KLM",		5,	3,	13,	},
	{ "Jena 6",				"OSSM",		5,	3,	14,	},
	{ "Ruhla 4",				"RUHL",		5,	3,	15,	},
	{ "Creuzburg 2 (Neuenhof)",		"NEUF",		5,	3,	16,	},
	{ "Nordhausen 1",			"NDHN",		5,	3,	17,	},
	{ "Camburg 2",				"CAB",		5,	3,	18,	},
	{ "Bad Frankenhausen 3",		"BFRH",		5,	3,	19,	},
	{ "Gera 13",				"GERA13",	5,	3,	20,	},
	{ "Sondershausen 5",			"SOND",		5,	3,	21,	},
	{ "Hermsdorf 1",			"HDF1",		5,	3,	22,	},
	{ "Weimar 14",				"WEIM",		5,	3,	23,	},
	{ "Erfurt 20(Schwerborner STR.)",	"EKLZ08",	5,	3,	24,	},
	{ "Arnsgereuth 1",			"ARRTH",	5,	3,	25,	},
	{ "Arnstadt 8",				"ARNA",		5,	3,	26,	},
	{ "Suhl 2",				"SUHL",		5,	3,	27,	},
	{ "Bad Koesen 1000",			"KOES",		5,	3,	29,	},
	{ "Hildburghausen 11",			"HILHSN",	5,	3,	30,	},
	{ "Ilmenau 4",				"ILME",		5,	3,	31,	},
	{ "Erfurt 13 (Flughafen alt)",		"EKLZ07",	5,	3,	32,	},
	{ "Erfurt 7 (Fuchsgrund)",		"EKLZ03",	5,	3,	33,	},
	{ "Erfurt 4 (Andreasstr.)",		"EKLZ02",	5,	3,	34,	},
	{ "Erfurt 3 (Chamissostr.)",		"EKLZ01",	5,	3,	35,	},
	{ "Neuhaus 0",				"NEURE",	5,	3,	36,	},
	{ "Meiningen 5",			"MEIN",		5,	3,	37,	},
	{ "Erfurt 17 (FZA)",			"EKLZ05",	5,	3,	38,	},
	{ "Erfurt 8 (EVST 4)",			"EKLZ04",	5,	3,	39,	},
	{ "Muehlhausen 7 (Eigenrieden)",	"EGRD",		5,	3,	40,	},
	{ "Blankenhain 1",			"BLHA1",	5,	3,	41,	},
	{ "Schmalkalden 6",			"SMAL",		5,	3,	42,	},
	{ "Heuthen 1 (Hockelrein)",		"HOCKE",	5,	3,	43,	},
	{ "Kaltennordheim 2",			"KLFE",		5,	3,	44,	},
	{ "Berga 1",				"BERG",		5,	3,	45,	},
	{ "Oberhof 2",				"OBHF",		5,	3,	46,	},
	{ "Poessneck 5",			"PSNK",		5,	3,	47,	},
	{ "Apolda 2",				"APOL",		5,	3,	48,	},
	{ "Bad Langensalza 4",			"BSALZ",	5,	3,	49,	},
	{ "Soemmerda 0",			"SOEM",		5,	3,	50,	},
	{ "Triebes 2",				"ZLRD",		5,	3,	51,	},
	{ "Lobenstein 4",			"LOBS",		5,	3,	52,	},
	{ "Rudolstadt 4",			"RDST",		5,	3,	53,	},
	{ "Schleiz 2",				"SLZ",		5,	3,	54,	},
	{ "Stadtroda 1",			"STRDA1",	5,	3,	55,	},
	{ "Wernshausen 3 (Pless)",		"PLS",		5,	3,	56,	},
	{ "Steinbach-Hallenberg 2",		"STBH",		5,	3,	58,	},
	{ "Geisa 4",				"GEISA",	5,	3,	59,	},
	{ "Bleicherode7 (Gebraer Kopf)",	"SOLL",		5,	3,	60,	},
	{ "Inselsberg",				"INSEL",	5,	3,	61,	},
	{ "Steinach 3 (Fellberg)",		"FELL",		5,	3,	62,	},
	{ "Stadtilm 4",				"STADTI",	5,	3,	63,	},
	{ "Waltershausen 4",			"WALT4",	5,	3,	65,	},
	{ "Gotha 6",				"GTHA6",	5,	3,	66,	},
	{ "Eisenach 11",			"ESNA11",	5,	3,	67,	},
	{ "Kahla 1",				"KAHLA2",	5,	3,	68,	},
	{ "Heiligenstadt 4",			"HLGS4",	5,	3,	69,	},
	{ "Thimmendorf 1",			"THIM1",	5,	3,	70,	},
	{ "Buttelstedt 3",			"BUTT3",	5,	3,	71,	},
	{ "Koenigsee 2",			"KNGS2",	5,	3,	72,	},
	{ "Erfurt 30",				"EKLZ30",	5,	3,	73,	},
	{ "Schoenbrunn 7",			"SHBN7",	5,	3,	74,	},
	{ "Kindelbrueck (TVU)",			"KIND",		5,	3,	75,	},
	{ "Schlotheim 3",			"SCHLT",	5,	3,	79,	},
	{ "Bischofsheim 2",			"BIH2",		5,	3,	91,	},
	{ "Ludwigsstadt 1",			"LUDW1",	5,	3,	92,	},
	{ "Ostheim 1",				"UNSL1",	5,	3,	93,	},
	{ "Frechen 0",				"FCHN0",	6,	2,	1,	},
	{ "Koeln 35 (Messe)",			"K35",		6,	2,	2,	},
	{ "Bergisch Gladbach 4",		"BGLB99",	6,	2,	3,	},
	{ "Niederkassel 0",			"NKS0",		6,	2,	4,	},
	{ "Koeln 0",				"K0",		6,	2,	5,	},
	{ "Koeln 8 <Bake>",			"K8",		6,	2,	6,	},
	{ "Bonn 460",				"BN460",	6,	2,	7,	},
	{ "Koeln 27",				"K27",		6,	2,	8,	},
	{ "Bornheim-Merten 1",			"MTN1",		6,	2,	9,	},
	{ "Frechen 8 <4.3 W ERP>",		"FCHN3",	6,	2,	10,	},
	{ "Kerpen-Horrem 2",			"KERP51",	6,	2,	11,	},
	{ "Erftstadt 50",			"ERF50",	6,	2,	12,	},
	{ "Koeln 34",				"K34",		6,	2,	13,	},
	{ "Pulheim 0",				"PLH0",		6,	2,	14,	},
	{ "Koeln-Porz 50",			"PRZ50",	6,	2,	15,	},
	{ "Bergheim 2",				"BGH2",		6,	2,	16,	},
	{ "Koeln 860",				"HMR",		6,	2,	17,	},
	{ "Koenigswinter-Oberpleis 1",		"KWT1",		6,	2,	18,	},
	{ "Siegburg 70",			"TROI70",	6,	2,	19,	},
	{ "Bergisch Gladbach 2",		"BGLB2",	6,	2,	21,	},
	{ "Koeln 170",				"K17",		6,	2,	22,	},
	{ "Koeln 25",				"K25",		6,	2,	23,	},
	{ "Koeln 370",				"K37",		6,	2,	24,	},
	{ "Koeln 430",				"K43",		6,	2,	25,	},
	{ "Koeln 760",				"K76",		6,	2,	26,	},
	{ "Koeln 640",				"K640",		6,	2,	27,	},
	{ "Koeln 28",				"K850",		6,	2,	28,	},
	{ "Bruehl 99",				"BRHL99",	6,	2,	29,	},
	{ "Kerpen 3",				"VILLE",	6,	2,	30,	},
	{ "Koeln 350.8001",			"K350",		6,	2,	31,	},
	{ "Bonn 0",				"BN0",		6,	2,	33,	},
	{ "Bonn 320",				"BN320",	6,	2,	34,	},
	{ "Bonn 620",				"BN620",	6,	2,	35,	},
	{ "Bonn 670",				"BN670",	6,	2,	36,	},
	{ "Siegburg 41",			"SIGB41",	6,	2,	37,	},
	{ "Siegburg 20",			"SIGB20",	6,	2,	38,	},
	{ "Lohmar 2",				"LOH99",	6,	2,	39,	},
	{ "Siegburg 0",				"SIGB0",	6,	2,	40,	},
	{ "Lohmar 1 <Mischbake>",		"LOH1",		6,	2,	41,	},
	{ "Bonn 13 (BMPT)",			"BN13",		6,	2,	42,	},
	{ "Dueren 30",				"DUER30",	6,	2,	43,	},
	{ "Heimbach 2",				"HEIM2",	6,	2,	44,	},
	{ "Huertgenwald 4 <Mischbake>",		"HGW4",		6,	2,	45,	},
	{ "Kerpen-Buir 1",			"BUIR",		6,	2,	46,	},
	{ "Monschau 1",				"MONS1",	6,	2,	47,	},
	{ "Hennef 1",				"HNNF1",	6,	2,	48,	},
	{ "Nideggen 4",				"NGG4",		6,	2,	49,	},
	{ "Zuelpich 1",				"ZUEL",		6,	2,	50,	},
	{ "Rheinbach 2",			"RHBH",		6,	2,	51,	},
	{ "Euskirchen 4",			"EUSK4",	6,	2,	52,	},
	{ "Weilerswist 0",			"WLW0",		6,	2,	53,	},
	{ "Bad Muenstereifel 2",		"BMST",		6,	2,	54,	},
	{ "Mechernich 4",			"MECH2",	6,	2,	55,	},
	{ "Schleiden 1",			"SLDN1",	6,	2,	56,	},
	{ "Koenigswinter-Oberpleis 0",		"KWT",		6,	2,	57,	},
	{ "Noervenich 1",			"NOER",		6,	2,	58,	},
	{ "Dormagen 7.80B1",			"DOR7",		6,	2,	60,	},
	{ "Simmerath 3",			"SIMM3",	6,	2,	61,	},
	{ "Nettersheim 4",			"NETSH4",	6,	2,	62,	},
	{ "Schleiden-Gemuend 3",		"RURB",		6,	2,	63,	},
	{ "Wermelskirchen 0",			"WEKI0",	6,	2,	64,	},
	{ "Burscheid 3",			"BUR3",		6,	2,	65,	},
	{ "Wesseling 0",			"WESS0",	6,	2,	66,	},
	{ "Huerth 0",				"HRT0",		6,	2,	67,	},
	{ "Roesrath 2",				"RRT",		6,	2,	68,	},
	{ "Burscheid 10",			"BUR10",	6,	2,	69,	},
	{ "Koeln 23",				"K23",		6,	2,	70,	},
	{ "Leverkusen-Opladen 1",		"LEVOP1",	6,	2,	71,	},
	{ "Bonn 2",				"BN2",		6,	2,	72,	},
	{ "Rommerskirchen 0",			"ROMM0",	6,	2,	73,	},
	{ "Bonn 630",				"BN630",	6,	2,	76,	},
	{ "Bensberg 60",			"BNBG60",	6,	2,	78,	},
	{ "Leverkusen 0",			"LEV0",		6,	2,	91,	},
	{ "Magdeburg 25 (Sudenburg)",		"MDB25",	6,	3,	1,	},
	{ "Magdeburg 22 (Cracau)",		"MDB22",	6,	3,	2,	},
	{ "Magdeburg 24 (Neust. See)",		"MDB24",	6,	3,	3,	},
	{ "Biederitz 1",			"BIED1",	6,	3,	4,	},
	{ "Magdeburg 7 (Olvenstaedt)",		"MDB7",		6,	3,	5,	},
	{ "Magdeburg 23 (Buckau)",		"MDB23",	6,	3,	6,	},
	{ "Moeser 1",				"MOESE1",	6,	3,	7,	},
	{ "Magdeburg 1",			"MDB0",		6,	3,	8,	},
	{ "Magdeburg 10 (Schoenebeck)",		"TRANS6",	6,	3,	9,	},
	{ "Leitzkau 1",				"LEIT1",	6,	3,	10,	},
	{ "Stendal 2",				"STD2",		6,	3,	11,	},
	{ "Haldensleben 4 (end)",		"HLDL",		6,	3,	12,	},
	{ "Oschersleben 0",			"OSCH0",	6,	3,	13,	},
	{ "Wernigerode 0",			"WIGR0",	6,	3,	14,	},
	{ "Halberstadt 2",			"HBST",		6,	3,	15,	},
	{ "Erxleben ueb. Hldln. 1",		"ERX1",		6,	3,	16,	},
	{ "Altengrabow 1",			"ALGR1",	6,	3,	17,	},
	{ "Genthin 0",				"GENT0",	6,	3,	18,	},
	{ "Burg 0",				"BURG0",	6,	3,	19,	},
	{ "Lindau-Anhalt 1",			"DEE",		6,	3,	20,	},
	{ "Kamern 2",				"KAME",		6,	3,	21,	},
	{ "Niederndodeleben 1",			"TRANS1",	6,	3,	22,	},
	{ "Egeln 0",				"EGELN0",	6,	3,	23,	},
	{ "Burg 5",				"TRANS2",	6,	3,	24,	},
	{ "Fleetmark 1",			"LUEG",		6,	3,	25,	},
	{ "Dolle 1",				"DLL",		6,	3,	26,	},
	{ "Osterburg 3",			"OTBG3",	6,	3,	27,	},
	{ "Frose 3 (Hoym)",			"HOYM",		6,	3,	28,	},
	{ "Harzgerode 0",			"HGR",		6,	3,	29,	},
	{ "Koennern 3",				"KOENE3",	6,	3,	30,	},
	{ "Elbingerode 0.97B1",			"ELBRD",	6,	3,	31,	},
	{ "Wanzleben 2",			"WANZ2",	6,	3,	32,	},
	{ "Morsleben",				"MORS",		6,	3,	33,	},
	{ "Tangermuende 0.97B1",		"JERI0",	6,	3,	34,	},
	{ "Bernburg 7",				"BBG",		6,	3,	35,	},
	{ "Salzwedel 8",			"SALZ8",	6,	3,	36,	},
	{ "Zerbst 4",				"ZERBST",	6,	3,	39,	},
	{ "Aschersleben 5 End",			"ASCHS0",	6,	3,	48,	},
	{ "Tangerhuette 0",			"TANGER",	6,	3,	49,	},
	{ "Kloetze",				"KLOETZ",	6,	3,	52,	},
	{ "Mieste 0",				"MIEST0",	6,	3,	55,	},
	{ "Thale",				"THAL",		6,	3,	88,	},
	{ "Seehausen 0",			"SEE0",		6,	3,	93,	},
	{ "Blankenburg 0",			"BLABG",	6,	3,	95,	},
	{ "Gardelegen 0",			"GDLG",		6,	3,	96,	},
	{ "Gernrode 3 (end)",			"GERN1",	6,	3,	97,	},
	{ "Hasselfelde 0",			"HASS",		6,	3,	98,	},
	{ "Overath 5",				"OVRT5",	7,	2,	1,	},
	{ "Dierdorf 10",			"DIER2",	7,	2,	2,	},
	{ "Daun 4",				"DAU4",		7,	2,	4,	},
	{ "Much 1",				"MUCH",		7,	2,	6,	},
	{ "Saffig 10",				"SAFF10",	7,	2,	7,	},
	{ "Gummersbach 40",			"GU40",		7,	2,	8,	},
	{ "Asbach 10 <f. HNNF6>",		"ASB10",	7,	2,	9,	},
	{ "Eitorf 2",				"EIT2",		7,	2,	10,	},
	{ "Windhagen 10",			"WINH10",	7,	2,	11,	},
	{ "Bad Honnef 80",			"BHF80",	7,	2,	12,	},
	{ "Nuembrecht 10",			"NUEM10",	7,	2,	13,	},
	{ "Koblenz 10 <Mischbake>",		"KO10",		7,	2,	14,	},
	{ "Hoehr-Grenzhausen 1 <Misch>",	"HGH1",		7,	2,	15,	},
	{ "Montabaur 3",			"MT3",		7,	2,	16,	},
	{ "Weibern 2 <Mischbake>",		"WBN2",		7,	2,	18,	},
	{ "Bad Marienberg 1 <Mischba.>",	"BMA1",		7,	2,	19,	},
	{ "Bad Bertrich 1",			"BER1",		7,	2,	20,	},
	{ "Blankenheim-Ahr 5",			"BHM5",		7,	2,	21,	},
	{ "Wissen 2",				"WISS2",	7,	2,	22,	},
	{ "Betzdorf 4",				"BZD4",		7,	2,	23,	},
	{ "Wenden 186",				"WEDN89",	7,	2,	26,	},
	{ "Puderbach 3",			"PUDB3",	7,	2,	28,	},
	{ "Kuerten-Duerscheid 3",		"KUERT3",	7,	2,	30,	},
	{ "Bad Honnef 0",			"BHF1",		7,	2,	31,	},
	{ "Wipperfuerth 2",			"WIPP2",	7,	2,	33,	},
	{ "Kuerten 1",				"KUERT1",	7,	2,	34,	},
	{ "Gummersbach 0",			"GU0",		7,	2,	35,	},
	{ "Windeck 2",				"WIND1",	7,	2,	37,	},
	{ "Bad Neuenahr-Ahrweiler 4",		"BNA4",		7,	2,	38,	},
	{ "Linz 4 <Mischbake>",			"LNZ",		7,	2,	39,	},
	{ "Kreuztal 1 <Mischbake>",		"KRZT1",	7,	2,	41,	},
	{ "Bad Berleburg 1",			"BBERL1",	7,	2,	43,	},
	{ "Bad Laasphe 7",			"LPHE7",	7,	2,	44,	},
	{ "Netphen 7",				"NETP7",	7,	2,	45,	},
	{ "Olpe 0",				"OE0",		7,	2,	47,	},
	{ "Drolshagen-Bleche 1",		"SCHK",		7,	2,	48,	},
	{ "Hilchenbach 1",			"LUZL",		7,	2,	49,	},
	{ "Freudenberg 7",			"FDB7",		7,	2,	50,	},
	{ "Burbach 3",				"BURB",		7,	2,	51,	},
	{ "Waldbreitbach 2",			"WBB2",		7,	2,	52,	},
	{ "Ellenz-Poltersdorf 2",		"ELLZ2",	7,	2,	53,	},
	{ "Insul 2",				"INSU2",	7,	2,	54,	},
	{ "Linz 2",				"LNZ2",		7,	2,	55,	},
	{ "Wildbergerhuette 1",			"SKHL",		7,	2,	56,	},
	{ "Kelberg 3 (Hochkelberg)",		"HKBG",		7,	2,	57,	},
	{ "Kesseling 1",			"KESS1",	7,	2,	58,	},
	{ "Reichshof-Eckenhagen 3",		"WEHN",		7,	2,	59,	},
	{ "Rengsdorf 4",			"WILR",		7,	2,	60,	},
	{ "Mendig 3",				"MEND",		7,	2,	61,	},
	{ "Cochem 1",				"COC1",		7,	2,	62,	},
	{ "Mayen 3",				"MAY3",		7,	2,	63,	},
	{ "Neuwied 2",				"NEUW0",	7,	2,	64,	},
	{ "Hachenburg 2",			"HACH2",	7,	2,	65,	},
	{ "Westerburg 1",			"WESB1",	7,	2,	66,	},
	{ "Asbach 5",				"ASB5",		7,	2,	67,	},
	{ "Loef 1",				"LOEF1",	7,	2,	68,	},
	{ "Engelskirchen 6",			"ENGK6",	7,	2,	69,	},
	{ "Altenkirchen 0",			"ATK0",		7,	2,	70,	},
	{ "Siegen 15",				"SG99",		7,	2,	71,	},
	{ "Neunkirchen-Seelscheid 1",		"NNK1",		7,	2,	73,	},
	{ "Ochtendung 2",			"OCHT99",	7,	2,	74,	},
	{ "Bad Ems 1",				"BEMS1",	7,	2,	79,	},
	{ "Marienheide 1",			"MARI1",	7,	2,	80,	},
	{ "Gummersbach 16 <Mischbake>",		"GU16",		7,	2,	82,	},
	{ "Flammersfeld 2",			"FLF2",		7,	2,	83,	},
	{ "Waldbroel 1",			"WDBR1",	7,	2,	84,	},
	{ "Bendorf 1",				"BEN1",		7,	2,	85,	},
	{ "Engelskirchen 3",			"ENGK",		7,	2,	86,	},
	{ "Selters 2",				"SELT2",	7,	2,	87,	},
	{ "Adenau 7 (Nuerburgring)",		"ADN7",		7,	2,	88,	},
	{ "Kaisersesch 2",			"KESCH2",	7,	2,	89,	},
	{ "Nassau 1",				"NAS1",		7,	2,	90,	},
	{ "Bad Marienberg 2",			"BMA2",		7,	2,	91,	},
	{ "Antweiler 1",			"ANT1",		7,	2,	92,	},
	{ "Ruppichteroth 3",			"BKRT",		7,	2,	93,	},
	{ "Lindlar 1",				"LINL",		7,	2,	95,	},
	{ "Siegen 1 <Mischbake>",		"SG1",		7,	2,	96,	},
	{ "Gummersbach 13 <Mischbake>",		"GU13",		7,	2,	97,	},
	{ "Rheinbrohl 0",			"RHBL0",	7,	2,	99,	},
	{ "Baerenstein 1",			"BAER2",	7,	3,	1,	},
	{ "Auerbach 4 (Schnarrtanne)",		"SNTN",		7,	3,	2,	},
	{ "Bad Elster 1 (Reuth)",		"REUTH",	7,	3,	3,	},
	{ "Marienberg 0",			"MBG",		7,	3,	4,	},
	{ "Chemnitz 11 (Totenstein)",		"TOT",		7,	3,	5,	},
	{ "Reichenbach 3",			"KUH",		7,	3,	6,	},
	{ "Bergen 1 (Werda)",			"WDA",		7,	3,	7,	},
	{ "Rochlitz 5",				"ROCH",		7,	3,	8,	},
	{ "Chemnitz 12 (Reichenhain)",		"REIHN",	7,	3,	9,	},
	{ "Frankenberg 4",			"FRKN",		7,	3,	10,	},
	{ "Ebersbrunn 1",			"ZWW",		7,	3,	11,	},
	{ "Schwarzenberg 7",			"BNBC",		7,	3,	12,	},
	{ "Freiberg 2",				"FBG",		7,	3,	13,	},
	{ "Frauenstein 3",			"FRAU",		7,	3,	14,	},
	{ "Glauchau 2",				"GLAU",		7,	3,	15,	},
	{ "Plauen 10",				"KEMM",		7,	3,	16,	},
	{ "Werdau 4 (Niederalbertsd.)",		"NDAD",		7,	3,	17,	},
	{ "Mittweida 1",			"MITT1",	7,	3,	18,	},
	{ "Zschopau 4 (Hohndorf)",		"HDRF",		7,	3,	19,	},
	{ "Chemnitz 32 (BKH-Bettenh.)",		"CZ01",		7,	3,	20,	},
	{ "Chemnitz 29 (Heckert)",		"CZ02",		7,	3,	21,	},
	{ "Chemnitz 17 (Landratsamt)",		"CZ08",		7,	3,	22,	},
	{ "Nossen 5",				"NOSS5",	7,	3,	23,	},
	{ "Chemnitz 22 (Leukersdorf)",		"CZ05",		7,	3,	24,	},
	{ "Chemnitz 33 (Numerik)",		"CZ06",		7,	3,	25,	},
	{ "Hainichen 1 (end)",			"HAIN1",	7,	3,	26,	},
	{ "Zwoenitz 4",				"ZWO3",		7,	3,	27,	},
	{ "Zwickau 1",				"ZWWI",		7,	3,	28,	},
	{ "Chemnitz 28 (Funkfeuer)",		"CZ09",		7,	3,	29,	},
	{ "Floeha 4 (TVU Steinberg)",		"STEIN",	7,	3,	30,	},
	{ "Crimmitzschau 2",			"CRIMMI",	7,	3,	31,	},
	{ "Eibenstock 4",			"EIBEN",	7,	3,	32,	},
	{ "Chemnitz 1010 (Autobahnamt)",	"CZ10",		7,	3,	33,	},
	{ "Olbernhau 3",			"LUGA",		7,	3,	35,	},
	{ "Hartenstein 1000",			"HART1",	7,	3,	36,	},
	{ "Greitz 2",				"GRZ2",		7,	3,	37,	},
	{ "Penig 2",				"PEN2",		7,	3,	38,	},
	{ "Thalheim",				"THALH",	7,	3,	39,	},
	{ "FTZ Example",			"FTZ",		1,	1,	38,	}, /* use in FTZ standard as example */
	{ "",					"",		0,	0,	0,	},
};

void init_station(void)
{
}

void station_list(void)
{
	int i;
	char name[33];

	printf("List of all base stations:\n\n");
	printf("Kurz    Name	                        Nat     FuVst   Rest\n");
	printf("------------------------------------------------------------\n");
	for (i = 0; cnetz_stations[i].long_name[0]; i++) {
		memset(name, ' ', sizeof(name));
		memcpy(name, cnetz_stations[i].name, strlen(cnetz_stations[i].name));
		name[8] = '\0';
		printf("%s", name);
		memset(name, ' ', sizeof(name));
		memcpy(name, cnetz_stations[i].long_name, strlen(cnetz_stations[i].long_name));
		name[sizeof(name) - 1] = '\0';
		printf("%s%d\t%d\t%d\n", name, cnetz_stations[i].nat, cnetz_stations[i].fuvst, cnetz_stations[i].rest);
	}
}

const char *get_station_name(uint8_t nat, uint8_t fuvst, uint8_t rest, const char **long_name)
{

	int i;

	for (i = 0; cnetz_stations[i].long_name[0]; i++) {
		if (cnetz_stations[i].nat == nat
		 && cnetz_stations[i].fuvst == fuvst
		 && cnetz_stations[i].rest == rest) {
			if (long_name)
				*long_name = cnetz_stations[i].long_name;
			return cnetz_stations[i].name;
		}
	}
	if (long_name)
		*long_name = "unknown";
	return *long_name;
}

const char *get_station_id(const char *name, uint8_t *nat, uint8_t *fuvst, uint8_t *rest)
{
	int i, found = -1;

	for (i = 0; cnetz_stations[i].name[0]; i++) {
		/* check for given prefix */
		if (!strncasecmp(cnetz_stations[i].name, name, strlen(name))
		 || !strncasecmp(cnetz_stations[i].long_name, name, strlen(name)) ) {
			/* found twice */
			if (found >= 0)
				return "Given station name is ambiguous, use more letters! Use '-S fuz-name=list' to get a list of all stations.";
			/* found the first time */
			found = i;
			/* check for exact match, so we are done */
			if (strlen(cnetz_stations[i].name) == strlen(name))
				break;
		}
	}
	/* mo match */
	if (found < 0)
		return "Given station name not found! Use '-S fuz-name=list' to get a list of all stations.\n";

	/* here we go */
	*nat = cnetz_stations[found].nat;
	*fuvst = cnetz_stations[found].fuvst;
	*rest = cnetz_stations[found].rest;
	return NULL;
}

