/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the DoEmailLookupResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DoEmailLookupResponse{}

// DoEmailLookupResponse struct for DoEmailLookupResponse
type DoEmailLookupResponse struct {
	// The email address passed to the call.
	Address string `json:"address"`
	// The email is `valid` or `invalid`.
	Status string `json:"status"`
	// The delivery status of the email address is`deliverable`, `undeliverable`. or `unknown`.
	Deliverability string `json:"deliverability"`
	// The reason why the checked email is invalid/undeliverable.
	Reason NullableString `json:"reason"`
	// The risk score of the email is`high`, `medium`, `low` or `null`.
	Risk string `json:"risk"`
	// The email address type (domain) is `free` or `corporate`.
	AddressType string `json:"addressType"`
	// This is `true` if the domain is in the list of disposable email addresses; otherwise, it returns as `false`.
	IsDisposableAddress bool `json:"isDisposableAddress"`
	// Null if nothing is suggested; however, if there is a potential typo in the email address, the closest suggestion is provided.
	Suggestion NullableString `json:"suggestion"`
	// Checks the mailbox part of the email to see whether it matches a specific role type (‘admin’, ‘sales’, ‘webmaster’).
	EmailRole NullableString `json:"emailRole"`
	// The local part of the email address.
	LocalPart string `json:"localPart"`
	// The domain part of the email address.
	DomainPart string `json:"domainPart"`
	// Email exchange server domain name (MX record value).
	Exchange NullableString `json:"exchange"`
	// MX record preference.
	Preference NullableInt32 `json:"preference"`
	// `true` if the email address exists in the Textmagic whitelist. 
	IsInWhiteList bool `json:"isInWhiteList"`
	// `true` if the email address exists in the Textmagic blacklist. 
	IsInBlackList bool `json:"isInBlackList"`
	// `true` if the email address domain has an MX record. 
	HasMx bool `json:"hasMx"`
	// `true` if the email address domain has an A record (IPv4). 
	HasAa bool `json:"hasAa"`
	// `true` if the email address domain has an AAAA record (IPv6). 
	HasAaaa bool `json:"hasAaaa"`
}

type _DoEmailLookupResponse DoEmailLookupResponse

// NewDoEmailLookupResponse instantiates a new DoEmailLookupResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDoEmailLookupResponse(address string, status string, deliverability string, reason NullableString, risk string, addressType string, isDisposableAddress bool, suggestion NullableString, emailRole NullableString, localPart string, domainPart string, exchange NullableString, preference NullableInt32, isInWhiteList bool, isInBlackList bool, hasMx bool, hasAa bool, hasAaaa bool) *DoEmailLookupResponse {
	this := DoEmailLookupResponse{}
	this.Address = address
	this.Status = status
	this.Deliverability = deliverability
	this.Reason = reason
	this.Risk = risk
	this.AddressType = addressType
	this.IsDisposableAddress = isDisposableAddress
	this.Suggestion = suggestion
	this.EmailRole = emailRole
	this.LocalPart = localPart
	this.DomainPart = domainPart
	this.Exchange = exchange
	this.Preference = preference
	this.IsInWhiteList = isInWhiteList
	this.IsInBlackList = isInBlackList
	this.HasMx = hasMx
	this.HasAa = hasAa
	this.HasAaaa = hasAaaa
	return &this
}

// NewDoEmailLookupResponseWithDefaults instantiates a new DoEmailLookupResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDoEmailLookupResponseWithDefaults() *DoEmailLookupResponse {
	this := DoEmailLookupResponse{}
	return &this
}

// GetAddress returns the Address field value
func (o *DoEmailLookupResponse) GetAddress() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Address
}

// GetAddressOk returns a tuple with the Address field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetAddressOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Address, true
}

// SetAddress sets field value
func (o *DoEmailLookupResponse) SetAddress(v string) {
	o.Address = v
}

// GetStatus returns the Status field value
func (o *DoEmailLookupResponse) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *DoEmailLookupResponse) SetStatus(v string) {
	o.Status = v
}

// GetDeliverability returns the Deliverability field value
func (o *DoEmailLookupResponse) GetDeliverability() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Deliverability
}

// GetDeliverabilityOk returns a tuple with the Deliverability field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetDeliverabilityOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Deliverability, true
}

// SetDeliverability sets field value
func (o *DoEmailLookupResponse) SetDeliverability(v string) {
	o.Deliverability = v
}

// GetReason returns the Reason field value
// If the value is explicit nil, the zero value for string will be returned
func (o *DoEmailLookupResponse) GetReason() string {
	if o == nil || o.Reason.Get() == nil {
		var ret string
		return ret
	}

	return *o.Reason.Get()
}

// GetReasonOk returns a tuple with the Reason field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DoEmailLookupResponse) GetReasonOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Reason.Get(), o.Reason.IsSet()
}

// SetReason sets field value
func (o *DoEmailLookupResponse) SetReason(v string) {
	o.Reason.Set(&v)
}

// GetRisk returns the Risk field value
func (o *DoEmailLookupResponse) GetRisk() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Risk
}

// GetRiskOk returns a tuple with the Risk field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetRiskOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Risk, true
}

// SetRisk sets field value
func (o *DoEmailLookupResponse) SetRisk(v string) {
	o.Risk = v
}

// GetAddressType returns the AddressType field value
func (o *DoEmailLookupResponse) GetAddressType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.AddressType
}

// GetAddressTypeOk returns a tuple with the AddressType field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetAddressTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.AddressType, true
}

// SetAddressType sets field value
func (o *DoEmailLookupResponse) SetAddressType(v string) {
	o.AddressType = v
}

// GetIsDisposableAddress returns the IsDisposableAddress field value
func (o *DoEmailLookupResponse) GetIsDisposableAddress() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsDisposableAddress
}

// GetIsDisposableAddressOk returns a tuple with the IsDisposableAddress field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetIsDisposableAddressOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsDisposableAddress, true
}

// SetIsDisposableAddress sets field value
func (o *DoEmailLookupResponse) SetIsDisposableAddress(v bool) {
	o.IsDisposableAddress = v
}

// GetSuggestion returns the Suggestion field value
// If the value is explicit nil, the zero value for string will be returned
func (o *DoEmailLookupResponse) GetSuggestion() string {
	if o == nil || o.Suggestion.Get() == nil {
		var ret string
		return ret
	}

	return *o.Suggestion.Get()
}

// GetSuggestionOk returns a tuple with the Suggestion field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DoEmailLookupResponse) GetSuggestionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Suggestion.Get(), o.Suggestion.IsSet()
}

// SetSuggestion sets field value
func (o *DoEmailLookupResponse) SetSuggestion(v string) {
	o.Suggestion.Set(&v)
}

// GetEmailRole returns the EmailRole field value
// If the value is explicit nil, the zero value for string will be returned
func (o *DoEmailLookupResponse) GetEmailRole() string {
	if o == nil || o.EmailRole.Get() == nil {
		var ret string
		return ret
	}

	return *o.EmailRole.Get()
}

// GetEmailRoleOk returns a tuple with the EmailRole field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DoEmailLookupResponse) GetEmailRoleOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.EmailRole.Get(), o.EmailRole.IsSet()
}

// SetEmailRole sets field value
func (o *DoEmailLookupResponse) SetEmailRole(v string) {
	o.EmailRole.Set(&v)
}

// GetLocalPart returns the LocalPart field value
func (o *DoEmailLookupResponse) GetLocalPart() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LocalPart
}

// GetLocalPartOk returns a tuple with the LocalPart field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetLocalPartOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LocalPart, true
}

// SetLocalPart sets field value
func (o *DoEmailLookupResponse) SetLocalPart(v string) {
	o.LocalPart = v
}

// GetDomainPart returns the DomainPart field value
func (o *DoEmailLookupResponse) GetDomainPart() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.DomainPart
}

// GetDomainPartOk returns a tuple with the DomainPart field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetDomainPartOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.DomainPart, true
}

// SetDomainPart sets field value
func (o *DoEmailLookupResponse) SetDomainPart(v string) {
	o.DomainPart = v
}

// GetExchange returns the Exchange field value
// If the value is explicit nil, the zero value for string will be returned
func (o *DoEmailLookupResponse) GetExchange() string {
	if o == nil || o.Exchange.Get() == nil {
		var ret string
		return ret
	}

	return *o.Exchange.Get()
}

// GetExchangeOk returns a tuple with the Exchange field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DoEmailLookupResponse) GetExchangeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Exchange.Get(), o.Exchange.IsSet()
}

// SetExchange sets field value
func (o *DoEmailLookupResponse) SetExchange(v string) {
	o.Exchange.Set(&v)
}

// GetPreference returns the Preference field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *DoEmailLookupResponse) GetPreference() int32 {
	if o == nil || o.Preference.Get() == nil {
		var ret int32
		return ret
	}

	return *o.Preference.Get()
}

// GetPreferenceOk returns a tuple with the Preference field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DoEmailLookupResponse) GetPreferenceOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Preference.Get(), o.Preference.IsSet()
}

// SetPreference sets field value
func (o *DoEmailLookupResponse) SetPreference(v int32) {
	o.Preference.Set(&v)
}

// GetIsInWhiteList returns the IsInWhiteList field value
func (o *DoEmailLookupResponse) GetIsInWhiteList() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsInWhiteList
}

// GetIsInWhiteListOk returns a tuple with the IsInWhiteList field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetIsInWhiteListOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsInWhiteList, true
}

// SetIsInWhiteList sets field value
func (o *DoEmailLookupResponse) SetIsInWhiteList(v bool) {
	o.IsInWhiteList = v
}

// GetIsInBlackList returns the IsInBlackList field value
func (o *DoEmailLookupResponse) GetIsInBlackList() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.IsInBlackList
}

// GetIsInBlackListOk returns a tuple with the IsInBlackList field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetIsInBlackListOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.IsInBlackList, true
}

// SetIsInBlackList sets field value
func (o *DoEmailLookupResponse) SetIsInBlackList(v bool) {
	o.IsInBlackList = v
}

// GetHasMx returns the HasMx field value
func (o *DoEmailLookupResponse) GetHasMx() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.HasMx
}

// GetHasMxOk returns a tuple with the HasMx field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetHasMxOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.HasMx, true
}

// SetHasMx sets field value
func (o *DoEmailLookupResponse) SetHasMx(v bool) {
	o.HasMx = v
}

// GetHasAa returns the HasAa field value
func (o *DoEmailLookupResponse) GetHasAa() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.HasAa
}

// GetHasAaOk returns a tuple with the HasAa field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetHasAaOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.HasAa, true
}

// SetHasAa sets field value
func (o *DoEmailLookupResponse) SetHasAa(v bool) {
	o.HasAa = v
}

// GetHasAaaa returns the HasAaaa field value
func (o *DoEmailLookupResponse) GetHasAaaa() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.HasAaaa
}

// GetHasAaaaOk returns a tuple with the HasAaaa field value
// and a boolean to check if the value has been set.
func (o *DoEmailLookupResponse) GetHasAaaaOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.HasAaaa, true
}

// SetHasAaaa sets field value
func (o *DoEmailLookupResponse) SetHasAaaa(v bool) {
	o.HasAaaa = v
}

func (o DoEmailLookupResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DoEmailLookupResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["address"] = o.Address
	toSerialize["status"] = o.Status
	toSerialize["deliverability"] = o.Deliverability
	toSerialize["reason"] = o.Reason.Get()
	toSerialize["risk"] = o.Risk
	toSerialize["addressType"] = o.AddressType
	toSerialize["isDisposableAddress"] = o.IsDisposableAddress
	toSerialize["suggestion"] = o.Suggestion.Get()
	toSerialize["emailRole"] = o.EmailRole.Get()
	toSerialize["localPart"] = o.LocalPart
	toSerialize["domainPart"] = o.DomainPart
	toSerialize["exchange"] = o.Exchange.Get()
	toSerialize["preference"] = o.Preference.Get()
	toSerialize["isInWhiteList"] = o.IsInWhiteList
	toSerialize["isInBlackList"] = o.IsInBlackList
	toSerialize["hasMx"] = o.HasMx
	toSerialize["hasAa"] = o.HasAa
	toSerialize["hasAaaa"] = o.HasAaaa
	return toSerialize, nil
}

func (o *DoEmailLookupResponse) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"address",
		"status",
		"deliverability",
		"reason",
		"risk",
		"addressType",
		"isDisposableAddress",
		"suggestion",
		"emailRole",
		"localPart",
		"domainPart",
		"exchange",
		"preference",
		"isInWhiteList",
		"isInBlackList",
		"hasMx",
		"hasAa",
		"hasAaaa",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varDoEmailLookupResponse := _DoEmailLookupResponse{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varDoEmailLookupResponse)

	if err != nil {
		return err
	}

	*o = DoEmailLookupResponse(varDoEmailLookupResponse)

	return err
}

type NullableDoEmailLookupResponse struct {
	value *DoEmailLookupResponse
	isSet bool
}

func (v NullableDoEmailLookupResponse) Get() *DoEmailLookupResponse {
	return v.value
}

func (v *NullableDoEmailLookupResponse) Set(val *DoEmailLookupResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableDoEmailLookupResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableDoEmailLookupResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDoEmailLookupResponse(val *DoEmailLookupResponse) *NullableDoEmailLookupResponse {
	return &NullableDoEmailLookupResponse{value: val, isSet: true}
}

func (v NullableDoEmailLookupResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDoEmailLookupResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


