/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the List type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &List{}

// List struct for List
type List struct {
	// List ID.
	Id int32 `json:"id"`
	// List name.
	Name string `json:"name"`
	// Description of the list.
	Description NullableString `json:"description"`
	// Is the List favorited? See [Favorites list](https://docs.textmagic.com/#operation/getFavourites).
	Favorited bool `json:"favorited"`
	// List members count.
	MembersCount int32 `json:"membersCount"`
	User NullableUser `json:"user"`
	// Internal service field.
	Service bool `json:"service"`
	// Is the list **shared** among all sub-accounts?
	Shared NullableBool `json:"shared"`
	Avatar NullableListImage `json:"avatar"`
	// Indicates that List is used as a default. All new contacts added via the Web-app will be added in this List by default.
	IsDefault NullableBool `json:"isDefault"`
}

type _List List

// NewList instantiates a new List object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewList(id int32, name string, description NullableString, favorited bool, membersCount int32, user NullableUser, service bool, shared NullableBool, avatar NullableListImage, isDefault NullableBool) *List {
	this := List{}
	this.Id = id
	this.Name = name
	this.Description = description
	this.Favorited = favorited
	this.MembersCount = membersCount
	this.User = user
	this.Service = service
	this.Shared = shared
	this.Avatar = avatar
	this.IsDefault = isDefault
	return &this
}

// NewListWithDefaults instantiates a new List object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListWithDefaults() *List {
	this := List{}
	return &this
}

// GetId returns the Id field value
func (o *List) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *List) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *List) SetId(v int32) {
	o.Id = v
}

// GetName returns the Name field value
func (o *List) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *List) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *List) SetName(v string) {
	o.Name = v
}

// GetDescription returns the Description field value
// If the value is explicit nil, the zero value for string will be returned
func (o *List) GetDescription() string {
	if o == nil || o.Description.Get() == nil {
		var ret string
		return ret
	}

	return *o.Description.Get()
}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *List) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description.Get(), o.Description.IsSet()
}

// SetDescription sets field value
func (o *List) SetDescription(v string) {
	o.Description.Set(&v)
}

// GetFavorited returns the Favorited field value
func (o *List) GetFavorited() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Favorited
}

// GetFavoritedOk returns a tuple with the Favorited field value
// and a boolean to check if the value has been set.
func (o *List) GetFavoritedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Favorited, true
}

// SetFavorited sets field value
func (o *List) SetFavorited(v bool) {
	o.Favorited = v
}

// GetMembersCount returns the MembersCount field value
func (o *List) GetMembersCount() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.MembersCount
}

// GetMembersCountOk returns a tuple with the MembersCount field value
// and a boolean to check if the value has been set.
func (o *List) GetMembersCountOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.MembersCount, true
}

// SetMembersCount sets field value
func (o *List) SetMembersCount(v int32) {
	o.MembersCount = v
}

// GetUser returns the User field value
// If the value is explicit nil, the zero value for User will be returned
func (o *List) GetUser() User {
	if o == nil || o.User.Get() == nil {
		var ret User
		return ret
	}

	return *o.User.Get()
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *List) GetUserOk() (*User, bool) {
	if o == nil {
		return nil, false
	}
	return o.User.Get(), o.User.IsSet()
}

// SetUser sets field value
func (o *List) SetUser(v User) {
	o.User.Set(&v)
}

// GetService returns the Service field value
func (o *List) GetService() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Service
}

// GetServiceOk returns a tuple with the Service field value
// and a boolean to check if the value has been set.
func (o *List) GetServiceOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Service, true
}

// SetService sets field value
func (o *List) SetService(v bool) {
	o.Service = v
}

// GetShared returns the Shared field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *List) GetShared() bool {
	if o == nil || o.Shared.Get() == nil {
		var ret bool
		return ret
	}

	return *o.Shared.Get()
}

// GetSharedOk returns a tuple with the Shared field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *List) GetSharedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.Shared.Get(), o.Shared.IsSet()
}

// SetShared sets field value
func (o *List) SetShared(v bool) {
	o.Shared.Set(&v)
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for ListImage will be returned
func (o *List) GetAvatar() ListImage {
	if o == nil || o.Avatar.Get() == nil {
		var ret ListImage
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *List) GetAvatarOk() (*ListImage, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *List) SetAvatar(v ListImage) {
	o.Avatar.Set(&v)
}

// GetIsDefault returns the IsDefault field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *List) GetIsDefault() bool {
	if o == nil || o.IsDefault.Get() == nil {
		var ret bool
		return ret
	}

	return *o.IsDefault.Get()
}

// GetIsDefaultOk returns a tuple with the IsDefault field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *List) GetIsDefaultOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.IsDefault.Get(), o.IsDefault.IsSet()
}

// SetIsDefault sets field value
func (o *List) SetIsDefault(v bool) {
	o.IsDefault.Set(&v)
}

func (o List) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o List) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	toSerialize["description"] = o.Description.Get()
	toSerialize["favorited"] = o.Favorited
	toSerialize["membersCount"] = o.MembersCount
	toSerialize["user"] = o.User.Get()
	toSerialize["service"] = o.Service
	toSerialize["shared"] = o.Shared.Get()
	toSerialize["avatar"] = o.Avatar.Get()
	toSerialize["isDefault"] = o.IsDefault.Get()
	return toSerialize, nil
}

func (o *List) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"name",
		"description",
		"favorited",
		"membersCount",
		"user",
		"service",
		"shared",
		"avatar",
		"isDefault",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varList := _List{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varList)

	if err != nil {
		return err
	}

	*o = List(varList)

	return err
}

type NullableList struct {
	value *List
	isSet bool
}

func (v NullableList) Get() *List {
	return v.value
}

func (v *NullableList) Set(val *List) {
	v.value = val
	v.isSet = true
}

func (v NullableList) IsSet() bool {
	return v.isSet
}

func (v *NullableList) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableList(val *List) *NullableList {
	return &NullableList{value: val, isSet: true}
}

func (v NullableList) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableList) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


