/*
 * Decompiled with CFR 0.152.
 */
package ari.ucidy;

import ari.ucidy.UCDParser;
import ari.ucidy.UCDWord;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;

public class UCDWordList
implements Iterable<UCDWord> {
    protected static final Logger LOGGER = Logger.getLogger(UCDWordList.class.getName());
    protected TreeSet<UCDWord> words = new TreeSet<UCDWord>(new UCDWordComparator());
    private final String version;

    public static void main(String[] args) throws Throwable {
        UCDWordList words = new UCDWordList();
        int nbWords = words.addAll(UCDWordList.class.getResourceAsStream("/ari/ucidy/ucd1p-words.txt"), true);
        System.out.println(nbWords + " UCD words successfully read!");
        for (UCDWord w : words) {
            if (w.recommended) continue;
            System.out.println("- \"" + w + "\" NOT RECOMMENDED");
        }
        String search = "META";
        System.out.print("\nEXACT MATCH for \"" + search + "\": ");
        System.out.println(words.get(search));
        System.out.println("\nSTARTING WITH \"" + search + "\":");
        for (UCDWord w : words.startingWith(search)) {
            System.out.println("  - " + w);
        }
        search = "pos.eq.de";
        System.out.println("\nCLOSEST TO \"" + search + "\":");
        for (UCDWord w : words.getClosest(search)) {
            System.out.println("  - " + w);
        }
        search = "elec.optical.u";
        System.out.println("\nCLOSEST TO \"" + search + "\":");
        for (UCDWord w : words.getClosest(search)) {
            System.out.println("  - " + w);
        }
        search = "em.ot.x";
        System.out.println("\nCLOSEST TO \"" + search + "\":");
        for (UCDWord w : words.getClosest(search)) {
            System.out.println("  - " + w);
        }
    }

    public UCDWordList() {
        this(null);
    }

    public UCDWordList(String version) {
        this.version = version == null || version.trim().isEmpty() ? null : version;
    }

    public final String getVersion() {
        return this.version;
    }

    public boolean add(UCDWord newWord) {
        if (newWord == null || !newWord.valid || !newWord.recognised || !newWord.recommended && newWord.namespace != null && newWord.namespace.equalsIgnoreCase("ivoa")) {
            return false;
        }
        boolean added = this.words.add(newWord);
        if (added && !newWord.recommended && newWord.namespace == null) {
            LOGGER.warning("\"" + newWord + "\" is not validated by the IVOA and does not have any namespace (which by default is reserved for validated words). It is strongly encouraged to set one (different from \"ivoa\") before using this item.");
        }
        return added;
    }

    public int addAll(Collection<UCDWord> newWords) {
        if (newWords == null) {
            return 0;
        }
        int nbAdded = 0;
        for (UCDWord w : newWords) {
            if (w == null || !this.add(w)) continue;
            ++nbAdded;
        }
        return nbAdded;
    }

    public int addAll(UCDWord[] newWords) {
        if (newWords == null) {
            return 0;
        }
        int nbAdded = 0;
        for (UCDWord w : newWords) {
            if (w == null || !this.add(w)) continue;
            ++nbAdded;
        }
        return nbAdded;
    }

    public int addAll(File psvFile) throws NullPointerException, IOException {
        return this.addAll(psvFile, false);
    }

    public int addAll(File psvFile, boolean recommended) throws NullPointerException, IOException {
        if (psvFile == null) {
            throw new NullPointerException("Missing file to parse!");
        }
        return this.addAll(new FileReader(psvFile), recommended);
    }

    public int addAll(InputStream stream, boolean recommended) throws NullPointerException, IOException {
        if (stream == null) {
            throw new NullPointerException("Missing input stream to parse!");
        }
        return this.addAll(new InputStreamReader(stream), recommended);
    }

    public int addAll(Reader reader, boolean recommended) throws NullPointerException, IOException {
        return UCDParser.parseWordList(reader, recommended, this);
    }

    @Override
    public Iterator<UCDWord> iterator() {
        return this.words.iterator();
    }

    public int size() {
        return this.words.size();
    }

    public boolean contains(String ucdWord) {
        return ucdWord == null || ucdWord.trim().length() == 0 ? false : this.words.contains(new UCDWord(ucdWord));
    }

    public UCDWord get(String ucdWord) {
        return this.get(ucdWord, false);
    }

    public UCDWord get(String ucdWord, boolean checkNamespace) {
        if (ucdWord == null || ucdWord.trim().length() == 0) {
            return null;
        }
        UCDWord word = new UCDWord(ucdWord);
        SortedSet<UCDWord> result = this.words.subSet(word, new UCDWord(ucdWord + '\u0000'));
        if (result.size() == 0) {
            return null;
        }
        if (!checkNamespace || result.first().equals(word)) {
            return result.first();
        }
        return null;
    }

    public SortedSet<UCDWord> startingWith(String startStr) {
        if (startStr == null || startStr.trim().length() == 0) {
            return new TreeSet<UCDWord>();
        }
        return this.words.subSet(new UCDWord(startStr), new UCDWord(startStr + '\uffff'));
    }

    public UCDWord[] getClosest(String wrongWord) {
        if (wrongWord == null || wrongWord.trim().length() == 0) {
            return new UCDWord[0];
        }
        wrongWord = wrongWord.trim().toLowerCase();
        ArrayList<UCDWord> match = new ArrayList<UCDWord>(10);
        int threshold = Math.round((float)wrongWord.length() / 2.0f);
        int bestDistance = Integer.MAX_VALUE;
        for (UCDWord w : this.words) {
            int dist = UCDWordList.levenshtein(wrongWord, w.word.toLowerCase());
            if (dist == 0) {
                return new UCDWord[]{w};
            }
            if (dist == bestDistance) {
                match.add(w);
                continue;
            }
            if (dist >= bestDistance || dist > threshold) continue;
            match.clear();
            match.add(w);
            bestDistance = dist;
        }
        return match.size() == 0 ? new UCDWord[]{} : match.toArray(new UCDWord[match.size()]);
    }

    public Set<UCDWord> search(String keywords) {
        return new TreeSet<UCDWord>();
    }

    public UCDWord remove(String ucdWord) {
        if (ucdWord == null || ucdWord.trim().length() == 0) {
            return null;
        }
        UCDWord match = this.get(ucdWord);
        if (match != null) {
            return this.words.remove(match) ? match : null;
        }
        return null;
    }

    public void clear() {
        this.words.clear();
    }

    protected static int levenshtein(String left, String right) throws NullPointerException {
        int j;
        int alen = left.length();
        int blen = right.length();
        int[] costs = new int[blen + 1];
        for (j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= alen; ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (j = 1; j <= blen; ++j) {
                int cj = UCDWordList.lev_min(1 + costs[j], 1 + costs[j - 1], left.charAt(i - 1) == right.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[blen];
    }

    protected static int lev_min(int a, int b, int c) {
        return a < b ? (a < c ? a : c) : (b < c ? b : c);
    }

    protected class UCDWordComparator
    implements Comparator<UCDWord> {
        protected UCDWordComparator() {
        }

        @Override
        public int compare(UCDWord o1, UCDWord o2) {
            if (o1 == null || o2 == null) {
                return -1;
            }
            return o1.word.compareToIgnoreCase(o2.word);
        }
    }
}

