/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef AREAUI_H
#define AREAUI_H

#include "languageframe.h"
#include "addlanguagedialog.h"
#include "addinputmethoddialog.h"
#include "libukcc/widgets/Label/titlelabel.h"
#include "addbutton.h"
#include "settinggroup.h"
#include "comboxwidget.h"
#include <QWidget>
#include <QVBoxLayout>

class AreaUi : public QWidget
{
    Q_OBJECT

public:
    enum ComboBoxOrder {
        COUNTRY = 0,
        CALENDAR,
        FIRSTDAY,
        DATEFORMAT,
#ifdef Nile
        SHORTDATEFORMAT,
        LONGDATEFORMAT,
#endif
        TIMEFORMAT
    };
    AreaUi(QWidget* parent = nullptr, Qt::WindowFlags f = Qt::WindowFlags());
    virtual ~AreaUi();
    void initUi();
    void initLanguageFormat();
    void initSystemLanguage();
    void settingForIntel();

public:
    inline QComboBox *countryComboBox()
    {
        if (countryWidget) {
            return countryWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline QComboBox *calendarComboBox()
    {
        if (calendarWidget) {
            return calendarWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline QComboBox *firstDayComboBox()
    {
        if (dayWidget) {
            return dayWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline QComboBox *dateComboBox()
    {
        if (shortDateWidget) {
            return shortDateWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline QComboBox *shortDateComboBox()
    {
        if (shortDateWidget) {
            return shortDateWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline QComboBox *longDateComboBox()
    {
        if (longDateWidget) {
            return longDateWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline QComboBox *timeComboBox()
    {
        if (timeWidget) {
            return timeWidget->comboBox();
        } else {
            return nullptr;
        }
    }

    inline AddButton *addbutton()
    {
        return addLanguageBtn;
    }

    inline AddLanguageDialog *languageDialog()
    {
        return addLanguageDialog;
    }

    inline AddInputMethodDialog *inputMethodDialog()
    {
        return addInputMehtodDialog;
    }

    void addShowLanguage(QString languageCode, QString languageName, bool selected = false);
    void clearShowLanguage();
    void reloadLanguageFrameIcon();

Q_SIGNALS:
    void languageChanged(QString languageCode);
    void showLanguageListRemoved(QString languageCode);

private:
    QVBoxLayout *uiLayout       = nullptr;
    QVBoxLayout *formatLayout   = nullptr;
    QVBoxLayout *LanguageLayout = nullptr;

private:
    TitleLabel   *formatTitleLabel = nullptr;
    SettingGroup *formatGroup      = nullptr;
    ComboxWidget *countryWidget    = nullptr;
    ComboxWidget *calendarWidget   = nullptr;
    ComboxWidget *dayWidget        = nullptr;
    ComboxWidget *shortDateWidget  = nullptr;
    ComboxWidget *longDateWidget   = nullptr;
    ComboxWidget *timeWidget       = nullptr;

private:
    TitleLabel           *languageTitleLable   = nullptr;
    AddButton            *addLanguageBtn       = nullptr;
    SettingGroup         *languageGroup        = nullptr;
    AddLanguageDialog    *addLanguageDialog    = nullptr;
    AddInputMethodDialog *addInputMehtodDialog = nullptr;

private:
    QList<LanguageFrame*> languageFrameList = {};
};

#endif // AREAUI_H
