/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.ccil.cowan.tagsoup.AutoDetector;
import org.ccil.cowan.tagsoup.Element;
import org.ccil.cowan.tagsoup.ElementType;
import org.ccil.cowan.tagsoup.HTMLScanner;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.ScanHandler;
import org.ccil.cowan.tagsoup.Scanner;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler
implements ScanHandler,
XMLReader,
LexicalHandler {
    private ContentHandler theContentHandler;
    private LexicalHandler theLexicalHandler;
    private DTDHandler theDTDHandler;
    private ErrorHandler theErrorHandler;
    private EntityResolver theEntityResolver;
    private Schema theSchema;
    private Scanner theScanner;
    private AutoDetector theAutoDetector;
    public static final String namespacesFeature = "http://xml.org/sax/features/namespaces";
    public static final String namespacePrefixesFeature = "http://xml.org/sax/features/namespace-prefixes";
    public static final String externalGeneralEntitiesFeature = "http://xml.org/sax/features/external-general-entities";
    public static final String externalParameterEntitiesFeature = "http://xml.org/sax/features/external-parameter-entities";
    public static final String ignoreBogonsFeature = "http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons";
    public static final String bogonsEmptyFeature = "http://www.ccil.org/~cowan/tagsoup/features/bogons-empty";
    public static final String lexicalHandlerProperty = "http://xml.org/sax/properties/lexical-handler";
    public static final String scannerProperty = "http://www.ccil.org/~cowan/tagsoup/properties/scanner";
    public static final String schemaProperty = "http://www.ccil.org/~cowan/tagsoup/properties/schema";
    public static final String autoDetectorProperty = "http://www.ccil.org/~cowan/tagsoup/properties/auto-detector";
    private HashMap theFeatures;
    private Element theNewElement;
    private String theAttributeName;
    private String thePITarget;
    private Element theStack;
    private Element theSaved;
    private Element thePCDATA;
    private char theEntity;
    private static char[] etagchars;
    private boolean virginStack;

    private /* synthetic */ void instinit$(Parser parser) {
        this.theFeatures.put(externalGeneralEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put(externalParameterEntitiesFeature, Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/is-standalone", Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/lexical-handler/parameter-entities", Boolean.FALSE);
        this.theFeatures.put(namespacesFeature, Boolean.TRUE);
        this.theFeatures.put(namespacePrefixesFeature, Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/resolve-dtd-uris", Boolean.TRUE);
        this.theFeatures.put("http://xml.org/sax/features/string-interning", Boolean.TRUE);
        this.theFeatures.put("http://xml.org/sax/features/use-attributes2", Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/use-locator2", Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/use-entity-resolver2", Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/validation", Boolean.FALSE);
        this.theFeatures.put("http://xml.org/sax/features/xmlns-uris", Boolean.FALSE);
        this.theFeatures.put(ignoreBogonsFeature, Boolean.FALSE);
        this.theFeatures.put(bogonsEmptyFeature, Boolean.TRUE);
    }

    private /* synthetic */ void finit$() {
        this.theContentHandler = this;
        this.theLexicalHandler = this;
        this.theDTDHandler = this;
        this.theErrorHandler = this;
        this.theEntityResolver = this;
        this.theFeatures = new HashMap();
        this.theNewElement = null;
        this.theAttributeName = null;
        this.thePITarget = null;
        this.theStack = null;
        this.theSaved = null;
        this.thePCDATA = null;
        this.theEntity = '\u0000';
        this.virginStack = true;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = (Boolean)this.theFeatures.get(string);
        if (bl == null) {
            throw new SAXNotRecognizedException("Unknown feature " + string);
        }
        return bl;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (bl) {
            this.theFeatures.put(string, Boolean.TRUE);
        } else {
            this.theFeatures.put(string, Boolean.FALSE);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(lexicalHandlerProperty)) {
            if (this.theLexicalHandler != this) {
                return this.theLexicalHandler;
            }
            return null;
        }
        if (string.equals(scannerProperty)) {
            return this.theScanner;
        }
        if (string.equals(schemaProperty)) {
            return this.theSchema;
        }
        if (string.equals(autoDetectorProperty)) {
            return this.theAutoDetector;
        }
        throw new SAXNotRecognizedException("Unknown property " + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(lexicalHandlerProperty)) {
            if (!(object instanceof LexicalHandler)) throw new SAXNotSupportedException("Your lexical handler is not a LexicalHandler");
            this.theLexicalHandler = (LexicalHandler)object;
            return;
        } else if (string.equals(scannerProperty)) {
            if (!(object instanceof Scanner)) throw new SAXNotSupportedException("Your scanner is not a Scanner");
            this.theScanner = (Scanner)object;
            return;
        } else if (string.equals(schemaProperty)) {
            if (!(object instanceof Schema)) throw new SAXNotSupportedException("Your schema is not a Schema");
            this.theSchema = (Schema)object;
            return;
        } else {
            if (!string.equals(autoDetectorProperty)) throw new SAXNotRecognizedException("Unknown property " + string);
            if (!(object instanceof AutoDetector)) throw new SAXNotSupportedException("Your auto-detector is not an AutoDetector");
            this.theAutoDetector = (AutoDetector)object;
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.theEntityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        if (this.theEntityResolver == this) {
            return null;
        }
        return this.theEntityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.theDTDHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        if (this.theDTDHandler == this) {
            return null;
        }
        return this.theDTDHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.theContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        if (this.theContentHandler == this) {
            return null;
        }
        return this.theContentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.theErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        if (this.theErrorHandler == this) {
            return null;
        }
        return this.theErrorHandler;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        this.setup();
        if (reader == null) {
            reader = this.getReader(inputSource.getByteStream(), inputSource.getEncoding(), inputSource.getPublicId(), inputSource.getSystemId());
        }
        this.theContentHandler.startDocument();
        if (!this.theSchema.getURI().equals("")) {
            this.theContentHandler.startPrefixMapping(this.theSchema.getPrefix(), this.theSchema.getURI());
        }
        this.theScanner.scan(reader, this);
    }

    public void parse(String string) throws IOException, SAXException {
        this.setup();
        Reader reader = this.getReader(null, null, null, string);
        this.theContentHandler.startDocument();
        this.theScanner.scan(reader, this);
    }

    private void setup() {
        if (this.theSchema == null) {
            this.theSchema = HTMLSchema.sharedSchema();
        }
        if (this.theScanner == null) {
            this.theScanner = new HTMLScanner();
        }
        if (this.theAutoDetector == null) {
            this.theAutoDetector = new AutoDetector(this){
                private /* synthetic */ Parser this$0;
                {
                    this.this$0 = parser;
                }

                public Reader autoDetectingReader(InputStream inputStream) {
                    return new InputStreamReader(inputStream);
                }
            };
        }
        this.theStack = new Element(this.theSchema.getElementType("<root>"));
        this.thePCDATA = new Element(this.theSchema.getElementType("<pcdata>"));
        this.theNewElement = null;
        this.theAttributeName = null;
        this.thePITarget = null;
        this.theSaved = null;
        this.theEntity = '\u0000';
        this.virginStack = true;
    }

    private Reader getReader(InputStream inputStream, String string, String string2, String string3) throws IOException, SAXException {
        if (inputStream == null) {
            inputStream = this.getInputStream(string2, string3);
        }
        if (string == null) {
            return this.theAutoDetector.autoDetectingReader(inputStream);
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            return inputStreamReader;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new InputStreamReader(inputStream);
        }
    }

    private InputStream getInputStream(String string, String string2) throws IOException, SAXException {
        URL uRL = new URL("file", "", System.getProperty("user.dir") + "/.");
        URL uRL2 = new URL(uRL, string2);
        URLConnection uRLConnection = uRL2.openConnection();
        return uRLConnection.getInputStream();
    }

    public void adup(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement == null || this.theAttributeName == null) {
            return;
        }
        this.theNewElement.setAttribute(this.theAttributeName, null, this.theAttributeName);
        this.theAttributeName = null;
    }

    public void aname(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.theAttributeName = this.makeName(cArray, n, n2);
    }

    public void aval(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement == null || this.theAttributeName == null) {
            return;
        }
        String string = new String(cArray, n, n2);
        this.theNewElement.setAttribute(this.theAttributeName, null, string);
        this.theAttributeName = null;
    }

    public void entity(char[] cArray, int n, int n2) throws SAXException {
        if (n2 < 1) {
            this.theEntity = '\u0000';
            return;
        }
        String string = new String(cArray, n, n2);
        this.theEntity = this.theSchema.getEntity(string);
    }

    public void eof(char[] cArray, int n, int n2) throws SAXException {
        if (this.virginStack) {
            this.rectify(this.thePCDATA);
        }
        while (this.theStack.next() != null) {
            this.pop();
        }
        if (!this.theSchema.getURI().equals("")) {
            this.theContentHandler.endPrefixMapping(this.theSchema.getPrefix());
        }
        this.theContentHandler.endDocument();
    }

    public void etag(char[] cArray, int n, int n2) throws SAXException {
        Element element;
        int n3;
        String string = this.theStack.name();
        if ((this.theStack.flags() & 2) != 0 && n2 == string.length()) {
            boolean bl = false;
            for (n3 = 0; n3 < n2; ++n3) {
                if (cArray[n + n3] == string.charAt(n3)) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.theContentHandler.characters(etagchars, 0, 2);
                this.theContentHandler.characters(cArray, n, n2);
                this.theContentHandler.characters(etagchars, 2, 1);
                this.theScanner.startCDATA();
                return;
            }
        }
        this.theNewElement = null;
        String string2 = this.makeName(cArray, n, n2);
        if (string2 == null || string2.equals("")) {
            string2 = string;
        }
        n3 = 0;
        for (element = this.theStack; element != null && !element.name().equals(string2); element = element.next()) {
            if ((element.flags() & 4) == 0) continue;
            n3 = 1;
        }
        if (element == null) {
            return;
        }
        if (element.next() == null || element.next().next() == null) {
            return;
        }
        if (n3 != 0) {
            element.preclose();
        } else {
            while (this.theStack != element) {
                this.restartablyPop();
            }
            this.pop();
        }
        while (this.theStack.isPreclosed()) {
            this.pop();
        }
        this.restart();
    }

    private void restart() throws SAXException {
        while (this.theSaved != null && this.theStack.canContain(this.theSaved)) {
            Element element = this.theSaved.next();
            this.push(this.theSaved);
            this.theSaved = element;
        }
    }

    private void pop() throws SAXException {
        if (this.theStack == null) {
            return;
        }
        String string = this.theStack.name();
        if ((this.theStack.flags() & 2) != 0) {
            this.theLexicalHandler.endCDATA();
        }
        String string2 = this.theStack.namespace();
        if (this.theFeatures.get(namespacesFeature) == Boolean.FALSE) {
            string2 = "";
        }
        this.theContentHandler.endElement(string2, this.theStack.localName(), string);
        this.theStack = this.theStack.next();
    }

    private void restartablyPop() throws SAXException {
        Element element = this.theStack;
        this.pop();
        if ((element.flags() & 1) != 0) {
            element.anonymize();
            element.setNext(this.theSaved);
            this.theSaved = element;
        }
    }

    private void push(Element element) throws SAXException {
        element.clean();
        String string = element.namespace();
        if (this.theFeatures.get(namespacesFeature) == Boolean.FALSE) {
            string = "";
        }
        this.theContentHandler.startElement(string, element.localName(), element.name(), element.atts());
        element.setNext(this.theStack);
        this.theStack = element;
        this.virginStack = false;
        if ((this.theStack.flags() & 2) != 0) {
            this.theScanner.startCDATA();
            this.theLexicalHandler.startCDATA();
        }
    }

    public void gi(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement != null) {
            return;
        }
        String string = this.makeName(cArray, n, n2);
        if (string == null) {
            return;
        }
        ElementType elementType = this.theSchema.getElementType(string);
        if (elementType == null) {
            if (this.theFeatures.get(ignoreBogonsFeature) == Boolean.TRUE) {
                return;
            }
            boolean bl = this.theFeatures.get(bogonsEmptyFeature) == Boolean.TRUE;
            this.theSchema.elementType(string, bl ? 0 : -1, -1, 0);
            elementType = this.theSchema.getElementType(string);
        }
        if (this.theStack.name().equals("<root>") && elementType.parent() == null) {
            return;
        }
        this.theNewElement = new Element(elementType);
    }

    public void pcdata(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (Character.isWhitespace(cArray[n + i])) continue;
            bl = false;
        }
        if (bl && !this.theStack.canContain(this.thePCDATA)) {
            return;
        }
        this.rectify(this.thePCDATA);
        this.theContentHandler.characters(cArray, n, n2);
    }

    public void pitarget(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement != null) {
            return;
        }
        this.thePITarget = this.makeName(cArray, n, n2);
    }

    public void pi(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement != null || this.thePITarget == null) {
            return;
        }
        if (this.thePITarget.toLowerCase().equals("xml")) {
            return;
        }
        this.theContentHandler.processingInstruction(this.thePITarget, new String(cArray, n, n2));
        this.thePITarget = null;
    }

    public void stagc(char[] cArray, int n, int n2) throws SAXException {
        if (this.theNewElement == null) {
            return;
        }
        this.rectify(this.theNewElement);
    }

    public void cmnt(char[] cArray, int n, int n2) throws SAXException {
        this.theLexicalHandler.comment(cArray, n, n2);
    }

    private void rectify(Element object) throws SAXException {
        Object object2;
        Element element;
        while (true) {
            for (element = this.theStack; element != null && !element.canContain((Element)object); element = element.next()) {
            }
            if (element != null || (object2 = ((Element)object).parent()) == null) break;
            Element element2 = new Element((ElementType)object2);
            element2.setNext((Element)object);
            object = element2;
        }
        if (element == null) {
            return;
        }
        while (this.theStack != element && this.theStack != null && this.theStack.next() != null && this.theStack.next().next() != null) {
            this.restartablyPop();
        }
        while (object != null) {
            object2 = ((Element)object).next();
            if (!((Element)object).name().equals("<pcdata>")) {
                this.push((Element)object);
            }
            object = object2;
            this.restart();
        }
        this.theNewElement = null;
    }

    public char getEntity() {
        return this.theEntity;
    }

    private String makeName(char[] cArray, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(n2 + 2);
        boolean bl = false;
        boolean bl2 = true;
        while (n2-- > 0) {
            n3 = Character.toLowerCase(cArray[n]);
            if (Character.isLetter((char)n3) || n3 == 95) {
                bl2 = false;
                stringBuffer.append((char)n3);
            } else if (Character.isDigit((char)n3) || n3 == 45 || n3 == 46) {
                if (bl2) {
                    stringBuffer.append('_');
                }
                bl2 = false;
                stringBuffer.append((char)n3);
            } else if (n3 == 58 && !bl) {
                bl = true;
                if (bl2) {
                    stringBuffer.append('_');
                }
                bl2 = true;
                stringBuffer.append((char)n3);
            }
            ++n;
        }
        n3 = stringBuffer.length();
        if (n3 == 0 || stringBuffer.charAt(n3 - '\u0001') == ':') {
            stringBuffer.append('_');
        }
        return stringBuffer.toString().intern();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public Parser() {
        this.finit$();
        this.instinit$(this);
    }

    static {
        namespacesFeature = namespacesFeature;
        namespacePrefixesFeature = namespacePrefixesFeature;
        externalGeneralEntitiesFeature = externalGeneralEntitiesFeature;
        externalParameterEntitiesFeature = externalParameterEntitiesFeature;
        ignoreBogonsFeature = ignoreBogonsFeature;
        bogonsEmptyFeature = bogonsEmptyFeature;
        lexicalHandlerProperty = lexicalHandlerProperty;
        scannerProperty = scannerProperty;
        schemaProperty = schemaProperty;
        autoDetectorProperty = autoDetectorProperty;
        etagchars = new char[]{'<', '/', '>'};
    }
}

